'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _class; /* Copyright © 2016 Kuali, Inc. - All Rights Reserved
             * You may use and modify this code under the terms of the Kuali, Inc.
             * Pre-Release License Agreement. You may not distribute it.
             *
             * You should have received a copy of the Kuali, Inc. Pre-Release License
             * Agreement with this file. If not, please write to license@kuali.co.
             */

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _coreDecorators = require('core-decorators');

var _v = require('uuid/v4');

var _v2 = _interopRequireDefault(_v);

var _ = require('..');

var _papers = require('../papers');

var _papers2 = _interopRequireDefault(_papers);

var _constants = require('./constants');

var _columnSelector = require('./components/column-selector');

var _columnSelector2 = _interopRequireDefault(_columnSelector);

var _content = require('./components/content');

var _content2 = _interopRequireDefault(_content);

var _heading = require('./components/heading');

var _heading2 = _interopRequireDefault(_heading);

var _rules = require('./components/rules');

var _rules2 = _interopRequireDefault(_rules);

var _rule = require('./components/rule');

var _rule2 = _interopRequireDefault(_rule);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var noop = function noop() {}; // eslint-disable-line no-empty-function

function ruleIsValid(field, operator, value) {
  return field && operator && (value !== undefined || operator === _constants.OPERATOR_TYPES.BLANK || operator === _constants.OPERATOR_TYPES.NOT_BLANK);
}

var FilterEditor = (0, _coreDecorators.autobind)(_class = function (_Component) {
  _inherits(FilterEditor, _Component);

  function FilterEditor() {
    var _ref;

    var _temp, _this, _ret;

    _classCallCheck(this, FilterEditor);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = FilterEditor.__proto__ || Object.getPrototypeOf(FilterEditor)).call.apply(_ref, [this].concat(args))), _this), _this.state = {
      incompleteRules: []
    }, _this.operationChanged = function (operation) {
      var rules = _this.props.filter.rules;

      _this.props.onFilterChanged(Object.assign({}, _this.props.filter, {
        operation: operation,
        fn: _this.getFilterForRules(rules, operation)
      }));
    }, _this.getFilterForRules = function () {
      var rules = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
      var operation = arguments[1];

      operation = operation || _this.props.filter.operation;
      return function (row) {
        if (!rules.length) return true;
        return operation === _constants.OPERATION_TYPES.AND ? rules.every(function (_ref2) {
          var matchFunction = _ref2.matchFunction;
          return matchFunction(row);
        }) : rules.some(function (_ref3) {
          var matchFunction = _ref3.matchFunction;
          return matchFunction(row);
        });
      };
    }, _temp), _possibleConstructorReturn(_this, _ret);
  }

  _createClass(FilterEditor, [{
    key: 'handleColumnSelectionChanged',
    value: function handleColumnSelectionChanged(newFilter) {
      this.props.onFilterChanged(newFilter);
    }
  }, {
    key: 'addRule',
    value: function addRule() {
      this.setState({
        incompleteRules: [].concat(_toConsumableArray(this.state.incompleteRules), [{ id: (0, _v2.default)() }])
      });
    }
  }, {
    key: 'clearAllRules',
    value: function clearAllRules() {
      this.setState({ incompleteRules: [] });
      this.props.onFilterChanged(Object.assign({}, this.props.filter, {
        rules: [],
        fn: this.getFilterForRules([])
      }));
    }
  }, {
    key: 'ruleChanged',
    value: function ruleChanged(_ref4) {
      var id = _ref4.id,
          field = _ref4.field,
          operator = _ref4.operator,
          value = _ref4.value,
          matchFunction = _ref4.matchFunction;
      var state = this.state,
          props = this.props;

      var valid = ruleIsValid(field, operator, value);

      var rules = [].concat(_toConsumableArray(props.filter.rules));
      var existingValidRule = rules.find(function (rule) {
        return rule.id === id;
      });
      if (existingValidRule) {
        Object.assign(existingValidRule, {
          field: field.name,
          matchFunction: matchFunction,
          operator: operator,
          type: field.type,
          value: value
        });
        if (!valid) {
          rules = rules.filter(function (rule) {
            return rule.id !== id;
          });

          this.setState({
            incompleteRules: [].concat(_toConsumableArray(state.incompleteRules), [existingValidRule])
          });
        }
      } else {
        if (!valid) {
          var incompleteRule = state.incompleteRules.find(function (rule) {
            return rule.id === id;
          });
          Object.assign(incompleteRule, {
            field: field.name,
            type: field.type,
            operator: operator,
            value: value
          });
          this.setState({ incompleteRules: state.incompleteRules });
          return;
        }

        this.setState({
          incompleteRules: state.incompleteRules.filter(function (rule) {
            return rule.id !== id;
          })
        });
        rules.push({
          field: field.name,
          matchFunction: matchFunction,
          id: id,
          operator: operator,
          type: field.type,
          value: value
        });
      }

      var newFilter = Object.assign({}, props.filter, {
        rules: rules,
        fn: this.getFilterForRules(rules)
      });
      props.onFilterChanged(newFilter);
    }
  }, {
    key: 'ruleRemoved',
    value: function ruleRemoved(ruleId) {
      var rules = this.props.filter.rules.filter(function (rule) {
        return rule.id !== ruleId;
      });
      this.props.onFilterChanged(Object.assign({}, this.props.filter, {
        rules: rules,
        fn: this.getFilterForRules(rules)
      }));

      this.setState({
        incompleteRules: this.state.incompleteRules.filter(function (rule) {
          return rule.id !== ruleId;
        })
      });
    }
  }, {
    key: 'filterNameChanged',
    value: function filterNameChanged(name) {
      this.props.onFilterChanged(Object.assign({}, this.props.filter, { name: name }));
    }
  }, {
    key: 'render',
    value: function render() {
      var _this2 = this;

      var incompleteRules = this.state.incompleteRules;
      var _props = this.props,
          actions = _props.actions,
          availableColumns = _props.columns,
          fields = _props.fields,
          filter = _props.filter,
          className = _props.className,
          footer = _props.footer,
          title = _props.title;


      var rulesToRender = [];

      if (filter.rules) {
        rulesToRender = rulesToRender.concat(filter.rules);
      }

      if (incompleteRules) {
        rulesToRender = rulesToRender.concat(incompleteRules);
      }

      var rules = rulesToRender.map(function (rule, index) {
        return _react2.default.createElement(_rule2.default, {
          availableFields: fields,
          key: rule.id,
          id: rule.id,
          onOperationChanged: _this2.operationChanged,
          onRemove: _this2.ruleRemoved,
          onRuleChanged: _this2.ruleChanged,
          operationType: filter.operation,
          rowIndex: index,
          selectedField: fields.find(function (f) {
            return f.name === rule.field;
          }),
          selectedOperator: rule.operator,
          value: rule.value
        });
      });

      return _react2.default.createElement(
        _papers2.default,
        { className: (0, _classnames2.default)('filter-editor', className) },
        _react2.default.createElement(
          _content2.default,
          null,
          _react2.default.createElement(
            'div',
            { className: 'filter-editor__header' },
            _react2.default.createElement(
              _heading2.default,
              { className: 'filter-editor__title' },
              title
            ),
            rulesToRender.length > 0 ? _react2.default.createElement(
              _.FlatButton,
              {
                label: 'Clear All Rules',
                onClick: this.clearAllRules,
                size: 'small'
              },
              'delete'
            ) : null
          ),
          _react2.default.createElement(
            _rules2.default,
            null,
            rules
          ),
          _react2.default.createElement(
            'div',
            { className: 'filter-editor__actions' },
            _react2.default.createElement(
              _.RaisedButton,
              { label: 'Add Rule', onClick: this.addRule },
              _react2.default.createElement(_.Icon, { name: 'add_circle', variant: 'success' })
            ),
            actions
          )
        ),
        availableColumns.length > 0 ? _react2.default.createElement(
          _content2.default,
          null,
          _react2.default.createElement(_columnSelector2.default, {
            columns: availableColumns,
            filter: filter,
            onChange: this.handleColumnSelectionChanged
          })
        ) : null,
        footer,
        _react2.default.createElement(
          _.IconButton,
          {
            className: 'filter-editor__close',
            onClick: this.props.onClose,
            variant: 'plain'
          },
          _react2.default.createElement(_.Icon, { name: 'clear' })
        )
      );
    }
  }]);

  return FilterEditor;
}(_react.Component)) || _class;

FilterEditor.defaultProps = {
  columns: [],
  filter: {
    columns: [],
    name: '',
    operation: _constants.OPERATION_TYPES.AND,
    rules: []
  },
  onClose: noop,
  title: 'Filter Rules'
};
FilterEditor.propTypes = {
  actions: _propTypes2.default.node,
  columns: _propTypes2.default.array,
  className: _propTypes2.default.string,
  fields: _propTypes2.default.arrayOf(_propTypes2.default.shape({
    label: _propTypes2.default.string.isRequired,
    type: _propTypes2.default.oneOf([_constants.FIELD_TYPES.DATE, _constants.FIELD_TYPES.ENUM, _constants.FIELD_TYPES.NUMBER, _constants.FIELD_TYPES.TEXT, _constants.FIELD_TYPES.TIME]).isRequired,
    name: _propTypes2.default.oneOfType([_propTypes2.default.string, _propTypes2.default.func]),
    values: _propTypes2.default.arrayOf(_propTypes2.default.shape({
      value: _propTypes2.default.oneOfType([_propTypes2.default.number, _propTypes2.default.string]).isRequired,
      label: _propTypes2.default.string.isRequired
    }))
  })).isRequired,
  filter: _propTypes2.default.shape({
    columns: _propTypes2.default.arrayOf(_propTypes2.default.string),
    operation: _propTypes2.default.oneOf([_constants.OPERATION_TYPES.AND, _constants.OPERATION_TYPES.OR]),
    name: _propTypes2.default.string.isRequired,
    rules: _propTypes2.default.arrayOf(_propTypes2.default.shape({
      id: _propTypes2.default.oneOfType([_propTypes2.default.string, _propTypes2.default.number]).isRequired,
      field: _propTypes2.default.oneOfType([_propTypes2.default.string, _propTypes2.default.func]),
      operator: _propTypes2.default.string,
      value: _propTypes2.default.any,
      type: _propTypes2.default.oneOf([_constants.FIELD_TYPES.DATE, _constants.FIELD_TYPES.ENUM, _constants.FIELD_TYPES.NUMBER, _constants.FIELD_TYPES.TEXT, _constants.FIELD_TYPES.TIME])
    }))
  }),
  footer: _propTypes2.default.node,
  onClose: _propTypes2.default.func,
  onFilterChanged: _propTypes2.default.func.isRequired,
  title: _propTypes2.default.oneOfType([_propTypes2.default.string, _propTypes2.default.node])
};
exports.default = FilterEditor;