'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _class; /* Copyright © 2016 Kuali, Inc. - All Rights Reserved
             * You may use and modify this code under the terms of the Kuali, Inc.
             * Pre-Release License Agreement. You may not distribute it.
             *
             * You should have received a copy of the Kuali, Inc. Pre-Release License
             * Agreement with this file. If not, please write to license@kuali.co.
             */

/* eslint-disable jsx-a11y/click-events-have-key-events */
/* eslint-disable jsx-a11y/no-static-element-interactions */
/* eslint-disable jsx-a11y/onclick-has-role */

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _reactDom = require('react-dom');

var _coreDecorators = require('core-decorators');

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _ = require('..');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var FieldCell = (0, _coreDecorators.autobind)(_class = function (_Component) {
  _inherits(FieldCell, _Component);

  function FieldCell() {
    var _ref;

    var _temp, _this, _ret;

    _classCallCheck(this, FieldCell);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = FieldCell.__proto__ || Object.getPrototypeOf(FieldCell)).call.apply(_ref, [this].concat(args))), _this), _this.state = { flexBasis: null }, _temp), _possibleConstructorReturn(_this, _ret);
  }

  _createClass(FieldCell, [{
    key: 'componentDidMount',
    value: function componentDidMount() {
      var widthOptions = [25, 33, 50, 66, 100];
      var el = (0, _reactDom.findDOMNode)(this.cell);

      var elWidth = el.offsetWidth;
      var parentWidth = el.parentNode.offsetWidth;


      var widthPercentage = Math.floor(elWidth / parentWidth * 100);

      var basis = widthOptions.sort(function (a, b) {
        return Math.abs(widthPercentage - a) - Math.abs(widthPercentage - b);
      })[0];

      this.setState({ flexBasis: basis + '%' });
    }
  }, {
    key: 'handleClick',
    value: function handleClick(evt) {
      var _props;

      var target = evt.target;


      var targetIsCell = target === this.cell;

      if (targetIsCell && this._label && this._label.props.htmlFor) {
        var el = (0, _reactDom.findDOMNode)(this._label);
        if (el) el.click();
      }

      if (this.props.onClick) (_props = this.props).onClick.apply(_props, arguments);
    }
  }, {
    key: 'render',
    value: function render() {
      var _this2 = this;

      var _props2 = this.props,
          className = _props2.className,
          disabled = _props2.disabled,
          style = _props2.style,
          rest = _objectWithoutProperties(_props2, ['className', 'disabled', 'style']);

      delete rest.children;
      delete rest.onClick;

      var classes = (0, _classnames2.default)('kuali-form__cell', { 'kuali-form__cell--disabled': disabled }, className);
      var allStyle = _extends({}, style, { flexBasis: this.state.flexBasis });

      return _react2.default.createElement(
        'div',
        _extends({
          className: classes,
          onClick: this.handleClick,
          style: allStyle
        }, rest, {
          ref: function ref(_ref2) {
            _this2.cell = _ref2;
          }
        }),
        this.children
      );
    }
  }, {
    key: 'children',
    get: function get() {
      var _this3 = this;

      return _react.Children.map(this.props.children, function (child) {
        return (0, _react.cloneElement)(child, {
          ref: function ref(node) {
            if (child.type === _.Label) _this3._label = node;
            if (typeof child.ref === 'function') child.ref(node);
          }
        });
      });
    }
  }]);

  return FieldCell;
}(_react.Component)) || _class;

FieldCell.defaultProps = {
  disabled: false
};
FieldCell.propTypes = {
  children: _propTypes2.default.node.isRequired,
  className: _propTypes2.default.string,
  disabled: _propTypes2.default.bool,
  onClick: _propTypes2.default.func,
  style: _propTypes2.default.object
};
exports.default = FieldCell;