'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _class; /* Copyright © 2016 Kuali, Inc. - All Rights Reserved
             * You may use and modify this code under the terms of the Kuali, Inc.
             * Pre-Release License Agreement. You may not distribute it.
             *
             * You should have received a copy of the Kuali, Inc. Pre-Release License
             * Agreement with this file. If not, please write to license@kuali.co.
             */

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _coreDecorators = require('core-decorators');

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _reactMd = require('react-md');

var _menus = require('../menus');

var _lists = require('../lists');

var _brand = require('../brand');

var _userDetails = require('./components/user-details');

var _userDetails2 = _interopRequireDefault(_userDetails);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var Header = (0, _coreDecorators.autobind)(_class = function (_Component) {
  _inherits(Header, _Component);

  function Header() {
    var _ref;

    var _temp, _this, _ret;

    _classCallCheck(this, Header);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = Header.__proto__ || Object.getPrototypeOf(Header)).call.apply(_ref, [this].concat(args))), _this), _this.state = {
      menuIsOpen: false
    }, _temp), _possibleConstructorReturn(_this, _ret);
  }

  _createClass(Header, [{
    key: 'handleLogoClick',
    value: function handleLogoClick(evt) {
      this.props.onBrandSelected(evt);
    }
  }, {
    key: 'handleLogoKeyPress',
    value: function handleLogoKeyPress(evt) {
      if (evt.key === 'Enter') this.props.onBrandSelected(evt);
    }
  }, {
    key: 'handleMenuKeyPress',
    value: function handleMenuKeyPress(evt) {
      if (evt.key === 'Enter') this.handleMenuToggled(evt);
    }
  }, {
    key: 'handleMenuClose',
    value: function handleMenuClose(evt) {
      this.setState({ menuIsOpen: false });
    }
  }, {
    key: 'handleMenuToggled',
    value: function handleMenuToggled(evt) {
      this.setState({ menuIsOpen: !this.state.menuIsOpen });
    }
  }, {
    key: 'render',
    value: function render() {
      var _props = this.props,
          className = _props.className,
          menuItems = _props.menuItems,
          module = _props.module,
          user = _props.user;
      var menuIsOpen = this.state.menuIsOpen;


      return _react2.default.createElement(
        'header',
        { className: (0, _classnames2.default)('layout__header', className) },
        _react2.default.createElement(
          'span',
          { className: 'header__title' },
          module.name
        ),
        _react2.default.createElement(
          'span',
          {
            className: 'header__brand-logo-container',
            onClick: this.handleLogoClick,
            onKeyPress: this.handleLogoKeyPress,
            role: 'link',
            tabIndex: 0
          },
          _react2.default.createElement(_brand.BrandLogo, { className: 'header__brand-logo' })
        ),
        user && _react2.default.createElement('div', { className: 'header__brand-divider' }),
        _react2.default.createElement(
          _menus.Menu,
          {
            id: 'header-menu',
            className: 'header__menu-container',
            sameWidth: false,
            visible: menuIsOpen,
            position: _menus.Menu.Positions.TOP_RIGHT,
            toggle: _react2.default.createElement(
              _reactMd.AccessibleFakeButton,
              { className: 'header__menu-button' },
              user && _react2.default.createElement(_userDetails2.default, { user: user })
            ),
            onClick: this.handleMenuToggled,
            onKeyPress: this.handleMenuKeyPress,
            onClose: this.handleMenuClose,
            listStyle: { top: '100%', right: 10 }
          },
          menuItems.map(function (attrs, idx) {
            return _react2.default.createElement(_lists.ListItem, _extends({ key: idx }, attrs));
          })
        )
      );
    }
  }]);

  return Header;
}(_react.Component)) || _class;

Header.defaultProps = {
  menuItems: []
};
Header.propTypes = {
  className: _propTypes2.default.string,
  menuItems: _propTypes2.default.arrayOf(_propTypes2.default.shape({
    primaryText: _propTypes2.default.string.isRequired,
    onClick: _propTypes2.default.func.isRequired
  })),
  module: _propTypes2.default.shape({
    name: _propTypes2.default.string.isRequired
  }).isRequired,
  onBrandSelected: _propTypes2.default.func.isRequired,
  user: _propTypes2.default.object
};
exports.default = Header;