"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = enforceAllowedIcons;
/* Copyright © 2016 Kuali, Inc. - All Rights Reserved
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 *
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 */

function enforceAllowedIcons(propType) {
  var _this = this;

  var allowed = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];

  var warned = false;

  return function () {
    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    var props = args[0],
        propName = args[1];

    var iconName = props[propName];

    if (iconName && !warned && !allowed.includes(iconName)) {
      warned = true;
      console.warn("PropType Warning: Material Icon of action '" + iconName + "' is not allowed");
    }

    return propType.call.apply(propType, [_this].concat(args));
  };
}