'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _class; /* Copyright © 2018 Kuali, Inc. - All Rights Reserved
             * You may use and modify this code under the terms of the Kuali, Inc.
             * Pre-Release License Agreement. You may not distribute it.
             *
             * You should have received a copy of the Kuali, Inc. Pre-Release License
             * Agreement with this file. If not, please write to license@kuali.co.
             */


var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _coreDecorators = require('core-decorators');

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _ = require('../../');

var _brand = require('../../brand');

var _navLists = require('../../nav-lists');

var _titleBar = require('../title-bar');

var _titleBar2 = _interopRequireDefault(_titleBar);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var GrayjoyLayout = (0, _coreDecorators.autobind)(_class = function (_Component) {
  _inherits(GrayjoyLayout, _Component);

  function GrayjoyLayout(props) {
    _classCallCheck(this, GrayjoyLayout);

    var _this = _possibleConstructorReturn(this, (GrayjoyLayout.__proto__ || Object.getPrototypeOf(GrayjoyLayout)).call(this, props));

    _this.applySidebarItemClassNames = function (element) {
      return (0, _react.cloneElement)(element, {
        className: (0, _classnames2.default)('grayjoy-layout__sidebar-item', {
          'grayjoy-layout__sidebar-item-active': element.props.active
        })
      });
    };

    _this.toggleSidebarVisibility = function () {
      _this.setState({ sidebarIsExpanded: !_this.state.sidebarIsExpanded });
    };

    _this.state = { sidebarIsExpanded: false };
    return _this;
  }

  _createClass(GrayjoyLayout, [{
    key: 'render',
    value: function render() {
      var _props = this.props,
          children = _props.children,
          className = _props.className,
          appName = _props.appName,
          pageTitle = _props.pageTitle,
          sidebarBodyLinks = _props.sidebarBodyLinks,
          sidebarFooterLinks = _props.sidebarFooterLinks;
      var sidebarIsExpanded = this.state.sidebarIsExpanded;


      var classes = (0, _classnames2.default)('grayjoy-layout', className);

      return _react2.default.createElement(
        'div',
        { className: classes },
        _react2.default.createElement(
          _.Drawer,
          {
            visible: sidebarIsExpanded,
            onVisibilityChange: function onVisibilityChange() {},
            onMediaTypeChange: function onMediaTypeChange() {},
            className: (0, _classnames2.default)('grayjoy-layout__sidebar', {
              'grayjoy-layout__sidebar--mini': !sidebarIsExpanded
            }),
            mobileType: _.Drawer.DrawerTypes.TEMPORARY,
            type: sidebarIsExpanded ? _.Drawer.DrawerTypes.PERSISTENT : _.Drawer.DrawerTypes.PERSISTENT_MINI,
            header: _react2.default.createElement(
              'div',
              { className: 'grayjoy-layout__sidebar-header' },
              _react2.default.createElement(_brand.BrandIcon, null),
              _react2.default.createElement(
                'span',
                { className: 'grayjoy-layout__sidebar-header-text' },
                appName
              )
            )
          },
          _react2.default.createElement(
            _navLists.NavList,
            { className: 'grayjoy-layout__sidebar-body' },
            sidebarBodyLinks
          ),
          _react2.default.createElement(
            _navLists.NavList,
            { className: 'grayjoy-layout__sidebar-footer' },
            sidebarFooterLinks,
            _react2.default.createElement(
              _navLists.NavListItem,
              {
                className: 'grayjoy-layout__sidebar-item',
                iconName: 'layers'
              },
              'Switch apps'
            ),
            _react2.default.createElement(
              _navLists.NavListItem,
              {
                onClick: this.toggleSidebarVisibility,
                iconName: sidebarIsExpanded ? 'keyboard_arrow_left' : 'keyboard_arrow_right'
              },
              sidebarIsExpanded ? 'Hide' : ''
            )
          )
        ),
        _react2.default.createElement(
          'div',
          { className: 'grayjoy-layout__body' },
          _react2.default.createElement(
            _titleBar2.default,
            { className: 'grayjoy-layout__titlebar' },
            _react2.default.createElement(
              _.FontIcon,
              {
                className: 'grayjoy-layout__titlebar-menu-icon',
                onClick: this.toggleSidebarVisibility
              },
              'menu'
            ),
            _react2.default.createElement(
              'div',
              {
                className: (0, _classnames2.default)('grayjoy-layout__titlebar-title', {
                  'grayjoy-layout__titlebar-title--sidebar-expanded': sidebarIsExpanded
                })
              },
              pageTitle
            )
          ),
          _react2.default.createElement(
            'div',
            {
              className: (0, _classnames2.default)('grayjoy-layout__main', {
                'grayjoy-layout__main--sidebar-expanded': sidebarIsExpanded
              })
            },
            children
          )
        )
      );
    }
  }]);

  return GrayjoyLayout;
}(_react.Component)) || _class;

GrayjoyLayout.propTypes = {
  appName: _propTypes2.default.string.isRequired,
  children: _propTypes2.default.node.isRequired,
  className: _propTypes2.default.string,
  pageTitle: _propTypes2.default.oneOfType([_propTypes2.default.string.isRequired, _propTypes2.default.node.isRequired]),
  sidebarBodyLinks: _propTypes2.default.oneOfType([_propTypes2.default.node, _propTypes2.default.arrayOf(_propTypes2.default.node)]),
  sidebarFooterLinks: _propTypes2.default.oneOfType([_propTypes2.default.node, _propTypes2.default.arrayOf(_propTypes2.default.node)])
};
exports.default = GrayjoyLayout;