'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JumpToMenuItem = exports.JumpToMenuBadge = exports.JumpToMenu = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _class, _class2; /* Copyright © 2016 Kuali, Inc. - All Rights Reserved
                      * You may use and modify this code under the terms of the Kuali, Inc.
                      * Pre-Release License Agreement. You may not distribute it.
                      *
                      * You should have received a copy of the Kuali, Inc. Pre-Release License
                      * Agreement with this file. If not, please write to license@kuali.co.
                      */

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _coreDecorators = require('core-decorators');

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _Inks = require('react-md/lib/Inks');

var _Inks2 = _interopRequireDefault(_Inks);

var _ = require('../..');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var JumpToMenu = exports.JumpToMenu = (0, _coreDecorators.autobind)(_class = function (_Component) {
  _inherits(JumpToMenu, _Component);

  function JumpToMenu() {
    var _ref;

    var _temp, _this, _ret;

    _classCallCheck(this, JumpToMenu);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = JumpToMenu.__proto__ || Object.getPrototypeOf(JumpToMenu)).call.apply(_ref, [this].concat(args))), _this), _this.state = {
      expanded: false
    }, _temp), _possibleConstructorReturn(_this, _ret);
  }

  _createClass(JumpToMenu, [{
    key: 'handleToggle',
    value: function handleToggle(evt) {
      this.setState({ expanded: !this.state.expanded });
    }
  }, {
    key: 'render',
    value: function render() {
      var _props = this.props,
          children = _props.children,
          className = _props.className;
      var expanded = this.state.expanded;


      var classes = (0, _classnames2.default)('jump-to-menu', {
        'jump-to-menu--expanded': expanded
      }, className);

      return _react2.default.createElement(
        'div',
        { className: classes },
        _react2.default.createElement(
          _.RaisedButton,
          {
            block: true,
            className: 'jump-to-menu__expand-button',
            label: 'Jump To',
            onClick: this.handleToggle,
            variant: 'plain'
          },
          _react2.default.createElement(_.Icon, { name: 'arrow_downward' })
        ),
        _react2.default.createElement(
          'ul',
          { className: 'jump-to-menu__list' },
          children
        )
      );
    }
  }]);

  return JumpToMenu;
}(_react.Component)) || _class;

JumpToMenu.propTypes = {
  children: _propTypes2.default.node.isRequired,
  className: _propTypes2.default.string
};

var JumpToMenuBadge = exports.JumpToMenuBadge = function (_PureComponent) {
  _inherits(JumpToMenuBadge, _PureComponent);

  function JumpToMenuBadge() {
    _classCallCheck(this, JumpToMenuBadge);

    return _possibleConstructorReturn(this, (JumpToMenuBadge.__proto__ || Object.getPrototypeOf(JumpToMenuBadge)).apply(this, arguments));
  }

  _createClass(JumpToMenuBadge, [{
    key: 'render',
    value: function render() {
      var _props2 = this.props,
          className = _props2.className,
          count = _props2.count,
          rest = _objectWithoutProperties(_props2, ['className', 'count']);

      var classes = (0, _classnames2.default)('jump-to-menu__badge', className);

      return _react2.default.createElement(
        'span',
        _extends({ className: classes }, rest),
        count
      );
    }
  }]);

  return JumpToMenuBadge;
}(_react.PureComponent);

JumpToMenuBadge.propTypes = {
  className: _propTypes2.default.string,
  count: _propTypes2.default.number.isRequired
};

var JumpToMenuItem = exports.JumpToMenuItem = (0, _Inks2.default)(_class2 = function (_PureComponent2) {
  _inherits(JumpToMenuItem, _PureComponent2);

  function JumpToMenuItem() {
    _classCallCheck(this, JumpToMenuItem);

    return _possibleConstructorReturn(this, (JumpToMenuItem.__proto__ || Object.getPrototypeOf(JumpToMenuItem)).apply(this, arguments));
  }

  _createClass(JumpToMenuItem, [{
    key: 'render',
    value: function render() {
      var _props3 = this.props,
          children = _props3.children,
          className = _props3.className,
          ink = _props3.ink,
          rest = _objectWithoutProperties(_props3, ['children', 'className', 'ink']);

      delete rest.badgeCount;
      delete rest.checked;
      delete rest.icon;

      var classes = (0, _classnames2.default)('jump-to-menu__item', className);

      return _react2.default.createElement(
        'li',
        null,
        _react2.default.createElement(
          'a',
          _extends({ className: classes, tabIndex: '0' }, rest),
          _react2.default.createElement(
            'span',
            { className: 'jump-to-menu__item-inner' },
            children
          ),
          this.indicator,
          ink
        )
      );
    }
  }, {
    key: 'indicator',
    get: function get() {
      var _props4 = this.props,
          badgeCount = _props4.badgeCount,
          checked = _props4.checked,
          icon = _props4.icon;


      var toRender = void 0;

      if (badgeCount > 0) {
        toRender = _react2.default.createElement(JumpToMenuBadge, { count: badgeCount });
      } else if (icon) {
        toRender = icon;
      } else if (checked) {
        toRender = _react2.default.createElement(_.Icon, { name: 'done', variant: 'success' });
      }

      if (!toRender) return null;

      return _react2.default.createElement(
        'div',
        { className: 'jump-to-menu__item__indicator' },
        toRender
      );
    }
  }]);

  return JumpToMenuItem;
}(_react.PureComponent)) || _class2;

JumpToMenuItem.defaultProps = {
  badgeCount: 0,
  checked: false
};
JumpToMenuItem.propTypes = {
  badgeCount: _propTypes2.default.number,
  className: _propTypes2.default.string,
  checked: _propTypes2.default.bool,
  children: _propTypes2.default.node.isRequired,
  icon: _propTypes2.default.node,
  ink: _propTypes2.default.node
};