'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = deprecated;
/* Copyright © 2016 Kuali, Inc. - All Rights Reserved
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 *
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 */

function deprecated(propType, message) {
  var _this = this;

  var warned = false;

  return function () {
    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    var props = args[0],
        propName = args[1];

    var prop = props[propName];

    if (prop && !warned) {
      warned = true;
      console.warn('PropType Warning:', message || 'prop "' + propName + '" is deprecated.');
    }

    return propType.call.apply(propType, [_this].concat(args));
  };
}