import _toConsumableArray from 'babel-runtime/helpers/toConsumableArray';
/**
 * strips indentation from a template literal
 * @param  {String} type = 'initial' - whether to remove all indentation or just leading indentation. can be 'all' or 'initial'
 * @return {Object}                  - a TemplateTag transformer
 */
var stripIndentTransformer = function stripIndentTransformer() {
  var type = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'initial';
  return {
    onEndResult: function onEndResult(endResult) {
      if (type === 'initial') {
        // remove the shortest leading indentation from each line
        var match = endResult.match(/^[^\S\n]*(?=\S)/gm);
        var indent = match && Math.min.apply(Math, _toConsumableArray(match.map(function (el) {
          return el.length;
        })));
        if (indent) {
          var regexp = new RegExp('^.{' + indent + '}', 'gm');
          return endResult.replace(regexp, '');
        }
        return endResult;
      }
      if (type === 'all') {
        // remove all indentation from each line
        return endResult.replace(/^[^\S\n]+/gm, '');
      }
      throw new Error('Unknown type: ' + type);
    }
  };
};

export default stripIndentTransformer;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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