'use strict';

var _index = require('./index.js');

/*! normalize.css v5.0.0 | MIT License | github.com/necolas/normalize.css */

/**
 * 1. Change the default font family in all browsers (opinionated).
 * 2. Correct the line height in all browsers.
 * 3. Prevent adjustments of font size after orientation changes in
 *    IE on Windows Phone and in iOS.
 */

/* Document
   ========================================================================== */

(0, _index.insertRule)('html {\n  font-family: sans-serif; /* 1 */\n  line-height: 1.15; /* 2 */\n  -ms-text-size-adjust: 100%; /* 3 */\n  -webkit-text-size-adjust: 100%; /* 3 */\n}');

/* Sections
   ========================================================================== */

/**
 * Remove the margin in all browsers (opinionated).
 */

(0, _index.insertRule)('body {\n  margin: 0;\n}');

/**
 * Add the correct display in IE 9-.
 */

(0, _index.insertRule)('article,\naside,\nfooter,\nheader,\nnav,\nsection {\n  display: block;\n}');

/**
 * Correct the font size and margin on `h1` elements within `section` and
 * `article` contexts in Chrome, Firefox, and Safari.
 */

(0, _index.insertRule)('h1 {\n  font-size: 2em;\n  margin: 0.67em 0;\n}');

/* Grouping content
   ========================================================================== */

/**
 * Add the correct display in IE 9-.
 * 1. Add the correct display in IE.
 */

(0, _index.insertRule)('figcaption,\nfigure,\nmain { /* 1 */\n  display: block;\n}');

/**
 * Add the correct margin in IE 8.
 */

(0, _index.insertRule)('figure {\n  margin: 1em 40px;\n}');

/**
 * 1. Add the correct box sizing in Firefox.
 * 2. Show the overflow in Edge and IE.
 */

(0, _index.insertRule)('hr {\n  box-sizing: content-box; /* 1 */\n  height: 0; /* 1 */\n  overflow: visible; /* 2 */\n}');

/**
 * 1. Correct the inheritance and scaling of font size in all browsers.
 * 2. Correct the odd `em` font sizing in all browsers.
 */

(0, _index.insertRule)('pre {\n  font-family: monospace, monospace; /* 1 */\n  font-size: 1em; /* 2 */\n}');

/* Text-level semantics
   ========================================================================== */

/**
 * 1. Remove the gray background on active links in IE 10.
 * 2. Remove gaps in links underline in iOS 8+ and Safari 8+.
 */

(0, _index.insertRule)('a {\n  background-color: transparent; /* 1 */\n  -webkit-text-decoration-skip: objects; /* 2 */\n}');

/**
 * Remove the outline on focused links when they are also active or hovered
 * in all browsers (opinionated).
 */

(0, _index.insertRule)('a:active,\na:hover {\n  outline-width: 0;\n}');

/**
 * 1. Remove the bottom border in Firefox 39-.
 * 2. Add the correct text decoration in Chrome, Edge, IE, Opera, and Safari.
 */

(0, _index.insertRule)('abbr[title] {\n  border-bottom: none; /* 1 */\n  text-decoration: underline; /* 2 */\n  text-decoration: underline dotted; /* 2 */\n}');

/**
 * Prevent the duplicate application of `bolder` by the next rule in Safari 6.
 */

(0, _index.insertRule)('b,\nstrong {\n  font-weight: inherit;\n}');

/**
 * Add the correct font weight in Chrome, Edge, and Safari.
 */

(0, _index.insertRule)('b,\nstrong {\n  font-weight: bolder;\n}');

/**
 * 1. Correct the inheritance and scaling of font size in all browsers.
 * 2. Correct the odd `em` font sizing in all browsers.
 */

(0, _index.insertRule)('code,\nkbd,\nsamp {\n  font-family: monospace, monospace; /* 1 */\n  font-size: 1em; /* 2 */\n}');

/**
 * Add the correct font style in Android 4.3-.
 */

(0, _index.insertRule)('dfn {\n  font-style: italic;\n}');

/**
 * Add the correct background and color in IE 9-.
 */

(0, _index.insertRule)('mark {\n  background-color: #ff0;\n  color: #000;\n}');

/**
 * Add the correct font size in all browsers.
 */

(0, _index.insertRule)('small {\n  font-size: 80%;\n}');

/**
 * Prevent `sub` and `sup` elements from affecting the line height in
 * all browsers.
 */

(0, _index.insertRule)('sub,\nsup {\n  font-size: 75%;\n  line-height: 0;\n  position: relative;\n  vertical-align: baseline;\n}');

(0, _index.insertRule)('sub {\n  bottom: -0.25em;\n}');

(0, _index.insertRule)('sup {\n  top: -0.5em;\n}');

/* Embedded content
   ========================================================================== */

/**
 * Add the correct display in IE 9-.
 */

(0, _index.insertRule)('audio,\nvideo {\n  display: inline-block;\n}');

/**
 * Add the correct display in iOS 4-7.
 */

(0, _index.insertRule)('audio:not([controls]) {\n  display: none;\n  height: 0;\n}');

/**
 * Remove the border on images inside links in IE 10-.
 */

(0, _index.insertRule)('img {\n  border-style: none;\n}');

/**
 * Hide the overflow in IE.
 */

(0, _index.insertRule)('svg:not(:root) {\n  overflow: hidden;\n}');

/* Forms
   ========================================================================== */

/**
 * 1. Change the font styles in all browsers (opinionated).
 * 2. Remove the margin in Firefox and Safari.
 */

(0, _index.insertRule)('button,\ninput,\noptgroup,\nselect,\ntextarea {\n  font-family: sans-serif; /* 1 */\n  font-size: 100%; /* 1 */\n  line-height: 1.15; /* 1 */\n  margin: 0; /* 2 */\n}');

/**
 * Show the overflow in IE.
 * 1. Show the overflow in Edge.
 */

(0, _index.insertRule)('button,\ninput { /* 1 */\n  overflow: visible;\n}');

/**
 * Remove the inheritance of text transform in Edge, Firefox, and IE.
 * 1. Remove the inheritance of text transform in Firefox.
 */

(0, _index.insertRule)('button,\nselect { /* 1 */\n  text-transform: none;\n}');

/**
 * 1. Prevent a WebKit bug where (2) destroys native `audio` and `video`
 *    controls in Android 4.
 * 2. Correct the inability to style clickable types in iOS and Safari.
 */

(0, _index.insertRule)('button,\nhtml [type="button"], /* 1 */\n[type="reset"],\n[type="submit"] {\n  -webkit-appearance: button; /* 2 */\n}');

/**
 * Remove the inner border and padding in Firefox.
 */

(0, _index.insertRule)('button::-moz-focus-inner,\n[type="button"]::-moz-focus-inner,\n[type="reset"]::-moz-focus-inner,\n[type="submit"]::-moz-focus-inner {\n  border-style: none;\n  padding: 0;\n}');

/**
 * Restore the focus styles unset by the previous rule.
 */

(0, _index.insertRule)('button:-moz-focusring,\n[type="button"]:-moz-focusring,\n[type="reset"]:-moz-focusring,\n[type="submit"]:-moz-focusring {\n  outline: 1px dotted ButtonText;\n}');

/**
 * Change the border, margin, and padding in all browsers (opinionated).
 */

(0, _index.insertRule)('fieldset {\n  border: 1px solid #c0c0c0;\n  margin: 0 2px;\n  padding: 0.35em 0.625em 0.75em;\n}');

/**
 * 1. Correct the text wrapping in Edge and IE.
 * 2. Correct the color inheritance from `fieldset` elements in IE.
 * 3. Remove the padding so developers are not caught out when they zero out
 *    `fieldset` elements in all browsers.
 */

(0, _index.insertRule)('legend {\n  box-sizing: border-box; /* 1 */\n  color: inherit; /* 2 */\n  display: table; /* 1 */\n  max-width: 100%; /* 1 */\n  padding: 0; /* 3 */\n  white-space: normal; /* 1 */\n}');

/**
 * 1. Add the correct display in IE 9-.
 * 2. Add the correct vertical alignment in Chrome, Firefox, and Opera.
 */

(0, _index.insertRule)('progress {\n  display: inline-block; /* 1 */\n  vertical-align: baseline; /* 2 */\n}');

/**
 * Remove the default vertical scrollbar in IE.
 */

(0, _index.insertRule)('textarea {\n  overflow: auto;\n}');

/**
 * 1. Add the correct box sizing in IE 10-.
 * 2. Remove the padding in IE 10-.
 */

(0, _index.insertRule)('[type="checkbox"],\n[type="radio"] {\n  box-sizing: border-box; /* 1 */\n  padding: 0; /* 2 */\n}');

/**
 * Correct the cursor style of increment and decrement buttons in Chrome.
 */

(0, _index.insertRule)('[type="number"]::-webkit-inner-spin-button,\n[type="number"]::-webkit-outer-spin-button {\n  height: auto;\n}');

/**
 * 1. Correct the odd appearance in Chrome and Safari.
 * 2. Correct the outline style in Safari.
 */

(0, _index.insertRule)('[type="search"] {\n  -webkit-appearance: textfield; /* 1 */\n  outline-offset: -2px; /* 2 */\n}');

/**
 * Remove the inner padding and cancel buttons in Chrome and Safari on macOS.
 */

(0, _index.insertRule)('[type="search"]::-webkit-search-cancel-button,\n[type="search"]::-webkit-search-decoration {\n  -webkit-appearance: none;\n}');

/**
 * 1. Correct the inability to style clickable types in iOS and Safari.
 * 2. Change font properties to `inherit` in Safari.
 */

(0, _index.insertRule)('::-webkit-file-upload-button {\n  -webkit-appearance: button; /* 1 */\n  font: inherit; /* 2 */\n}');

/* Interactive
   ========================================================================== */

/*
 * Add the correct display in IE 9-.
 * 1. Add the correct display in Edge, IE, and Firefox.
 */

(0, _index.insertRule)('details, /* 1 */\nmenu {\n  display: block;\n}');

/*
 * Add the correct display in all browsers.
 */

(0, _index.insertRule)('summary {\n  display: list-item;\n}');

/* Scripting
   ========================================================================== */

/**
 * Add the correct display in IE 9-.
 */

(0, _index.insertRule)('canvas {\n  display: inline-block;\n}');

/**
 * Add the correct display in IE.
 */

(0, _index.insertRule)('template {\n  display: none;\n}');

/* Hidden
   ========================================================================== */

/**
 * Add the correct display in IE 10-.
 */

(0, _index.insertRule)('[hidden] {\n  display: none;\n}');