# Contributing

Hey, you feel like contributing to include-media? That's great, we are really looking forward to it! You might want to know just a few things before getting started:

* Code should stick to [Sass Guidelines](http://sass-guidelin.es);
* Sass variables, functions, mixins and placeholders should be documented with [SassDoc](http://sassdoc.com);
* Tests and code linting should pass at all time (there is a pre-commit hook for it);
* Simplicity is a keyword in include-media, try not to involve too much complexity.

## Found a bug?

Have a quick search on the GitHub repository to make sure someone has not opened something similar already. If it looks unique enough to you, be sure to open an issue explaining the problem clearly. We'll try to fix it as soon as possible!

## Want a new feature?

Open an issue before submitting any pull-request to the repository. It would be a shame if you spent hours working on something only to see it declined for some reason. So open an issue to explain the feature you'd like to see in include-media, let's discuss it, and then if you feel like it, go crazy and tackle it!

## Found a typo in the documentation?

If you found a typo in the [project documentation](http://include-media.com), you can submit a pull-request on the `gh-pages` branch to fix it. Thanks for doing it!

If you found a typo in the [Sass API documentation](http://include-media.com/documentation/), you can pull-request the code on `master` to update the block comment from the relevant item.
