'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.AXURL = exports.fn = exports.devices = exports.browser = exports.role = exports.DOM = exports.aria = exports.hasProp = exports.trueish = exports.listensTo = exports.hiddenFromAT = exports.isInteractive = undefined;

var _symbol = require('babel-runtime/core-js/symbol');

var _symbol2 = _interopRequireDefault(_symbol);

var _isInteractive = require('./is-interactive');

Object.defineProperty(exports, 'isInteractive', {
    enumerable: true,
    get: function get() {
        return _interopRequireDefault(_isInteractive).default;
    }
});

var _hiddenFromAt = require('./hidden-from-at');

Object.defineProperty(exports, 'hiddenFromAT', {
    enumerable: true,
    get: function get() {
        return _interopRequireDefault(_hiddenFromAt).default;
    }
});

var _listensTo = require('./listens-to');

Object.defineProperty(exports, 'listensTo', {
    enumerable: true,
    get: function get() {
        return _interopRequireDefault(_listensTo).default;
    }
});

var _trueish = require('./trueish');

Object.defineProperty(exports, 'trueish', {
    enumerable: true,
    get: function get() {
        return _interopRequireDefault(_trueish).default;
    }
});

var _hasProp = require('./has-prop');

Object.defineProperty(exports, 'hasProp', {
    enumerable: true,
    get: function get() {
        return _interopRequireDefault(_hasProp).default;
    }
});

var _aria = require('./aria');

Object.defineProperty(exports, 'aria', {
    enumerable: true,
    get: function get() {
        return _interopRequireDefault(_aria).default;
    }
});

var _DOM = require('./DOM');

Object.defineProperty(exports, 'DOM', {
    enumerable: true,
    get: function get() {
        return _interopRequireDefault(_DOM).default;
    }
});

var _role = require('./role');

Object.defineProperty(exports, 'role', {
    enumerable: true,
    get: function get() {
        return _interopRequireDefault(_role).default;
    }
});

var _browser = require('./browser');

Object.defineProperty(exports, 'browser', {
    enumerable: true,
    get: function get() {
        return _interopRequireDefault(_browser).default;
    }
});

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var devices = exports.devices = {
    screenReaders: (0, _symbol2.default)('screenReaders'),
    keyboardOnly: (0, _symbol2.default)('keyboardOnly'),
    mobile: (0, _symbol2.default)('mobile')
};

// simple callback
var fn = exports.fn = function fn() {
    return null;
};

// builds url for specific google AX Rule
var AXURL = exports.AXURL = function AXURL(ax) {
    return 'https://github.com/GoogleChrome/accessibility-developer-tools/wiki/Audit-Rules#' + ax;
};