import React, { Children, Component, PureComponent, cloneElement, createElement, isValidElement } from 'react';
import reactDom, { createPortal, findDOMNode, unmountComponentAtNode, unstable_renderSubtreeIntoContainer } from 'react-dom';

var commonjsGlobal = typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};



function unwrapExports (x) {
	return x && x.__esModule ? x['default'] : x;
}

function createCommonjsModule(fn, module) {
	return module = { exports: {} }, fn(module, module.exports), module.exports;
}

"use strict";

/**
 * Copyright (c) 2013-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * 
 */

function makeEmptyFunction(arg) {
  return function () {
    return arg;
  };
}

/**
 * This function accepts and discards inputs; it has no side effects. This is
 * primarily useful idiomatically for overridable function endpoints which
 * always need to be callable, since JS lacks a null-call idiom ala Cocoa.
 */
var emptyFunction = function emptyFunction() {};

emptyFunction.thatReturns = makeEmptyFunction;
emptyFunction.thatReturnsFalse = makeEmptyFunction(false);
emptyFunction.thatReturnsTrue = makeEmptyFunction(true);
emptyFunction.thatReturnsNull = makeEmptyFunction(null);
emptyFunction.thatReturnsThis = function () {
  return this;
};
emptyFunction.thatReturnsArgument = function (arg) {
  return arg;
};

var emptyFunction_1 = emptyFunction;

/**
 * Copyright (c) 2013-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 */

'use strict';

/**
 * Use invariant() to assert state which your program assumes to be true.
 *
 * Provide sprintf-style format (only %s is supported) and arguments
 * to provide information about what broke and what you were
 * expecting.
 *
 * The invariant message will be stripped in production, but the invariant
 * will remain to ensure logic does not differ in production.
 */

var validateFormat = function validateFormat(format) {};

if (process.env.NODE_ENV !== 'production') {
  validateFormat = function validateFormat(format) {
    if (format === undefined) {
      throw new Error('invariant requires an error message argument');
    }
  };
}

function invariant(condition, format, a, b, c, d, e, f) {
  validateFormat(format);

  if (!condition) {
    var error;
    if (format === undefined) {
      error = new Error('Minified exception occurred; use the non-minified dev environment ' + 'for the full error message and additional helpful warnings.');
    } else {
      var args = [a, b, c, d, e, f];
      var argIndex = 0;
      error = new Error(format.replace(/%s/g, function () {
        return args[argIndex++];
      }));
      error.name = 'Invariant Violation';
    }

    error.framesToPop = 1; // we don't care about invariant's own frame
    throw error;
  }
}

var invariant_1 = invariant;

/**
 * Copyright (c) 2014-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 */

'use strict';



/**
 * Similar to invariant but only logs a warning if the condition is not met.
 * This can be used to log issues in development environments in critical
 * paths. Removing the logging code for production environments will keep the
 * same logic and follow the same code paths.
 */

var warning = emptyFunction_1;

if (process.env.NODE_ENV !== 'production') {
  var printWarning = function printWarning(format) {
    for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
      args[_key - 1] = arguments[_key];
    }

    var argIndex = 0;
    var message = 'Warning: ' + format.replace(/%s/g, function () {
      return args[argIndex++];
    });
    if (typeof console !== 'undefined') {
      console.error(message);
    }
    try {
      // --- Welcome to debugging React ---
      // This error was thrown as a convenience so that you can use this stack
      // to find the callsite that caused this warning to fire.
      throw new Error(message);
    } catch (x) {}
  };

  warning = function warning(condition, format) {
    if (format === undefined) {
      throw new Error('`warning(condition, format, ...args)` requires a warning ' + 'message argument');
    }

    if (format.indexOf('Failed Composite propType: ') === 0) {
      return; // Ignore CompositeComponent proptype check.
    }

    if (!condition) {
      for (var _len2 = arguments.length, args = Array(_len2 > 2 ? _len2 - 2 : 0), _key2 = 2; _key2 < _len2; _key2++) {
        args[_key2 - 2] = arguments[_key2];
      }

      printWarning.apply(undefined, [format].concat(args));
    }
  };
}

var warning_1 = warning;

/*
object-assign
(c) Sindre Sorhus
@license MIT
*/

'use strict';
/* eslint-disable no-unused-vars */
var getOwnPropertySymbols = Object.getOwnPropertySymbols;
var hasOwnProperty = Object.prototype.hasOwnProperty;
var propIsEnumerable = Object.prototype.propertyIsEnumerable;

function toObject(val) {
	if (val === null || val === undefined) {
		throw new TypeError('Object.assign cannot be called with null or undefined');
	}

	return Object(val);
}

function shouldUseNative() {
	try {
		if (!Object.assign) {
			return false;
		}

		// Detect buggy property enumeration order in older V8 versions.

		// https://bugs.chromium.org/p/v8/issues/detail?id=4118
		var test1 = new String('abc');  // eslint-disable-line no-new-wrappers
		test1[5] = 'de';
		if (Object.getOwnPropertyNames(test1)[0] === '5') {
			return false;
		}

		// https://bugs.chromium.org/p/v8/issues/detail?id=3056
		var test2 = {};
		for (var i = 0; i < 10; i++) {
			test2['_' + String.fromCharCode(i)] = i;
		}
		var order2 = Object.getOwnPropertyNames(test2).map(function (n) {
			return test2[n];
		});
		if (order2.join('') !== '0123456789') {
			return false;
		}

		// https://bugs.chromium.org/p/v8/issues/detail?id=3056
		var test3 = {};
		'abcdefghijklmnopqrst'.split('').forEach(function (letter) {
			test3[letter] = letter;
		});
		if (Object.keys(Object.assign({}, test3)).join('') !==
				'abcdefghijklmnopqrst') {
			return false;
		}

		return true;
	} catch (err) {
		// We don't expect any of the above to throw, but better to be safe.
		return false;
	}
}

var objectAssign = shouldUseNative() ? Object.assign : function (target, source) {
	var from;
	var to = toObject(target);
	var symbols;

	for (var s = 1; s < arguments.length; s++) {
		from = Object(arguments[s]);

		for (var key in from) {
			if (hasOwnProperty.call(from, key)) {
				to[key] = from[key];
			}
		}

		if (getOwnPropertySymbols) {
			symbols = getOwnPropertySymbols(from);
			for (var i = 0; i < symbols.length; i++) {
				if (propIsEnumerable.call(from, symbols[i])) {
					to[symbols[i]] = from[symbols[i]];
				}
			}
		}
	}

	return to;
};

/**
 * Copyright (c) 2013-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */

'use strict';

var ReactPropTypesSecret = 'SECRET_DO_NOT_PASS_THIS_OR_YOU_WILL_BE_FIRED';

var ReactPropTypesSecret_1 = ReactPropTypesSecret;

/**
 * Copyright (c) 2013-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */

'use strict';

if (process.env.NODE_ENV !== 'production') {
  var invariant$1 = invariant_1;
  var warning$1 = warning_1;
  var ReactPropTypesSecret$1 = ReactPropTypesSecret_1;
  var loggedTypeFailures = {};
}

/**
 * Assert that the values match with the type specs.
 * Error messages are memorized and will only be shown once.
 *
 * @param {object} typeSpecs Map of name to a ReactPropType
 * @param {object} values Runtime values that need to be type-checked
 * @param {string} location e.g. "prop", "context", "child context"
 * @param {string} componentName Name of the component for error messages.
 * @param {?Function} getStack Returns the component stack.
 * @private
 */
function checkPropTypes(typeSpecs, values, location, componentName, getStack) {
  if (process.env.NODE_ENV !== 'production') {
    for (var typeSpecName in typeSpecs) {
      if (typeSpecs.hasOwnProperty(typeSpecName)) {
        var error;
        // Prop type validation may throw. In case they do, we don't want to
        // fail the render phase where it didn't fail before. So we log it.
        // After these have been cleaned up, we'll let them throw.
        try {
          // This is intentionally an invariant that gets caught. It's the same
          // behavior as without this statement except with a better message.
          invariant$1(typeof typeSpecs[typeSpecName] === 'function', '%s: %s type `%s` is invalid; it must be a function, usually from ' + 'the `prop-types` package, but received `%s`.', componentName || 'React class', location, typeSpecName, typeof typeSpecs[typeSpecName]);
          error = typeSpecs[typeSpecName](values, typeSpecName, componentName, location, null, ReactPropTypesSecret$1);
        } catch (ex) {
          error = ex;
        }
        warning$1(!error || error instanceof Error, '%s: type specification of %s `%s` is invalid; the type checker ' + 'function must return `null` or an `Error` but returned a %s. ' + 'You may have forgotten to pass an argument to the type checker ' + 'creator (arrayOf, instanceOf, objectOf, oneOf, oneOfType, and ' + 'shape all require an argument).', componentName || 'React class', location, typeSpecName, typeof error);
        if (error instanceof Error && !(error.message in loggedTypeFailures)) {
          // Only monitor this failure once because there tends to be a lot of the
          // same error.
          loggedTypeFailures[error.message] = true;

          var stack = getStack ? getStack() : '';

          warning$1(false, 'Failed %s type: %s%s', location, error.message, stack != null ? stack : '');
        }
      }
    }
  }
}

var checkPropTypes_1 = checkPropTypes;

/**
 * Copyright (c) 2013-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */

'use strict';









var factoryWithTypeCheckers = function(isValidElement$$1, throwOnDirectAccess) {
  /* global Symbol */
  var ITERATOR_SYMBOL = typeof Symbol === 'function' && Symbol.iterator;
  var FAUX_ITERATOR_SYMBOL = '@@iterator'; // Before Symbol spec.

  /**
   * Returns the iterator method function contained on the iterable object.
   *
   * Be sure to invoke the function with the iterable as context:
   *
   *     var iteratorFn = getIteratorFn(myIterable);
   *     if (iteratorFn) {
   *       var iterator = iteratorFn.call(myIterable);
   *       ...
   *     }
   *
   * @param {?object} maybeIterable
   * @return {?function}
   */
  function getIteratorFn(maybeIterable) {
    var iteratorFn = maybeIterable && (ITERATOR_SYMBOL && maybeIterable[ITERATOR_SYMBOL] || maybeIterable[FAUX_ITERATOR_SYMBOL]);
    if (typeof iteratorFn === 'function') {
      return iteratorFn;
    }
  }

  /**
   * Collection of methods that allow declaration and validation of props that are
   * supplied to React components. Example usage:
   *
   *   var Props = require('ReactPropTypes');
   *   var MyArticle = React.createClass({
   *     propTypes: {
   *       // An optional string prop named "description".
   *       description: Props.string,
   *
   *       // A required enum prop named "category".
   *       category: Props.oneOf(['News','Photos']).isRequired,
   *
   *       // A prop named "dialog" that requires an instance of Dialog.
   *       dialog: Props.instanceOf(Dialog).isRequired
   *     },
   *     render: function() { ... }
   *   });
   *
   * A more formal specification of how these methods are used:
   *
   *   type := array|bool|func|object|number|string|oneOf([...])|instanceOf(...)
   *   decl := ReactPropTypes.{type}(.isRequired)?
   *
   * Each and every declaration produces a function with the same signature. This
   * allows the creation of custom validation functions. For example:
   *
   *  var MyLink = React.createClass({
   *    propTypes: {
   *      // An optional string or URI prop named "href".
   *      href: function(props, propName, componentName) {
   *        var propValue = props[propName];
   *        if (propValue != null && typeof propValue !== 'string' &&
   *            !(propValue instanceof URI)) {
   *          return new Error(
   *            'Expected a string or an URI for ' + propName + ' in ' +
   *            componentName
   *          );
   *        }
   *      }
   *    },
   *    render: function() {...}
   *  });
   *
   * @internal
   */

  var ANONYMOUS = '<<anonymous>>';

  // Important!
  // Keep this list in sync with production version in `./factoryWithThrowingShims.js`.
  var ReactPropTypes = {
    array: createPrimitiveTypeChecker('array'),
    bool: createPrimitiveTypeChecker('boolean'),
    func: createPrimitiveTypeChecker('function'),
    number: createPrimitiveTypeChecker('number'),
    object: createPrimitiveTypeChecker('object'),
    string: createPrimitiveTypeChecker('string'),
    symbol: createPrimitiveTypeChecker('symbol'),

    any: createAnyTypeChecker(),
    arrayOf: createArrayOfTypeChecker,
    element: createElementTypeChecker(),
    instanceOf: createInstanceTypeChecker,
    node: createNodeChecker(),
    objectOf: createObjectOfTypeChecker,
    oneOf: createEnumTypeChecker,
    oneOfType: createUnionTypeChecker,
    shape: createShapeTypeChecker,
    exact: createStrictShapeTypeChecker,
  };

  /**
   * inlined Object.is polyfill to avoid requiring consumers ship their own
   * https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/is
   */
  /*eslint-disable no-self-compare*/
  function is(x, y) {
    // SameValue algorithm
    if (x === y) {
      // Steps 1-5, 7-10
      // Steps 6.b-6.e: +0 != -0
      return x !== 0 || 1 / x === 1 / y;
    } else {
      // Step 6.a: NaN == NaN
      return x !== x && y !== y;
    }
  }
  /*eslint-enable no-self-compare*/

  /**
   * We use an Error-like object for backward compatibility as people may call
   * PropTypes directly and inspect their output. However, we don't use real
   * Errors anymore. We don't inspect their stack anyway, and creating them
   * is prohibitively expensive if they are created too often, such as what
   * happens in oneOfType() for any type before the one that matched.
   */
  function PropTypeError(message) {
    this.message = message;
    this.stack = '';
  }
  // Make `instanceof Error` still work for returned errors.
  PropTypeError.prototype = Error.prototype;

  function createChainableTypeChecker(validate) {
    if (process.env.NODE_ENV !== 'production') {
      var manualPropTypeCallCache = {};
      var manualPropTypeWarningCount = 0;
    }
    function checkType(isRequired, props, propName, componentName, location, propFullName, secret) {
      componentName = componentName || ANONYMOUS;
      propFullName = propFullName || propName;

      if (secret !== ReactPropTypesSecret_1) {
        if (throwOnDirectAccess) {
          // New behavior only for users of `prop-types` package
          invariant_1(
            false,
            'Calling PropTypes validators directly is not supported by the `prop-types` package. ' +
            'Use `PropTypes.checkPropTypes()` to call them. ' +
            'Read more at http://fb.me/use-check-prop-types'
          );
        } else if (process.env.NODE_ENV !== 'production' && typeof console !== 'undefined') {
          // Old behavior for people using React.PropTypes
          var cacheKey = componentName + ':' + propName;
          if (
            !manualPropTypeCallCache[cacheKey] &&
            // Avoid spamming the console because they are often not actionable except for lib authors
            manualPropTypeWarningCount < 3
          ) {
            warning_1(
              false,
              'You are manually calling a React.PropTypes validation ' +
              'function for the `%s` prop on `%s`. This is deprecated ' +
              'and will throw in the standalone `prop-types` package. ' +
              'You may be seeing this warning due to a third-party PropTypes ' +
              'library. See https://fb.me/react-warning-dont-call-proptypes ' + 'for details.',
              propFullName,
              componentName
            );
            manualPropTypeCallCache[cacheKey] = true;
            manualPropTypeWarningCount++;
          }
        }
      }
      if (props[propName] == null) {
        if (isRequired) {
          if (props[propName] === null) {
            return new PropTypeError('The ' + location + ' `' + propFullName + '` is marked as required ' + ('in `' + componentName + '`, but its value is `null`.'));
          }
          return new PropTypeError('The ' + location + ' `' + propFullName + '` is marked as required in ' + ('`' + componentName + '`, but its value is `undefined`.'));
        }
        return null;
      } else {
        return validate(props, propName, componentName, location, propFullName);
      }
    }

    var chainedCheckType = checkType.bind(null, false);
    chainedCheckType.isRequired = checkType.bind(null, true);

    return chainedCheckType;
  }

  function createPrimitiveTypeChecker(expectedType) {
    function validate(props, propName, componentName, location, propFullName, secret) {
      var propValue = props[propName];
      var propType = getPropType(propValue);
      if (propType !== expectedType) {
        // `propValue` being instance of, say, date/regexp, pass the 'object'
        // check, but we can offer a more precise error message here rather than
        // 'of type `object`'.
        var preciseType = getPreciseType(propValue);

        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + preciseType + '` supplied to `' + componentName + '`, expected ') + ('`' + expectedType + '`.'));
      }
      return null;
    }
    return createChainableTypeChecker(validate);
  }

  function createAnyTypeChecker() {
    return createChainableTypeChecker(emptyFunction_1.thatReturnsNull);
  }

  function createArrayOfTypeChecker(typeChecker) {
    function validate(props, propName, componentName, location, propFullName) {
      if (typeof typeChecker !== 'function') {
        return new PropTypeError('Property `' + propFullName + '` of component `' + componentName + '` has invalid PropType notation inside arrayOf.');
      }
      var propValue = props[propName];
      if (!Array.isArray(propValue)) {
        var propType = getPropType(propValue);
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + propType + '` supplied to `' + componentName + '`, expected an array.'));
      }
      for (var i = 0; i < propValue.length; i++) {
        var error = typeChecker(propValue, i, componentName, location, propFullName + '[' + i + ']', ReactPropTypesSecret_1);
        if (error instanceof Error) {
          return error;
        }
      }
      return null;
    }
    return createChainableTypeChecker(validate);
  }

  function createElementTypeChecker() {
    function validate(props, propName, componentName, location, propFullName) {
      var propValue = props[propName];
      if (!isValidElement$$1(propValue)) {
        var propType = getPropType(propValue);
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + propType + '` supplied to `' + componentName + '`, expected a single ReactElement.'));
      }
      return null;
    }
    return createChainableTypeChecker(validate);
  }

  function createInstanceTypeChecker(expectedClass) {
    function validate(props, propName, componentName, location, propFullName) {
      if (!(props[propName] instanceof expectedClass)) {
        var expectedClassName = expectedClass.name || ANONYMOUS;
        var actualClassName = getClassName(props[propName]);
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + actualClassName + '` supplied to `' + componentName + '`, expected ') + ('instance of `' + expectedClassName + '`.'));
      }
      return null;
    }
    return createChainableTypeChecker(validate);
  }

  function createEnumTypeChecker(expectedValues) {
    if (!Array.isArray(expectedValues)) {
      process.env.NODE_ENV !== 'production' ? warning_1(false, 'Invalid argument supplied to oneOf, expected an instance of array.') : void 0;
      return emptyFunction_1.thatReturnsNull;
    }

    function validate(props, propName, componentName, location, propFullName) {
      var propValue = props[propName];
      for (var i = 0; i < expectedValues.length; i++) {
        if (is(propValue, expectedValues[i])) {
          return null;
        }
      }

      var valuesString = JSON.stringify(expectedValues);
      return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of value `' + propValue + '` ' + ('supplied to `' + componentName + '`, expected one of ' + valuesString + '.'));
    }
    return createChainableTypeChecker(validate);
  }

  function createObjectOfTypeChecker(typeChecker) {
    function validate(props, propName, componentName, location, propFullName) {
      if (typeof typeChecker !== 'function') {
        return new PropTypeError('Property `' + propFullName + '` of component `' + componentName + '` has invalid PropType notation inside objectOf.');
      }
      var propValue = props[propName];
      var propType = getPropType(propValue);
      if (propType !== 'object') {
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + propType + '` supplied to `' + componentName + '`, expected an object.'));
      }
      for (var key in propValue) {
        if (propValue.hasOwnProperty(key)) {
          var error = typeChecker(propValue, key, componentName, location, propFullName + '.' + key, ReactPropTypesSecret_1);
          if (error instanceof Error) {
            return error;
          }
        }
      }
      return null;
    }
    return createChainableTypeChecker(validate);
  }

  function createUnionTypeChecker(arrayOfTypeCheckers) {
    if (!Array.isArray(arrayOfTypeCheckers)) {
      process.env.NODE_ENV !== 'production' ? warning_1(false, 'Invalid argument supplied to oneOfType, expected an instance of array.') : void 0;
      return emptyFunction_1.thatReturnsNull;
    }

    for (var i = 0; i < arrayOfTypeCheckers.length; i++) {
      var checker = arrayOfTypeCheckers[i];
      if (typeof checker !== 'function') {
        warning_1(
          false,
          'Invalid argument supplied to oneOfType. Expected an array of check functions, but ' +
          'received %s at index %s.',
          getPostfixForTypeWarning(checker),
          i
        );
        return emptyFunction_1.thatReturnsNull;
      }
    }

    function validate(props, propName, componentName, location, propFullName) {
      for (var i = 0; i < arrayOfTypeCheckers.length; i++) {
        var checker = arrayOfTypeCheckers[i];
        if (checker(props, propName, componentName, location, propFullName, ReactPropTypesSecret_1) == null) {
          return null;
        }
      }

      return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` supplied to ' + ('`' + componentName + '`.'));
    }
    return createChainableTypeChecker(validate);
  }

  function createNodeChecker() {
    function validate(props, propName, componentName, location, propFullName) {
      if (!isNode(props[propName])) {
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` supplied to ' + ('`' + componentName + '`, expected a ReactNode.'));
      }
      return null;
    }
    return createChainableTypeChecker(validate);
  }

  function createShapeTypeChecker(shapeTypes) {
    function validate(props, propName, componentName, location, propFullName) {
      var propValue = props[propName];
      var propType = getPropType(propValue);
      if (propType !== 'object') {
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type `' + propType + '` ' + ('supplied to `' + componentName + '`, expected `object`.'));
      }
      for (var key in shapeTypes) {
        var checker = shapeTypes[key];
        if (!checker) {
          continue;
        }
        var error = checker(propValue, key, componentName, location, propFullName + '.' + key, ReactPropTypesSecret_1);
        if (error) {
          return error;
        }
      }
      return null;
    }
    return createChainableTypeChecker(validate);
  }

  function createStrictShapeTypeChecker(shapeTypes) {
    function validate(props, propName, componentName, location, propFullName) {
      var propValue = props[propName];
      var propType = getPropType(propValue);
      if (propType !== 'object') {
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type `' + propType + '` ' + ('supplied to `' + componentName + '`, expected `object`.'));
      }
      // We need to check all keys in case some are required but missing from
      // props.
      var allKeys = objectAssign({}, props[propName], shapeTypes);
      for (var key in allKeys) {
        var checker = shapeTypes[key];
        if (!checker) {
          return new PropTypeError(
            'Invalid ' + location + ' `' + propFullName + '` key `' + key + '` supplied to `' + componentName + '`.' +
            '\nBad object: ' + JSON.stringify(props[propName], null, '  ') +
            '\nValid keys: ' +  JSON.stringify(Object.keys(shapeTypes), null, '  ')
          );
        }
        var error = checker(propValue, key, componentName, location, propFullName + '.' + key, ReactPropTypesSecret_1);
        if (error) {
          return error;
        }
      }
      return null;
    }

    return createChainableTypeChecker(validate);
  }

  function isNode(propValue) {
    switch (typeof propValue) {
      case 'number':
      case 'string':
      case 'undefined':
        return true;
      case 'boolean':
        return !propValue;
      case 'object':
        if (Array.isArray(propValue)) {
          return propValue.every(isNode);
        }
        if (propValue === null || isValidElement$$1(propValue)) {
          return true;
        }

        var iteratorFn = getIteratorFn(propValue);
        if (iteratorFn) {
          var iterator = iteratorFn.call(propValue);
          var step;
          if (iteratorFn !== propValue.entries) {
            while (!(step = iterator.next()).done) {
              if (!isNode(step.value)) {
                return false;
              }
            }
          } else {
            // Iterator will provide entry [k,v] tuples rather than values.
            while (!(step = iterator.next()).done) {
              var entry = step.value;
              if (entry) {
                if (!isNode(entry[1])) {
                  return false;
                }
              }
            }
          }
        } else {
          return false;
        }

        return true;
      default:
        return false;
    }
  }

  function isSymbol(propType, propValue) {
    // Native Symbol.
    if (propType === 'symbol') {
      return true;
    }

    // 19.4.3.5 Symbol.prototype[@@toStringTag] === 'Symbol'
    if (propValue['@@toStringTag'] === 'Symbol') {
      return true;
    }

    // Fallback for non-spec compliant Symbols which are polyfilled.
    if (typeof Symbol === 'function' && propValue instanceof Symbol) {
      return true;
    }

    return false;
  }

  // Equivalent of `typeof` but with special handling for array and regexp.
  function getPropType(propValue) {
    var propType = typeof propValue;
    if (Array.isArray(propValue)) {
      return 'array';
    }
    if (propValue instanceof RegExp) {
      // Old webkits (at least until Android 4.0) return 'function' rather than
      // 'object' for typeof a RegExp. We'll normalize this here so that /bla/
      // passes PropTypes.object.
      return 'object';
    }
    if (isSymbol(propType, propValue)) {
      return 'symbol';
    }
    return propType;
  }

  // This handles more types than `getPropType`. Only used for error messages.
  // See `createPrimitiveTypeChecker`.
  function getPreciseType(propValue) {
    if (typeof propValue === 'undefined' || propValue === null) {
      return '' + propValue;
    }
    var propType = getPropType(propValue);
    if (propType === 'object') {
      if (propValue instanceof Date) {
        return 'date';
      } else if (propValue instanceof RegExp) {
        return 'regexp';
      }
    }
    return propType;
  }

  // Returns a string that is postfixed to a warning about an invalid type.
  // For example, "undefined" or "of type array"
  function getPostfixForTypeWarning(value) {
    var type = getPreciseType(value);
    switch (type) {
      case 'array':
      case 'object':
        return 'an ' + type;
      case 'boolean':
      case 'date':
      case 'regexp':
        return 'a ' + type;
      default:
        return type;
    }
  }

  // Returns class name of the object, if any.
  function getClassName(propValue) {
    if (!propValue.constructor || !propValue.constructor.name) {
      return ANONYMOUS;
    }
    return propValue.constructor.name;
  }

  ReactPropTypes.checkPropTypes = checkPropTypes_1;
  ReactPropTypes.PropTypes = ReactPropTypes;

  return ReactPropTypes;
};

/**
 * Copyright (c) 2013-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */

'use strict';





var factoryWithThrowingShims = function() {
  function shim(props, propName, componentName, location, propFullName, secret) {
    if (secret === ReactPropTypesSecret_1) {
      // It is still safe when called from React.
      return;
    }
    invariant_1(
      false,
      'Calling PropTypes validators directly is not supported by the `prop-types` package. ' +
      'Use PropTypes.checkPropTypes() to call them. ' +
      'Read more at http://fb.me/use-check-prop-types'
    );
  }
  shim.isRequired = shim;
  function getShim() {
    return shim;
  }
  // Important!
  // Keep this list in sync with production version in `./factoryWithTypeCheckers.js`.
  var ReactPropTypes = {
    array: shim,
    bool: shim,
    func: shim,
    number: shim,
    object: shim,
    string: shim,
    symbol: shim,

    any: shim,
    arrayOf: getShim,
    element: shim,
    instanceOf: getShim,
    node: shim,
    objectOf: getShim,
    oneOf: getShim,
    oneOfType: getShim,
    shape: getShim,
    exact: getShim
  };

  ReactPropTypes.checkPropTypes = emptyFunction_1;
  ReactPropTypes.PropTypes = ReactPropTypes;

  return ReactPropTypes;
};

var propTypes = createCommonjsModule(function (module) {
/**
 * Copyright (c) 2013-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */

if (process.env.NODE_ENV !== 'production') {
  var REACT_ELEMENT_TYPE = (typeof Symbol === 'function' &&
    Symbol.for &&
    Symbol.for('react.element')) ||
    0xeac7;

  var isValidElement$$1 = function(object) {
    return typeof object === 'object' &&
      object !== null &&
      object.$$typeof === REACT_ELEMENT_TYPE;
  };

  // By explicitly using `prop-types` you are opting into new development behavior.
  // http://fb.me/prop-types-in-prod
  var throwOnDirectAccess = true;
  module.exports = factoryWithTypeCheckers(isValidElement$$1, throwOnDirectAccess);
} else {
  // By explicitly using `prop-types` you are opting into new production behavior.
  // http://fb.me/prop-types-in-prod
  module.exports = factoryWithThrowingShims();
}
});

"use strict";

/**
 * Copyright (c) 2013-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * 
 */

function makeEmptyFunction$1(arg) {
  return function () {
    return arg;
  };
}

/**
 * This function accepts and discards inputs; it has no side effects. This is
 * primarily useful idiomatically for overridable function endpoints which
 * always need to be callable, since JS lacks a null-call idiom ala Cocoa.
 */
var emptyFunction$2 = function emptyFunction() {};

emptyFunction$2.thatReturns = makeEmptyFunction$1;
emptyFunction$2.thatReturnsFalse = makeEmptyFunction$1(false);
emptyFunction$2.thatReturnsTrue = makeEmptyFunction$1(true);
emptyFunction$2.thatReturnsNull = makeEmptyFunction$1(null);
emptyFunction$2.thatReturnsThis = function () {
  return this;
};
emptyFunction$2.thatReturnsArgument = function (arg) {
  return arg;
};

var emptyFunction_1$2 = emptyFunction$2;

/**
 * Copyright (c) 2013-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 */

'use strict';

/**
 * Use invariant() to assert state which your program assumes to be true.
 *
 * Provide sprintf-style format (only %s is supported) and arguments
 * to provide information about what broke and what you were
 * expecting.
 *
 * The invariant message will be stripped in production, but the invariant
 * will remain to ensure logic does not differ in production.
 */

var validateFormat$1 = function validateFormat(format) {};

if (process.env.NODE_ENV !== 'production') {
  validateFormat$1 = function validateFormat(format) {
    if (format === undefined) {
      throw new Error('invariant requires an error message argument');
    }
  };
}

function invariant$3(condition, format, a, b, c, d, e, f) {
  validateFormat$1(format);

  if (!condition) {
    var error;
    if (format === undefined) {
      error = new Error('Minified exception occurred; use the non-minified dev environment ' + 'for the full error message and additional helpful warnings.');
    } else {
      var args = [a, b, c, d, e, f];
      var argIndex = 0;
      error = new Error(format.replace(/%s/g, function () {
        return args[argIndex++];
      }));
      error.name = 'Invariant Violation';
    }

    error.framesToPop = 1; // we don't care about invariant's own frame
    throw error;
  }
}

var invariant_1$2 = invariant$3;

/**
 * Copyright 2014-2015, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 */

'use strict';



/**
 * Similar to invariant but only logs a warning if the condition is not met.
 * This can be used to log issues in development environments in critical
 * paths. Removing the logging code for production environments will keep the
 * same logic and follow the same code paths.
 */

var warning$2 = emptyFunction_1$2;

if (process.env.NODE_ENV !== 'production') {
  (function () {
    var printWarning = function printWarning(format) {
      for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }

      var argIndex = 0;
      var message = 'Warning: ' + format.replace(/%s/g, function () {
        return args[argIndex++];
      });
      if (typeof console !== 'undefined') {
        console.error(message);
      }
      try {
        // --- Welcome to debugging React ---
        // This error was thrown as a convenience so that you can use this stack
        // to find the callsite that caused this warning to fire.
        throw new Error(message);
      } catch (x) {}
    };

    warning$2 = function warning(condition, format) {
      if (format === undefined) {
        throw new Error('`warning(condition, format, ...args)` requires a warning ' + 'message argument');
      }

      if (format.indexOf('Failed Composite propType: ') === 0) {
        return; // Ignore CompositeComponent proptype check.
      }

      if (!condition) {
        for (var _len2 = arguments.length, args = Array(_len2 > 2 ? _len2 - 2 : 0), _key2 = 2; _key2 < _len2; _key2++) {
          args[_key2 - 2] = arguments[_key2];
        }

        printWarning.apply(undefined, [format].concat(args));
      }
    };
  })();
}

var warning_1$2 = warning$2;

/**
 * Copyright 2013-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 */

'use strict';

var ReactPropTypesSecret$3 = 'SECRET_DO_NOT_PASS_THIS_OR_YOU_WILL_BE_FIRED';

var ReactPropTypesSecret_1$2 = ReactPropTypesSecret$3;

/**
 * Copyright 2013-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 */

'use strict';

if (process.env.NODE_ENV !== 'production') {
  var invariant$4 = invariant_1$2;
  var warning$3 = warning_1$2;
  var ReactPropTypesSecret$4 = ReactPropTypesSecret_1$2;
  var loggedTypeFailures$1 = {};
}

/**
 * Assert that the values match with the type specs.
 * Error messages are memorized and will only be shown once.
 *
 * @param {object} typeSpecs Map of name to a ReactPropType
 * @param {object} values Runtime values that need to be type-checked
 * @param {string} location e.g. "prop", "context", "child context"
 * @param {string} componentName Name of the component for error messages.
 * @param {?Function} getStack Returns the component stack.
 * @private
 */
function checkPropTypes$2(typeSpecs, values, location, componentName, getStack) {
  if (process.env.NODE_ENV !== 'production') {
    for (var typeSpecName in typeSpecs) {
      if (typeSpecs.hasOwnProperty(typeSpecName)) {
        var error;
        // Prop type validation may throw. In case they do, we don't want to
        // fail the render phase where it didn't fail before. So we log it.
        // After these have been cleaned up, we'll let them throw.
        try {
          // This is intentionally an invariant that gets caught. It's the same
          // behavior as without this statement except with a better message.
          invariant$4(typeof typeSpecs[typeSpecName] === 'function', '%s: %s type `%s` is invalid; it must be a function, usually from ' + 'React.PropTypes.', componentName || 'React class', location, typeSpecName);
          error = typeSpecs[typeSpecName](values, typeSpecName, componentName, location, null, ReactPropTypesSecret$4);
        } catch (ex) {
          error = ex;
        }
        warning$3(!error || error instanceof Error, '%s: type specification of %s `%s` is invalid; the type checker ' + 'function must return `null` or an `Error` but returned a %s. ' + 'You may have forgotten to pass an argument to the type checker ' + 'creator (arrayOf, instanceOf, objectOf, oneOf, oneOfType, and ' + 'shape all require an argument).', componentName || 'React class', location, typeSpecName, typeof error);
        if (error instanceof Error && !(error.message in loggedTypeFailures$1)) {
          // Only monitor this failure once because there tends to be a lot of the
          // same error.
          loggedTypeFailures$1[error.message] = true;

          var stack = getStack ? getStack() : '';

          warning$3(false, 'Failed %s type: %s%s', location, error.message, stack != null ? stack : '');
        }
      }
    }
  }
}

var checkPropTypes_1$2 = checkPropTypes$2;

/**
 * Copyright 2013-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 */

'use strict';








var factoryWithTypeCheckers$2 = function(isValidElement$$1, throwOnDirectAccess) {
  /* global Symbol */
  var ITERATOR_SYMBOL = typeof Symbol === 'function' && Symbol.iterator;
  var FAUX_ITERATOR_SYMBOL = '@@iterator'; // Before Symbol spec.

  /**
   * Returns the iterator method function contained on the iterable object.
   *
   * Be sure to invoke the function with the iterable as context:
   *
   *     var iteratorFn = getIteratorFn(myIterable);
   *     if (iteratorFn) {
   *       var iterator = iteratorFn.call(myIterable);
   *       ...
   *     }
   *
   * @param {?object} maybeIterable
   * @return {?function}
   */
  function getIteratorFn(maybeIterable) {
    var iteratorFn = maybeIterable && (ITERATOR_SYMBOL && maybeIterable[ITERATOR_SYMBOL] || maybeIterable[FAUX_ITERATOR_SYMBOL]);
    if (typeof iteratorFn === 'function') {
      return iteratorFn;
    }
  }

  /**
   * Collection of methods that allow declaration and validation of props that are
   * supplied to React components. Example usage:
   *
   *   var Props = require('ReactPropTypes');
   *   var MyArticle = React.createClass({
   *     propTypes: {
   *       // An optional string prop named "description".
   *       description: Props.string,
   *
   *       // A required enum prop named "category".
   *       category: Props.oneOf(['News','Photos']).isRequired,
   *
   *       // A prop named "dialog" that requires an instance of Dialog.
   *       dialog: Props.instanceOf(Dialog).isRequired
   *     },
   *     render: function() { ... }
   *   });
   *
   * A more formal specification of how these methods are used:
   *
   *   type := array|bool|func|object|number|string|oneOf([...])|instanceOf(...)
   *   decl := ReactPropTypes.{type}(.isRequired)?
   *
   * Each and every declaration produces a function with the same signature. This
   * allows the creation of custom validation functions. For example:
   *
   *  var MyLink = React.createClass({
   *    propTypes: {
   *      // An optional string or URI prop named "href".
   *      href: function(props, propName, componentName) {
   *        var propValue = props[propName];
   *        if (propValue != null && typeof propValue !== 'string' &&
   *            !(propValue instanceof URI)) {
   *          return new Error(
   *            'Expected a string or an URI for ' + propName + ' in ' +
   *            componentName
   *          );
   *        }
   *      }
   *    },
   *    render: function() {...}
   *  });
   *
   * @internal
   */

  var ANONYMOUS = '<<anonymous>>';

  // Important!
  // Keep this list in sync with production version in `./factoryWithThrowingShims.js`.
  var ReactPropTypes = {
    array: createPrimitiveTypeChecker('array'),
    bool: createPrimitiveTypeChecker('boolean'),
    func: createPrimitiveTypeChecker('function'),
    number: createPrimitiveTypeChecker('number'),
    object: createPrimitiveTypeChecker('object'),
    string: createPrimitiveTypeChecker('string'),
    symbol: createPrimitiveTypeChecker('symbol'),

    any: createAnyTypeChecker(),
    arrayOf: createArrayOfTypeChecker,
    element: createElementTypeChecker(),
    instanceOf: createInstanceTypeChecker,
    node: createNodeChecker(),
    objectOf: createObjectOfTypeChecker,
    oneOf: createEnumTypeChecker,
    oneOfType: createUnionTypeChecker,
    shape: createShapeTypeChecker
  };

  /**
   * inlined Object.is polyfill to avoid requiring consumers ship their own
   * https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/is
   */
  /*eslint-disable no-self-compare*/
  function is(x, y) {
    // SameValue algorithm
    if (x === y) {
      // Steps 1-5, 7-10
      // Steps 6.b-6.e: +0 != -0
      return x !== 0 || 1 / x === 1 / y;
    } else {
      // Step 6.a: NaN == NaN
      return x !== x && y !== y;
    }
  }
  /*eslint-enable no-self-compare*/

  /**
   * We use an Error-like object for backward compatibility as people may call
   * PropTypes directly and inspect their output. However, we don't use real
   * Errors anymore. We don't inspect their stack anyway, and creating them
   * is prohibitively expensive if they are created too often, such as what
   * happens in oneOfType() for any type before the one that matched.
   */
  function PropTypeError(message) {
    this.message = message;
    this.stack = '';
  }
  // Make `instanceof Error` still work for returned errors.
  PropTypeError.prototype = Error.prototype;

  function createChainableTypeChecker(validate) {
    if (process.env.NODE_ENV !== 'production') {
      var manualPropTypeCallCache = {};
      var manualPropTypeWarningCount = 0;
    }
    function checkType(isRequired, props, propName, componentName, location, propFullName, secret) {
      componentName = componentName || ANONYMOUS;
      propFullName = propFullName || propName;

      if (secret !== ReactPropTypesSecret_1$2) {
        if (throwOnDirectAccess) {
          // New behavior only for users of `prop-types` package
          invariant_1$2(
            false,
            'Calling PropTypes validators directly is not supported by the `prop-types` package. ' +
            'Use `PropTypes.checkPropTypes()` to call them. ' +
            'Read more at http://fb.me/use-check-prop-types'
          );
        } else if (process.env.NODE_ENV !== 'production' && typeof console !== 'undefined') {
          // Old behavior for people using React.PropTypes
          var cacheKey = componentName + ':' + propName;
          if (
            !manualPropTypeCallCache[cacheKey] &&
            // Avoid spamming the console because they are often not actionable except for lib authors
            manualPropTypeWarningCount < 3
          ) {
            warning_1$2(
              false,
              'You are manually calling a React.PropTypes validation ' +
              'function for the `%s` prop on `%s`. This is deprecated ' +
              'and will throw in the standalone `prop-types` package. ' +
              'You may be seeing this warning due to a third-party PropTypes ' +
              'library. See https://fb.me/react-warning-dont-call-proptypes ' + 'for details.',
              propFullName,
              componentName
            );
            manualPropTypeCallCache[cacheKey] = true;
            manualPropTypeWarningCount++;
          }
        }
      }
      if (props[propName] == null) {
        if (isRequired) {
          if (props[propName] === null) {
            return new PropTypeError('The ' + location + ' `' + propFullName + '` is marked as required ' + ('in `' + componentName + '`, but its value is `null`.'));
          }
          return new PropTypeError('The ' + location + ' `' + propFullName + '` is marked as required in ' + ('`' + componentName + '`, but its value is `undefined`.'));
        }
        return null;
      } else {
        return validate(props, propName, componentName, location, propFullName);
      }
    }

    var chainedCheckType = checkType.bind(null, false);
    chainedCheckType.isRequired = checkType.bind(null, true);

    return chainedCheckType;
  }

  function createPrimitiveTypeChecker(expectedType) {
    function validate(props, propName, componentName, location, propFullName, secret) {
      var propValue = props[propName];
      var propType = getPropType(propValue);
      if (propType !== expectedType) {
        // `propValue` being instance of, say, date/regexp, pass the 'object'
        // check, but we can offer a more precise error message here rather than
        // 'of type `object`'.
        var preciseType = getPreciseType(propValue);

        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + preciseType + '` supplied to `' + componentName + '`, expected ') + ('`' + expectedType + '`.'));
      }
      return null;
    }
    return createChainableTypeChecker(validate);
  }

  function createAnyTypeChecker() {
    return createChainableTypeChecker(emptyFunction_1$2.thatReturnsNull);
  }

  function createArrayOfTypeChecker(typeChecker) {
    function validate(props, propName, componentName, location, propFullName) {
      if (typeof typeChecker !== 'function') {
        return new PropTypeError('Property `' + propFullName + '` of component `' + componentName + '` has invalid PropType notation inside arrayOf.');
      }
      var propValue = props[propName];
      if (!Array.isArray(propValue)) {
        var propType = getPropType(propValue);
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + propType + '` supplied to `' + componentName + '`, expected an array.'));
      }
      for (var i = 0; i < propValue.length; i++) {
        var error = typeChecker(propValue, i, componentName, location, propFullName + '[' + i + ']', ReactPropTypesSecret_1$2);
        if (error instanceof Error) {
          return error;
        }
      }
      return null;
    }
    return createChainableTypeChecker(validate);
  }

  function createElementTypeChecker() {
    function validate(props, propName, componentName, location, propFullName) {
      var propValue = props[propName];
      if (!isValidElement$$1(propValue)) {
        var propType = getPropType(propValue);
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + propType + '` supplied to `' + componentName + '`, expected a single ReactElement.'));
      }
      return null;
    }
    return createChainableTypeChecker(validate);
  }

  function createInstanceTypeChecker(expectedClass) {
    function validate(props, propName, componentName, location, propFullName) {
      if (!(props[propName] instanceof expectedClass)) {
        var expectedClassName = expectedClass.name || ANONYMOUS;
        var actualClassName = getClassName(props[propName]);
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + actualClassName + '` supplied to `' + componentName + '`, expected ') + ('instance of `' + expectedClassName + '`.'));
      }
      return null;
    }
    return createChainableTypeChecker(validate);
  }

  function createEnumTypeChecker(expectedValues) {
    if (!Array.isArray(expectedValues)) {
      process.env.NODE_ENV !== 'production' ? warning_1$2(false, 'Invalid argument supplied to oneOf, expected an instance of array.') : void 0;
      return emptyFunction_1$2.thatReturnsNull;
    }

    function validate(props, propName, componentName, location, propFullName) {
      var propValue = props[propName];
      for (var i = 0; i < expectedValues.length; i++) {
        if (is(propValue, expectedValues[i])) {
          return null;
        }
      }

      var valuesString = JSON.stringify(expectedValues);
      return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of value `' + propValue + '` ' + ('supplied to `' + componentName + '`, expected one of ' + valuesString + '.'));
    }
    return createChainableTypeChecker(validate);
  }

  function createObjectOfTypeChecker(typeChecker) {
    function validate(props, propName, componentName, location, propFullName) {
      if (typeof typeChecker !== 'function') {
        return new PropTypeError('Property `' + propFullName + '` of component `' + componentName + '` has invalid PropType notation inside objectOf.');
      }
      var propValue = props[propName];
      var propType = getPropType(propValue);
      if (propType !== 'object') {
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + propType + '` supplied to `' + componentName + '`, expected an object.'));
      }
      for (var key in propValue) {
        if (propValue.hasOwnProperty(key)) {
          var error = typeChecker(propValue, key, componentName, location, propFullName + '.' + key, ReactPropTypesSecret_1$2);
          if (error instanceof Error) {
            return error;
          }
        }
      }
      return null;
    }
    return createChainableTypeChecker(validate);
  }

  function createUnionTypeChecker(arrayOfTypeCheckers) {
    if (!Array.isArray(arrayOfTypeCheckers)) {
      process.env.NODE_ENV !== 'production' ? warning_1$2(false, 'Invalid argument supplied to oneOfType, expected an instance of array.') : void 0;
      return emptyFunction_1$2.thatReturnsNull;
    }

    for (var i = 0; i < arrayOfTypeCheckers.length; i++) {
      var checker = arrayOfTypeCheckers[i];
      if (typeof checker !== 'function') {
        warning_1$2(
          false,
          'Invalid argument supplid to oneOfType. Expected an array of check functions, but ' +
          'received %s at index %s.',
          getPostfixForTypeWarning(checker),
          i
        );
        return emptyFunction_1$2.thatReturnsNull;
      }
    }

    function validate(props, propName, componentName, location, propFullName) {
      for (var i = 0; i < arrayOfTypeCheckers.length; i++) {
        var checker = arrayOfTypeCheckers[i];
        if (checker(props, propName, componentName, location, propFullName, ReactPropTypesSecret_1$2) == null) {
          return null;
        }
      }

      return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` supplied to ' + ('`' + componentName + '`.'));
    }
    return createChainableTypeChecker(validate);
  }

  function createNodeChecker() {
    function validate(props, propName, componentName, location, propFullName) {
      if (!isNode(props[propName])) {
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` supplied to ' + ('`' + componentName + '`, expected a ReactNode.'));
      }
      return null;
    }
    return createChainableTypeChecker(validate);
  }

  function createShapeTypeChecker(shapeTypes) {
    function validate(props, propName, componentName, location, propFullName) {
      var propValue = props[propName];
      var propType = getPropType(propValue);
      if (propType !== 'object') {
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type `' + propType + '` ' + ('supplied to `' + componentName + '`, expected `object`.'));
      }
      for (var key in shapeTypes) {
        var checker = shapeTypes[key];
        if (!checker) {
          continue;
        }
        var error = checker(propValue, key, componentName, location, propFullName + '.' + key, ReactPropTypesSecret_1$2);
        if (error) {
          return error;
        }
      }
      return null;
    }
    return createChainableTypeChecker(validate);
  }

  function isNode(propValue) {
    switch (typeof propValue) {
      case 'number':
      case 'string':
      case 'undefined':
        return true;
      case 'boolean':
        return !propValue;
      case 'object':
        if (Array.isArray(propValue)) {
          return propValue.every(isNode);
        }
        if (propValue === null || isValidElement$$1(propValue)) {
          return true;
        }

        var iteratorFn = getIteratorFn(propValue);
        if (iteratorFn) {
          var iterator = iteratorFn.call(propValue);
          var step;
          if (iteratorFn !== propValue.entries) {
            while (!(step = iterator.next()).done) {
              if (!isNode(step.value)) {
                return false;
              }
            }
          } else {
            // Iterator will provide entry [k,v] tuples rather than values.
            while (!(step = iterator.next()).done) {
              var entry = step.value;
              if (entry) {
                if (!isNode(entry[1])) {
                  return false;
                }
              }
            }
          }
        } else {
          return false;
        }

        return true;
      default:
        return false;
    }
  }

  function isSymbol(propType, propValue) {
    // Native Symbol.
    if (propType === 'symbol') {
      return true;
    }

    // 19.4.3.5 Symbol.prototype[@@toStringTag] === 'Symbol'
    if (propValue['@@toStringTag'] === 'Symbol') {
      return true;
    }

    // Fallback for non-spec compliant Symbols which are polyfilled.
    if (typeof Symbol === 'function' && propValue instanceof Symbol) {
      return true;
    }

    return false;
  }

  // Equivalent of `typeof` but with special handling for array and regexp.
  function getPropType(propValue) {
    var propType = typeof propValue;
    if (Array.isArray(propValue)) {
      return 'array';
    }
    if (propValue instanceof RegExp) {
      // Old webkits (at least until Android 4.0) return 'function' rather than
      // 'object' for typeof a RegExp. We'll normalize this here so that /bla/
      // passes PropTypes.object.
      return 'object';
    }
    if (isSymbol(propType, propValue)) {
      return 'symbol';
    }
    return propType;
  }

  // This handles more types than `getPropType`. Only used for error messages.
  // See `createPrimitiveTypeChecker`.
  function getPreciseType(propValue) {
    if (typeof propValue === 'undefined' || propValue === null) {
      return '' + propValue;
    }
    var propType = getPropType(propValue);
    if (propType === 'object') {
      if (propValue instanceof Date) {
        return 'date';
      } else if (propValue instanceof RegExp) {
        return 'regexp';
      }
    }
    return propType;
  }

  // Returns a string that is postfixed to a warning about an invalid type.
  // For example, "undefined" or "of type array"
  function getPostfixForTypeWarning(value) {
    var type = getPreciseType(value);
    switch (type) {
      case 'array':
      case 'object':
        return 'an ' + type;
      case 'boolean':
      case 'date':
      case 'regexp':
        return 'a ' + type;
      default:
        return type;
    }
  }

  // Returns class name of the object, if any.
  function getClassName(propValue) {
    if (!propValue.constructor || !propValue.constructor.name) {
      return ANONYMOUS;
    }
    return propValue.constructor.name;
  }

  ReactPropTypes.checkPropTypes = checkPropTypes_1$2;
  ReactPropTypes.PropTypes = ReactPropTypes;

  return ReactPropTypes;
};

/**
 * Copyright 2013-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 */

'use strict';





var factoryWithThrowingShims$2 = function() {
  function shim(props, propName, componentName, location, propFullName, secret) {
    if (secret === ReactPropTypesSecret_1$2) {
      // It is still safe when called from React.
      return;
    }
    invariant_1$2(
      false,
      'Calling PropTypes validators directly is not supported by the `prop-types` package. ' +
      'Use PropTypes.checkPropTypes() to call them. ' +
      'Read more at http://fb.me/use-check-prop-types'
    );
  }
  shim.isRequired = shim;
  function getShim() {
    return shim;
  }
  // Important!
  // Keep this list in sync with production version in `./factoryWithTypeCheckers.js`.
  var ReactPropTypes = {
    array: shim,
    bool: shim,
    func: shim,
    number: shim,
    object: shim,
    string: shim,
    symbol: shim,

    any: shim,
    arrayOf: getShim,
    element: shim,
    instanceOf: getShim,
    node: shim,
    objectOf: getShim,
    oneOf: getShim,
    oneOfType: getShim,
    shape: getShim
  };

  ReactPropTypes.checkPropTypes = emptyFunction_1$2;
  ReactPropTypes.PropTypes = ReactPropTypes;

  return ReactPropTypes;
};

var propTypes$1 = createCommonjsModule(function (module) {
/**
 * Copyright 2013-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 */

if (process.env.NODE_ENV !== 'production') {
  var REACT_ELEMENT_TYPE = (typeof Symbol === 'function' &&
    Symbol.for &&
    Symbol.for('react.element')) ||
    0xeac7;

  var isValidElement$$1 = function(object) {
    return typeof object === 'object' &&
      object !== null &&
      object.$$typeof === REACT_ELEMENT_TYPE;
  };

  // By explicitly using `prop-types` you are opting into new development behavior.
  // http://fb.me/prop-types-in-prod
  var throwOnDirectAccess = true;
  module.exports = factoryWithTypeCheckers$2(isValidElement$$1, throwOnDirectAccess);
} else {
  // By explicitly using `prop-types` you are opting into new production behavior.
  // http://fb.me/prop-types-in-prod
  module.exports = factoryWithThrowingShims$2();
}
});

var chainFunction = function chain(){
  var len = arguments.length;
  var args = [];

  for (var i = 0; i < len; i++)
    args[i] = arguments[i];

  args = args.filter(function(fn){ return fn != null });

  if (args.length === 0) return undefined
  if (args.length === 1) return args[0]

  return args.reduce(function(current, next){
    return function chainedFunction() {
      current.apply(this, arguments);
      next.apply(this, arguments);
    };
  })
};

/**
 * Copyright 2014-2015, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 */

'use strict';

/**
 * Similar to invariant but only logs a warning if the condition is not met.
 * This can be used to log issues in development environments in critical
 * paths. Removing the logging code for production environments will keep the
 * same logic and follow the same code paths.
 */

var warning$4 = function() {};

if (process.env.NODE_ENV !== 'production') {
  warning$4 = function(condition, format, args) {
    var len = arguments.length;
    args = new Array(len > 2 ? len - 2 : 0);
    for (var key = 2; key < len; key++) {
      args[key - 2] = arguments[key];
    }
    if (format === undefined) {
      throw new Error(
        '`warning(condition, format, ...args)` requires a warning ' +
        'message argument'
      );
    }

    if (format.length < 10 || (/^[s\W]*$/).test(format)) {
      throw new Error(
        'The warning format should be able to uniquely identify this ' +
        'warning. Please, use a more descriptive format than: ' + format
      );
    }

    if (!condition) {
      var argIndex = 0;
      var message = 'Warning: ' +
        format.replace(/%s/g, function() {
          return args[argIndex++];
        });
      if (typeof console !== 'undefined') {
        console.error(message);
      }
      try {
        // This error was thrown as a convenience so that you can use this stack
        // to find the callsite that caused this warning to fire.
        throw new Error(message);
      } catch(x) {}
    }
  };
}

var browser = warning$4;

var ChildMapping = createCommonjsModule(function (module, exports) {
'use strict';

exports.__esModule = true;
exports.getChildMapping = getChildMapping;
exports.mergeChildMappings = mergeChildMappings;



/**
 * Given `this.props.children`, return an object mapping key to child.
 *
 * @param {*} children `this.props.children`
 * @return {object} Mapping of key to child
 */
function getChildMapping(children) {
  if (!children) {
    return children;
  }
  var result = {};
  React.Children.map(children, function (child) {
    return child;
  }).forEach(function (child) {
    result[child.key] = child;
  });
  return result;
}

/**
 * When you're adding or removing children some may be added or removed in the
 * same render pass. We want to show *both* since we want to simultaneously
 * animate elements in and out. This function takes a previous set of keys
 * and a new set of keys and merges them with its best guess of the correct
 * ordering. In the future we may expose some of the utilities in
 * ReactMultiChild to make this easy, but for now React itself does not
 * directly have this concept of the union of prevChildren and nextChildren
 * so we implement it here.
 *
 * @param {object} prev prev children as returned from
 * `ReactTransitionChildMapping.getChildMapping()`.
 * @param {object} next next children as returned from
 * `ReactTransitionChildMapping.getChildMapping()`.
 * @return {object} a key set that contains all keys in `prev` and all keys
 * in `next` in a reasonable order.
 */
function mergeChildMappings(prev, next) {
  prev = prev || {};
  next = next || {};

  function getValueForKey(key) {
    if (next.hasOwnProperty(key)) {
      return next[key];
    }

    return prev[key];
  }

  // For each key of `next`, the list of keys to insert before that key in
  // the combined list
  var nextKeysPending = {};

  var pendingKeys = [];
  for (var prevKey in prev) {
    if (next.hasOwnProperty(prevKey)) {
      if (pendingKeys.length) {
        nextKeysPending[prevKey] = pendingKeys;
        pendingKeys = [];
      }
    } else {
      pendingKeys.push(prevKey);
    }
  }

  var i = void 0;
  var childMapping = {};
  for (var nextKey in next) {
    if (nextKeysPending.hasOwnProperty(nextKey)) {
      for (i = 0; i < nextKeysPending[nextKey].length; i++) {
        var pendingNextKey = nextKeysPending[nextKey][i];
        childMapping[nextKeysPending[nextKey][i]] = getValueForKey(pendingNextKey);
      }
    }
    childMapping[nextKey] = getValueForKey(nextKey);
  }

  // Finally, add the keys which didn't appear before any key in `next`
  for (i = 0; i < pendingKeys.length; i++) {
    childMapping[pendingKeys[i]] = getValueForKey(pendingKeys[i]);
  }

  return childMapping;
}
});

unwrapExports(ChildMapping);

var TransitionGroup_1 = createCommonjsModule(function (module, exports) {
'use strict';

exports.__esModule = true;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };



var _chainFunction2 = _interopRequireDefault(chainFunction);



var _react2 = _interopRequireDefault(React);



var _propTypes2 = _interopRequireDefault(propTypes$1);



var _warning2 = _interopRequireDefault(browser);



function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var propTypes = {
  component: _propTypes2.default.any,
  childFactory: _propTypes2.default.func,
  children: _propTypes2.default.node
};

var defaultProps = {
  component: 'span',
  childFactory: function childFactory(child) {
    return child;
  }
};

var TransitionGroup = function (_React$Component) {
  _inherits(TransitionGroup, _React$Component);

  function TransitionGroup(props, context) {
    _classCallCheck(this, TransitionGroup);

    var _this = _possibleConstructorReturn(this, _React$Component.call(this, props, context));

    _this.performAppear = function (key, component) {
      _this.currentlyTransitioningKeys[key] = true;

      if (component.componentWillAppear) {
        component.componentWillAppear(_this._handleDoneAppearing.bind(_this, key, component));
      } else {
        _this._handleDoneAppearing(key, component);
      }
    };

    _this._handleDoneAppearing = function (key, component) {
      if (component.componentDidAppear) {
        component.componentDidAppear();
      }

      delete _this.currentlyTransitioningKeys[key];

      var currentChildMapping = (0, ChildMapping.getChildMapping)(_this.props.children);

      if (!currentChildMapping || !currentChildMapping.hasOwnProperty(key)) {
        // This was removed before it had fully appeared. Remove it.
        _this.performLeave(key, component);
      }
    };

    _this.performEnter = function (key, component) {
      _this.currentlyTransitioningKeys[key] = true;

      if (component.componentWillEnter) {
        component.componentWillEnter(_this._handleDoneEntering.bind(_this, key, component));
      } else {
        _this._handleDoneEntering(key, component);
      }
    };

    _this._handleDoneEntering = function (key, component) {
      if (component.componentDidEnter) {
        component.componentDidEnter();
      }

      delete _this.currentlyTransitioningKeys[key];

      var currentChildMapping = (0, ChildMapping.getChildMapping)(_this.props.children);

      if (!currentChildMapping || !currentChildMapping.hasOwnProperty(key)) {
        // This was removed before it had fully entered. Remove it.
        _this.performLeave(key, component);
      }
    };

    _this.performLeave = function (key, component) {
      _this.currentlyTransitioningKeys[key] = true;

      if (component.componentWillLeave) {
        component.componentWillLeave(_this._handleDoneLeaving.bind(_this, key, component));
      } else {
        // Note that this is somewhat dangerous b/c it calls setState()
        // again, effectively mutating the component before all the work
        // is done.
        _this._handleDoneLeaving(key, component);
      }
    };

    _this._handleDoneLeaving = function (key, component) {
      if (component.componentDidLeave) {
        component.componentDidLeave();
      }

      delete _this.currentlyTransitioningKeys[key];

      var currentChildMapping = (0, ChildMapping.getChildMapping)(_this.props.children);

      if (currentChildMapping && currentChildMapping.hasOwnProperty(key)) {
        // This entered again before it fully left. Add it again.
        _this.keysToEnter.push(key);
      } else {
        _this.setState(function (state) {
          var newChildren = _extends({}, state.children);
          delete newChildren[key];
          return { children: newChildren };
        });
      }
    };

    _this.childRefs = Object.create(null);

    _this.state = {
      children: (0, ChildMapping.getChildMapping)(props.children)
    };
    return _this;
  }

  TransitionGroup.prototype.componentWillMount = function componentWillMount() {
    this.currentlyTransitioningKeys = {};
    this.keysToEnter = [];
    this.keysToLeave = [];
  };

  TransitionGroup.prototype.componentDidMount = function componentDidMount() {
    var initialChildMapping = this.state.children;
    for (var key in initialChildMapping) {
      if (initialChildMapping[key]) {
        this.performAppear(key, this.childRefs[key]);
      }
    }
  };

  TransitionGroup.prototype.componentWillReceiveProps = function componentWillReceiveProps(nextProps) {
    var nextChildMapping = (0, ChildMapping.getChildMapping)(nextProps.children);
    var prevChildMapping = this.state.children;

    this.setState({
      children: (0, ChildMapping.mergeChildMappings)(prevChildMapping, nextChildMapping)
    });

    for (var key in nextChildMapping) {
      var hasPrev = prevChildMapping && prevChildMapping.hasOwnProperty(key);
      if (nextChildMapping[key] && !hasPrev && !this.currentlyTransitioningKeys[key]) {
        this.keysToEnter.push(key);
      }
    }

    for (var _key in prevChildMapping) {
      var hasNext = nextChildMapping && nextChildMapping.hasOwnProperty(_key);
      if (prevChildMapping[_key] && !hasNext && !this.currentlyTransitioningKeys[_key]) {
        this.keysToLeave.push(_key);
      }
    }

    // If we want to someday check for reordering, we could do it here.
  };

  TransitionGroup.prototype.componentDidUpdate = function componentDidUpdate() {
    var _this2 = this;

    var keysToEnter = this.keysToEnter;
    this.keysToEnter = [];
    keysToEnter.forEach(function (key) {
      return _this2.performEnter(key, _this2.childRefs[key]);
    });

    var keysToLeave = this.keysToLeave;
    this.keysToLeave = [];
    keysToLeave.forEach(function (key) {
      return _this2.performLeave(key, _this2.childRefs[key]);
    });
  };

  TransitionGroup.prototype.render = function render() {
    var _this3 = this;

    // TODO: we could get rid of the need for the wrapper node
    // by cloning a single child
    var childrenToRender = [];

    var _loop = function _loop(key) {
      var child = _this3.state.children[key];
      if (child) {
        var isCallbackRef = typeof child.ref !== 'string';
        var factoryChild = _this3.props.childFactory(child);
        var ref = function ref(r) {
          _this3.childRefs[key] = r;
        };

        process.env.NODE_ENV !== 'production' ? (0, _warning2.default)(isCallbackRef, 'string refs are not supported on children of TransitionGroup and will be ignored. ' + 'Please use a callback ref instead: https://facebook.github.io/react/docs/refs-and-the-dom.html#the-ref-callback-attribute') : void 0;

        // Always chaining the refs leads to problems when the childFactory
        // wraps the child. The child ref callback gets called twice with the
        // wrapper and the child. So we only need to chain the ref if the
        // factoryChild is not different from child.
        if (factoryChild === child && isCallbackRef) {
          ref = (0, _chainFunction2.default)(child.ref, ref);
        }

        // You may need to apply reactive updates to a child as it is leaving.
        // The normal React way to do it won't work since the child will have
        // already been removed. In case you need this behavior you can provide
        // a childFactory function to wrap every child, even the ones that are
        // leaving.
        childrenToRender.push(_react2.default.cloneElement(factoryChild, {
          key: key,
          ref: ref
        }));
      }
    };

    for (var key in this.state.children) {
      _loop(key);
    }

    // Do not forward TransitionGroup props to primitive DOM nodes
    var props = _extends({}, this.props);
    delete props.transitionLeave;
    delete props.transitionName;
    delete props.transitionAppear;
    delete props.transitionEnter;
    delete props.childFactory;
    delete props.transitionLeaveTimeout;
    delete props.transitionEnterTimeout;
    delete props.transitionAppearTimeout;
    delete props.component;

    return _react2.default.createElement(this.props.component, props, childrenToRender);
  };

  return TransitionGroup;
}(_react2.default.Component);

TransitionGroup.displayName = 'TransitionGroup';


TransitionGroup.propTypes = process.env.NODE_ENV !== "production" ? propTypes : {};
TransitionGroup.defaultProps = defaultProps;

exports.default = TransitionGroup;
module.exports = exports['default'];
});

var TransitionGroup = unwrapExports(TransitionGroup_1);

var hasClass_1 = createCommonjsModule(function (module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = hasClass;
function hasClass(element, className) {
  if (element.classList) return !!className && element.classList.contains(className);else return (" " + element.className + " ").indexOf(" " + className + " ") !== -1;
}
module.exports = exports["default"];
});

unwrapExports(hasClass_1);

var addClass_1 = createCommonjsModule(function (module, exports) {
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = addClass;



var _hasClass2 = _interopRequireDefault(hasClass_1);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function addClass(element, className) {
  if (element.classList) element.classList.add(className);else if (!(0, _hasClass2.default)(element)) element.className = element.className + ' ' + className;
}
module.exports = exports['default'];
});

unwrapExports(addClass_1);

'use strict';

var removeClass = function removeClass(element, className) {
  if (element.classList) element.classList.remove(className);else element.className = element.className.replace(new RegExp('(^|\\s)' + className + '(?:\\s|$)', 'g'), '$1').replace(/\s+/g, ' ').replace(/^\s*|\s*$/g, '');
};

var inDOM = createCommonjsModule(function (module, exports) {
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = !!(typeof window !== 'undefined' && window.document && window.document.createElement);
module.exports = exports['default'];
});

unwrapExports(inDOM);

var requestAnimationFrame$1 = createCommonjsModule(function (module, exports) {
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});



var _inDOM2 = _interopRequireDefault(inDOM);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var vendors = ['', 'webkit', 'moz', 'o', 'ms'];
var cancel = 'clearTimeout';
var raf = fallback;
var compatRaf = void 0;

var getKey = function getKey(vendor, k) {
  return vendor + (!vendor ? k : k[0].toUpperCase() + k.substr(1)) + 'AnimationFrame';
};

if (_inDOM2.default) {
  vendors.some(function (vendor) {
    var rafKey = getKey(vendor, 'request');

    if (rafKey in window) {
      cancel = getKey(vendor, 'cancel');
      return raf = function raf(cb) {
        return window[rafKey](cb);
      };
    }
  });
}

/* https://github.com/component/raf */
var prev = new Date().getTime();
function fallback(fn) {
  var curr = new Date().getTime(),
      ms = Math.max(0, 16 - (curr - prev)),
      req = setTimeout(fn, ms);

  prev = curr;
  return req;
}

compatRaf = function compatRaf(cb) {
  return raf(cb);
};
compatRaf.cancel = function (id) {
  window[cancel] && typeof window[cancel] === 'function' && window[cancel](id);
};
exports.default = compatRaf;
module.exports = exports['default'];
});

unwrapExports(requestAnimationFrame$1);

var properties = createCommonjsModule(function (module, exports) {
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.animationEnd = exports.animationDelay = exports.animationTiming = exports.animationDuration = exports.animationName = exports.transitionEnd = exports.transitionDuration = exports.transitionDelay = exports.transitionTiming = exports.transitionProperty = exports.transform = undefined;



var _inDOM2 = _interopRequireDefault(inDOM);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var transform = 'transform';
var prefix = void 0,
    transitionEnd = void 0,
    animationEnd = void 0;
var transitionProperty = void 0,
    transitionDuration = void 0,
    transitionTiming = void 0,
    transitionDelay = void 0;
var animationName = void 0,
    animationDuration = void 0,
    animationTiming = void 0,
    animationDelay = void 0;

if (_inDOM2.default) {
  var _getTransitionPropert = getTransitionProperties();

  prefix = _getTransitionPropert.prefix;
  exports.transitionEnd = transitionEnd = _getTransitionPropert.transitionEnd;
  exports.animationEnd = animationEnd = _getTransitionPropert.animationEnd;


  exports.transform = transform = prefix + '-' + transform;
  exports.transitionProperty = transitionProperty = prefix + '-transition-property';
  exports.transitionDuration = transitionDuration = prefix + '-transition-duration';
  exports.transitionDelay = transitionDelay = prefix + '-transition-delay';
  exports.transitionTiming = transitionTiming = prefix + '-transition-timing-function';

  exports.animationName = animationName = prefix + '-animation-name';
  exports.animationDuration = animationDuration = prefix + '-animation-duration';
  exports.animationTiming = animationTiming = prefix + '-animation-delay';
  exports.animationDelay = animationDelay = prefix + '-animation-timing-function';
}

exports.transform = transform;
exports.transitionProperty = transitionProperty;
exports.transitionTiming = transitionTiming;
exports.transitionDelay = transitionDelay;
exports.transitionDuration = transitionDuration;
exports.transitionEnd = transitionEnd;
exports.animationName = animationName;
exports.animationDuration = animationDuration;
exports.animationTiming = animationTiming;
exports.animationDelay = animationDelay;
exports.animationEnd = animationEnd;
exports.default = {
  transform: transform,
  end: transitionEnd,
  property: transitionProperty,
  timing: transitionTiming,
  delay: transitionDelay,
  duration: transitionDuration
};


function getTransitionProperties() {
  var style = document.createElement('div').style;

  var vendorMap = {
    O: function O(e) {
      return 'o' + e.toLowerCase();
    },
    Moz: function Moz(e) {
      return e.toLowerCase();
    },
    Webkit: function Webkit(e) {
      return 'webkit' + e;
    },
    ms: function ms(e) {
      return 'MS' + e;
    }
  };

  var vendors = Object.keys(vendorMap);

  var transitionEnd = void 0,
      animationEnd = void 0;
  var prefix = '';

  for (var i = 0; i < vendors.length; i++) {
    var vendor = vendors[i];

    if (vendor + 'TransitionProperty' in style) {
      prefix = '-' + vendor.toLowerCase();
      transitionEnd = vendorMap[vendor]('TransitionEnd');
      animationEnd = vendorMap[vendor]('AnimationEnd');
      break;
    }
  }

  if (!transitionEnd && 'transitionProperty' in style) transitionEnd = 'transitionend';

  if (!animationEnd && 'animationName' in style) animationEnd = 'animationend';

  style = null;

  return { animationEnd: animationEnd, transitionEnd: transitionEnd, prefix: prefix };
}
});

unwrapExports(properties);

var PropTypes$1 = createCommonjsModule(function (module, exports) {
'use strict';

exports.__esModule = true;
exports.nameShape = undefined;
exports.transitionTimeout = transitionTimeout;



var _react2 = _interopRequireDefault(React);



var _propTypes2 = _interopRequireDefault(propTypes$1);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function transitionTimeout(transitionType) {
  var timeoutPropName = 'transition' + transitionType + 'Timeout';
  var enabledPropName = 'transition' + transitionType;

  return function (props) {
    // If the transition is enabled
    if (props[enabledPropName]) {
      // If no timeout duration is provided
      if (props[timeoutPropName] == null) {
        return new Error(timeoutPropName + ' wasn\'t supplied to CSSTransitionGroup: ' + 'this can cause unreliable animations and won\'t be supported in ' + 'a future version of React. See ' + 'https://fb.me/react-animation-transition-group-timeout for more ' + 'information.');

        // If the duration isn't a number
      } else if (typeof props[timeoutPropName] !== 'number') {
        return new Error(timeoutPropName + ' must be a number (in milliseconds)');
      }
    }

    return null;
  };
}

var nameShape = exports.nameShape = _propTypes2.default.oneOfType([_propTypes2.default.string, _propTypes2.default.shape({
  enter: _propTypes2.default.string,
  leave: _propTypes2.default.string,
  active: _propTypes2.default.string
}), _propTypes2.default.shape({
  enter: _propTypes2.default.string,
  enterActive: _propTypes2.default.string,
  leave: _propTypes2.default.string,
  leaveActive: _propTypes2.default.string,
  appear: _propTypes2.default.string,
  appearActive: _propTypes2.default.string
})]);
});

unwrapExports(PropTypes$1);

var CSSTransitionGroupChild_1 = createCommonjsModule(function (module, exports) {
'use strict';

exports.__esModule = true;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };



var _addClass2 = _interopRequireDefault(addClass_1);



var _removeClass2 = _interopRequireDefault(removeClass);



var _requestAnimationFrame2 = _interopRequireDefault(requestAnimationFrame$1);





var _react2 = _interopRequireDefault(React);



var _propTypes2 = _interopRequireDefault(propTypes$1);





function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var events = [];
if (properties.transitionEnd) events.push(properties.transitionEnd);
if (properties.animationEnd) events.push(properties.animationEnd);

function addEndListener(node, listener) {
  if (events.length) {
    events.forEach(function (e) {
      return node.addEventListener(e, listener, false);
    });
  } else {
    setTimeout(listener, 0);
  }

  return function () {
    if (!events.length) return;
    events.forEach(function (e) {
      return node.removeEventListener(e, listener, false);
    });
  };
}

var propTypes = {
  children: _propTypes2.default.node,
  name: PropTypes$1.nameShape.isRequired,

  // Once we require timeouts to be specified, we can remove the
  // boolean flags (appear etc.) and just accept a number
  // or a bool for the timeout flags (appearTimeout etc.)
  appear: _propTypes2.default.bool,
  enter: _propTypes2.default.bool,
  leave: _propTypes2.default.bool,
  appearTimeout: _propTypes2.default.number,
  enterTimeout: _propTypes2.default.number,
  leaveTimeout: _propTypes2.default.number
};

var CSSTransitionGroupChild = function (_React$Component) {
  _inherits(CSSTransitionGroupChild, _React$Component);

  function CSSTransitionGroupChild() {
    var _temp, _this, _ret;

    _classCallCheck(this, CSSTransitionGroupChild);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = _possibleConstructorReturn(this, _React$Component.call.apply(_React$Component, [this].concat(args))), _this), _this.componentWillAppear = function (done) {
      if (_this.props.appear) {
        _this.transition('appear', done, _this.props.appearTimeout);
      } else {
        done();
      }
    }, _this.componentWillEnter = function (done) {
      if (_this.props.enter) {
        _this.transition('enter', done, _this.props.enterTimeout);
      } else {
        done();
      }
    }, _this.componentWillLeave = function (done) {
      if (_this.props.leave) {
        _this.transition('leave', done, _this.props.leaveTimeout);
      } else {
        done();
      }
    }, _temp), _possibleConstructorReturn(_this, _ret);
  }

  CSSTransitionGroupChild.prototype.componentWillMount = function componentWillMount() {
    this.classNameAndNodeQueue = [];
    this.transitionTimeouts = [];
  };

  CSSTransitionGroupChild.prototype.componentWillUnmount = function componentWillUnmount() {
    this.unmounted = true;

    if (this.timeout) {
      clearTimeout(this.timeout);
    }
    this.transitionTimeouts.forEach(function (timeout) {
      clearTimeout(timeout);
    });

    this.classNameAndNodeQueue.length = 0;
  };

  CSSTransitionGroupChild.prototype.transition = function transition(animationType, finishCallback, timeout) {
    var node = (0, reactDom.findDOMNode)(this);

    if (!node) {
      if (finishCallback) {
        finishCallback();
      }
      return;
    }

    var className = this.props.name[animationType] || this.props.name + '-' + animationType;
    var activeClassName = this.props.name[animationType + 'Active'] || className + '-active';
    var timer = null;
    var removeListeners = void 0;

    (0, _addClass2.default)(node, className);

    // Need to do this to actually trigger a transition.
    this.queueClassAndNode(activeClassName, node);

    // Clean-up the animation after the specified delay
    var finish = function finish(e) {
      if (e && e.target !== node) {
        return;
      }

      clearTimeout(timer);
      if (removeListeners) removeListeners();

      (0, _removeClass2.default)(node, className);
      (0, _removeClass2.default)(node, activeClassName);

      if (removeListeners) removeListeners();

      // Usually this optional callback is used for informing an owner of
      // a leave animation and telling it to remove the child.
      if (finishCallback) {
        finishCallback();
      }
    };

    if (timeout) {
      timer = setTimeout(finish, timeout);
      this.transitionTimeouts.push(timer);
    } else if (properties.transitionEnd) {
      removeListeners = addEndListener(node, finish);
    }
  };

  CSSTransitionGroupChild.prototype.queueClassAndNode = function queueClassAndNode(className, node) {
    var _this2 = this;

    this.classNameAndNodeQueue.push({
      className: className,
      node: node
    });

    if (!this.rafHandle) {
      this.rafHandle = (0, _requestAnimationFrame2.default)(function () {
        return _this2.flushClassNameAndNodeQueue();
      });
    }
  };

  CSSTransitionGroupChild.prototype.flushClassNameAndNodeQueue = function flushClassNameAndNodeQueue() {
    if (!this.unmounted) {
      this.classNameAndNodeQueue.forEach(function (obj) {
        // This is for to force a repaint,
        // which is necessary in order to transition styles when adding a class name.
        /* eslint-disable no-unused-expressions */
        obj.node.scrollTop;
        /* eslint-enable no-unused-expressions */
        (0, _addClass2.default)(obj.node, obj.className);
      });
    }
    this.classNameAndNodeQueue.length = 0;
    this.rafHandle = null;
  };

  CSSTransitionGroupChild.prototype.render = function render() {
    var props = _extends({}, this.props);
    delete props.name;
    delete props.appear;
    delete props.enter;
    delete props.leave;
    delete props.appearTimeout;
    delete props.enterTimeout;
    delete props.leaveTimeout;
    delete props.children;
    return _react2.default.cloneElement(_react2.default.Children.only(this.props.children), props);
  };

  return CSSTransitionGroupChild;
}(_react2.default.Component);

CSSTransitionGroupChild.displayName = 'CSSTransitionGroupChild';


CSSTransitionGroupChild.propTypes = process.env.NODE_ENV !== "production" ? propTypes : {};

exports.default = CSSTransitionGroupChild;
module.exports = exports['default'];
});

unwrapExports(CSSTransitionGroupChild_1);

var CSSTransitionGroup_1 = createCommonjsModule(function (module, exports) {
'use strict';

exports.__esModule = true;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };



var _react2 = _interopRequireDefault(React);



var _propTypes2 = _interopRequireDefault(propTypes$1);



var _TransitionGroup2 = _interopRequireDefault(TransitionGroup_1);



var _CSSTransitionGroupChild2 = _interopRequireDefault(CSSTransitionGroupChild_1);



function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var propTypes = {
  transitionName: PropTypes$1.nameShape.isRequired,

  transitionAppear: _propTypes2.default.bool,
  transitionEnter: _propTypes2.default.bool,
  transitionLeave: _propTypes2.default.bool,
  transitionAppearTimeout: (0, PropTypes$1.transitionTimeout)('Appear'),
  transitionEnterTimeout: (0, PropTypes$1.transitionTimeout)('Enter'),
  transitionLeaveTimeout: (0, PropTypes$1.transitionTimeout)('Leave')
};

var defaultProps = {
  transitionAppear: false,
  transitionEnter: true,
  transitionLeave: true
};

var CSSTransitionGroup = function (_React$Component) {
  _inherits(CSSTransitionGroup, _React$Component);

  function CSSTransitionGroup() {
    var _temp, _this, _ret;

    _classCallCheck(this, CSSTransitionGroup);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = _possibleConstructorReturn(this, _React$Component.call.apply(_React$Component, [this].concat(args))), _this), _this._wrapChild = function (child) {
      return _react2.default.createElement(_CSSTransitionGroupChild2.default, {
        name: _this.props.transitionName,
        appear: _this.props.transitionAppear,
        enter: _this.props.transitionEnter,
        leave: _this.props.transitionLeave,
        appearTimeout: _this.props.transitionAppearTimeout,
        enterTimeout: _this.props.transitionEnterTimeout,
        leaveTimeout: _this.props.transitionLeaveTimeout
      }, child);
    }, _temp), _possibleConstructorReturn(_this, _ret);
  }

  // We need to provide this childFactory so that
  // ReactCSSTransitionGroupChild can receive updates to name, enter, and
  // leave while it is leaving.


  CSSTransitionGroup.prototype.render = function render() {
    return _react2.default.createElement(_TransitionGroup2.default, _extends({}, this.props, { childFactory: this._wrapChild }));
  };

  return CSSTransitionGroup;
}(_react2.default.Component);

CSSTransitionGroup.displayName = 'CSSTransitionGroup';


CSSTransitionGroup.propTypes = process.env.NODE_ENV !== "production" ? propTypes : {};
CSSTransitionGroup.defaultProps = defaultProps;

exports.default = CSSTransitionGroup;
module.exports = exports['default'];
});

var CSSTransitionGroup = unwrapExports(CSSTransitionGroup_1);

var classnames = createCommonjsModule(function (module) {
/*!
  Copyright (c) 2016 Jed Watson.
  Licensed under the MIT License (MIT), see
  http://jedwatson.github.io/classnames
*/
/* global define */

(function () {
	'use strict';

	var hasOwn = {}.hasOwnProperty;

	function classNames () {
		var classes = [];

		for (var i = 0; i < arguments.length; i++) {
			var arg = arguments[i];
			if (!arg) continue;

			var argType = typeof arg;

			if (argType === 'string' || argType === 'number') {
				classes.push(arg);
			} else if (Array.isArray(arg)) {
				classes.push(classNames.apply(null, arg));
			} else if (argType === 'object') {
				for (var key in arg) {
					if (hasOwn.call(arg, key) && arg[key]) {
						classes.push(key);
					}
				}
			}
		}

		return classes.join(' ');
	}

	if ('object' !== 'undefined' && module.exports) {
		module.exports = classNames;
	} else if (typeof undefined === 'function' && typeof undefined.amd === 'object' && undefined.amd) {
		// register as 'classnames', consistent with npm package name
		undefined('classnames', [], function () {
			return classNames;
		});
	} else {
		window.classNames = classNames;
	}
}());
});

/** @module utils/getField */

/**
 * Gets the current field for a component that can the field
 * as either uncontrolled or controlled.
 *
 * @param {Object} props - the props object.
 * @param {Object} state = the state object.
 * @param {string=} field - the field to extract a value from. Defaults to 'value'.
 *
 * @return the field's value.
 */
function getField(props, state) {
  var field = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'value';

  return typeof props[field] !== 'undefined' ? props[field] : state[field];
}

/** @module utils/omit */

/**
 * This should hopefully be very similar to lodash's omit function. It will
 * take an object and return a new object without any of the given keys.
 *
 * @param {Object} obj - The object to omit keys from.
 * @param {Array.<String>} keys - a list of keys to remove.
 */
function omit(obj, keys) {
  if (!obj) {
    return {};
  } else if (!keys || !keys.length) {
    return obj;
  }

  return Object.keys(obj).filter(function (key) {
    return keys.indexOf(key) === -1;
  }).reduce(function (newProps, key) {
    newProps[key] = obj[key];

    return newProps;
  }, {});
}

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) {
  return typeof obj;
} : function (obj) {
  return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
};





var asyncGenerator = function () {
  function AwaitValue(value) {
    this.value = value;
  }

  function AsyncGenerator(gen) {
    var front, back;

    function send(key, arg) {
      return new Promise(function (resolve, reject) {
        var request = {
          key: key,
          arg: arg,
          resolve: resolve,
          reject: reject,
          next: null
        };

        if (back) {
          back = back.next = request;
        } else {
          front = back = request;
          resume(key, arg);
        }
      });
    }

    function resume(key, arg) {
      try {
        var result = gen[key](arg);
        var value = result.value;

        if (value instanceof AwaitValue) {
          Promise.resolve(value.value).then(function (arg) {
            resume("next", arg);
          }, function (arg) {
            resume("throw", arg);
          });
        } else {
          settle(result.done ? "return" : "normal", result.value);
        }
      } catch (err) {
        settle("throw", err);
      }
    }

    function settle(type, value) {
      switch (type) {
        case "return":
          front.resolve({
            value: value,
            done: true
          });
          break;

        case "throw":
          front.reject(value);
          break;

        default:
          front.resolve({
            value: value,
            done: false
          });
          break;
      }

      front = front.next;

      if (front) {
        resume(front.key, front.arg);
      } else {
        back = null;
      }
    }

    this._invoke = send;

    if (typeof gen.return !== "function") {
      this.return = undefined;
    }
  }

  if (typeof Symbol === "function" && Symbol.asyncIterator) {
    AsyncGenerator.prototype[Symbol.asyncIterator] = function () {
      return this;
    };
  }

  AsyncGenerator.prototype.next = function (arg) {
    return this._invoke("next", arg);
  };

  AsyncGenerator.prototype.throw = function (arg) {
    return this._invoke("throw", arg);
  };

  AsyncGenerator.prototype.return = function (arg) {
    return this._invoke("return", arg);
  };

  return {
    wrap: function (fn) {
      return function () {
        return new AsyncGenerator(fn.apply(this, arguments));
      };
    },
    await: function (value) {
      return new AwaitValue(value);
    }
  };
}();





var classCallCheck = function (instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
};

var createClass = function () {
  function defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  return function (Constructor, protoProps, staticProps) {
    if (protoProps) defineProperties(Constructor.prototype, protoProps);
    if (staticProps) defineProperties(Constructor, staticProps);
    return Constructor;
  };
}();





var defineProperty = function (obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value: value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }

  return obj;
};

var _extends = Object.assign || function (target) {
  for (var i = 1; i < arguments.length; i++) {
    var source = arguments[i];

    for (var key in source) {
      if (Object.prototype.hasOwnProperty.call(source, key)) {
        target[key] = source[key];
      }
    }
  }

  return target;
};



var inherits = function (subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
  }

  subClass.prototype = Object.create(superClass && superClass.prototype, {
    constructor: {
      value: subClass,
      enumerable: false,
      writable: true,
      configurable: true
    }
  });
  if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
};









var objectWithoutProperties = function (obj, keys) {
  var target = {};

  for (var i in obj) {
    if (keys.indexOf(i) >= 0) continue;
    if (!Object.prototype.hasOwnProperty.call(obj, i)) continue;
    target[i] = obj[i];
  }

  return target;
};

var possibleConstructorReturn = function (self, call) {
  if (!self) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }

  return call && (typeof call === "object" || typeof call === "function") ? call : self;
};





var slicedToArray = function () {
  function sliceIterator(arr, i) {
    var _arr = [];
    var _n = true;
    var _d = false;
    var _e = undefined;

    try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);

        if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;
      _e = err;
    } finally {
      try {
        if (!_n && _i["return"]) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }

    return _arr;
  }

  return function (arr, i) {
    if (Array.isArray(arr)) {
      return arr;
    } else if (Symbol.iterator in Object(arr)) {
      return sliceIterator(arr, i);
    } else {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }
  };
}();











var toArray = function (arr) {
  return Array.isArray(arr) ? arr : Array.from(arr);
};

/** @module utils/findIgnoreCase */
/**
 * This function finds the first item in a `haystack` that starts with every
 * letter of the `value` in order. It will ignore:
 *  - null or undefined
 *  - valid React components
 *
 * @param {Array.<string|number|Object|function>} haystack - the haystack to search.
 * @param {string} value - the current value to use.
 * @param {string=} dataLabel - the object key to use to extract the comparing value.
 *
 * @return {string} the found element or the empty string.
 */
function findIgnoreCase(haystack, value, dataLabel) {
  var needle = value ? value.toLowerCase() : '';

  if (!needle) {
    return needle;
  }

  var suggestion = '';
  haystack.some(function (hay) {
    if (hay === null || typeof hay === 'undefined' || React.isValidElement(hay)) {
      return false;
    }

    var hayStr = (typeof hay === 'undefined' ? 'undefined' : _typeof(hay)) === 'object' ? hay[dataLabel] : hay.toString();

    if (hayStr.toLowerCase().indexOf(needle) === 0) {
      suggestion = hayStr;
    }

    return suggestion;
  });

  return suggestion;
}

/** @module utils/fuzzyFilter */
/**
 * This function does a simple fuzzy search of some `needle` for every
 * item in a `haystack`. It will only include items that are:
 *  - not null or undefined
 *  - valid React Components
 *  - a number or string that contains each letter/number in order ignoring case
 *  - an object's `dataLabel` value that contains each letter/number in order ignoring case.
 *
 * Example:
 * ```js
 * const haystack = ['Apple', 'Banana', 'Orange'];
 * fuzzyFilter(haystack, 'An') // ['Banana', 'Orange'];
 * fuzzyFilter(haystack, 'ae') // ['Apple']
 * ```
 *
 * @param {Array.<string|number|Object|function>} haystack - the haystack to search
 * @param {string} needle - the filter text to use.
 * @param {string=} dataLabel - the data label to use if the element is an object.
 *
 * @return {Array.<string|number|Object|function>} a filtered list.
 */
function fuzzyFilter(haystack, needle, dataLabel) {
  // Create an amazing regex that matches the letters in order
  // and escapes any strings that could be part of a regex.
  var reg = new RegExp(('' + needle).split('').join('\\w*').replace(/(\(|\||\)|\\(?!w\*)|\[|\|-|\.|\^|\+|\$|\?|^(?!w)\*)/g, '\\$1')
  // Couldn't get the matching of two '*' working, so replace them here..
  .replace(/\*\*/g, '*\\*'), 'i');

  return haystack.filter(function (hay) {
    if (hay === null || typeof hay === 'undefined') {
      return false;
    } else if (React.isValidElement(hay)) {
      return true;
    }

    var value = void 0;
    switch (typeof hay === 'undefined' ? 'undefined' : _typeof(hay)) {
      case 'string':
      case 'number':
        value = hay.toString();
        break;
      default:
        value = hay[dataLabel];
    }

    return value && value.match(reg);
  });
}

/** @module utils/caseInsensitiveFilter */
/**
 * This function does a simple ignore case search of some `filterText` for every
 * item in a `haystack`. It will only include items that are:
 *  - not null or undefined
 *  - valid React Components
 *  - a number or string that contains each letter/number in exact order ignoring case
 *  - an object's `dataLabel` value that contains each letter/number in exact order ignoring case.
 *
 * Example:
 *
 * ```js
 * const haystack = ['Apple', 'Banana', 'Orange'];
 * caseInsensitiveFilter(haystack, 'An') // ['Banana', 'Orange'];
 * caseInsensitiveFilter(haystack, 'ae') // []
 * ```
 *
 * @param {Array.<string|number|Object|function>} haystack - the haystack to search
 * @param {string} filterText - the filter text to use.
 * @param {string=} dataLabel - the data label to use if the element is an object.
 *
 * @return {Array.<string|number|Object|function>} a filtered list.
 */
function caseInsensitiveFilter(haystack, filterText, dataLabel) {
  var needle = filterText.toLowerCase();

  return haystack.filter(function (hay) {
    if (hay === null || typeof hay === 'undefined') {
      return false;
    } else if (React.isValidElement(hay)) {
      return true;
    }

    var value = void 0;
    switch (typeof hay === 'undefined' ? 'undefined' : _typeof(hay)) {
      case 'string':
      case 'number':
        value = hay.toString();
        break;
      default:
        value = hay[dataLabel];
    }

    return value && value.toLowerCase().indexOf(needle) !== -1;
  });
}

/** @module utils/Positioning/getTextWidth */

var cachedCanvas = void 0;

/**
 * A utility function to measure the width (in px) of any text. It will require a canvas
 * and an element to use to determine the current fonts to apply since different fonts will
 * have different widths.
 *
 * This isn't fully accurate since some browsers handle the calculations a bit differently so
 * they are off by a 0-3px
 *
 * @param {String} text - The text to measure the width
 * @param {HTMLElement} el - The element to use to determine the current font for the text.
 * @param {HTMLElement=} canvas - An optional canvas to use for doing the calculations. If this
 *    is omitted, it will just use the locally created canvas to do the calculations.
 * @return {number} this will either return null if there is a problem calculating the width or
 *    the length (in px) of the text.
 */
function getTextWidth(text, el, canvas) {
  if (!el) {
    return null;
  }

  if (!canvas) {
    if (!cachedCanvas) {
      cachedCanvas = document.createElement('canvas');
    }

    canvas = cachedCanvas;
  }

  var context = canvas.getContext('2d');
  if (!context) {
    // context doesn't exist in testing without complicated mocks
    return null;
  }

  var styles = window.getComputedStyle(el);
  var font = styles.font;
  // Some browsers do not actually supply the font style since they are on an older version of CSSProperties,
  // so the font string needs to be made manually.
  if (!font) {
    // font-style font-variant font-weight font-size/line-height font-family
    var sizing = styles.fontSize + ' / ' + styles.lineHeight + ' ' + styles.fontFamily;
    font = styles.fontStyle + ' ' + styles.fontVariant + ' ' + styles.fontWeight + ' ' + sizing;
  }

  context.font = font;
  return context.measureText(text).width;
}

/** @module utils/PropTypes/oneRequiredForA11y */

/**
 * This validator checks that either the current prop is defined and valid or that one of the
 * other given prop names are defined. If it fails it returns an error for a11y.
 *
 * @param {function} validator - The React PropTypes validator to use for the given prop.
 * @param {String[]} otherPropNames - Any other prop names to validate against.
 * @return {Error} an error or null
 */
function oneRequiredForA11y(validator) {
  for (var _len = arguments.length, otherPropNames = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
    otherPropNames[_key - 1] = arguments[_key];
  }

  return function validate(props, propName, componentName, location, propFullName) {
    var componentNameSafe = componentName || '<<anonymous>>';
    var propFullNameSafe = propFullName || propName;
    var allPropNames = [propFullNameSafe].concat(otherPropNames);

    for (var _len2 = arguments.length, args = Array(_len2 > 5 ? _len2 - 5 : 0), _key2 = 5; _key2 < _len2; _key2++) {
      args[_key2 - 5] = arguments[_key2];
    }

    var err = validator.apply(undefined, [props, propName, componentName, location, propFullName].concat(args));
    if (!err && !allPropNames.filter(function (pn) {
      return typeof props[pn] !== 'undefined';
    }).length) {
      err = new Error('One of the following props are required to make ' + componentNameSafe + ' accessible ' + ('for users of assistive technologies such as screen readers. `' + allPropNames.join('`, `') + '`.'));
    }

    return err;
  };
}

/** @module utils/PropTypes/controlled */
/**
 * Validates the a component is fully controlled or uncontrolled.  If the given prop is not
 * `undefined`, it will check if the `funcName` is defined and a function. A missing function
 * will generate an error similar to the built-in React controlled validation message.
 *
 * @param {String} funcName - The function name to use for additional validation.
 * @param {function} validator - The PropTypes validator to use for the given prop.
 * @return {Error} an error or null.
 */
function controlled(validator, funcName) {
  var fallbackPropName = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'defaultValue';

  return function validate(props, propName, componentName, location, propFullName) {
    var componentNameSafe = componentName || '<<anonymous>>';
    var propFullNameSafe = propFullName || propName;

    for (var _len = arguments.length, args = Array(_len > 5 ? _len - 5 : 0), _key = 5; _key < _len; _key++) {
      args[_key - 5] = arguments[_key];
    }

    var err = validator.apply(undefined, [props, propName, componentName, location, propFullName].concat(args));
    if (!err && typeof props[propName] !== 'undefined' && !props.readOnly && !props.disabled) {
      var _PropTypes$func;

      var funcError = (_PropTypes$func = propTypes.func).isRequired.apply(_PropTypes$func, [props, funcName, componentName, location, propFullName].concat(args));
      if (funcError) {
        err = new Error('You provided a `' + propFullNameSafe + '` ' + location + ' to the ' + componentNameSafe + ' without a ' + ('`' + funcName + '` handler. This will render a read only field. Set either the `' + funcName + '` ') + ('or use the `' + fallbackPropName + '` instead.'));
      }
    }

    return err;
  };
}

/** @module utils/PropTypes/invalidIf */

/**
 * A custom validator that will throw an error if any of the `ifDefinedProps` are also defined.
 *
 * @param {function} validator - The PropTypes validator to use.
 * @param {String...} ifDefinedProps - any othe rprop names to validate against
 * @return {Error} an error or null
 */
function invalidIf(validator) {
  for (var _len = arguments.length, ifDefinedProps = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
    ifDefinedProps[_key - 1] = arguments[_key];
  }

  return function validate(props, propName, componentName, location, propFullName) {
    var componentNameSafe = componentName || '<<anonymous>>';
    var propFullNameSafe = propFullName || propName;

    for (var _len2 = arguments.length, args = Array(_len2 > 5 ? _len2 - 5 : 0), _key2 = 5; _key2 < _len2; _key2++) {
      args[_key2 - 5] = arguments[_key2];
    }

    var err = validator.apply(undefined, [props, propName, componentName, location, propFullName].concat(args));
    if (err) {
      return err;
    }

    var defined = typeof props[propName] !== 'undefined' && !!props[propName];
    var othersDefined = ifDefinedProps.filter(function (name) {
      return typeof props[name] !== 'undefined' && !!props[name];
    });
    if (defined && othersDefined.length) {
      var names = '`' + othersDefined.join('`, `') + '`';
      if (othersDefined.length === 1) {
        return new Error('You provided both a `' + propFullNameSafe + '` and ' + names + ' prop to the ' + componentNameSafe + ' ' + 'but only one can be given.');
      }

      return new Error('You provided a `' + propFullNameSafe + '` ' + location + ' to the ' + componentNameSafe + ' when ' + ('the following props were defined: ' + names + '. Either remove the `' + propFullNameSafe + '` ') + 'or use the remove all the other props.');
    }

    return null;
  };
}

var LEFT_MOUSE = 0;


var TAB = 9;
var ENTER = 13;
var ESC = 27;
var SPACE = 32;




var LEFT = 37;
var UP = 38;
var RIGHT = 39;
var DOWN = 40;

var ZERO = 48;
var NINE = 57;
var KEYPAD_ZERO = 96;
var KEYPAD_NINE = 105;

/** @module Helpers/HorizontalAnchors */

/**
 * An enum for all the different types of horizontal anchors on a layover.
 *
 * @readonly
 * @enum {string}
 */
var HorizontalAnchors = {
  /**
   * Positions the layover to the outside left on the toggle component
   * so that it does not overlap.
   */
  LEFT: 'left',

  /**
   * Positions the layover to the inner left of the toggle component so
   * that it will overlap.
   */
  INNER_LEFT: 'inner left',

  /**
   * Positions the layover so that it overlaps the toggle component
   * by positioning itself in the cetner of the toggle component's width.
   */
  CENTER: 'center',

  /**
   * Positions the layover to the outside right on the toggle component
   * so that it does not overlap.
   */
  RIGHT: 'right',

  /**
   * Positions the layover to the outside right on the toggle component
   * so that it will overlap.
   */
  INNER_RIGHT: 'inner right'
};

/** @module Helpers/VerticalAnchors */

/**
 * An enum for all the different types of horizontal anchors on a layover.
 *
 * @readonly
 * @enum {string}
 */
var VerticalAnchors = {
  /**
   * Positions the layover to be placed over the toggle component so that
   * it will never overlay the toggle component.
   */
  TOP: 'top',

  /**
   * Positions the layover so that it will be centered over the toggle component
   * based on the layover's height.
   */
  CENTER: 'center',

  /**
   * Positions the layover so that it will overlap the toggle component by
   * fixing to the top of the toggle.
   */
  OVERLAP: 'overlap',

  /**
   * Positions the layover to be placed below the toggle component so that
   * it will never overlay the toggle component.
   */
  BOTTOM: 'bottom'
};

var anchorShape = propTypes.shape({
  x: propTypes.oneOf([HorizontalAnchors.LEFT, HorizontalAnchors.INNER_LEFT, HorizontalAnchors.CENTER, HorizontalAnchors.RIGHT, HorizontalAnchors.INNER_RIGHT]).isRequired,
  y: propTypes.oneOf([VerticalAnchors.TOP, VerticalAnchors.CENTER, VerticalAnchors.OVERLAP, VerticalAnchors.BOTTOM]).isRequired
});

var fixedToShape = propTypes.oneOfType([propTypes.object, propTypes.shape({
  x: propTypes.object,
  y: propTypes.object
})]);

/** @module Helpers/Positions */

/**
 * An enum for all the animation positions for a layover appearing.
 *
 * @readonly
 * @enum {string}
 */
var Positions = {
  /**
   * The layover will appear by transitioning from the top left and expand
   * down right.
   */
  TOP_LEFT: 'tl',

  /**
   * The layover will appear by transitioning from the top right and expand
   * down left.
   */
  TOP_RIGHT: 'tr',

  /**
   * The layover will appear by transitioning from the bottom left and expand
   * top right.
   */
  BOTTOM_LEFT: 'bl',

  /**
   * The layover will appear by transitioning from the bottom right and expand
   * top left.
   */
  BOTTOM_RIGHT: 'br',

  /**
   * The layover will appear by just transitioning downwards from the bottom
   * of the toggle component.
   */
  BELOW: 'below'
};

var positionShape = propTypes.oneOfType([propTypes.oneOf([Positions.TOP_LEFT, Positions.TOP_RIGHT, Positions.BOTTOM_LEFT, Positions.BOTTOM_RIGHT, Positions.BELOW]), propTypes.string]);

var deprecated_1 = createCommonjsModule(function (module, exports) {
'use strict';

exports.__esModule = true;
exports.default = deprecated;



var _warning2 = _interopRequireDefault(browser);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var warned = {};

function deprecated(validator, reason) {
  return function validate(props, propName, componentName, location, propFullName) {
    var componentNameSafe = componentName || '<<anonymous>>';
    var propFullNameSafe = propFullName || propName;

    if (props[propName] != null) {
      var messageKey = componentName + '.' + propName;

      (0, _warning2.default)(warned[messageKey], 'The ' + location + ' `' + propFullNameSafe + '` of ' + ('`' + componentNameSafe + '` is deprecated. ' + reason + '.'));

      warned[messageKey] = true;
    }

    for (var _len = arguments.length, args = Array(_len > 5 ? _len - 5 : 0), _key = 5; _key < _len; _key++) {
      args[_key - 5] = arguments[_key];
    }

    return validator.apply(undefined, [props, propName, componentName, location, propFullName].concat(args));
  };
}

/* eslint-disable no-underscore-dangle */
function _resetWarned() {
  warned = {};
}

deprecated._resetWarned = _resetWarned;
/* eslint-enable no-underscore-dangle */
});

var deprecated = unwrapExports(deprecated_1);

/** @module utils/themeColors */
/**
 * This is a utility function to apply the different text colors as a class name.
 *
 * @param {Object} options - The options to use to figure out which styles to apply.
 * @param {boolean?} options.text - Boolean if the base text color should attempt to be
 *    applied. This will only be applied if all the other states are not true.
 * @param {boolean?} options.disabled - Boolean if the text should be disabled.
 * @param {boolean?} options.error - Boolean if the error color should attempt to be applied.
 *    This will only be applied if the disabled state is false.
 * @param {boolean?} options.primary - Boolean if the primary color should be applied. This
 *    will only be applied if all the other states are false.
 * @param {boolean?} options.secondary - Boolean if the secondary color should be applied.
 *    This will only be applied if all the other states are false.
 * @param {boolean?} options.inherit - Boolean if the color should be inherited by a parent.
 *    This will only be applied if the error and disabled states are false.
 * @return {String} the class name
 */
function themeColors() {
  var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
      _ref$themeText = _ref.themeText,
      themeText = _ref$themeText === undefined ? true : _ref$themeText,
      _ref$text = _ref.text,
      text = _ref$text === undefined ? false : _ref$text,
      _ref$background = _ref.background,
      background = _ref$background === undefined ? false : _ref$background,
      _ref$disabled = _ref.disabled,
      disabled = _ref$disabled === undefined ? false : _ref$disabled,
      _ref$error = _ref.error,
      error = _ref$error === undefined ? false : _ref$error,
      _ref$hint = _ref.hint,
      hint = _ref$hint === undefined ? false : _ref$hint,
      _ref$primary = _ref.primary,
      primary = _ref$primary === undefined ? false : _ref$primary,
      _ref$secondary = _ref.secondary,
      secondary = _ref$secondary === undefined ? false : _ref$secondary,
      _ref$inherit = _ref.inherit,
      inherit = _ref$inherit === undefined ? false : _ref$inherit,
      _ref$ink = _ref.ink,
      ink = _ref$ink === undefined ? false : _ref$ink,
      _ref$card = _ref.card,
      card = _ref$card === undefined ? false : _ref$card,
      _ref$hover = _ref.hover,
      hover = _ref$hover === undefined ? false : _ref$hover;

  var className = arguments[1];

  var colors = '';
  if (themeText) {
    if (disabled) {
      colors = 'md-text--disabled';
    } else if (error) {
      colors = 'md-text--error';
    } else if (inherit) {
      colors = 'md-text--inherit';
    } else {
      colors = classnames({
        'md-text': text && !primary && !secondary && !hint,
        'md-text--secondary': hint,
        'md-text--theme-primary': !hint && primary,
        'md-text--theme-secondary': !hint && secondary,
        'md-ink--primary': ink && primary,
        'md-ink--secondary': ink && secondary
      });
    }
  } else {
    colors = classnames({
      'md-background': background && !primary && !secondary && !card,
      'md-background--card': card,
      'md-background--primary': primary,
      'md-background--primary-hover': primary && hover,
      'md-background--secondary': secondary,
      'md-background--secondary-hover': secondary && hover
    });
  }

  return classnames(colors, className);
}

/**
 * A simple utility function to get the dynamic collapser styles.
 */
function getCollapserStyles(_ref) {
  var _ref2;

  var flipped = _ref.flipped,
      suffix = _ref.suffix,
      suffixFlipped = _ref.suffixFlipped;

  for (var _len = arguments.length, classNames = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
    classNames[_key - 1] = arguments[_key];
  }

  return classnames.apply(undefined, ['md-collapser', (_ref2 = {
    'md-collapser--flipped': flipped && (!suffixFlipped || !suffix)
  }, defineProperty(_ref2, 'md-collapser--' + suffix, suffix), defineProperty(_ref2, 'md-collapser--' + suffix + '-flipped', suffix && flipped && suffixFlipped), _ref2)].concat(classNames));
}

/** @module utils/closest */

/**
 * A _very_ primitive polyfill for the Element.closest function. If this is a browser that doesn't
 * support it (IE, Edge, etc), it will just keep searching the parent elements until the nodeName
 * matches the provided type.
 *
 * @param {Element} el - the html element to find a closest node type for
 * @param {String} type - the html element type to find.
 * @return {Element} the found element or null.
 */
function closest(el, type) {
  if (typeof el.closest === 'function') {
    return el.closest(type);
  }

  var nodeType = type.toUpperCase();
  var node = el.parentElement;
  while (node && node.parentElement) {
    if (node.nodeName === nodeType) {
      return node;
    }

    node = node.parentElement;
  }

  return null;
}

/** @module utils/isFormPartRole */

/**
 * A simple utility function to determine if an element has a role that should
 * be used as a form part. This is mostly used for changing the behavior of keyboard
 * events.
 *
 * A form part role is one of the following:
 * - checkbox
 * - radio
 * - listbox
 * - input
 *
 * @param {HTMLElement} el - the element to check.
 * @return {boolean} true if the element is considered an element part of a form.
 */
function isFormPartRole(el) {
  if (!el) {
    return false;
  } else if (el.nodeName === 'INPUT') {
    return true;
  }

  var role = el.getAttribute('role');
  return role === 'checkbox' || role === 'radio' || role === 'listbox';
}

/** @module utils/EventUtils/handleKeyboardAccessibility */

/**
 * A utility function for adding keyboard accessibility to elements that are not a natively
 * clickable (div, span, etc). When the space or enter key is pressed while focusing the
 * element, different flows will happen.
 *
 * - space - The click event will be triggered and the default page scrolling behavior of the
 *      spacebar will be prevented
 * - enter - If the element has a form role ('checkbox' or 'radio'), the click event will not
 *      be triggered. Instead, it will find out if the element is inside a form. If it is, it
 *      will emulate the default behavior of attempting to submit the form. If the element does
 *      not have a form role, the click event will be triggered.
 *
 * @param {Event} e - the keydown event
 * @param {function} onClick - the on click event to be triggered if space or enter was pressed
 * @param {boolean=true} listenToEnter - boolean if the enter key should be used to trigger the
 *      the click event. Even if this is true, the click event will not be triggered if the role
 *      is for a form role.
 * @param {boolean=true} listenToSpace - boolean if the space key should be used to trigger the
 *      click event.
 * @return {Boolean} true if the enter or space keys were pressed while their listener is also active.
 */
function handleKeyboardAccessibility(e, onClick) {
  var listenToEnter = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;
  var listenToSpace = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : true;

  var key = e.which || e.keyCode;
  var space = listenToSpace && key === SPACE;
  var enter = key === ENTER;

  var tagName = e.target.tagName;
  // it is valid to press space in text fields, contenteditable, and buttons

  if (space && !tagName.match(/input|textarea|button/i) && e.target.getAttribute('contenteditable') !== 'true') {
    // Stop page scrolling
    e.preventDefault();
  }

  if (enter && isFormPartRole(e.target)) {
    var form = closest(e.target, 'form');
    var submit = form ? form.querySelector('*[type="submit"]') : null;
    if (submit) {
      submit.click();
    }

    return true;
  }

  if (enter && listenToEnter || space) {
    onClick(e);

    return true;
  }

  return false;
}

/**
 * The `AccessibleFakeButton` is a generic component that can be used to render
 * a `div` or any other non `button` components as a button. This should not be
 * used often.
 *
 * The `AccessibleFakeButton` allows the user to tab focus the element, use the
 * space or enter key to trigger the `onClick` event, and toggles the `aria-pressed`
 * attribute.
 */

var AccessibleFakeButton = function (_PureComponent) {
  inherits(AccessibleFakeButton, _PureComponent);

  function AccessibleFakeButton() {
    var _ref;

    var _temp, _this, _ret;

    classCallCheck(this, AccessibleFakeButton);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = possibleConstructorReturn(this, (_ref = AccessibleFakeButton.__proto__ || Object.getPrototypeOf(AccessibleFakeButton)).call.apply(_ref, [this].concat(args))), _this), _this.state = { pressed: false, tabFocused: false }, _this.focus = function () {
      if (_this._node) {
        _this._node.focus();
      }
    }, _this.blur = function () {
      if (_this._node) {
        _this._node.blur();
      }
    }, _this._setNode = function (node) {
      if (node) {
        _this._node = findDOMNode(node);
      }
    }, _this._handleClick = function (e) {
      if (_this.props.disabled) {
        return;
      }

      if (_this.props.onClick) {
        _this.props.onClick(e);
      }

      _this._node.focus();
      _this.setState({ pressed: !_this.state.pressed });
    }, _this._handleKeyDown = function (e) {
      var _this$props = _this.props,
          disabled = _this$props.disabled,
          onKeyDown = _this$props.onKeyDown,
          listenToEnter = _this$props.listenToEnter,
          listenToSpace = _this$props.listenToSpace;

      if (disabled) {
        return;
      }

      if (onKeyDown) {
        onKeyDown(e);
      }

      handleKeyboardAccessibility(e, _this._handleClick, listenToEnter, listenToSpace);
    }, _this._handleKeyUp = function (e) {
      var _this$props2 = _this.props,
          onKeyUp = _this$props2.onKeyUp,
          onTabFocus = _this$props2.onTabFocus;

      if (onKeyUp) {
        onKeyUp(e);
      }

      if ((e.which || e.keyCode) === TAB) {
        if (onTabFocus) {
          onTabFocus(e);
        }

        _this.setState({ tabFocused: true });
      }
    }, _this._handleBlur = function (e) {
      if (_this.props.onBlur) {
        _this.props.onBlur(e);
      }

      if (_this.state.tabFocused) {
        _this.setState({ tabFocused: false });
      }
    }, _temp), possibleConstructorReturn(_this, _ret);
  }

  /**
   * Focuses the button.
   */


  /**
   * Blurs the button.
   */


  createClass(AccessibleFakeButton, [{
    key: 'render',
    value: function render() {
      var _props = this.props,
          Component$$1 = _props.component,
          children = _props.children,
          className = _props.className,
          tabbedClassName = _props.tabbedClassName,
          disabled = _props.disabled,
          tabIndex = _props.tabIndex,
          ink = _props.ink,
          noFocusOutline = _props.noFocusOutline,
          onBlur = _props.onBlur,
          onClick = _props.onClick,
          onKeyUp = _props.onKeyUp,
          onKeyDown = _props.onKeyDown,
          onTabFocus = _props.onTabFocus,
          listenToEnter = _props.listenToEnter,
          listenToSpace = _props.listenToSpace,
          props = objectWithoutProperties(_props, ['component', 'children', 'className', 'tabbedClassName', 'disabled', 'tabIndex', 'ink', 'noFocusOutline', 'onBlur', 'onClick', 'onKeyUp', 'onKeyDown', 'onTabFocus', 'listenToEnter', 'listenToSpace']);


      var childElements = children;
      if (ink) {
        childElements = Children.toArray(children);
        childElements.unshift(ink);
      }

      return React.createElement(
        Component$$1,
        _extends({}, props, {
          ref: this._setNode,
          className: classnames('md-fake-btn', defineProperty({
            'md-pointer--hover': !disabled,
            'md-fake-btn--no-outline': noFocusOutline
          }, tabbedClassName, tabbedClassName && this.state.tabFocused), className),
          disabled: disabled,
          tabIndex: disabled ? null : tabIndex,
          onBlur: this._handleBlur,
          onClick: this._handleClick,
          onKeyUp: this._handleKeyUp,
          onKeyDown: this._handleKeyDown,
          'aria-pressed': this.state.pressed
        }),
        childElements
      );
    }
  }]);
  return AccessibleFakeButton;
}(PureComponent);

AccessibleFakeButton.propTypes = {
  /**
   * An optional style to apply.
   */
  style: propTypes.object,

  /**
   * An optional className to apply.
   */
  className: propTypes.string,

  /**
   * An optional function to call only when the button has been focused with the tab key.
   */
  tabbedClassName: propTypes.string,

  /**
   * Any children to display in the Accessible Fake Button.
   */
  children: propTypes.node,

  /**
   * An optional onClick function to call when the user clicks the
   * button or presses space || enter.
   */
  onClick: propTypes.func,

  /**
   * An optional onKeyDown function to call.
   */
  onKeyDown: propTypes.func,

  /**
   * An optional onBlur function to call.
   */
  onBlur: propTypes.func,

  /**
   * An optional onKeyUp function to call.
   */
  onKeyUp: propTypes.func,

  /**
   * An optional function to call when the element is focused with the tab key.
   */
  onTabFocus: propTypes.func,

  /**
   * The component to render the Fake button as.
   */
  component: propTypes.oneOfType([propTypes.func, propTypes.string]).isRequired,

  /**
   * Boolean if the default outline should be removed the when the fake button has been focused.
   *
   * @see {@link #tabbedClassName}
   */
  noFocusOutline: propTypes.bool,

  /**
   * The tab index to use for the Fake button so it is keyboard focusable.
   */
  tabIndex: propTypes.number,

  /**
   * Boolean if the Button is disabled. This will prevent tab focus.
   */
  disabled: propTypes.bool,

  /**
   * The role for the accessible fake button. It is recommended to keep it
   * the default of `button` unless you are rendering it as an `a` tag.
   */
  role: propTypes.string,

  /**
   * The ink when coming from the AccessibleFakeInkedButton
   * @access private
   */
  ink: propTypes.node,

  /**
   * Boolean if the spacebar should be used to trigger the click event. This _should_ be `true`
   * is almost all cases.
   */
  listenToSpace: propTypes.bool,

  /**
   * Boolean if the enter key should be used to trigger the click event. This _should_ be `true`
   * in most cases. By default, the param will be ignored if the `role` attribute is for a `checkbox`
   * or `radio`. When it is a checkbox or radio, it will attempt to submit the form on the enter
   * keypress instead like the native elements.
   */
  listenToEnter: propTypes.bool
};
AccessibleFakeButton.defaultProps = {
  component: 'div',
  tabIndex: 0,
  role: 'button',
  noFocusOutline: true,
  listenToEnter: true,
  listenToSpace: true
};

/** @module utils/StringUtils/getDisplayName */

/**
 * Gets the display name for a composed component.
 *
 * @param {function|Object} ComposedComponent - The composed component to use
 * @param {String} hoc - The higher order component's name to use.
 * @return {String} the new name of the component.
 */
function getDisplayName(ComposedComponent, hoc) {
  var name = '' + (ComposedComponent.displayName || ComposedComponent.name || 'Component');

  return 'with' + hoc + '(' + name + ')';
}

/** @module utils/Positioning/getPagePosition */

/**
 * Gets the current page position.
 *
 * @see https://developer.mozilla.org/en-US/docs/Web/API/Window/scrollY
 * @param {String} direction - The direction that should be retrieved. This
 *    should be either 'x' or 'y'.
 * @return {number} the position of the direction on the page.
 */
function getPagePosition(direction) {
  var scroll = 'scroll' + (direction === 'x' ? 'Left' : 'Top');
  if (typeof window.pageXOffset !== 'undefined') {
    return window['page' + direction.toUpperCase() + 'Offset'];
  } else if ((document.compatMode || '') === 'CSS1Compat') {
    return document.documentElement[scroll];
  } else {
    return document.body[scroll];
  }
}

/** @module utils/Positioning/calcPageOffset */
/**
 * Calculates the page offset of an element. If the element
 * is false-ish, an empty object will be returned.
 *
 * This is really only used for calculating an ink position.
 *
 * @param {Node} el - An html node to find a page offset for.
 * @return {Object} an object with a left and top attribute for the page
 *    offset.
 */
function calcPageOffset(el) {
  if (!el) {
    return { left: null, right: null };
  }

  var rect = el.getBoundingClientRect();
  return {
    left: rect.left + getPagePosition('x'),
    top: rect.top + getPagePosition('y')
  };
}

/** @module utils/EventUtils/isValidClick */
/**
 * Checks if an event is a valid click event by ignoring
 * any clisk that are not the left mouse button and not
 * clicks that involve the shift key.
 *
 * @param {Object} e - the event to check
 * @return {Boolean} true if the event is valid.
 */
function isValidClick(e) {
  return e.button === LEFT_MOUSE && !e.shiftKey;
}

// https://github.com/WICG/EventListenerOptions/blob/gh-pages/explainer.md
var supportsPassive = void 0;
try {
  var opts = Object.defineProperty({}, 'passive', {
    get: function get$$1() {
      supportsPassive = true;
    }
  });
  window.addEventListener('test', null, opts);
} catch (e) {
  supportsPassive = false;
}

/**
 * A helper function for manually setting touch events on elements with the passive
 * option (when it is supported).
 *
 * @param {boolean} add - Boolean if the event listener should be added or removed.
 * @param {HTMLElement} el - The element to add the listener to.
 * @param {String} type - the event type to set. This should be 'start', 'move', or 'end'
 * @param {function} callback - The event listener callback function.
 * @param {Object=} options - any additional options to apply.
 */
function setTouchEvent(add, el, eventType, callback, options) {
  return el[(add ? 'add' : 'remove') + 'EventListener']('touch' + eventType, callback, supportsPassive ? _extends({ passive: true }, options) : false);
}

/**
 * A helper function for manually adding touch events on elements with the passive
 * option (when it is supported).
 *
 * @param {HTMLElement} el - The element to add the listener to.
 * @param {String} type - the event type to set. This should be 'start', 'move', or 'end'
 * @param {function} callback - The event listener callback function.
 * @param {Object=} options - any additional options to apply.
 */
function addTouchEvent(el, type, callback, options) {
  return setTouchEvent(true, el, type, callback, options);
}

/**
 * A helper function for manually removing touch events on elements with the passive
 * option (when it is supported).
 *
 * @param {HTMLElement} el - The element to add the listener to.
 * @param {String} type - the event type to set. This should be 'start', 'move', or 'end'
 * @param {function} callback - The event listener callback function.
 * @param {Object=} options - any additional options to apply.
 */
function removeTouchEvent(el, type, callback, options) {
  return setTouchEvent(false, el, type, callback, options);
}

/** @module utils/EventUtils/captureNextEvent */

/**
 * This function will capture the next event and stop propagation during the
 * bubbling cycle of events. This is really only useful if you want to stop
 * the default behavior of chained events.
 *
 * @param {String} type - The event type to capture.
 * @param {Object|func=} target - Either the DOM node to target, a callback function
 *      to call once the event has been captured, or undefined. If this is undefined,
 *      the event will be captured on the window.
 * @param {func=} callback - An optional callback function to call once the event
 *      has been captured.
 */
function captureNextEvent(type, target, callback) {
  var el = typeof target !== 'function' && target ? target : window;
  var cb = typeof target === 'function' ? target : callback;

  var capture = function capture(e) {
    e.stopPropagation();
    if (cb) {
      cb(e);
    }

    el.removeEventListener(type, capture, true);
  };

  el.addEventListener(type, capture, true);
}

/** @module utils/NumberUtils/calculateHypotenuse */

/**
 * Calculates the hypotenuse using the x and y coordinates given.
 *
 * @param {number} a the x coordinate
 * @param {number} b the y coordinate
 * @return {number} the hypotenuse length for the given x and y coordinates.
 */
function calculateHypotenuse(a, b) {
  return Math.sqrt(a * a + b * b);
}

// This will need to keep in sync with the `ReactCSSTransitionGroupChild` `TICK` const.
// https://github.com/facebook/react/blob/master/src/addons/transitions/ReactCSSTransitionGroupChild.js#L22

var TICK = 17;

var Ink = function (_PureComponent) {
  inherits(Ink, _PureComponent);

  function Ink(props) {
    classCallCheck(this, Ink);

    var _this = possibleConstructorReturn(this, (Ink.__proto__ || Object.getPrototypeOf(Ink)).call(this, props));

    _this.state = {
      active: false,
      expanded: false,
      pulsing: false,
      leaving: false
    };
    return _this;
  }

  createClass(Ink, [{
    key: 'componentWillReceiveProps',
    value: function componentWillReceiveProps(nextProps) {
      if (!this.props.aborted && nextProps.aborted) {
        if (this._timeout) {
          clearTimeout(this._timeout);
        }

        if (this._abort) {
          this._abort();
        }

        this.setState({ active: false, expanding: false, pulsing: false, leaving: false });
      }
    }
  }, {
    key: 'componentWillUnmount',
    value: function componentWillUnmount() {
      if (this._timeout) {
        clearTimeout(this._timeout);
      }
    }
  }, {
    key: 'componentWillEnter',
    value: function componentWillEnter(cb) {
      var _this2 = this;

      if (this.props.aborted) {
        cb();
        return;
      }

      var _props = this.props,
          transitionOverlap = _props.transitionOverlap,
          transitionEnterTimeout = _props.transitionEnterTimeout;

      this._abort = cb;

      this._timeout = setTimeout(function () {
        _this2._timeout = setTimeout(function () {
          _this2._timeout = null;
          _this2._abort = null;

          cb();
        }, transitionEnterTimeout - transitionOverlap);

        _this2.setState({ expanded: true });
      }, TICK);

      this.setState({ active: true });
    }
  }, {
    key: 'componentDidEnter',
    value: function componentDidEnter() {
      var _this3 = this;

      if (this.props.pulse) {
        this._timeout = setTimeout(function () {
          _this3._timeout = null;

          _this3.setState({ pulsing: true });
        }, this.props.transitionEnterTimeout);
      }
    }
  }, {
    key: 'componentWillLeave',
    value: function componentWillLeave(cb) {
      var _this4 = this;

      if (this.props.aborted) {
        cb();
        return;
      }

      if (this._timeout) {
        clearTimeout(this._timeout);
      }

      this._abort = cb;
      this._timeout = setTimeout(function () {
        _this4._timeout = null;

        cb();
      }, this.props.transitionLeaveTimeout);

      this.setState({ pulsing: false, leaving: true });
    }
  }, {
    key: 'componentDidLeave',
    value: function componentDidLeave() {
      if (!this.props.aborted && this.props.onRemove) {
        this.props.onRemove();
      }
    }
  }, {
    key: 'render',
    value: function render() {
      var _props2 = this.props,
          style = _props2.style,
          className = _props2.className,
          left = _props2.left,
          top = _props2.top,
          size = _props2.size;
      var _state = this.state,
          active = _state.active,
          expanded = _state.expanded,
          pulsing = _state.pulsing,
          leaving = _state.leaving;


      return React.createElement('span', {
        style: Object.assign({}, style, {
          left: left,
          top: top,
          height: size,
          width: size
        }),
        className: classnames('md-ink', {
          'md-ink--active': active,
          'md-ink--expanded': expanded,
          'md-ink--pulsing': pulsing,
          'md-ink--leaving': leaving
        }, className)
      });
    }
  }]);
  return Ink;
}(PureComponent);

Ink.propTypes = {
  style: propTypes.object,
  className: propTypes.string,
  aborted: propTypes.bool,
  onRemove: propTypes.func,
  left: propTypes.number.isRequired,
  top: propTypes.number.isRequired,
  size: propTypes.number.isRequired,
  transitionOverlap: propTypes.number.isRequired,
  transitionEnterTimeout: propTypes.number.isRequired,
  transitionLeaveTimeout: propTypes.number.isRequired,
  pulse: propTypes.bool
};

/**
 * The `InkContainer` is used for holding the list of inks that get created by touch,
 * click, or keyboard focus.
 *
 * If the container element has the `type="submit"` attribute, the ink will also be
 * triggered when the user presses enter anywhere in the form.
 */

var InkContainer = function (_PureComponent) {
  inherits(InkContainer, _PureComponent);

  function InkContainer() {
    var _ref;

    var _temp, _this, _ret;

    classCallCheck(this, InkContainer);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = possibleConstructorReturn(this, (_ref = InkContainer.__proto__ || Object.getPrototypeOf(InkContainer)).call.apply(_ref, [this].concat(args))), _this), _this.state = { inks: [] }, _this.createInk = function (pageX, pageY) {
      _this._createInk(pageX, pageY);
      _this._removeTimeout = setTimeout(function () {
        _this._removeTimeout = null;
        _this._removeInk();
      }, _this.props.transitionOverlap);
    }, _this.focus = function () {
      _this._getKeyboardContainer().focus();
    }, _this._createInk = function (pageX, pageY) {
      var _this$_inkContainer = _this._inkContainer,
          offsetWidth = _this$_inkContainer.offsetWidth,
          offsetHeight = _this$_inkContainer.offsetHeight;


      var x = void 0;
      var y = void 0;
      if (typeof pageX !== 'undefined' && typeof pageY !== 'undefined') {
        var pageOffset = calcPageOffset(_this._inkContainer);

        x = pageX - pageOffset.left;
        y = pageY - pageOffset.top;
      } else {
        x = offsetWidth / 2;
        y = offsetHeight / 2;
      }

      var r = Math.max(calculateHypotenuse(x, y), calculateHypotenuse(offsetWidth - x, y), calculateHypotenuse(offsetWidth - x, offsetHeight - y), calculateHypotenuse(x, offsetHeight - y));

      var ink = {
        left: x - r,
        top: y - r,
        size: r * 2,
        key: Date.now()
      };

      var inks = _this.state.inks.slice();
      inks.push(ink);
      _this.setState({ inks: inks });
    }, _this._removeInk = function () {
      var inks = _this.state.inks.slice();
      inks.pop();

      _this.setState({ inks: inks });
    }, _this._getKeyboardContainer = function () {
      if (_this._container.classList.contains('md-text-field-container')) {
        return _this._container.querySelector('.md-text-field');
      }

      return _this._container;
    }, _this._setContainers = function (group) {
      if (group !== null) {
        _this._inkContainer = findDOMNode(group);
        _this._container = _this._inkContainer.parentElement;

        if (_this._container) {
          _this._initOrRemoveEvents(_this.props);
        }
      }
    }, _this._initOrRemoveEvents = function (props) {
      var keyboardDiff = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
      var mouseDiff = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;
      var touchDiff = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : true;

      var mouseDisabled = _this._isListenerDisabled('mouse', props.disabledInteractions);
      var touchDisabled = _this._isListenerDisabled('touch', props.disabledInteractions);
      var keyboardDisabled = _this._isListenerDisabled('keyboard', props.disabledInteractions);

      if (keyboardDiff) {
        var fn = (keyboardDisabled ? 'remove' : 'add') + 'EventListener';
        _this._getKeyboardContainer()[fn]('focus', _this._handleFocus);
        _this._getKeyboardContainer()[fn]('keydown', _this._handleKeyDown);

        if (_this._container.getAttribute('type') === 'submit') {
          window[fn]('submit', _this._handleSubmit);
        }

        if (mouseDiff) {
          _this._container[(!mouseDisabled ? 'add' : 'remove') + 'EventListener']('mousedown', _this._stopPropagationToFocus);
        }

        if (touchDiff) {
          setTouchEvent(!touchDisabled, _this._container, 'start', _this._stopPropagationToFocus);
        }
      }

      if (mouseDiff) {
        var _fn = (mouseDisabled ? 'remove' : 'add') + 'EventListener';
        _this._container[_fn]('mousedown', _this._handleMouseDown);
        _this._container[_fn]('mouseup', _this._handleMouseUp);
      }

      if (touchDiff) {
        setTouchEvent(!touchDisabled, _this._container, 'start', _this._handleTouchStart);
        setTouchEvent(!touchDisabled, _this._container, 'end', _this._handleTouchEnd);
      }
    }, _this._maybeDelayClick = function () {
      if (!_this.props.waitForInkTransition) {
        return;
      }

      captureNextEvent('click', _this._container);
    }, _this._handleRemove = function () {
      if (_this._clicked && _this.props.waitForInkTransition) {
        // For some reason if the click event will make the ink unmount, it will no longer
        // have a debug id in the TransitionGroup and it displays a warning. Adding a 1ms timeout
        // fixes that issue... It only happens on an actual click instead of an enter click.
        setTimeout(function () {
          _this._container.click();
        }, 1);
      }

      _this._clicked = false;
    }, _this._handleKeyDown = function (e) {
      var key = e.which || e.keyCode;
      var enter = key === ENTER;
      var space = key === SPACE;
      // Don't trigger ink when enter key is pressed and the target has an input inside of it (SelectField)
      if (space || enter && !isFormPartRole(e.target) && !e.target.querySelector('input')) {
        _this._clicked = true;
        _this.createInk();
        _this._maybeDelayClick();
      }
    }, _this._handleFocus = function () {
      if (_this._clicked) {
        return;
      }

      _this._createInk();
      _this._getKeyboardContainer().addEventListener('blur', _this._handleBlur);
    }, _this._handleBlur = function () {
      _this._getKeyboardContainer().removeEventListener('blur', _this._handleBlur);
      _this._removeInk();
    }, _this._handleMouseDown = function (e) {
      _this._clicked = true;
      if (!isValidClick(e) || _this._skipNextMouse) {
        _this._skipNextMouse = false;
        return;
      }

      _this._mouseLeave = false;
      _this._container.addEventListener('mouseleave', _this._handleMouseLeave);
      _this._createInk(e.pageX, e.pageY);
    }, _this._handleMouseLeave = function () {
      _this._container.removeEventListener('mouseleave', _this._handleMouseLeave);
      _this._mouseLeave = true;
      _this._removeInk();
    }, _this._handleMouseUp = function () {
      if (_this._mouseLeave) {
        return;
      }

      _this._maybeDelayClick();
      _this._container.removeEventListener('mouseleave', _this._handleMouseLeave);
      _this._removeInk();
    }, _this._handleTouchStart = function (e) {
      _this._aborted = false;
      _this._clicked = true;
      _this._skipNextMouse = true;
      addTouchEvent(window, 'move', _this._handleTouchMove);

      var _e$changedTouches$ = e.changedTouches[0],
          pageX = _e$changedTouches$.pageX,
          pageY = _e$changedTouches$.pageY;

      _this._createInk(pageX, pageY);
    }, _this._handleTouchMove = function () {
      removeTouchEvent(window, 'move', _this._handleTouchMove);
      var lastInk = _this.state.inks[_this.state.inks.length - 1];
      if (!lastInk || Date.now() > lastInk.key + 200) {
        _this._aborted = false;
        return;
      }

      var inks = _this.state.inks.slice();
      var index = inks.length - 1;

      var abortedInk = Object.assign({}, lastInk, { aborted: true });
      inks.splice(index, 1, abortedInk);

      _this._aborted = true;
      _this.setState({ inks: inks }, _this._removeInk);
    }, _this._handleTouchEnd = function () {
      _this._skipNextMouse = true;

      if (_this._aborted) {
        return;
      } else {
        removeTouchEvent(window, 'move', _this._handleTouchMove);
      }

      _this._removeInk();
    }, _this._handleSubmit = function (e) {
      if (document.activeElement === _this._container || !e.target.contains(_this._container)) {
        return;
      }

      _this._maybeDelayClick();
      _this.createInk();
    }, _this._stopPropagationToFocus = function (e) {
      switch (e.type) {
        case 'touchstart':
          addTouchEvent(window, 'end', _this._stopPropagationToFocus, { capture: true });
          break;
        case 'touchend':
          removeTouchEvent(window, 'end', _this._stopPropagationToFocus, { capture: true });
          break;
        case 'mousedown':
          window.addEventListener('mouseup', _this._stopPropagationToFocus, true);
          break;
        case 'mouseup':
          window.removeEventListener('mouseup', _this._stopPropagationToFocus, true);
          break;
        default:
      }
    }, _temp), possibleConstructorReturn(_this, _ret);
  }

  createClass(InkContainer, [{
    key: 'componentWillReceiveProps',
    value: function componentWillReceiveProps(nextProps) {
      var di = this.props.disabledInteractions;
      var ndi = nextProps.disabledInteractions;

      if (di === ndi || !this._container) {
        return;
      }

      var mouseDisabledDiff = this._isListenerDisabledDiff('mouse', di, ndi);
      var touchDisabledDiff = this._isListenerDisabledDiff('touch', di, ndi);
      var keyboardDisabledDiff = this._isListenerDisabledDiff('keyboard', di, ndi);
      this._initOrRemoveEvents(nextProps, keyboardDisabledDiff, mouseDisabledDiff, touchDisabledDiff);
    }
  }, {
    key: 'componentWillUnmount',
    value: function componentWillUnmount() {
      if (this._removeTimeout) {
        clearTimeout(this._removeTimeout);
      }

      if (this._container) {
        this._initOrRemoveEvents({ disabledInteractions: ['keyboard', 'mouse', 'touch'] });
        this._getKeyboardContainer().removeEventListener('blur', this._handleBlur);
      }
    }

    /**
     * Creates an ink from pageX and pageY coordinates. These values should either come
     * from the `changedTouches` or just the base event (if clicked). These coordinates
     * are used to position the ink correctly in the container from touch/click point.
     * If either value is undefined, an ink will be created from the center of the
     * container.
     *
     * It will also automatically remove the ink.
     *
     * @param {number} pageX - The page x coordinate of the click or touch event.
     * @param {number} pageY - The page y coordinate of the click or touch event.
     */


    /**
     * Focuses the main element.
     */

  }, {
    key: '_isListenerDisabledDiff',
    value: function _isListenerDisabledDiff(interaction, disabledInteractions, nextDisabledInteractions) {
      var i = disabledInteractions.indexOf(interaction);
      var ni = nextDisabledInteractions.indexOf(interaction);

      return i < 0 && ni >= 0 || i >= 0 && ni < 0;
    }
  }, {
    key: '_isListenerDisabled',
    value: function _isListenerDisabled(interaction, disabledInteractions) {
      return disabledInteractions && disabledInteractions.indexOf(interaction) !== -1;
    }

    /**
     * Creates an ink from pageX and pageY coordinates. These values should either come
     * from the `changedTouches` or just the base event (if clicked). These coordinates
     * are used to position the ink correctly in the container from touch/click point.
     * If either value is undefined, an ink will be created from the center of the
     * container.
     *
     * @param {number} pageX - The page x coordinate of the click or touch event.
     * @param {number} pageY - The page y coordinate of the click or touch event.
     */


    /**
     * Removes an ink from the container.
     */


    /**
     * Gets the container for any keyboard events. This will almost always be the main element,
     * but text fields will need to be the input itself.
     */


    /**
     * Sets the ink container and the main container from the ref callback. When the component
     * is mounting, the keyboard, mouse, and keyboard events will be initialized.
     */


    /**
     * This function will either add or remove the event listeners for creating inks.
     *
     * @param {Object} props - The current props to use for figuring out if the events should
     *    be added or removed.
     * @param {bool=} keyboardDiff - Boolean if there was a difference between the current props and either
     *    the previous or next props for the keyboard interactions being disabled.
     * @param {bool=} mouseDiff - Boolean if there was a difference between the current props and either
     *    the previous or next props for the mouse interactions being disabled.
     * @param {bool=} touchDiff - Boolean if there was a difference between the current props and either
     *    the previous or next props for the touch interactions being disabled.
     */


    /**
     * If a form was submitted that contains the container of the ink and the current focus element
     * is not the container, trigger an ink effect.
     *
     * The current focus check is added so that two inks are not created.
     */

  }, {
    key: 'render',
    value: function render() {
      var _this2 = this;

      var _props = this.props,
          style = _props.style,
          className = _props.className,
          inkStyle = _props.inkStyle,
          inkClassName = _props.inkClassName,
          transitionOverlap = _props.transitionOverlap,
          transitionEnterTimeout = _props.transitionEnterTimeout,
          transitionLeaveTimeout = _props.transitionLeaveTimeout,
          pulse = _props.pulse;

      var inks = this.state.inks.map(function (props) {
        return React.createElement(Ink, _extends({}, props, {
          pulse: pulse,
          style: inkStyle,
          className: inkClassName,
          onRemove: _this2._handleRemove,
          transitionOverlap: transitionOverlap,
          transitionEnterTimeout: transitionEnterTimeout,
          transitionLeaveTimeout: transitionLeaveTimeout
        }));
      });

      return React.createElement(
        TransitionGroup,
        {
          component: 'div',
          style: style,
          className: classnames('md-ink-container', className),
          ref: this._setContainers
        },
        inks
      );
    }
  }]);
  return InkContainer;
}(PureComponent);

InkContainer.propTypes = {
  style: propTypes.object,
  className: propTypes.string,
  inkStyle: propTypes.object,
  inkClassName: propTypes.string,
  waitForInkTransition: propTypes.bool,
  disabledInteractions: propTypes.arrayOf(propTypes.oneOf(['keyboard', 'mouse', 'touch'])),
  transitionOverlap: propTypes.number.isRequired,
  transitionEnterTimeout: propTypes.number.isRequired,
  transitionLeaveTimeout: propTypes.number.isRequired,
  pulse: propTypes.bool
};
InkContainer.defaultProps = {
  transitionOverlap: 150,
  transitionEnterTimeout: 450,
  transitionLeaveTimeout: 300
};

var inkContextTypes = {
  inkDisabled: propTypes.bool,
  inkDisabledInteractions: propTypes.arrayOf(propTypes.oneOf(['keyboard', 'mouse', 'touch']))
};

/**
 * Takes any component and injects an ink container for having the Material Design Ink effect.
 *
 * The default triggers for an ink are:
 * - mouse down event
 * - touch start event
 * - keyboard focus
 * - form submit
 *
 * The form submit ink will only be triggered if the `ComposedComponent` has the attribute
 * `type="submit"`, the `ComposedComponent` is in a form, and the user hits the `enter` key
 * while not actively focusing the `ComposedComponent`.
 *
 * ```js
 * @param {function} ComposedComponent - The React Component to inject an `ink` prop into.
 * @return {function} a new React class rendering the `ComposedComponent` and adding an
 *    `ink` pop.
 * ```
 */
var injectInk = (function (ComposedComponent) {
  var _class, _temp2;

  return _temp2 = _class = function (_PureComponent) {
    inherits(InkedComponent, _PureComponent);

    function InkedComponent() {
      var _ref;

      var _temp, _this, _ret;

      classCallCheck(this, InkedComponent);

      for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      return _ret = (_temp = (_this = possibleConstructorReturn(this, (_ref = InkedComponent.__proto__ || Object.getPrototypeOf(InkedComponent)).call.apply(_ref, [this].concat(args))), _this), _this.createInk = function (pageX, pageY) {
        if (_this._inkContainer && !_this.props.disabled && !_this.props.inkDisabled) {
          _this._inkContainer.createInk(pageX, pageY);
        }
      }, _this.focus = function () {
        if (_this.props.inkDisabled) {
          var composed = findDOMNode(_this._composed);
          if (composed) {
            composed.focus();
          }
        } else if (_this._inkContainer) {
          _this._inkContainer.focus();
        }
      }, _this.getComposedComponent = function () {
        return _this._composed;
      }, _this._setInkRef = function (inkContainer) {
        if (inkContainer) {
          _this._inkContainer = inkContainer;
        }
      }, _this._setComposedComponent = function (component) {
        _this._composed = component;
      }, _temp), possibleConstructorReturn(_this, _ret);
    }

    createClass(InkedComponent, [{
      key: 'componentDidMount',
      value: function componentDidMount() {
        var ref = this.props.__SUPER_SECRET_REF__;
        // Emulate the ref callback...

        if (ref) {
          ref(this);
        }
      }
    }, {
      key: 'componentWillUnmount',
      value: function componentWillUnmount() {
        var ref = this.props.__SUPER_SECRET_REF__;
        // Emulate the ref callback...

        if (ref) {
          ref(null);
        }
      }

      /**
       * A publicly accessible way to manually create an ink. This can be used with the `refs`.
       * The ink can either be created by using the `pageX` and `pageY` from a click/touch event
       * or it will be created in the center of the `ComposedComponent`.
       *
       * ```js
       * <SomeInkedComponent ref={inkHOC => inkHOC.createInk()} />
       * ```
       *
       * @param {number=} pageX - An optional pageX of the click or touch event.
       * @param {number=} pageY - An optional pageY of the click or touch event.
       */


      /**
       * This will attempt to focus the composed component. If the component is disabled, nothing
       * will happen. If the `disabled` and `inkDisabled` props are not set to `true`, an ink will
       * also be created.
       *
       * ```js
       * <SomeInkedComponent ref={inkHOC => inkHOC.focus()} />
       * ```
       */


      /**
       * Gets the composed component as a ref. This is useful if you need to access the ref of the
       * composed component instead of the `injectInk` HOC to use some publicly accessible methods.
       *
       * ```js
       * <SomeInkedComponent
       *   ref={inkHOC => {
       *     inkHOC.getComposedComponent().focus();
       *   }}
       * />
       * ```
       */

    }, {
      key: 'render',
      value: function render() {
        var _props = this.props,
            transitionOverlap = _props.inkTransitionOverlap,
            transitionEnterTimeout = _props.inkTransitionEnterTimeout,
            transitionLeaveTimeout = _props.inkTransitionLeaveTimeout,
            inkStyle = _props.inkStyle,
            inkClassName = _props.inkClassName,
            inkContainerStyle = _props.inkContainerStyle,
            inkContainerClassName = _props.inkContainerClassName,
            waitForInkTransition = _props.waitForInkTransition,
            disabledInteractions = _props.disabledInteractions,
            pulse = _props.pulse,
            propInkDisabled = _props.inkDisabled,
            __SUPER_SECRET_REF__ = _props.__SUPER_SECRET_REF__,
            props = objectWithoutProperties(_props, ['inkTransitionOverlap', 'inkTransitionEnterTimeout', 'inkTransitionLeaveTimeout', 'inkStyle', 'inkClassName', 'inkContainerStyle', 'inkContainerClassName', 'waitForInkTransition', 'disabledInteractions', 'pulse', 'inkDisabled', '__SUPER_SECRET_REF__']);


        var inkDisabled = getField(this.props, this.context, 'inkDisabled');
        var inkDisabledInteractions = typeof disabledInteractions !== 'undefined' ? disabledInteractions : this.context.inkDisabledInteractions;

        if (!(props.disabled || inkDisabled)) {
          props.ink = React.createElement(InkContainer, {
            ref: this._setInkRef,
            key: 'ink-container',
            pulse: pulse,
            style: inkContainerStyle,
            className: inkContainerClassName,
            inkStyle: inkStyle,
            inkClassName: inkClassName,
            disabledInteractions: inkDisabledInteractions,
            transitionOverlap: transitionOverlap,
            transitionEnterTimeout: transitionEnterTimeout,
            transitionLeaveTimeout: transitionLeaveTimeout,
            waitForInkTransition: waitForInkTransition
          });
        }

        props.ref = this._setComposedComponent;

        return React.createElement(ComposedComponent, props);
      }
    }]);
    return InkedComponent;
  }(PureComponent), _class.displayName = getDisplayName(ComposedComponent, 'Ink'), _class.propTypes = {
    /**
     * An optional style to apply to each ink that gets generated.
     */
    inkStyle: propTypes.object,

    /**
     * An optional className to apply to each ink that gets generated.
     */
    inkClassName: propTypes.string,

    /**
     * An optional style to apply to the ink's container.
     */
    inkContainerStyle: propTypes.object,

    /**
     * An optional className to apply to the ink's container.
     */
    inkContainerClassName: propTypes.string,

    /**
     * Boolean if the composed component or the ink is disabled.
     */
    disabled: propTypes.bool,

    /**
     * Boolean if only the ink is disabled for the composed component.
     */
    inkDisabled: propTypes.bool,

    /**
     * The time (in ms) that the enter and leave transitions for the ink should overlap.
     * This really just allows for a more _fluid_ looking ink when something is quickly
     * touched or clicked by having it fade out while growing.
     */
    inkTransitionOverlap: propTypes.number.isRequired,

    /**
     * The transition time for the ink to be considered fully entered. This should really
     * map up to whatever value you set for `$md-ink-enter-transition-time`.
     */
    inkTransitionEnterTimeout: propTypes.number.isRequired,

    /**
     * The transition time for the ink to be considered fully leaved (left?). This should really
     * map up to whatever value you set for `$md-ink-leave-transition-time`.
     */
    inkTransitionLeaveTimeout: propTypes.number.isRequired,

    /**
     * Boolean if the `ComposedComponent`'s click event only after the ink has finished transitioning
     * in and out. This is really only to get a more _fluid_ looking click event when clicking on
     * the `ComposedComponent` ends up taking it out of the view. (ex: Closing a Dialog).
     */
    waitForInkTransition: propTypes.bool,

    /**
     * An optional array of interactions that can be disabled for the ink. This is a *very* limited
     * use case where `Switches` needed the ink disabled only when using a mouse.
     */
    disabledInteractions: propTypes.arrayOf(propTypes.oneOf(['keyboard', 'mouse', 'touch'])),

    /**
     * Boolean if the ink should do a pulse animation while focused. This was enabled by default in
     * previous versions.
     */
    pulse: propTypes.bool,

    /**
     * When using inked components in a `TransitionGroup`, the ref callback is not actually invoked.
     * This is a little _hack_ to get it to work by not using `ref`, but this name.
     */
    __SUPER_SECRET_REF__: propTypes.func
  }, _class.defaultProps = {
    inkTransitionOverlap: 150,
    inkTransitionEnterTimeout: 450,
    inkTransitionLeaveTimeout: 300
  }, _class.contextTypes = inkContextTypes, _temp2;
});

var AccessibleFakeInkedButton = injectInk(AccessibleFakeButton);

var mapToZero_1 = createCommonjsModule(function (module, exports) {
// currently used to initiate the velocity style object to 0
'use strict';

exports.__esModule = true;
exports['default'] = mapToZero;

function mapToZero(obj) {
  var ret = {};
  for (var key in obj) {
    if (Object.prototype.hasOwnProperty.call(obj, key)) {
      ret[key] = 0;
    }
  }
  return ret;
}

module.exports = exports['default'];
});

unwrapExports(mapToZero_1);

var stripStyle_1 = createCommonjsModule(function (module, exports) {
// turn {x: {val: 1, stiffness: 1, damping: 2}, y: 2} generated by
// `{x: spring(1, {stiffness: 1, damping: 2}), y: 2}` into {x: 1, y: 2}

'use strict';

exports.__esModule = true;
exports['default'] = stripStyle;

function stripStyle(style) {
  var ret = {};
  for (var key in style) {
    if (!Object.prototype.hasOwnProperty.call(style, key)) {
      continue;
    }
    ret[key] = typeof style[key] === 'number' ? style[key] : style[key].val;
  }
  return ret;
}

module.exports = exports['default'];
});

unwrapExports(stripStyle_1);

var stepper_1 = createCommonjsModule(function (module, exports) {
// stepper is used a lot. Saves allocation to return the same array wrapper.
// This is fine and danger-free against mutations because the callsite
// immediately destructures it and gets the numbers inside without passing the
"use strict";

exports.__esModule = true;
exports["default"] = stepper;

var reusedTuple = [0, 0];

function stepper(secondPerFrame, x, v, destX, k, b, precision) {
  // Spring stiffness, in kg / s^2

  // for animations, destX is really spring length (spring at rest). initial
  // position is considered as the stretched/compressed position of a spring
  var Fspring = -k * (x - destX);

  // Damping, in kg / s
  var Fdamper = -b * v;

  // usually we put mass here, but for animation purposes, specifying mass is a
  // bit redundant. you could simply adjust k and b accordingly
  // let a = (Fspring + Fdamper) / mass;
  var a = Fspring + Fdamper;

  var newV = v + a * secondPerFrame;
  var newX = x + newV * secondPerFrame;

  if (Math.abs(newV) < precision && Math.abs(newX - destX) < precision) {
    reusedTuple[0] = destX;
    reusedTuple[1] = 0;
    return reusedTuple;
  }

  reusedTuple[0] = newX;
  reusedTuple[1] = newV;
  return reusedTuple;
}

module.exports = exports["default"];
// array reference around.
});

unwrapExports(stepper_1);

var performanceNow = createCommonjsModule(function (module) {
// Generated by CoffeeScript 1.7.1
(function() {
  var getNanoSeconds, hrtime, loadTime;

  if ((typeof performance !== "undefined" && performance !== null) && performance.now) {
    module.exports = function() {
      return performance.now();
    };
  } else if ((typeof process !== "undefined" && process !== null) && process.hrtime) {
    module.exports = function() {
      return (getNanoSeconds() - loadTime) / 1e6;
    };
    hrtime = process.hrtime;
    getNanoSeconds = function() {
      var hr;
      hr = hrtime();
      return hr[0] * 1e9 + hr[1];
    };
    loadTime = getNanoSeconds();
  } else if (Date.now) {
    module.exports = function() {
      return Date.now() - loadTime;
    };
    loadTime = Date.now();
  } else {
    module.exports = function() {
      return new Date().getTime() - loadTime;
    };
    loadTime = new Date().getTime();
  }

}).call(commonjsGlobal);
});

var root = typeof window === 'undefined' ? commonjsGlobal : window;
var vendors = ['moz', 'webkit'];
var suffix = 'AnimationFrame';
var raf = root['request' + suffix];
var caf = root['cancel' + suffix] || root['cancelRequest' + suffix];

for(var i = 0; !raf && i < vendors.length; i++) {
  raf = root[vendors[i] + 'Request' + suffix];
  caf = root[vendors[i] + 'Cancel' + suffix]
      || root[vendors[i] + 'CancelRequest' + suffix];
}

// Some versions of FF have rAF but not cAF
if(!raf || !caf) {
  var last = 0
    , id = 0
    , queue = []
    , frameDuration = 1000 / 60;

  raf = function(callback) {
    if(queue.length === 0) {
      var _now = performanceNow()
        , next = Math.max(0, frameDuration - (_now - last));
      last = next + _now;
      setTimeout(function() {
        var cp = queue.slice(0);
        // Clear queue here to prevent
        // callbacks from appending listeners
        // to the current frame's queue
        queue.length = 0;
        for(var i = 0; i < cp.length; i++) {
          if(!cp[i].cancelled) {
            try{
              cp[i].callback(last);
            } catch(e) {
              setTimeout(function() { throw e }, 0);
            }
          }
        }
      }, Math.round(next));
    }
    queue.push({
      handle: ++id,
      callback: callback,
      cancelled: false
    });
    return id
  };

  caf = function(handle) {
    for(var i = 0; i < queue.length; i++) {
      if(queue[i].handle === handle) {
        queue[i].cancelled = true;
      }
    }
  };
}

var raf_1 = function(fn) {
  // Wrap in a new function to prevent
  // `cancel` potentially being assigned
  // to the native rAF function
  return raf.call(root, fn)
};
var cancel = function() {
  caf.apply(root, arguments);
};
var polyfill = function() {
  root.requestAnimationFrame = raf;
  root.cancelAnimationFrame = caf;
};

raf_1.cancel = cancel;
raf_1.polyfill = polyfill;

var shouldStopAnimation_1 = createCommonjsModule(function (module, exports) {
// usage assumption: currentStyle values have already been rendered but it says
// nothing of whether currentStyle is stale (see unreadPropStyle)
'use strict';

exports.__esModule = true;
exports['default'] = shouldStopAnimation;

function shouldStopAnimation(currentStyle, style, currentVelocity) {
  for (var key in style) {
    if (!Object.prototype.hasOwnProperty.call(style, key)) {
      continue;
    }

    if (currentVelocity[key] !== 0) {
      return false;
    }

    var styleValue = typeof style[key] === 'number' ? style[key] : style[key].val;
    // stepper will have already taken care of rounding precision errors, so
    // won't have such thing as 0.9999 !=== 1
    if (currentStyle[key] !== styleValue) {
      return false;
    }
  }

  return true;
}

module.exports = exports['default'];
});

unwrapExports(shouldStopAnimation_1);

"use strict";

/**
 * Copyright (c) 2013-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * 
 */

function makeEmptyFunction$2(arg) {
  return function () {
    return arg;
  };
}

/**
 * This function accepts and discards inputs; it has no side effects. This is
 * primarily useful idiomatically for overridable function endpoints which
 * always need to be callable, since JS lacks a null-call idiom ala Cocoa.
 */
var emptyFunction$4 = function emptyFunction() {};

emptyFunction$4.thatReturns = makeEmptyFunction$2;
emptyFunction$4.thatReturnsFalse = makeEmptyFunction$2(false);
emptyFunction$4.thatReturnsTrue = makeEmptyFunction$2(true);
emptyFunction$4.thatReturnsNull = makeEmptyFunction$2(null);
emptyFunction$4.thatReturnsThis = function () {
  return this;
};
emptyFunction$4.thatReturnsArgument = function (arg) {
  return arg;
};

var emptyFunction_1$4 = emptyFunction$4;

/**
 * Copyright (c) 2013-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 */

'use strict';

/**
 * Use invariant() to assert state which your program assumes to be true.
 *
 * Provide sprintf-style format (only %s is supported) and arguments
 * to provide information about what broke and what you were
 * expecting.
 *
 * The invariant message will be stripped in production, but the invariant
 * will remain to ensure logic does not differ in production.
 */

var validateFormat$2 = function validateFormat(format) {};

if (process.env.NODE_ENV !== 'production') {
  validateFormat$2 = function validateFormat(format) {
    if (format === undefined) {
      throw new Error('invariant requires an error message argument');
    }
  };
}

function invariant$6(condition, format, a, b, c, d, e, f) {
  validateFormat$2(format);

  if (!condition) {
    var error;
    if (format === undefined) {
      error = new Error('Minified exception occurred; use the non-minified dev environment ' + 'for the full error message and additional helpful warnings.');
    } else {
      var args = [a, b, c, d, e, f];
      var argIndex = 0;
      error = new Error(format.replace(/%s/g, function () {
        return args[argIndex++];
      }));
      error.name = 'Invariant Violation';
    }

    error.framesToPop = 1; // we don't care about invariant's own frame
    throw error;
  }
}

var invariant_1$4 = invariant$6;

/**
 * Copyright 2014-2015, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 */

'use strict';



/**
 * Similar to invariant but only logs a warning if the condition is not met.
 * This can be used to log issues in development environments in critical
 * paths. Removing the logging code for production environments will keep the
 * same logic and follow the same code paths.
 */

var warning$5 = emptyFunction_1$4;

if (process.env.NODE_ENV !== 'production') {
  (function () {
    var printWarning = function printWarning(format) {
      for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }

      var argIndex = 0;
      var message = 'Warning: ' + format.replace(/%s/g, function () {
        return args[argIndex++];
      });
      if (typeof console !== 'undefined') {
        console.error(message);
      }
      try {
        // --- Welcome to debugging React ---
        // This error was thrown as a convenience so that you can use this stack
        // to find the callsite that caused this warning to fire.
        throw new Error(message);
      } catch (x) {}
    };

    warning$5 = function warning(condition, format) {
      if (format === undefined) {
        throw new Error('`warning(condition, format, ...args)` requires a warning ' + 'message argument');
      }

      if (format.indexOf('Failed Composite propType: ') === 0) {
        return; // Ignore CompositeComponent proptype check.
      }

      if (!condition) {
        for (var _len2 = arguments.length, args = Array(_len2 > 2 ? _len2 - 2 : 0), _key2 = 2; _key2 < _len2; _key2++) {
          args[_key2 - 2] = arguments[_key2];
        }

        printWarning.apply(undefined, [format].concat(args));
      }
    };
  })();
}

var warning_1$4 = warning$5;

/**
 * Copyright 2013-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 */

'use strict';

var ReactPropTypesSecret$6 = 'SECRET_DO_NOT_PASS_THIS_OR_YOU_WILL_BE_FIRED';

var ReactPropTypesSecret_1$4 = ReactPropTypesSecret$6;

/**
 * Copyright 2013-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 */

'use strict';

if (process.env.NODE_ENV !== 'production') {
  var invariant$7 = invariant_1$4;
  var warning$6 = warning_1$4;
  var ReactPropTypesSecret$7 = ReactPropTypesSecret_1$4;
  var loggedTypeFailures$2 = {};
}

/**
 * Assert that the values match with the type specs.
 * Error messages are memorized and will only be shown once.
 *
 * @param {object} typeSpecs Map of name to a ReactPropType
 * @param {object} values Runtime values that need to be type-checked
 * @param {string} location e.g. "prop", "context", "child context"
 * @param {string} componentName Name of the component for error messages.
 * @param {?Function} getStack Returns the component stack.
 * @private
 */
function checkPropTypes$4(typeSpecs, values, location, componentName, getStack) {
  if (process.env.NODE_ENV !== 'production') {
    for (var typeSpecName in typeSpecs) {
      if (typeSpecs.hasOwnProperty(typeSpecName)) {
        var error;
        // Prop type validation may throw. In case they do, we don't want to
        // fail the render phase where it didn't fail before. So we log it.
        // After these have been cleaned up, we'll let them throw.
        try {
          // This is intentionally an invariant that gets caught. It's the same
          // behavior as without this statement except with a better message.
          invariant$7(typeof typeSpecs[typeSpecName] === 'function', '%s: %s type `%s` is invalid; it must be a function, usually from ' + 'React.PropTypes.', componentName || 'React class', location, typeSpecName);
          error = typeSpecs[typeSpecName](values, typeSpecName, componentName, location, null, ReactPropTypesSecret$7);
        } catch (ex) {
          error = ex;
        }
        warning$6(!error || error instanceof Error, '%s: type specification of %s `%s` is invalid; the type checker ' + 'function must return `null` or an `Error` but returned a %s. ' + 'You may have forgotten to pass an argument to the type checker ' + 'creator (arrayOf, instanceOf, objectOf, oneOf, oneOfType, and ' + 'shape all require an argument).', componentName || 'React class', location, typeSpecName, typeof error);
        if (error instanceof Error && !(error.message in loggedTypeFailures$2)) {
          // Only monitor this failure once because there tends to be a lot of the
          // same error.
          loggedTypeFailures$2[error.message] = true;

          var stack = getStack ? getStack() : '';

          warning$6(false, 'Failed %s type: %s%s', location, error.message, stack != null ? stack : '');
        }
      }
    }
  }
}

var checkPropTypes_1$4 = checkPropTypes$4;

/**
 * Copyright 2013-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 */

'use strict';








var factoryWithTypeCheckers$4 = function(isValidElement$$1, throwOnDirectAccess) {
  /* global Symbol */
  var ITERATOR_SYMBOL = typeof Symbol === 'function' && Symbol.iterator;
  var FAUX_ITERATOR_SYMBOL = '@@iterator'; // Before Symbol spec.

  /**
   * Returns the iterator method function contained on the iterable object.
   *
   * Be sure to invoke the function with the iterable as context:
   *
   *     var iteratorFn = getIteratorFn(myIterable);
   *     if (iteratorFn) {
   *       var iterator = iteratorFn.call(myIterable);
   *       ...
   *     }
   *
   * @param {?object} maybeIterable
   * @return {?function}
   */
  function getIteratorFn(maybeIterable) {
    var iteratorFn = maybeIterable && (ITERATOR_SYMBOL && maybeIterable[ITERATOR_SYMBOL] || maybeIterable[FAUX_ITERATOR_SYMBOL]);
    if (typeof iteratorFn === 'function') {
      return iteratorFn;
    }
  }

  /**
   * Collection of methods that allow declaration and validation of props that are
   * supplied to React components. Example usage:
   *
   *   var Props = require('ReactPropTypes');
   *   var MyArticle = React.createClass({
   *     propTypes: {
   *       // An optional string prop named "description".
   *       description: Props.string,
   *
   *       // A required enum prop named "category".
   *       category: Props.oneOf(['News','Photos']).isRequired,
   *
   *       // A prop named "dialog" that requires an instance of Dialog.
   *       dialog: Props.instanceOf(Dialog).isRequired
   *     },
   *     render: function() { ... }
   *   });
   *
   * A more formal specification of how these methods are used:
   *
   *   type := array|bool|func|object|number|string|oneOf([...])|instanceOf(...)
   *   decl := ReactPropTypes.{type}(.isRequired)?
   *
   * Each and every declaration produces a function with the same signature. This
   * allows the creation of custom validation functions. For example:
   *
   *  var MyLink = React.createClass({
   *    propTypes: {
   *      // An optional string or URI prop named "href".
   *      href: function(props, propName, componentName) {
   *        var propValue = props[propName];
   *        if (propValue != null && typeof propValue !== 'string' &&
   *            !(propValue instanceof URI)) {
   *          return new Error(
   *            'Expected a string or an URI for ' + propName + ' in ' +
   *            componentName
   *          );
   *        }
   *      }
   *    },
   *    render: function() {...}
   *  });
   *
   * @internal
   */

  var ANONYMOUS = '<<anonymous>>';

  // Important!
  // Keep this list in sync with production version in `./factoryWithThrowingShims.js`.
  var ReactPropTypes = {
    array: createPrimitiveTypeChecker('array'),
    bool: createPrimitiveTypeChecker('boolean'),
    func: createPrimitiveTypeChecker('function'),
    number: createPrimitiveTypeChecker('number'),
    object: createPrimitiveTypeChecker('object'),
    string: createPrimitiveTypeChecker('string'),
    symbol: createPrimitiveTypeChecker('symbol'),

    any: createAnyTypeChecker(),
    arrayOf: createArrayOfTypeChecker,
    element: createElementTypeChecker(),
    instanceOf: createInstanceTypeChecker,
    node: createNodeChecker(),
    objectOf: createObjectOfTypeChecker,
    oneOf: createEnumTypeChecker,
    oneOfType: createUnionTypeChecker,
    shape: createShapeTypeChecker
  };

  /**
   * inlined Object.is polyfill to avoid requiring consumers ship their own
   * https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/is
   */
  /*eslint-disable no-self-compare*/
  function is(x, y) {
    // SameValue algorithm
    if (x === y) {
      // Steps 1-5, 7-10
      // Steps 6.b-6.e: +0 != -0
      return x !== 0 || 1 / x === 1 / y;
    } else {
      // Step 6.a: NaN == NaN
      return x !== x && y !== y;
    }
  }
  /*eslint-enable no-self-compare*/

  /**
   * We use an Error-like object for backward compatibility as people may call
   * PropTypes directly and inspect their output. However, we don't use real
   * Errors anymore. We don't inspect their stack anyway, and creating them
   * is prohibitively expensive if they are created too often, such as what
   * happens in oneOfType() for any type before the one that matched.
   */
  function PropTypeError(message) {
    this.message = message;
    this.stack = '';
  }
  // Make `instanceof Error` still work for returned errors.
  PropTypeError.prototype = Error.prototype;

  function createChainableTypeChecker(validate) {
    if (process.env.NODE_ENV !== 'production') {
      var manualPropTypeCallCache = {};
      var manualPropTypeWarningCount = 0;
    }
    function checkType(isRequired, props, propName, componentName, location, propFullName, secret) {
      componentName = componentName || ANONYMOUS;
      propFullName = propFullName || propName;

      if (secret !== ReactPropTypesSecret_1$4) {
        if (throwOnDirectAccess) {
          // New behavior only for users of `prop-types` package
          invariant_1$4(
            false,
            'Calling PropTypes validators directly is not supported by the `prop-types` package. ' +
            'Use `PropTypes.checkPropTypes()` to call them. ' +
            'Read more at http://fb.me/use-check-prop-types'
          );
        } else if (process.env.NODE_ENV !== 'production' && typeof console !== 'undefined') {
          // Old behavior for people using React.PropTypes
          var cacheKey = componentName + ':' + propName;
          if (
            !manualPropTypeCallCache[cacheKey] &&
            // Avoid spamming the console because they are often not actionable except for lib authors
            manualPropTypeWarningCount < 3
          ) {
            warning_1$4(
              false,
              'You are manually calling a React.PropTypes validation ' +
              'function for the `%s` prop on `%s`. This is deprecated ' +
              'and will throw in the standalone `prop-types` package. ' +
              'You may be seeing this warning due to a third-party PropTypes ' +
              'library. See https://fb.me/react-warning-dont-call-proptypes ' + 'for details.',
              propFullName,
              componentName
            );
            manualPropTypeCallCache[cacheKey] = true;
            manualPropTypeWarningCount++;
          }
        }
      }
      if (props[propName] == null) {
        if (isRequired) {
          if (props[propName] === null) {
            return new PropTypeError('The ' + location + ' `' + propFullName + '` is marked as required ' + ('in `' + componentName + '`, but its value is `null`.'));
          }
          return new PropTypeError('The ' + location + ' `' + propFullName + '` is marked as required in ' + ('`' + componentName + '`, but its value is `undefined`.'));
        }
        return null;
      } else {
        return validate(props, propName, componentName, location, propFullName);
      }
    }

    var chainedCheckType = checkType.bind(null, false);
    chainedCheckType.isRequired = checkType.bind(null, true);

    return chainedCheckType;
  }

  function createPrimitiveTypeChecker(expectedType) {
    function validate(props, propName, componentName, location, propFullName, secret) {
      var propValue = props[propName];
      var propType = getPropType(propValue);
      if (propType !== expectedType) {
        // `propValue` being instance of, say, date/regexp, pass the 'object'
        // check, but we can offer a more precise error message here rather than
        // 'of type `object`'.
        var preciseType = getPreciseType(propValue);

        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + preciseType + '` supplied to `' + componentName + '`, expected ') + ('`' + expectedType + '`.'));
      }
      return null;
    }
    return createChainableTypeChecker(validate);
  }

  function createAnyTypeChecker() {
    return createChainableTypeChecker(emptyFunction_1$4.thatReturnsNull);
  }

  function createArrayOfTypeChecker(typeChecker) {
    function validate(props, propName, componentName, location, propFullName) {
      if (typeof typeChecker !== 'function') {
        return new PropTypeError('Property `' + propFullName + '` of component `' + componentName + '` has invalid PropType notation inside arrayOf.');
      }
      var propValue = props[propName];
      if (!Array.isArray(propValue)) {
        var propType = getPropType(propValue);
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + propType + '` supplied to `' + componentName + '`, expected an array.'));
      }
      for (var i = 0; i < propValue.length; i++) {
        var error = typeChecker(propValue, i, componentName, location, propFullName + '[' + i + ']', ReactPropTypesSecret_1$4);
        if (error instanceof Error) {
          return error;
        }
      }
      return null;
    }
    return createChainableTypeChecker(validate);
  }

  function createElementTypeChecker() {
    function validate(props, propName, componentName, location, propFullName) {
      var propValue = props[propName];
      if (!isValidElement$$1(propValue)) {
        var propType = getPropType(propValue);
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + propType + '` supplied to `' + componentName + '`, expected a single ReactElement.'));
      }
      return null;
    }
    return createChainableTypeChecker(validate);
  }

  function createInstanceTypeChecker(expectedClass) {
    function validate(props, propName, componentName, location, propFullName) {
      if (!(props[propName] instanceof expectedClass)) {
        var expectedClassName = expectedClass.name || ANONYMOUS;
        var actualClassName = getClassName(props[propName]);
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + actualClassName + '` supplied to `' + componentName + '`, expected ') + ('instance of `' + expectedClassName + '`.'));
      }
      return null;
    }
    return createChainableTypeChecker(validate);
  }

  function createEnumTypeChecker(expectedValues) {
    if (!Array.isArray(expectedValues)) {
      process.env.NODE_ENV !== 'production' ? warning_1$4(false, 'Invalid argument supplied to oneOf, expected an instance of array.') : void 0;
      return emptyFunction_1$4.thatReturnsNull;
    }

    function validate(props, propName, componentName, location, propFullName) {
      var propValue = props[propName];
      for (var i = 0; i < expectedValues.length; i++) {
        if (is(propValue, expectedValues[i])) {
          return null;
        }
      }

      var valuesString = JSON.stringify(expectedValues);
      return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of value `' + propValue + '` ' + ('supplied to `' + componentName + '`, expected one of ' + valuesString + '.'));
    }
    return createChainableTypeChecker(validate);
  }

  function createObjectOfTypeChecker(typeChecker) {
    function validate(props, propName, componentName, location, propFullName) {
      if (typeof typeChecker !== 'function') {
        return new PropTypeError('Property `' + propFullName + '` of component `' + componentName + '` has invalid PropType notation inside objectOf.');
      }
      var propValue = props[propName];
      var propType = getPropType(propValue);
      if (propType !== 'object') {
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + propType + '` supplied to `' + componentName + '`, expected an object.'));
      }
      for (var key in propValue) {
        if (propValue.hasOwnProperty(key)) {
          var error = typeChecker(propValue, key, componentName, location, propFullName + '.' + key, ReactPropTypesSecret_1$4);
          if (error instanceof Error) {
            return error;
          }
        }
      }
      return null;
    }
    return createChainableTypeChecker(validate);
  }

  function createUnionTypeChecker(arrayOfTypeCheckers) {
    if (!Array.isArray(arrayOfTypeCheckers)) {
      process.env.NODE_ENV !== 'production' ? warning_1$4(false, 'Invalid argument supplied to oneOfType, expected an instance of array.') : void 0;
      return emptyFunction_1$4.thatReturnsNull;
    }

    for (var i = 0; i < arrayOfTypeCheckers.length; i++) {
      var checker = arrayOfTypeCheckers[i];
      if (typeof checker !== 'function') {
        warning_1$4(
          false,
          'Invalid argument supplid to oneOfType. Expected an array of check functions, but ' +
          'received %s at index %s.',
          getPostfixForTypeWarning(checker),
          i
        );
        return emptyFunction_1$4.thatReturnsNull;
      }
    }

    function validate(props, propName, componentName, location, propFullName) {
      for (var i = 0; i < arrayOfTypeCheckers.length; i++) {
        var checker = arrayOfTypeCheckers[i];
        if (checker(props, propName, componentName, location, propFullName, ReactPropTypesSecret_1$4) == null) {
          return null;
        }
      }

      return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` supplied to ' + ('`' + componentName + '`.'));
    }
    return createChainableTypeChecker(validate);
  }

  function createNodeChecker() {
    function validate(props, propName, componentName, location, propFullName) {
      if (!isNode(props[propName])) {
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` supplied to ' + ('`' + componentName + '`, expected a ReactNode.'));
      }
      return null;
    }
    return createChainableTypeChecker(validate);
  }

  function createShapeTypeChecker(shapeTypes) {
    function validate(props, propName, componentName, location, propFullName) {
      var propValue = props[propName];
      var propType = getPropType(propValue);
      if (propType !== 'object') {
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type `' + propType + '` ' + ('supplied to `' + componentName + '`, expected `object`.'));
      }
      for (var key in shapeTypes) {
        var checker = shapeTypes[key];
        if (!checker) {
          continue;
        }
        var error = checker(propValue, key, componentName, location, propFullName + '.' + key, ReactPropTypesSecret_1$4);
        if (error) {
          return error;
        }
      }
      return null;
    }
    return createChainableTypeChecker(validate);
  }

  function isNode(propValue) {
    switch (typeof propValue) {
      case 'number':
      case 'string':
      case 'undefined':
        return true;
      case 'boolean':
        return !propValue;
      case 'object':
        if (Array.isArray(propValue)) {
          return propValue.every(isNode);
        }
        if (propValue === null || isValidElement$$1(propValue)) {
          return true;
        }

        var iteratorFn = getIteratorFn(propValue);
        if (iteratorFn) {
          var iterator = iteratorFn.call(propValue);
          var step;
          if (iteratorFn !== propValue.entries) {
            while (!(step = iterator.next()).done) {
              if (!isNode(step.value)) {
                return false;
              }
            }
          } else {
            // Iterator will provide entry [k,v] tuples rather than values.
            while (!(step = iterator.next()).done) {
              var entry = step.value;
              if (entry) {
                if (!isNode(entry[1])) {
                  return false;
                }
              }
            }
          }
        } else {
          return false;
        }

        return true;
      default:
        return false;
    }
  }

  function isSymbol(propType, propValue) {
    // Native Symbol.
    if (propType === 'symbol') {
      return true;
    }

    // 19.4.3.5 Symbol.prototype[@@toStringTag] === 'Symbol'
    if (propValue['@@toStringTag'] === 'Symbol') {
      return true;
    }

    // Fallback for non-spec compliant Symbols which are polyfilled.
    if (typeof Symbol === 'function' && propValue instanceof Symbol) {
      return true;
    }

    return false;
  }

  // Equivalent of `typeof` but with special handling for array and regexp.
  function getPropType(propValue) {
    var propType = typeof propValue;
    if (Array.isArray(propValue)) {
      return 'array';
    }
    if (propValue instanceof RegExp) {
      // Old webkits (at least until Android 4.0) return 'function' rather than
      // 'object' for typeof a RegExp. We'll normalize this here so that /bla/
      // passes PropTypes.object.
      return 'object';
    }
    if (isSymbol(propType, propValue)) {
      return 'symbol';
    }
    return propType;
  }

  // This handles more types than `getPropType`. Only used for error messages.
  // See `createPrimitiveTypeChecker`.
  function getPreciseType(propValue) {
    if (typeof propValue === 'undefined' || propValue === null) {
      return '' + propValue;
    }
    var propType = getPropType(propValue);
    if (propType === 'object') {
      if (propValue instanceof Date) {
        return 'date';
      } else if (propValue instanceof RegExp) {
        return 'regexp';
      }
    }
    return propType;
  }

  // Returns a string that is postfixed to a warning about an invalid type.
  // For example, "undefined" or "of type array"
  function getPostfixForTypeWarning(value) {
    var type = getPreciseType(value);
    switch (type) {
      case 'array':
      case 'object':
        return 'an ' + type;
      case 'boolean':
      case 'date':
      case 'regexp':
        return 'a ' + type;
      default:
        return type;
    }
  }

  // Returns class name of the object, if any.
  function getClassName(propValue) {
    if (!propValue.constructor || !propValue.constructor.name) {
      return ANONYMOUS;
    }
    return propValue.constructor.name;
  }

  ReactPropTypes.checkPropTypes = checkPropTypes_1$4;
  ReactPropTypes.PropTypes = ReactPropTypes;

  return ReactPropTypes;
};

/**
 * Copyright 2013-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 */

'use strict';





var factoryWithThrowingShims$4 = function() {
  function shim(props, propName, componentName, location, propFullName, secret) {
    if (secret === ReactPropTypesSecret_1$4) {
      // It is still safe when called from React.
      return;
    }
    invariant_1$4(
      false,
      'Calling PropTypes validators directly is not supported by the `prop-types` package. ' +
      'Use PropTypes.checkPropTypes() to call them. ' +
      'Read more at http://fb.me/use-check-prop-types'
    );
  }
  shim.isRequired = shim;
  function getShim() {
    return shim;
  }
  // Important!
  // Keep this list in sync with production version in `./factoryWithTypeCheckers.js`.
  var ReactPropTypes = {
    array: shim,
    bool: shim,
    func: shim,
    number: shim,
    object: shim,
    string: shim,
    symbol: shim,

    any: shim,
    arrayOf: getShim,
    element: shim,
    instanceOf: getShim,
    node: shim,
    objectOf: getShim,
    oneOf: getShim,
    oneOfType: getShim,
    shape: getShim
  };

  ReactPropTypes.checkPropTypes = emptyFunction_1$4;
  ReactPropTypes.PropTypes = ReactPropTypes;

  return ReactPropTypes;
};

var propTypes$3 = createCommonjsModule(function (module) {
/**
 * Copyright 2013-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 */

if (process.env.NODE_ENV !== 'production') {
  var REACT_ELEMENT_TYPE = (typeof Symbol === 'function' &&
    Symbol.for &&
    Symbol.for('react.element')) ||
    0xeac7;

  var isValidElement$$1 = function(object) {
    return typeof object === 'object' &&
      object !== null &&
      object.$$typeof === REACT_ELEMENT_TYPE;
  };

  // By explicitly using `prop-types` you are opting into new development behavior.
  // http://fb.me/prop-types-in-prod
  var throwOnDirectAccess = true;
  module.exports = factoryWithTypeCheckers$4(isValidElement$$1, throwOnDirectAccess);
} else {
  // By explicitly using `prop-types` you are opting into new production behavior.
  // http://fb.me/prop-types-in-prod
  module.exports = factoryWithThrowingShims$4();
}
});

var Motion_1 = createCommonjsModule(function (module, exports) {
'use strict';

exports.__esModule = true;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }



var _mapToZero2 = _interopRequireDefault(mapToZero_1);



var _stripStyle2 = _interopRequireDefault(stripStyle_1);



var _stepper4 = _interopRequireDefault(stepper_1);



var _performanceNow2 = _interopRequireDefault(performanceNow);



var _raf2 = _interopRequireDefault(raf_1);



var _shouldStopAnimation2 = _interopRequireDefault(shouldStopAnimation_1);



var _react2 = _interopRequireDefault(React);



var _propTypes2 = _interopRequireDefault(propTypes$3);

var msPerFrame = 1000 / 60;

var Motion = (function (_React$Component) {
  _inherits(Motion, _React$Component);

  _createClass(Motion, null, [{
    key: 'propTypes',
    value: {
      // TOOD: warn against putting a config in here
      defaultStyle: _propTypes2['default'].objectOf(_propTypes2['default'].number),
      style: _propTypes2['default'].objectOf(_propTypes2['default'].oneOfType([_propTypes2['default'].number, _propTypes2['default'].object])).isRequired,
      children: _propTypes2['default'].func.isRequired,
      onRest: _propTypes2['default'].func
    },
    enumerable: true
  }]);

  function Motion(props) {
    var _this = this;

    _classCallCheck(this, Motion);

    _React$Component.call(this, props);
    this.wasAnimating = false;
    this.animationID = null;
    this.prevTime = 0;
    this.accumulatedTime = 0;
    this.unreadPropStyle = null;

    this.clearUnreadPropStyle = function (destStyle) {
      var dirty = false;
      var _state = _this.state;
      var currentStyle = _state.currentStyle;
      var currentVelocity = _state.currentVelocity;
      var lastIdealStyle = _state.lastIdealStyle;
      var lastIdealVelocity = _state.lastIdealVelocity;

      for (var key in destStyle) {
        if (!Object.prototype.hasOwnProperty.call(destStyle, key)) {
          continue;
        }

        var styleValue = destStyle[key];
        if (typeof styleValue === 'number') {
          if (!dirty) {
            dirty = true;
            currentStyle = _extends({}, currentStyle);
            currentVelocity = _extends({}, currentVelocity);
            lastIdealStyle = _extends({}, lastIdealStyle);
            lastIdealVelocity = _extends({}, lastIdealVelocity);
          }

          currentStyle[key] = styleValue;
          currentVelocity[key] = 0;
          lastIdealStyle[key] = styleValue;
          lastIdealVelocity[key] = 0;
        }
      }

      if (dirty) {
        _this.setState({ currentStyle: currentStyle, currentVelocity: currentVelocity, lastIdealStyle: lastIdealStyle, lastIdealVelocity: lastIdealVelocity });
      }
    };

    this.startAnimationIfNecessary = function () {
      // TODO: when config is {a: 10} and dest is {a: 10} do we raf once and
      // call cb? No, otherwise accidental parent rerender causes cb trigger
      _this.animationID = _raf2['default'](function (timestamp) {
        // check if we need to animate in the first place
        var propsStyle = _this.props.style;
        if (_shouldStopAnimation2['default'](_this.state.currentStyle, propsStyle, _this.state.currentVelocity)) {
          if (_this.wasAnimating && _this.props.onRest) {
            _this.props.onRest();
          }

          // no need to cancel animationID here; shouldn't have any in flight
          _this.animationID = null;
          _this.wasAnimating = false;
          _this.accumulatedTime = 0;
          return;
        }

        _this.wasAnimating = true;

        var currentTime = timestamp || _performanceNow2['default']();
        var timeDelta = currentTime - _this.prevTime;
        _this.prevTime = currentTime;
        _this.accumulatedTime = _this.accumulatedTime + timeDelta;
        // more than 10 frames? prolly switched browser tab. Restart
        if (_this.accumulatedTime > msPerFrame * 10) {
          _this.accumulatedTime = 0;
        }

        if (_this.accumulatedTime === 0) {
          // no need to cancel animationID here; shouldn't have any in flight
          _this.animationID = null;
          _this.startAnimationIfNecessary();
          return;
        }

        var currentFrameCompletion = (_this.accumulatedTime - Math.floor(_this.accumulatedTime / msPerFrame) * msPerFrame) / msPerFrame;
        var framesToCatchUp = Math.floor(_this.accumulatedTime / msPerFrame);

        var newLastIdealStyle = {};
        var newLastIdealVelocity = {};
        var newCurrentStyle = {};
        var newCurrentVelocity = {};

        for (var key in propsStyle) {
          if (!Object.prototype.hasOwnProperty.call(propsStyle, key)) {
            continue;
          }

          var styleValue = propsStyle[key];
          if (typeof styleValue === 'number') {
            newCurrentStyle[key] = styleValue;
            newCurrentVelocity[key] = 0;
            newLastIdealStyle[key] = styleValue;
            newLastIdealVelocity[key] = 0;
          } else {
            var newLastIdealStyleValue = _this.state.lastIdealStyle[key];
            var newLastIdealVelocityValue = _this.state.lastIdealVelocity[key];
            for (var i = 0; i < framesToCatchUp; i++) {
              var _stepper = _stepper4['default'](msPerFrame / 1000, newLastIdealStyleValue, newLastIdealVelocityValue, styleValue.val, styleValue.stiffness, styleValue.damping, styleValue.precision);

              newLastIdealStyleValue = _stepper[0];
              newLastIdealVelocityValue = _stepper[1];
            }

            var _stepper2 = _stepper4['default'](msPerFrame / 1000, newLastIdealStyleValue, newLastIdealVelocityValue, styleValue.val, styleValue.stiffness, styleValue.damping, styleValue.precision);

            var nextIdealX = _stepper2[0];
            var nextIdealV = _stepper2[1];

            newCurrentStyle[key] = newLastIdealStyleValue + (nextIdealX - newLastIdealStyleValue) * currentFrameCompletion;
            newCurrentVelocity[key] = newLastIdealVelocityValue + (nextIdealV - newLastIdealVelocityValue) * currentFrameCompletion;
            newLastIdealStyle[key] = newLastIdealStyleValue;
            newLastIdealVelocity[key] = newLastIdealVelocityValue;
          }
        }

        _this.animationID = null;
        // the amount we're looped over above
        _this.accumulatedTime -= framesToCatchUp * msPerFrame;

        _this.setState({
          currentStyle: newCurrentStyle,
          currentVelocity: newCurrentVelocity,
          lastIdealStyle: newLastIdealStyle,
          lastIdealVelocity: newLastIdealVelocity
        });

        _this.unreadPropStyle = null;

        _this.startAnimationIfNecessary();
      });
    };

    this.state = this.defaultState();
  }

  Motion.prototype.defaultState = function defaultState() {
    var _props = this.props;
    var defaultStyle = _props.defaultStyle;
    var style = _props.style;

    var currentStyle = defaultStyle || _stripStyle2['default'](style);
    var currentVelocity = _mapToZero2['default'](currentStyle);
    return {
      currentStyle: currentStyle,
      currentVelocity: currentVelocity,
      lastIdealStyle: currentStyle,
      lastIdealVelocity: currentVelocity
    };
  };

  // it's possible that currentStyle's value is stale: if props is immediately
  // changed from 0 to 400 to spring(0) again, the async currentStyle is still
  // at 0 (didn't have time to tick and interpolate even once). If we naively
  // compare currentStyle with destVal it'll be 0 === 0 (no animation, stop).
  // In reality currentStyle should be 400

  Motion.prototype.componentDidMount = function componentDidMount() {
    this.prevTime = _performanceNow2['default']();
    this.startAnimationIfNecessary();
  };

  Motion.prototype.componentWillReceiveProps = function componentWillReceiveProps(props) {
    if (this.unreadPropStyle != null) {
      // previous props haven't had the chance to be set yet; set them here
      this.clearUnreadPropStyle(this.unreadPropStyle);
    }

    this.unreadPropStyle = props.style;
    if (this.animationID == null) {
      this.prevTime = _performanceNow2['default']();
      this.startAnimationIfNecessary();
    }
  };

  Motion.prototype.componentWillUnmount = function componentWillUnmount() {
    if (this.animationID != null) {
      _raf2['default'].cancel(this.animationID);
      this.animationID = null;
    }
  };

  Motion.prototype.render = function render() {
    var renderedChildren = this.props.children(this.state.currentStyle);
    return renderedChildren && _react2['default'].Children.only(renderedChildren);
  };

  return Motion;
})(_react2['default'].Component);

exports['default'] = Motion;
module.exports = exports['default'];

// after checking for unreadPropStyle != null, we manually go set the
// non-interpolating values (those that are a number, without a spring
// config)
});

unwrapExports(Motion_1);

var StaggeredMotion_1 = createCommonjsModule(function (module, exports) {
'use strict';

exports.__esModule = true;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }



var _mapToZero2 = _interopRequireDefault(mapToZero_1);



var _stripStyle2 = _interopRequireDefault(stripStyle_1);



var _stepper4 = _interopRequireDefault(stepper_1);



var _performanceNow2 = _interopRequireDefault(performanceNow);



var _raf2 = _interopRequireDefault(raf_1);



var _shouldStopAnimation2 = _interopRequireDefault(shouldStopAnimation_1);



var _react2 = _interopRequireDefault(React);



var _propTypes2 = _interopRequireDefault(propTypes$3);

var msPerFrame = 1000 / 60;

function shouldStopAnimationAll(currentStyles, styles, currentVelocities) {
  for (var i = 0; i < currentStyles.length; i++) {
    if (!_shouldStopAnimation2['default'](currentStyles[i], styles[i], currentVelocities[i])) {
      return false;
    }
  }
  return true;
}

var StaggeredMotion = (function (_React$Component) {
  _inherits(StaggeredMotion, _React$Component);

  _createClass(StaggeredMotion, null, [{
    key: 'propTypes',
    value: {
      // TOOD: warn against putting a config in here
      defaultStyles: _propTypes2['default'].arrayOf(_propTypes2['default'].objectOf(_propTypes2['default'].number)),
      styles: _propTypes2['default'].func.isRequired,
      children: _propTypes2['default'].func.isRequired
    },
    enumerable: true
  }]);

  function StaggeredMotion(props) {
    var _this = this;

    _classCallCheck(this, StaggeredMotion);

    _React$Component.call(this, props);
    this.animationID = null;
    this.prevTime = 0;
    this.accumulatedTime = 0;
    this.unreadPropStyles = null;

    this.clearUnreadPropStyle = function (unreadPropStyles) {
      var _state = _this.state;
      var currentStyles = _state.currentStyles;
      var currentVelocities = _state.currentVelocities;
      var lastIdealStyles = _state.lastIdealStyles;
      var lastIdealVelocities = _state.lastIdealVelocities;

      var someDirty = false;
      for (var i = 0; i < unreadPropStyles.length; i++) {
        var unreadPropStyle = unreadPropStyles[i];
        var dirty = false;

        for (var key in unreadPropStyle) {
          if (!Object.prototype.hasOwnProperty.call(unreadPropStyle, key)) {
            continue;
          }

          var styleValue = unreadPropStyle[key];
          if (typeof styleValue === 'number') {
            if (!dirty) {
              dirty = true;
              someDirty = true;
              currentStyles[i] = _extends({}, currentStyles[i]);
              currentVelocities[i] = _extends({}, currentVelocities[i]);
              lastIdealStyles[i] = _extends({}, lastIdealStyles[i]);
              lastIdealVelocities[i] = _extends({}, lastIdealVelocities[i]);
            }
            currentStyles[i][key] = styleValue;
            currentVelocities[i][key] = 0;
            lastIdealStyles[i][key] = styleValue;
            lastIdealVelocities[i][key] = 0;
          }
        }
      }

      if (someDirty) {
        _this.setState({ currentStyles: currentStyles, currentVelocities: currentVelocities, lastIdealStyles: lastIdealStyles, lastIdealVelocities: lastIdealVelocities });
      }
    };

    this.startAnimationIfNecessary = function () {
      // TODO: when config is {a: 10} and dest is {a: 10} do we raf once and
      // call cb? No, otherwise accidental parent rerender causes cb trigger
      _this.animationID = _raf2['default'](function (timestamp) {
        var destStyles = _this.props.styles(_this.state.lastIdealStyles);

        // check if we need to animate in the first place
        if (shouldStopAnimationAll(_this.state.currentStyles, destStyles, _this.state.currentVelocities)) {
          // no need to cancel animationID here; shouldn't have any in flight
          _this.animationID = null;
          _this.accumulatedTime = 0;
          return;
        }

        var currentTime = timestamp || _performanceNow2['default']();
        var timeDelta = currentTime - _this.prevTime;
        _this.prevTime = currentTime;
        _this.accumulatedTime = _this.accumulatedTime + timeDelta;
        // more than 10 frames? prolly switched browser tab. Restart
        if (_this.accumulatedTime > msPerFrame * 10) {
          _this.accumulatedTime = 0;
        }

        if (_this.accumulatedTime === 0) {
          // no need to cancel animationID here; shouldn't have any in flight
          _this.animationID = null;
          _this.startAnimationIfNecessary();
          return;
        }

        var currentFrameCompletion = (_this.accumulatedTime - Math.floor(_this.accumulatedTime / msPerFrame) * msPerFrame) / msPerFrame;
        var framesToCatchUp = Math.floor(_this.accumulatedTime / msPerFrame);

        var newLastIdealStyles = [];
        var newLastIdealVelocities = [];
        var newCurrentStyles = [];
        var newCurrentVelocities = [];

        for (var i = 0; i < destStyles.length; i++) {
          var destStyle = destStyles[i];
          var newCurrentStyle = {};
          var newCurrentVelocity = {};
          var newLastIdealStyle = {};
          var newLastIdealVelocity = {};

          for (var key in destStyle) {
            if (!Object.prototype.hasOwnProperty.call(destStyle, key)) {
              continue;
            }

            var styleValue = destStyle[key];
            if (typeof styleValue === 'number') {
              newCurrentStyle[key] = styleValue;
              newCurrentVelocity[key] = 0;
              newLastIdealStyle[key] = styleValue;
              newLastIdealVelocity[key] = 0;
            } else {
              var newLastIdealStyleValue = _this.state.lastIdealStyles[i][key];
              var newLastIdealVelocityValue = _this.state.lastIdealVelocities[i][key];
              for (var j = 0; j < framesToCatchUp; j++) {
                var _stepper = _stepper4['default'](msPerFrame / 1000, newLastIdealStyleValue, newLastIdealVelocityValue, styleValue.val, styleValue.stiffness, styleValue.damping, styleValue.precision);

                newLastIdealStyleValue = _stepper[0];
                newLastIdealVelocityValue = _stepper[1];
              }

              var _stepper2 = _stepper4['default'](msPerFrame / 1000, newLastIdealStyleValue, newLastIdealVelocityValue, styleValue.val, styleValue.stiffness, styleValue.damping, styleValue.precision);

              var nextIdealX = _stepper2[0];
              var nextIdealV = _stepper2[1];

              newCurrentStyle[key] = newLastIdealStyleValue + (nextIdealX - newLastIdealStyleValue) * currentFrameCompletion;
              newCurrentVelocity[key] = newLastIdealVelocityValue + (nextIdealV - newLastIdealVelocityValue) * currentFrameCompletion;
              newLastIdealStyle[key] = newLastIdealStyleValue;
              newLastIdealVelocity[key] = newLastIdealVelocityValue;
            }
          }

          newCurrentStyles[i] = newCurrentStyle;
          newCurrentVelocities[i] = newCurrentVelocity;
          newLastIdealStyles[i] = newLastIdealStyle;
          newLastIdealVelocities[i] = newLastIdealVelocity;
        }

        _this.animationID = null;
        // the amount we're looped over above
        _this.accumulatedTime -= framesToCatchUp * msPerFrame;

        _this.setState({
          currentStyles: newCurrentStyles,
          currentVelocities: newCurrentVelocities,
          lastIdealStyles: newLastIdealStyles,
          lastIdealVelocities: newLastIdealVelocities
        });

        _this.unreadPropStyles = null;

        _this.startAnimationIfNecessary();
      });
    };

    this.state = this.defaultState();
  }

  StaggeredMotion.prototype.defaultState = function defaultState() {
    var _props = this.props;
    var defaultStyles = _props.defaultStyles;
    var styles = _props.styles;

    var currentStyles = defaultStyles || styles().map(_stripStyle2['default']);
    var currentVelocities = currentStyles.map(function (currentStyle) {
      return _mapToZero2['default'](currentStyle);
    });
    return {
      currentStyles: currentStyles,
      currentVelocities: currentVelocities,
      lastIdealStyles: currentStyles,
      lastIdealVelocities: currentVelocities
    };
  };

  StaggeredMotion.prototype.componentDidMount = function componentDidMount() {
    this.prevTime = _performanceNow2['default']();
    this.startAnimationIfNecessary();
  };

  StaggeredMotion.prototype.componentWillReceiveProps = function componentWillReceiveProps(props) {
    if (this.unreadPropStyles != null) {
      // previous props haven't had the chance to be set yet; set them here
      this.clearUnreadPropStyle(this.unreadPropStyles);
    }

    this.unreadPropStyles = props.styles(this.state.lastIdealStyles);
    if (this.animationID == null) {
      this.prevTime = _performanceNow2['default']();
      this.startAnimationIfNecessary();
    }
  };

  StaggeredMotion.prototype.componentWillUnmount = function componentWillUnmount() {
    if (this.animationID != null) {
      _raf2['default'].cancel(this.animationID);
      this.animationID = null;
    }
  };

  StaggeredMotion.prototype.render = function render() {
    var renderedChildren = this.props.children(this.state.currentStyles);
    return renderedChildren && _react2['default'].Children.only(renderedChildren);
  };

  return StaggeredMotion;
})(_react2['default'].Component);

exports['default'] = StaggeredMotion;
module.exports = exports['default'];

// it's possible that currentStyle's value is stale: if props is immediately
// changed from 0 to 400 to spring(0) again, the async currentStyle is still
// at 0 (didn't have time to tick and interpolate even once). If we naively
// compare currentStyle with destVal it'll be 0 === 0 (no animation, stop).
// In reality currentStyle should be 400

// after checking for unreadPropStyles != null, we manually go set the
// non-interpolating values (those that are a number, without a spring
// config)
});

unwrapExports(StaggeredMotion_1);

var mergeDiff_1 = createCommonjsModule(function (module, exports) {
// core keys merging algorithm. If previous render's keys are [a, b], and the
// next render's [c, b, d], what's the final merged keys and ordering?

// - c and a must both be before b
// - b before d
// - ordering between a and c ambiguous

// this reduces to merging two partially ordered lists (e.g. lists where not
// every item has a definite ordering, like comparing a and c above). For the
// ambiguous ordering we deterministically choose to place the next render's
// item after the previous'; so c after a

// this is called a topological sorting. Except the existing algorithms don't
// work well with js bc of the amount of allocation, and isn't optimized for our
// current use-case bc the runtime is linear in terms of edges (see wiki for
// meaning), which is huge when two lists have many common elements
'use strict';

exports.__esModule = true;
exports['default'] = mergeDiff;

function mergeDiff(prev, next, onRemove) {
  // bookkeeping for easier access of a key's index below. This is 2 allocations +
  // potentially triggering chrome hash map mode for objs (so it might be faster

  var prevKeyIndex = {};
  for (var i = 0; i < prev.length; i++) {
    prevKeyIndex[prev[i].key] = i;
  }
  var nextKeyIndex = {};
  for (var i = 0; i < next.length; i++) {
    nextKeyIndex[next[i].key] = i;
  }

  // first, an overly elaborate way of merging prev and next, eliminating
  // duplicates (in terms of keys). If there's dupe, keep the item in next).
  // This way of writing it saves allocations
  var ret = [];
  for (var i = 0; i < next.length; i++) {
    ret[i] = next[i];
  }
  for (var i = 0; i < prev.length; i++) {
    if (!Object.prototype.hasOwnProperty.call(nextKeyIndex, prev[i].key)) {
      // this is called my TM's `mergeAndSync`, which calls willLeave. We don't
      // merge in keys that the user desires to kill
      var fill = onRemove(i, prev[i]);
      if (fill != null) {
        ret.push(fill);
      }
    }
  }

  // now all the items all present. Core sorting logic to have the right order
  return ret.sort(function (a, b) {
    var nextOrderA = nextKeyIndex[a.key];
    var nextOrderB = nextKeyIndex[b.key];
    var prevOrderA = prevKeyIndex[a.key];
    var prevOrderB = prevKeyIndex[b.key];

    if (nextOrderA != null && nextOrderB != null) {
      // both keys in next
      return nextKeyIndex[a.key] - nextKeyIndex[b.key];
    } else if (prevOrderA != null && prevOrderB != null) {
      // both keys in prev
      return prevKeyIndex[a.key] - prevKeyIndex[b.key];
    } else if (nextOrderA != null) {
      // key a in next, key b in prev

      // how to determine the order between a and b? We find a "pivot" (term
      // abuse), a key present in both prev and next, that is sandwiched between
      // a and b. In the context of our above example, if we're comparing a and
      // d, b's (the only) pivot
      for (var i = 0; i < next.length; i++) {
        var pivot = next[i].key;
        if (!Object.prototype.hasOwnProperty.call(prevKeyIndex, pivot)) {
          continue;
        }

        if (nextOrderA < nextKeyIndex[pivot] && prevOrderB > prevKeyIndex[pivot]) {
          return -1;
        } else if (nextOrderA > nextKeyIndex[pivot] && prevOrderB < prevKeyIndex[pivot]) {
          return 1;
        }
      }
      // pluggable. default to: next bigger than prev
      return 1;
    }
    // prevOrderA, nextOrderB
    for (var i = 0; i < next.length; i++) {
      var pivot = next[i].key;
      if (!Object.prototype.hasOwnProperty.call(prevKeyIndex, pivot)) {
        continue;
      }
      if (nextOrderB < nextKeyIndex[pivot] && prevOrderA > prevKeyIndex[pivot]) {
        return 1;
      } else if (nextOrderB > nextKeyIndex[pivot] && prevOrderA < prevKeyIndex[pivot]) {
        return -1;
      }
    }
    // pluggable. default to: next bigger than prev
    return -1;
  });
}

module.exports = exports['default'];
// to loop through and find a key's index each time), but I no longer care
});

unwrapExports(mergeDiff_1);

var TransitionMotion_1 = createCommonjsModule(function (module, exports) {
'use strict';

exports.__esModule = true;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }



var _mapToZero2 = _interopRequireDefault(mapToZero_1);



var _stripStyle2 = _interopRequireDefault(stripStyle_1);



var _stepper4 = _interopRequireDefault(stepper_1);



var _mergeDiff2 = _interopRequireDefault(mergeDiff_1);



var _performanceNow2 = _interopRequireDefault(performanceNow);



var _raf2 = _interopRequireDefault(raf_1);



var _shouldStopAnimation2 = _interopRequireDefault(shouldStopAnimation_1);



var _react2 = _interopRequireDefault(React);



var _propTypes2 = _interopRequireDefault(propTypes$3);

var msPerFrame = 1000 / 60;

// the children function & (potential) styles function asks as param an
// Array<TransitionPlainStyle>, where each TransitionPlainStyle is of the format
// {key: string, data?: any, style: PlainStyle}. However, the way we keep
// internal states doesn't contain such a data structure (check the state and
// TransitionMotionState). So when children function and others ask for such
// data we need to generate them on the fly by combining mergedPropsStyles and
// currentStyles/lastIdealStyles
function rehydrateStyles(mergedPropsStyles, unreadPropStyles, plainStyles) {
  // Copy the value to a `const` so that Flow understands that the const won't
  // change and will be non-nullable in the callback below.
  var cUnreadPropStyles = unreadPropStyles;
  if (cUnreadPropStyles == null) {
    return mergedPropsStyles.map(function (mergedPropsStyle, i) {
      return {
        key: mergedPropsStyle.key,
        data: mergedPropsStyle.data,
        style: plainStyles[i]
      };
    });
  }
  return mergedPropsStyles.map(function (mergedPropsStyle, i) {
    for (var j = 0; j < cUnreadPropStyles.length; j++) {
      if (cUnreadPropStyles[j].key === mergedPropsStyle.key) {
        return {
          key: cUnreadPropStyles[j].key,
          data: cUnreadPropStyles[j].data,
          style: plainStyles[i]
        };
      }
    }
    return { key: mergedPropsStyle.key, data: mergedPropsStyle.data, style: plainStyles[i] };
  });
}

function shouldStopAnimationAll(currentStyles, destStyles, currentVelocities, mergedPropsStyles) {
  if (mergedPropsStyles.length !== destStyles.length) {
    return false;
  }

  for (var i = 0; i < mergedPropsStyles.length; i++) {
    if (mergedPropsStyles[i].key !== destStyles[i].key) {
      return false;
    }
  }

  // we have the invariant that mergedPropsStyles and
  // currentStyles/currentVelocities/last* are synced in terms of cells, see
  // mergeAndSync comment for more info
  for (var i = 0; i < mergedPropsStyles.length; i++) {
    if (!_shouldStopAnimation2['default'](currentStyles[i], destStyles[i].style, currentVelocities[i])) {
      return false;
    }
  }

  return true;
}

// core key merging logic

// things to do: say previously merged style is {a, b}, dest style (prop) is {b,
// c}, previous current (interpolating) style is {a, b}
// **invariant**: current[i] corresponds to merged[i] in terms of key

// steps:
// turn merged style into {a?, b, c}
//    add c, value of c is destStyles.c
//    maybe remove a, aka call willLeave(a), then merged is either {b, c} or {a, b, c}
// turn current (interpolating) style from {a, b} into {a?, b, c}
//    maybe remove a
//    certainly add c, value of c is willEnter(c)
// loop over merged and construct new current
// dest doesn't change, that's owner's
function mergeAndSync(willEnter, willLeave, didLeave, oldMergedPropsStyles, destStyles, oldCurrentStyles, oldCurrentVelocities, oldLastIdealStyles, oldLastIdealVelocities) {
  var newMergedPropsStyles = _mergeDiff2['default'](oldMergedPropsStyles, destStyles, function (oldIndex, oldMergedPropsStyle) {
    var leavingStyle = willLeave(oldMergedPropsStyle);
    if (leavingStyle == null) {
      didLeave({ key: oldMergedPropsStyle.key, data: oldMergedPropsStyle.data });
      return null;
    }
    if (_shouldStopAnimation2['default'](oldCurrentStyles[oldIndex], leavingStyle, oldCurrentVelocities[oldIndex])) {
      didLeave({ key: oldMergedPropsStyle.key, data: oldMergedPropsStyle.data });
      return null;
    }
    return { key: oldMergedPropsStyle.key, data: oldMergedPropsStyle.data, style: leavingStyle };
  });

  var newCurrentStyles = [];
  var newCurrentVelocities = [];
  var newLastIdealStyles = [];
  var newLastIdealVelocities = [];
  for (var i = 0; i < newMergedPropsStyles.length; i++) {
    var newMergedPropsStyleCell = newMergedPropsStyles[i];
    var foundOldIndex = null;
    for (var j = 0; j < oldMergedPropsStyles.length; j++) {
      if (oldMergedPropsStyles[j].key === newMergedPropsStyleCell.key) {
        foundOldIndex = j;
        break;
      }
    }
    // TODO: key search code
    if (foundOldIndex == null) {
      var plainStyle = willEnter(newMergedPropsStyleCell);
      newCurrentStyles[i] = plainStyle;
      newLastIdealStyles[i] = plainStyle;

      var velocity = _mapToZero2['default'](newMergedPropsStyleCell.style);
      newCurrentVelocities[i] = velocity;
      newLastIdealVelocities[i] = velocity;
    } else {
      newCurrentStyles[i] = oldCurrentStyles[foundOldIndex];
      newLastIdealStyles[i] = oldLastIdealStyles[foundOldIndex];
      newCurrentVelocities[i] = oldCurrentVelocities[foundOldIndex];
      newLastIdealVelocities[i] = oldLastIdealVelocities[foundOldIndex];
    }
  }

  return [newMergedPropsStyles, newCurrentStyles, newCurrentVelocities, newLastIdealStyles, newLastIdealVelocities];
}

var TransitionMotion = (function (_React$Component) {
  _inherits(TransitionMotion, _React$Component);

  _createClass(TransitionMotion, null, [{
    key: 'propTypes',
    value: {
      defaultStyles: _propTypes2['default'].arrayOf(_propTypes2['default'].shape({
        key: _propTypes2['default'].string.isRequired,
        data: _propTypes2['default'].any,
        style: _propTypes2['default'].objectOf(_propTypes2['default'].number).isRequired
      })),
      styles: _propTypes2['default'].oneOfType([_propTypes2['default'].func, _propTypes2['default'].arrayOf(_propTypes2['default'].shape({
        key: _propTypes2['default'].string.isRequired,
        data: _propTypes2['default'].any,
        style: _propTypes2['default'].objectOf(_propTypes2['default'].oneOfType([_propTypes2['default'].number, _propTypes2['default'].object])).isRequired
      }))]).isRequired,
      children: _propTypes2['default'].func.isRequired,
      willEnter: _propTypes2['default'].func,
      willLeave: _propTypes2['default'].func,
      didLeave: _propTypes2['default'].func
    },
    enumerable: true
  }, {
    key: 'defaultProps',
    value: {
      willEnter: function willEnter(styleThatEntered) {
        return _stripStyle2['default'](styleThatEntered.style);
      },
      // recall: returning null makes the current unmounting TransitionStyle
      // disappear immediately
      willLeave: function willLeave() {
        return null;
      },
      didLeave: function didLeave() {}
    },
    enumerable: true
  }]);

  function TransitionMotion(props) {
    var _this = this;

    _classCallCheck(this, TransitionMotion);

    _React$Component.call(this, props);
    this.unmounting = false;
    this.animationID = null;
    this.prevTime = 0;
    this.accumulatedTime = 0;
    this.unreadPropStyles = null;

    this.clearUnreadPropStyle = function (unreadPropStyles) {
      var _mergeAndSync = mergeAndSync(_this.props.willEnter, _this.props.willLeave, _this.props.didLeave, _this.state.mergedPropsStyles, unreadPropStyles, _this.state.currentStyles, _this.state.currentVelocities, _this.state.lastIdealStyles, _this.state.lastIdealVelocities);

      var mergedPropsStyles = _mergeAndSync[0];
      var currentStyles = _mergeAndSync[1];
      var currentVelocities = _mergeAndSync[2];
      var lastIdealStyles = _mergeAndSync[3];
      var lastIdealVelocities = _mergeAndSync[4];

      for (var i = 0; i < unreadPropStyles.length; i++) {
        var unreadPropStyle = unreadPropStyles[i].style;
        var dirty = false;

        for (var key in unreadPropStyle) {
          if (!Object.prototype.hasOwnProperty.call(unreadPropStyle, key)) {
            continue;
          }

          var styleValue = unreadPropStyle[key];
          if (typeof styleValue === 'number') {
            if (!dirty) {
              dirty = true;
              currentStyles[i] = _extends({}, currentStyles[i]);
              currentVelocities[i] = _extends({}, currentVelocities[i]);
              lastIdealStyles[i] = _extends({}, lastIdealStyles[i]);
              lastIdealVelocities[i] = _extends({}, lastIdealVelocities[i]);
              mergedPropsStyles[i] = {
                key: mergedPropsStyles[i].key,
                data: mergedPropsStyles[i].data,
                style: _extends({}, mergedPropsStyles[i].style)
              };
            }
            currentStyles[i][key] = styleValue;
            currentVelocities[i][key] = 0;
            lastIdealStyles[i][key] = styleValue;
            lastIdealVelocities[i][key] = 0;
            mergedPropsStyles[i].style[key] = styleValue;
          }
        }
      }

      // unlike the other 2 components, we can't detect staleness and optionally
      // opt out of setState here. each style object's data might contain new
      // stuff we're not/cannot compare
      _this.setState({
        currentStyles: currentStyles,
        currentVelocities: currentVelocities,
        mergedPropsStyles: mergedPropsStyles,
        lastIdealStyles: lastIdealStyles,
        lastIdealVelocities: lastIdealVelocities
      });
    };

    this.startAnimationIfNecessary = function () {
      if (_this.unmounting) {
        return;
      }

      // TODO: when config is {a: 10} and dest is {a: 10} do we raf once and
      // call cb? No, otherwise accidental parent rerender causes cb trigger
      _this.animationID = _raf2['default'](function (timestamp) {
        // https://github.com/chenglou/react-motion/pull/420
        // > if execution passes the conditional if (this.unmounting), then
        // executes async defaultRaf and after that component unmounts and after
        // that the callback of defaultRaf is called, then setState will be called
        // on unmounted component.
        if (_this.unmounting) {
          return;
        }

        var propStyles = _this.props.styles;
        var destStyles = typeof propStyles === 'function' ? propStyles(rehydrateStyles(_this.state.mergedPropsStyles, _this.unreadPropStyles, _this.state.lastIdealStyles)) : propStyles;

        // check if we need to animate in the first place
        if (shouldStopAnimationAll(_this.state.currentStyles, destStyles, _this.state.currentVelocities, _this.state.mergedPropsStyles)) {
          // no need to cancel animationID here; shouldn't have any in flight
          _this.animationID = null;
          _this.accumulatedTime = 0;
          return;
        }

        var currentTime = timestamp || _performanceNow2['default']();
        var timeDelta = currentTime - _this.prevTime;
        _this.prevTime = currentTime;
        _this.accumulatedTime = _this.accumulatedTime + timeDelta;
        // more than 10 frames? prolly switched browser tab. Restart
        if (_this.accumulatedTime > msPerFrame * 10) {
          _this.accumulatedTime = 0;
        }

        if (_this.accumulatedTime === 0) {
          // no need to cancel animationID here; shouldn't have any in flight
          _this.animationID = null;
          _this.startAnimationIfNecessary();
          return;
        }

        var currentFrameCompletion = (_this.accumulatedTime - Math.floor(_this.accumulatedTime / msPerFrame) * msPerFrame) / msPerFrame;
        var framesToCatchUp = Math.floor(_this.accumulatedTime / msPerFrame);

        var _mergeAndSync2 = mergeAndSync(_this.props.willEnter, _this.props.willLeave, _this.props.didLeave, _this.state.mergedPropsStyles, destStyles, _this.state.currentStyles, _this.state.currentVelocities, _this.state.lastIdealStyles, _this.state.lastIdealVelocities);

        var newMergedPropsStyles = _mergeAndSync2[0];
        var newCurrentStyles = _mergeAndSync2[1];
        var newCurrentVelocities = _mergeAndSync2[2];
        var newLastIdealStyles = _mergeAndSync2[3];
        var newLastIdealVelocities = _mergeAndSync2[4];

        for (var i = 0; i < newMergedPropsStyles.length; i++) {
          var newMergedPropsStyle = newMergedPropsStyles[i].style;
          var newCurrentStyle = {};
          var newCurrentVelocity = {};
          var newLastIdealStyle = {};
          var newLastIdealVelocity = {};

          for (var key in newMergedPropsStyle) {
            if (!Object.prototype.hasOwnProperty.call(newMergedPropsStyle, key)) {
              continue;
            }

            var styleValue = newMergedPropsStyle[key];
            if (typeof styleValue === 'number') {
              newCurrentStyle[key] = styleValue;
              newCurrentVelocity[key] = 0;
              newLastIdealStyle[key] = styleValue;
              newLastIdealVelocity[key] = 0;
            } else {
              var newLastIdealStyleValue = newLastIdealStyles[i][key];
              var newLastIdealVelocityValue = newLastIdealVelocities[i][key];
              for (var j = 0; j < framesToCatchUp; j++) {
                var _stepper = _stepper4['default'](msPerFrame / 1000, newLastIdealStyleValue, newLastIdealVelocityValue, styleValue.val, styleValue.stiffness, styleValue.damping, styleValue.precision);

                newLastIdealStyleValue = _stepper[0];
                newLastIdealVelocityValue = _stepper[1];
              }

              var _stepper2 = _stepper4['default'](msPerFrame / 1000, newLastIdealStyleValue, newLastIdealVelocityValue, styleValue.val, styleValue.stiffness, styleValue.damping, styleValue.precision);

              var nextIdealX = _stepper2[0];
              var nextIdealV = _stepper2[1];

              newCurrentStyle[key] = newLastIdealStyleValue + (nextIdealX - newLastIdealStyleValue) * currentFrameCompletion;
              newCurrentVelocity[key] = newLastIdealVelocityValue + (nextIdealV - newLastIdealVelocityValue) * currentFrameCompletion;
              newLastIdealStyle[key] = newLastIdealStyleValue;
              newLastIdealVelocity[key] = newLastIdealVelocityValue;
            }
          }

          newLastIdealStyles[i] = newLastIdealStyle;
          newLastIdealVelocities[i] = newLastIdealVelocity;
          newCurrentStyles[i] = newCurrentStyle;
          newCurrentVelocities[i] = newCurrentVelocity;
        }

        _this.animationID = null;
        // the amount we're looped over above
        _this.accumulatedTime -= framesToCatchUp * msPerFrame;

        _this.setState({
          currentStyles: newCurrentStyles,
          currentVelocities: newCurrentVelocities,
          lastIdealStyles: newLastIdealStyles,
          lastIdealVelocities: newLastIdealVelocities,
          mergedPropsStyles: newMergedPropsStyles
        });

        _this.unreadPropStyles = null;

        _this.startAnimationIfNecessary();
      });
    };

    this.state = this.defaultState();
  }

  TransitionMotion.prototype.defaultState = function defaultState() {
    var _props = this.props;
    var defaultStyles = _props.defaultStyles;
    var styles = _props.styles;
    var willEnter = _props.willEnter;
    var willLeave = _props.willLeave;
    var didLeave = _props.didLeave;

    var destStyles = typeof styles === 'function' ? styles(defaultStyles) : styles;

    // this is special. for the first time around, we don't have a comparison
    // between last (no last) and current merged props. we'll compute last so:
    // say default is {a, b} and styles (dest style) is {b, c}, we'll
    // fabricate last as {a, b}
    var oldMergedPropsStyles = undefined;
    if (defaultStyles == null) {
      oldMergedPropsStyles = destStyles;
    } else {
      oldMergedPropsStyles = defaultStyles.map(function (defaultStyleCell) {
        // TODO: key search code
        for (var i = 0; i < destStyles.length; i++) {
          if (destStyles[i].key === defaultStyleCell.key) {
            return destStyles[i];
          }
        }
        return defaultStyleCell;
      });
    }
    var oldCurrentStyles = defaultStyles == null ? destStyles.map(function (s) {
      return _stripStyle2['default'](s.style);
    }) : defaultStyles.map(function (s) {
      return _stripStyle2['default'](s.style);
    });
    var oldCurrentVelocities = defaultStyles == null ? destStyles.map(function (s) {
      return _mapToZero2['default'](s.style);
    }) : defaultStyles.map(function (s) {
      return _mapToZero2['default'](s.style);
    });

    var _mergeAndSync3 = mergeAndSync(
    // Because this is an old-style createReactClass component, Flow doesn't
    // understand that the willEnter and willLeave props have default values
    // and will always be present.
    willEnter, willLeave, didLeave, oldMergedPropsStyles, destStyles, oldCurrentStyles, oldCurrentVelocities, oldCurrentStyles, // oldLastIdealStyles really
    oldCurrentVelocities);

    var mergedPropsStyles = _mergeAndSync3[0];
    var currentStyles = _mergeAndSync3[1];
    var currentVelocities = _mergeAndSync3[2];
    var lastIdealStyles = _mergeAndSync3[3];
    var lastIdealVelocities = _mergeAndSync3[4];
    // oldLastIdealVelocities really

    return {
      currentStyles: currentStyles,
      currentVelocities: currentVelocities,
      lastIdealStyles: lastIdealStyles,
      lastIdealVelocities: lastIdealVelocities,
      mergedPropsStyles: mergedPropsStyles
    };
  };

  // after checking for unreadPropStyles != null, we manually go set the
  // non-interpolating values (those that are a number, without a spring
  // config)

  TransitionMotion.prototype.componentDidMount = function componentDidMount() {
    this.prevTime = _performanceNow2['default']();
    this.startAnimationIfNecessary();
  };

  TransitionMotion.prototype.componentWillReceiveProps = function componentWillReceiveProps(props) {
    if (this.unreadPropStyles) {
      // previous props haven't had the chance to be set yet; set them here
      this.clearUnreadPropStyle(this.unreadPropStyles);
    }

    var styles = props.styles;
    if (typeof styles === 'function') {
      this.unreadPropStyles = styles(rehydrateStyles(this.state.mergedPropsStyles, this.unreadPropStyles, this.state.lastIdealStyles));
    } else {
      this.unreadPropStyles = styles;
    }

    if (this.animationID == null) {
      this.prevTime = _performanceNow2['default']();
      this.startAnimationIfNecessary();
    }
  };

  TransitionMotion.prototype.componentWillUnmount = function componentWillUnmount() {
    this.unmounting = true;
    if (this.animationID != null) {
      _raf2['default'].cancel(this.animationID);
      this.animationID = null;
    }
  };

  TransitionMotion.prototype.render = function render() {
    var hydratedStyles = rehydrateStyles(this.state.mergedPropsStyles, this.unreadPropStyles, this.state.currentStyles);
    var renderedChildren = this.props.children(hydratedStyles);
    return renderedChildren && _react2['default'].Children.only(renderedChildren);
  };

  return TransitionMotion;
})(_react2['default'].Component);

exports['default'] = TransitionMotion;
module.exports = exports['default'];

// list of styles, each containing interpolating values. Part of what's passed
// to children function. Notice that this is
// Array<ActualInterpolatingStyleObject>, without the wrapper that is {key: ...,
// data: ... style: ActualInterpolatingStyleObject}. Only mergedPropsStyles
// contains the key & data info (so that we only have a single source of truth
// for these, and to save space). Check the comment for `rehydrateStyles` to
// see how we regenerate the entirety of what's passed to children function

// the array that keeps track of currently rendered stuff! Including stuff
// that you've unmounted but that's still animating. This is where it lives

// it's possible that currentStyle's value is stale: if props is immediately
// changed from 0 to 400 to spring(0) again, the async currentStyle is still
// at 0 (didn't have time to tick and interpolate even once). If we naively
// compare currentStyle with destVal it'll be 0 === 0 (no animation, stop).
// In reality currentStyle should be 400
});

unwrapExports(TransitionMotion_1);

var presets = createCommonjsModule(function (module, exports) {
"use strict";

exports.__esModule = true;
exports["default"] = {
  noWobble: { stiffness: 170, damping: 26 }, // the default, if nothing provided
  gentle: { stiffness: 120, damping: 14 },
  wobbly: { stiffness: 180, damping: 12 },
  stiff: { stiffness: 210, damping: 20 }
};
module.exports = exports["default"];
});

unwrapExports(presets);

var spring_1 = createCommonjsModule(function (module, exports) {
'use strict';

exports.__esModule = true;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

exports['default'] = spring;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }



var _presets2 = _interopRequireDefault(presets);

var defaultConfig = _extends({}, _presets2['default'].noWobble, {
  precision: 0.01
});

function spring(val, config) {
  return _extends({}, defaultConfig, config, { val: val });
}

module.exports = exports['default'];
});

unwrapExports(spring_1);

var reorderKeys_1 = createCommonjsModule(function (module, exports) {
'use strict';

exports.__esModule = true;
exports['default'] = reorderKeys;

var hasWarned = false;

function reorderKeys() {
  if (process.env.NODE_ENV === 'development') {
    if (!hasWarned) {
      hasWarned = true;
      console.error('`reorderKeys` has been removed, since it is no longer needed for TransitionMotion\'s new styles array API.');
    }
  }
}

module.exports = exports['default'];
});

unwrapExports(reorderKeys_1);

var reactMotion = createCommonjsModule(function (module, exports) {
'use strict';

exports.__esModule = true;

function _interopRequire(obj) { return obj && obj.__esModule ? obj['default'] : obj; }



exports.Motion = _interopRequire(Motion_1);



exports.StaggeredMotion = _interopRequire(StaggeredMotion_1);



exports.TransitionMotion = _interopRequire(TransitionMotion_1);



exports.spring = _interopRequire(spring_1);



exports.presets = _interopRequire(presets);



exports.stripStyle = _interopRequire(stripStyle_1);

// deprecated, dummy warning function



exports.reorderKeys = _interopRequire(reorderKeys_1);
});

unwrapExports(reactMotion);
var reactMotion_1 = reactMotion.Motion;
var reactMotion_4 = reactMotion.spring;

/**
 * The `Collapse` component is used to animate a single child entering
 * or leaving. This uses the `react-motion` library to animate the height,
 * padding-top, and padding-bottom of an element when the `collapsed` prop
 * changes.
 */

var Collapse = function (_PureComponent) {
  inherits(Collapse, _PureComponent);

  function Collapse(props) {
    classCallCheck(this, Collapse);

    var _this = possibleConstructorReturn(this, (Collapse.__proto__ || Object.getPrototypeOf(Collapse)).call(this, props));

    _this._setHeight = function (child) {
      if (_this._child && typeof _this._child.ref === 'function') {
        _this._child.ref(child);
      }

      var height = 0;
      var paddingTop = 0;
      var paddingBottom = 0;
      if (child !== null) {
        var node = findDOMNode(child);
        var cs = window.getComputedStyle(node);
        height = node.offsetHeight;
        paddingTop = parseInt(cs.getPropertyValue('padding-top'), 10);
        paddingBottom = parseInt(cs.getPropertyValue('padding-bottom'), 10);
      }

      height = Math.max(_this.props.minHeight, height);

      _this.setState({ height: height, paddingTop: paddingTop, paddingBottom: paddingBottom });
    };

    if (!props.collapsed) {
      _this.state = { initialOpen: true };
    } else {
      _this.state = {
        height: props.minHeight,
        paddingTop: 0,
        paddingBottom: 0
      };
    }
    return _this;
  }

  createClass(Collapse, [{
    key: 'componentWillReceiveProps',
    value: function componentWillReceiveProps(nextProps) {
      if (this.state.initialOpen && nextProps.collapsed) {
        this.setState({ initialOpen: false });
      }
    }
  }, {
    key: '_spring',
    value: function _spring(collapsed, initialOpen, value, config) {
      var min = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : 0;

      var nextValue = !collapsed ? Math.max(min, value) : min;
      if (initialOpen && !collapsed) {
        return nextValue;
      }

      return reactMotion_4(nextValue, config);
    }
  }, {
    key: 'render',
    value: function render() {
      var _this2 = this;

      var _state = this.state,
          height = _state.height,
          paddingTop = _state.paddingTop,
          paddingBottom = _state.paddingBottom,
          initialOpen = _state.initialOpen;
      var _props = this.props,
          children = _props.children,
          collapsed = _props.collapsed,
          defaultStyle = _props.defaultStyle,
          motionStyle = _props.style,
          springConfig = _props.springConfig,
          animate = _props.animate,
          minHeight = _props.minHeight;


      if (!animate) {
        return collapsed ? null : children;
      }

      return React.createElement(
        reactMotion_1,
        {
          style: _extends({}, motionStyle, {
            height: this._spring(collapsed, initialOpen, height, springConfig, minHeight),
            paddingTop: this._spring(collapsed, initialOpen, paddingTop, springConfig),
            paddingBottom: this._spring(collapsed, initialOpen, paddingBottom, springConfig)
          }),
          defaultStyle: _extends({}, defaultStyle, {
            height: height,
            paddingTop: paddingTop,
            paddingBottom: paddingBottom
          })
        },
        function (style) {
          if (collapsed && !style.height) {
            return null;
          }

          var child = Children.only(children);
          _this2._child = child;
          var nextStyle = child.props.style;
          if (collapsed && (!minHeight || style.height !== minHeight) || style.height !== height) {
            nextStyle = _extends({}, child.props.style, style, {
              overflow: 'hidden'
            });
          }
          return cloneElement(child, {
            ref: !collapsed ? _this2._setHeight : null,
            style: nextStyle
          });
        }
      );
    }
  }]);
  return Collapse;
}(PureComponent);

Collapse.propTypes = {
  /**
   * An optional style to merge with the `Motion` style.
   */
  style: propTypes.object,

  /**
   * An optional default style to merge with the `Motion` default style.
   */
  defaultStyle: propTypes.object,

  /**
   * Boolean if the children are currently collapsed.
   */
  collapsed: propTypes.bool.isRequired,

  /**
   * A single child to collapse or expand.
   */
  children: propTypes.element.isRequired,

  /**
   * The spring config to use for the animation.
   */
  springConfig: propTypes.object.isRequired,

  /**
   * Boolean if the single child entering or leaving should be animated.
   */
  animate: propTypes.bool,

  /**
   * The min height to apply for the collapse div.
   */
  minHeight: propTypes.number.isRequired
};
Collapse.defaultProps = {
  animate: true,
  springConfig: {
    precision: 0.5
  },
  minHeight: 0
};

var ICON_SIZE = 24;

/**
 * The \`FontIcon\` component is used for rendering a font-icon library's
 * icon. The default is to use the `material-icons` library, but others
 * can be used as well.
 *
 * If you are using another font-icon library that does not always create
 * icons with a perfect 1:1 scale (such as font-awesome), it is recommended
 * to update the `.md-icon` styles to set the width and height to `$md-font-icon-size`.
 * However, this will prevent different sided icons.
 *
 * ```scss
 * .md-icon.fa {
 *   height: $md-font-icon-size;
 *   width: $md-font-icon-size;
 * }
 * ```
 */

var FontIcon = function (_PureComponent) {
  inherits(FontIcon, _PureComponent);

  function FontIcon(props) {
    classCallCheck(this, FontIcon);

    var _this = possibleConstructorReturn(this, (FontIcon.__proto__ || Object.getPrototypeOf(FontIcon)).call(this));

    _initialiseProps$2.call(_this);

    _this.state = { styles: _this._mergeStyles(props) };
    return _this;
  }

  createClass(FontIcon, [{
    key: 'componentWillReceiveProps',
    value: function componentWillReceiveProps(nextProps) {
      var _props = this.props,
          style = _props.style,
          forceSize = _props.forceSize,
          forceFontSize = _props.forceFontSize;

      if (style !== nextProps.style || forceSize !== nextProps.forceSize || forceFontSize !== nextProps.forceFontSize) {
        this.setState({ styles: this._mergeStyles(nextProps) });
      }
    }
  }, {
    key: 'render',
    value: function render() {
      var styles = this.state.styles;
      var _props2 = this.props,
          iconClassName = _props2.iconClassName,
          className = _props2.className,
          children = _props2.children,
          disabled = _props2.disabled,
          primary = _props2.primary,
          secondary = _props2.secondary,
          error = _props2.error,
          inherit = _props2.inherit,
          style = _props2.style,
          forceSize = _props2.forceSize,
          forceFontSize = _props2.forceFontSize,
          props = objectWithoutProperties(_props2, ['iconClassName', 'className', 'children', 'disabled', 'primary', 'secondary', 'error', 'inherit', 'style', 'forceSize', 'forceFontSize']);


      var classes = classnames('md-icon', iconClassName, themeColors({
        disabled: disabled,
        error: error,
        inherit: inherit,
        primary: primary,
        secondary: secondary
      }), className);

      return React.createElement(
        'i',
        _extends({}, props, { style: styles, className: classes }),
        children
      );
    }
  }]);
  return FontIcon;
}(PureComponent);

FontIcon.propTypes = {
  /**
   * An optional style to apply.
   */
  style: propTypes.object,

  /**
   * An optional className to apply to the `FontIcon`.
   */
  className: propTypes.string,

  /**
   * The icon font library className to use to display the icon.
   */
  iconClassName: propTypes.string.isRequired,

  /**
   * Boolean if the primary theme color should be applied.
   */
  primary: propTypes.bool,

  /**
   * Boolean if the secondary theme color should be applied.
   */
  secondary: propTypes.bool,

  /**
   * Boolean if the icon is considered disabled and should inherit the
   * disabled color.
   */
  disabled: propTypes.bool,

  /**
   * Boolean if the error color should be applied to the icon.
   */
  error: propTypes.bool,

  /**
   * Boolean if the color of the icon should be inherited by parent elements.
   */
  inherit: propTypes.bool,

  /**
   * Either a boolean that will enforce the 24x24 size of the font icon or a number of the size
   * to enforce. This is useful when using other font icon libraries that do not have a consistent
   * size.
   */
  forceSize: propTypes.oneOfType([propTypes.bool, propTypes.number]),

  /**
   * Boolean if the `forceSize` prop should also force the `font-size` instead of only `width` and `height`.
   */
  forceFontSize: function forceFontSize(props, propName, component) {
    for (var _len = arguments.length, args = Array(_len > 3 ? _len - 3 : 0), _key = 3; _key < _len; _key++) {
      args[_key - 3] = arguments[_key];
    }

    var error = propTypes.bool.apply(propTypes, [props, propName, component].concat(args));
    if (!error && typeof props.forceSize === 'undefined' && props[propName]) {
      error = new Error('You provided a `forceFontSize` prop to the ' + component + ' component, without specifying the `forceSize` ' + ('prop. Either set the `forceSize` prop to a boolean or a number, or disable `' + propName + '`.'));
    }

    return error;
  },

  /**
   * Any children required to display the icon with the font library.
   */
  children: propTypes.node
};
FontIcon.defaultProps = {
  iconClassName: 'material-icons'
};

var _initialiseProps$2 = function _initialiseProps() {
  this._mergeStyles = function (_ref) {
    var style = _ref.style,
        forceSize = _ref.forceSize,
        forceFontSize = _ref.forceFontSize;

    var styles = style;
    if (typeof forceSize === 'boolean') {
      styles = _extends({
        height: ICON_SIZE,
        width: ICON_SIZE,
        fontSize: forceFontSize ? ICON_SIZE : undefined
      }, style);
    } else if (typeof forceSize === 'number') {
      styles = _extends({
        height: forceSize,
        width: forceSize,
        fontSize: forceFontSize ? forceSize : undefined
      }, style);
    }

    return styles;
  };
};

function getDeprecatedIcon(className, children, icon) {
  if (className || children) {
    return React.createElement(
      FontIcon,
      { iconClassName: className },
      children
    );
  }

  return icon;
}

/**
 * The `TileAddon` component is used to render either a `FontIcon` or an `Avatar`
 * next to the `ListTileText` for a `ListItem`.
 */

var TileAddon = function (_PureComponent) {
  inherits(TileAddon, _PureComponent);

  function TileAddon() {
    classCallCheck(this, TileAddon);
    return possibleConstructorReturn(this, (TileAddon.__proto__ || Object.getPrototypeOf(TileAddon)).apply(this, arguments));
  }

  createClass(TileAddon, [{
    key: 'render',
    value: function render() {
      var _props = this.props,
          icon = _props.icon,
          avatar = _props.avatar,
          active = _props.active,
          activeClassName = _props.activeClassName,
          style = _props.style,
          className = _props.className;

      if (!icon && !avatar) {
        return null;
      }

      var avatarIcon = false;
      if (avatar) {
        var avatarChild = React.Children.only(avatar);
        if (avatarChild.props.iconSized) {
          avatarIcon = true;
        }
      }
      return React.createElement(
        'div',
        {
          style: style,
          className: classnames('md-tile-addon', defineProperty({
            'md-tile-addon--icon': icon || avatarIcon,
            'md-tile-addon--avatar': avatar && !avatarIcon
          }, activeClassName, active), className)
        },
        icon || avatar
      );
    }
  }]);
  return TileAddon;
}(PureComponent);

TileAddon.propTypes = {
  style: propTypes.object,
  className: propTypes.string,
  active: propTypes.bool,
  activeClassName: propTypes.string,
  icon: propTypes.node,
  avatar: propTypes.node
};

/**
 * The `ListItemText` component is used to render the `primaryText` and an optional
 * `secondaryText` for a `ListItem`.
 */

var ListItemText = function (_PureComponent) {
  inherits(ListItemText, _PureComponent);

  function ListItemText() {
    classCallCheck(this, ListItemText);
    return possibleConstructorReturn(this, (ListItemText.__proto__ || Object.getPrototypeOf(ListItemText)).apply(this, arguments));
  }

  createClass(ListItemText, [{
    key: 'render',
    value: function render() {
      var _props = this.props,
          active = _props.active,
          activeClassName = _props.activeClassName,
          disabled = _props.disabled,
          primaryText = _props.primaryText,
          primaryTextStyle = _props.primaryTextStyle,
          primaryTextClassName = _props.primaryTextClassName,
          secondaryText = _props.secondaryText,
          secondaryTextStyle = _props.secondaryTextStyle,
          secondaryTextClassName = _props.secondaryTextClassName,
          className = _props.className,
          threeLines = _props.threeLines,
          props = objectWithoutProperties(_props, ['active', 'activeClassName', 'disabled', 'primaryText', 'primaryTextStyle', 'primaryTextClassName', 'secondaryText', 'secondaryTextStyle', 'secondaryTextClassName', 'className', 'threeLines']);


      var secondaryTextNode = void 0;
      if (secondaryText) {
        secondaryTextNode = React.createElement(
          'div',
          {
            style: secondaryTextStyle,
            className: classnames('md-tile-text--secondary', {
              'md-tile-text--three-lines': threeLines
            }, themeColors({ disabled: disabled, hint: !disabled }), secondaryTextClassName)
          },
          secondaryText
        );
      }

      return React.createElement(
        'div',
        _extends({}, props, { className: classnames('md-tile-content', className) }),
        React.createElement(
          'div',
          {
            style: primaryTextStyle,
            className: classnames('md-tile-text--primary', defineProperty({}, activeClassName, !disabled && active), themeColors({ disabled: disabled, text: !active }), primaryTextClassName)
          },
          primaryText
        ),
        secondaryTextNode
      );
    }
  }]);
  return ListItemText;
}(PureComponent);

ListItemText.propTypes = {
  active: propTypes.bool,
  activeClassName: propTypes.string,
  disabled: propTypes.bool,
  primaryText: propTypes.node.isRequired,
  primaryTextStyle: propTypes.object,
  primaryTextClassName: propTypes.string,
  secondaryText: propTypes.node,
  secondaryTextStyle: propTypes.object,
  secondaryTextClassName: propTypes.string,
  className: propTypes.string,
  threeLines: propTypes.bool
};

/**
 * The `Subheader` component is generally used inside of lists or menus.
 */

var Subheader$1 = function (_PureComponent) {
  inherits(Subheader, _PureComponent);

  function Subheader() {
    classCallCheck(this, Subheader);
    return possibleConstructorReturn(this, (Subheader.__proto__ || Object.getPrototypeOf(Subheader)).apply(this, arguments));
  }

  createClass(Subheader, [{
    key: 'render',
    value: function render() {
      var _props = this.props,
          Component$$1 = _props.component,
          inset = _props.inset,
          primary = _props.primary,
          primaryText = _props.primaryText,
          className = _props.className,
          children = _props.children,
          props = objectWithoutProperties(_props, ['component', 'inset', 'primary', 'primaryText', 'className', 'children']);


      return React.createElement(
        Component$$1,
        _extends({}, props, {
          className: classnames('md-subheader', {
            'md-list-item--inset': inset
          }, themeColors({ primary: primary, hint: !primary }), className)
        }),
        primaryText,
        children
      );
    }
  }]);
  return Subheader;
}(PureComponent);

Subheader$1.propTypes = {
  /**
   * An optional style to apply to the subheader.
   */
  style: propTypes.object,

  /**
   * An optional className to apply to the subheader.
   */
  className: propTypes.string,

  /**
   * Boolean if the subheader should be styled with the primary color.
   */
  primary: propTypes.bool,

  /**
   * Boolean if the subheader is inset in the list. This will add additional
   * spacing to align the subheader.
   */
  inset: propTypes.bool,

  /**
   * The primary text to use in the subheader.
   */
  primaryText: propTypes.node.isRequired,

  /**
   * Any optional children to display after the `primaryText`. This prop is
   * not recommended.
   */
  children: propTypes.node,

  /**
   * The component to render the Subheader as.
   */
  component: propTypes.oneOfType([propTypes.string, propTypes.func]).isRequired
};
Subheader$1.defaultProps = {
  component: 'li'
};

/**
 * Lists present multiple line items vertically as a single continuous element.
 */

var List = function (_PureComponent) {
  inherits(List, _PureComponent);

  function List() {
    var _ref;

    var _temp, _this, _ret;

    classCallCheck(this, List);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = possibleConstructorReturn(this, (_ref = List.__proto__ || Object.getPrototypeOf(List)).call.apply(_ref, [this].concat(args))), _this), _this.state = {}, _temp), possibleConstructorReturn(_this, _ret);
  }

  createClass(List, [{
    key: 'getChildContext',
    value: function getChildContext() {
      var _context = this.context,
          listLevel = _context.listLevel,
          context = objectWithoutProperties(_context, ['listLevel']);

      var cascadingFixedTo = getField(this.state, this.context, 'cascadingFixedTo');
      return _extends({}, context, {
        cascadingFixedTo: cascadingFixedTo,
        listLevel: typeof listLevel === 'undefined' ? 1 : listLevel + 1
      });
    }
  }, {
    key: 'componentDidMount',
    value: function componentDidMount() {
      if (this.context.cascadingMenu) {
        var list = findDOMNode(this);
        if (list.offsetHeight < list.scrollHeight) {
          var cascadingFixedTo = { y: findDOMNode(this) };
          this.setState({ cascadingFixedTo: cascadingFixedTo }); // eslint-disable-line react/no-did-mount-set-state
        }
      }
    }
  }, {
    key: 'render',
    value: function render() {
      var _cn;

      var _props = this.props,
          className = _props.className,
          ordered = _props.ordered,
          children = _props.children,
          subheader = _props.subheader,
          inline = _props.inline,
          primarySubheader = _props.primarySubheader,
          props = objectWithoutProperties(_props, ['className', 'ordered', 'children', 'subheader', 'inline', 'primarySubheader']);
      var _context2 = this.context,
          cascadingMenu = _context2.cascadingMenu,
          cascadingZDepth = _context2.cascadingZDepth,
          listLevel = _context2.listLevel;


      var subheaderEl = void 0;
      if (subheader) {
        subheaderEl = React.createElement(Subheader$1, { key: 'subheader', primaryText: subheader, primary: primarySubheader });
      }

      var Component$$1 = ordered ? 'ol' : 'ul';
      return React.createElement(
        Component$$1,
        _extends({}, props, {
          className: classnames('md-list', (_cn = {
            'md-list--inline': inline,
            'md-list--menu-cascading': cascadingMenu
          }, defineProperty(_cn, 'md-paper md-paper--' + cascadingZDepth, cascadingZDepth && cascadingMenu && listLevel > 0), defineProperty(_cn, 'md-list--nested-' + listLevel, listLevel && !cascadingMenu), _cn), className)
        }),
        subheaderEl,
        children
      );
    }
  }]);
  return List;
}(PureComponent);

List.propTypes = {
  /**
   * An optional style to apply to the list.
   */
  style: propTypes.object,

  /**
   * An optional className to apply to the list.
   */
  className: propTypes.string,

  /**
   * Boolean if this should be an ordered list (`<ol>`) component. Otherwise, it will
   * be rendered as `<ul>`.
   */
  ordered: propTypes.bool,

  /**
   * This *should* be a list of `ListItem`, `ListItemControl`, `Divider`, or
   * `Subheader`.
   */
  children: propTypes.node,

  /**
   * Boolean if the list should appear horizontally instead of vertically.
   */
  inline: propTypes.bool,
  subheader: deprecated(propTypes.string, 'Use the `Subheader` component as a child instead'),
  primarySubheader: deprecated(propTypes.bool, 'Use the `Subheader` component as a child instead')
};
List.childContextTypes = {
  listLevel: propTypes.number,
  cascadingMenu: propTypes.bool,
  cascadingFixedTo: fixedToShape,
  cascadingZDepth: propTypes.number
};
List.contextTypes = {
  listLevel: propTypes.number,
  cascadingMenu: propTypes.bool,
  cascadingFixedTo: fixedToShape,
  cascadingZDepth: propTypes.number
};

var isRequiredForA11y_1 = createCommonjsModule(function (module, exports) {
'use strict';

exports.__esModule = true;
exports.default = isRequiredForA11y;
function isRequiredForA11y(validator) {
  return function validate(props, propName, componentName, location, propFullName) {
    var componentNameSafe = componentName || '<<anonymous>>';
    var propFullNameSafe = propFullName || propName;

    if (props[propName] == null) {
      return new Error('The ' + location + ' `' + propFullNameSafe + '` is required to make ' + ('`' + componentNameSafe + '` accessible for users of assistive ') + 'technologies such as screen readers.');
    }

    for (var _len = arguments.length, args = Array(_len > 5 ? _len - 5 : 0), _key = 5; _key < _len; _key++) {
      args[_key - 5] = arguments[_key];
    }

    return validator.apply(undefined, [props, propName, componentName, location, propFullName].concat(args));
  };
}
});

var isRequiredForA11y = unwrapExports(isRequiredForA11y_1);

/** @module utils/EventUtils/handleWindowClickListeners */
var mobileSafari = void 0;

/**
 * Since mobile safari doesn't delegate click events to the window (it only does touch events),
 * this utility function will hack a fix to allow the delegation by updaging the body's cursor
 * to be a pointer.
 *
 * Hopefully this can be removed one day....
 *
 * @see https://developer.mozilla.org/en-US/docs/Web/Events/click#Safari_Mobile
 * @param {function} cb - the callback function to use for a window click event.
 * @param {boolean} enabled - boolean if the click event is enabled.
 */
function handleWindowClickListeners(cb) {
  var enabled = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

  if (typeof mobileSafari === 'undefined' && typeof window !== 'undefined') {
    var ua = window.navigator.userAgent;
    var iOS = ua.match(/iP(ad|hone)/i);
    var webkit = ua.match(/WebKit/i);
    mobileSafari = iOS && webkit && !ua.match(/CriOS/i);

    if (mobileSafari) {
      document.body.style.cursor = 'pointer';
    }
  }

  var listener = window[(enabled ? 'add' : 'remove') + 'EventListener'];
  listener('click', cb);
}

/** @module utils/getSelectedText */

/**
 * A utility function that gets the current selected text in the document. I think
 * that all the browsers I support have `window.getSelection`, but it falls back to
 * support others.
 *
 * @return {String} the current selection on the page
 */
function getSelectedText() {
  if (typeof window.getSelection !== 'undefined') {
    return window.getSelection().toString();
  } else if (typeof document.selection !== 'undefined' && document.selection.type === 'Text') {
    return document.selection.createRange().text;
  }

  return '';
}

/** @module utils/Positoning/getSelectedTextPosition */
var ZERO_WIDTH_CHARACTER = '\u200B';

/**
 * A utility function to attempt to get the current highlighted text position.
 *
 * When a context menu is opened, this function attempts to find the bounding client rect
 * for the highlighted text. However, if the text is in the text field, some weird stuff
 * happens and it is unable to get it correctly.
 */
function getSelectedTextPosition(e) {
  var height = void 0;
  var target = e.target,
      clientX = e.clientX,
      clientY = e.clientY;

  var text = getSelectedText();
  var width = Math.round(getTextWidth(text, target) || 0);
  if (!text || target.classList.contains('md-text-field')) {
    height = parseInt(window.getComputedStyle(target).fontSize, 10);
    return {
      width: width,
      height: height,
      left: clientX - width,
      top: clientY
    };
  }

  // All browsers I am supporting have window.getSelection, but better safe than sorry
  if (window.getSelection) {
    var selection = window.getSelection();
    if (selection.rangeCount) {
      var range = selection.getRangeAt(0).cloneRange();
      var rect = null;
      if (range.getClientRects) {
        var rects = range.getClientRects();
        if (rects.length > 0) {
          rect = rects[0];
        }
      }

      if (!rect) {
        var span = document.createElement('span');
        span.appendChild(document.createTextNode(ZERO_WIDTH_CHARACTER));
        range.insertNode(span);
        rect = span.getBoundingClientRect();

        var spanParent = span.parentNode;
        spanParent.removeChild(span);
        spanParent.normalize();
      }

      return rect;
    }
  }

  return null;
}

/** @module utils/Positioning/getScroll */

/**
 * A utility function to just get an element's scroll x and y
 * values. This is really just needed because `window` uses
 * different attributes.
 *
 * @param {Object} el - The element to get a scroll value from.
 * @return {Object} an object containing the scrollX and scrollY of the element.
 */
function getScroll(el) {
  if (typeof el.scrollX !== 'undefined' && typeof el.scrollY !== 'undefined') {
    return { x: el.scrollX, y: el.scrollY };
  } else if (typeof el.scrollLeft !== 'undefined' && typeof el.scrollTop !== 'undefined') {
    return { x: el.scrollLeft, y: el.scrollTop };
  }

  return { x: 0, y: 0 };
}

/** @module utils/Positioning/getScreenSize */

/**
 * A utility function to get the height or width of the of the browser with
 * a fallback for older browsers.
 *
 * @param {String} position - the position to get the screen size for
 * @return {number} the screen size for the provided position.
 */
function getScreenSize(position) {
  if (position !== 'Height' && position !== 'Width' && process.env.NODE_ENV !== 'production') {
    throw new Error('The \'getScreenSize\' function requires either a position of \'Height\' or \'Width\' ' + ('but received `' + position + '`'));
  }

  return window['inner' + position] || document.documentElement['client' + position];
}

/** @module utils/Positioning/viewport */
/**
 * Determines if an element is still in the viewport. If it is,
 * it will return a `true` boolean. If it is not, it will return
 * an object containing booleans for top, right, bottom, and left
 * where a `false` value will mean it is out of the viewport for that
 * position.
 *
 * @param {Object} el - The element to test.
 * @return {boolean|Object} the results.
 */
function viewport(el) {
  if (!el) {
    return {};
  }

  var rect = el.getBoundingClientRect();
  var top = rect.top >= 0;
  var right = rect.right <= getScreenSize('Width');
  var bottom = rect.bottom <= getScreenSize('Height');
  var left = rect.left >= 0;

  return top && right && bottom && left || { top: top, right: right, bottom: bottom, left: left };
}

/** @module utils/Positioning/isOutOfBounds */

function isOutHorizontally(fixedTo, child, threshold) {
  var _fixedTo$getBoundingC = fixedTo.getBoundingClientRect(),
      fixedLeft = _fixedTo$getBoundingC.left,
      fixedRight = _fixedTo$getBoundingC.right;

  var _child$getBoundingCli = child.getBoundingClientRect(),
      childLeft = _child$getBoundingCli.left,
      childRight = _child$getBoundingCli.right;

  var offset = child.offsetWidth * threshold;

  var left = childLeft + offset;
  var right = childRight - offset;

  var screenEdge = childLeft === 0 || getScreenSize('Width') === childRight;
  return fixedLeft > left || fixedRight < right || screenEdge;
}

function isOutVertically(fixedTo, child, toggle, threshold) {
  var _fixedTo$getBoundingC2 = fixedTo.getBoundingClientRect(),
      fixedTop = _fixedTo$getBoundingC2.top,
      fixedBottom = _fixedTo$getBoundingC2.bottom;

  var _child$getBoundingCli2 = child.getBoundingClientRect(),
      childTop = _child$getBoundingCli2.top,
      childBottom = _child$getBoundingCli2.bottom;

  var offset = toggle.offsetHeight * threshold;

  var screenEdge = childTop === 0 || getScreenSize('Height') === childBottom;
  return fixedTop > childTop + offset || fixedBottom < childTop - offset || screenEdge;
}

/**
 * Checks if the fixedTo object for the Layover component is considered
 * out of bounds relative to the container.
 *
 * @param {Object} fixedTo - The Layover's `fixedTo` prop.
 * @param {Object} child - The Layover's `children` prop as a DOM element.
 * @param {Object} toggle - The Layover's `toggle` prop as a DOM element.
 * @param {number} verticalThreshold - The vertical threshold multiplier to apply.
 * @param {number} horizontalThreshold - The horizontal threshold multiplier to apply.
 * @return {boolean} true if the Layover's `fixedTo` prop is considered out of bounds.
 */
function isOutOfBounds(fixedTo, child, toggle, verticalThreshold, horizontalThreshold) {
  if (fixedTo === window) {
    return false;
  } else if (fixedTo.x || fixedTo.y) {
    var x = fixedTo.x,
        y = fixedTo.y;

    return !!y && isOutVertically(y, child, toggle, verticalThreshold) || !!x && isOutHorizontally(x, child, horizontalThreshold);
  }

  return isOutVertically(fixedTo, child, toggle, verticalThreshold) || isOutHorizontally(fixedTo, child, horizontalThreshold);
}

/**
 * A collection of shims that provide minimal functionality of the ES6 collections.
 *
 * These implementations are not meant to be used outside of the ResizeObserver
 * modules as they cover only a limited range of use cases.
 */
/* eslint-disable require-jsdoc, valid-jsdoc */
var MapShim = (function () {
    if (typeof Map != 'undefined') {
        return Map;
    }

    /**
     * Returns index in provided array that matches the specified key.
     *
     * @param {Array<Array>} arr
     * @param {*} key
     * @returns {number}
     */
    function getIndex(arr, key) {
        var result = -1;

        arr.some(function (entry, index) {
            if (entry[0] === key) {
                result = index;

                return true;
            }

            return false;
        });

        return result;
    }

    return (function () {
        function anonymous() {
            this.__entries__ = [];
        }

        var prototypeAccessors = { size: {} };

        /**
         * @returns {boolean}
         */
        prototypeAccessors.size.get = function () {
            return this.__entries__.length;
        };

        /**
         * @param {*} key
         * @returns {*}
         */
        anonymous.prototype.get = function (key) {
            var index = getIndex(this.__entries__, key);
            var entry = this.__entries__[index];

            return entry && entry[1];
        };

        /**
         * @param {*} key
         * @param {*} value
         * @returns {void}
         */
        anonymous.prototype.set = function (key, value) {
            var index = getIndex(this.__entries__, key);

            if (~index) {
                this.__entries__[index][1] = value;
            } else {
                this.__entries__.push([key, value]);
            }
        };

        /**
         * @param {*} key
         * @returns {void}
         */
        anonymous.prototype.delete = function (key) {
            var entries = this.__entries__;
            var index = getIndex(entries, key);

            if (~index) {
                entries.splice(index, 1);
            }
        };

        /**
         * @param {*} key
         * @returns {void}
         */
        anonymous.prototype.has = function (key) {
            return !!~getIndex(this.__entries__, key);
        };

        /**
         * @returns {void}
         */
        anonymous.prototype.clear = function () {
            this.__entries__.splice(0);
        };

        /**
         * @param {Function} callback
         * @param {*} [ctx=null]
         * @returns {void}
         */
        anonymous.prototype.forEach = function (callback, ctx) {
            if ( ctx === void 0 ) ctx = null;

            for (var i = 0, list = this.__entries__; i < list.length; i += 1) {
                var entry = list[i];

                callback.call(ctx, entry[1], entry[0]);
            }
        };

        Object.defineProperties( anonymous.prototype, prototypeAccessors );

        return anonymous;
    }());
})();

/**
 * Detects whether window and document objects are available in current environment.
 */
var isBrowser = typeof window != 'undefined' && typeof document != 'undefined' && window.document === document;

/**
 * A shim for the requestAnimationFrame which falls back to the setTimeout if
 * first one is not supported.
 *
 * @returns {number} Requests' identifier.
 */
var requestAnimationFrame$1$1 = (function () {
    if (typeof requestAnimationFrame === 'function') {
        return requestAnimationFrame;
    }

    return function (callback) { return setTimeout(function () { return callback(Date.now()); }, 1000 / 60); };
})();

// Defines minimum timeout before adding a trailing call.
var trailingTimeout = 2;

/**
 * Creates a wrapper function which ensures that provided callback will be
 * invoked only once during the specified delay period.
 *
 * @param {Function} callback - Function to be invoked after the delay period.
 * @param {number} delay - Delay after which to invoke callback.
 * @returns {Function}
 */
var throttle = function (callback, delay) {
    var leadingCall = false,
        trailingCall = false,
        lastCallTime = 0;

    /**
     * Invokes the original callback function and schedules new invocation if
     * the "proxy" was called during current request.
     *
     * @returns {void}
     */
    function resolvePending() {
        if (leadingCall) {
            leadingCall = false;

            callback();
        }

        if (trailingCall) {
            proxy();
        }
    }

    /**
     * Callback invoked after the specified delay. It will further postpone
     * invocation of the original function delegating it to the
     * requestAnimationFrame.
     *
     * @returns {void}
     */
    function timeoutCallback() {
        requestAnimationFrame$1$1(resolvePending);
    }

    /**
     * Schedules invocation of the original function.
     *
     * @returns {void}
     */
    function proxy() {
        var timeStamp = Date.now();

        if (leadingCall) {
            // Reject immediately following calls.
            if (timeStamp - lastCallTime < trailingTimeout) {
                return;
            }

            // Schedule new call to be in invoked when the pending one is resolved.
            // This is important for "transitions" which never actually start
            // immediately so there is a chance that we might miss one if change
            // happens amids the pending invocation.
            trailingCall = true;
        } else {
            leadingCall = true;
            trailingCall = false;

            setTimeout(timeoutCallback, delay);
        }

        lastCallTime = timeStamp;
    }

    return proxy;
};

// Minimum delay before invoking the update of observers.
var REFRESH_DELAY = 20;

// A list of substrings of CSS properties used to find transition events that
// might affect dimensions of observed elements.
var transitionKeys = ['top', 'right', 'bottom', 'left', 'width', 'height', 'size', 'weight'];

// Detect whether running in IE 11 (facepalm).
var isIE11 = typeof navigator != 'undefined' && /Trident\/.*rv:11/.test(navigator.userAgent);

// MutationObserver should not be used if running in Internet Explorer 11 as it's
// implementation is unreliable. Example: https://jsfiddle.net/x2r3jpuz/2/
//
// It's a real bummer that there is no other way to check for this issue but to
// use the UA information.
var mutationObserverSupported = typeof MutationObserver != 'undefined' && !isIE11;

/**
 * Singleton controller class which handles updates of ResizeObserver instances.
 */
var ResizeObserverController = function() {
    /**
     * Indicates whether DOM listeners have been added.
     *
     * @private {boolean}
     */
    this.connected_ = false;

    /**
     * Tells that controller has subscribed for Mutation Events.
     *
     * @private {boolean}
     */
    this.mutationEventsAdded_ = false;

    /**
     * Keeps reference to the instance of MutationObserver.
     *
     * @private {MutationObserver}
     */
    this.mutationsObserver_ = null;

    /**
     * A list of connected observers.
     *
     * @private {Array<ResizeObserverSPI>}
     */
    this.observers_ = [];

    this.onTransitionEnd_ = this.onTransitionEnd_.bind(this);
    this.refresh = throttle(this.refresh.bind(this), REFRESH_DELAY);
};

/**
 * Adds observer to observers list.
 *
 * @param {ResizeObserverSPI} observer - Observer to be added.
 * @returns {void}
 */
ResizeObserverController.prototype.addObserver = function (observer) {
    if (!~this.observers_.indexOf(observer)) {
        this.observers_.push(observer);
    }

    // Add listeners if they haven't been added yet.
    if (!this.connected_) {
        this.connect_();
    }
};

/**
 * Removes observer from observers list.
 *
 * @param {ResizeObserverSPI} observer - Observer to be removed.
 * @returns {void}
 */
ResizeObserverController.prototype.removeObserver = function (observer) {
    var observers = this.observers_;
    var index = observers.indexOf(observer);

    // Remove observer if it's present in registry.
    if (~index) {
        observers.splice(index, 1);
    }

    // Remove listeners if controller has no connected observers.
    if (!observers.length && this.connected_) {
        this.disconnect_();
    }
};

/**
 * Invokes the update of observers. It will continue running updates insofar
 * it detects changes.
 *
 * @returns {void}
 */
ResizeObserverController.prototype.refresh = function () {
    var changesDetected = this.updateObservers_();

    // Continue running updates if changes have been detected as there might
    // be future ones caused by CSS transitions.
    if (changesDetected) {
        this.refresh();
    }
};

/**
 * Updates every observer from observers list and notifies them of queued
 * entries.
 *
 * @private
 * @returns {boolean} Returns "true" if any observer has detected changes in
 *  dimensions of it's elements.
 */
ResizeObserverController.prototype.updateObservers_ = function () {
    // Collect observers that have active observations.
    var activeObservers = this.observers_.filter(function (observer) {
        return observer.gatherActive(), observer.hasActive();
    });

    // Deliver notifications in a separate cycle in order to avoid any
    // collisions between observers, e.g. when multiple instances of
    // ResizeObserver are tracking the same element and the callback of one
    // of them changes content dimensions of the observed target. Sometimes
    // this may result in notifications being blocked for the rest of observers.
    activeObservers.forEach(function (observer) { return observer.broadcastActive(); });

    return activeObservers.length > 0;
};

/**
 * Initializes DOM listeners.
 *
 * @private
 * @returns {void}
 */
ResizeObserverController.prototype.connect_ = function () {
    // Do nothing if running in a non-browser environment or if listeners
    // have been already added.
    if (!isBrowser || this.connected_) {
        return;
    }

    // Subscription to the "Transitionend" event is used as a workaround for
    // delayed transitions. This way it's possible to capture at least the
    // final state of an element.
    document.addEventListener('transitionend', this.onTransitionEnd_);

    window.addEventListener('resize', this.refresh);

    if (mutationObserverSupported) {
        this.mutationsObserver_ = new MutationObserver(this.refresh);

        this.mutationsObserver_.observe(document, {
            attributes: true,
            childList: true,
            characterData: true,
            subtree: true
        });
    } else {
        document.addEventListener('DOMSubtreeModified', this.refresh);

        this.mutationEventsAdded_ = true;
    }

    this.connected_ = true;
};

/**
 * Removes DOM listeners.
 *
 * @private
 * @returns {void}
 */
ResizeObserverController.prototype.disconnect_ = function () {
    // Do nothing if running in a non-browser environment or if listeners
    // have been already removed.
    if (!isBrowser || !this.connected_) {
        return;
    }

    document.removeEventListener('transitionend', this.onTransitionEnd_);
    window.removeEventListener('resize', this.refresh);

    if (this.mutationsObserver_) {
        this.mutationsObserver_.disconnect();
    }

    if (this.mutationEventsAdded_) {
        document.removeEventListener('DOMSubtreeModified', this.refresh);
    }

    this.mutationsObserver_ = null;
    this.mutationEventsAdded_ = false;
    this.connected_ = false;
};

/**
 * "Transitionend" event handler.
 *
 * @private
 * @param {TransitionEvent} event
 * @returns {void}
 */
ResizeObserverController.prototype.onTransitionEnd_ = function (ref) {
        var propertyName = ref.propertyName;

    // Detect whether transition may affect dimensions of an element.
    var isReflowProperty = transitionKeys.some(function (key) {
        return !!~propertyName.indexOf(key);
    });

    if (isReflowProperty) {
        this.refresh();
    }
};

/**
 * Returns instance of the ResizeObserverController.
 *
 * @returns {ResizeObserverController}
 */
ResizeObserverController.getInstance = function () {
    if (!this.instance_) {
        this.instance_ = new ResizeObserverController();
    }

    return this.instance_;
};

/**
 * Holds reference to the controller's instance.
 *
 * @private {ResizeObserverController}
 */
ResizeObserverController.instance_ = null;

/**
 * Defines non-writable/enumerable properties of the provided target object.
 *
 * @param {Object} target - Object for which to define properties.
 * @param {Object} props - Properties to be defined.
 * @returns {Object} Target object.
 */
var defineConfigurable = (function (target, props) {
    for (var i = 0, list = Object.keys(props); i < list.length; i += 1) {
        var key = list[i];

        Object.defineProperty(target, key, {
            value: props[key],
            enumerable: false,
            writable: false,
            configurable: true
        });
    }

    return target;
});

// Placeholder of an empty content rectangle.
var emptyRect = createRectInit(0, 0, 0, 0);

/**
 * Converts provided string to a number.
 *
 * @param {number|string} value
 * @returns {number}
 */
function toFloat(value) {
    return parseFloat(value) || 0;
}

/**
 * Extracts borders size from provided styles.
 *
 * @param {CSSStyleDeclaration} styles
 * @param {...string} positions - Borders positions (top, right, ...)
 * @returns {number}
 */
function getBordersSize(styles) {
    var positions = Array.prototype.slice.call(arguments, 1);

    return positions.reduce(function (size, position) {
        var value = styles['border-' + position + '-width'];

        return size + toFloat(value);
    }, 0);
}

/**
 * Extracts paddings sizes from provided styles.
 *
 * @param {CSSStyleDeclaration} styles
 * @returns {Object} Paddings box.
 */
function getPaddings(styles) {
    var positions = ['top', 'right', 'bottom', 'left'];
    var paddings = {};

    for (var i = 0, list = positions; i < list.length; i += 1) {
        var position = list[i];

        var value = styles['padding-' + position];

        paddings[position] = toFloat(value);
    }

    return paddings;
}

/**
 * Calculates content rectangle of provided SVG element.
 *
 * @param {SVGGraphicsElement} target - Element content rectangle of which needs
 *      to be calculated.
 * @returns {DOMRectInit}
 */
function getSVGContentRect(target) {
    var bbox = target.getBBox();

    return createRectInit(0, 0, bbox.width, bbox.height);
}

/**
 * Calculates content rectangle of provided HTMLElement.
 *
 * @param {HTMLElement} target - Element for which to calculate the content rectangle.
 * @returns {DOMRectInit}
 */
function getHTMLElementContentRect(target) {
    // Client width & height properties can't be
    // used exclusively as they provide rounded values.
    var clientWidth = target.clientWidth;
    var clientHeight = target.clientHeight;

    // By this condition we can catch all non-replaced inline, hidden and
    // detached elements. Though elements with width & height properties less
    // than 0.5 will be discarded as well.
    //
    // Without it we would need to implement separate methods for each of
    // those cases and it's not possible to perform a precise and performance
    // effective test for hidden elements. E.g. even jQuery's ':visible' filter
    // gives wrong results for elements with width & height less than 0.5.
    if (!clientWidth && !clientHeight) {
        return emptyRect;
    }

    var styles = getComputedStyle(target);
    var paddings = getPaddings(styles);
    var horizPad = paddings.left + paddings.right;
    var vertPad = paddings.top + paddings.bottom;

    // Computed styles of width & height are being used because they are the
    // only dimensions available to JS that contain non-rounded values. It could
    // be possible to utilize the getBoundingClientRect if only it's data wasn't
    // affected by CSS transformations let alone paddings, borders and scroll bars.
    var width = toFloat(styles.width),
        height = toFloat(styles.height);

    // Width & height include paddings and borders when the 'border-box' box
    // model is applied (except for IE).
    if (styles.boxSizing === 'border-box') {
        // Following conditions are required to handle Internet Explorer which
        // doesn't include paddings and borders to computed CSS dimensions.
        //
        // We can say that if CSS dimensions + paddings are equal to the "client"
        // properties then it's either IE, and thus we don't need to subtract
        // anything, or an element merely doesn't have paddings/borders styles.
        if (Math.round(width + horizPad) !== clientWidth) {
            width -= getBordersSize(styles, 'left', 'right') + horizPad;
        }

        if (Math.round(height + vertPad) !== clientHeight) {
            height -= getBordersSize(styles, 'top', 'bottom') + vertPad;
        }
    }

    // Following steps can't be applied to the document's root element as its
    // client[Width/Height] properties represent viewport area of the window.
    // Besides, it's as well not necessary as the <html> itself neither has
    // rendered scroll bars nor it can be clipped.
    if (!isDocumentElement(target)) {
        // In some browsers (only in Firefox, actually) CSS width & height
        // include scroll bars size which can be removed at this step as scroll
        // bars are the only difference between rounded dimensions + paddings
        // and "client" properties, though that is not always true in Chrome.
        var vertScrollbar = Math.round(width + horizPad) - clientWidth;
        var horizScrollbar = Math.round(height + vertPad) - clientHeight;

        // Chrome has a rather weird rounding of "client" properties.
        // E.g. for an element with content width of 314.2px it sometimes gives
        // the client width of 315px and for the width of 314.7px it may give
        // 314px. And it doesn't happen all the time. So just ignore this delta
        // as a non-relevant.
        if (Math.abs(vertScrollbar) !== 1) {
            width -= vertScrollbar;
        }

        if (Math.abs(horizScrollbar) !== 1) {
            height -= horizScrollbar;
        }
    }

    return createRectInit(paddings.left, paddings.top, width, height);
}

/**
 * Checks whether provided element is an instance of the SVGGraphicsElement.
 *
 * @param {Element} target - Element to be checked.
 * @returns {boolean}
 */
var isSVGGraphicsElement = (function () {
    // Some browsers, namely IE and Edge, don't have the SVGGraphicsElement
    // interface.
    if (typeof SVGGraphicsElement != 'undefined') {
        return function (target) { return target instanceof SVGGraphicsElement; };
    }

    // If it's so, then check that element is at least an instance of the
    // SVGElement and that it has the "getBBox" method.
    // eslint-disable-next-line no-extra-parens
    return function (target) { return target instanceof SVGElement && typeof target.getBBox === 'function'; };
})();

/**
 * Checks whether provided element is a document element (<html>).
 *
 * @param {Element} target - Element to be checked.
 * @returns {boolean}
 */
function isDocumentElement(target) {
    return target === document.documentElement;
}

/**
 * Calculates an appropriate content rectangle for provided html or svg element.
 *
 * @param {Element} target - Element content rectangle of which needs to be calculated.
 * @returns {DOMRectInit}
 */
function getContentRect(target) {
    if (!isBrowser) {
        return emptyRect;
    }

    if (isSVGGraphicsElement(target)) {
        return getSVGContentRect(target);
    }

    return getHTMLElementContentRect(target);
}

/**
 * Creates rectangle with an interface of the DOMRectReadOnly.
 * Spec: https://drafts.fxtf.org/geometry/#domrectreadonly
 *
 * @param {DOMRectInit} rectInit - Object with rectangle's x/y coordinates and dimensions.
 * @returns {DOMRectReadOnly}
 */
function createReadOnlyRect(ref) {
    var x = ref.x;
    var y = ref.y;
    var width = ref.width;
    var height = ref.height;

    // If DOMRectReadOnly is available use it as a prototype for the rectangle.
    var Constr = typeof DOMRectReadOnly != 'undefined' ? DOMRectReadOnly : Object;
    var rect = Object.create(Constr.prototype);

    // Rectangle's properties are not writable and non-enumerable.
    defineConfigurable(rect, {
        x: x, y: y, width: width, height: height,
        top: y,
        right: x + width,
        bottom: height + y,
        left: x
    });

    return rect;
}

/**
 * Creates DOMRectInit object based on the provided dimensions and the x/y coordinates.
 * Spec: https://drafts.fxtf.org/geometry/#dictdef-domrectinit
 *
 * @param {number} x - X coordinate.
 * @param {number} y - Y coordinate.
 * @param {number} width - Rectangle's width.
 * @param {number} height - Rectangle's height.
 * @returns {DOMRectInit}
 */
function createRectInit(x, y, width, height) {
    return { x: x, y: y, width: width, height: height };
}

/**
 * Class that is responsible for computations of the content rectangle of
 * provided DOM element and for keeping track of it's changes.
 */
var ResizeObservation = function(target) {
    /**
     * Broadcasted width of content rectangle.
     *
     * @type {number}
     */
    this.broadcastWidth = 0;

    /**
     * Broadcasted height of content rectangle.
     *
     * @type {number}
     */
    this.broadcastHeight = 0;

    /**
     * Reference to the last observed content rectangle.
     *
     * @private {DOMRectInit}
     */
    this.contentRect_ = createRectInit(0, 0, 0, 0);

    /**
     * Reference to the observed element.
     *
     * @type {Element}
     */
    this.target = target;
};

/**
 * Updates content rectangle and tells whether it's width or height properties
 * have changed since the last broadcast.
 *
 * @returns {boolean}
 */
ResizeObservation.prototype.isActive = function () {
    var rect = getContentRect(this.target);

    this.contentRect_ = rect;

    return rect.width !== this.broadcastWidth || rect.height !== this.broadcastHeight;
};

/**
 * Updates 'broadcastWidth' and 'broadcastHeight' properties with a data
 * from the corresponding properties of the last observed content rectangle.
 *
 * @returns {DOMRectInit} Last observed content rectangle.
 */
ResizeObservation.prototype.broadcastRect = function () {
    var rect = this.contentRect_;

    this.broadcastWidth = rect.width;
    this.broadcastHeight = rect.height;

    return rect;
};

var ResizeObserverEntry = function(target, rectInit) {
    var contentRect = createReadOnlyRect(rectInit);

    // According to the specification following properties are not writable
    // and are also not enumerable in the native implementation.
    //
    // Property accessors are not being used as they'd require to define a
    // private WeakMap storage which may cause memory leaks in browsers that
    // don't support this type of collections.
    defineConfigurable(this, { target: target, contentRect: contentRect });
};

var ResizeObserverSPI = function(callback, controller, callbackCtx) {
    if (typeof callback !== 'function') {
        throw new TypeError('The callback provided as parameter 1 is not a function.');
    }

    /**
     * Collection of resize observations that have detected changes in dimensions
     * of elements.
     *
     * @private {Array<ResizeObservation>}
     */
    this.activeObservations_ = [];

    /**
     * Registry of the ResizeObservation instances.
     *
     * @private {Map<Element, ResizeObservation>}
     */
    this.observations_ = new MapShim();

    /**
     * Reference to the callback function.
     *
     * @private {ResizeObserverCallback}
     */
    this.callback_ = callback;

    /**
     * Reference to the associated ResizeObserverController.
     *
     * @private {ResizeObserverController}
     */
    this.controller_ = controller;

    /**
     * Public ResizeObserver instance which will be passed to the callback
     * function and used as a value of it's "this" binding.
     *
     * @private {ResizeObserver}
     */
    this.callbackCtx_ = callbackCtx;
};

/**
 * Starts observing provided element.
 *
 * @param {Element} target - Element to be observed.
 * @returns {void}
 */
ResizeObserverSPI.prototype.observe = function (target) {
    if (!arguments.length) {
        throw new TypeError('1 argument required, but only 0 present.');
    }

    // Do nothing if current environment doesn't have the Element interface.
    if (typeof Element === 'undefined' || !(Element instanceof Object)) {
        return;
    }

    if (!(target instanceof Element)) {
        throw new TypeError('parameter 1 is not of type "Element".');
    }

    var observations = this.observations_;

    // Do nothing if element is already being observed.
    if (observations.has(target)) {
        return;
    }

    observations.set(target, new ResizeObservation(target));

    this.controller_.addObserver(this);

    // Force the update of observations.
    this.controller_.refresh();
};

/**
 * Stops observing provided element.
 *
 * @param {Element} target - Element to stop observing.
 * @returns {void}
 */
ResizeObserverSPI.prototype.unobserve = function (target) {
    if (!arguments.length) {
        throw new TypeError('1 argument required, but only 0 present.');
    }

    // Do nothing if current environment doesn't have the Element interface.
    if (typeof Element === 'undefined' || !(Element instanceof Object)) {
        return;
    }

    if (!(target instanceof Element)) {
        throw new TypeError('parameter 1 is not of type "Element".');
    }

    var observations = this.observations_;

    // Do nothing if element is not being observed.
    if (!observations.has(target)) {
        return;
    }

    observations.delete(target);

    if (!observations.size) {
        this.controller_.removeObserver(this);
    }
};

/**
 * Stops observing all elements.
 *
 * @returns {void}
 */
ResizeObserverSPI.prototype.disconnect = function () {
    this.clearActive();
    this.observations_.clear();
    this.controller_.removeObserver(this);
};

/**
 * Collects observation instances the associated element of which has changed
 * it's content rectangle.
 *
 * @returns {void}
 */
ResizeObserverSPI.prototype.gatherActive = function () {
        var this$1 = this;

    this.clearActive();

    this.observations_.forEach(function (observation) {
        if (observation.isActive()) {
            this$1.activeObservations_.push(observation);
        }
    });
};

/**
 * Invokes initial callback function with a list of ResizeObserverEntry
 * instances collected from active resize observations.
 *
 * @returns {void}
 */
ResizeObserverSPI.prototype.broadcastActive = function () {
    // Do nothing if observer doesn't have active observations.
    if (!this.hasActive()) {
        return;
    }

    var ctx = this.callbackCtx_;

    // Create ResizeObserverEntry instance for every active observation.
    var entries = this.activeObservations_.map(function (observation) {
        return new ResizeObserverEntry(observation.target, observation.broadcastRect());
    });

    this.callback_.call(ctx, entries, ctx);
    this.clearActive();
};

/**
 * Clears the collection of active observations.
 *
 * @returns {void}
 */
ResizeObserverSPI.prototype.clearActive = function () {
    this.activeObservations_.splice(0);
};

/**
 * Tells whether observer has active observations.
 *
 * @returns {boolean}
 */
ResizeObserverSPI.prototype.hasActive = function () {
    return this.activeObservations_.length > 0;
};

// Registry of internal observers. If WeakMap is not available use current shim
// for the Map collection as it has all required methods and because WeakMap
// can't be fully polyfilled anyway.
var observers = typeof WeakMap != 'undefined' ? new WeakMap() : new MapShim();

/**
 * ResizeObserver API. Encapsulates the ResizeObserver SPI implementation
 * exposing only those methods and properties that are defined in the spec.
 */
var ResizeObserver$1$1 = function(callback) {
    if (!(this instanceof ResizeObserver$1$1)) {
        throw new TypeError('Cannot call a class as a function');
    }

    if (!arguments.length) {
        throw new TypeError('1 argument required, but only 0 present.');
    }

    var controller = ResizeObserverController.getInstance();
    var observer = new ResizeObserverSPI(callback, controller, this);

    observers.set(this, observer);
};

// Expose public methods of ResizeObserver.
['observe', 'unobserve', 'disconnect'].forEach(function (method) {
    ResizeObserver$1$1.prototype[method] = function () {
        return (ref = observers.get(this))[method].apply(ref, arguments);
        var ref;
    };
});

var index = (function () {
    // Export existing implementation if available.
    if (typeof ResizeObserver != 'undefined') {
        // eslint-disable-next-line no-undef
        return ResizeObserver;
    }

    return ResizeObserver$1$1;
})();

/**
 * The `ResizeObserver` component is a component hook for the
 * [ResizeObserver](http://rawgit.com/WICG/ResizeObserver/master/index.html)
 * using the [resize-observer-polyfill](https://github.com/que-etc/resize-observer-polyfill)
 * for browsers that don't support it yet.
 *
 * This component displays an empty `span` with `aria-hidden` to allow access to the DOM. By
 * default it will attempt to watch changes on its parent component, but it can be configured
 * to watch any element by using the `target` prop.
 */

var ResizeObserver$1 = function (_PureComponent) {
  inherits(ResizeObserver, _PureComponent);

  function ResizeObserver() {
    var _ref;

    var _temp, _this, _ret;

    classCallCheck(this, ResizeObserver);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = possibleConstructorReturn(this, (_ref = ResizeObserver.__proto__ || Object.getPrototypeOf(ResizeObserver)).call.apply(_ref, [this].concat(args))), _this), _this._container = null, _this._target = null, _this._observer = null, _this._height = null, _this._width = null, _this._scrollHeight = null, _this._scrollWidth = null, _this._measure = function (entries) {
      if (!_this._observer || !_this._target) {
        return;
      }

      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = entries[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          var entry = _step.value;

          if (!entry) {
            return;
          }

          var _entry$contentRect = entry.contentRect,
              height = _entry$contentRect.height,
              width = _entry$contentRect.width;
          var _entry$target = entry.target,
              scrollHeight = _entry$target.scrollHeight,
              scrollWidth = _entry$target.scrollWidth;

          if (_this._isHeightChange(height, scrollHeight) || _this._isWidthChange(width, scrollWidth)) {
            _this._height = height;
            _this._width = width;
            _this._scrollHeight = scrollHeight;
            _this._scrollWidth = scrollWidth;
            _this.props.onResize({ height: height, width: width, scrollHeight: scrollHeight, scrollWidth: scrollWidth, el: entry.target });
          }
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator.return) {
            _iterator.return();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }
    }, _this._isHeightChange = function (height, scrollHeight) {
      return _this.props.watchHeight && (height !== _this._height || scrollHeight !== _this._scrollHeight);
    }, _this._isWidthChange = function (width, scrollWidth) {
      return _this.props.watchWidth && (width !== _this._width || scrollWidth !== _this._scrollWidth);
    }, _this._handleRef = function (container) {
      if (container) {
        _this._container = container;
        _this._target = _this._getTarget(container, _this.props.target);
        _this._observer = new index(_this._measure);

        if (_this._target) {
          _this._observer.observe(_this._target);
        }
      } else {
        if (_this._observer) {
          _this._observer.disconnect();
        }

        _this._container = null;
        _this._target = null;
        _this._observer = null;
        _this._height = null;
        _this._width = null;
        _this._scrollHeight = null;
        _this._scrollWidth = null;
      }

      if (_this.props.elRef) {
        _this.props.elRef(_this._target);
      }
    }, _temp), possibleConstructorReturn(_this, _ret);
  }

  createClass(ResizeObserver, [{
    key: 'componentWillReceiveProps',
    value: function componentWillReceiveProps(nextProps) {
      var target = this.props.target;

      var nextTarget = nextProps.target;
      if (target === nextTarget) {
        return;
      } else if (nextTarget) {
        if (this._target) {
          this._observer.unobserve(this._target);
        }
        this._target = this._getTarget(this._container, nextTarget);
        this._observer.observe(this._target);
      }
    }
  }, {
    key: '_getTarget',
    value: function _getTarget(container, target) {
      if (target === null || target && typeof target !== 'string') {
        return target;
      }

      var t = null;
      if (target) {
        t = document.getElementById(target) || document.querySelector(target);
      } else {
        t = container.parentNode;
      }

      if (!t) {
        throw new Error('An HTMLDOMNode is required as the `ResizeObserver`\'s watch target but none were provided/found. ' + ('Please update the target prop to find a valid node since the provided target is invalid. `' + target + '`.'));
      }

      return t;
    }
  }, {
    key: 'render',
    value: function render() {
      var Component$$1 = this.props.component;

      return React.createElement(Component$$1, { ref: this._handleRef, 'aria-hidden': true });
    }
  }]);
  return ResizeObserver;
}(PureComponent);

ResizeObserver$1.propTypes = {
  /**
   * Boolean if the height should be watched for the resize target.
   */
  watchHeight: propTypes.bool,

  /**
   * Boolean if the width should be watched for the resize target.
   */
  watchWidth: propTypes.bool,

  /**
   * An optional target that should be used for detecting resize events. This can either
   * be a HTMLDOMNode or a string to use with `document.getElementById` or `document.querySelector`.
   *
   * If this prop is not provided and not null, it will default to the parent node of this component.
   * If the provided `target={null}`, the observer will not begin until the `target` is `undefined` or
   * it has been correctly passed a target string or object.
   */
  target: propTypes.oneOfType([propTypes.object, propTypes.string]),

  /**
   * The component to be rendered as. This should normally just be the default `span`, but there are cases
   * where the component should be switched to something else for valid html.
   */
  component: propTypes.string,

  /**
   * A function to call when the height or width has been changed and that attribute is being watched.
   * The callback will include the current height, width, scrollHeight and scrollWidth of the target.
   *
   * ```js
   * onResize({
   *   height: nextHeight,
   *   width: nextWidth,
   *   scrollHeight: nextScrollHeight,
   *   scrollWidth: nextScrollWidth,
   *   el: resizeTarget,
   * });
   * ```
   */
  onResize: propTypes.func.isRequired,

  /**
   * An optional ref callback that will include the `target` or the parent node of the resize observer. Just
   * like other refs, this will provide null when it unmounts.
   *
   * This is really only helpful if you'd like the DOM node for a parent Component without needing to use
   * `ReactDOM.findDOMNode(this)`.
   */
  elRef: propTypes.func
};
ResizeObserver$1.defaultProps = {
  watchHeight: false,
  watchWidth: false,
  component: 'span'
};

/**
 * The Layover component is used to keep a component fixed to another component
 * while the page is scrolling or a container is scrolling. When the fixed component
 * is considered out of view, it will be closed.
 *
 * > NOTE: Don't look at source code. Plz.
 */

var Layover = function (_PureComponent) {
  inherits(Layover, _PureComponent);

  function Layover(props) {
    classCallCheck(this, Layover);

    var _this = possibleConstructorReturn(this, (Layover.__proto__ || Object.getPrototypeOf(Layover)).call(this));

    _initialiseProps$3.call(_this);

    var child = React.Children.only(props.children);
    _this.state = {
      below: false,
      right: false,
      styles: child.props.style
    };

    _this._lastXFix = null;
    _this._lastYFix = null;
    _this._initialX = null;
    _this._initialY = null;
    _this._initialTop = null;
    _this._initialLeft = null;
    _this._child = null;
    _this._toggle = null;
    return _this;
  }

  createClass(Layover, [{
    key: 'componentDidMount',
    value: function componentDidMount() {
      var _this2 = this;

      if (process.env.NODE_ENV === 'development') {
        window.addEventListener('load', function () {
          _this2._setContainer(_this2._container);
        });
      }

      var _props = this.props,
          visible = _props.visible,
          fixedTo = _props.fixedTo,
          sameWidth = _props.sameWidth,
          centered = _props.centered,
          simplified = _props.simplified;

      var anchor = this._getAnchor(this.props);
      if (visible) {
        handleWindowClickListeners(this._handleOutsideClick, true);

        // Don't worry about any of the other logic for a "simple" layover
        if (simplified) {
          return;
        }

        var rect = this._contextRect || this._toggle.getBoundingClientRect();
        if (this._dialog) {
          this._manageFixedToListener(this._dialog, true);
        } else if (!this._inFixed) {
          this._manageFixedToListener(fixedTo, true);
        }

        this._init(fixedTo, anchor, sameWidth, centered, rect);
      }
    }
  }, {
    key: 'componentWillReceiveProps',
    value: function componentWillReceiveProps(nextProps) {
      var fixedTo = nextProps.fixedTo,
          visible = nextProps.visible,
          children = nextProps.children,
          sameWidth = nextProps.sameWidth,
          centered = nextProps.centered,
          simplified = nextProps.simplified;

      if (simplified) {
        if (this.props.simplified !== simplified) {
          this._reset();
        }
        return;
      }

      var anchor = this._getAnchor(nextProps);
      var visibileDiff = visible !== this.props.visible;
      var childStyle = React.Children.only(children).props.style;

      if (visibileDiff) {
        if (!visible) {
          this._reset();
        } else {
          // Initialize the layover logic
          var rect = this._contextRect || this._toggle.getBoundingClientRect();
          if (this._dialog) {
            this._manageFixedToListener(this._dialog, true);
          } else if (!this._inFixed) {
            this._manageFixedToListener(fixedTo, true);
          }

          this._init(fixedTo, anchor, sameWidth, centered, rect);
        }
      } else if (fixedTo !== this.props.fixedTo && visible) {
        // swap the fixedTo listeners
        this._manageFixedToListener(this.props.fixedTo, false);
        this._manageFixedToListener(fixedTo, true);
      } else if (childStyle !== React.Children.only(this.props.children).props.style) {
        // Re-merge styles... This is only required if all the others fail since all the other
        // logic always merges styles with the children styles
        this.setState({ styles: _extends({}, this.state.styles, childStyle) });
      }
    }
  }, {
    key: 'componentDidUpdate',
    value: function componentDidUpdate(prevProps) {
      var _this3 = this;

      var _props2 = this.props,
          visible = _props2.visible,
          closeOnOutsideClick = _props2.closeOnOutsideClick;

      var enabled = visible && closeOnOutsideClick;
      var prevEnabled = prevProps.visible && prevProps.closeOnOutsideClick;
      if (enabled !== prevEnabled) {
        if (this._clickTimeout) {
          clearTimeout(this._clickTimeout);
          this._clickTimeout = null;
        }

        // This is really an arbitrary timeout time, but firefox needs to have a timeout
        // so the context menu doesn't close automatically due to an "outside click" being
        // triggered
        this._clickTimeout = setTimeout(function () {
          _this3._clickTimeout = null;
          handleWindowClickListeners(_this3._handleOutsideClick, enabled);
        }, enabled ? 300 : 0);
      }
    }
  }, {
    key: 'componentWillUnmount',
    value: function componentWillUnmount() {
      if (this._clickTimeout) {
        clearTimeout(this._clickTimeout);
        this._clickTimeout = null;
      }
      handleWindowClickListeners(this._handleOutsideClick, false);

      if (!this.props.simplified) {
        this._manageFixedToListener(this.props.fixedTo, false);
        this._manageWindowResizeListener(false);
      }
    }
  }, {
    key: '_getAnchor',
    value: function _getAnchor(_ref) {
      var anchor = _ref.anchor,
          belowAnchor = _ref.belowAnchor,
          animationPosition = _ref.animationPosition;

      return animationPosition === Layover.Positions.BELOW && belowAnchor || anchor;
    }

    /**
     * Whew. Ok. So since the fixedTo prop can either be two elements or a single item,
     * this utility function is used to add/remove the scrolling event listeners for
     * this prop.
     *
     * When the fixedTo prop has a horizontal and/or vertical attribute, the `window`
     * will be the fallback option. If both the horizontal and vertical attributes are
     * defined, the `window` still needs to have a scroll listener to make sure it
     * doesn't go off screen.
     */


    /**
     * This is just a simple utility function to merge the existing state styles,
     * any new styles, and the children's styles (with most precedence).
     */


    /**
     * This initializes the popover with the default styles, and the initial bookkeeping
     * variables to update while it is open.
     */


    /**
     * Attempts to fix the child by setting it's location ONLY for the entire
     * page viewport. I didn't bother attempting to fix it for additional fixedTo
     * stuff.
     */


    /**
     * When the child is initially mounted, it will update the styles for centering
     * the element (if enabled) and then attempt to fix any viewport issues.
     */


    /**
     * This is the meat of the stuff. Do lots of viewport / container checks to make sure
     * the element should still be visible. If it is still visible, it will update its
     * x and y position for the new scroll position.
     */


    /**
     * Attempts to fix a viewport problem by swapping the positioning. This only does
     * vertical switching right now.
     *
     * @param {Object} vp - The result of the viewport function
     * @return {boolean} true if the fix was able to be done and successful.
     */

  }, {
    key: 'render',
    value: function render() {
      var _props3 = this.props,
          className = _props3.className,
          block = _props3.block,
          toggle = _props3.toggle,
          visible = _props3.visible,
          children = _props3.children,
          fullWidth = _props3.fullWidth,
          animationPosition = _props3.animationPosition,
          simplified = _props3.simplified,
          fillViewportWidth = _props3.fillViewportWidth,
          fillViewportHeight = _props3.fillViewportHeight,
          anchor = _props3.anchor,
          belowAnchor = _props3.belowAnchor,
          onClose = _props3.onClose,
          repositionOnScroll = _props3.repositionOnScroll,
          repositionOnResize = _props3.repositionOnResize,
          sameWidth = _props3.sameWidth,
          centered = _props3.centered,
          fixedTo = _props3.fixedTo,
          toggleQuery = _props3.toggleQuery,
          yThreshold = _props3.yThreshold,
          xThreshold = _props3.xThreshold,
          onContextMenu = _props3.onContextMenu,
          preventContextMenu = _props3.preventContextMenu,
          closeOnOutsideClick = _props3.closeOnOutsideClick,
          minLeft = _props3.minLeft,
          minRight = _props3.minRight,
          minBottom = _props3.minBottom,
          props = objectWithoutProperties(_props3, ['className', 'block', 'toggle', 'visible', 'children', 'fullWidth', 'animationPosition', 'simplified', 'fillViewportWidth', 'fillViewportHeight', 'anchor', 'belowAnchor', 'onClose', 'repositionOnScroll', 'repositionOnResize', 'sameWidth', 'centered', 'fixedTo', 'toggleQuery', 'yThreshold', 'xThreshold', 'onContextMenu', 'preventContextMenu', 'closeOnOutsideClick', 'minLeft', 'minRight', 'minBottom']);


      var child = void 0;
      var childId = void 0;
      if (visible) {
        child = React.Children.only(children);
        if (child.props.id) {
          childId = child.props.id;
        } else if (props.id) {
          childId = props.id + '-layover';
        }

        child = React.cloneElement(children, {
          ref: this._fixateChild,
          id: childId,
          style: simplified ? child.props.style : this.state.styles,
          className: classnames('md-layover-child md-layover-child--' + animationPosition, {
            'md-layover-child--simplified': simplified
          }, child.props.className)
        });
      }

      var observer = null;
      if (!simplified && !fillViewportWidth && !fillViewportHeight) {
        observer = React.createElement(ResizeObserver$1, {
          watchWidth: !fillViewportWidth,
          watchHeight: !fillViewportHeight,
          target: this._child,
          onResize: this._handleResize
        });
      }

      return React.createElement(
        CSSTransitionGroup,
        _extends({}, props, {
          className: classnames('md-layover', {
            'md-layover--simplified': simplified,
            'md-inline-block': !block && !fullWidth,
            'md-full-width': fullWidth
          }, className),
          ref: this._setContainer,
          'aria-haspopup': true,
          'aria-owns': childId,
          'aria-expanded': visible,
          transitionEnter: props.transitionEnterTimeout !== 0,
          transitionLeave: props.transitionLeaveTimeout !== 0,
          onContextMenu: this._handleContextMenu
        }),
        observer,
        toggle,
        child
      );
    }
  }]);
  return Layover;
}(PureComponent);

Layover.HorizontalAnchors = HorizontalAnchors;
Layover.VerticalAnchors = VerticalAnchors;
Layover.Positions = Positions;
Layover.propTypes = {
  /**
   * A id to give the layover itself. This is generally recommended for accessibility. If the
   * child does not have an id, the child will automatically be updated to be `${id}-layover`.
   */
  id: propTypes.oneOfType([propTypes.number, propTypes.string]),

  /**
   * An optional style to apply to the layover.
   */
  style: propTypes.object,

  /**
   * An optional className to apply to the layover.
   */
  className: propTypes.string,

  /**
   * Boolean if the layover's child is currently visible.
   */
  visible: propTypes.bool.isRequired,

  /**
   * This should either be a single element or two elements that the layover recalculates
   * its fixed position when scrolling for horizontal and vertical.
   *
   * When it is a single element, it will recalculate for both horizontal and vertical
   * scrolling. Otherwise, you can specify the element for horizontal scrolling and a
   * separate element for vertical scrolling. If one is omitted, it will default to `window`.
   *
   * If the component is no longer considered to be in view after scrolling, the `onClose`
   * prop will be called.
   */
  fixedTo: fixedToShape.isRequired,

  /**
   * The renderable item that causes the Layover to become visible. This _should_
   * most likely be an `element` or `arrayOf(element)`, but anything is allowed.
   */
  toggle: propTypes.node,

  /**
   * Since the `toggle` prop can be anything, I need a way to be able to find an
   * element to base all the calculations on. This can either be a string that
   * gets passed to `layover.querySelector`, a DOM Element, or a function that
   * returns a DOM Element.
   */
  toggleQuery: propTypes.oneOfType([propTypes.func, propTypes.object, propTypes.string]).isRequired,

  /**
   * A single child that should be fixed to the toggle element.
   */
  children: propTypes.element.isRequired,

  /**
   * Boolean if the Layover should be displayed as a block instead of as an inline block.
   */
  block: propTypes.bool,

  /**
   * Boolean if the `children` should be centered horizontally and vertically while keeping
   * its height in mind as well. This is *only* valid if both the x and y `anchor` targets
   * are `CENTER`.
   */
  centered: propTypes.bool,

  /**
   * Boolean if the layover should gain the `md-full-width` class name.
   */
  fullWidth: propTypes.bool,

  /**
   * Boolean if the width of the children should be updated automatically to be the width
   * of the toggle element.
   */
  sameWidth: propTypes.bool,

  /**
   * The minimum value the `left` style can be for the child component. This is really just used
   * to make sure it doesn't scroll off the left of the page. It can also be used to make
   * full screen layovers on devices when when the `fillViewportWidth` prop is enabled.
   *
   * This can either be a number of pixels or a string for percentages. If this value is a string
   * **it will always be used over the calculated values** so it is preferred to use a number.
   *
   * @see {@link #minRight}
   * @see {@link #fillViewportWidth}
   */
  minLeft: propTypes.oneOfType([propTypes.number, propTypes.string]).isRequired,

  /**
   * The minimum value the `right` style can be for the child component. This is really just used
   * to make sure it doesn't scroll off the right of the page when the `fillViewportWidth` prop is
   * enabled.
   *
   * This can either be a number of pixels or a string for percentages. If this value is a string
   * **it will always be used over the calculated values** so it is preferred to use a number.
   *
   * @see {@link #minLeft}
   * @see {@link #fillViewportWidth}
   */
  minRight: propTypes.oneOfType([propTypes.number, propTypes.string]).isRequired,

  /**
   * The minimum value that can be used for the `bottom` prop when the `fillViewportHeight` prop is enabled.
   * It is generally recommended to keep this value at `0` to keep it stretched to the bottom of the viewport
   * or setting it to a small positive number to add some padding.
   *
   * This can either be a number of pixels or a string for percentages. If this value is a string
   * **it will always be used over the calculated values** so it is preferred to use a number.
   *
   * @see {@link #fillViewportHeight}
   */
  minBottom: propTypes.number.isRequired,

  /**
   * Boolean if the layover should make the child fill the entire viewport's width. This will just
   * style the child element with:
   *
   * ```js
   * childStyle = {
   *   left: this.props.minLeft,
   *   right: this.props.minRight,
   * };
   * ```
   *
   * If you add any additional constraints such as `width` or `max-width`, it will not span the entire viewport's
   * width. This prop should generally really only be used on mobile devices. Using this prop along with
   * `fillViewportHeight` for Autocompletes can create great Android mobile searches. See the `fillViewportHeight`
   * for more information about why it is *only Android*.
   *
   * @see {@link #minLeft}
   * @see {@link #minRight}
   * @see {@link #fillViewportHeight}
   */
  fillViewportWidth: propTypes.bool,

  /**
   * Boolean if the layover should fill the height of the viewport from the current calculated `top`. This will just
   * style the child element with:
   *
   * ```js
   * childStyle = {
   *   top: currentCalculatedTop,
   *   bottom: this.props.minBottom,
   *   maxHeight: 'none',
   * };
   * ```
   *
   * This is *super* nice on Android devices since it will allow you to create nice toolbar search autocompletes
   * in your app and the list of items will grow until it reaches the soft keyboard. It isn't as nice on iOS since
   * iOS does not subtract the soft keyboard from the viewport's size so the list will still extend to the bottom
   * of the page.
   *
   * @see {@link #minBottom}
   * @see {@link #fillViewportWidth}
   */
  fillViewportHeight: propTypes.bool,

  /**
   * A function used to hide the visibility of the children when the children are no longer
   * visible or an element outside of the layover is clicked.
   */
  onClose: propTypes.func.isRequired,

  /**
   * The component to render the Layover as.
   */
  component: propTypes.oneOfType([propTypes.string, propTypes.func]).isRequired,

  /**
   * The transition name to use for the children appearing/disappearing.
   */
  transitionName: propTypes.string.isRequired,

  /**
   * The transition duration for the enter animation. The animation can be disabled by setting
   * this value to 0.
   */
  transitionEnterTimeout: propTypes.number.isRequired,

  /**
   * The transition duration for the leave animation. The animation can be disabled by setting
   * this value to 0.
   */
  transitionLeaveTimeout: propTypes.number.isRequired,

  /**
   * This is a threshold that is used to calculate if the `children` is still in
   * view by applying this multiplier to the `children`'s width.
   */
  xThreshold: propTypes.number.isRequired,

  /**
   * This is a threshold that is used to calculate if the `children` is still in
   * view by applying this multiplier to the `toggle`'s height.
   */
  yThreshold: propTypes.number.isRequired,

  /**
   * Boolean if the `children` should be hidden when an element outside
   * of the `Layout` component has been clicked.
   */
  closeOnOutsideClick: propTypes.bool.isRequired,

  /**
   * This is how the children get "anchored" to the `toggle` element and how the
   * auto-fix attempts will be made. Right now, the auto fixes will only be handled
   * on viewport boundaries instead of `fixedTo` boundaries. It was too hard for
   * first attempt.
   *
   * The general behavior will be that an equal-opposite of an anchor will be chosen
   * when that direction is out of viewport. So for example, the children are out
   * of viewport for the right of the screen, and the `anchor.x` value is
   * `Layover.HorizontalPositions.RIGHT`, the children will be swapped to be the `LEFT`
   * of the `toggle` component now.
   *
   * So a full list:
   * - `LEFT` / `RIGHT`
   * - `INNER_LEFT` / `INNER_RIGHT`
   * - `TOP` / `BOTTOM`
   *
   * The `CENTER` and `OVERLAP` positions can not be automatically adjusted.
   *
   * > To be safe, you should use the enum values for the `x` and `y` values.
   * @see {@link #VerticalAnchors}
   * @see {@link #HorizontalAnchors}
   */
  anchor: anchorShape.isRequired,

  /**
   * This is how the children get "anchored" when the `animationPositions` is set to `Layover.Positions.BELOW`.
   * Set this to `null` to continue using the base `anchor` prop instead of switching to this anchor.
   *
   * @see {@link #anchor}
   */
  belowAnchor: anchorShape,

  /**
   * This is the position that the children should animate from. It directly ties into
   * the `$md-layover-child-positions` Sass variable.
   */
  animationPosition: positionShape.isRequired,

  /**
   * If you would like the layover to interact as a context menu, provide this prop. It will
   * make the children appear relative to the context menu origin automatically.
   *
   * @see {@link #preventContextMenu}
   */
  onContextMenu: propTypes.func,

  /**
   * Boolean if the default behavior of the context menu should be prevented when using the
   * `onContextMenu` prop.
   *
   * @see {@link #onContextMenu}
   */
  preventContextMenu: propTypes.bool,

  /**
   * Boolean if the layover should attempt to automatically adjust the position of the element to
   * keep it within the viewport. If this value is set to `false`, the `onClose` prop will be called
   * instead.
   */
  repositionOnScroll: propTypes.bool,

  /**
   * Boolean if the layover should attempt to automatically adjust the position of the element to
   * keep it within the viewport. If this value is set to `false`, the `onClose` prop will be called
   * instead.
   */
  repositionOnResize: propTypes.bool,

  /**
   * Boolean if the layover should become "simplified". This basically disables all the logic for
   * keeping the child within the viewport and allows you to manage all the positioning via CSS.
   *
   * When this is enabled, it updates the `Layover` to have `position: relative` while the child will
   * have `position: absolute` which will allow for simple `top`, `right`, `bottom`, and/or `left` CSS
   * to position as wanted.
   *
   * This is really only helpful in cases where the layover can't calculate things correctly due to
   * being in fixed containers somewhere in the page or some other weird stuff. Hopefully this won't
   * really need to be used much.
   */
  simplified: propTypes.bool
};
Layover.defaultProps = {
  anchor: {
    x: Layover.HorizontalAnchors.INNER_LEFT,
    y: Layover.VerticalAnchors.OVERLAP
  },
  belowAnchor: {
    x: Layover.HorizontalAnchors.CENTER,
    y: Layover.VerticalAnchors.BOTTOM
  },
  animationPosition: Layover.Positions.BELOW,
  repositionOnScroll: true,
  repositionOnResize: false,
  component: 'div',
  fixedTo: typeof window !== 'undefined' ? window : {},
  toggleQuery: '.md-text-field-container,button,*[role="button"],*[role="listbox"]',
  transitionName: 'md-layover',
  transitionEnterTimeout: 200,
  transitionLeaveTimeout: 200,
  yThreshold: 0.38,
  xThreshold: 0.38,
  closeOnOutsideClick: true,
  preventContextMenu: true,
  simplified: false,
  minLeft: 0,
  minRight: 0,
  minBottom: 0,
  fillViewportWidth: false,
  fillViewportHeight: false
};

var _initialiseProps$3 = function _initialiseProps() {
  var _this4 = this;

  this._isCenteredDialog = function () {
    return _this4._dialog && _this4._dialog.classList.contains('md-dialog--centered');
  };

  this._createStyles = function (anchor, centered, child, rect) {
    var x = anchor.x,
        y = anchor.y;
    var offsetWidth = child.offsetWidth,
        offsetHeight = child.offsetHeight;


    var left = void 0;
    var top = void 0;
    if (x === HorizontalAnchors.CENTER) {
      left = rect.left + rect.width / 2 - offsetWidth / 2;
    } else if (x === HorizontalAnchors.INNER_RIGHT) {
      left = rect.right - offsetWidth;
    } else if (x === HorizontalAnchors.LEFT) {
      left = rect.left - offsetWidth;
    } else if (x === HorizontalAnchors.RIGHT) {
      left = rect.right;
    }

    if (centered && x === HorizontalAnchors.CENTER && y === VerticalAnchors.CENTER) {
      top = rect.top - offsetHeight / 2 + rect.height / 2;
    } else if (y === VerticalAnchors.TOP) {
      top = rect.top - offsetHeight;
    } else if (y === VerticalAnchors.CENTER) {
      top = rect.top + rect.height / 2;
    } else if (y === VerticalAnchors.BOTTOM) {
      top = rect.bottom;
    }

    if (_this4._isCenteredDialog()) {
      var dialogRect = _this4._dialog.getBoundingClientRect();
      left -= dialogRect.left;
      top -= dialogRect.top;
    }

    var style = {};
    if (top) {
      style.top = top;
    }

    if (left) {
      style.left = left;
    }

    return style;
  };

  this._manageFixedToListener = function (fixedTo, add) {
    var listener = (add ? 'add' : 'remove') + 'EventListener';
    if (fixedTo !== window && (fixedTo.x || fixedTo.y)) {
      var x = fixedTo.x,
          y = fixedTo.y;

      if (x) {
        x[listener]('scroll', _this4._handleScroll);
      } else {
        window[listener]('scroll', _this4._handleScroll);
      }

      if (y) {
        y[listener]('scroll', _this4._handleScroll);
      } else if (!x) {
        // Only add the window event listener once
        window[listener]('scroll', _this4._handleScroll);
      }

      if (y && y !== window && x && x !== window) {
        window[listener]('scroll', _this4._handleScroll);
      }
    } else {
      fixedTo[listener]('scroll', _this4._handleScroll);

      if (fixedTo !== window) {
        window[listener]('scroll', _this4._handleScroll);
      }
    }
  };

  this._manageWindowResizeListener = function (enabled) {
    if (_this4._windowResizeTimeout) {
      clearTimeout(_this4._windowResizeTimeout);
      _this4._windowResizeTimeout = null;
    }

    if (enabled) {
      // add a 2 second delay before watching resize events since Android soft keyboards trigger a resize event.
      _this4._windowResizeTimeout = setTimeout(function () {
        _this4._windowResizeTimeout = null;
        window.addEventListener('resize', _this4._handleWindowResize);
      }, 2000);
    } else {
      window.removeEventListener('resize', _this4._handleWindowResize);
    }
  };

  this._mergeStyles = function (style) {
    var _props4 = _this4.props,
        minLeft = _props4.minLeft,
        minRight = _props4.minRight,
        minBottom = _props4.minBottom,
        fillViewportWidth = _props4.fillViewportWidth,
        fillViewportHeight = _props4.fillViewportHeight;

    if (fillViewportWidth) {
      style.left = minLeft;
      style.right = minRight;
    } else {
      if (style.left) {
        style.left = Math.max(minLeft, style.left);
      }

      if (style.right) {
        style.right = Math.max(minRight, style.right);
      }
    }

    if (fillViewportHeight) {
      style.bottom = minBottom;
      style.maxHeight = 'none';
    } else {
      // These styles are only created when filling the viewport height, so clear
      // them out again
      style.bottom = null;
      style.maxHeight = null;
    }

    return _extends({}, _this4.state.styles, style, React.Children.only(_this4.props.children).props.style);
  };

  this._init = function (fixedTo, anchor, sameWidth, centered, rect) {
    if (_this4._child) {
      // The init function can be called again if the user quickly toggles the layover. If that
      // is the case, we want the styles that were set after the _positionChild _attemptFix.
      return;
    }

    var height = rect.height,
        width = rect.width;
    var top = rect.top,
        left = rect.left,
        right = rect.right;

    var x = void 0;
    var y = void 0;
    if (_this4._dialog) {
      var scroll = getScroll(_this4._dialog);
      x = scroll.x;
      y = scroll.y;

      if (_this4._isCenteredDialog()) {
        var dialogRect = _this4._dialog.getBoundingClientRect();
        left -= dialogRect.left;
        top -= dialogRect.top;
        right -= dialogRect.right;
      }
    } else if (fixedTo !== window && (fixedTo.y || fixedTo.x)) {
      x = getScroll(fixedTo.x || window).x;
      y = getScroll(fixedTo.y || window).y;
    } else {
      var _scroll = getScroll(fixedTo);
      x = _scroll.x;
      y = _scroll.y;
    }

    _this4._initialX = x;
    _this4._initialY = y;
    _this4._initialLeft = left;
    _this4._initialTop = top;

    if (anchor.x === HorizontalAnchors.INNER_RIGHT) {
      _this4._initialLeft = left + width;
    } else if (anchor.x === HorizontalAnchors.RIGHT) {
      _this4._initialLeft = right;
    }

    if (!centered) {
      _this4._lastYFix = anchor.y === VerticalAnchors.TOP ? 'bottom' : 'top';
    } else {
      // Centered is not fixable
      _this4._lastYFix = null;
    }
    if (anchor.x === HorizontalAnchors.LEFT || anchor.x === HorizontalAnchors.INNER_LEFT) {
      _this4._lastXFix = 'right';
    } else if (anchor.x === HorizontalAnchors.RIGHT || anchor.x === HorizontalAnchors.INNER_RIGHT) {
      _this4._lastXFix = 'left';
    } else {
      // Can't fix others
      _this4._lastXFix = null;
    }

    if (anchor.y === VerticalAnchors.BOTTOM) {
      _this4._initialTop = top + height;
    }

    if (fixedTo !== window && !fixedTo.y && !fixedTo.x) {
      var _scroll2 = getScroll(window);
      _this4._initialWinX = _scroll2.x;
      _this4._initialWinY = _scroll2.y;
    }

    var styles = _this4._mergeStyles({
      left: _this4._initialLeft,
      top: _this4._initialTop,
      transformOrigin: undefined,
      width: sameWidth ? width : undefined
    });

    _this4.setState({ styles: styles });
  };

  this._reset = function () {
    var _ref2 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : _this4.props,
        fixedTo = _ref2.fixedTo;

    // Reset all the bookkeeping variables for a fresh start on re-visible
    _this4._lastXFix = null;
    _this4._lastYFix = null;
    _this4._initialX = null;
    _this4._initialY = null;
    _this4._initialTop = null;
    _this4._initialLeft = null;

    if (!_this4._inFixed) {
      if (_this4._dialog) {
        _this4._manageFixedToListener(_this4._dialog, false);
      }

      _this4._manageFixedToListener(fixedTo, false);
    }
  };

  this._setContainer = function (container) {
    _this4._container = findDOMNode(container);
    _this4._toggle = null;
    if (!_this4._container) {
      return;
    }

    var _props5 = _this4.props,
        toggleQuery = _props5.toggleQuery,
        onContextMenu = _props5.onContextMenu;

    if (typeof toggleQuery === 'function') {
      _this4._toggle = toggleQuery();
    } else if (typeof toggleQuery === 'string') {
      _this4._toggle = _this4._container.querySelector(toggleQuery);
    } else {
      _this4._toggle = toggleQuery;
    }

    if (!_this4._toggle && !onContextMenu && process.env.NODE_ENV !== 'production') {
      var error = new Error('Unable to find a toggle component with the provided `toggleQuery` and `toggle` element. \n' + ('`toggleQuery`: `' + toggleQuery + '`'));
      error.toggleQuery = toggleQuery;
      error.toggle = _this4.props.toggle;

      throw error;
    }

    var node = _this4._container;
    while (node) {
      var fixed = window.getComputedStyle(node).position === 'fixed';
      if (fixed && node.className.match(/md-dialog--(full-page|centered)/)) {
        _this4._dialog = node;
        return;
      } else if (fixed && !node.classList.contains('md-layover-child')) {
        _this4._inFixed = true;
        return;
      }

      node = node.offsetParent;
    }
  };

  this._initialFix = function () {
    // Need to make a clone that disables any transitions to calculate positioning stuff
    var clone = _this4._child.cloneNode(true);
    clone.style.webkitTransform = 'none';
    clone.style.transfrom = 'none';
    clone.style.webkitTransition = 'none';
    clone.style.transition = 'none';

    _this4._child.parentNode.appendChild(clone);
    var vp = viewport(clone);
    var childHeight = clone.offsetHeight,
        childWidth = clone.offsetWidth;

    _this4._child.parentNode.removeChild(clone);

    if (vp === true || !_this4._toggle || !_this4._child) {
      return;
    }

    var _getAnchor2 = _this4._getAnchor(_this4.props),
        x = _getAnchor2.x,
        y = _getAnchor2.y;

    var toggleHeight = void 0;
    var toggleWidth = void 0;
    if (_this4._contextRect) {
      toggleHeight = _this4._contextRect.height;
      toggleWidth = _this4._contextRect.width;
    } else {
      toggleHeight = _this4._toggle.offsetHeight;
      toggleWidth = _this4._toggle.offsetWidth;
    }

    var addToTop = 0;
    var addToLeft = 0;

    // Android devices will never get this far because they consider the keyboard as part
    // of the viewport, iOS will and cause it to be a giant negative number. *sigh*
    // Prevent any additional vertical positioning for iOS
    if (!_this4.props.fillViewportHeight && (!vp.top || !vp.bottom)) {
      var multiplier = vp.top ? -1 : 1;
      if (!vp.bottom && y === VerticalAnchors.OVERLAP) {
        addToTop += toggleHeight;
      } else if (y === VerticalAnchors.TOP || y === VerticalAnchors.BOTTOM) {
        addToTop += multiplier * toggleHeight;
      }

      addToTop += multiplier * childHeight;

      _this4._lastYFix = vp.top ? 'bottom' : 'top';
    }

    if (!_this4.props.fillViewportWidth && x !== HorizontalAnchors.CENTER && (!vp.left || !vp.right)) {
      if (!vp.left && x === HorizontalAnchors.LEFT) {
        addToLeft += toggleWidth + childWidth;
        _this4._lastXFix = 'left';
      } else if (!vp.left && x === HorizontalAnchors.INNER_LEFT) {
        addToLeft += toggleWidth;
        _this4._lastXFix = 'left';
      } else if (!vp.right && x === HorizontalAnchors.RIGHT) {
        addToLeft -= toggleWidth + childWidth;
        _this4._lastXFix = 'right';
      } else if (!vp.right && x === HorizontalAnchors.INNER_RIGHT) {
        addToLeft -= toggleWidth;
        _this4._lastXFix = 'right';
      }
    }

    if (addToTop !== 0 || addToLeft !== 0) {
      _this4._initialTop += addToTop;
      _this4._initialLeft += addToLeft;

      _this4.setState({ styles: _this4._mergeStyles({ top: _this4._initialTop, left: _this4._initialLeft }) });
    }
  };

  this._fixateChild = function (child) {
    _this4._child = findDOMNode(child);

    if (_this4._child !== null) {
      _this4._childComponent = React.Children.only(_this4.props.children);

      // If child also has a ref callback, simulate the same thing
      if (typeof _this4._childComponent.ref === 'function') {
        _this4._childComponent.ref(child);
      }

      if (_this4.props.simplified || !_this4._child || !_this4._toggle && !_this4._contextRect) {
        return;
      }

      if (_this4._dialog && _this4._dialog.classList.contains('md-dialog--centered')) {
        return;
      }

      _this4._manageWindowResizeListener(true);
      _this4._positionChild();
    } else if (_this4._childComponent && typeof _this4._childComponent.ref === 'function') {
      _this4._childComponent.ref(child);
    }
  };

  this._positionChild = function () {
    var centered = _this4.props.centered;

    var anchor = _this4._getAnchor(_this4.props);
    var rect = _this4._contextRect || _this4._toggle.getBoundingClientRect();
    _this4._height = rect.height;
    _this4._width = rect.width;
    var styles = _this4._createStyles(anchor, centered, _this4._child, rect);
    if (styles.top || styles.left) {
      _this4._initialLeft = styles.left || _this4._initialLeft;
      _this4._initialTop = styles.top || _this4._initialTop;
      _this4.setState({ styles: _this4._mergeStyles(styles) }, _this4._initialFix);
    } else {
      _this4._initialFix();
    }
  };

  this._handleResize = function () {
    if (_this4.props.visible) {
      _this4._positionChild();
    }
  };

  this._handleScroll = function (e) {
    if (!_this4.props.repositionOnScroll) {
      _this4._manageFixedToListener(_this4.props.fixedTo, false);
      _this4.props.onClose(e);
    }

    if (!_this4._ticking) {
      requestAnimationFrame(function () {
        return _this4._handleTick(e);
      });
    }

    _this4._ticking = true;
  };

  this._handleTick = function (e) {
    var _props6 = _this4.props,
        fixedTo = _props6.fixedTo,
        xThreshold = _props6.xThreshold,
        yThreshold = _props6.yThreshold;

    var vp = viewport(_this4._child);
    if (vp !== true && vp.left && vp.right) {
      var fixed = !_this4._contextRect && _this4._attemptFix(vp);
      if (!fixed) {
        _this4.props.onClose(e);
        _this4._ticking = false;
      }

      return;
    } else if (isOutOfBounds(fixedTo, _this4._child, _this4._toggle, yThreshold, xThreshold)) {
      _this4.props.onClose(e);
      _this4._ticking = false;
      return;
    }

    var x = void 0;
    var y = void 0;
    if (_this4._dialog) {
      var scroll = getScroll(_this4._dialog);
      x = scroll.x;
      y = scroll.y;
    } else if (fixedTo !== window && (fixedTo.x || fixedTo.y)) {
      x = getScroll(fixedTo.x || window).x;
      y = getScroll(fixedTo.y || window).y;
    } else {
      var _scroll3 = getScroll(fixedTo);
      x = _scroll3.x;
      y = _scroll3.y;
    }

    var winX = void 0;
    var winY = void 0;
    // When using the additional fixedTo stuff, need to also keep track of the entire
    // window's scrolling..
    if (fixedTo !== window && !fixedTo.x && !fixedTo.y) {
      var _scroll4 = getScroll(window);
      winX = _scroll4.x;
      winY = _scroll4.y;
    }

    var styles = _this4.state.styles;
    var left = styles.left,
        top = styles.top;

    if (_this4._initialX !== x) {
      left = _this4._initialX - x + _this4._initialLeft;
    }

    if (winX && _this4._initialWinX !== winX) {
      left = _this4._initialWinX - winX + _this4._initialX;
    }

    if (_this4._initialY !== y) {
      top = _this4._initialY - y + _this4._initialTop;
    }

    if (winY && _this4._initialWinY !== winY) {
      top = _this4._initialWinY - winY + _this4._initialTop + (_this4._initialY - y);
    }

    if (styles.top !== top || styles.left !== left) {
      _this4.setState({ styles: _this4._mergeStyles({ left: left, top: top }) }, function () {
        _this4._ticking = false;
      });
    } else {
      _this4._ticking = false;
    }
  };

  this._handleOutsideClick = function (e) {
    if (_this4._contextRect && _this4._child && !_this4._child.contains(e.target) || _this4._container && !_this4._container.contains(e.target)) {
      _this4.props.onClose(e);
    }
  };

  this._handleWindowResize = function (e) {
    var _props7 = _this4.props,
        onClose = _props7.onClose,
        repositionOnResize = _props7.repositionOnResize;

    if (repositionOnResize) {
      _this4._handleResize();
    } else {
      onClose(e);
      _this4._manageWindowResizeListener(false);
    }
  };

  this._attemptFix = function (vp) {
    var _getAnchor3 = _this4._getAnchor(_this4.props),
        x = _getAnchor3.x,
        y = _getAnchor3.y;

    var centered = x === HorizontalAnchors.CENTER && y === VerticalAnchors.CENTER && _this4.props.centered;
    if (centered || _this4._lastYFix === 'top' && !vp.top || _this4._lastYFix === 'bottom' && !vp.bottom) {
      return false;
    }

    var toggleTop = _this4._toggle.getBoundingClientRect().top;
    var toggleHeight = _this4._toggle.offsetHeight;
    var childHeight = _this4._child.offsetHeight;

    // Can;t fix if the child can't fit on the page based on the toggle's position

    if (toggleTop + toggleHeight + childHeight > window.innerHeight) {
      return false;
    }

    var _child$getBoundingCli = _this4._child.getBoundingClientRect(),
        top = _child$getBoundingCli.top;

    var newTop = _this4._initialTop;
    var addToTop = childHeight * (vp.top ? -1 : 1);
    if (y === VerticalAnchors.OVERLAP) {
      addToTop += (vp.top ? 1 : -1) * toggleHeight;
    } else if (y === VerticalAnchors.TOP || y === VerticalAnchors.BOTTOM) {
      addToTop += (_this4._lastYFix === 'top' ? -1 : 1) * toggleHeight;
    }

    if (addToTop !== 0) {
      newTop = top + addToTop;
      _this4._lastYFix = vp.top ? 'bottom' : 'top';
    }

    if (newTop !== _this4._initialTop) {
      _this4._initialTop = newTop;
      var fixedTo = _this4.props.fixedTo;

      var scrollEl = fixedTo;
      if (fixedTo !== window && (fixedTo.y || fixedTo.x)) {
        scrollEl = fixedTo.y || window;
      }

      _this4._initialY = getScroll(scrollEl).y;

      _this4.setState({ styles: _this4._mergeStyles({ top: _this4._initialTop }) }, function () {
        _this4._ticking = false;
      });
      return true;
    }

    return false;
  };

  this._handleContextMenu = function (e) {
    var anchor = _this4._getAnchor(_this4.props);
    var _props8 = _this4.props,
        onContextMenu = _props8.onContextMenu,
        preventContextMenu = _props8.preventContextMenu,
        fixedTo = _props8.fixedTo,
        sameWidth = _props8.sameWidth,
        centered = _props8.centered,
        visible = _props8.visible;

    if (!onContextMenu) {
      return;
    }

    _this4._contextRect = getSelectedTextPosition(e);
    if (preventContextMenu && (!_this4._child || !_this4._child.contains(e.target))) {
      e.preventDefault();
    }

    onContextMenu(e);
    if (visible) {
      _this4._init(fixedTo, anchor, sameWidth, centered, _this4._contextRect);
    }
  };
};

/**
 * The `Menu` controlled component is used to display a list of children in the `List`
 * component once the `visible` prop is true.
 */

var Menu = function (_PureComponent) {
  inherits(Menu, _PureComponent);

  function Menu() {
    var _ref;

    var _temp, _this, _ret;

    classCallCheck(this, Menu);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = possibleConstructorReturn(this, (_ref = Menu.__proto__ || Object.getPrototypeOf(Menu)).call.apply(_ref, [this].concat(args))), _this), _this._handleClose = function (e) {
      var _this$props = _this.props,
          close = _this$props.close,
          onClose = _this$props.onClose;

      if (close || onClose) {
        (close || onClose)(e);
      }
    }, _this._handleClick = function (e) {
      if (_this.props.onClick) {
        _this.props.onClick(e);
      }

      var node = e.target;
      while (_this._container && _this._container.contains(node)) {
        if (_this._isIgnoreTarget(node)) {
          return;
        } else if (_this._isCloseTarget(node)) {
          e.persist();
          // set a timeout so item click events still trigger, and then close
          _this._timeout = setTimeout(function () {
            _this._timeout = null;
            _this._handleClose(e);
          }, TICK);

          return;
        }

        node = node.parentNode;
      }
    }, _this._handleKeyDown = function (e) {
      if (_this.props.onKeyDown) {
        _this.props.onKeyDown(e);
      }

      handleKeyboardAccessibility(e, _this._handleClick, true, true);
    }, _temp), possibleConstructorReturn(_this, _ret);
  }

  createClass(Menu, [{
    key: 'getChildContext',
    value: function getChildContext() {
      var _props = this.props,
          cascading = _props.cascading,
          id = _props.id,
          fixedTo = _props.fixedTo,
          cascadingAnchor = _props.cascadingAnchor;

      var listLevel = this.context.listLevel || 0;
      var cascadingMenu = typeof cascading !== 'undefined' ? cascading : this.context.cascadingMenu;
      var cascadingZDepth = getField(this.context, this.props, 'cascadingZDepth');
      var cascadingFixedTo = typeof fixedTo !== 'undefined' ? fixedTo : this.context.cascadingFixedTo;

      return {
        listLevel: listLevel,
        cascadingId: id + '-level-' + (listLevel + 1),
        cascadingMenu: cascadingMenu,
        cascadingAnchor: cascadingAnchor,
        cascadingZDepth: cascadingZDepth,
        cascadingFixedTo: cascadingFixedTo
      };
    }
  }, {
    key: 'componentDidMount',
    value: function componentDidMount() {
      this._container = findDOMNode(this);
    }
  }, {
    key: 'componentWillUnmount',
    value: function componentWillUnmount() {
      if (this._timeout) {
        clearTimeout(this._timeout);
      }
    }
  }, {
    key: '_isCloseTarget',


    /**
     * Checks if a provided event target or HTML Element is considered a menu click target.
     * This normally is just a ListItem.
     */
    value: function _isCloseTarget(target) {
      return target.classList.contains('md-list-item') && !target.classList.contains('md-list-item--nested-container');
    }

    /**
     * Checks if a provided event target or HTML Element is something that should shortcut/break
     * out of the click event loop because it **should not** close menus when clicked.
     */

  }, {
    key: '_isIgnoreTarget',
    value: function _isIgnoreTarget(target) {
      return target.getAttribute('disabled') !== null || target.classList.contains('md-list-control');
    }
  }, {
    key: 'render',
    value: function render() {
      var _cn;

      var _props2 = this.props,
          id = _props2.id,
          className = _props2.className,
          listStyle = _props2.listStyle,
          listClassName = _props2.listClassName,
          visible = _props2.visible,
          children = _props2.children,
          listProps = _props2.listProps,
          listZDepth = _props2.listZDepth,
          listInline = _props2.listInline,
          listHeightRestricted = _props2.listHeightRestricted,
          cascading = _props2.cascading,
          sameWidth = _props2.sameWidth,
          simplified = _props2.simplified,
          contained = _props2.contained,
          isOpen = _props2.isOpen,
          propFixedTo = _props2.fixedTo,
          propListId = _props2.listId,
          cascadingAnchor = _props2.cascadingAnchor,
          cascadingZDepth = _props2.cascadingZDepth,
          onClose = _props2.onClose,
          propPosition = _props2.position,
          close = _props2.close,
          autoclose = _props2.autoclose,
          limitHeight = _props2.limitHeight,
          expanderIconChildren = _props2.expanderIconChildren,
          expanderIconClassName = _props2.expanderIconClassName,
          props = objectWithoutProperties(_props2, ['id', 'className', 'listStyle', 'listClassName', 'visible', 'children', 'listProps', 'listZDepth', 'listInline', 'listHeightRestricted', 'cascading', 'sameWidth', 'simplified', 'contained', 'isOpen', 'fixedTo', 'listId', 'cascadingAnchor', 'cascadingZDepth', 'onClose', 'position', 'close', 'autoclose', 'limitHeight', 'expanderIconChildren', 'expanderIconClassName']);
      var _props3 = this.props,
          listId = _props3.listId,
          position = _props3.position;

      if (!listId) {
        listId = id + '-list';
      }

      // can't have a simplified menu for cascading and context menus
      var simple = !cascading && !props.onContextMenu && position !== 'context' && simplified;
      if (position === 'context') {
        position = Menu.Positions.BELOW;
      }

      var below = position === Menu.Positions.BELOW;
      var fixedTo = typeof propFixedTo !== 'undefined' ? propFixedTo : this.context.cascadingFixedTo;
      var listVisible = typeof isOpen !== 'undefined' ? isOpen : visible;
      return React.createElement(
        Layover,
        _extends({}, props, {
          id: id,
          className: classnames('md-menu-container', {
            'md-menu-container--menu-below': simplified && below
          }, className),
          simplified: simple,
          sameWidth: contained || sameWidth,
          fixedTo: fixedTo,
          onClick: this._handleClick,
          onKeyDown: this._handleKeyDown,
          onClose: this._handleClose,
          animationPosition: position,
          visible: listVisible,
          'aria-haspopup': true,
          'aria-expanded': listVisible,
          'aria-owns': listId
        }),
        React.createElement(
          List,
          _extends({}, listProps, {
            id: listId,
            key: 'menu-list',
            style: listStyle,
            className: classnames('md-list--menu', (_cn = {
              'md-list--menu-restricted': listHeightRestricted,
              'md-list--menu-contained': simplified && (sameWidth || contained)
            }, defineProperty(_cn, 'md-list--menu-' + position, simplified), defineProperty(_cn, 'md-paper md-paper--' + listZDepth, listZDepth), _cn), listClassName),
            inline: listInline
          }),
          children
        )
      );
    }
  }]);
  return Menu;
}(PureComponent);

Menu.HorizontalAnchors = Layover.HorizontalAnchors;
Menu.VerticalAnchors = Layover.VerticalAnchors;
Menu.Positions = {
  // Can't do ...Layover.Positions since it triggers the get for CONTEXT
  TOP_LEFT: Layover.Positions.TOP_LEFT,
  TOP_RIGHT: Layover.Positions.TOP_RIGHT,
  BOTTOM_LEFT: Layover.Positions.BOTTOM_LEFT,
  BOTTOM_RIGHT: Layover.Positions.BOTTOM_RIGHT,
  BELOW: Layover.Positions.BELOW,
  _warned: false,
  get CONTEXT() {
    if (!this._warned) {
      /* eslint-disable no-console */
      console.error('The `Menu.Positions.CONTEXT` position has been deprecated and will be removed ' + 'in the next major release. To make the `Menu` behave as a context menu, provide ' + 'the `onContextMenu` prop instead.');
      /* eslint-enable no-console */
    }

    this._warned = true;
    return 'context';
  }
};
Menu.propTypes = {
  /**
   * An id to provide to the menu's container. This is required for accessibility as it generates
   * the `aria-` attributes for dynamic content.
   *
   * @see {@link #listId}
   */
  id: isRequiredForA11y(propTypes.oneOfType([propTypes.number, propTypes.string])),

  /**
   * An optional id to provide to the menu's list. If this prop is omitted, the list's id will be
   * `\`${id}-list\``
   */
  listId: propTypes.oneOfType([propTypes.number, propTypes.string]),

  /**
   * An optional style to apply to the main container for the menu.
   */
  style: propTypes.object,

  /**
   * An optional class name to apply to the main container for the menu.
   */
  className: propTypes.string,

  /**
   * An optional style to apply to the list once the menu has opened.
   */
  listStyle: propTypes.object,

  /**
   * An optional class name to apply to the list once the menu has opened.
   */
  listClassName: propTypes.string,

  /**
   * The component to render the main container as.
   *
   * @see {@link Helpers/Layover#component}
   */
  component: propTypes.oneOfType([propTypes.string, propTypes.func]),

  /**
   * This is how the menu's `List` gets anchored to the `toggle` element.
   *
   * @see {@link Helpers/Layover#anchor}
   */
  anchor: anchorShape,

  /**
   * This is the optional anchor to use when the `position` is set to `Menu.Positions.BELOW`.
   * Set this to `null` to use the default `anchor` prop.
   *
   * @see {@link Helpers/Layover#belowAnchor}
   */
  belowAnchor: anchorShape,

  /**
   * This is the animation position for the list that appears.
   *
   * @see {@link Helpers/Layover#animationPosition}
   */
  position: positionShape,

  /**
   * This is the component/element that should toggle the menu open.
   *
   * @see {@link Helpers/Layover#toggle}
   */
  toggle: propTypes.node,

  /**
   * This is how the menu's list will be "fixed" to the `toggle` component.
   *
   * @see {@link Helpers/Layover#fixedTo}
   */
  fixedTo: fixedToShape,

  /**
   * Any additional props that should be applied to the list in the menu. This is really used
   * when additional `aria-` tags need to be applied.
   */
  listProps: propTypes.object,

  /**
   * Boolean if the menu's list should appear horizontally instead of vertically.
   */
  listInline: propTypes.bool,

  /**
   * The list's z-depth for applying box shadow. This should be a number from 0 to 5.
   */
  listZDepth: propTypes.number.isRequired,

  /**
   * Boolean if the list should have its height restricted to the `$md-menu-mobile-max-height`/
   * `$md-menu-desktop-max-height` values.
   *
   * @see [md-menu-mobile-max-height](/components/menus?tab=2#variable-md-menu-mobile-max-height)
   * @see [md-menu-desktop-max-height](/components/menus?tab=2#variable-md-menu-desktop-max-height)
   */
  listHeightRestricted: propTypes.bool,

  /**
   * Boolean if the menu's list is visible.
   */
  visible: propTypes.bool.isRequired,

  /**
   * Any children to render in the menu's list. This _should_ normally be `ListItem`, or
   * `ListItemControl`.
   */
  children: propTypes.node,

  /**
   * An optional function to call when en element in the menu has been clicked.
   */
  onClick: propTypes.func,

  /**
   * An optional function to call when a key is pressed anywhere in the menu.
   */
  onKeyDown: propTypes.func,

  /**
   * A function to call to close the menu. This is used for closing on outside clicks,
   * closing when a list item has been clicked, or the user presses escape.
   */
  onClose: propTypes.func.isRequired,

  /**
   * Boolean if the menu should be cascading. This means that the menu will pop the additional
   * `nestedItems` on any `ListItem` to be appear either to the right or left of the visible list.
   */
  cascading: propTypes.bool,

  /**
   * This is how the cascading lists get anchored to the list item.
   *
   * @see {@link Helpers/Layover#anchor}
   */
  cascadingAnchor: Layover.propTypes.anchor,

  /**
   * This is the z-depth the list should gain for a cascading menu. This only gets applied on
   * items that are more than 1 level deep.
   */
  cascadingZDepth: propTypes.number.isRequired,

  /**
   * Boolean if the `md-full-width` class name should get applied to the menu's container.
   */
  fullWidth: propTypes.bool,

  /**
   * Boolean if the menu should be displayed as a block instead of as an inline block.
   *
   * @see {@link #fullWidth}
   */
  block: propTypes.bool,

  /**
   * @see {@link Helpers/Layover#centered}
   */
  centered: Layover.propTypes.centered,

  /**
   * @see {@link Helpers/Layover#sameWidth}
   */
  sameWidth: Layover.propTypes.sameWidth,

  /**
   * If you would like the menu to interact as a context menu, provide this prop.
   *
   * @see {@link Helpers/Layover#onContextMenu}
   */
  onContextMenu: Layover.propTypes.onContextMenu,

  /**
   * Boolean if the default behavior of the context menu should be prevented when using the
   * `onContextMenu` prop.
   *
   * @see {@link Helpers/Layover#preventContextMenu}
   */
  preventContextMenu: Layover.propTypes.preventContextMenu,

  /**
   * @see {@link Helpers/Layover#xThreshold}
   */
  xThreshold: propTypes.number,

  /**
   * @see {@link Helpers/Layover#yThreshold}
   */
  yThreshold: propTypes.number,

  /**
   * @see {@link Helpers/Layover#closeOnOutsideClick}
   */
  closeOnOutsideClick: propTypes.bool,

  /**
   * @see {@link Helpers/Layover#toggleQuery}
   */
  toggleQuery: propTypes.oneOfType([propTypes.func, propTypes.object, propTypes.string]),

  /**
   * An optional transition name to use for the list appearing/disappearing.
   *
   * @see {@link Helpers/Layover#transitionName}
   */
  transitionName: propTypes.string,

  /**
   * @see {@link Helpers/Layover#transitionEnterTimeout}
   */
  transitionEnterTimeout: propTypes.number,

  /**
   * @see {@link Helpers/Layover#transitionLeaveTimeout}
   */
  transitionLeaveTimeout: propTypes.number,

  /**
   * Boolean if the menu should automatically try to reposition itself to stay within
   * the viewport when the `fixedTo` element scrolls.
   *
   * @see {@link Helpers/Layover#repositionOnScroll}
   */
  repositionOnScroll: propTypes.bool,

  /**
   * Boolean if the menu should automatically try to reposition itself to stay within
   * the viewport when the window resizes.
   *
   * @see {@link Helpers/Layover#repositionOnResize}
   */
  repositionOnResize: propTypes.bool,

  /**
   * @see {@link Helpers/Layover#simplified}
   */
  simplified: propTypes.bool,

  /**
   * @see {@link Helpers/Layover#minLeft}
   */
  minLeft: propTypes.oneOfType([propTypes.number, propTypes.string]),

  /**
   * @see {@link Helpers/Layover#minRight}
   */
  minRight: propTypes.oneOfType([propTypes.number, propTypes.string]),

  /**
   * @see {@link Helpers/Layover#minBottom}
   */
  minBottom: propTypes.oneOfType([propTypes.number, propTypes.string]),

  /**
   * @see {@link Helpers/Layover#fillViewportWidth}
   */
  fillViewportWidth: propTypes.bool,

  /**
   * @see {@link Helpers/Layover#fillViewportHeight}
   */
  fillViewportHeight: propTypes.bool,

  isOpen: deprecated(propTypes.bool, 'Use `visible` instead'),
  close: deprecated(propTypes.func, 'Use `onClose` instead'),
  autoclose: deprecated(propTypes.bool, 'The menus will always autoclose as according to the specs'),
  contained: deprecated(propTypes.bool, 'Use `sameWidth` instead'),
  limitHeight: deprecated(propTypes.bool, 'The menus will always be limited in height as according to the specs'),
  expanderIconClassName: deprecated(propTypes.node, 'The expander for cascading menus will now just be a simple rotate of the existing `ListItem` ' + 'expander icon'),
  expanderIconChildren: deprecated(propTypes.node, 'The expander for cascading menus will now just be a simple rotate of the existing `ListItem` ' + 'expander icon')
};
Menu.defaultProps = {
  anchor: {
    x: Layover.HorizontalAnchors.INNER_RIGHT,
    y: Layover.VerticalAnchors.OVERLAP
  },
  cascadingAnchor: {
    x: Layover.HorizontalAnchors.RIGHT,
    y: Layover.VerticalAnchors.OVERLAP
  },
  position: Layover.Positions.TOP_RIGHT,
  fixedTo: typeof window !== 'undefined' ? window : {},
  listZDepth: 2,
  listHeightRestricted: true,
  cascadingZDepth: 3,
  repositionOnScroll: true,
  repositionOnResize: false,
  simplified: true
};
Menu.contextTypes = {
  listLevel: propTypes.number,
  cascadingId: propTypes.oneOfType([propTypes.string, propTypes.number]),
  cascadingMenu: propTypes.bool,
  cascadingAnchor: anchorShape,
  cascadingZDepth: propTypes.number
};
Menu.childContextTypes = {
  listLevel: propTypes.number,
  cascadingId: propTypes.oneOfType([propTypes.string, propTypes.number]),
  cascadingMenu: propTypes.bool,
  cascadingFixedTo: fixedToShape,
  cascadingAnchor: anchorShape,
  cascadingZDepth: propTypes.number
};

/**
 * The `ListItem` component is used for rendering a `li` tag with text and optional
 * icons/avatars.
 */

var ListItem = function (_PureComponent) {
  inherits(ListItem, _PureComponent);

  function ListItem(props) {
    classCallCheck(this, ListItem);

    var _this = possibleConstructorReturn(this, (ListItem.__proto__ || Object.getPrototypeOf(ListItem)).call(this, props));

    _initialiseProps$1.call(_this);

    _this.state = { active: false };

    if (typeof props.isOpen === 'undefined' && typeof props.visible === 'undefined') {
      var defined = function defined(v) {
        return typeof v !== 'undefined';
      };
      var _this$props = _this.props,
          initiallyOpen = _this$props.initiallyOpen,
          defaultOpen = _this$props.defaultOpen,
          defaultVisible = _this$props.defaultVisible;

      var visible = defined(initiallyOpen) ? initiallyOpen : defaultVisible;
      visible = defined(defaultOpen) ? defaultOpen : visible;
      visible = !!visible;

      _this.state.visible = visible;
    }
    return _this;
  }

  createClass(ListItem, [{
    key: 'componentWillUnmount',
    value: function componentWillUnmount() {
      if (this.state.active) {
        window.removeEventListener('click', this._handleOutsideClick);
      }

      if (this._touchTimeout) {
        clearTimeout(this._touchTimeout);
      }
    }

    /**
     * A utility function to focus the `AccessibleFakeInkedButton` in the `ListItem` and also
     * inject an ink to indicate focus.
     */


    /**
     * A utility function to blur the `AccessibleFakeInkedButton` in the `ListItem`.
     */

  }, {
    key: 'render',
    value: function render() {
      var _props = this.props,
          style = _props.style,
          className = _props.className,
          tileStyle = _props.tileStyle,
          tileClassName = _props.tileClassName,
          contentStyle = _props.contentStyle,
          contentClassName = _props.contentClassName,
          leftNodeStyle = _props.leftNodeStyle,
          leftNodeClassName = _props.leftNodeClassName,
          rightNodeStyle = _props.rightNodeStyle,
          rightNodeClassName = _props.rightNodeClassName,
          primaryTextStyle = _props.primaryTextStyle,
          primaryTextClassName = _props.primaryTextClassName,
          secondaryTextStyle = _props.secondaryTextStyle,
          secondaryTextClassName = _props.secondaryTextClassName,
          nestedListStyle = _props.nestedListStyle,
          nestedListClassName = _props.nestedListClassName,
          nestedListHeightRestricted = _props.nestedListHeightRestricted,
          disabled = _props.disabled,
          leftIcon = _props.leftIcon,
          leftAvatar = _props.leftAvatar,
          inset = _props.inset,
          rightIcon = _props.rightIcon,
          rightAvatar = _props.rightAvatar,
          primaryText = _props.primaryText,
          secondaryText = _props.secondaryText,
          threeLines = _props.threeLines,
          children = _props.children,
          nestedItems = _props.nestedItems,
          prependNested = _props.prependNested,
          active = _props.active,
          activeClassName = _props.activeClassName,
          activeBoxStyle = _props.activeBoxStyle,
          activeBoxClassName = _props.activeBoxClassName,
          animateNestedItems = _props.animateNestedItems,
          expanderIcon = _props.expanderIcon,
          expanderLeft = _props.expanderLeft,
          component = _props.component,
          ItemComponent = _props.itemComponent,
          itemProps = _props.itemProps,
          tileProps = _props.tileProps,
          passPropsToItem = _props.passPropsToItem,
          ariaSize = _props['aria-setsize'],
          ariaPos = _props['aria-posinset'],
          isOpen = _props.isOpen,
          expanderIconChildren = _props.expanderIconChildren,
          expanderIconClassName = _props.expanderIconClassName,
          propVisible = _props.visible,
          defaultVisible = _props.defaultVisible,
          itemRef = _props.itemRef,
          defaultOpen = _props.defaultOpen,
          initiallyOpen = _props.initiallyOpen,
          props = objectWithoutProperties(_props, ['style', 'className', 'tileStyle', 'tileClassName', 'contentStyle', 'contentClassName', 'leftNodeStyle', 'leftNodeClassName', 'rightNodeStyle', 'rightNodeClassName', 'primaryTextStyle', 'primaryTextClassName', 'secondaryTextStyle', 'secondaryTextClassName', 'nestedListStyle', 'nestedListClassName', 'nestedListHeightRestricted', 'disabled', 'leftIcon', 'leftAvatar', 'inset', 'rightIcon', 'rightAvatar', 'primaryText', 'secondaryText', 'threeLines', 'children', 'nestedItems', 'prependNested', 'active', 'activeClassName', 'activeBoxStyle', 'activeBoxClassName', 'animateNestedItems', 'expanderIcon', 'expanderLeft', 'component', 'itemComponent', 'itemProps', 'tileProps', 'passPropsToItem', 'aria-setsize', 'aria-posinset', 'isOpen', 'expanderIconChildren', 'expanderIconClassName', 'visible', 'defaultVisible', 'itemRef', 'defaultOpen', 'initiallyOpen']);
      var _context = this.context,
          cascadingId = _context.cascadingId,
          cascadingMenu = _context.cascadingMenu,
          cascadingAnchor = _context.cascadingAnchor,
          cascadingFixedTo = _context.cascadingFixedTo;

      var visible = getField(this.props, this.state, 'visible');
      if (typeof isOpen !== 'undefined') {
        visible = isOpen;
      }

      var leftNode = React.createElement(TileAddon, {
        key: 'left-addon',
        style: leftNodeStyle,
        className: leftNodeClassName,
        active: active,
        activeClassName: activeClassName,
        icon: leftIcon,
        avatar: leftAvatar
      });

      var rightNode = React.createElement(TileAddon, {
        key: 'right-addon',
        style: rightNodeStyle,
        className: rightNodeClassName,
        active: active,
        activeClassName: activeClassName,
        icon: rightIcon,
        avatar: rightAvatar
      });

      var nestedList = void 0;
      if (nestedItems) {
        if (!cascadingMenu) {
          nestedList = React.createElement(
            Collapse,
            { collapsed: !visible, animate: animateNestedItems },
            React.createElement(
              List,
              { style: nestedListStyle, className: nestedListClassName },
              nestedItems
            )
          );
        }

        var icon = React.Children.only(getDeprecatedIcon(expanderIconClassName, expanderIconChildren, expanderIcon));
        var collapser = React.createElement(TileAddon, {
          key: 'expander-addon',
          icon: React.cloneElement(icon, {
            className: getCollapserStyles({ flipped: visible }, icon.props.className)
          }),
          avatar: null
        });

        if (expanderLeft) {
          if (!leftIcon && !leftAvatar) {
            leftNode = collapser;
          }
        } else if (!rightIcon && !rightAvatar) {
          rightNode = collapser;
        }
      }

      var icond = !!leftIcon || !!rightIcon || !!nestedItems;
      var avatard = !!leftAvatar || !!rightAvatar;

      var tile = React.createElement(
        AccessibleFakeInkedButton,
        _extends({}, tileProps, passPropsToItem ? undefined : props, {
          component: component,
          __SUPER_SECRET_REF__: this._setTile,
          key: 'tile',
          onClick: this._handleClick,
          onMouseOver: this._handleMouseOver,
          onMouseLeave: this._handleMouseLeave,
          onTouchStart: this._handleTouchStart,
          onTouchEnd: this._handleTouchEnd,
          onKeyDown: this._handleKeyDown,
          onKeyUp: this._handleKeyUp,
          disabled: disabled,
          style: tileStyle,
          className: classnames('md-list-tile', {
            'md-list-tile--active': this.state.active && !this._touched,
            'md-list-tile--icon': !secondaryText && icond && !avatard,
            'md-list-tile--avatar': !secondaryText && avatard,
            'md-list-tile--two-lines': secondaryText && !threeLines,
            'md-list-tile--three-lines': secondaryText && threeLines,
            'md-list-item--inset': inset && !leftIcon && !leftAvatar
          }, themeColors({ disabled: disabled, text: true }), tileClassName),
          'aria-expanded': nestedList && !cascadingMenu ? visible : null
        }),
        leftNode,
        React.createElement(ListItemText, {
          active: active,
          activeClassName: activeClassName,
          disabled: disabled,
          primaryText: primaryText,
          secondaryText: secondaryText,
          threeLines: threeLines,
          style: contentStyle,
          className: classnames({
            'md-tile-content--left-icon': leftIcon || expanderLeft && nestedItems,
            'md-tile-content--left-avatar': leftAvatar,
            'md-tile-content--right-padding': rightIcon || rightAvatar
          }, contentClassName),
          primaryTextStyle: primaryTextStyle,
          primaryTextClassName: primaryTextClassName,
          secondaryTextStyle: secondaryTextStyle,
          secondaryTextClassName: secondaryTextClassName
        }),
        rightNode,
        children
      );

      var sharedProps = _extends({}, itemProps, passPropsToItem ? props : undefined, {
        style: Object.assign({}, style, active ? activeBoxStyle : null),
        className: classnames('md-list-item', defineProperty({
          'md-list-item--nested-container': nestedItems
        }, activeBoxClassName, activeBoxClassName && active), className),
        'aria-setsize': ariaSize,
        'aria-posinset': ariaPos,
        ref: this._setContainer
      });
      if (cascadingMenu && nestedItems) {
        return React.createElement(
          Menu,
          _extends({
            id: cascadingId,
            visible: visible,
            onClose: this._handleClick,
            toggle: tile,
            block: true,
            simplified: false,
            anchor: cascadingAnchor,
            belowAnchor: null,
            position: Menu.Positions.BELOW,
            component: ItemComponent,
            listStyle: nestedListStyle,
            listClassName: nestedListClassName,
            listHeightRestricted: nestedListHeightRestricted
          }, sharedProps, {
            fixedTo: cascadingFixedTo
          }),
          nestedItems
        );
      }

      return React.createElement(
        ItemComponent,
        sharedProps,
        prependNested ? nestedList : null,
        tile,
        prependNested ? null : nestedList
      );
    }
  }]);
  return ListItem;
}(PureComponent);

ListItem.propTypes = {
  /**
   * An optional style to apply to the `li` tag.
   */
  style: propTypes.object,

  /**
   * An optional className to apply to the `li` tag.
   */
  className: propTypes.string,

  /**
   * An optional style to apply to the `.md-list-tile`.
   *
   * @see {@link #component}
   */
  tileStyle: propTypes.object,

  /**
   * An optional className to apply to the `.md-list-tile`.
   *
   * @see {@link #component}
   */
  tileClassName: propTypes.string,

  /**
   * An optional style to apply to the div that surrounds the `primaryText` and `secondaryText`
   * nodes.
   */
  contentStyle: propTypes.object,

  /**
   * An optional className to apply to the div that surrounds the `primaryText` and `secondaryText`
   * nodes.
   */
  contentClassName: propTypes.string,

  /**
   * An optional style to apply to the element that is rendered before content node.
   */
  leftNodeStyle: propTypes.object,

  /**
   * An optional className to apply to the element that is rendered before content node.
   */
  leftNodeClassName: propTypes.string,

  /**
   * An optional style to apply to the element that is rendered after content node.
   */
  rightNodeStyle: propTypes.object,

  /**
   * An optional className to apply to the element that is rendered after content node.
   */
  rightNodeClassName: propTypes.string,

  /**
   * An optional style to apply to the div surrounding the `primaryText`.
   */
  primaryTextStyle: propTypes.object,

  /**
   * An optional className to apply to the div surrounding the `primaryText`.
   */
  primaryTextClassName: propTypes.string,

  /**
   * An optional style to apply to the div surrounding the `secondaryText`.
   */
  secondaryTextStyle: propTypes.object,

  /**
   * An optional className to apply to the div surrounding the `secondaryText`.
   */
  secondaryTextClassName: propTypes.string,

  /**
   * An optional style to apply to the nested `List` that gets created when using `nestedItems`.
   */
  nestedListStyle: propTypes.object,

  /**
   * An optional className to apply to the nested `List` that gets created when using `nestedItems`.
   */
  nestedListClassName: propTypes.string,

  /**
   * Boolean if the nested `List` in a cascading menu should be restricted.
   */
  nestedListHeightRestricted: propTypes.bool,

  /**
   * Any additional children to display in the `.md-list-tile`. If you use this prop,
   * you will most likely need to override the `height` for the `.md-list-tile--icon`,
   * `.md-list-tile--avatar`, `.md-list-tile--two-lines`, and/or `.md-list-tile--three-lines`
   * to get it to display correctly unless the children are positioned `absolute`.
   */
  children: propTypes.node,

  /**
   * Boolean if the `ListItem` is disabled.
   */
  disabled: propTypes.bool,

  /**
   * An optional tab index for the `.md-list-tile`. If omitted, it will default to the
   * `AccessibleFakeButton`'s `tabIndex` default prop value.
   */
  tabIndex: propTypes.number,

  /**
   * The primary text to display. This will only be rendered as a single line. Any overflown
   * text will be converted to ellipsis.
   */
  primaryText: propTypes.node.isRequired,

  /**
   * An optional secondary text to display below the `primaryText`. This can be an additional
   * one or two lines. Like the `primaryText`, and overflown text will be converted to ellipsis.
   *
   * You must set the `threeLines` prop to `true` if you want this to be displayed as two lines.
   */
  secondaryText: propTypes.node,

  /**
   * An optional `FontIcon` to display to the left of the text.
   */
  leftIcon: propTypes.node,

  /**
   * An optional `Avatar` to display to the left of the text. If you have a mixed `List` of
   * `FontIcon` and `Avatar`, it is recommended to set the `iconSized` prop on the `Avatar` to
   * `true` so that the `Avatar` will be scaled down to the `FontIcon` size.
   */
  leftAvatar: propTypes.node,

  /**
   * An optional `FontIcon` to display to the right of the text.
   */
  rightIcon: propTypes.node,

  /**
   * An optional `Avatar` to display to the right of the text. If you have a mixed `List` of
   * `FontIcon` and `Avatar`, it is recommended to set the `iconSized` prop on the `Avatar` to
   * `true` so that the `Avatar` will be scaled down to the `FontIcon` size.
   */
  rightAvatar: propTypes.node,

  /**
   * Boolean if the list item should be inset as if there is a `leftIcon` or a `leftAvatar`.
   * This is used for some lists where only a parent contains the icon.
   */
  inset: propTypes.bool,

  /**
   * Boolean if the `secondaryText` should span two lines instead of one. This will include
   * three lines of text in total when including the `primaryText`.
   */
  threeLines: propTypes.bool,

  /**
   * The component to render the `.md-list-tile` as. This is mostly useful if you
   * want to use the `ListItem` for navigation and working with the `react-router`'s `Link`
   * component.
   *
   * This prop is **not** the top-most element of the `ListItem` component. To change the
   * top-most element, see the `itemComponent` prop.
   *
   * @see {@link #itemComponent}
   */
  component: propTypes.oneOfType([propTypes.string, propTypes.func]).isRequired,

  /**
   * The component to render the top-most element of the `ListItem` component. This is the
   * `.md-list-item` and defaults to the `<li>` element.
   *
   * @see {@link #component}
   * @see {@link #itemProps}
   */
  itemComponent: propTypes.oneOfType([propTypes.string, propTypes.func]).isRequired,

  /**
   * An optional ref callback to get reference to the top-most element of the `ListItem` component.
   * Just like other refs, this will provide null when it unmounts.
   */
  itemRef: propTypes.func,

  /**
   * An optional list of `ListItem`, `ListItemControl`, `Divider`, or `Subheader` components
   * to render in a nested list. This will inject an expander icon to the right of the text
   * in the `.md-list-tile` that rotates 180 degrees when open.
   *
   * The nested items will be visible once the user clicks on the `ListItem`.
   *
   * @see {@link #visible}
   */
  nestedItems: propTypes.arrayOf(propTypes.node),

  /**
   * An optional parameter determining whether `nestedItems` should be placed before or after `ListItemText`
   */
  prependNested: propTypes.bool,

  /**
   * Boolean if the `nestedItems` are visible by default.
   */
  defaultVisible: propTypes.bool,

  /**
   * Boolean if the `nestedItems` are visible. This will make the `nestedItems` controlled
   * and require the `onClick` function to be defined.
   *
   * @see {@link #defaultVisible}
   */
  visible: controlled(propTypes.bool, 'onClick', 'defaultVisible'),

  /**
   * An icon to use for the expander icon when there are nested items.
   */
  expanderIcon: propTypes.element,

  /**
   * Boolean if the expander icon should appear as the left icon instead of the right.
   */
  expanderLeft: propTypes.bool,

  /**
   * An optional function to call when the `.md-list-tile` is clicked. This is required if the
   * `visible` prop is defined.
   */
  onClick: propTypes.func,

  /**
   * An optional function to call when the `.md-list-tile` triggers the `mouseover` event.
   */
  onMouseOver: propTypes.func,

  /**
   * An optional function to call when the `.md-list-tile` triggers the `mouseleave` event.
   */
  onMouseLeave: propTypes.func,

  /**
   * An optional function to call when the `.md-list-tile` triggers the `touchstart` event.
   */
  onTouchStart: propTypes.func,

  /**
   * An optional function to call when the `.md-list-tile` triggers the `touchend` event.
   */
  onTouchEnd: propTypes.func,

  /**
   * An optional function to call when the `.md-list-tile` triggers the `keydown` event.
   */
  onKeyDown: propTypes.func,

  /**
   * An optional function to call when the `.md-list-tile` triggers the `keyup` event.
   */
  onKeyUp: propTypes.func,

  /**
   * Boolean if the `ListItem` is currently active. This will apply the `activeClassName` prop
   * to the `leftIcon`, `rightIcon`, and the `primaryText`.
   */
  active: propTypes.bool,

  /**
   * The className to apply to the `leftIcon`, `rightIcon`, and `primaryText` when the `active`
   * prop is `true`.
   */
  activeClassName: propTypes.string,

  /**
   * An optional style to apply to the top-most element of the `ListItem` component (`.md-list-item`)
   * when the `active` prop is `true`.
   */
  activeBoxStyle: propTypes.object,

  /**
   * The className to apply to the top-most element of the `ListItem` component (`.md-list-item`)
   * when the `active` prop is `true`.
   */
  activeBoxClassName: propTypes.string,

  /**
   * Boolean if the nested items should animate when they appear or disappear.
   */
  animateNestedItems: propTypes.bool,

  /**
   * Defines the number of items in the list. This is only required when all items in the
   * list are not present in the DOM.
   *
   * @see https://www.w3.org/TR/wai-aria/states_and_properties#aria-setsize
   */
  'aria-setsize': propTypes.number,

  /**
   * Defines the items position in the list. This is only required when all items in the list
   * are not present in the DOM. The custom validation just requires this prop if the `aria-setsize`
   * prop is defined as a helpful reminder.
   *
   * @see https://www.w3.org/TR/wai-aria/states_and_properties#aria-posinset
   */
  'aria-posinset': function ariaPosinset(props, propName) {
    for (var _len = arguments.length, args = Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
      args[_key - 2] = arguments[_key];
    }

    var validator = propTypes.number;
    if (typeof props['aria-setsize'] !== 'undefined') {
      validator = validator.isRequired;
    }

    return validator.apply(undefined, [props, propName].concat(args));
  },

  /**
   * Any additional props you would like to supply to the surrounding `<li>` tag for the `ListItem`.
   * By default, all props will be provided to the inner `AccessibleFakeButton`. If the `passPropsToItem`
   * prop is enabled, the remaining props will be provided to the `<li>` tag instead and this prop
   * is probably useless.
   */
  itemProps: propTypes.object,

  /**
   * Any additional props you would like to add to the inner `AccessibleFakeButton`. By default, all the
   * remaining props will be provided to the `AccessibleFakeButton`, so this prop is probably useless.
   * Enabling the `passPropsToItem` prop will change the default behavior so that the remaining props
   * are provided to the surrounding `<li>` node instead and this prop becomes useful.
   */
  tileProps: propTypes.object,

  /**
   * All the remaining props should be passed to the surrounding `<li>` node instead of the `AccessibleFakeButton`.
   *
   * > NOTE: This will most likely become the default in the next *major* release. Migration warnings will be added
   * if that is the case.
   */
  passPropsToItem: propTypes.bool,
  expanderIconChildren: deprecated(propTypes.node, 'Use `expanderIcon` instead'),
  expanderIconClassName: deprecated(propTypes.string, 'Use `expanderIcon` instead'),
  initiallyOpen: deprecated(propTypes.bool, 'Use `defaultVisible` instead'),
  defaultOpen: deprecated(propTypes.bool, 'Use `defaultVisible` instead'),
  isOpen: deprecated(propTypes.bool, 'Use `visible` instead')
};
ListItem.defaultProps = {
  animateNestedItems: true,
  activeClassName: 'md-text--theme-primary',
  component: 'div',
  itemComponent: 'li',
  expanderIcon: React.createElement(
    FontIcon,
    null,
    'keyboard_arrow_down'
  )
};
ListItem.contextTypes = {
  cascadingId: propTypes.oneOfType([propTypes.number, propTypes.string]),
  cascadingMenu: propTypes.bool,
  cascadingAnchor: anchorShape,
  cascadingFixedTo: fixedToShape
};

var _initialiseProps$1 = function _initialiseProps() {
  var _this2 = this;

  this.focus = function () {
    if (_this2._tile) {
      _this2._tile.focus();
    }
  };

  this.blur = function () {
    if (_this2._tile) {
      _this2._tile.blur();
    }
  };

  this._setTile = function (tile) {
    if (tile) {
      _this2._tile = tile;
      _this2._tileNode = findDOMNode(tile);
    }
  };

  this._setContainer = function (container) {
    var itemRef = _this2.props.itemRef;

    if (container) {
      _this2._container = findDOMNode(container);
    }
    if (itemRef) {
      itemRef(container ? _this2._container : null);
    }
  };

  this._handleOutsideClick = function (e) {
    if (_this2._container && !_this2._container.contains(e.target)) {
      window.removeEventListener('click', _this2._handleOutsideClick);
      _this2.setState({ active: false });
    }
  };

  this._handleClick = function (e) {
    if (_this2.props.onClick) {
      _this2.props.onClick(e);
    }

    if (typeof _this2.state.visible !== 'undefined') {
      _this2.setState({ visible: !_this2.state.visible });
    }
  };

  this._handleMouseOver = function (e) {
    if (_this2.props.onMouseOver) {
      _this2.props.onMouseOver(e);
    }

    if (!_this2.props.disabled) {
      _this2.setState({ active: true });
    }
  };

  this._handleMouseLeave = function (e) {
    if (_this2.props.onMouseLeave) {
      _this2.props.onMouseLeave(e);
    }

    if (!_this2.props.disabled) {
      _this2.setState({ active: false });
    }
  };

  this._handleTouchStart = function (e) {
    if (_this2.props.onTouchStart) {
      _this2.props.onTouchStart(e);
    }

    _this2._touched = true;

    _this2.setState({ active: true, touchedAt: Date.now() });
  };

  this._handleTouchEnd = function (e) {
    if (_this2.props.onTouchEnd) {
      _this2.props.onTouchEnd(e);
    }

    var time = Date.now() - _this2.state.touchedAt;
    _this2._touchTimeout = setTimeout(function () {
      _this2._touchTimeout = null;

      _this2.setState({ active: false });
    }, time > 450 ? 0 : 450 - time);
  };

  this._handleKeyUp = function (e) {
    if (_this2.props.onKeyUp) {
      _this2.props.onKeyUp(e);
    }

    if ((e.which || e.keyCode) === TAB) {
      window.addEventListener('click', _this2._handleOutsideClick);
      _this2.setState({ active: true });
    }
  };

  this._handleKeyDown = function (e) {
    if (_this2.props.onKeyDown) {
      _this2.props.onKeyDown(e);
    }

    if ((e.which || e.keyCode) === TAB) {
      window.removeEventListener('click', _this2._handleOutsideClick);
      _this2.setState({ active: false });
    }
  };
};

/** @module utils/isValied */

/**
 * A really simple utility function to check if an input's value is considered "valued".
 *
 * @param {string|number} v - the value to check
 * @return {boolean} true if the value is a number or a non-empty string.
 */
function isValued(v) {
  return v === 0 || !!v;
}

/** @module utils/PropTypes/minNumber */
/**
 * Validates the a prop's value is greater than or equal to the minimum value.
 *
 * @param {Number} min - the minimum value for the prop.
 * @param {Boolean} required - Boolean if the prop is required.
 * @return {Error} an error or null.
 */
function minNumber(min, required) {
  return function validate(props, propName, componentName, location, propFullName) {
    var componentNameSafe = componentName || '<<anonymous>>';
    var propFullNameSafe = propFullName || propName;

    var validator = propTypes.number;
    if (required) {
      validator = validator.isRequired;
    }

    for (var _len = arguments.length, args = Array(_len > 5 ? _len - 5 : 0), _key = 5; _key < _len; _key++) {
      args[_key - 5] = arguments[_key];
    }

    var err = validator.apply(undefined, [props, propName, componentName, location, propFullName].concat(args));
    if (!required && !err && props[propName] < min) {
      err = new Error('The ' + location + ' `' + propFullNameSafe + '` must be greater than or equal to the min value ' + ('`' + min + '` but received `' + props[propName] + '` for the `' + componentNameSafe + '` component.'));
    }

    return err;
  };
}

/** @module utils/StringUtils/addSuffix */

/**
 * Optionally adds a suffix to a string if it does
 * not already contain that string.
 *
 * @param {String} str - The string to modify
 * @param {String} suffix - The suffix to add
 *
 * @return {String} the string with a suffix
 */
function addSuffix(str, suffix) {
  if (!str || typeof str !== 'string') {
    return str;
  }

  return str.indexOf(suffix) === -1 ? str.trim() + ' ' + suffix : str;
}

var FloatingLabel = function (_PureComponent) {
  inherits(FloatingLabel, _PureComponent);

  function FloatingLabel() {
    classCallCheck(this, FloatingLabel);
    return possibleConstructorReturn(this, (FloatingLabel.__proto__ || Object.getPrototypeOf(FloatingLabel)).apply(this, arguments));
  }

  createClass(FloatingLabel, [{
    key: 'render',
    value: function render() {
      var _cn;

      var _props = this.props,
          label = _props.label,
          htmlFor = _props.htmlFor,
          className = _props.className,
          floating = _props.floating,
          active = _props.active,
          error = _props.error,
          disabled = _props.disabled,
          iconOffset = _props.iconOffset,
          customSize = _props.customSize,
          props = objectWithoutProperties(_props, ['label', 'htmlFor', 'className', 'floating', 'active', 'error', 'disabled', 'iconOffset', 'customSize']);


      if (!label) {
        return null;
      }

      return React.createElement(
        'label',
        _extends({}, props, {
          htmlFor: htmlFor,
          className: classnames('md-floating-label', (_cn = {
            'md-floating-label--inactive': !floating,
            'md-floating-label--inactive-sized': !floating && !customSize
          }, defineProperty(_cn, 'md-floating-label--' + customSize, customSize), defineProperty(_cn, 'md-floating-label--inactive-' + customSize, customSize && !floating), defineProperty(_cn, 'md-floating-label--floating', floating), defineProperty(_cn, 'md-floating-label--icon-offset', iconOffset), _cn), themeColors({
            disabled: disabled,
            error: error,
            hint: !active,
            primary: active
          }, className))
        }),
        label
      );
    }
  }]);
  return FloatingLabel;
}(PureComponent);

FloatingLabel.propTypes = {
  style: propTypes.object,
  className: propTypes.string,
  label: propTypes.node,
  floating: propTypes.bool,
  error: propTypes.bool,
  active: propTypes.bool,
  disabled: propTypes.bool,
  iconOffset: propTypes.bool,
  customSize: propTypes.string,
  htmlFor: propTypes.string
};

var Message = function (_PureComponent) {
  inherits(Message, _PureComponent);

  function Message() {
    classCallCheck(this, Message);
    return possibleConstructorReturn(this, (Message.__proto__ || Object.getPrototypeOf(Message)).apply(this, arguments));
  }

  createClass(Message, [{
    key: 'render',
    value: function render() {
      var _props = this.props,
          active = _props.active,
          children = _props.children,
          className = _props.className;


      if (!children) {
        return null;
      }

      return React.createElement(
        'div',
        {
          'aria-hidden': !active,
          className: classnames('md-text-field-message', 'md-text-field-message--' + (active ? '' : 'in') + 'active', className)
        },
        children
      );
    }
  }]);
  return Message;
}(PureComponent);

Message.propTypes = {
  active: propTypes.bool,
  className: propTypes.string,
  children: propTypes.node
};

var TextFieldMessage = function (_PureComponent) {
  inherits(TextFieldMessage, _PureComponent);

  function TextFieldMessage(props) {
    classCallCheck(this, TextFieldMessage);

    var _this = possibleConstructorReturn(this, (TextFieldMessage.__proto__ || Object.getPrototypeOf(TextFieldMessage)).call(this, props));

    _this.state = {
      message: props.error && props.errorText || props.helpText || props.errorText,
      isMessageVisible: _this._isMessageVisible(props)
    };
    return _this;
  }

  createClass(TextFieldMessage, [{
    key: 'componentWillReceiveProps',
    value: function componentWillReceiveProps(nextProps) {
      var keys = ['active', 'error', 'helpOnFocus', 'helpText', 'errorText'];
      if (this._anyChanges(keys, this.props, nextProps)) {
        this.setState({
          isMessageVisible: this._isMessageVisible(nextProps),
          message: nextProps.error && nextProps.errorText || nextProps.helpText || nextProps.errorText
        });
      }
    }
  }, {
    key: '_anyChanges',
    value: function _anyChanges(keys, p1, p2) {
      var changed = false;
      keys.some(function (key) {
        if (p1[key] !== p2[key]) {
          changed = true;
        }

        return changed;
      });

      return changed;
    }
  }, {
    key: '_isMessageVisible',
    value: function _isMessageVisible(props) {
      var error = props.error,
          errorText = props.errorText,
          helpText = props.helpText,
          helpOnFocus = props.helpOnFocus,
          active = props.active;

      if (error && errorText) {
        return true;
      }

      return !!(helpText && (!helpOnFocus || active));
    }
  }, {
    key: 'render',
    value: function render() {
      var _props = this.props,
          maxLength = _props.maxLength,
          error = _props.error,
          className = _props.className,
          errorText = _props.errorText,
          helpText = _props.helpText,
          currentLength = _props.currentLength,
          leftIcon = _props.leftIcon,
          rightIcon = _props.rightIcon,
          block = _props.block,
          active = _props.active;
      var _state = this.state,
          isMessageVisible = _state.isMessageVisible,
          message = _state.message;


      if (currentLength === 'undefined' || !helpText && !errorText && !maxLength) {
        return null;
      }

      return React.createElement(
        'div',
        {
          className: classnames('md-text-field-message-container', {
            'md-text-field-message-container--count-only': !message || !isMessageVisible,
            'md-text-field-message-container--left-icon-offset': leftIcon,
            'md-text-field-message-container--right-icon-offset': rightIcon,
            'md-full-width': !block
          }, themeColors({ error: error, disabled: !error }), className)
        },
        React.createElement(
          Message,
          { key: 'message', active: isMessageVisible },
          message
        ),
        React.createElement(
          Message,
          { key: 'counter', className: 'md-text-field-message--counter', active: active },
          maxLength ? currentLength + ' / ' + maxLength : null
        )
      );
    }
  }]);
  return TextFieldMessage;
}(PureComponent);

TextFieldMessage.propTypes = {
  className: propTypes.string,
  error: propTypes.bool,
  helpText: propTypes.node,
  errorText: propTypes.node,
  active: propTypes.bool,
  helpOnFocus: propTypes.bool,
  maxLength: propTypes.number,
  currentLength: propTypes.number,
  leftIcon: propTypes.bool,
  rightIcon: propTypes.bool,
  block: propTypes.bool
};

var PasswordButton = function (_PureComponent) {
  inherits(PasswordButton, _PureComponent);

  function PasswordButton() {
    var _ref;

    var _temp, _this, _ret;

    classCallCheck(this, PasswordButton);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = possibleConstructorReturn(this, (_ref = PasswordButton.__proto__ || Object.getPrototypeOf(PasswordButton)).call.apply(_ref, [this].concat(args))), _this), _this.state = { keyboardFocus: false }, _this._handleOutsideClick = function (e) {
      if (_this._button && !_this._button.contains(e.target)) {
        window.removeEventListener('click', _this._handleOutsideClick);
        _this.setState({ keyboardFocus: false });
      }
    }, _this._handleBlur = function () {
      if (_this.state.keyboardFocus) {
        _this.setState({ keyboardFocus: false });
      }
    }, _this._handleKeyUp = function (e) {
      var key = e.which || e.keyCode;
      if (key === TAB) {
        _this.setState({ keyboardFocus: true });
      }
    }, _temp), possibleConstructorReturn(_this, _ret);
  }

  createClass(PasswordButton, [{
    key: 'render',
    value: function render() {
      var keyboardFocus = this.state.keyboardFocus;
      var _props = this.props,
          active = _props.active,
          passwordVisible = _props.passwordVisible,
          block = _props.block,
          floating = _props.floating,
          icon = _props.icon,
          props = objectWithoutProperties(_props, ['active', 'passwordVisible', 'block', 'floating', 'icon']);


      return React.createElement(
        'button',
        _extends({}, props, {
          onBlur: this._handleBlur,
          onKeyUp: this._handleKeyUp,
          type: 'button',
          className: classnames('md-text-field-inline-indicator md-password-btn md-pointer--hover', {
            'md-password-btn--focus': keyboardFocus,
            'md-password-btn--invisible': active && !passwordVisible,
            'md-text-field-inline-indicator--floating': floating,
            'md-text-field-inline-indicator--block': block
          }, themeColors({ disabled: !active, hint: active }))
        }),
        icon
      );
    }
  }]);
  return PasswordButton;
}(PureComponent);

PasswordButton.propTypes = {
  active: propTypes.bool,
  passwordVisible: propTypes.bool,
  icon: propTypes.element,
  block: propTypes.bool,
  floating: propTypes.bool
};

/**
 * The `TextArea` component is used to allow a dynamic height for the
 * `textarea`. The height will keep on changing until the maxRows prop
 * is met or infinitely if it does not exist, or is 0.
 */

var TextArea = function (_PureComponent) {
  inherits(TextArea, _PureComponent);

  function TextArea() {
    var _ref;

    var _temp, _this, _ret;

    classCallCheck(this, TextArea);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = possibleConstructorReturn(this, (_ref = TextArea.__proto__ || Object.getPrototypeOf(TextArea)).call.apply(_ref, [this].concat(args))), _this), _this.state = { height: null }, _this.getField = function () {
      return _this._field;
    }, _this.getValue = function () {
      return _this._field.value;
    }, _this.focus = function () {
      _this._field.focus();
    }, _this.blur = function () {
      _this._field.blur();
    }, _this._calcRowHeight = function () {
      var _ref2 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : _this.props,
          rows = _ref2.rows;

      if (!_this._field) {
        return 19;
      }

      var height = _this._field.style.height;
      _this._field.style.height = 'auto';
      var rowHeight = _this._field.offsetHeight / rows;
      _this._field.style.height = height;
      return rowHeight;
    }, _this._setMask = function (mask) {
      _this._mask = mask;
    }, _this._setField = function (field) {
      _this._field = field;
    }, _this._handleResize = function () {
      _this._rowHeight = _this._calcRowHeight();
      _this._syncHeightWithMask();
    }, _this._syncHeightWithMask = function (value) {
      // The mask is always null in snapshot teseting
      if (!_this._mask) {
        return;
      }

      if (value !== undefined) {
        _this._mask.value = value;
      }

      var height = _this._mask.scrollHeight;
      if (height === undefined) {
        return;
      }

      var _this$props = _this.props,
          rows = _this$props.rows,
          maxRows = _this$props.maxRows;

      if (maxRows && maxRows > 0) {
        height = Math.min(height, _this._rowHeight * maxRows);
      }

      height = Math.max(_this._rowHeight * rows, height);
      _this.setState({ height: height });
    }, _this._handleChange = function (e) {
      _this._syncHeightWithMask(e.target.value, e);

      if (_this.props.onChange) {
        _this.props.onChange(e);
      }
    }, _temp), possibleConstructorReturn(_this, _ret);
  }

  createClass(TextArea, [{
    key: 'componentDidMount',
    value: function componentDidMount() {
      this._rowHeight = this._calcRowHeight();
      this._syncHeightWithMask();
    }
  }, {
    key: 'componentWillReceiveProps',
    value: function componentWillReceiveProps(nextProps) {
      if (this.props.rows !== nextProps.rows) {
        this._rowHeight = this._calcRowHeight(nextProps);
      }

      if (this.props.value !== nextProps.value || this.props.maxRows !== nextProps.maxRows) {
        this._syncHeightWithMask(nextProps.value);
      }
    }
  }, {
    key: 'render',
    value: function render() {
      var height = this.state.height;
      var _props = this.props,
          style = _props.style,
          defaultValue = _props.defaultValue,
          value = _props.value,
          className = _props.className,
          label = _props.label,
          block = _props.block,
          maxRows = _props.maxRows,
          onChange = _props.onChange,
          props = objectWithoutProperties(_props, ['style', 'defaultValue', 'value', 'className', 'label', 'block', 'maxRows', 'onChange']);


      return React.createElement(
        'div',
        {
          style: { height: height && height + 5 },
          className: classnames('md-text-field-multiline-container', {
            'md-text-field--margin': !label && !block,
            'md-text-field--floating-margin': label && !block
          })
        },
        React.createElement(ResizeObserver$1, { watchWidth: true, onResize: this._handleResize }),
        React.createElement('textarea', {
          ref: this._setMask,
          className: classnames(className, 'md-text-field--multiline-mask'),
          readOnly: true,
          rows: props.rows,
          tabIndex: -1,
          style: style,
          defaultValue: defaultValue,
          'aria-hidden': true,
          value: value
        }),
        React.createElement('textarea', _extends({}, props, {
          ref: this._setField,
          style: Object.assign({}, style, { height: height }),
          className: className,
          defaultValue: defaultValue,
          value: value,
          onChange: this._handleChange
        }))
      );
    }
  }]);
  return TextArea;
}(PureComponent);

TextArea.propTypes = {
  id: propTypes.string,
  style: propTypes.object,
  className: propTypes.string,
  rows: propTypes.number.isRequired,
  maxRows: propTypes.number,
  onChange: propTypes.func,
  defaultValue: propTypes.string,
  floatingLabel: propTypes.bool,
  value: propTypes.string,
  block: propTypes.bool,
  label: propTypes.node
};

/**
 * This component either renders a base `input` tag or the `TextArea` component.
 */

var InputField = function (_PureComponent) {
  inherits(InputField, _PureComponent);

  function InputField() {
    var _ref;

    var _temp, _this, _ret;

    classCallCheck(this, InputField);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = possibleConstructorReturn(this, (_ref = InputField.__proto__ || Object.getPrototypeOf(InputField)).call.apply(_ref, [this].concat(args))), _this), _this.getField = function () {
      // eslint-disable-line arrow-body-style
      return typeof _this.props.rows === 'undefined' ? _this._field : _this._field.getField();
    }, _this.getValue = function () {
      if (typeof _this.props.rows === 'undefined') {
        return _this._field.value;
      }

      return _this._field.getValue();
    }, _this.focus = function () {
      _this._field.focus();
    }, _this.blur = function () {
      _this._field.blur();
    }, _this._setField = function (field) {
      _this._field = field;
    }, _temp), possibleConstructorReturn(_this, _ret);
  }

  createClass(InputField, [{
    key: 'render',
    value: function render() {
      var _cn;

      var _props = this.props,
          className = _props.className,
          rows = _props.rows,
          label = _props.label,
          customSize = _props.customSize,
          fullWidth = _props.fullWidth,
          type = _props.type,
          passwordVisible = _props.passwordVisible,
          block = _props.block,
          inlineIndicator = _props.inlineIndicator,
          maxRows = _props.maxRows,
          props = objectWithoutProperties(_props, ['className', 'rows', 'label', 'customSize', 'fullWidth', 'type', 'passwordVisible', 'block', 'inlineIndicator', 'maxRows']);


      var multiline = typeof rows !== 'undefined';
      var Component$$1 = multiline ? TextArea : 'input';
      if (!multiline) {
        props.type = passwordVisible ? 'text' : type;
      } else {
        props.label = label;
        props.block = block;
        props.maxRows = maxRows;
      }

      return createElement(Component$$1, _extends({}, props, {
        rows: rows,
        ref: this._setField,
        className: classnames('md-text-field', (_cn = {
          'md-text-field--inline-indicator': inlineIndicator || !multiline && type === 'password',
          'md-text-field--multiline': multiline,
          'md-text-field--margin': !block && !multiline && !label,
          'md-text-field--floating-margin': !block && !multiline && label
        }, defineProperty(_cn, 'md-text-field--' + customSize, customSize), defineProperty(_cn, 'md-full-width', fullWidth), _cn), themeColors({ disabled: props.disabled, text: !props.disabled }, className))
      }));
    }
  }]);
  return InputField;
}(PureComponent);

InputField.propTypes = {
  id: propTypes.oneOfType([propTypes.string, propTypes.number]),
  style: propTypes.object,
  className: propTypes.string,
  type: propTypes.string,
  placeholder: propTypes.string,
  block: propTypes.bool,
  disabled: propTypes.bool,
  rows: propTypes.number,
  maxRows: propTypes.number,
  label: propTypes.node,
  fullWidth: propTypes.bool,
  customSize: propTypes.string,
  passwordVisible: propTypes.bool,
  inlineIndicator: propTypes.bool
};

/**
 * The divider component will pass all other props such as style or
 * event listeners on to the component.
 */

var Divider = function (_PureComponent) {
  inherits(Divider, _PureComponent);

  function Divider() {
    classCallCheck(this, Divider);
    return possibleConstructorReturn(this, (Divider.__proto__ || Object.getPrototypeOf(Divider)).apply(this, arguments));
  }

  createClass(Divider, [{
    key: 'render',
    value: function render() {
      var _props = this.props,
          className = _props.className,
          inset = _props.inset,
          vertical = _props.vertical,
          props = objectWithoutProperties(_props, ['className', 'inset', 'vertical']);


      var Component$$1 = vertical ? 'div' : 'hr';

      return React.createElement(Component$$1, _extends({}, props, {
        className: classnames('md-divider', {
          'md-divider--vertical': vertical,
          'md-divider--inset': inset
        }, className)
      }));
    }
  }]);
  return Divider;
}(PureComponent);

Divider.propTypes = {
  /*
   * An optional style to apply to the divider.
   */
  style: propTypes.object,

  /**
   * An optional className to apply to the divider.
   */
  className: propTypes.string,

  /**
   * Boolean if this divider should be inset relative to it's container
   * component. This means that if it is in a `List` with `Avatar`, it
   * will start the divider  to the left of the main text in the list.
   */
  inset: propTypes.bool,

  /**
   * Boolean if the divider should be vertical instead of horizontal.
   */
  vertical: propTypes.bool
};

var TextFieldDivider = function (_PureComponent) {
  inherits(TextFieldDivider, _PureComponent);

  function TextFieldDivider() {
    classCallCheck(this, TextFieldDivider);
    return possibleConstructorReturn(this, (TextFieldDivider.__proto__ || Object.getPrototypeOf(TextFieldDivider)).apply(this, arguments));
  }

  createClass(TextFieldDivider, [{
    key: 'render',
    value: function render() {
      var _props = this.props,
          active = _props.active,
          error = _props.error,
          lineDirection = _props.lineDirection,
          className = _props.className,
          props = objectWithoutProperties(_props, ['active', 'error', 'lineDirection', 'className']);

      return React.createElement(Divider, _extends({}, props, {
        className: classnames('md-divider--text-field md-divider--expand-from-' + lineDirection, {
          'md-divider--text-field-expanded': active,
          'md-divider--text-field-active': !error && active,
          'md-divider--text-field-error': error
        }, className)
      }));
    }
  }]);
  return TextFieldDivider;
}(PureComponent);

TextFieldDivider.propTypes = {
  style: propTypes.object,
  className: propTypes.string,
  active: propTypes.bool,
  error: propTypes.bool,
  lineDirection: propTypes.oneOf(['left', 'center', 'right'])
};

var DEFAULT_TEXT_FIELD_SIZE = 180;

var WILL_RECEIVE_KEYS = ['style', 'value', 'resize'];
var DID_UPDATE_KEYS = ['leftIcon', 'rightIcon', 'passwordIcon', 'inlineIndicator'];

/**
 * The `TextField` component can either be a single line `input` field or a multiline
 * `textarea` field. `FontIcon`s, messages, and password indicators can also be added
 * to this field.
 *
 * The optional mouse and touch events will be added to the entire container while the
 * text specific events will be added to the `input` or `textarea` tags.
 */

var TextField = function (_PureComponent) {
  inherits(TextField, _PureComponent);

  function TextField(props) {
    classCallCheck(this, TextField);

    var _this = possibleConstructorReturn(this, (TextField.__proto__ || Object.getPrototypeOf(TextField)).call(this, props));

    _initialiseProps$4.call(_this);

    var currentLength = _this._getLength(typeof props.value !== 'undefined' ? props.value : props.defaultValue);

    _this._canvas = null;
    var width = null;
    if (typeof props.resize !== 'undefined') {
      width = typeof props.resize.min === 'number' ? props.resize.min : DEFAULT_TEXT_FIELD_SIZE;
    }

    _this.state = {
      active: false,
      error: props.maxLength ? props.maxLength < currentLength : false,
      floating: isValued(props.defaultValue) || isValued(props.value),
      passwordVisible: props.passwordInitiallyVisible,
      currentLength: currentLength,
      styles: width ? _extends({ width: width }, props.style) : props.style
    };
    return _this;
  }

  createClass(TextField, [{
    key: 'componentDidMount',
    value: function componentDidMount() {
      var _props = this.props,
          value = _props.value,
          defaultValue = _props.defaultValue,
          resize = _props.resize,
          style = _props.style;

      var v = typeof value !== 'undefined' ? value : defaultValue;
      /* eslint-disable react/no-did-mount-set-state */
      if (resize) {
        // always want to set width on mount
        this.setState({ styles: _extends({ width: this._calcWidth(v, this.props) }, style) });
      }
    }
  }, {
    key: 'componentWillReceiveProps',
    value: function componentWillReceiveProps(nextProps) {
      var _this2 = this;

      var value = nextProps.value,
          resize = nextProps.resize,
          style = nextProps.style;

      var nextState = {};
      if (value !== this.props.value) {
        nextState.error = this._isErrored(nextProps);
        nextState.floating = this._focus || isValued(value);
        nextState.currentLength = this._getLength(value);
      }

      if (WILL_RECEIVE_KEYS.some(function (key) {
        return _this2.props[key] !== nextProps[key];
      })) {
        if (!resize) {
          nextState.styles = style;
        } else {
          var width = this._calcWidth(value, nextProps);
          nextState.styles = _extends({ width: width }, style);
        }
      }

      this.setState(nextState);
    }
  }, {
    key: 'componentDidUpdate',
    value: function componentDidUpdate(prevProps) {
      var _this3 = this;

      var _props2 = this.props,
          resize = _props2.resize,
          value = _props2.value,
          style = _props2.style;

      if (resize && DID_UPDATE_KEYS.some(function (key) {
        return _this3.props[key] !== prevProps[key];
      })) {
        var width = this._calcWidth(value, this.props);
        this.setState({ styles: _extends({ width: width }, style) }); // eslint-disable-line react/no-did-update-set-state
      }
    }

    /**
     * A helper function for getting the specific `input` field or the `textarea` in the `TextField`.
     * This is accessible if you use `refs`.
     *
     * Example:
     *
     * ```js
     * <TextField ref={field => this._field = field;} label="Hello" />;
     *
     * this._field.getField(); // `input` node
     * ```
     */


    /**
     * A helper function for focusing the `input` field or the `textarea` in the `TextField`.
     * This is accessibile if you use `refs`.
     * Example:
     *
     * ```js
     * <TextField ref={field => this._field = field;} label="Hello" />;
     *
     * this._field.focus();
     * ```
     */

  }, {
    key: 'blur',


    /**
     * A helper function for blurring the `input` field or the `textarea` in the `TextField`.
     * This is accessible if you use `refs`.
     * Example:
     *
     * ```js
     * <TextField ref={field => this._field = field;} label="Hello" />;
     *
     * this._field.blur();
     * ```
     */
    value: function blur() {
      this._field.blur();
    }
  }, {
    key: '_cloneIcon',
    value: function _cloneIcon(icon, active, error, disabled, stateful, block, dir) {
      if (!icon) {
        return icon;
      }

      try {
        var iconEl = Children.only(icon);
        return cloneElement(iconEl, {
          key: iconEl.key || 'icon-' + dir,
          disabled: stateful ? disabled : undefined,
          primary: stateful ? !error && active : undefined,
          error: stateful ? error : undefined,
          className: classnames('md-text-field-icon', {
            'md-text-field-icon--positioned': !block
          }, iconEl.props.className)
        });
      } catch (e) {
        return icon;
      }
    }

    /**
     * A small utility function for calculating an inline-icon's width keeping the SVG Icons
     * in mind and any margin that gets applied for spacing.
     */

  }, {
    key: 'render',
    value: function render() {
      var _state = this.state,
          currentLength = _state.currentLength,
          passwordVisible = _state.passwordVisible,
          styles = _state.styles;
      var _props3 = this.props,
          id = _props3.id,
          type = _props3.type,
          className = _props3.className,
          inputStyle = _props3.inputStyle,
          inputClassName = _props3.inputClassName,
          block = _props3.block,
          fullWidth = _props3.fullWidth,
          required = _props3.required,
          customSize = _props3.customSize,
          maxLength = _props3.maxLength,
          errorText = _props3.errorText,
          helpText = _props3.helpText,
          helpOnFocus = _props3.helpOnFocus,
          disabled = _props3.disabled,
          leftIconStateful = _props3.leftIconStateful,
          rightIconStateful = _props3.rightIconStateful,
          passwordIcon = _props3.passwordIcon,
          lineDirection = _props3.lineDirection,
          paddedBlock = _props3.paddedBlock,
          onDoubleClick = _props3.onDoubleClick,
          onTouchStart = _props3.onTouchStart,
          onTouchMove = _props3.onTouchMove,
          onTouchCancel = _props3.onTouchCancel,
          onTouchEnd = _props3.onTouchEnd,
          onMouseDown = _props3.onMouseDown,
          onMouseUp = _props3.onMouseUp,
          onMouseOver = _props3.onMouseOver,
          onMouseLeave = _props3.onMouseLeave,
          ink = _props3.ink,
          inlineIndicator = _props3.inlineIndicator,
          toolbar = _props3.toolbar,
          icon = _props3.icon,
          passwordIconChildren = _props3.passwordIconChildren,
          passwordIconClassName = _props3.passwordIconClassName,
          style = _props3.style,
          propLabel = _props3.label,
          propPlaceholder = _props3.placeholder,
          propError = _props3.error,
          propActive = _props3.active,
          propFloating = _props3.floating,
          propLeftIcon = _props3.leftIcon,
          propRightIcon = _props3.rightIcon,
          onClick = _props3.onClick,
          onChange = _props3.onChange,
          onBlur = _props3.onBlur,
          onFocus = _props3.onFocus,
          resize = _props3.resize,
          adjustMinWidth = _props3.adjustMinWidth,
          propFloatingLabel = _props3.floatingLabel,
          props = objectWithoutProperties(_props3, ['id', 'type', 'className', 'inputStyle', 'inputClassName', 'block', 'fullWidth', 'required', 'customSize', 'maxLength', 'errorText', 'helpText', 'helpOnFocus', 'disabled', 'leftIconStateful', 'rightIconStateful', 'passwordIcon', 'lineDirection', 'paddedBlock', 'onDoubleClick', 'onTouchStart', 'onTouchMove', 'onTouchCancel', 'onTouchEnd', 'onMouseDown', 'onMouseUp', 'onMouseOver', 'onMouseLeave', 'ink', 'inlineIndicator', 'toolbar', 'icon', 'passwordIconChildren', 'passwordIconClassName', 'style', 'label', 'placeholder', 'error', 'active', 'floating', 'leftIcon', 'rightIcon', 'onClick', 'onChange', 'onBlur', 'onFocus', 'resize', 'adjustMinWidth', 'floatingLabel']);
      var _props4 = this.props,
          label = _props4.label,
          placeholder = _props4.placeholder,
          error = _props4.error,
          active = _props4.active,
          floating = _props4.floating,
          leftIcon = _props4.leftIcon,
          rightIcon = _props4.rightIcon;

      active = active || this.state.active;
      error = error || this.state.error;
      floating = floating || this.state.floating;

      if (required) {
        if (label) {
          label = addSuffix(label, '*');
        }

        if (placeholder && !label) {
          placeholder = addSuffix(placeholder, '*');
        }
      }

      if (label && !floating) {
        placeholder = null;
      }

      leftIcon = this._cloneIcon(icon || leftIcon, active, error, disabled, leftIconStateful, block, 'left');
      if (type === 'password' && !disabled) {
        rightIcon = React.createElement(PasswordButton, {
          key: 'password-btn',
          onClick: this._togglePasswordField,
          active: active,
          passwordVisible: passwordVisible,
          icon: getDeprecatedIcon(passwordIconClassName, passwordIconChildren, passwordIcon),
          block: block,
          floating: !!label
        });
      } else if (inlineIndicator) {
        var el = Children.only(inlineIndicator);
        rightIcon = cloneElement(inlineIndicator, {
          key: 'icon-right',
          className: classnames('md-text-field-inline-indicator', {
            'md-text-field-inline-indicator--floating': label,
            'md-text-field-inline-indicator--block': block
          }, el.props.className)
        });
      } else {
        rightIcon = this._cloneIcon(rightIcon, active, error, disabled, rightIconStateful, block, 'right');
      }
      var rightIconed = !!rightIcon && type !== 'password' && !inlineIndicator;

      var floatingLabel = React.createElement(FloatingLabel, {
        key: 'label',
        label: label,
        htmlFor: id,
        active: active,
        error: error,
        floating: floating,
        customSize: customSize,
        disabled: disabled,
        iconOffset: !!leftIcon
      });

      var message = React.createElement(TextFieldMessage, {
        key: 'message',
        active: active,
        error: error,
        errorText: errorText,
        helpText: helpText,
        helpOnFocus: helpOnFocus,
        block: block,
        maxLength: maxLength,
        leftIcon: !!leftIcon,
        rightIcon: !!rightIcon,
        currentLength: currentLength
      });

      var field = React.createElement(InputField, _extends({}, props, {
        key: 'field',
        ref: this._setField,
        id: id,
        type: type,
        label: label,
        style: inputStyle,
        className: classnames({ 'md-text-field--toolbar': toolbar }, inputClassName),
        disabled: disabled,
        customSize: customSize,
        fullWidth: fullWidth,
        passwordVisible: passwordVisible,
        placeholder: placeholder,
        block: block,
        onFocus: this._handleFocus,
        onBlur: this._handleBlur,
        onChange: this._handleChange,
        inlineIndicator: !!inlineIndicator
      }));

      var divider = void 0;
      if (!block) {
        divider = React.createElement(TextFieldDivider, {
          key: 'text-divider',
          active: active,
          error: error,
          lineDirection: lineDirection
        });
      }

      var children = void 0;
      if (leftIcon || rightIconed) {
        children = React.createElement(
          'div',
          { key: 'icon-divider', className: 'md-text-field-icon-container' },
          leftIcon,
          React.createElement(
            'div',
            {
              key: 'divider-container',
              className: classnames('md-text-field-divider-container', {
                'md-text-field-divider-container--grow': fullWidth
              })
            },
            field,
            divider
          ),
          rightIcon
        );
      } else {
        children = [leftIcon, field, divider, rightIcon];
      }

      children = [floatingLabel, children, message];

      var multiline = typeof props.rows !== 'undefined';
      return React.createElement(
        'div',
        {
          style: styles,
          className: classnames('md-text-field-container', {
            'md-inline-block': !fullWidth && !block,
            'md-full-width': block || fullWidth,
            'md-text-field-container--disabled': disabled,
            'md-text-field-container--input': !multiline,
            'md-text-field-container--input-block': block && !multiline,
            'md-text-field-container--multiline': multiline,
            'md-text-field-container--multiline-block': multiline && block,
            'md-text-field-container--padded-block': block && paddedBlock
          }, className),
          onClick: this._handleContainerClick,
          onDoubleClick: onDoubleClick,
          onMouseOver: onMouseOver,
          onMouseLeave: onMouseLeave,
          onMouseDown: onMouseDown,
          onMouseUp: onMouseUp,
          onTouchStart: onTouchStart,
          onTouchEnd: onTouchEnd,
          onTouchCancel: onTouchCancel,
          onTouchMove: onTouchMove,
          ref: this._setContainer
        },
        ink,
        children
      );
    }
  }, {
    key: 'value',


    /**
     * Gets the current value from the text field. This is used when you have an uncontrolled
     * text field and simply need the value from a ref callback.
     *
     * @return {String} the text field's value
     */
    get: function get$$1() {
      return this.getField().value;
    }
  }]);
  return TextField;
}(PureComponent);

TextField.propTypes = {
  /**
   * The id for a text field. This is required when using the `label` prop for accessibility,
   * but normally a good idea to include one anyways.
   */
  id: isRequiredForA11y(propTypes.oneOfType([propTypes.number, propTypes.string])),

  /**
   * An optional style to apply to the text field's container.
   */
  style: propTypes.object,

  /**
   * An optional className to apply to the text field's container.
   */
  className: propTypes.string,

  /**
   * An optional style to apply to the `input` or `textarea` tag.
   */
  inputStyle: propTypes.object,

  /**
   * An optional className to apply to the `input` or `textarea` tag.
   */
  inputClassName: propTypes.string,

  /**
   * An optional value to apply to the text field. This will make the component
   * controlled and require the `onChange` prop.
   */
  value: controlled(propTypes.oneOfType([propTypes.string, propTypes.number]), 'onChange'),

  /**
   * An optional default value for the text field.
   */
  defaultValue: propTypes.oneOfType([propTypes.string, propTypes.number]),

  /**
   * Boolean if the text field should be displayed as a `block`. This is equivalent to
   * the `full width` text field in the Material Design specs. This view will disable
   * floating labels and remove the text divider from the component.
   */
  block: propTypes.bool,

  /**
   * Boolean if the `block` text field should include padding to the left and right of
   * the text field.
   */
  paddedBlock: propTypes.bool,

  /**
   * Boolean if the text field is currently disabled.
   */
  disabled: propTypes.bool,

  /**
   * An optional label to display with the text field. This will convert the text field
   * into a floating label text field. You can make it single line by only using the
   * `placeholder` prop.
   */
  label: invalidIf(propTypes.node, 'block'),

  /**
   * An optional placeholder text to display in the text field. If there is no `label` prop,
   * the text field will be displayed as a single line text field. If there is a `label` prop,
   * this will only be visible when there is no value and the user focused the text field.
   */
  placeholder: propTypes.string,

  /**
   * The type for the text field. This is one of the most import props for mobile accessibility
   * as it will update the keyboard for the text type. This does not get applied on multiline
   * text fields.
   */
  type: propTypes.oneOf(['text', 'number', 'email', 'search', 'tel', 'url', 'password']).isRequired,

  /**
   * An optional function to call when the text field's container triggers the `click` event.
   */
  onClick: propTypes.func,

  /**
   * An optional function to call when the text field's container triggers the `doubleclick`
   * event.
   */
  onDoubleClick: propTypes.func,

  /**
   * An optional function to call when the text field's container triggers the `touchstart`
   * event.
   */
  onTouchStart: propTypes.func,

  /**
   * An optional function to call when the text field's container triggers the `touchmove`
   * event.
   */
  onTouchMove: propTypes.func,

  /**
   * An optional function to call when the text field's container triggers the `touchcancel`
   * event.
   */
  onTouchCancel: propTypes.func,

  /**
   * An optional function to call when the text field's container triggers the `touchend`
   * event.
   */
  onTouchEnd: propTypes.func,

  /**
   * An optional function to call when the text field's container triggers the `mousedown`
   * event.
   */
  onMouseDown: propTypes.func,

  /**
   * An optional function to call when the text field's container triggers the `mouseup`
   * event.
   */
  onMouseUp: propTypes.func,

  /**
   * An optional function to call when the text field's container triggers the `mouseover`
   * event.
   */
  onMouseOver: propTypes.func,

  /**
   * An optional function to call when the text field's container triggers the `mouseleave`
   * event.
   */
  onMouseLeave: propTypes.func,

  /**
   * An optional onChange function to call. If the `value` prop is defined, this is
   * required.
   *
   * When the value changes in the text field, this will be called with the new text
   * field's value and the change event.
   *
   * ```js
   * onChange(e.target.value, e);
   * ```
   */
  onChange: propTypes.func,

  /**
   * An optional function to call when the text field is blurred.
   */
  onBlur: propTypes.func,

  /**
   * An optional function to call when the text field is focused.
   */
  onFocus: propTypes.func,

  /**
   * An optional boolean if the `active` state of the text field can be externally
   * modified as well. The text field is usually considered active when it gains focus.
   *
   * If this prop is set, it will check both the active prop and the active state to
   * determine if one is true.
   */
  active: propTypes.bool,

  /**
   * An optional boolean if the `error` state of the text field can be externally
   * modified as well. The text field is usually considered errored when it is required
   * and there is no value or the current length of the text field's value is greater
   * than the `maxLength` prop.
   *
   * If this prop is set, it will check both the error prop and the error state to
   * determine if one is true.
   */
  error: propTypes.bool,

  /**
   * An optional boolean if the `floating` state of the text field's floating label can be
   * externally modified as well. The floating state is true when the text field gains focus
   * or there is a value in the text field.
   *
   * If this prop is set, it will check both the floating prop and the floating state to
   * determine if one is true.
   */
  floating: propTypes.bool,

  /**
   * Boolean if the text field is required. If the user blurs the text field while there is
   * no value and it is required, the `error` state will be set to true.
   */
  required: propTypes.bool,

  /**
   * The direction that the underline should appear from.
   */
  lineDirection: propTypes.oneOf(['left', 'center', 'right']).isRequired,

  /**
   * An optional icon to place to the left of the text field.
   */
  leftIcon: propTypes.element,

  /**
   * Boolean if the left icon should be stateful. This means that the icon will
   * gain the active or error colors with the text field.
   */
  leftIconStateful: propTypes.bool,

  /**
   * An optional icon to place to the right of the text field.
   */
  rightIcon: propTypes.element,

  /**
   * Boolean if the right icon should be stateful. This means that the icon will
   * gain the active or error colors with the text field.
   */
  rightIconStateful: propTypes.bool,

  /**
   * The icon to use for a password text field.
   */
  passwordIcon: propTypes.element,

  /**
   * Boolean if the password is initially visible.
   */
  passwordInitiallyVisible: propTypes.bool,

  /**
   * Boolean if the text field should be displayed as full width.
   */
  fullWidth: propTypes.bool,

  /**
   * The number of rows for the `multiline` text field. This value must be greater than
   * or equal to 1. When this value is set, the text field will be converted to a multiline
   * field.
   */
  rows: minNumber(1, false),

  /**
   * The maximum number of rows for a `multiline` text field. If this value is
   * `undefined`, `0`, or a number less than `0`, the multiline text field will
   * infinitely expand.
   */
  maxRows: propTypes.number,

  /**
   * An optional custom size to apply to the text field. This is used along with
   * the `$md-text-field-custom-sizes` variable. It basically applies a className of
   * `md-text-field--NAME`.
   */
  customSize: propTypes.string,

  /**
   * An optional error text to display below the text field. This will only appear when
   * the text field has the `error` state through the `error` prop, the current length
   * of the text field's value is greater than the `maxLength` prop, or the field is
   * required and the user blurs the text field with no value.
   */
  errorText: propTypes.node,

  /**
   * An optional help text to display below the text field. This will always be visible
   * unless the `helpOnFocus` prop is set to true. Otherwise it will appear on focus.
   */
  helpText: propTypes.node,

  /**
   * Boolean if the help text should display on focus only.
   */
  helpOnFocus: propTypes.bool,

  /**
   * An optional max length for the text field. This will insert a counter underneath the
   * text field that appears on focus.
   */
  maxLength: propTypes.number,

  /**
   * The ink when there is an injectInk above the text field. Used from the SelectField.
   *
   * @access private
   */
  ink: propTypes.node,

  /**
   * An optional element to display inside of the `TextField` to the farthest right. This will
   * position the indicator absolutely and add some additional padding to the `TextField`.
   */
  inlineIndicator: propTypes.element,

  /**
   * This prop allows the text field to resize its width to stay between the min and max sizes provided. By
   * default, the field will expand and collapse based on the amount of text provided. The collapsing can
   * be disabled by providing `disableShrink` to the configuration object.
   *
   * If the `min` prop is not provided, it will default to `180` which is about the same size as a default
   * text field.
   */
  resize: propTypes.shape({
    min: propTypes.number,
    max: propTypes.number.isRequired,
    disableShrink: propTypes.bool
  }),

  /**
   * Boolean if the TextField is in a toolbar and acting as a title. This will apply additional styles to the
   * text field to make it look like the toolbar's title.
   */
  toolbar: propTypes.bool,

  passwordIconChildren: deprecated(propTypes.node, 'Use the `passwordIcon` prop instead'),
  passwordIconClassName: deprecated(propTypes.string, 'Use the `passwordIcon` prop instead'),
  icon: deprecated(propTypes.node, 'Use the `leftIcon` or `rightIcon` prop instead'),
  floatingLabel: deprecated(propTypes.bool, 'The `label` prop is now always floating. To create a non-floating text field, only use the `placeholder` prop'),
  adjustMinWidth: deprecated(propTypes.bool, 'Manually add a min width style instead')
};
TextField.defaultProps = {
  type: 'text',
  lineDirection: 'left',
  passwordIcon: React.createElement(
    FontIcon,
    null,
    'remove_red_eye'
  ),
  leftIconStateful: true,
  rightIconStateful: true,
  fullWidth: true
};

var _initialiseProps$4 = function _initialiseProps() {
  var _this4 = this;

  this.getField = function () {
    return _this4._field.getField();
  };

  this.focus = function () {
    _this4._field.focus();
  };

  this._getLength = function (v) {
    if (isValued(v)) {
      return String(v).length;
    }

    return 0;
  };

  this._setContainer = function (div) {
    _this4._container = div;
  };

  this._setField = function (field) {
    if (field !== null) {
      _this4._field = field;
    }
  };

  this._calcIconWidth = function (icon) {
    var style = window.getComputedStyle(icon);

    return icon.getBoundingClientRect().width + parseInt(style.marginLeft, 10);
  };

  this._calcWidth = function (value) {
    var props = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : _this4.props;

    var text = value;
    // if it is a password, use the bullet unicode instead
    if (props.type === 'password') {
      text = Array.from(Array(value.length)).reduce(function (s) {
        return s + '\u2022';
      }, '');
    }

    var field = _this4._field && _this4._field.getField();
    if (!isValued(text) && field) {
      text = field.value;
    }

    var min = getField(props.resize, { min: DEFAULT_TEXT_FIELD_SIZE }, 'min');
    var width = getTextWidth(text, field);
    if (width === null || !field) {
      // some error happened, don't do other logic
      return width || min;
    }

    var max = props.resize.max;


    if (_this4._container) {
      var indicator = _this4._container.querySelector('.md-text-field-inline-indicator');
      if (indicator) {
        width += indicator.getBoundingClientRect().width;
      }

      var iconContainer = _this4._container.querySelector('.md-text-field-icon-container');
      if (iconContainer) {
        // There is conditionally an icon before and after the text field, or only an icon before/after
        var _iconContainer$childr = slicedToArray(iconContainer.children, 3),
            first = _iconContainer$childr[0],
            second = _iconContainer$childr[1],
            third = _iconContainer$childr[2];

        if (first.classList.contains('md-icon')) {
          width += first.getBoundingClientRect().width;
          width += parseInt(window.getComputedStyle(second).marginLeft, 10);

          if (third) {
            width += _this4._calcIconWidth(third);
          }
        } else if (second) {
          width += _this4._calcIconWidth(second);
        }
      }
    }

    return Math.ceil(Math.min(max, Math.max(min, width)));
  };

  this._isErrored = function () {
    var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : _this4.props,
        value = _ref.value,
        maxLength = _ref.maxLength,
        required = _ref.required;

    var error = _this4.state.error;

    var currentLength = _this4._getLength(value);
    if (required && error) {
      error = !isValued(value);
    }

    if (maxLength) {
      error = error || currentLength > maxLength;
    }

    return error;
  };

  this._handleContainerClick = function (e) {
    if (_this4.props.onClick) {
      _this4.props.onClick(e);
    }

    if (!_this4.props.disabled) {
      _this4.focus();
    }
  };

  this._handleBlur = function (e) {
    _this4._focus = false;
    var _props5 = _this4.props,
        required = _props5.required,
        maxLength = _props5.maxLength,
        onBlur = _props5.onBlur;

    if (onBlur) {
      onBlur(e);
    }

    var value = e.target.value;

    var state = {
      active: false,
      error: required && !isValued(value) || maxLength && String(value).length > maxLength
    };

    if (!_this4.props.block) {
      state.floating = isValued(value);
    }

    _this4.setState(state);
  };

  this._handleFocus = function (e) {
    _this4._focus = true;
    var _props6 = _this4.props,
        onFocus = _props6.onFocus,
        block = _props6.block;

    if (onFocus) {
      onFocus(e);
    }

    var state = { active: true };
    if (!block) {
      state.floating = true;
    }

    _this4.setState(state);
  };

  this._handleChange = function (e) {
    var _props7 = _this4.props,
        onChange = _props7.onChange,
        maxLength = _props7.maxLength,
        required = _props7.required,
        resize = _props7.resize;
    var value = e.target.value;

    if (onChange) {
      onChange(e.target.value, e);
    }

    var currentLength = value.length;
    var state = void 0;
    if (typeof maxLength !== 'undefined') {
      state = { currentLength: currentLength, error: currentLength > maxLength };
    } else if (required && _this4.state.error) {
      state = { error: !currentLength };
    }

    if (typeof _this4.props.value === 'undefined' && resize) {
      var width = _this4._calcWidth(value);
      if (!resize.disableShrink || !_this4.state.styles || width > _this4.state.styles.width) {
        state = state || {};
        state.styles = _extends({}, _this4.state.styles, { width: width });
      }
    }

    if (state) {
      _this4.setState(state);
    }
  };

  this._togglePasswordField = function () {
    _this4.setState({ passwordVisible: !_this4.state.passwordVisible }, _this4.focus);
  };
};

/**
 * The `Autocomplete` component is useful for presenting real-time suggestions, completions,
 * or filtering.
 */

var Autocomplete = function (_PureComponent) {
  inherits(Autocomplete, _PureComponent);

  function Autocomplete(props) {
    classCallCheck(this, Autocomplete);

    var _this = possibleConstructorReturn(this, (Autocomplete.__proto__ || Object.getPrototypeOf(Autocomplete)).call(this, props));

    _initialiseProps.call(_this);

    var defaultValue = props.defaultValue,
        data = props.data,
        dataLabel = props.dataLabel,
        filter = props.filter;


    var matches = [];
    if (defaultValue && filter) {
      matches = filter(data, defaultValue, dataLabel);
    } else if (!filter) {
      matches = data;
    }

    _this.state = {
      value: defaultValue,
      matches: matches,
      visible: false,
      matchIndex: -1,
      manualFocus: false,
      suggestion: '',
      suggestionIndex: -1
    };
    return _this;
  }

  createClass(Autocomplete, [{
    key: 'componentWillReceiveProps',
    value: function componentWillReceiveProps(nextProps) {
      var nextValue = nextProps.value,
          data = nextProps.data,
          filter = nextProps.filter,
          dataLabel = nextProps.dataLabel;

      var dataDiff = data !== this.props.data;
      if (nextValue !== this.props.value || dataDiff) {
        var _state = this.state,
            visible = _state.visible,
            matches = _state.matches;

        var value = getField(nextProps, this.state, 'value');

        if (filter) {
          matches = filter(data, value, dataLabel);
        } else if (dataDiff) {
          matches = data;
        }

        if (this.state.focus) {
          visible = !!matches.length;
        }

        this.setState({ matches: matches, visible: visible });
      }
    }
  }, {
    key: 'componentWillUpdate',
    value: function componentWillUpdate(nextProps, nextState) {
      if (this.state.visible !== nextState.visible) {
        var menuFn = nextProps['onMenu' + (nextState.visible ? 'Open' : 'Close')];
        if (menuFn) {
          menuFn();
        }
      }
    }

    /**
     * Gets the current value from the text field. This is used when you have an uncontrolled
     * text field and simply need the value from a ref callback.
     *
     * @return {String} the text field's value
     */

  }, {
    key: 'render',
    value: function render() {
      var _state2 = this.state,
          visible = _state2.visible,
          matches = _state2.matches,
          tabbed = _state2.tabbed,
          focus = _state2.focus,
          suggestionStyle = _state2.suggestionStyle;
      var _props = this.props,
          fullWidth = _props.fullWidth,
          block = _props.block,
          style = _props.style,
          className = _props.className,
          listStyle = _props.listStyle,
          listClassName = _props.listClassName,
          textFieldStyle = _props.textFieldStyle,
          textFieldClassName = _props.textFieldClassName,
          inlineSuggestionStyle = _props.inlineSuggestionStyle,
          inlineSuggestionClassName = _props.inlineSuggestionClassName,
          menuId = _props.menuId,
          inline = _props.inline,
          anchor = _props.anchor,
          belowAnchor = _props.belowAnchor,
          position = _props.position,
          fixedTo = _props.fixedTo,
          listId = _props.listId,
          listInline = _props.listInline,
          listZDepth = _props.listZDepth,
          listHeightRestricted = _props.listHeightRestricted,
          xThreshold = _props.xThreshold,
          yThreshold = _props.yThreshold,
          closeOnOutsideClick = _props.closeOnOutsideClick,
          transitionName = _props.transitionName,
          transitionEnterTimeout = _props.transitionEnterTimeout,
          transitionLeaveTimeout = _props.transitionLeaveTimeout,
          centered = _props.centered,
          sameWidth = _props.sameWidth,
          repositionOnScroll = _props.repositionOnScroll,
          repositionOnResize = _props.repositionOnResize,
          simplifiedMenu = _props.simplifiedMenu,
          minLeft = _props.minLeft,
          minRight = _props.minRight,
          minBottom = _props.minBottom,
          fillViewportWidth = _props.fillViewportWidth,
          fillViewportHeight = _props.fillViewportHeight,
          propValue = _props.value,
          total = _props.total,
          offset = _props.offset,
          filter = _props.filter,
          data = _props.data,
          dataLabel = _props.dataLabel,
          dataValue = _props.dataValue,
          deleteKeys = _props.deleteKeys,
          defaultValue = _props.defaultValue,
          clearOnAutocomplete = _props.clearOnAutocomplete,
          autocompleteWithLabel = _props.autocompleteWithLabel,
          findInlineSuggestion = _props.findInlineSuggestion,
          inlineSuggestionPadding = _props.inlineSuggestionPadding,
          onAutocomplete = _props.onAutocomplete,
          onMenuOpen = _props.onMenuOpen,
          onMenuClose = _props.onMenuClose,
          onBlur = _props.onBlur,
          onFocus = _props.onFocus,
          onKeyDown = _props.onKeyDown,
          onMouseDown = _props.onMouseDown,
          onChange = _props.onChange,
          props = objectWithoutProperties(_props, ['fullWidth', 'block', 'style', 'className', 'listStyle', 'listClassName', 'textFieldStyle', 'textFieldClassName', 'inlineSuggestionStyle', 'inlineSuggestionClassName', 'menuId', 'inline', 'anchor', 'belowAnchor', 'position', 'fixedTo', 'listId', 'listInline', 'listZDepth', 'listHeightRestricted', 'xThreshold', 'yThreshold', 'closeOnOutsideClick', 'transitionName', 'transitionEnterTimeout', 'transitionLeaveTimeout', 'centered', 'sameWidth', 'repositionOnScroll', 'repositionOnResize', 'simplifiedMenu', 'minLeft', 'minRight', 'minBottom', 'fillViewportWidth', 'fillViewportHeight', 'value', 'total', 'offset', 'filter', 'data', 'dataLabel', 'dataValue', 'deleteKeys', 'defaultValue', 'clearOnAutocomplete', 'autocompleteWithLabel', 'findInlineSuggestion', 'inlineSuggestionPadding', 'onAutocomplete', 'onMenuOpen', 'onMenuClose', 'onBlur', 'onFocus', 'onKeyDown', 'onMouseDown', 'onChange']);

      delete props.focusInputOnAutocomplete;

      var value = getField(this.props, this.state, 'value');

      var autocomplete = React.createElement(TextField, _extends({}, props, {
        'aria-autocomplete': inline ? 'inline' : 'list',
        style: textFieldStyle,
        className: classnames('md-autocomplete', textFieldClassName),
        key: 'autocomplete',
        ref: this._setField,
        value: value,
        onKeyDown: this._handleTextFieldKeyDown,
        onMouseDown: this._toggleMenu,
        onChange: this._handleChange,
        onFocus: this._handleFocus,
        onBlur: this._handleBlur,
        fullWidth: fullWidth,
        block: block
      }));

      if (inline) {
        var suggestion = void 0;
        if (focus && this.state.suggestion) {
          suggestion = React.createElement(
            'span',
            {
              key: 'suggestion',
              style: _extends({}, suggestionStyle, inlineSuggestionStyle),
              className: classnames('md-autocomplete-suggestion', {
                'md-autocomplete-suggestion--floating': props.label,
                'md-autocomplete-suggestion--block': block
              }, inlineSuggestionClassName)
            },
            this.state.suggestion
          );
        }

        return React.createElement(
          CSSTransitionGroup,
          {
            component: 'div',
            style: style,
            className: classnames('md-menu-container md-autocomplete-container', className, {
              'md-full-width': fullWidth || block
            }),
            transitionName: 'opacity',
            transitionEnterTimeout: 150,
            transitionLeave: !tabbed,
            transitionLeaveTimeout: 150,
            onTouchStart: this._handleTouchStart
          },
          autocomplete,
          suggestion
        );
      }

      return React.createElement(
        Menu,
        {
          id: menuId || props.id + '-menu',
          listId: listId,
          ref: this._setMenu,
          toggle: autocomplete,
          visible: visible,
          onClick: this._handleClick,
          onClose: this._close,
          onKeyDown: this._handleMenuKeyDown,
          simplified: simplifiedMenu,
          sameWidth: sameWidth,
          centered: centered,
          anchor: anchor,
          belowAnchor: belowAnchor,
          position: position,
          fixedTo: fixedTo,
          listInline: listInline,
          listZDepth: listZDepth,
          listHeightRestricted: listHeightRestricted,
          xThreshold: xThreshold,
          yThreshold: yThreshold,
          closeOnOutsideClick: closeOnOutsideClick,
          transitionName: transitionName,
          transitionEnterTimeout: transitionEnterTimeout,
          transitionLeaveTimeout: transitionLeaveTimeout,
          fullWidth: fullWidth || block,
          style: style,
          className: classnames('md-autocomplete-container', className),
          listStyle: listStyle,
          listClassName: classnames('md-autocomplete-list', listClassName),
          repositionOnScroll: repositionOnScroll,
          repositionOnResize: repositionOnResize,
          minLeft: minLeft,
          minRight: minRight,
          minBottom: minBottom,
          fillViewportWidth: fillViewportWidth,
          fillViewportHeight: fillViewportHeight
        },
        matches.map(this._mapToListItem)
      );
    }
  }, {
    key: 'value',
    get: function get$$1() {
      return getField(this.props, this.state, 'value');
    }

    /**
     * Just check if the click target is in a list item.. if it is, autocomplete the text field
     * with that item.
     */


    /**
     * The `mousedown` event is used instead of `click` because of the order
     * of the `mousedown`, `focus`, and `click` events.
     */


    /**
     * Allows touch devices to autocomplete the inline view by tapping:
     * - the suggestion text
     * - the text field IF there is a suggestion visible
     */

  }]);
  return Autocomplete;
}(PureComponent);

Autocomplete.HorizontalAnchors = Menu.HorizontalAnchors;
Autocomplete.VerticalAnchors = Menu.VerticalAnchors;
Autocomplete.Positions = Menu.Positions;
Autocomplete.fuzzyFilter = fuzzyFilter;
Autocomplete.caseInsensitiveFilter = caseInsensitiveFilter;
Autocomplete.findIgnoreCase = findIgnoreCase;
Autocomplete.propTypes = {
  /**
   * An id to give the autocomplete. Either this or the `menuId` is required for accessibility.
   *
   * @see {@link #menuId}
   */
  id: propTypes.oneOfType([propTypes.number, propTypes.string]),

  /**
   * The menu id to provide to the autocomplete. Either this prop or the `id` prop is required. If
   * this props is omitted, the menuId will become: `${id}-menu`
   */
  menuId: oneRequiredForA11y(propTypes.oneOfType([propTypes.number, propTypes.string]), 'id'),

  /**
   * An optional id to provide to the menu's list.
   *
   * @see {@link Menus/Menu#listId}
   */
  listId: propTypes.oneOfType([propTypes.number, propTypes.string]),

  /**
   * An optional style to apply to the menu that contains the autocomplete.
   */
  style: propTypes.object,

  /**
   * An optional className to apply to the menu that contains the autocomplete.
   */
  className: propTypes.string,

  /**
   * An optional style to apply to the autocomplete's text field.
   */
  textFieldStyle: propTypes.object,

  /**
   * An optional className to apply to the autocomplete's text field.
   */
  textFieldClassName: propTypes.string,

  /**
   * An optional style to apply to the autocomplete's text field input itself.
   */
  inputStyle: propTypes.object,

  /**
   * An optional className to apply to the autocomplete's input field itself.
   */
  inputClassName: propTypes.string,

  /**
   * The optional style to apply to the opened menu List if the
   * `Autocomplete` is not using `inline` suggestions.
   */
  listStyle: propTypes.object,

  /**
   * The optional className to apply to the opened menu List if the
   * `Autocomplete` is not using `inline` suggestions.
   */
  listClassName: propTypes.string,

  /**
   * An optional style to apply to the inline suggestion when using `inline` mode.
   */
  inlineSuggestionStyle: propTypes.object,

  /**
   * An optional className to apply to the inline suggestion when using `inline` mode.
   */
  inlineSuggestionClassName: propTypes.string,

  /**
   * Boolean if the autocomplete is disabled.
   */
  disabled: propTypes.bool,

  /**
   * A label to display with the autocomplete.
   */
  label: propTypes.node,

  /**
   * An optional value to use for the text field. This will force this component
   * to be controlled and require the `onChange` function.
   */
  value: controlled(propTypes.oneOfType([propTypes.string, propTypes.number]), 'onChange'),

  /**
   * The default value for the autocomplete's text field.
   */
  defaultValue: propTypes.oneOfType([propTypes.string, propTypes.number]),

  /**
   * An object key to use to extract the text to be compared for filtering.
   * This will only be applied if the given `data` prop is an array of objects.
   */
  dataLabel: propTypes.string.isRequired,

  /**
   * An optional object key to use to extract the `value` of the given `data` prop.
   * This is really only used with generating a unique react key. The unique react
   * key with either be:
   * - the datum if it is a string or number
   * - the `key` attribute of the datum object
   * - the `datum[dataValue]`
   * - or the `datum[dataLabel]`
   */
  dataValue: propTypes.string,

  /**
   * A single key or an array of keys to delete from your data object before passing
   * to the `ListItem` component.
   */
  deleteKeys: propTypes.oneOfType([propTypes.string, propTypes.arrayOf(propTypes.string)]),

  /**
   * The data that will be used for autocomplete suggestions. This can either be
   * an array of string, number, or object. If it is an array of objects, the key
   * `dataLabel` is required.
   *
   * ```docgen
   * PropTypes.arrayOf(PropTypes.oneOfType([
   *   PropTypes.element,
   *   PropTypes.string,
   *   PropTypes.number,
   *   PropTypes.shape({
   *     [dataLabel]: PropTypes.oneOfType([
   *       PropTypes.string,
   *       PropTypes.number,
   *       PropTypes.node,
   *     ]).isRequired,
   *   }),
   * ])).isRequired
   * ```
   */
  data: function data(props, propName, component) {
    for (var _len = arguments.length, others = Array(_len > 3 ? _len - 3 : 0), _key = 3; _key < _len; _key++) {
      others[_key - 3] = arguments[_key];
    }

    var _PropTypes$arrayOf;

    var dataLabel = props.dataLabel;

    return (_PropTypes$arrayOf = propTypes.arrayOf(propTypes.oneOfType([propTypes.element, propTypes.string, propTypes.number, propTypes.shape(defineProperty({}, dataLabel, propTypes.oneOfType([propTypes.string, propTypes.number, propTypes.node]).isRequired))]))).isRequired.apply(_PropTypes$arrayOf, [props, propName, component].concat(others));
  },

  /**
   * An optional number representing the total number of results in the `data` prop.
   * This should really only be used when the data is paginated. When this is set,
   * each item in the suggestion menu will be updated with the `aria-setsize` and
   * `aria-posinset`.
   *
   * @see {@link #offset}
   */
  total: invalidIf(propTypes.number, 'inline'),

  /**
   * An optional number representing the data's offset if the results were paginated.
   * This is used for accessibility with the `aria-posinset` attribute.
   *
   * @see {@link #total}
   */
  offset: propTypes.number.isRequired,

  /**
   * An optional function to use to filter the `data`. If you have a sexy backend
   * using solr or some other search/indexer, it is recommended to set this prop to
   * `null`.
   */
  filter: propTypes.func,

  /**
   * An optional function to call when the `Autocomplete`'s text field has a `keydown` event.
   */
  onKeyDown: propTypes.func,

  /**
   * An optional function to call when the `Autocomplete`'s text field has a `mousedown` event.
   */
  onMouseDown: propTypes.func,

  /**
   * An optional function to call when the `Autocomplete`'s text field value changes.
   * The callback will be given the new value and the change event.
   *
   * `onChange(textFeldValue, event)`
   */
  onChange: propTypes.func,

  /**
   * An optional function to call when the `Autocomplete`'s text field is focused.
   */
  onFocus: propTypes.func,

  /**
   * An optional function to call when the entire `Autocomplete` component is blurred.
   * This will be triggered when the window is clicked or when a user tabs away from
   * the autocomplete.
   */
  onBlur: propTypes.func,

  /**
   * Boolean if this text field should be styled as a full width text field.
   * Floating labels and the text field indicator will be removed automatically.
   */
  block: propTypes.bool,

  /**
   * Boolean if the autocomplete should span the entire width.
   */
  fullWidth: propTypes.bool,

  /**
   * Boolean if the `Autocomplete` should display suggestions inline instead
   * of in a `Menu`.
   */
  inline: propTypes.bool,

  /**
   * The amount of padding to use between the current text and the inline suggestion text.
   */
  inlineSuggestionPadding: propTypes.number.isRequired,

  /**
   * The function to call to find a suggestion for an inline autocomplete. This function
   * expects to return a single result of a number or a string.
   *
   * ```js
   * @param {Array<Object|String|Number>} data - The data prop to search.
   * @param {String} value - The current value to use for searching.
   * @param {String} dataLabel - The `dataLabel` prop to use if a datum is an object.
   * @return {String|Number} the found suggestion or false-ish
   * ```
   */
  findInlineSuggestion: propTypes.func,

  /**
   * An optional function to call when an autocomplete suggestion is clicked either
   * by using the mouse, the enter/space key, or touch. The match index and current
   * `dataLabel` will be given back.
   *
   * `onAutocomplete(suggestion, suggestionIndex, matches);`
   *
   * @see {@link #autocompleteWithLabel}
   */
  onAutocomplete: propTypes.func,

  /**
   * Boolean if the `onAutocomplete` should attempt send the `suggestion[dataLabel]` instead
   * of `suggestion[dataValue]` when the data is an object.
   *
   * @see {@link #onAutocomplete}
   */
  autocompleteWithLabel: propTypes.bool,

  /**
   * A boolean if the text field's value should be reset to the empty string when
   * an item is auto-completed. This is useful if you do not want a fully controlled
   * component and the values are stored outside of the `TextField`. (like `Chips`).
   */
  clearOnAutocomplete: propTypes.bool,

  /**
   * An optional function to call when the `Autocomplete` suggestion menu opens.
   */
  onMenuOpen: propTypes.func,

  /**
   * An optional function to call when the `Autocomplete` suggestion menu closes.
   */
  onMenuClose: propTypes.func,

  /**
   * This prop is used for disabling the browser's default autocomplete suggestions
   * of previously typed values in the text field. By default, this is disabled.
   */
  autoComplete: propTypes.oneOf(['on', 'off']),

  /**
   * Boolean if the `input` should be focused again after a suggestion was clicked.
   *
   * This is really only added for keyboard support and the fact that each of suggestions
   * are focusable.
   */
  focusInputOnAutocomplete: propTypes.bool,

  /**
   * This is how the menu's `List` gets anchored to the `toggle` element.
   *
   * @see {@link Helpers/Layover#anchor}
   */
  anchor: anchorShape,

  /**
   * This is the anchor to use when the `position` is set to `Autocomplete.Positions.BELOW`.
   *
   * @see {@link Helpers/Layover#belowAnchor}
   */
  belowAnchor: anchorShape,

  /**
   * This is the animation position for the list that appears.
   *
   * @see {@link Helpers/Layover#animationPosition}
   */
  position: positionShape,

  /**
   * This is how the menu's list will be "fixed" to the `toggle` component.
   *
   * @see {@link Helpers/Layover#fixedTo}
   */
  fixedTo: fixedToShape,

  /**
   * Boolean if the menu's list should appear horizontally instead of vertically.
   */
  listInline: propTypes.bool,

  /**
   * The list's z-depth for applying box shadow. This should be a number from 0 to 5.
   */
  listZDepth: propTypes.number,

  /**
   * Boolean if the list should have its height restricted to the `$md-menu-mobile-max-height`/
   * `$md-menu-desktop-max-height` values.
   *
   * @see [md-menu-mobile-max-height](/components/menus?tab=2#variable-md-menu-mobile-max-height)
   * @see [md-menu-desktop-max-height](/components/menus?tab=2#variable-md-menu-desktop-max-height)
   */
  listHeightRestricted: propTypes.bool,

  /**
   * @see {@link Helpers/Layover#xThreshold}
   */
  xThreshold: propTypes.number,

  /**
   * @see {@link Helpers/Layover#yThreshold}
   */
  yThreshold: propTypes.number,

  /**
   * @see {@link Helpers/Layover#closeOnOutsideClick}
   */
  closeOnOutsideClick: propTypes.bool,

  /**
   * An optional transition name to use for the list appearing/disappearing.
   *
   * @see {@link Helpers/Layover#transitionName}
   */
  transitionName: propTypes.string,

  /**
   * @see {@link Helpers/Layover#transitionEnterTimeout}
   */
  transitionEnterTimeout: propTypes.number,

  /**
   * @see {@link Helpers/Layover#transitionLeaveTimeout}
   */
  transitionLeaveTimeout: propTypes.number,

  /**
   * @see {@link Helpers/Layover#centered}
   */
  centered: Menu.propTypes.centered,

  /**
   * @see {@link Helpers/Layover#sameWidth}
   */
  sameWidth: Menu.propTypes.sameWidth,

  /**
   * Boolean if the menu should automatically try to reposition itself to stay within
   * the viewport when the `fixedTo` element scrolls.
   *
   * @see {@link Helpers/Layover#repositionOnScroll}
   */
  repositionOnScroll: propTypes.bool,

  /**
   * Boolean if the menu should automatically try to reposition itself to stay within
   * the viewport when the window resizes.
   *
   * @see {@link Helpers/Layover#repositionOnResize}
   */
  repositionOnResize: propTypes.bool,

  /**
   * Boolean if the menu logic should be simplified without any viewport logic and position
   * based on the relative position of the menu. This will most like require some additional
   * styles applied to the menu.
   *
   * @see {@link Helpers/Layover#simplified}
   */
  simplifiedMenu: propTypes.bool,

  /**
   * @see {@link Helpers/Layover#minLeft}
   */
  minLeft: propTypes.number,

  /**
   * @see {@link Helpers/Layover#minRight}
   */
  minRight: propTypes.number,

  /**
   * @see {@link Helpers/Layover#minBottom}
   */
  minBottom: propTypes.number,

  /**
   * @see {@link Helpers/Layover#fillViewportWidth}
   */
  fillViewportWidth: propTypes.bool,

  /**
   * @see {@link Helpers/Layover#fillViewportHeight}
   */
  fillViewportHeight: propTypes.bool,

  /**
   * @see {@link TextFields#toolbar}
   */
  toolbar: propTypes.bool
};
Autocomplete.defaultProps = {
  autocompleteWithLabel: false,
  position: Menu.Positions.BELOW,
  sameWidth: true,
  offset: 0,
  fullWidth: true,
  defaultValue: '',
  dataLabel: 'primaryText',
  filter: Autocomplete.fuzzyFilter,
  findInlineSuggestion: Autocomplete.findIgnoreCase,
  autoComplete: 'off',
  repositionOnScroll: true,
  repositionOnResize: true,
  inlineSuggestionPadding: 6
};

var _initialiseProps = function _initialiseProps() {
  var _this2 = this;

  this._close = function (e) {
    if (_this2.props.onBlur) {
      _this2.props.onBlur(e);
    }

    _this2.setState({ visible: false });
  };

  this._handleChange = function (value, event) {
    var _props2 = _this2.props,
        onChange = _props2.onChange,
        filter = _props2.filter,
        findInlineSuggestion = _props2.findInlineSuggestion,
        data = _props2.data,
        dataLabel = _props2.dataLabel,
        inline = _props2.inline;


    if (onChange) {
      onChange(value, event);
    }

    if (inline) {
      // If findInlineSuggestion does not exist, assume that `onChange` will handle it.
      return findInlineSuggestion ? _this2._findInlineSuggestions(value) : null;
    }

    var visible = _this2.state.visible;

    var matches = value || !filter ? _this2.state.matches : [];
    if (value && filter) {
      matches = filter(data, value, dataLabel);
    }

    if (filter) {
      visible = !!matches.length;
    }

    return _this2.setState({ matches: matches, visible: visible, value: value });
  };

  this._handleFocus = function (e) {
    if (_this2.props.onFocus) {
      _this2.props.onFocus(e);
    }

    var value = e.target.value;

    if (_this2.props.inline && value) {
      if (_this2.props.findInlineSuggestion) {
        _this2._findInlineSuggestions(value);
      }

      return;
    }

    _this2.setState({
      matchIndex: -1,
      visible: !_this2.state.manualFocus && !!value && !!_this2.state.matches.length,
      manualFocus: false,
      focus: true
    });
  };

  this._handleBlur = function (e) {
    if (_this2.props.inline || !_this2.state.matches.length) {
      if (_this2.props.onBlur) {
        _this2.props.onBlur(e);
      }
    }

    _this2.setState({ focus: false });
  };

  this._handleInlineAutocomplete = function () {
    var _state3 = _this2.state,
        suggestionIndex = _state3.suggestionIndex,
        matches = _state3.matches;

    if (suggestionIndex === -1) {
      return;
    }

    var _props3 = _this2.props,
        data = _props3.data,
        dataLabel = _props3.dataLabel,
        dataValue = _props3.dataValue,
        label = _props3.autocompleteWithLabel,
        onAutocomplete = _props3.onAutocomplete;


    var value = data[suggestionIndex];
    if (onAutocomplete) {
      var v = value;
      if ((typeof value === 'undefined' ? 'undefined' : _typeof(value)) === 'object') {
        if (!label) {
          v = value[dataValue];
        } else {
          v = value[dataLabel];
        }
      }

      onAutocomplete(v, suggestionIndex, matches);
    }

    if ((typeof value === 'undefined' ? 'undefined' : _typeof(value)) === 'object') {
      value = value[dataLabel];
    }

    _this2.setState({
      value: value,
      suggestion: '',
      suggestionIndex: -1,
      tabbed: true
    });
  };

  this._handleTextFieldKeyDown = function (e) {
    var _props4 = _this2.props,
        inline = _props4.inline,
        onKeyDown = _props4.onKeyDown;
    var suggestionIndex = _this2.state.suggestionIndex;


    var key = e.which || e.keyCode;
    if (onKeyDown) {
      onKeyDown(e);
    }

    if (inline && key === TAB && suggestionIndex !== -1) {
      // Autocomplete the text field
      e.preventDefault();
      _this2._handleInlineAutocomplete();
    }
  };

  this._handleMenuKeyDown = function (e) {
    var key = e.which || e.keyCode;
    if (key === TAB) {
      if (_this2.props.onBlur) {
        _this2.props.onBlur(e);
      }

      _this2.setState({ visible: false });
    } else if (key === UP || key === DOWN) {
      _this2._focusSuggestion(key === UP, e);
    }
  };

  this._handleClick = function (e) {
    var target = e.target;
    while (_this2._menu && _this2._menu.contains(target)) {
      if (target.classList.contains('md-list-item')) {
        var items = target.parentNode.querySelectorAll('.md-list-item');
        items = Array.prototype.slice.call(items);

        return _this2._handleItemClick(items.indexOf(target));
      }

      target = target.parentNode;
    }

    return null;
  };

  this._handleItemClick = function (index) {
    if (index === -1) {
      return;
    }

    var matches = _this2.state.matches;
    var _props5 = _this2.props,
        data = _props5.data,
        dataLabel = _props5.dataLabel,
        dataValue = _props5.dataValue,
        filter = _props5.filter,
        onAutocomplete = _props5.onAutocomplete,
        clearOnAutocomplete = _props5.clearOnAutocomplete,
        focusInputOnAutocomplete = _props5.focusInputOnAutocomplete,
        label = _props5.autocompleteWithLabel;


    var value = matches.filter(function (m) {
      return !React.isValidElement(m);
    })[index];
    if (onAutocomplete) {
      var v = value;
      if ((typeof v === 'undefined' ? 'undefined' : _typeof(v)) === 'object') {
        if (!label) {
          v = value[dataValue];
        } else {
          v = value[dataLabel];
        }
      }

      onAutocomplete(v, index, matches);
    }

    if ((typeof value === 'undefined' ? 'undefined' : _typeof(value)) === 'object') {
      value = value[dataLabel];
    }

    value = clearOnAutocomplete ? '' : value;
    var callback = void 0;
    if (focusInputOnAutocomplete) {
      callback = function callback() {
        _this2._field.focus();
      };
    }

    _this2.setState({
      visible: false,
      manualFocus: focusInputOnAutocomplete,
      matches: filter ? filter(data, value, dataLabel) : matches,
      value: value
    }, callback);
  };

  this._focusSuggestion = function (negative, e) {
    e.preventDefault();
    var _state4 = _this2.state,
        matchIndex = _state4.matchIndex,
        matches = _state4.matches;

    var l = matches.length;

    var index = void 0;
    if (negative && matchIndex === -1 || !negative && matchIndex >= l) {
      return;
    } else if (negative) {
      index = matchIndex - 1;
      if (index === -1) {
        _this2._field.focus();
      }
    } else {
      index = Math.min(l, matchIndex + 1);
    }

    if (index !== -1 && index !== matchIndex) {
      var item = _this2._menu.querySelectorAll('.md-list-tile')[index];
      if (item) {
        item.focus();
      }
    }

    _this2.setState({ matchIndex: index });
  };

  this._findInlineSuggestions = function (value) {
    var _props6 = _this2.props,
        data = _props6.data,
        dataLabel = _props6.dataLabel,
        findInlineSuggestion = _props6.findInlineSuggestion,
        inlineSuggestionPadding = _props6.inlineSuggestionPadding;


    var suggestion = findInlineSuggestion(data, value, dataLabel);
    if ((typeof suggestion === 'undefined' ? 'undefined' : _typeof(suggestion)) === 'object') {
      throw new Error('`findInlineSuggestion` should return a string or a number, but got an object.', suggestion);
    }

    var suggestionStyle = _this2.state.suggestionStyle;

    var suggestionIndex = -1;
    if (suggestion) {
      // Find index of suggestion
      data.some(function (datum, i) {
        var d = (typeof dataum === 'undefined' ? 'undefined' : _typeof(dataum)) === 'object' ? datum[dataLabel] : datum;
        if (d === suggestion) {
          suggestionIndex = i;
        }

        return suggestionIndex !== -1;
      });

      // Strip already used letters
      suggestion = suggestion.toString().substring(value.length, suggestion.length);

      // Position the inline suggestion next to the text
      var width = getTextWidth(value, _this2._field);
      if (width !== null) {
        width += inlineSuggestionPadding;
      }

      if (width !== null && (!suggestionStyle || suggestionStyle.left !== width)) {
        suggestionStyle = { left: width };
      }
    }

    _this2.setState({
      value: value,
      suggestion: suggestion,
      suggestionIndex: suggestionIndex,
      suggestionStyle: suggestionStyle,
      tabbed: false,
      focus: true
    });
  };

  this._mapToListItem = function (match, i) {
    if (React.isValidElement(match)) {
      return match;
    }

    var _props7 = _this2.props,
        dataLabel = _props7.dataLabel,
        dataValue = _props7.dataValue,
        deleteKeys = _props7.deleteKeys,
        total = _props7.total,
        offset = _props7.offset,
        data = _props7.data;

    var props = void 0;
    switch (typeof match === 'undefined' ? 'undefined' : _typeof(match)) {
      case 'string':
      case 'number':
        props = {
          key: match,
          primaryText: match
        };
        break;
      default:
        if (deleteKeys) {
          props = omit(match, typeof deleteKeys === 'string' ? [deleteKeys] : deleteKeys);
        } else {
          props = match;
        }

        props = _extends({}, props, {
          key: match.key || dataValue && match[dataValue] || match[dataLabel],
          primaryText: match[dataLabel]
        });
    }

    if (typeof total !== 'undefined' && data.length < total) {
      props['aria-setsize'] = total;
      props['aria-posinset'] = i + 1 + offset;
    }

    // Allows focus, but does not let tab focus. This is so up and down keys work.
    return React.createElement(ListItem, _extends({ tabIndex: -1 }, props));
  };

  this._toggleMenu = function (e) {
    if (_this2.props.onMouseDown) {
      _this2.props.onMouseDown(e);
    }

    if (!_this2.props.inline && _this2.state.matches.length && getField(_this2.props, _this2.state, 'value')) {
      _this2.setState({ visible: !_this2.state.visible });
    }
  };

  this._handleTouchStart = function (e) {
    var target = e.target;
    var suggestion = _this2.state.suggestion;

    if (target.classList.contains('md-autocomplete-suggestion') && suggestion) {
      _this2._handleInlineAutocomplete();
    }
  };

  this._setField = function (field) {
    if (field) {
      _this2._field = field.getField();
    }
  };

  this._setMenu = function (menu) {
    _this2._menu = findDOMNode(menu);
  };
};

/** @module utils/PropTypes/oneRequiredForA11yIf */

/**
 * A PropType validator to make sure that any of the other prop names have been defined
 * if the current prop is also defined.
 *
 * This is mostly useful for when adding a prop requires additional accessibility props defined
 * as well.
 *
 * @param {function} validator - The current prop's validator.
 */
function oneRequiredForA11yIf(validator) {
  for (var _len = arguments.length, otherPropNames = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
    otherPropNames[_key - 1] = arguments[_key];
  }

  return function validate(props, propName, componentName, location, propFullName) {
    var filterUndefined = function filterUndefined(pn) {
      return typeof props[pn] !== 'undefined';
    };
    var componentNameSafe = componentName || '<<anonymous>>';
    var propFullNameSafe = propFullName || propName;
    var defined = typeof props[propName] !== 'undefined';
    var allPropNames = [propFullNameSafe].concat(otherPropNames);

    for (var _len2 = arguments.length, args = Array(_len2 > 5 ? _len2 - 5 : 0), _key2 = 5; _key2 < _len2; _key2++) {
      args[_key2 - 5] = arguments[_key2];
    }

    var err = validator.apply(undefined, [props, propName, componentName, location, propFullName].concat(args));
    if (!err && defined && !allPropNames.filter(filterUndefined).length) {
      err = new Error('One of the following props are required to make `' + componentNameSafe + '` accessible ' + ('for users of assistive technologies such as screen readers when using the `' + propFullNameSafe + '` ') + ('prop. `' + allPropNames.join('`, `') + '`.'));
    }

    return err;
  };
}

/**
 * The avatar component is used to convert a `FontIcon`, an image, or
 * a letter into an avatar.
 *
 * Any other props given to the Avatar component such as event listeners
 * or styles will also be applied.
 */

var Avatar = function (_PureComponent) {
  inherits(Avatar, _PureComponent);

  function Avatar() {
    var _ref;

    var _temp, _this, _ret;

    classCallCheck(this, Avatar);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = possibleConstructorReturn(this, (_ref = Avatar.__proto__ || Object.getPrototypeOf(Avatar)).call.apply(_ref, [this].concat(args))), _this), _this.state = { color: null }, _this._setRandomColor = function () {
      var suffixes = _this.props.suffixes;


      var i = Math.floor(Math.random() * (suffixes.length - 1)) + 1;
      _this.setState({ color: suffixes[i] });
    }, _temp), possibleConstructorReturn(_this, _ret);
  }

  createClass(Avatar, [{
    key: 'componentWillMount',
    value: function componentWillMount() {
      if (this.props.random) {
        this._setRandomColor();
      }
    }
  }, {
    key: 'componentWillReceiveProps',
    value: function componentWillReceiveProps(nextProps) {
      if (nextProps.random && (this.props.src !== nextProps.src || this.props.icon !== nextProps.icon)) {
        this._setRandomColor();
      } else if (this.props.random && !nextProps.random) {
        this.setState({ color: null });
      }
    }
  }, {
    key: '_getColor',
    value: function _getColor(suffix, suffixes, color) {
      if (suffix) {
        return 'md-avatar--' + suffix;
      } else if (!!suffixes && !color) {
        return 'md-avatar--default';
      }

      return 'md-avatar--' + color;
    }
  }, {
    key: 'render',
    value: function render() {
      var _props = this.props,
          className = _props.className,
          contentStyle = _props.contentStyle,
          contentClassName = _props.contentClassName,
          src = _props.src,
          alt = _props.alt,
          icon = _props.icon,
          children = _props.children,
          suffix = _props.suffix,
          suffixes = _props.suffixes,
          iconSized = _props.iconSized,
          role = _props.role,
          random = _props.random,
          props = objectWithoutProperties(_props, ['className', 'contentStyle', 'contentClassName', 'src', 'alt', 'icon', 'children', 'suffix', 'suffixes', 'iconSized', 'role', 'random']);


      var content = void 0;
      if (src) {
        content = React.createElement('img', {
          src: src,
          alt: alt,
          role: role,
          style: contentStyle,
          className: classnames('md-avatar-img', contentClassName)
        });
      } else {
        content = React.createElement(
          'div',
          {
            style: contentStyle,
            className: classnames('md-avatar-content', contentClassName)
          },
          icon || children
        );
      }
      return React.createElement(
        'div',
        _extends({}, props, {
          className: classnames('md-inline-block md-avatar', this._getColor(suffix, suffixes, this.state.color), {
            'md-avatar--icon-sized': iconSized
          }, className)
        }),
        content
      );
    }
  }]);
  return Avatar;
}(PureComponent);

Avatar.propTypes = {
  /**
   * An optional className to apply to the avatar.
   */
  className: propTypes.string,

  /**
   * An optional style to apply to either the `<img>` or `<div>` surrounding the content. The `<img>` tag
   * will be used with the `src` prop is defined.
   */
  contentStyle: propTypes.object,

  /**
   * An optional className to apply to either the `<img>` or `<div>` surrounding the content. The `<img>` tag
   * will be used with the `src` prop is defined.
   */
  contentClassName: propTypes.string,

  /**
   * An optional image source to use for the avatar.
   */
  src: oneRequiredForA11yIf(propTypes.string, 'role', 'alt'),

  /**
   * An optional image alt to use for the avatar if it is
   * an image.
   */
  alt: propTypes.string,

  /**
   * An optional `FontIcon` to convert into an avatar.
   */
  icon: propTypes.node,

  /**
   * An optional letter to display in the avatar.
   */
  children: propTypes.node,

  /**
   * A boolean if a random color should be applied to the avatar.
   * This will be one of the `suffixes`.
   */
  random: propTypes.bool,

  /**
   * A list of available suffixes to use when generating a random
   * color for the avatar.
   */
  suffixes: propTypes.arrayOf(propTypes.string),

  /**
   * The suffix to use for a color. This can be any value but
   * *should* be one of the available `suffixes`.
   */
  suffix: propTypes.string,

  /**
   * Boolean if the `Avatar` should be sized to a `FontIcon` size. This
   * will just set the width and height to the `$md-font-icon-size`.
   */
  iconSized: propTypes.bool,

  /**
   * A role for the avatar's image. When the `src` prop is set, either a `role` of `presentation`
   * or the `alt` prop must be defined for a11y.
   */
  role: propTypes.oneOf(['presentation'])
};
Avatar.defaultProps = {
  suffixes: ['red', 'pink', 'purple', 'deep-purple', 'indigo', 'blue', 'light-blue', 'cyan', 'teal', 'green', 'light-green', 'lime', 'yellow', 'amber', 'orange', 'deep-orange', 'brown', 'grey', 'blue-grey']
};

/**
 * The main use case of the `Badge` component is for notifications. It can
 * however also place any content floating to whatever children are supplied.
 */

var Badge = function (_PureComponent) {
  inherits(Badge, _PureComponent);

  function Badge(props) {
    classCallCheck(this, Badge);

    var _this = possibleConstructorReturn(this, (Badge.__proto__ || Object.getPrototypeOf(Badge)).call(this, props));

    var single = _this._isSingleChild(props);
    _this.state = {
      single: single,
      element: single && isValidElement(props.children),
      count: _this._normalizeCount(props)
    };
    return _this;
  }

  createClass(Badge, [{
    key: 'componentWillReceiveProps',
    value: function componentWillReceiveProps(nextProps) {
      var _props = this.props,
          badgeContent = _props.badgeContent,
          max = _props.max,
          children = _props.children;

      var nextState = void 0;
      if (badgeContent !== nextProps.badgeContent || max !== nextProps.max) {
        nextState = { count: this._normalizeCount(nextProps) };
      }

      if (children !== nextProps.children) {
        nextState = nextState || {};
        nextState.single = this._isSingleChild(nextProps);
        nextState.element = nextState.single && isValidElement(nextProps.children);
      }

      if (nextState) {
        this.setState(nextState);
      }
    }
  }, {
    key: '_isSingleChild',
    value: function _isSingleChild(_ref) {
      var children = _ref.children;

      return Children.count(children) === 1;
    }
  }, {
    key: '_normalizeCount',
    value: function _normalizeCount(_ref2) {
      var badgeContent = _ref2.badgeContent,
          max = _ref2.max;

      var count = void 0;
      if (max) {
        var n = parseInt(badgeContent, 10);
        if (!Number.isNaN(n) && n.toString() === badgeContent.toString()) {
          count = n > max ? max + '+' : n;
        }
      }

      return count;
    }
  }, {
    key: 'render',
    value: function render() {
      var _state = this.state,
          count = _state.count,
          single = _state.single,
          element = _state.element;
      var _props2 = this.props,
          className = _props2.className,
          badgeStyle = _props2.badgeStyle,
          badgeClassName = _props2.badgeClassName,
          badgeContent = _props2.badgeContent,
          Component$$1 = _props2.component,
          children = _props2.children,
          primary = _props2.primary,
          secondary = _props2.secondary,
          defaultTheme = _props2.default,
          circular = _props2.circular,
          badgeId = _props2.badgeId,
          invisibleOnZero = _props2.invisibleOnZero,
          max = _props2.max,
          props = objectWithoutProperties(_props2, ['className', 'badgeStyle', 'badgeClassName', 'badgeContent', 'component', 'children', 'primary', 'secondary', 'default', 'circular', 'badgeId', 'invisibleOnZero', 'max']);


      var useCircular = typeof circular !== 'undefined' ? circular : typeof count !== 'undefined';
      var content = children;
      if (single && element) {
        var c = Children.only(content);
        if (!c.props['aria-describedby']) {
          content = cloneElement(c, { 'aria-describedby': badgeId });
        }
      } else if (single && !element && !props['aria-describedby']) {
        props['aria-describedby'] = badgeId;
      }

      var badge = React.createElement(
        'span',
        {
          id: badgeId,
          key: 'badge',
          role: 'status',
          style: badgeStyle,
          className: classnames('md-badge', {
            'md-badge--circular': useCircular,
            'md-badge--default': defaultTheme
          }, themeColors({
            primary: primary,
            secondary: secondary,
            text: useCircular,
            themeText: !primary && !secondary
          }, badgeClassName))
        },
        count || badgeContent
      );

      return React.createElement(
        Component$$1,
        _extends({}, props, {
          className: classnames('md-badge-container md-inline-block', className)
        }),
        content,
        invisibleOnZero && count === 0 ? null : badge
      );
    }
  }]);
  return Badge;
}(PureComponent);

Badge.propTypes = {
  /**
   * An optional style to apply to the badge's container.
   */
  style: propTypes.object,

  /**
   * An optional className to apply to the badge's container.
   */
  className: propTypes.string,

  /**
   * An optional style to apply to the badge.
   */
  badgeStyle: propTypes.object,

  /**
   * An optional className to apply to the badge.
   */
  badgeClassName: propTypes.string,

  /**
   * The id to give the badge's content. This is required to help with the
   * `aria-describedby` attribute that should be applied to one of the children.
   *
   * If there is only one child that is a valid React element, the `aria-describedby`
   * will automatically be cloned into that child (so make sure your component passes
   * that prop correctly).
   *
   * If there is only one child, but it is a string or number, the badge's container
   * will be updated to include the `aria-describedby`.
   *
   * If there is more than child, you are required to add it to a child yourself.
   */
  badgeId: isRequiredForA11y(propTypes.oneOfType([propTypes.number, propTypes.string])),

  /**
   * The content to display with the badge's content. The size of this
   * element is determinate of the location of the content. You might have
   * to update the positioning yourself.
   */
  children: propTypes.node.isRequired,

  /**
   * The component to render the badge as.
   */
  component: propTypes.oneOfType([propTypes.string, propTypes.func]).isRequired,

  /**
   * The content to display in the badge. If the content is a number or a number string,
   * the number will be normalized if `normalizeContent` is enabled.
   */
  badgeContent: propTypes.oneOfType([propTypes.number, propTypes.string, propTypes.node]).isRequired,

  /**
   * This will basically update the display value of the content to only be 2 digits. If
   * a number is greater than 99, 99+ will be displayed instead. This is really just to
   * keep the count inside the circular bubble.
   */
  max: propTypes.number,

  /**
   * Boolean if the primary color background should get applied to the badge's content.
   */
  primary: propTypes.bool,

  /**
   * Boolean if the secondary color background should get applied to the badge's content.
   */
  secondary: propTypes.bool,

  /**
   * Boolean if the default styles should be applied.
   */
  default: propTypes.bool,

  /**
   * Boolean if the badge's content should appear in a circular container. If this is
   * undefined, the content will be in a circular container if the badgeContent is a number.
   */
  circular: propTypes.bool,

  /**
   * Boolean if the badge's notification should be invisible when the count is 0.
   */
  invisibleOnZero: propTypes.bool
};
Badge.defaultProps = {
  max: 99,
  component: 'div'
};

var isReact16 = typeof createPortal === 'function';

/**
 * Creates a "Portal" for the children to be rendered in. Basically it will render the
 * children only when the `visible` prop is `true`. When it is visible, a new `component`
 * will be rendered as the first child in the body with the children inside.
 *
 * Unlike all the other components, `style` will not be applied for the `Portal`.
 */

var Portal = function (_PureComponent) {
  inherits(Portal, _PureComponent);

  function Portal() {
    var _ref;

    var _temp, _this, _ret;

    classCallCheck(this, Portal);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = possibleConstructorReturn(this, (_ref = Portal.__proto__ || Object.getPrototypeOf(Portal)).call.apply(_ref, [this].concat(args))), _this), _this._container = null, _this._portal = null, _this._applyStyles = function (props) {
      if (props.className) {
        _this._container.className = props.className;
      }
    }, _this._renderPortal = function (props) {
      if (!_this._container) {
        _this._container = document.createElement(props.component);

        _this._applyStyles(props);
        var node = props.renderNode || document.body;
        if (props.lastChild) {
          node.appendChild(_this._container);
        } else {
          node.insertBefore(_this._container, node.firstChild);
        }
      } else {
        _this._applyStyles(props);
      }

      if (!isReact16) {
        _this._portal = unstable_renderSubtreeIntoContainer(_this, props.children, _this._container);
      }
    }, _this._removePortal = function () {
      if (_this.props.onClose) {
        _this.props.onClose();
      }

      if (_this._container) {
        if (!isReact16) {
          unmountComponentAtNode(_this._container);
        }

        (_this.props.renderNode || document.body).removeChild(_this._container);
      }

      _this._portal = null;
      _this._container = null;
    }, _temp), possibleConstructorReturn(_this, _ret);
  }

  createClass(Portal, [{
    key: 'componentDidMount',
    value: function componentDidMount() {
      if (this.props.visible) {
        this._renderPortal(this.props);

        if (isReact16) {
          // Need to update after the renderPortal created the DOM element.
          this.forceUpdate();
        }
      }
    }
  }, {
    key: 'componentWillReceiveProps',
    value: function componentWillReceiveProps(nextProps) {
      var visible = nextProps.visible,
          onOpen = nextProps.onOpen;

      if (this.props.visible === visible) {
        if (visible && !isReact16) {
          // Need to just re-render the subtree
          this._renderPortal(nextProps);
        }

        return;
      }

      if (visible) {
        if (onOpen) {
          onOpen();
        }

        this._renderPortal(nextProps);
      } else {
        this._removePortal();
      }
    }
  }, {
    key: 'componentWillUnmount',
    value: function componentWillUnmount() {
      if (this.props.visible && this.props.onClose) {
        this.props.onClose();
      }
      this._removePortal();
    }
  }, {
    key: 'render',
    value: function render() {
      var _props = this.props,
          Component$$1 = _props.component,
          className = _props.className,
          children = _props.children,
          visible = _props.visible;

      // When doing server side rendering, actually render the component as a direct child of its parent.
      // Once it has been rendered and working client side, it will be removed correctly.

      if (typeof window === 'undefined' && visible) {
        return React.createElement(
          Component$$1,
          { className: className },
          children
        );
      } else if (isReact16 && visible && this._container && typeof window !== 'undefined') {
        return createPortal(children, this._container);
      }

      return null;
    }
  }]);
  return Portal;
}(PureComponent);

Portal.propTypes = {
  /**
   * An optional className to apply to the newly created `component` when visible.
   */
  className: propTypes.string,

  /**
   * Boolean if the children are visible.
   */
  visible: propTypes.bool.isRequired,

  /**
   * The children to render when visible.
   */
  children: propTypes.element,

  /**
   * The component to render as. This should be a valid DOM element.
   */
  component: propTypes.string.isRequired,

  /**
   * An optional function to call when the portal is opened.
   */
  onOpen: propTypes.func,

  /**
   * An optional function to call when the portal is closed
   */
  onClose: propTypes.func,

  /**
   * An optional DOM Node to render the portal into. The default is to render as
   * the first child in the `body`.
   */
  renderNode: propTypes.object,

  /**
   * Boolean if the portal should render the children as the last child of the `renderNode`
   * or `body` instead of the first.
   */
  lastChild: propTypes.bool
};
Portal.defaultProps = {
  component: 'span'
};

/** @module utils/NumberUtils/isBetween */

/**
 * Checks if a number is between a min and maximum (inclusive)
 *
 * @param {Number} num the number to check
 * @param {Number} min the minimum
 * @param {Number} max the maximum
 * @return {Boolean} true if the number is between the min and max (inclusive)
 */
function isBetween(num, min, max) {
  return num >= min && num <= max;
}

/** @module utils/PropTypes/between */

/**
 * Validates that a number is between a min and max value.
 *
 * @param {function} validator - The number validator to use.
 * @param {number} min - The min number to use.
 * @param {number} max - The max number to use.
 * @return {Error} the prop type error or null
 */
function between(validator, min, max) {
  return function validate(props, propName, componentName, location, propFullName) {
    var componentNameSafe = componentName || '<<anonymous>>';
    var propFullNameSafe = propFullName || propName;

    for (var _len = arguments.length, args = Array(_len > 5 ? _len - 5 : 0), _key = 5; _key < _len; _key++) {
      args[_key - 5] = arguments[_key];
    }

    var err = validator.apply(undefined, [props, propName, componentName, location, propFullName].concat(args));
    var value = props[propName];
    if (!err && typeof value !== 'undefined' && !isBetween(value, min, max)) {
      err = new Error('You provided a `' + propFullNameSafe + '` ' + location + ' to the ' + componentNameSafe + ' that was ' + ('not within the range from \'' + min + ' - ' + max + '\'. `' + propFullNameSafe + '`: ' + value + '.'));
    }

    return err;
  };
}

/**
 * The `Paper` component is a simple wrapper that adds box-shadow.
 *
 * You can also use the SCSS mixin instead of paper.
 *
 * ```scss
 * @include md-box-shadow(5);
 * ```
 */

var Paper = function (_PureComponent) {
  inherits(Paper, _PureComponent);

  function Paper() {
    classCallCheck(this, Paper);
    return possibleConstructorReturn(this, (Paper.__proto__ || Object.getPrototypeOf(Paper)).apply(this, arguments));
  }

  createClass(Paper, [{
    key: 'render',
    value: function render() {
      var _props = this.props,
          Component$$1 = _props.component,
          zDepth = _props.zDepth,
          className = _props.className,
          raiseOnHover = _props.raiseOnHover,
          props = objectWithoutProperties(_props, ['component', 'zDepth', 'className', 'raiseOnHover']);


      return React.createElement(Component$$1, _extends({}, props, {
        className: classnames('md-paper md-paper--' + zDepth, {
          'md-paper--0-hover': zDepth === 0 && raiseOnHover
        }, className)
      }));
    }
  }]);
  return Paper;
}(PureComponent);

Paper.propTypes = {
  /**
   * The component to render the paper as.
   */
  component: propTypes.oneOfType([propTypes.func, propTypes.string]).isRequired,

  /**
   * An optional className to apply.
   */
  className: propTypes.string,

  /**
   * The depth of the paper. This should be a number between 0 - 5. If
   * the depth is 0, it will raise to a depth of 3 on hover.
   */
  zDepth: between(propTypes.number.isRequired, 0, 5),

  /**
   * Any children to display in the paper.
   */
  children: propTypes.node,

  /**
   * Boolean if the paper should raise to the `zDepth` of `3` on hover when the initial
   * `zDepth` is `0`.
   */
  raiseOnHover: propTypes.bool
};
Paper.defaultProps = {
  zDepth: 1,
  component: 'div'
};

/**
 * The `BottomNav` component is used for rendering the navigation tab/link in the `BottomNavigation`
 * component.
 */

var BottomNav = function (_PureComponent) {
  inherits(BottomNav, _PureComponent);

  function BottomNav() {
    var _ref;

    var _temp, _this, _ret;

    classCallCheck(this, BottomNav);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = possibleConstructorReturn(this, (_ref = BottomNav.__proto__ || Object.getPrototypeOf(BottomNav)).call.apply(_ref, [this].concat(args))), _this), _this._handleClick = function (e) {
      var _this$props = _this.props,
          onClick = _this$props.onClick,
          onNavChange = _this$props.onNavChange,
          index = _this$props.index;

      if (onClick) {
        onClick(index, e);
      }

      if (onNavChange) {
        onNavChange(index, e);
      }
    }, _temp), possibleConstructorReturn(_this, _ret);
  }

  createClass(BottomNav, [{
    key: 'render',
    value: function render() {
      var _props = this.props,
          active = _props.active,
          fixed = _props.fixed,
          className = _props.className,
          colored = _props.colored,
          animate = _props.animate,
          iconClassName = _props.iconClassName,
          iconChildren = _props.iconChildren,
          index = _props.index,
          propIcon = _props.icon,
          propLabel = _props.label,
          onClick = _props.onClick,
          onNavChange = _props.onNavChange,
          props = objectWithoutProperties(_props, ['active', 'fixed', 'className', 'colored', 'animate', 'iconClassName', 'iconChildren', 'index', 'icon', 'label', 'onClick', 'onNavChange']);
      var _props2 = this.props,
          label = _props2.label,
          icon = _props2.icon;

      var labelClassName = classnames('md-bottom-nav-label', { 'md-bottom-nav-label--shifting-inactive': !active && !fixed });
      if (Children.count(label) === 1 && isValidElement(label)) {
        var labelEl = Children.only(label);
        label = cloneElement(label, {
          className: classnames(labelClassName, labelEl.props.className)
        });
      } else {
        label = React.createElement(
          'div',
          { className: labelClassName },
          label
        );
      }

      if (!icon && (iconClassName || iconChildren)) {
        // Deprecated
        icon = React.createElement(
          FontIcon,
          { iconClassName: iconClassName, inherit: true },
          iconChildren
        );
      } else if (icon) {
        icon = React.cloneElement(icon, { inherit: true });
      }

      return React.createElement(
        AccessibleFakeInkedButton,
        _extends({}, props, {
          onClick: this._handleClick,
          className: classnames('md-bottom-nav', {
            'md-bottom-nav--active': active,
            'md-bottom-nav--fixed': fixed,
            'md-bottom-nav--shifting': !fixed,
            'md-bottom-nav--shifting-active': !fixed && active,
            'md-bottom-nav--shifting-inactive': !fixed && !active
          }, themeColors({ primary: !colored && active, text: !active && !colored }, className))
        }),
        icon,
        React.createElement(
          Collapse,
          { collapsed: !fixed && !active, animate: animate },
          label
        )
      );
    }
  }]);
  return BottomNav;
}(PureComponent);

BottomNav.propTypes = {
  style: propTypes.object,
  className: propTypes.string,
  component: propTypes.oneOfType([propTypes.func, propTypes.string]),
  active: propTypes.bool,
  fixed: propTypes.bool,
  children: propTypes.node,
  index: propTypes.number.isRequired,
  label: propTypes.node.isRequired,
  colored: propTypes.bool,
  iconChildren: propTypes.node,
  iconClassName: propTypes.string,
  onClick: propTypes.func,
  onNavChange: propTypes.func,
  role: propTypes.string,
  animate: propTypes.bool,
  icon: propTypes.element
};
BottomNav.defaultProps = {
  component: 'a',
  role: null
};

/**
 * The `BottomNavigation` component is an alternative to the `NavigationDrawer` for handling navigation
 * only on mobile devices.
 */

var BottomNavigation = function (_PureComponent) {
  inherits(BottomNavigation, _PureComponent);

  function BottomNavigation(props) {
    classCallCheck(this, BottomNavigation);

    var _this = possibleConstructorReturn(this, (BottomNavigation.__proto__ || Object.getPrototypeOf(BottomNavigation)).call(this, props));

    _initialiseProps$5.call(_this);

    var visible = typeof props.initiallyVisible === 'boolean' ? props.initiallyVisible : props.defaultVisible;
    _this.state = {
      visible: visible,
      portalVisible: visible
    };

    if (typeof props.activeIndex === 'undefined') {
      _this.state.activeIndex = props.defaultActiveIndex;
    }
    return _this;
  }

  createClass(BottomNavigation, [{
    key: 'componentDidMount',
    value: function componentDidMount() {
      if (this.props.dynamic) {
        this._addTouchEvents();
      }
    }
  }, {
    key: 'componentWillReceiveProps',
    value: function componentWillReceiveProps(nextProps) {
      var dynamic = nextProps.dynamic;

      if (this.props.dynamic === dynamic) {
        return;
      }

      if (dynamic) {
        this._addTouchEvents();
      } else {
        this._removeTouchEvents();
      }
    }
  }, {
    key: 'componentWillUpdate',
    value: function componentWillUpdate(nextProps, nextState) {
      if (this.state.visible !== nextState.visible && nextProps.onVisibilityChange) {
        nextProps.onVisibilityChange(nextState.visible);
      }
    }
  }, {
    key: 'componentWillUnmount',
    value: function componentWillUnmount() {
      if (this.props.dynamic) {
        this._removeTouchEvents();
      }

      if (this._timeout) {
        clearTimeout(this._timeout);
      }
    }
  }, {
    key: 'render',
    value: function render() {
      var _this2 = this;

      var _state = this.state,
          visible = _state.visible,
          portalVisible = _state.portalVisible;
      var _props = this.props,
          className = _props.className,
          actions = _props.actions,
          colored = _props.colored,
          dynamic = _props.dynamic,
          lastChild = _props.lastChild,
          animate = _props.animate,
          portal = _props.portal,
          propLinks = _props.links,
          propActiveIndex = _props.activeIndex,
          propRenderNode = _props.renderNode,
          onNavChange = _props.onNavChange,
          onVisibilityChange = _props.onVisibilityChange,
          defaultVisible = _props.defaultVisible,
          defaultActiveIndex = _props.defaultActiveIndex,
          dynamicThreshold = _props.dynamicThreshold,
          transitionDuration = _props.transitionDuration,
          onChange = _props.onChange,
          initiallyVisible = _props.initiallyVisible,
          containerStyle = _props.containerStyle,
          containerClassName = _props.containerClassName,
          transitionName = _props.transitionName,
          transitionEnterTimeout = _props.transitionEnterTimeout,
          transitionLeaveTimeout = _props.transitionLeaveTimeout,
          props = objectWithoutProperties(_props, ['className', 'actions', 'colored', 'dynamic', 'lastChild', 'animate', 'portal', 'links', 'activeIndex', 'renderNode', 'onNavChange', 'onVisibilityChange', 'defaultVisible', 'defaultActiveIndex', 'dynamicThreshold', 'transitionDuration', 'onChange', 'initiallyVisible', 'containerStyle', 'containerClassName', 'transitionName', 'transitionEnterTimeout', 'transitionLeaveTimeout']);
      var links = this.props.links;

      if (actions) {
        links = actions;
      }

      var fixed = links.length === 3;
      var activeIndex = getField(this.props, this.state, 'activeIndex');
      var renderNode = getField(this.props, this.context, 'renderNode');
      var navigation = React.createElement(
        Paper,
        _extends({}, props, {
          key: 'navigation',
          className: classnames('md-bottom-navigation', {
            'md-background--card': !colored,
            'md-background--primary': colored,
            'md-bottom-navigation--dynamic': dynamic,
            'md-bottom-navigation--dynamic-inactive': dynamic && !visible
          }, className),
          role: 'navigation'
        }),
        links.map(function (action, index) {
          return React.createElement(BottomNav, _extends({}, action, {
            animate: animate,
            key: action.key || index,
            index: index,
            onNavChange: _this2._handleNavChange,
            active: activeIndex === index,
            colored: colored,
            fixed: fixed
          }));
        })
      );

      if (!portal) {
        return portalVisible ? navigation : null;
      }

      return React.createElement(
        Portal,
        { renderNode: renderNode, visible: portalVisible, lastChild: lastChild },
        navigation
      );
    }
  }]);
  return BottomNavigation;
}(PureComponent);

BottomNavigation.propTypes = {
  /**
   * An optional style to apply.
   */
  style: propTypes.object,

  /**
   * An optional className to apply.
   */
  className: propTypes.string,

  /**
   * A list of objects to generate a bottom navigation link. There must be at least 3 and no more
   * than 5 links. A link gets rendered as the `AccessibleFakeButton` component, so any additional
   * props in the link's shape will be passed along.
   *
   * ```docgen
   * PropTypes.arrayOf(PropTypes.shape({
   *   label: PropTypes.node.isRequired,
   *   icon: PropTypes.element,
   *   component: PropTypes.oneOfType([
   *      PropTypes.func,
   *      PropTypes.string,
   *   ]),
   * }).isRequired
   * ```
   */
  links: function links(props, propName, component) {
    for (var _len = arguments.length, args = Array(_len > 3 ? _len - 3 : 0), _key = 3; _key < _len; _key++) {
      args[_key - 3] = arguments[_key];
    }

    var _PropTypes$arrayOf;

    var links = props[propName] || props.actions;
    var len = links.length;

    if (len < 3) {
      return new Error('Only ' + len + ' `' + propName + '` were given to the ' + component + '. At least 3 are required.');
    } else if (len > 5) {
      return new Error(len + ' `' + propName + '` were given to the ' + component + '. No more than 5 may be given.');
    }

    return (_PropTypes$arrayOf = propTypes.arrayOf(propTypes.shape({
      label: propTypes.node.isRequired,
      icon: propTypes.element,
      iconChildren: deprecated(propTypes.node, 'Use `icon` instead'),
      iconClassName: deprecated(propTypes.string, 'Use `icon` instead'),
      component: propTypes.oneOfType([propTypes.func, propTypes.string])
    }))).isRequired.apply(_PropTypes$arrayOf, [props, propName, component].concat(args));
  },

  /**
   * Boolean if the bottom navigation should be colored with the primary color or whatever color
   * was a result of the `react-md-theme-bottom-navigations-colored` mixin.
   */
  colored: propTypes.bool,

  /**
   * Boolean if the bottom navigation should dynamically appear based on scrolling. When the user
   * scrolls the `dynamicThreshold` amount, this component will either disappear (scrolling down)
   * or appear (scrolling up).
   */
  dynamic: propTypes.bool,

  /**
   * The distance a user must scroll before the bottom navigation appears or disappears when it is `dynamic`.
   */
  dynamicThreshold: propTypes.number.isRequired,

  /**
   * An optional function to call when a link has been clicked. The callback will
   * include the new active index and the click event.
   *
   * ```js
   * onNavChange(newActiveIndex, event);
   * ```
   */
  onNavChange: propTypes.func,

  /**
   * An optional active index to use. This will make the component controlled and require the
   * `onNavChange` prop to be defined.
   */
  activeIndex: controlled(propTypes.number, 'onNavChange', 'defaultActiveIndex'),

  /**
   * The index for the link that is active by default.
   */
  defaultActiveIndex: propTypes.number.isRequired,

  /**
   * Boolean if the bottom navigation is visible by default. This *should* probably always
   * be true.
   */
  defaultVisible: propTypes.bool.isRequired,

  /**
   * The component to render the bottom navigation as.
   */
  component: propTypes.oneOfType([propTypes.func, propTypes.string]).isRequired,

  /**
   * Boolean if the Portal's functionality of rendering in a separate react tree should be applied
   * to the bottom navigation.
   *
   * @see {@link Helpers/Portal}
   */
  portal: propTypes.bool,

  /**
   * Since the `BottomNavigation` component uses the `Portal` component, you can pass an optional
   * HTML Node to render in.
   */
  renderNode: propTypes.object,

  /**
   * Boolean if the bottom navigation should render as the last child in the `renderNode` or `body`
   * instead of as the first.
   */
  lastChild: propTypes.bool,

  /**
   * The transition duration for the dynamic bottom navigation to appear or disappear. This should
   * match the `$md-bottom-navigation-transition-time` variable.
   */
  transitionDuration: propTypes.number.isRequired,

  /**
   * An optional function to call when the visibility of the bottom navigation changes. The callback
   * will include the new visibility.
   *
   * ```js
   * onVisibilityChange(!visible);
   * ```
   */
  onVisibilityChange: propTypes.func,

  /**
   * Boolean if the label on a shifting navigation should animate in and out.
   */
  animate: propTypes.bool,

  onChange: deprecated(propTypes.func, 'Use `onNavChange` instead'),
  initiallyVisible: deprecated(propTypes.bool, 'Use `defaultVisible` instead'),
  initialActiveIndex: deprecated(propTypes.number, 'Use `defaultActiveIndex` instead'),
  containerStyle: deprecated(propTypes.object, 'Use `style` instead'),
  containerClassName: deprecated(propTypes.string, 'Use `className` instead'),
  transitionName: deprecated(propTypes.string, 'There is no CSSTransitionGroup used anymore'),
  transitionEnterTimeout: deprecated(propTypes.number, 'Use `transitionDuration` instead'),
  transitionLeaveTimeout: deprecated(propTypes.number, 'Use `transitionDuration` instead'),
  actions: deprecated(propTypes.array, 'Use `links` instead')
};
BottomNavigation.defaultProps = {
  animate: true,
  defaultActiveIndex: 0,
  component: 'footer',
  defaultVisible: true,
  transitionDuration: 300,
  portal: false,
  dynamicThreshold: 5
};
BottomNavigation.contextTypes = {
  renderNode: propTypes.object
};

var _initialiseProps$5 = function _initialiseProps() {
  var _this3 = this;

  this._addTouchEvents = function () {
    addTouchEvent(window, 'start', _this3._handleTouchStart);
    addTouchEvent(window, 'move', _this3._handleTouchMove);
    addTouchEvent(window, 'end', _this3._handleTouchEnd);
  };

  this._removeTouchEvents = function () {
    removeTouchEvent(window, 'start', _this3._handleTouchStart);
    removeTouchEvent(window, 'move', _this3._handleTouchMove);
    removeTouchEvent(window, 'end', _this3._handleTouchEnd);
  };

  this._animateIn = function () {
    if (_this3._timeout) {
      clearTimeout(_this3._timeout);
    }

    _this3._timeout = setTimeout(function () {
      _this3._timeout = null;
      _this3.setState({ visible: true });
    }, 17);

    _this3.setState({ portalVisible: true });
  };

  this._animateOut = function () {
    if (_this3._timeout) {
      clearTimeout(_this3._timeout);
    }

    _this3._timeout = setTimeout(function () {
      _this3._timeout = null;
      _this3.setState({ portalVisible: false });
    }, _this3.props.transitionDuration);

    _this3.setState({ visible: false });
  };

  this._handleTouchStart = function (e) {
    var pageY = e.changedTouches[0].pageY;


    _this3._pageY = pageY;
    _this3._scrolling = true;
  };

  this._handleTouchMove = function (e) {
    var visible = _this3.state.visible;

    if (!_this3._scrolling) {
      return;
    }

    var touchY = e.changedTouches[0].pageY;
    var dynamicThreshold = _this3.props.dynamicThreshold;

    var passedThreshold = Math.abs(_this3._pageY - touchY) >= dynamicThreshold;
    if (_this3._pageY > touchY && visible && passedThreshold) {
      _this3._pageY = touchY;
      _this3._animateOut();
    } else if (_this3._pageY < touchY && !visible && passedThreshold) {
      _this3._pageY = touchY;
      _this3._animateIn();
    }
  };

  this._handleTouchEnd = function () {
    _this3._scrolling = false;
  };

  this._handleNavChange = function (index, e) {
    if (_this3.props.onNavChange || _this3.props.onChange) {
      (_this3.props.onNavChange || _this3.props.onChange)(index, e);
    }

    if (typeof _this3.props.activeIndex === 'undefined') {
      _this3.setState({ activeIndex: index });
    }
  };
};

/**
 * Since it can be helpful to apply button styles on other components, this is a utlity function
 * to apply those styles based on props.
 */
function getBtnStyles(_ref) {
  var _ref2;

  var flat = _ref.flat,
      raised = _ref.raised,
      icon = _ref.icon,
      floating = _ref.floating,
      disabled = _ref.disabled,
      primary = _ref.primary,
      secondary = _ref.secondary,
      hover = _ref.hover,
      swapTheming = _ref.swapTheming,
      pressed = _ref.pressed,
      mini = _ref.mini,
      fixed = _ref.fixed,
      fixedPosition = _ref.fixedPosition;

  var flatStyles = flat || icon;
  var raisedStyles = raised || floating;
  var textTheming = flatStyles && !swapTheming || raisedStyles && swapTheming;
  var backgroundTheming = (!disabled && raisedStyles && !swapTheming || flatStyles && swapTheming) && (primary || secondary);

  for (var _len = arguments.length, classNames = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
    classNames[_key - 1] = arguments[_key];
  }

  return classnames.apply(undefined, ['md-btn', (_ref2 = {
    'md-btn--flat': flat || disabled && raised,
    'md-btn--raised': !disabled && raised,
    'md-btn--icon': icon || floating,
    'md-btn--floating': floating,
    'md-btn--text': flat || raised,
    'md-btn--hover': !disabled && hover,
    'md-btn--raised-disabled': disabled && raised,
    'md-btn--raised-pressed': !disabled && raisedStyles && pressed,
    'md-btn--fixed': fixed
  }, defineProperty(_ref2, 'md-btn--fixed-' + fixedPosition, floating && fixed), defineProperty(_ref2, 'md-btn--floating-mini', floating && mini), defineProperty(_ref2, 'md-btn--color-primary-active', !disabled && primary && hover && textTheming), defineProperty(_ref2, 'md-btn--color-secondary-active', !disabled && secondary && hover && textTheming), defineProperty(_ref2, 'md-pointer--hover', !disabled), defineProperty(_ref2, 'md-paper md-paper--2', !disabled && floating), defineProperty(_ref2, 'md-paper--4', !disabled && floating && pressed), _ref2), themeColors({
    text: !icon && !floating && !backgroundTheming,
    themeText: !backgroundTheming,
    disabled: disabled,
    primary: primary,
    secondary: secondary,
    hover: true,
    ink: true
  })].concat(classNames));
}

/**
 * The `IconSeparator` component is a simple helper component to render some text and
 * an icon with some space between them while centering the text. The icon can either
 * come before or after the text.
 */

var IconSeparator = function (_PureComponent) {
  inherits(IconSeparator, _PureComponent);

  function IconSeparator() {
    classCallCheck(this, IconSeparator);
    return possibleConstructorReturn(this, (IconSeparator.__proto__ || Object.getPrototypeOf(IconSeparator)).apply(this, arguments));
  }

  createClass(IconSeparator, [{
    key: 'render',
    value: function render() {
      var _props = this.props,
          className = _props.className,
          labelStyle = _props.labelStyle,
          labelClassName = _props.labelClassName,
          component = _props.component,
          label = _props.label,
          iconBefore = _props.iconBefore,
          children = _props.children,
          props = objectWithoutProperties(_props, ['className', 'labelStyle', 'labelClassName', 'component', 'label', 'iconBefore', 'children']);


      var text = void 0;
      if (isValidElement(label)) {
        var labelProps = Children.only(label).props;
        text = cloneElement(label, {
          className: classnames('md-icon-text', labelClassName, labelProps.className),
          style: _extends({}, labelStyle, labelProps.style)
        });
      } else {
        text = React.createElement(
          'span',
          { style: labelStyle, className: classnames('md-icon-text', labelClassName) },
          label
        );
      }

      var Component$$1 = component;

      return React.createElement(
        Component$$1,
        _extends({}, props, { className: classnames('md-icon-separator', className) }),
        iconBefore && children,
        text,
        !iconBefore && children
      );
    }
  }]);
  return IconSeparator;
}(PureComponent);

IconSeparator.propTypes = {
  /**
   * An optional style to apply.
   */
  style: propTypes.object,

  /**
   * An optional className to apply.
   */
  className: propTypes.string,

  /**
   * An optional style to apply to the label.
   */
  labelStyle: propTypes.object,

  /**
   * An optional className to apply to the label.
   */
  labelClassName: propTypes.string,

  /**
   * The label to display.
   */
  label: propTypes.node.isRequired,

  /**
   * The icon to display.
   */
  children: propTypes.node.isRequired,

  /**
   * Boolean if the icon should appear before or after the text
   */
  iconBefore: propTypes.bool,

  /**
   * The component to be rendered as.
   */
  component: propTypes.oneOfType([propTypes.string, propTypes.func]).isRequired
};
IconSeparator.defaultProps = {
  component: 'div'
};

var Tooltip = function (_PureComponent) {
  inherits(Tooltip, _PureComponent);

  function Tooltip(props) {
    classCallCheck(this, Tooltip);

    var _this = possibleConstructorReturn(this, (Tooltip.__proto__ || Object.getPrototypeOf(Tooltip)).call(this, props));

    _this.state = {
      entering: false,
      leaving: false,
      active: false,
      visible: false
    };

    _this._timeout = null;
    return _this;
  }

  createClass(Tooltip, [{
    key: 'componentWillUnmount',
    value: function componentWillUnmount() {
      if (this._timeout) {
        clearTimeout(this._timeout);
      }
    }
  }, {
    key: 'componentWillEnter',
    value: function componentWillEnter(cb) {
      var _this2 = this;

      this._timeout = setTimeout(function () {
        _this2._timeout = setTimeout(function () {
          _this2._timeout = null;

          cb();
        }, _this2.props.enterTimeout);
        _this2.setState({ active: true });
      }, TICK);

      this.setState({ entering: true });
    }
  }, {
    key: 'componentDidEnter',
    value: function componentDidEnter() {
      this.setState({ entering: false, active: false, visible: true });
    }
  }, {
    key: 'componentWillLeave',
    value: function componentWillLeave(cb) {
      var _this3 = this;

      if (this._timeout) {
        clearTimeout(this._timeout);
      }

      this._timeout = setTimeout(function () {
        _this3._timeout = setTimeout(function () {
          _this3._timeout = null;

          cb();
        }, _this3.props.leaveTimeout);

        _this3.setState({ active: true, visible: false });
      }, TICK);

      this.setState({ leaving: true });
    }
  }, {
    key: 'render',
    value: function render() {
      var _state = this.state,
          active = _state.active,
          entering = _state.entering,
          leaving = _state.leaving,
          visible = _state.visible;
      var _props = this.props,
          style = _props.style,
          className = _props.className,
          children = _props.children,
          position = _props.position;


      var direction = position === 'top' || position === 'bottom' ? 'horizontal' : 'vertical';
      return React.createElement(
        'span',
        {
          style: style,
          className: classnames('md-tooltip md-tooltip--' + position + ' md-tooltip--' + direction, defineProperty({
            'md-tooltip--active': active,
            'md-tooltip--enter': entering,
            'md-tooltip--enter-active': entering && active,
            'md-tooltip--leave': leaving,
            'md-tooltip--leave-active': leaving && active
          }, 'md-tooltip--' + position + '-active', visible || entering && active), className)
        },
        children
      );
    }
  }]);
  return Tooltip;
}(PureComponent);

Tooltip.propTypes = {
  style: propTypes.object,
  className: propTypes.string,
  position: propTypes.oneOf(['top', 'right', 'bottom', 'left']),
  children: propTypes.node.isRequired,
  enterTimeout: propTypes.number,
  leaveTimeout: propTypes.number
};
Tooltip.defaultProps = {
  position: 'bottom',
  enterTimeout: 150,
  leaveTimeout: 150
};

function getContainer(tooltip) {
  return tooltip.parentNode;
}

var TooltipContainer = function (_PureComponent) {
  inherits(TooltipContainer, _PureComponent);

  function TooltipContainer() {
    var _ref;

    var _temp, _this, _ret;

    classCallCheck(this, TooltipContainer);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = possibleConstructorReturn(this, (_ref = TooltipContainer.__proto__ || Object.getPrototypeOf(TooltipContainer)).call.apply(_ref, [this].concat(args))), _this), _this.state = { visible: false }, _this._delayedTimeout = null, _this._unlinkTarget = function () {
      var target = _this._target;
      if (target) {
        removeTouchEvent(target, 'start', _this._showTooltip);
        removeTouchEvent(target, 'end', _this._hideTooltip);
        target.removeEventListener('mouseover', _this._showTooltip);
        target.removeEventListener('mouseleave', _this._hideTooltip);
        target.removeEventListener('keyup', _this._handleKeyUp);
        target.removeEventListener('blur', _this._hideTooltip);
      }
    }, _this._setTarget = function () {
      var container = _this._container;
      var target = _this.props.target;


      _this._unlinkTarget();

      if (typeof target === 'function') {
        target = target(container, _this);
      }
      target = target ? findDOMNode(target) : container;
      _this._target = target || null;

      if (target) {
        addTouchEvent(target, 'start', _this._showTooltip);
        addTouchEvent(target, 'end', _this._hideTooltip);
        target.addEventListener('mouseover', _this._showTooltip);
        target.addEventListener('mouseleave', _this._hideTooltip);
        target.addEventListener('keyup', _this._handleKeyUp);
        target.addEventListener('blur', _this._hideTooltip);
      }
    }, _this._setContainers = function (span) {
      if (span) {
        _this._container = _this.props.container(span.parentNode, _this);
      }
    }, _this._stopContextMenu = function (e) {
      e.preventDefault();
      window.removeEventListener('contextmenu', _this._stopContextMenu, true);
      captureNextEvent('click');
      _this.setState({ visible: true });
    }, _this._showTooltip = function (e) {
      if (e.type === 'mouseover' && _this._touched) {
        return;
      }

      if (e.type === 'touchstart') {
        _this._touched = true;

        window.addEventListener('contextmenu', _this._stopContextMenu, true);
        return;
      }

      var delay = _this.props.delay;

      if (_this._delayedTimeout) {
        clearTimeout(_this._delayedTimeout);
      }

      if (delay) {
        _this._delayedTimeout = setTimeout(function () {
          _this._delayedTimeout = null;

          _this.setState({ visible: true });
        }, delay);
      } else {
        _this.setState({ visible: true });
      }
    }, _this._hideTooltip = function (e) {
      if (_this._delayedTimeout) {
        clearTimeout(_this._delayedTimeout);
      }

      if (e.type === 'mouseover' && _this._touched) {
        return;
      }

      _this.setState({ visible: false });
    }, _this._handleKeyUp = function (e) {
      if ((e.which || e.keyCode) === TAB) {
        _this._showTooltip(e);
      }
    }, _temp), possibleConstructorReturn(_this, _ret);
  }

  createClass(TooltipContainer, [{
    key: 'componentDidMount',
    value: function componentDidMount() {
      this._setTarget();
    }
  }, {
    key: 'componentDidUpdate',
    value: function componentDidUpdate(prevProps) {
      if (this.props.target !== prevProps.target) {
        this._setTarget();
      }
    }
  }, {
    key: 'componentWillUnmount',
    value: function componentWillUnmount() {
      this._unlinkTarget();
      this._target = null;

      if (this._delayedTimeout) {
        clearTimeout(this._delayedTimeout);
      }
    }
  }, {
    key: 'render',
    value: function render() {
      var visible = this.state.visible;
      var _props = this.props,
          style = _props.style,
          className = _props.className,
          tooltipStyle = _props.tooltipStyle,
          tooltipClassName = _props.tooltipClassName,
          label = _props.label,
          position = _props.position,
          enterTimeout = _props.enterTimeout,
          leaveTimeout = _props.leaveTimeout;


      var tooltip = React.createElement(
        Tooltip,
        {
          key: 'tooltip',
          style: tooltipStyle,
          className: tooltipClassName,
          position: position,
          enterTimeout: enterTimeout,
          leaveTimeout: leaveTimeout
        },
        label
      );

      return React.createElement(
        TransitionGroup,
        {
          style: style,
          className: classnames('md-tooltip-container', className),
          component: 'div'
        },
        React.createElement('span', { ref: this._setContainers, 'aria-hidden': true }),
        visible ? tooltip : null
      );
    }
  }]);
  return TooltipContainer;
}(PureComponent);

TooltipContainer.propTypes = {
  style: propTypes.object,
  className: propTypes.string,
  tooltipStyle: propTypes.object,
  tooltipClassName: propTypes.string,
  label: propTypes.node.isRequired,
  position: Tooltip.propTypes.position,
  delay: propTypes.number,
  enterTimeout: Tooltip.propTypes.enterTimeout,
  leaveTimeout: Tooltip.propTypes.leaveTimeout,
  /**
   * A function that returns a DOM element that will be used as the tooltip's container.
   * A ref to the tooltip's DOM element will be passed into the function.
   */
  container: propTypes.func,
  /**
   * A component/element the tooltip should be linked to,
   * or a function that returns such a component/element.
   * A ref to the tooltip's container will be passed into the function.
   *
   * By default the tooltip's container will be used as the target.
   */
  target: propTypes.oneOfType([propTypes.object, propTypes.func])
};
TooltipContainer.defaultProps = {
  container: getContainer,
  delay: 0
};

/**
 * Takes any component and injects a tooltip container as a prop. The tooltip container
 * will add event listeners for touch, mouse, and keyboard events so that a tooltip will appear
 * in the ComposedComponent.
 *
 * If the `tooltipLabel` prop is omitted, the tooltip and event listeners will not
 * be included.
 *
 * ```js
 * @param {function} ComposedComponent the component to compose with the tooltip functionality.
 * @return {function} the ComposedComponent with a tooltip.
 * ```
 */
var injectTooltip = (function (ComposedComponent) {
  var _class, _temp2;

  return _temp2 = _class = function (_PureComponent) {
    inherits(TooltipedComponent, _PureComponent);

    function TooltipedComponent() {
      var _ref;

      var _temp, _this, _ret;

      classCallCheck(this, TooltipedComponent);

      for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      return _ret = (_temp = (_this = possibleConstructorReturn(this, (_ref = TooltipedComponent.__proto__ || Object.getPrototypeOf(TooltipedComponent)).call.apply(_ref, [this].concat(args))), _this), _this._composed = null, _this.getComposedComponent = function () {
        return _this._composed;
      }, _this._setComposedComponent = function (component) {
        _this._composed = component;
      }, _temp), possibleConstructorReturn(_this, _ret);
    }

    /**
     * Gets the composed component as a ref. This is useful if you need to access the ref of the
     * composed component instead of the `injectTooltip` HOC to use some publicly accessible methods.
     *
     * ```js
     * <SomeTooltippedComponent
     *   ref={tooltipHOC => {
     *     tooltipHOC.getComposedComponent().focus();
     *   }}
     * />
     * ```
     *
     * > NOTE: This can be `null`, so make sure to do a null check before using.
     */


    createClass(TooltipedComponent, [{
      key: 'render',
      value: function render() {
        var _props = this.props,
            tooltipLabel = _props.tooltipLabel,
            tooltipDelay = _props.tooltipDelay,
            tooltipPosition = _props.tooltipPosition,
            tooltipStyle = _props.tooltipStyle,
            tooltipClassName = _props.tooltipClassName,
            tooltipContainerStyle = _props.tooltipContainerStyle,
            tooltipContainerClassName = _props.tooltipContainerClassName,
            tooltipTransitionEnterTimeout = _props.tooltipTransitionEnterTimeout,
            tooltipTransitionLeaveTimeout = _props.tooltipTransitionLeaveTimeout,
            props = objectWithoutProperties(_props, ['tooltipLabel', 'tooltipDelay', 'tooltipPosition', 'tooltipStyle', 'tooltipClassName', 'tooltipContainerStyle', 'tooltipContainerClassName', 'tooltipTransitionEnterTimeout', 'tooltipTransitionLeaveTimeout']);


        if (tooltipLabel) {
          props.tooltip = React.createElement(TooltipContainer, {
            key: 'tooltipContainer',
            label: tooltipLabel,
            delay: tooltipDelay,
            position: tooltipPosition,
            enterTimeout: tooltipTransitionEnterTimeout,
            leaveTimeout: tooltipTransitionLeaveTimeout,
            style: tooltipContainerStyle,
            className: tooltipContainerClassName,
            tooltipStyle: tooltipStyle,
            tooltipClassName: tooltipClassName
          });
        }

        props.ref = this._setComposedComponent;

        return React.createElement(ComposedComponent, props);
      }
    }]);
    return TooltipedComponent;
  }(PureComponent), _class.displayName = getDisplayName(ComposedComponent, 'Tooltip'), _class.propTypes = {
    /**
     * An optional style to apply to the tooltip container.
     */
    tooltipContainerStyle: propTypes.object,

    /**
     * An optional className to apply to the tooltip container.
     */
    tooltipContainerClassName: propTypes.string,

    /**
     * An optional style to apply to the tooltip itself.
     */
    tooltipStyle: propTypes.object,

    /**
     * An optional className to the tooltip itself.
     */
    tooltipClassName: propTypes.string,

    /**
     * The tooltip to display. If omitted, the `tooltip` prop will not be injected.
     */
    tooltipLabel: propTypes.node,

    /**
     * The amount of delay before the tooltip will appear on hover, touch, or keyboard focus.
     */
    tooltipDelay: TooltipContainer.propTypes.delay,

    /**
     * The position that the tooltip should appear related to the composed component.
     */
    tooltipPosition: TooltipContainer.propTypes.position,

    /**
     * The transition time for the tooltip appearing.
     */
    tooltipTransitionEnterTimeout: TooltipContainer.propTypes.enterTimeout,

    /**
     * The transition time for the tooltip disappearing.
     */
    tooltipTransitionLeaveTimeout: TooltipContainer.propTypes.leaveTimeout
  }, _temp2;
});

/**
 * The `Button` component can either be a `FlatButton`, `RaisedButton`, `IconButton`, or a
 * `FloatingButton`.
 *
 * A `FlatButton` is a button with no depth on the screen that is ideally used in `Dialog`s
 * or `CardActions`. The text can be optionally styled with the `primary` or `secondary` colors.
 *
 * A `RaisedButton` is a button with some depth to help actions have more prominent in flat
 * layouts or layouts with varying content. The background can be styled by the light/dark theme,
 * or optionally the `primary` or `secondary` color.
 *
 * An `IconButton` is a button that just displays a `FontIcon` as the child in a circle.
 * The `FontIcon` can be optionally styled with the `primary` or `secondary` color.
 *
 * A `FloatingButton` is a special case. Woop
 */

var Button = function (_PureComponent) {
  inherits(Button, _PureComponent);

  function Button() {
    var _ref;

    var _temp, _this, _ret;

    classCallCheck(this, Button);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = possibleConstructorReturn(this, (_ref = Button.__proto__ || Object.getPrototypeOf(Button)).call.apply(_ref, [this].concat(args))), _this), _initialiseProps$6.call(_this), _temp), possibleConstructorReturn(_this, _ret);
  }

  createClass(Button, [{
    key: 'componentWillReceiveProps',
    value: function componentWillReceiveProps(nextProps) {
      if (this.props.disabled && !nextProps.disabled && this.state.hover) {
        this.setState({ hover: false });
      }
    }
  }, {
    key: 'componentWillUpdate',
    value: function componentWillUpdate(nextProps, nextState) {
      var _this2 = this;

      if (!this.state.pressed && nextState.pressed) {
        this._timeout = setTimeout(function () {
          _this2._timeout = null;
          if (_this2._attemptedBlur) {
            _this2._attemptedBlur = false;

            _this2.setState({ pressed: false });
          }
        }, 450);
      }
    }
  }, {
    key: 'componentWillUnmount',
    value: function componentWillUnmount() {
      if (this._timeout) {
        clearTimeout(this._timeout);
      }

      if (this._snackbarTimeout) {
        clearTimeout(this._snackbarTimeout);
      }

      window.removeEventListener('click', this._blur);
    }
  }, {
    key: 'render',
    value: function render() {
      var _props = this.props,
          className = _props.className,
          iconClassName = _props.iconClassName,
          iconChildren = _props.iconChildren,
          iconBefore = _props.iconBefore,
          href = _props.href,
          primary = _props.primary,
          secondary = _props.secondary,
          flat = _props.flat,
          raised = _props.raised,
          floating = _props.floating,
          mini = _props.mini,
          fixed = _props.fixed,
          fixedPosition = _props.fixedPosition,
          disabled = _props.disabled,
          component = _props.component,
          ink = _props.ink,
          tooltip = _props.tooltip,
          icon = _props.icon,
          forceIconSize = _props.forceIconSize,
          forceIconFontSize = _props.forceIconFontSize,
          type = _props.type,
          children = _props.children,
          swapTheming = _props.swapTheming,
          svg = _props.svg,
          propIconEl = _props.iconEl,
          label = _props.label,
          props = objectWithoutProperties(_props, ['className', 'iconClassName', 'iconChildren', 'iconBefore', 'href', 'primary', 'secondary', 'flat', 'raised', 'floating', 'mini', 'fixed', 'fixedPosition', 'disabled', 'component', 'ink', 'tooltip', 'icon', 'forceIconSize', 'forceIconFontSize', 'type', 'children', 'swapTheming', 'svg', 'iconEl', 'label']);
      var iconEl = this.props.iconEl;


      if (!href) {
        props.type = type;
      }

      var _state = this.state,
          pressed = _state.pressed,
          hover = _state.hover,
          snackbar = _state.snackbar,
          snackbarType = _state.snackbarType;

      var iconBtnType = icon || floating;

      var visibleChildren = void 0;
      if (!iconEl && !svg && (iconClassName || iconChildren || iconBtnType || label && children)) {
        var resolvedIconChildren = iconChildren;
        if (typeof iconChildren === 'undefined') {
          resolvedIconChildren = iconBtnType || label ? children : null;
        }

        iconEl = React.createElement(
          FontIcon,
          { iconClassName: iconClassName, forceSize: forceIconSize, forceFontSize: forceIconFontSize, inherit: true },
          resolvedIconChildren
        );
      } else if (iconEl || svg) {
        var el = React.Children.only(iconEl || children);
        iconEl = React.cloneElement(el, { inherit: !el.props.error });
      }

      if (!iconBtnType) {
        visibleChildren = label || children;
        if (iconEl) {
          visibleChildren = React.createElement(
            IconSeparator,
            { label: visibleChildren, iconBefore: iconBefore },
            iconEl
          );
        }
      } else {
        visibleChildren = iconEl;
      }

      var Component$$1 = component || (href ? 'a' : 'button');
      return React.createElement(
        Component$$1,
        _extends({}, props, {
          disabled: disabled,
          onTouchStart: this._handleTouchStart,
          onTouchEnd: this._handleTouchEnd,
          onMouseDown: this._handleMouseDown,
          onMouseUp: this._handleMouseUp,
          onKeyDown: this._handleKeyDown,
          onKeyUp: this._handleKeyUp,
          onMouseEnter: this._handleMouseEnter,
          onMouseLeave: this._handleMouseLeave,
          href: href,
          className: getBtnStyles({
            flat: flat,
            raised: raised,
            icon: icon,
            floating: floating,
            disabled: disabled,
            primary: primary,
            secondary: secondary,
            hover: hover,
            swapTheming: swapTheming,
            pressed: pressed,
            mini: mini,
            fixed: fixed,
            fixedPosition: fixedPosition
          }, defineProperty({
            'md-btn--tooltip': tooltip,
            'md-btn--snackbar-floating': snackbar
          }, 'md-btn--snackbar-floating-' + snackbarType + 'adjust', snackbar && snackbarType !== null), 'md-inline-block', className)
        }),
        ink,
        tooltip,
        visibleChildren
      );
    }
  }]);
  return Button;
}(PureComponent);

Button.propTypes = {
  /**
   * An optional style to apply to the button.
   */
  style: propTypes.object,

  /**
   * An optional className to apply to the button.
   */
  className: propTypes.string,

  /**
   * A boolean if the icon should appear before or after the text for a `FlatButton` or
   * a `RaisedButton`.
   */
  iconBefore: propTypes.bool,

  /**
   * Any children used to display the button. When the button type is `icon` or `floating`,
   * this can be used to render the `FontIcon` instead of the `iconChildren` prop.
   *
   * When the button type is `raised` or `flat`, this will be the label or any other elements
   * you'd like to display in the button. This can work hand-in-hand with the `iconClassName`
   * and `iconChildren` to make a button with an icon and text.
   */
  children: propTypes.node,

  /**
   * An icon className to use in an optional `FontIcon` in any version of the button. This will
   * be used with the `children` prop. If the `floating` or `icon` props are set to true, this or
   * the children are required.
   *
   * @see {@link #iconEl}
   */
  iconClassName: propTypes.string,

  /**
   * Any children to use to display an icon in the button.
   *
   * @see {@link #iconEl}
   */
  iconChildren: propTypes.node,

  /**
   * An optional icon to display. This prop is recommended over the `iconClassName` and `iconChildren`
   * props since it allows more control for you. There is also better SVG support since it won't wrap
   * the SVG with the `FontIcon` element.
   */
  iconEl: propTypes.element,

  /**
   * The type for the button. This is required when the `component` prop is not
   * the 'a' tag, a `function`, or when the `href` prop is defined.
   */
  type: function type(props, propName, component) {
    for (var _len2 = arguments.length, args = Array(_len2 > 3 ? _len2 - 3 : 0), _key2 = 3; _key2 < _len2; _key2++) {
      args[_key2 - 3] = arguments[_key2];
    }

    var c = props.component;
    var validator = propTypes.oneOf(['button', 'submit', 'reset']);
    if (!props.href && c !== 'a' && typeof c !== 'function') {
      validator = validator.isRequired;
    }

    return validator.apply(undefined, [props, propName, component].concat(args));
  },

  /**
   * Boolean if the button should be styled with the primary color.
   */
  primary: propTypes.bool,

  /**
   * Boolean if the button should be styled with the secondary color.
   */
  secondary: propTypes.bool,

  /**
   * Boolean if the button is disabled.
   */
  disabled: propTypes.bool,

  /**
   * An optional href for the button. This will style the `a` tag as a button.
   */
  href: propTypes.string,

  /**
   * An optional component to render the button as. This allows you to get all the styles and functionality
   * of the Button, but as a custom React component.
   */
  component: propTypes.oneOfType([propTypes.string, propTypes.func]),

  /**
   * An optional function to call when the `click` event is triggered.
   */
  onClick: propTypes.func,

  /**
   * An optional function to call when the `touchstart` event is triggered.
   */
  onTouchStart: propTypes.func,

  /**
   * An optional function to call when the `touchend` event is triggered.
   */
  onTouchEnd: propTypes.func,

  /**
   * An optional function to call when the `mousedown` event is triggered.
   */
  onMouseDown: propTypes.func,

  /**
   * An optional function to call when the `mouseup` event is triggered.
   */
  onMouseUp: propTypes.func,

  /**
   * An optional function to call when the `keyup` event is triggered.
   */
  onKeyUp: propTypes.func,

  /**
   * An optional function to call when the `keydown` event is triggered.
   */
  onKeyDown: propTypes.func,

  /**
   * An optional function to call when the `mouseenter` event is triggered.
   */
  onMouseEnter: propTypes.func,

  /**
   * An optional function to call when the `mouseleave` event is triggered.
   */
  onMouseLeave: propTypes.func,

  /**
   * Boolean if the `FloatingButton` should be fixed to the page. This prop can
   * only be enabled if the `floating` prop is true.
   */
  fixed: invalidIf(propTypes.bool, 'flat', 'raised', 'icon'),

  /**
   * The position that the `FloatingButton` should be fixed to the page. It will
   * either be fixed to the top right, top left, bottom right, or bottom left of
   * the page. This prop is only used if the `floating` prop and `fixed` prop are
   * `true`.
   */
  fixedPosition: propTypes.oneOf(['tr', 'tl', 'br', 'bl']).isRequired,

  /**
   * Boolean if the `FloatingButton` should be `mini`. This prop can only be used
   * when the `floating` prop is true.
   */
  mini: invalidIf(propTypes.bool, 'flat', 'raised', 'icon'),

  /**
   * Boolean if the `Button` should be styled as a `FlatButton`.
   */
  flat: propTypes.bool,

  /**
   * Boolean if the `Button` should be styled as a `RaisedButton`.
   */
  raised: propTypes.bool,

  /**
   * Boolean if the `Button` should be styled as a `IconButton`.
   *
   * @see {@link #svg}
   */
  icon: propTypes.bool,

  /**
   * Boolean if the `Button` should be styled as a `FloatingButton`.
   *
   * @see {@link #svg}
   */
  floating: propTypes.bool,

  /**
   * Boolean if the theming of `primary` or `secondary` should be swapped. By default,
   * only flat and icon buttons can gain the theme colors as text color while the raised
   * and floating buttons can gain the theme colors as background color.
   *
   * If this prop is enabled, the flat and icon buttons will gain the theme background colors
   * while the raised and icon will gain the theme text colors instead.
   *
   * @see {@link #primary}
   * @see {@link #secondary}
   */
  swapTheming: propTypes.bool,

  /**
   * An optional label to use for the tooltip. This is normally only used for
   * `IconButton`s or `FloatingButton`s, but can be used on `FlatButton`s and
   * `RaisedButton`s if you wish. Knock yourself out!
   *
   * If this prop is omitted, no tooltip will be included.
   */
  tooltipLabel: propTypes.node,

  /**
   * An optional delay before the tooltip appears on mouse over.
   */
  tooltipDelay: propTypes.number,

  /**
   * The position for the tooltip.
   */
  tooltipPosition: propTypes.oneOf(['top', 'right', 'bottom', 'left']),

  /**
   * An ink from `injectInk`.
   * @access private
   */
  ink: propTypes.node,

  /**
   * A tooltip from `injectTooltip`
   * @access private
   */
  tooltip: propTypes.node,

  /**
   * Custom validator for verifying that only one type is defined and that
   * at one type is defined.
   */
  _typeValidator: function _typeValidator(props, propName, component) {
    var flat = props.flat,
        raised = props.raised,
        icon = props.icon,
        floating = props.floating;


    var defined = [raised, flat, icon, floating].filter(function (d) {
      return d;
    });
    var len = defined.length;
    if (len === 0) {
      return new Error('A material design button type must be specified in the `' + component + '` but none were ' + 'given. Valid types are `flat`, `raised`, `icon`, or `floating`.');
    } else if (len !== 1) {
      return new Error('Only one material design button type may be specified in the `' + component + '` but `' + len + '` ' + 'were given. Select only one of `flat`, `raised`, `icon`, or `floating`.');
    }

    return null;
  },

  /**
   * Either a boolean that will enforce the 24x24 size of the font icon or a number of the size
   * to enforce. This is useful when using other font icon libraries that do not have a consistent
   * size.
   */
  forceIconSize: FontIcon.propTypes.forceSize,

  /**
   * Boolean if the `forceIconSize` prop should also force the `font-size` instead of only `width` and `height`.
   */
  forceIconFontSize: propTypes.bool,

  /**
   * Boolean if the child is an SVGIcon or FontIcon when using the `icon` or `floating` props. This is only needed
   * until the next release when the `label` migration can be removed.
   */
  svg: propTypes.bool,

  label: deprecated(propTypes.node, 'Use the `children` prop instead'),
  noIcon: deprecated(propTypes.bool, 'This has been removed during the alpha release. Children will always attempt to be rendered outside of an ' + 'icon by default for flat and raised buttons')
};
Button.defaultProps = {
  type: 'button',
  iconBefore: true,
  fixedPosition: 'br'
};

var _initialiseProps$6 = function _initialiseProps() {
  var _this3 = this;

  this.state = {
    pressed: false,
    snackbar: false,
    snackbarType: null
  };

  this._blur = function () {
    if (_this3.props.disabled) {
      return;
    }

    if (_this3._timeout) {
      _this3._attemptedBlur = true;
    } else {
      _this3.setState({ pressed: false });
    }
  };

  this._handleMouseUp = function (e) {
    if (_this3.props.onMouseUp) {
      _this3.props.onMouseUp(e);
    }

    _this3._blur();
  };

  this._handleMouseDown = function (e) {
    if (_this3.props.onMouseDown) {
      _this3.props.onMouseDown(e);
    }

    if (!_this3.props.disabled) {
      _this3.setState({ pressed: true });
    }
  };

  this._handleTouchStart = function (e) {
    if (_this3.props.onTouchStart) {
      _this3.props.onTouchStart(e);
    }

    if (!_this3.props.disabled) {
      _this3.setState({ pressed: true });
    }
  };

  this._handleTouchEnd = function (e) {
    if (_this3.props.onTouchEnd) {
      _this3.props.onTouchEnd(e);
    }

    _this3._blur();
    captureNextEvent('mouseover');
  };

  this._handleKeyUp = function (e) {
    if (_this3.props.onKeyUp) {
      _this3.props.onKeyUp(e);
    }

    if ((e.which || e.keyCode) === TAB) {
      window.addEventListener('click', _this3._blur);
      _this3.setState({ pressed: true });
    }
  };

  this._handleKeyDown = function (e) {
    if (_this3.props.onKeyDown) {
      _this3.props.onKeyDown(e);
    }

    if ((e.which || e.keyCode) === TAB) {
      window.removeEventListener('click', _this3._blur);
      _this3.setState({ pressed: false });
    }
  };

  this._handleMouseEnter = function (e) {
    if (_this3.props.onMouseEnter) {
      _this3.props.onMouseEnter(e);
    }

    if (!_this3.props.disabled) {
      _this3.setState({ hover: true });
    }
  };

  this._handleMouseLeave = function (e) {
    if (_this3.props.onMouseLeave) {
      _this3.props.onMouseLeave(e);
    }

    if (!_this3.props.disabled) {
      _this3.setState({ hover: false });
    }
  };

  this._animateForSnackbar = function (multiline, leaveTimeout) {
    if (typeof leaveTimeout === 'number') {
      _this3._snackbarTimeout = setTimeout(function () {
        _this3._snackbarTimeout = setTimeout(function () {
          _this3._snackbarTimeout = null;

          _this3.setState({ snackbar: false });
        }, leaveTimeout + 150);

        _this3.setState({ snackbarType: null });
      }, TICK);
    } else {
      _this3._snackbarTimeout = setTimeout(function () {
        _this3._snackbarTimeout = null;

        _this3.setState({ snackbar: true, snackbarType: multiline ? 'multiline-' : '' });
      }, TICK);
    }
  };
};

var Button$1 = injectInk(injectTooltip(Button));

var contextTypes = {
  onExpandClick: propTypes.func,
  expanded: propTypes.bool,
  icon: propTypes.element,
  tooltipPosition: propTypes.oneOf(['top', 'right', 'bottom', 'left']),
  tooltipLabel: propTypes.node,
  tooltipDelay: propTypes.number
};

var Card = function (_PureComponent) {
  inherits(Card, _PureComponent);

  function Card(props) {
    classCallCheck(this, Card);

    var _this = possibleConstructorReturn(this, (Card.__proto__ || Object.getPrototypeOf(Card)).call(this, props));

    _this._handleMouseOver = function (e) {
      if (_this.props.onMouseOver) {
        _this.props.onMouseOver(e);
      }

      if (_this.props.raise && !_this._touched) {
        _this.setState({ zDepth: 4 });
      }
    };

    _this._handleMouseLeave = function (e) {
      if (_this.props.onMouseLeave) {
        _this.props.onMouseLeave(e);
      }

      _this._touched = false;
      if (_this.props.raise && _this.state.zDepth !== 1) {
        _this.setState({ zDepth: 1 });
      }
    };

    _this._handleTouchStart = function (e) {
      if (_this.props.onTouchStart) {
        _this.props.onTouchStart(e);
      }

      _this._touched = true;
    };

    _this._handleExpandClick = function (e) {
      var onExpanderClick = _this.props.onExpanderClick;

      var expanded = !getField(_this.props, _this.state, 'expanded');
      if (onExpanderClick) {
        onExpanderClick(expanded, e);
      }

      if (typeof _this.props.expanded === 'undefined') {
        _this.setState({ expanded: expanded });
      }
    };

    _this.state = {
      zDepth: 1,
      expanded: typeof props.initiallyExpanded !== 'undefined' ? props.initiallyExpanded : !!props.defaultExpanded
    };
    return _this;
  }

  createClass(Card, [{
    key: 'getChildContext',
    value: function getChildContext() {
      var _props = this.props,
          expanderTooltipLabel = _props.expanderTooltipLabel,
          expanderTooltipDelay = _props.expanderTooltipDelay,
          expanderTooltipPosition = _props.expanderTooltipPosition,
          expanderIcon = _props.expanderIcon,
          iconClassName = _props.iconClassName,
          iconChildren = _props.iconChildren,
          expanderIconClassName = _props.expanderIconClassName,
          expanderIconChildren = _props.expanderIconChildren;


      var expanded = typeof this.props.isExpanded !== 'undefined' ? this.props.isExpanded : getField(this.props, this.state, 'expanded');

      return {
        expanded: expanded,
        onExpandClick: this._handleExpandClick,
        icon: getDeprecatedIcon(iconChildren || expanderIconChildren, iconClassName || expanderIconClassName, expanderIcon),
        tooltipLabel: expanderTooltipLabel,
        tooltipDelay: expanderTooltipDelay,
        tooltipPosition: expanderTooltipPosition
      };
    }
  }, {
    key: 'render',
    value: function render() {
      var zDepth = this.state.zDepth;
      var _props2 = this.props,
          className = _props2.className,
          raise = _props2.raise,
          tableCard = _props2.tableCard,
          children = _props2.children,
          animate = _props2.animate,
          propExpanded = _props2.expanded,
          onExpanderClick = _props2.onExpanderClick,
          defaultExpanded = _props2.defaultExpanded,
          expanderIcon = _props2.expanderIcon,
          expanderIconChildren = _props2.expanderIconChildren,
          expanderIconClassName = _props2.expanderIconClassName,
          expanderTooltipLabel = _props2.expanderTooltipLabel,
          expanderTooltipDelay = _props2.expanderTooltipDelay,
          expanderTooltipPosition = _props2.expanderTooltipPosition,
          iconChildren = _props2.iconChildren,
          iconClassName = _props2.iconClassName,
          isExpanded = _props2.isExpanded,
          initiallyExpanded = _props2.initiallyExpanded,
          props = objectWithoutProperties(_props2, ['className', 'raise', 'tableCard', 'children', 'animate', 'expanded', 'onExpanderClick', 'defaultExpanded', 'expanderIcon', 'expanderIconChildren', 'expanderIconClassName', 'expanderTooltipLabel', 'expanderTooltipDelay', 'expanderTooltipPosition', 'iconChildren', 'iconClassName', 'isExpanded', 'initiallyExpanded']);


      var expanded = typeof this.props.isExpanded !== 'undefined' ? this.props.isExpanded : getField(this.props, this.state, 'expanded');
      var expanderIndex = -1;
      var parts = Children.map(Children.toArray(children), function (child, i) {
        if (!child || !child.props) {
          return child;
        } else if (expanderIndex < 0 && (child.props.isExpander || child.props.expander)) {
          expanderIndex = i;
        }

        if (!child.props.expandable) {
          return child;
        }

        var collapsed = expanderIndex === -1 || expanderIndex === i || !expanded;
        return React.createElement(
          Collapse,
          { collapsed: collapsed, animate: animate },
          child
        );
      });

      return React.createElement(
        Paper,
        _extends({}, props, {
          zDepth: zDepth,
          className: classnames('md-card', {
            'md-card--raise': raise,
            'md-card--table': tableCard
          }, 'md-background--card', className),
          onMouseOver: this._handleMouseOver,
          onMouseLeave: this._handleMouseLeave,
          onTouchStart: this._handleTouchStart
        }),
        parts
      );
    }
  }]);
  return Card;
}(PureComponent);

Card.propTypes = {
  /**
   * An optional style to apply.
   */
  style: propTypes.object,

  /**
   * An optional className to apply to the card.
   */
  className: propTypes.string,

  /**
   * Any Card parts that should be rendered.
   */
  children: propTypes.node,

  /**
   * Boolean if the card is expanded by default when there is an expander
   * component.
   */
  defaultExpanded: propTypes.bool,

  /**
   * Boolean if the card should raise on hover when on a desktop display.
   */
  raise: propTypes.bool,

  /**
   * Boolean if the card is currently expanded. This will require the `onExpanderClick` function
   * to toggle the state. The card will become controlled if this is not `undefined`.
   */
  expanded: controlled(propTypes.bool, 'onExpanderClick', 'defaultExpanded'),

  /**
   * An optional function to call when the expander is clicked.
   */
  onExpanderClick: propTypes.func,

  /**
   * The icon to use for the expander button. It is recommended to use this prop over
   * the `expaderIconChildren` and `expanderIconClassName` since it provides more control.
   */
  expanderIcon: propTypes.element,

  /**
   * The tooltip position for the expander icon.
   */
  expanderTooltipPosition: propTypes.oneOf(['top', 'right', 'bottom', 'left']),

  /**
   * The optional tooltip to display for the expander icon.
   */
  expanderTooltipLabel: propTypes.node,

  /**
   * An optional delay before the tooltip appears for the expander icon on hover.
   */
  expanderTooltipDelay: propTypes.number,

  /**
   * Boolean if the card contains a table. It will update the styling accordingly.
   * When using the `DataTable` component, do not wrap it in a `CardText` component.
   *
   * ```js
   * <Card tableCard={true}>
   *   <CardTitle title="Example />
   *   <DataTable>
   *     ...
   *   </DataTable>
   * </Card>
   * ```
   */
  tableCard: propTypes.bool,

  /**
   * An optional function to call when the mouseover event is triggered.
   */
  onMouseOver: propTypes.func,

  /**
   * An optional function to call when the mouseleave event is triggered.
   */
  onMouseLeave: propTypes.func,

  /**
   * An optional function to call when the touchstart event is triggered.
   */
  onTouchStart: propTypes.func,

  /**
   * Boolean if the card expansion should be animated.
   */
  animate: propTypes.bool,

  expanderIconClassName: deprecated(propTypes.string, 'Use `expanderIcon` instead'),
  expanderIconChildren: deprecated(propTypes.node, 'Use `expanderIcon` instead'),
  initiallyExpanded: deprecated(propTypes.bool, 'Use `defaultExpanded` instead'),
  isExpanded: deprecated(propTypes.bool, 'Use `expanded` instead'),
  iconChildren: deprecated(propTypes.node, 'Use the `expanderIconChildren` prop instead'),
  iconClassName: deprecated(propTypes.string, 'Use the `expanderIconClassName` prop instead')
};
Card.defaultProps = {
  animate: true,
  expanderIcon: React.createElement(
    FontIcon,
    null,
    'keyboard_arrow_down'
  ),
  expanderTooltipPosition: 'left'
};
Card.childContextTypes = contextTypes;

/**
 * The CardExpander component is just a simple `IconButton` that
 * gets generated through the `Card`'s `contextTypes`. Props are not used
 * at all.
 *
 * Any component below a component that has this component inject into it
 * and has the prop `expandable={true}` will be toggleable when this is clicked.
 *
 * You can manually inject the `CardExpander` component yourself if you want to
 * use a component that is not a `CardActions` or a `CardTitle`.
 */

var CardExpander = function (_Component) {
  inherits(CardExpander, _Component);

  function CardExpander() {
    classCallCheck(this, CardExpander);
    return possibleConstructorReturn(this, (CardExpander.__proto__ || Object.getPrototypeOf(CardExpander)).apply(this, arguments));
  }

  createClass(CardExpander, [{
    key: 'render',
    value: function render() {
      var _context = this.context,
          expanded = _context.expanded,
          onExpandClick = _context.onExpandClick,
          icon = _context.icon,
          tooltipPosition = _context.tooltipPosition,
          tooltipLabel = _context.tooltipLabel,
          tooltipDelay = _context.tooltipDelay;


      return React.createElement(Button$1, {
        icon: true,
        className: getCollapserStyles({ flipped: expanded }, 'md-collapser--card'),
        onClick: onExpandClick,
        tooltipLabel: tooltipLabel,
        tooltipDelay: tooltipDelay,
        tooltipPosition: tooltipPosition,
        iconEl: icon
      });
    }
  }]);
  return CardExpander;
}(Component);

CardExpander.contextTypes = contextTypes;

/**
 * The `CardActions` component is used for adding actions on your card.
 * The actions should be `FlatButton`s or `IconButton`s.
 *
 * This component can act as a `CardExpander`.
 */

var CardActions = function (_Component) {
  inherits(CardActions, _Component);

  function CardActions() {
    classCallCheck(this, CardActions);
    return possibleConstructorReturn(this, (CardActions.__proto__ || Object.getPrototypeOf(CardActions)).apply(this, arguments));
  }

  createClass(CardActions, [{
    key: 'render',
    value: function render() {
      var _props = this.props,
          className = _props.className,
          children = _props.children,
          isExpander = _props.isExpander,
          expander = _props.expander,
          centered = _props.centered,
          stacked = _props.stacked,
          props = objectWithoutProperties(_props, ['className', 'children', 'isExpander', 'expander', 'centered', 'stacked']);

      return React.createElement(
        'section',
        _extends({}, props, {
          className: classnames('md-dialog-footer--card', {
            'md-dialog-footer--inline': !stacked,
            'md-dialog-footer--stacked': stacked,
            'md-dialog-footer--card-centered': centered
          }, className)
        }),
        children,
        isExpander || expander && React.createElement(CardExpander, null)
      );
    }
  }]);
  return CardActions;
}(Component);

CardActions.propTypes = {
  /**
   * Boolean if this component should act as an expander and inject the
   * `CardExpander`.
   */
  expander: propTypes.bool,

  /**
   * An optional className to apply to the actions container.
   */
  className: propTypes.string,

  /**
   * An actions to display.
   */
  children: propTypes.node,

  /**
   * Boolean if the actions should be centered.
   */
  centered: propTypes.bool,

  /**
   * Boolean if the actions should be stacked.
   */
  stacked: propTypes.bool,

  isExpander: deprecated(propTypes.bool, 'Use `expander` instead')
};

var CardTitleBlock = function (_PureComponent) {
  inherits(CardTitleBlock, _PureComponent);

  function CardTitleBlock() {
    classCallCheck(this, CardTitleBlock);
    return possibleConstructorReturn(this, (CardTitleBlock.__proto__ || Object.getPrototypeOf(CardTitleBlock)).apply(this, arguments));
  }

  createClass(CardTitleBlock, [{
    key: 'render',
    value: function render() {
      var _props = this.props,
          id = _props.id,
          subtitle = _props.subtitle,
          avatar = _props.avatar;
      var title = this.props.title;

      title = React.createElement(
        'h2',
        {
          id: id,
          className: classnames('md-card-title--title', {
            'md-card-title--large': !avatar
          }, themeColors({ text: true })),
          tabIndex: id ? -1 : null
        },
        title
      );

      if (!subtitle) {
        return title;
      }

      return React.createElement(
        'div',
        {
          className: classnames('md-card-title--title-block', {
            'md-card-title--one-line': avatar
          })
        },
        title,
        React.createElement(
          'h3',
          { className: 'md-card-title--title ' + themeColors({ hint: true }) },
          subtitle
        )
      );
    }
  }]);
  return CardTitleBlock;
}(PureComponent);

CardTitleBlock.propTypes = {
  id: propTypes.oneOfType([propTypes.number, propTypes.string]),
  title: propTypes.node.isRequired,
  subtitle: propTypes.node,
  avatar: propTypes.bool
};

/**
 * The `CardTitle` component is used to render a title in a Card along
 * with an optional subtitle or avatar.
 */

var CardTitle = function (_Component) {
  inherits(CardTitle, _Component);

  function CardTitle() {
    classCallCheck(this, CardTitle);
    return possibleConstructorReturn(this, (CardTitle.__proto__ || Object.getPrototypeOf(CardTitle)).apply(this, arguments));
  }

  createClass(CardTitle, [{
    key: 'render',
    value: function render() {
      var _props = this.props,
          id = _props.id,
          style = _props.style,
          className = _props.className,
          title = _props.title,
          subtitle = _props.subtitle,
          expander = _props.expander,
          isExpander = _props.isExpander,
          children = _props.children,
          propAvatar = _props.avatar,
          props = objectWithoutProperties(_props, ['id', 'style', 'className', 'title', 'subtitle', 'expander', 'isExpander', 'children', 'avatar']);
      var avatar = this.props.avatar;

      if (avatar) {
        var avatarClassName = Children.only(avatar).props.className;

        avatar = cloneElement(avatar, {
          className: classnames('md-avatar--card', avatarClassName)
        });
      }
      return React.createElement(
        'div',
        _extends({}, props, {
          style: style,
          className: classnames('md-card-title', {
            'md-card-title--primary': !avatar
          }, className)
        }),
        avatar,
        React.createElement(CardTitleBlock, { id: id, title: title, subtitle: subtitle, avatar: !!avatar }),
        children,
        isExpander || expander && React.createElement(CardExpander, null)
      );
    }
  }]);
  return CardTitle;
}(Component);

CardTitle.propTypes = {
  /**
   * An optional id to add to the `title`.
   */
  id: propTypes.oneOfType([propTypes.number, propTypes.string]),

  /**
   * An optional style to apply.
   */
  style: propTypes.object,

  /**
   * An optional className to apply.
   */
  className: propTypes.string,

  /**
   * The title to display.
   */
  title: propTypes.node.isRequired,

  /**
   * An optional subtitle to display.
   */
  subtitle: propTypes.node,

  /**
   * Any additional children to display in the title block
   * after the avatar, title, and subtitle.
   */
  children: propTypes.node,

  /**
   * An optional avatar to display before the title and subtitle.
   */
  avatar: propTypes.element,

  /**
   * Boolean if the `CardTitle` component should inject a button
   * for expanding all children below it.
   */
  expander: propTypes.bool,

  isExpander: deprecated(propTypes.bool, 'Use `expander` instead')
};

/**
 * The `CardText` component is a simple wrapper for text or any content in a `Card`.
 * It really just adds correct padding and font color.
 */

var CardText = function (_PureComponent) {
  inherits(CardText, _PureComponent);

  function CardText() {
    classCallCheck(this, CardText);
    return possibleConstructorReturn(this, (CardText.__proto__ || Object.getPrototypeOf(CardText)).apply(this, arguments));
  }

  createClass(CardText, [{
    key: 'render',
    value: function render() {
      var _props = this.props,
          Component$$1 = _props.component,
          className = _props.className,
          expandable = _props.expandable,
          props = objectWithoutProperties(_props, ['component', 'className', 'expandable']);


      return React.createElement(Component$$1, _extends({}, props, { className: classnames('md-card-text', className) }));
    }
  }]);
  return CardText;
}(PureComponent);

CardText.propTypes = {
  /**
   * An optional style to apply.
   */
  style: propTypes.object,

  /**
   * An optional className to apply.
   */
  className: propTypes.string,

  /**
   * The children to display.
   */
  children: propTypes.node,

  /**
   * The component to render as.
   */
  component: propTypes.oneOfType([propTypes.string, propTypes.func]).isRequired,

  /**
   * Boolean if this component should be expandable when there is a `CardExpander`
   * above it in the `Card`.
   */
  expandable: propTypes.bool
};
CardText.defaultProps = {
  component: 'section'
};

var Chip = function (_PureComponent) {
  inherits(Chip, _PureComponent);

  function Chip() {
    var _ref;

    var _temp, _this, _ret;

    classCallCheck(this, Chip);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = possibleConstructorReturn(this, (_ref = Chip.__proto__ || Object.getPrototypeOf(Chip)).call.apply(_ref, [this].concat(args))), _this), _this.state = { hover: false }, _this._handleMouseEnter = function (e) {
      if (_this.props.onMouseEnter) {
        _this.props.onMouseEnter(e);
      }

      _this.setState({ hover: true });
    }, _this._handleMouseLeave = function (e) {
      if (_this.props.onMouseLeave) {
        _this.props.onMouseLeave(e);
      }

      _this.setState({ hover: false });
    }, _temp), possibleConstructorReturn(_this, _ret);
  }

  createClass(Chip, [{
    key: 'render',
    value: function render() {
      var hover = this.state.hover;
      var _props = this.props,
          label = _props.label,
          className = _props.className,
          labelStyle = _props.labelStyle,
          labelClassName = _props.labelClassName,
          avatar = _props.avatar,
          children = _props.children,
          removable = _props.removable,
          remove = _props.remove,
          onClick = _props.onClick,
          rotateIcon = _props.rotateIcon,
          iconClassName = _props.iconClassName,
          removeIconChildren = _props.removeIconChildren,
          removeIconClassName = _props.removeIconClassName,
          props = objectWithoutProperties(_props, ['label', 'className', 'labelStyle', 'labelClassName', 'avatar', 'children', 'removable', 'remove', 'onClick', 'rotateIcon', 'iconClassName', 'removeIconChildren', 'removeIconClassName']);


      var icon = void 0;
      if (removable || remove) {
        var chipIconCN = classnames('md-chip-icon', {
          'md-chip-icon--rotate': rotateIcon,
          'md-chip-text--hover': hover
        });

        if (React.isValidElement(children)) {
          icon = React.Children.only(children);
          icon = React.cloneElement(icon, { className: classnames(chipIconCN, icon.props.className) });
        } else {
          icon = React.createElement(
            FontIcon,
            { className: chipIconCN, iconClassName: iconClassName },
            children
          );
        }
      }

      return React.createElement(
        'button',
        _extends({
          type: 'button'
        }, props, {
          className: classnames('md-chip', {
            'md-chip--avatar': avatar,
            'md-chip--remove': removable,
            'md-chip--hover': hover
          }, className),
          onClick: remove || onClick,
          onMouseEnter: this._handleMouseEnter,
          onMouseLeave: this._handleMouseLeave
        }),
        avatar,
        React.createElement(
          'span',
          {
            style: labelStyle,
            className: classnames('md-chip-text', {
              'md-chip-text--hover': hover
            }, labelClassName)
          },
          label
        ),
        icon
      );
    }
  }]);
  return Chip;
}(PureComponent);

Chip.propTypes = {
  /**
   * An optional style to apply.
   */
  style: propTypes.object,

  /**
   * An optional className to apply.
   */
  className: propTypes.string,

  /**
   * An optional style to apply to the chip's label.
   */
  labelStyle: propTypes.object,

  /**
   * An optional className to apply to the chip's label.
   */
  labelClassName: propTypes.string,

  /**
   * Boolean if the `.md-chip-icon--rotate` style should be applied to the remove icon.
   * The `.md-chip-icon--rotate` just rotates the icon 45 degrees.
   */
  rotateIcon: propTypes.bool,

  /**
   * Any children used to display the remove icon when `removable`.
   */
  children: propTypes.node,

  /**
   * The label to display on the chip.
   */
  label: propTypes.node.isRequired,

  /**
   * Boolean if the chip is removable.
   */
  removable: propTypes.bool,

  /**
   * An optional avatar to display on the chip.
   */
  avatar: propTypes.element,

  /**
   * An optional function to call when the `click` event is triggered.
   */
  onClick: propTypes.func,

  /**
   * An optional function to call when the `mouseenter` event is triggered.
   */
  onMouseEnter: propTypes.func,

  /**
   * An optional function to call when the `mouseleave` event is triggered.
   */
  onMouseLeave: propTypes.func,

  iconClassName: deprecated(propTypes.string, 'Use the `children` prop as a single FontIcon or SVGIcon instead'),
  remove: deprecated(propTypes.func, 'Use `removable` and `onClick` instead'),
  removeIconChildren: deprecated(propTypes.node, 'Use `children` instead'),
  removeIconClassName: deprecated(propTypes.string, 'Use `children` prop as a single FontIcon or SVGIcon instead')
};
Chip.defaultProps = {
  rotateIcon: true,
  children: React.createElement(
    FontIcon,
    null,
    'add_circle'
  )
};

/** @module utils/PropTypes/requiredForA11yIfNot */

/**
 * This validator checks that the current prop is valid and defined ONLY if
 * any of the `otherPropNames` are not true or defined.
 *
 * @param {function} validator - The React PropTypes validator to use for the given prop.
 * @param {String[]} otherPropNames - Any other prop names to validate against.
 * @return {Error} an error or null
 */
function requiredForA11yIfNot(validator) {
  for (var _len = arguments.length, otherPropNames = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
    otherPropNames[_key - 1] = arguments[_key];
  }

  return function validate(props, propName, componentName, location, propFullName) {
    var componentNameSafe = componentName || '<<anonymous>>';
    var propFullNameSafe = propFullName || propName;
    var defined = typeof props[propName] !== 'undefined';

    for (var _len2 = arguments.length, args = Array(_len2 > 5 ? _len2 - 5 : 0), _key2 = 5; _key2 < _len2; _key2++) {
      args[_key2 - 5] = arguments[_key2];
    }

    var err = validator.apply(undefined, [props, propName, componentName, location, propFullName].concat(args));
    if (!err && !defined && !otherPropNames.filter(function (pn) {
      return !!props[pn];
    }).length) {
      err = new Error('The `' + propFullNameSafe + '` ' + location + ' is required to make `' + componentNameSafe + '` accessible ' + 'for users of assistive technologies such as screen readers.');
    }

    return err;
  };
}

var contextTypes$1 = {
  checkedIcon: propTypes.element,
  uncheckedIcon: propTypes.element,
  indeterminateIcon: propTypes.element,
  indeterminate: propTypes.bool,
  plain: propTypes.bool,
  selectableRows: propTypes.bool.isRequired,
  allSelected: propTypes.bool.isRequired,
  selectedRows: propTypes.arrayOf(propTypes.bool).isRequired,
  createCheckbox: propTypes.func.isRequired,
  removeCheckbox: propTypes.func.isRequired,
  toggleSelectedRow: propTypes.func.isRequired,
  baseId: propTypes.oneOfType([propTypes.number, propTypes.string]),
  baseName: propTypes.string,
  checkboxHeaderLabel: propTypes.string.isRequired,
  checkboxLabelTemplate: propTypes.string.isRequired,
  fixedHeader: propTypes.bool.isRequired,
  fixedFooter: propTypes.bool.isRequired
};

/**
 * The `DataTable` component is used to manage the state of all rows.
 * This can either be a __plain__ table or a __data__ table.
 *
 * A __data__ table will include checkboxes on each row while a __plain__ table
 * will not.
 */

var DataTable = function (_PureComponent) {
  inherits(DataTable, _PureComponent);

  function DataTable(props) {
    classCallCheck(this, DataTable);

    var _this = possibleConstructorReturn(this, (DataTable.__proto__ || Object.getPrototypeOf(DataTable)).call(this));

    _initialiseProps$7.call(_this);

    var rows = props.defaultSelectedRows;
    _this.state = {
      header: false,
      indeterminate: props.indeterminate ? false : undefined,
      allSelected: _this._allSelected(rows),
      selectedRows: rows
    };

    _this._removed = 0;
    _this._initial = true;
    return _this;
  }

  createClass(DataTable, [{
    key: 'getChildContext',
    value: function getChildContext() {
      var _props = this.props,
          checkedIcon = _props.checkedIcon,
          uncheckedIcon = _props.uncheckedIcon,
          indeterminateIcon = _props.indeterminateIcon,
          plain = _props.plain,
          baseId = _props.baseId,
          selectableRows = _props.selectableRows,
          checkboxHeaderLabel = _props.checkboxHeaderLabel,
          checkboxLabelTemplate = _props.checkboxLabelTemplate,
          fixedHeader = _props.fixedHeader,
          fixedFooter = _props.fixedFooter,
          checkedIconChildren = _props.checkedIconChildren,
          checkedIconClassName = _props.checkedIconClassName,
          uncheckedIconChildren = _props.uncheckedIconChildren,
          uncheckedIconClassName = _props.uncheckedIconClassName,
          indeterminateIconChildren = _props.indeterminateIconChildren,
          indeterminateIconClassName = _props.indeterminateIconClassName;


      return {
        checkedIcon: getDeprecatedIcon(checkedIconClassName, checkedIconChildren, checkedIcon),
        uncheckedIcon: getDeprecatedIcon(uncheckedIconClassName, uncheckedIconChildren, uncheckedIcon),
        indeterminateIcon: getDeprecatedIcon(indeterminateIconClassName, indeterminateIconChildren, indeterminateIcon),
        indeterminate: this.state.indeterminate,
        plain: plain,
        allSelected: this.state.allSelected,
        selectedRows: this.state.selectedRows,
        toggleSelectedRow: this._toggleSelectedRow,
        createCheckbox: this._createCheckbox,
        removeCheckbox: this._removeCheckbox,
        baseId: baseId,
        baseName: baseId + '-control',
        selectableRows: selectableRows,
        checkboxHeaderLabel: checkboxHeaderLabel,
        checkboxLabelTemplate: checkboxLabelTemplate,
        fixedHeader: fixedHeader,
        fixedFooter: fixedFooter
      };
    }
  }, {
    key: 'componentDidUpdate',
    value: function componentDidUpdate() {
      this._removed = 0;
      this._initial = false;
    }
  }, {
    key: '_allSelected',
    value: function _allSelected(rows) {
      var all = rows.length !== 0;
      rows.some(function (checked) {
        if (!checked) {
          all = false;
        }

        return !all;
      });

      return all;
    }
  }, {
    key: 'render',
    value: function render() {
      var _cn;

      var _props2 = this.props,
          style = _props2.style,
          className = _props2.className,
          tableStyle = _props2.tableStyle,
          tableClassName = _props2.tableClassName,
          fixedWrapperStyle = _props2.fixedWrapperStyle,
          fixedWrapperClassName = _props2.fixedWrapperClassName,
          fixedScrollWrapperStyle = _props2.fixedScrollWrapperStyle,
          fixedScrollWrapperClassName = _props2.fixedScrollWrapperClassName,
          children = _props2.children,
          plain = _props2.plain,
          responsive = _props2.responsive,
          fixedHeader = _props2.fixedHeader,
          fixedFooter = _props2.fixedFooter,
          fixedDividers = _props2.fixedDividers,
          fixedHeight = _props2.fixedHeight,
          fixedWidth = _props2.fixedWidth,
          headerHeight = _props2.headerHeight,
          footerHeight = _props2.footerHeight,
          fullWidth = _props2.fullWidth,
          indeterminate = _props2.indeterminate,
          indeterminateIcon = _props2.indeterminateIcon,
          checkedIcon = _props2.checkedIcon,
          uncheckedIcon = _props2.uncheckedIcon,
          defaultSelectedRows = _props2.defaultSelectedRows,
          baseId = _props2.baseId,
          onRowToggle = _props2.onRowToggle,
          selectableRows = _props2.selectableRows,
          checkboxHeaderLabel = _props2.checkboxHeaderLabel,
          checkboxLabelTemplate = _props2.checkboxLabelTemplate,
          checkedIconChildren = _props2.checkedIconChildren,
          checkedIconClassName = _props2.checkedIconClassName,
          uncheckedIconChildren = _props2.uncheckedIconChildren,
          uncheckedIconClassName = _props2.uncheckedIconClassName,
          indeterminateIconChildren = _props2.indeterminateIconChildren,
          indeterminateIconClassName = _props2.indeterminateIconClassName,
          props = objectWithoutProperties(_props2, ['style', 'className', 'tableStyle', 'tableClassName', 'fixedWrapperStyle', 'fixedWrapperClassName', 'fixedScrollWrapperStyle', 'fixedScrollWrapperClassName', 'children', 'plain', 'responsive', 'fixedHeader', 'fixedFooter', 'fixedDividers', 'fixedHeight', 'fixedWidth', 'headerHeight', 'footerHeight', 'fullWidth', 'indeterminate', 'indeterminateIcon', 'checkedIcon', 'uncheckedIcon', 'defaultSelectedRows', 'baseId', 'onRowToggle', 'selectableRows', 'checkboxHeaderLabel', 'checkboxLabelTemplate', 'checkedIconChildren', 'checkedIconClassName', 'uncheckedIconChildren', 'uncheckedIconClassName', 'indeterminateIconChildren', 'indeterminateIconClassName']);


      var table = React.createElement(
        'table',
        _extends({}, props, {
          ref: this._setTable,
          style: responsive ? tableStyle : style,
          className: classnames('md-data-table', (_cn = {
            'md-data-table--plain': plain,
            'md-data-table--full-width': fullWidth
          }, defineProperty(_cn, className, !responsive && className), defineProperty(_cn, tableClassName, responsive && tableClassName), _cn))
        }),
        children
      );

      if (!responsive) {
        return table;
      }

      var content = table;
      if (fixedHeader || fixedFooter) {
        var height = fixedHeight;
        if (fixedHeight) {
          if (fixedHeader) {
            height -= headerHeight;
          }

          if (fixedFooter) {
            height -= footerHeight;
          }
        }

        var borderTop = fixedHeader;
        var borderBot = fixedFooter;
        if (typeof fixedDividers === 'boolean') {
          borderTop = borderTop && fixedDividers;
          borderBot = borderBot && fixedDividers;
        } else {
          borderTop = borderTop && (typeof fixedDividers.header === 'undefined' || fixedDividers.header);
          borderBot = borderBot && (typeof fixedDividers.footer === 'undefined' || fixedDividers.footer);
        }

        content = React.createElement(
          'div',
          {
            style: fixedWrapperStyle,
            className: classnames('md-data-table__fixed-wrapper', {
              'md-data-table__fixed-wrapper--header': fixedHeader,
              'md-data-table__fixed-wrapper--footer': fixedFooter
            }, fixedWrapperClassName)
          },
          React.createElement(
            'div',
            {
              style: _extends({ height: height }, fixedScrollWrapperStyle),
              className: classnames('md-data-table__scroll-wrapper', {
                'md-divider-border': fixedDividers,
                'md-divider-border--top': borderTop,
                'md-divider-border--bottom': borderBot
              }, fixedScrollWrapperClassName)
            },
            table
          )
        );
      }

      return React.createElement(
        'div',
        {
          style: _extends({ width: fixedWidth }, style),
          className: classnames('md-data-table--responsive', {
            'md-data-table--fixed': fixedHeader || fixedFooter
          }, className)
        },
        content
      );
    }
  }]);
  return DataTable;
}(PureComponent);

DataTable.propTypes = {
  /**
   * A base id to use for every checkbox or `EditDialogColumn` in the data table. This is
   * required for a11y if the data table is not plain. It is recommended to always provide
   * this prop if you are using any of the advanced table components to auto-generate unique
   * ids for each element.
   *
   * @see {@link DataTables/EditDialogColumn}
   * @see {@link DataTables/SelectFieldColumn}
   * @see {@link DataTables/DropdownMenuColumn}
   * @see {@link DataTables/MenuButtonColumn}
   * @see {@link DataTables/TablePagination}
   */
  baseId: requiredForA11yIfNot(propTypes.oneOfType([propTypes.number, propTypes.string]), 'plain'),

  /**
   * Optional style to apply to the table. If the table is `responsive`, this will be applied to the surrounding `div`
   * instead of the table itself. Use the `tableStyle` in this case.
   *
   * @see {@link #tableStyle}
   * @see {@link #responsive}
   */
  style: propTypes.object,

  /**
   * An optional className to apply to the table. If the table is `responsive`, this will be applied to the
   * surrounding `div` instead of the table itself. Use the `tableClassName` in this case.
   *
   * @see {@link #tableClassName}
   * @see {@link #responsive}
   */
  className: propTypes.string,

  /**
   * An optional style to apply to the `table` itself when the `responsive` prop is enabled. If the table is not
   * `responsive`, use the `style` prop.
   *
   * @see {@link #style}
   * @see {@link #responsive}
   */
  tableStyle: propTypes.object,

  /**
   * An optional className to apply to the `table` itself when the `responsive` prop is enabled. If the table is not
   * `responsive`, use the `className` prop.
   *
   * @see {@link #className}
   * @see {@link #responsive}
   */
  tableClassName: propTypes.string,

  /**
   * An optional style to apply to the fixed table wrapper that appears when there is a fixed
   * header or a fixed footer.
   *
   * @see {@link #fixedHeader}
   * @see {@link #fixedFooter}
   * @see {@link #fixedWrapperClassName}
   * @see {@link #fixedScrollWrapperStyle}
   * @see {@link #fixedScrollWrapperClassName}
   */
  fixedWrapperStyle: propTypes.object,

  /**
   * An optional className to apply to the fixed table wrapper that appears when there is a fixed
   * header or a fixed footer.
   *
   * @see {@link #fixedHeader}
   * @see {@link #fixedFooter}
   * @see {@link #fixedWrapperStyle}
   * @see {@link #fixedScrollWrapperStyle}
   * @see {@link #fixedScrollWrapperClassName}
   */
  fixedWrapperClassName: propTypes.string,

  /**
   * An optional style to apply to the fixed table wrapper's scroll container that appears when there is a fixed
   * header or a fixed footer.
   *
   * @see {@link #fixedHeader}
   * @see {@link #fixedFooter}
   * @see {@link #fixedWrapperStyle}
   * @see {@link #fixedWrapperClassName}
   * @see {@link #fixedScrollWrapperStyle}
   */
  fixedScrollWrapperStyle: propTypes.object,

  /**
   * An optional className to apply to the fixed table wrapper's scroll container that appears when there is a fixed
   * header or a fixed footer.
   *
   * @see {@link #fixedHeader}
   * @see {@link #fixedFooter}
   * @see {@link #fixedWrapperStyle}
   * @see {@link #fixedWrapperClassName}
   * @see {@link #fixedScrollWrapperStyle}
   */
  fixedScrollWrapperClassName: propTypes.string,

  /**
   * The table contents to display. This *should* be a list of `TableHeader` and `TableBody`
   * components.
   */
  children: propTypes.node.isRequired,

  /**
   * An optional array of booleans denoting if a row is selected.
   * This is an associative array so the index must match the row
   * number in the `TableBody` component.
   */
  defaultSelectedRows: propTypes.arrayOf(propTypes.bool).isRequired,

  /**
   * Boolean if the table is responsive. This will wrap the table in a container
   * that allows scrolling to the right if overflow exists.
   */
  responsive: propTypes.bool.isRequired,

  /**
   * Boolean if this table should not include the checkboxes on each row.
   * This really means that the entire table is unselectable and you wish
   * to display as a normal table.
   */
  plain: propTypes.bool,

  /**
   * The checked checkbox icon to display when a row is selected. This really defaults
   * to the `checkedCheckboxIcon` prop from the `SelectionControl`.
   *
   * @see {@link SelectionControls/SelectionControl#checkedCheckboxIcon}
   */
  checkedIcon: propTypes.element,

  /**
   * The unchecked checkbox icon to display when a row is selected. This really defaults
   * to the `uncheckedCheckboxIcon` prop from the `SelectionControl`.
   *
   * @see {@link SelectionControls/SelectionControl#uncheckedCheckboxIcon}
   */
  uncheckedIcon: propTypes.element,

  /**
   * An optional function to call when a non-plain data table has a row toggled. The callback
   * will include:
   * - the row id
   * - boolean if the row is now checked
   * - the total count of rows selected
   * - the change event
   *
   * All rows will be toggled on or off when the row id is 0 and a `thead` exists in the table.
   */
  onRowToggle: invalidIf(propTypes.func, 'plain'),

  /**
   * Boolean if the `DataTable` should inject checkboxes at the start of each row.
   */
  selectableRows: propTypes.bool,

  /**
   * Boolean if the checkboxes in the table should also include an _indeterminate_ state.
   * It will use the `indeterminateIconChildren` and `indeterminateIconClassName` when at least
   * 1 row has been checked, but not all rows.
   */
  indeterminate: propTypes.bool,

  /**
   * An optional icon to display when the selected state is indeterminate.
   *
   * @see {@link #indeterminate}
   */
  indeterminateIcon: propTypes.element,

  /**
   * This is the aria-label to apply to the checkbox in the table's header. This
   * is just used for accessibility since the checkboxes have no visible label.
   */
  checkboxHeaderLabel: propTypes.string.isRequired,

  /**
   * This is the aria-label to apply to a checkbox in the table's body. This can either
   * be a constant string that will replace `{{row}}` with the current row index, or
   * a function that takes the row index and returns a string.
   *
   * ```js
   * checkboxLabelTemplate={rowIndex => `Toggle row ${row}`}
   * ```
   */
  checkboxLabelTemplate: propTypes.oneOfType([propTypes.func, propTypes.string]).isRequired,

  /**
   * Boolean if the table should include a fixed header. This will allow the `TableHeader` component
   * to stay fixed to the top of the table while the `TableBody` scrolls horizontally.
   *
   * @see {@link #fixedFooter}
   * @see [react-md-make-fixed-table](/components/data-tables?tab=2#mixin-react-md-make-fixed-table)
   */
  fixedHeader: propTypes.bool,

  /**
   * Boolean if the table should include a fixed footer. This will allow the `TableFooter` component
   * to stay fixed to the bottom of the table while the `TableBody` scrolls horizontally.
   *
   * @see {@link #fixedHeader}
   * @see [react-md-make-fixed-table](/components/data-tables?tab=2#mixin-react-md-make-fixed-table)
   */
  fixedFooter: propTypes.bool,

  /**
   * Either a boolean or a shape of booleans for if a divider should appear at the top or bottom of the table
   * when there is a fixed header/footer. By default, this will automatically create dividers.
   *
   * @see {@link #fixedHeader}
   * @see {@link #fixedFooter}
   */
  fixedDividers: propTypes.oneOfType([propTypes.bool, propTypes.shape({
    header: propTypes.bool,
    footer: propTypes.bool
  })]),

  /**
   * An optional height to set for a table with a fixed header and/or a fixed footer. It is recommended to use
   * the related `react-md-make-fixed-table` mixin instead.
   *
   * @see {@link #headerHeight}
   * @see {@link #footerHeight}
   */
  fixedHeight: propTypes.number,

  /**
   * An optional width to set for a table with a fixed header and/or a fixed footer. It is recommended to use
   * the related `react-md-make-fixed-table` mixin instead.
   */
  fixedWidth: propTypes.number,

  /**
   * This is the height of the table's header columns. This should be equal to the `md-data-table-header-height`
   * variable.
   *
   * @see [md-data-table-header-height](/components/data-tables?tab=2#variable-md-data-table-header-height)
   * @see {@link #fixedHeight}
   */
  headerHeight: propTypes.number.isRequired,

  /**
   * This is the height of the table's header columns. This should be equal to the `md-data-table-header-height`
   * variable.
   *
   * @see [md-data-table-column-height](/components/data-tables?tab=2#variable-md-data-table-column-height)
   * @see {@link #fixedHeight}
   */
  footerHeight: propTypes.number.isRequired,

  /**
   * Boolean if the `<table>` element should always span the entire width of its container.
   */
  fullWidth: propTypes.bool,

  indeterminateIconChildren: deprecated(propTypes.node, 'Use the `indeterminateIcon` prop instead'),
  indeterminateIconClassName: deprecated(propTypes.string, 'Use the `indeterminateIcon` prop instead'),
  checkedIconClassName: deprecated(propTypes.string, 'Use the `checkedIcon` prop instead'),
  checkedIconChildren: deprecated(propTypes.node, 'Use the `checkedIcon` prop instead'),
  uncheckedIconClassName: deprecated(propTypes.string, 'Use the `uncheckedIcon` prop instead'),
  uncheckedIconChildren: deprecated(propTypes.node, 'Use the `uncheckedIcon` prop instead')
};
DataTable.defaultProps = {
  indeterminateIcon: React.createElement(
    FontIcon,
    null,
    'indeterminate_check_box'
  ),
  defaultSelectedRows: [],
  responsive: true,
  selectableRows: true,
  checkboxHeaderLabel: 'Toggle All Rows',
  checkboxLabelTemplate: 'Toggle row {{row}}',
  fixedHeader: false,
  fixedFooter: false,
  fixedDividers: true,
  headerHeight: 56,
  footerHeight: 48,
  fullWidth: true
};
DataTable.childContextTypes = contextTypes$1;

var _initialiseProps$7 = function _initialiseProps() {
  var _this2 = this;

  this._setTable = function (table) {
    _this2._table = table;
  };

  this._createCheckbox = function (index) {
    _this2.setState(function (state, props) {
      var selectedRows = state.selectedRows.slice();
      // Only use the default selected rows prop on first mount. If other changes occur after,
      // default to false.
      var selected = _this2._initial && props.defaultSelectedRows[index] || false;
      selectedRows.splice(index, 0, selected);
      return { selectedRows: selectedRows, allSelected: _this2._allSelected(selectedRows) };
    });
  };

  this._removeCheckbox = function (index) {
    _this2.setState(function (state) {
      // When multiple checkboxes are removed in a render cycle, they are removed in list order.
      // So to keep the index correct while removing, need to keep subtract the provided index by
      // the current number of removed elements. This value gets reset to 0 after a finished cycle.
      var selectedRows = state.selectedRows.slice();

      // This is really ugly. React 16 doesn't need to track all this while React 15 does
      if (React.version && React.version.match(/^16\./)) {
        selectedRows.splice(index, 1);
      } else {
        selectedRows.splice(index - _this2._removed, 1);
        _this2._removed += 1;
      }
      return { selectedRows: selectedRows, allSelected: _this2._allSelected(selectedRows) };
    });
  };

  this._toggleSelectedRow = function (row, header, e) {
    var selectedRows = void 0;
    var allSelected = _this2.state.allSelected;
    var selectedCount = 0;
    var i = _this2._table && _this2._table.querySelector('.md-table-header') ? row - 1 : row;
    var checked = e.target.checked;

    if (header) {
      selectedRows = _this2.state.selectedRows.map(function () {
        return checked;
      });
      allSelected = checked;
      selectedCount = !checked ? 0 : selectedRows.length;
    } else {
      selectedRows = _this2.state.selectedRows.slice();
      selectedRows[i] = !selectedRows[i];
      selectedCount = selectedRows.filter(function (b) {
        return b;
      }).length;
      allSelected = selectedCount === selectedRows.length;
    }

    if (_this2.props.onRowToggle) {
      _this2.props.onRowToggle(row, checked, selectedCount, e);
    }

    var indeterminate = _this2.props.indeterminate && !allSelected && selectedCount > 0;

    _this2.setState({ selectedRows: selectedRows, allSelected: allSelected, indeterminate: indeterminate });
  };
};

var headerContextTypes = _extends({}, contextTypes$1, { header: propTypes.bool });

/**
 * A `thead` component to use in the `DataTable` component. This
 * will automatically update the header row to check if it is selected
 * and inject a function to toggle all rows selected if the row is
 * uncontrolled. It will also automatically attempt to set the `TableColumn`
 * components to be the header type.
 */

var TableHeader = function (_Component) {
  inherits(TableHeader, _Component);

  function TableHeader() {
    classCallCheck(this, TableHeader);
    return possibleConstructorReturn(this, (TableHeader.__proto__ || Object.getPrototypeOf(TableHeader)).apply(this, arguments));
  }

  createClass(TableHeader, [{
    key: 'getChildContext',
    value: function getChildContext() {
      return _extends({}, this.context, {
        header: true
      });
    }
  }, {
    key: 'render',
    value: function render() {
      var _props = this.props,
          className = _props.className,
          children = _props.children,
          props = objectWithoutProperties(_props, ['className', 'children']);
      var allSelected = this.context.allSelected;

      var header = React.Children.only(children);
      var selected = typeof header.props.selected === 'undefined' ? allSelected : header.props.selected;

      var row = React.cloneElement(header, { selected: selected });

      return React.createElement(
        'thead',
        _extends({}, props, { className: classnames('md-table-header', className) }),
        row
      );
    }
  }]);
  return TableHeader;
}(Component);

TableHeader.contextTypes = contextTypes$1;
TableHeader.childContextTypes = headerContextTypes;
TableHeader.propTypes = {
  /**
   * An optional style to apply.
   */
  style: propTypes.object,

  /**
   * An optional className to apply to the table header
   */
  className: propTypes.string,

  /**
   * This should be a single `TableRow` component. The `custom` validation will
   * warn you if there are more than one children given or none at all.
   */
  children: function children(props, propName, component) {
    try {
      React.Children.only(props.children);
      return null;
    } catch (e) {
      var amt = props.children ? props.children.length : 0;
      return new Error('There must only be one child in a \'' + component + '\', but ' + amt + ' were given.');
    }
  }
};

/**
 * The `TableBody` component is used for managing the state of all
 * `TableRow` inside of it.
 */

var TableBody = function (_Component) {
  inherits(TableBody, _Component);

  function TableBody() {
    classCallCheck(this, TableBody);
    return possibleConstructorReturn(this, (TableBody.__proto__ || Object.getPrototypeOf(TableBody)).apply(this, arguments));
  }

  createClass(TableBody, [{
    key: 'render',
    value: function render() {
      var _props = this.props,
          children = _props.children,
          className = _props.className,
          props = objectWithoutProperties(_props, ['children', 'className']);
      var selectedRows = this.context.selectedRows;


      var rows = children ? Children.map(Children.toArray(children), function (row, i) {
        var uncontrolled = typeof row.props.selected === 'undefined';
        return React.cloneElement(row, {
          selected: uncontrolled ? selectedRows[i] : row.props.selected
        });
      }) : null;

      return React.createElement(
        'tbody',
        _extends({}, props, { className: classnames('md-table-body', className) }),
        rows
      );
    }
  }]);
  return TableBody;
}(Component);

TableBody.propTypes = {
  /**
   * An optional style to apply to the tbody.
   */
  style: propTypes.object,

  /**
   * An optional className to apply to the tbody.
   */
  className: propTypes.string,

  /**
   * A list or a single item of `TableRow` components to render.
   */
  children: propTypes.oneOfType([propTypes.element, propTypes.arrayOf(propTypes.element)])
};
TableBody.contextTypes = contextTypes$1;

var rowContextTypes = omit(_extends({}, headerContextTypes, {
  rowId: propTypes.oneOfType([propTypes.number, propTypes.string])
}), ['baseId']);

/** @module utils/StringUtils/capitlizeFirst */

/**
 * Capitalizes the first letter of a string. If the string is falsish, it will be
 * returned as is. If the string is only one letter long, it will be capitalized;
 *
 * @param {String} str - The string to capitalize.
 * @return {String} the updated string or false-ish self.
 */
function capitalizeFirst(str) {
  if (!str) {
    return str;
  } else if (str.length === 1) {
    return str.toUpperCase();
  }

  return "" + str.charAt(0).toUpperCase() + str.substring(1, str.length);
}

var DISABLED_INTERACTIONS = ['mouse'];

/**
 * This is the `Thumb` for the switch. The `ink` in the Thumb is only active on touch and keyboard
 * interactions, so the `AccessibleFakeInkButton` does not work for this case.
 *
 * This component really just is used for custom inkage.
 */

var SwitchThumb = function (_PureComponent) {
  inherits(SwitchThumb, _PureComponent);

  function SwitchThumb() {
    classCallCheck(this, SwitchThumb);
    return possibleConstructorReturn(this, (SwitchThumb.__proto__ || Object.getPrototypeOf(SwitchThumb)).apply(this, arguments));
  }

  createClass(SwitchThumb, [{
    key: 'render',
    value: function render() {
      var _props = this.props,
          disabled = _props.disabled,
          checked = _props.checked,
          className = _props.className,
          disabledInteractions = _props.disabledInteractions,
          props = objectWithoutProperties(_props, ['disabled', 'checked', 'className', 'disabledInteractions']);

      return React.createElement(AccessibleFakeInkedButton, _extends({}, props, {
        disabled: disabled,
        disabledInteractions: disabledInteractions || DISABLED_INTERACTIONS,
        inkContainerClassName: 'md-ink-container--2x',
        className: classnames('md-switch-thumb', {
          'md-switch-thumb--disabled': disabled,
          'md-switch-thumb--on': checked,
          'md-switch-thumb--off': !checked
        }, className)
      }));
    }
  }]);
  return SwitchThumb;
}(PureComponent);

SwitchThumb.propTypes = {
  className: propTypes.string,
  disabled: propTypes.bool,
  checked: propTypes.bool,
  onClick: propTypes.func,
  disabledInteractions: propTypes.arrayOf(propTypes.oneOf(['keyboard', 'touch', 'mouse']))
};

var SwitchTrack = function (_PureComponent) {
  inherits(SwitchTrack, _PureComponent);

  function SwitchTrack() {
    classCallCheck(this, SwitchTrack);
    return possibleConstructorReturn(this, (SwitchTrack.__proto__ || Object.getPrototypeOf(SwitchTrack)).apply(this, arguments));
  }

  createClass(SwitchTrack, [{
    key: 'render',
    value: function render() {
      var _props = this.props,
          disabled = _props.disabled,
          checked = _props.checked,
          className = _props.className,
          inkDisabled = _props.inkDisabled,
          disabledInteractions = _props.disabledInteractions,
          props = objectWithoutProperties(_props, ['disabled', 'checked', 'className', 'inkDisabled', 'disabledInteractions']);

      return React.createElement(
        'div',
        _extends({}, props, {
          className: classnames('md-switch-track', {
            'md-pointer--hover': !disabled,
            'md-switch-track--disabled': disabled,
            'md-switch-track--on': checked,
            'md-switch-track--off': !checked
          }, className)
        }),
        React.createElement(SwitchThumb, {
          disabled: disabled,
          checked: checked,
          onClick: props.onClick,
          inkDisabled: inkDisabled,
          disabledInteractions: disabledInteractions
        })
      );
    }
  }]);
  return SwitchTrack;
}(PureComponent);

SwitchTrack.propTypes = {
  className: propTypes.string,
  disabled: propTypes.bool,
  checked: propTypes.bool,
  inkDisabled: propTypes.bool,
  disabledInteractions: propTypes.arrayOf(propTypes.oneOf(['keyboard', 'touch', 'mouse']))
};

/**
 * Prevents a second warning from appearing when using the deprecated or a11y required
 * props by using the `__superSecretProp`.... So secret!
 */
function preventDouble(validator) {
  return function validate(props, propName) {
    for (var _len = arguments.length, others = Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
      others[_key - 2] = arguments[_key];
    }

    var err = validator.apply(undefined, [props, propName].concat(others));
    if (err && props.__superSecreteProp) {
      err = null;
    }

    return err;
  };
}

/**
 * The `SelectionControl` component is used to render any of the `Radio`, `Checkbox`, or `Switch`
 * selection control type. This component might eventually replace all three since they use this
 * anyways. I am not sure yet though.
 */

var SelectionControl = function (_PureComponent) {
  inherits(SelectionControl, _PureComponent);

  function SelectionControl(props) {
    classCallCheck(this, SelectionControl);

    var _this = possibleConstructorReturn(this, (SelectionControl.__proto__ || Object.getPrototypeOf(SelectionControl)).call(this, props));

    _this._setInput = function (input) {
      _this._input = input;
    };

    _this._setControl = function (control) {
      _this._control = control;
    };

    _this._setContainer = function (container) {
      _this._container = container;
    };

    _this._getIcon = function () {
      var _this$props = _this.props,
          checkedIcon = _this$props.checkedIcon,
          uncheckedIcon = _this$props.uncheckedIcon,
          type = _this$props.type;

      var checked = getField(_this.props, _this.state, 'checked');
      if (checkedIcon || uncheckedIcon) {
        return checked ? checkedIcon : uncheckedIcon;
      }

      var prefix = (checked ? '' : 'un') + 'checked' + capitalizeFirst(type) + 'Icon';
      var iconClassName = _this.props[prefix + 'ClassName'];
      var children = _this.props[prefix + 'Children'];

      if (iconClassName || children) {
        return React.createElement(
          FontIcon,
          { iconClassName: iconClassName, inherit: true },
          children
        );
      }

      var icon = _this.props[prefix];
      return icon ? React.cloneElement(icon, { inherit: true }) : null;
    };

    _this._handleKeyDown = function (e) {
      if (_this.props.onKeyDown) {
        _this.props.onKeyDown(e);
      }

      var key = e.which || e.keyCode;
      if (key === SPACE) {
        _this._input.click();
      }
    };

    _this._handleChange = function (e) {
      var _this$props2 = _this.props,
          type = _this$props2.type,
          onChange = _this$props2.onChange;

      var checked = !getField(_this.props, _this.state, 'checked');
      if (onChange) {
        onChange(type === 'radio' ? e.target.value : checked, e);
      }

      if (typeof _this.props.checked === 'undefined') {
        _this.setState({ checked: checked });
      }
    };

    _this.state = {};
    if (typeof props.checked === 'undefined') {
      _this.state.checked = !!props.defaultChecked;
    }
    return _this;
  }

  /**
   * Gets the current checked value from the selection control. This is used when you have
   * an uncontrolled selection control and simply need the checked state from a ref callback.
   *
   * @return {boolean} the checked state for the selection control.\
   */


  createClass(SelectionControl, [{
    key: 'render',
    value: function render() {
      var _props = this.props,
          id = _props.id,
          style = _props.style,
          className = _props.className,
          inline = _props.inline,
          type = _props.type,
          name = _props.name,
          value = _props.value,
          disabled = _props.disabled,
          labelBefore = _props.labelBefore,
          tabIndex = _props.tabIndex,
          inkDisabled = _props.inkDisabled,
          disabledInteractions = _props.disabledInteractions,
          ariaLabel = _props['aria-label'],
          ariaLabelledBy = _props['aria-labelledby'],
          propLabel = _props.label,
          propChildren = _props.checked,
          onChange = _props.onChange,
          tooltip = _props.tooltip,
          checkedCheckboxIcon = _props.checkedCheckboxIcon,
          uncheckedCheckboxIcon = _props.uncheckedCheckboxIcon,
          checkedRadioIcon = _props.checkedRadioIcon,
          uncheckedRadioIcon = _props.uncheckedRadioIcon,
          __superSecreteProp = _props.__superSecreteProp,
          checkedIcon = _props.checkedIcon,
          uncheckedIcon = _props.uncheckedIcon,
          checkedRadioIconChildren = _props.checkedRadioIconChildren,
          checkedRadioIconClassName = _props.checkedRadioIconClassName,
          uncheckedRadioIconChildren = _props.uncheckedRadioIconChildren,
          uncheckedRadioIconClassName = _props.uncheckedRadioIconClassName,
          checkedCheckboxIconChildren = _props.checkedCheckboxIconChildren,
          checkedCheckboxIconClassName = _props.checkedCheckboxIconClassName,
          uncheckedCheckboxIconChildren = _props.uncheckedCheckboxIconChildren,
          uncheckedCheckboxIconClassName = _props.uncheckedCheckboxIconClassName,
          props = objectWithoutProperties(_props, ['id', 'style', 'className', 'inline', 'type', 'name', 'value', 'disabled', 'labelBefore', 'tabIndex', 'inkDisabled', 'disabledInteractions', 'aria-label', 'aria-labelledby', 'label', 'checked', 'onChange', 'tooltip', 'checkedCheckboxIcon', 'uncheckedCheckboxIcon', 'checkedRadioIcon', 'uncheckedRadioIcon', '__superSecreteProp', 'checkedIcon', 'uncheckedIcon', 'checkedRadioIconChildren', 'checkedRadioIconClassName', 'uncheckedRadioIconChildren', 'uncheckedRadioIconClassName', 'checkedCheckboxIconChildren', 'checkedCheckboxIconClassName', 'uncheckedCheckboxIconChildren', 'uncheckedCheckboxIconClassName']);


      var checked = getField(this.props, this.state, 'checked');
      var isSwitch = type === 'switch';
      var label = this.props.label && React.createElement(
        'span',
        null,
        this.props.label
      );

      var control = void 0;
      if (isSwitch) {
        control = React.createElement(SwitchTrack, { disabled: disabled, checked: checked });
      } else {
        control = React.createElement(
          AccessibleFakeInkedButton,
          {
            inkDisabled: inkDisabled,
            disabledInteractions: disabledInteractions,
            role: type,
            className: classnames('md-selection-control-toggle md-btn md-btn--icon', themeColors({
              disabled: disabled,
              hint: !checked,
              secondary: checked
            })),
            'aria-checked': checked,
            tabIndex: tabIndex,
            disabled: disabled
          },
          tooltip,
          this._getIcon()
        );
      }

      return React.createElement(
        'div',
        _extends({}, props, {
          style: style,
          className: classnames('md-selection-control-container', {
            'md-selection-control-container--inline': inline,
            'md-switch-container': isSwitch
          }, className),
          onKeyDown: this._handleKeyDown
        }),
        React.createElement('input', {
          ref: this._setInput,
          id: id,
          type: isSwitch ? 'checkbox' : type,
          checked: checked,
          onChange: this._handleChange,
          disabled: disabled,
          className: 'md-selection-control-input',
          name: name,
          value: value,
          'aria-hidden': true,
          'aria-label': ariaLabel,
          'aria-labelledby': ariaLabelledBy
        }),
        React.createElement(
          'label',
          {
            htmlFor: id,
            className: classnames('md-selection-control-label', {
              'md-pointer--hover': !disabled
            }, themeColors({ disabled: disabled, text: !disabled }))
          },
          labelBefore && label,
          control,
          !labelBefore && label
        )
      );
    }
  }, {
    key: 'checked',
    get: function get$$1() {
      return getField(this.props, this.state, 'checked');
    }
  }]);
  return SelectionControl;
}(PureComponent);

SelectionControl.propTypes = {
  /**
   * An id to use with the selection control. This is used for accessibility and so that the label
   * triggers the selection control toggle.
   */
  id: preventDouble(isRequiredForA11y(propTypes.oneOfType([propTypes.string, propTypes.number]))),

  /**
   * An optional label to apply to the checkbox when there is no visible label.
   */
  'aria-label': oneRequiredForA11y(propTypes.string, 'label', 'aria-labelledby'),

  /**
   * An optional id that points to a label for the selection control when there is no visible label.
   */
  'aria-labelledby': propTypes.oneOfType([propTypes.number, propTypes.string]),

  /**
   * An optional style to apply to the selection control's container.
   */
  style: propTypes.object,

  /**
   * An optional className to apply to the selection control's container.
   */
  className: propTypes.string,

  /**
   * The type of selection control to render.
   */
  type: propTypes.oneOf(['checkbox', 'radio', 'switch']).isRequired,

  /**
   * A label to display with the selection control. This is required for accessibility and triggering
   * the toggle.
   */
  label: propTypes.node,

  /**
   * Boolean if the label should appear before the checkbox/radio icon or switch.
   */
  labelBefore: propTypes.bool,

  /**
   * A name to use for the `SelectionControl`. This is required for accessibility. If the `type`
   * is a `checkbox` and it is part of a group, it is recommended to make this a string ending
   * in `[]` so that the value can be found from `document.querySelector('input[name="someName[]"]').value`.
   */
  name: preventDouble(isRequiredForA11y(propTypes.oneOfType([propTypes.number, propTypes.string]))),

  /**
   * Boolean if the `Radio` is disabled.
   */
  disabled: propTypes.bool,

  /**
   * A function to call when the `SelectionControl` triggers the `change` event. The `onChange`
   * callback will either include:
   * - the currently changed radio's value
   * - the next checked state for the `Switch` or `Checkbox`.
   *
   * as the first parameter followed by the change event.
   *
   * ```js
   * // Radio
   * onChange(changeEvent.target.value, changeEvent);
   *
   * // Checkbox or Switch
   * onChange(changeEvent.target.checked, changeEvent);
   * ```
   */
  onChange: propTypes.func,

  /**
   * An optional function to call when the `keydown` event is triggered.
   */
  onKeyDown: propTypes.func,

  /**
   * The value for the `SelectionControl`. It is not required for `Checkbox` and `Switch`,
   * but it is recommended.
   */
  value: propTypes.oneOfType([propTypes.bool, propTypes.number, propTypes.string]),

  /**
   * A boolean if the `SelectionControl` is currently checked. This _really_ makes the `onChange`
   * prop required, but since there are cases you might want to have the `onChange` listener on a
   * `fieldset` or something above the component, it is never set to `required`. It will however
   * prevent updates if there is no change listener.
   */
  checked: propTypes.bool,

  /**
   * Boolean if the `Checkbox` or `Switch` are checked by default. This prop is invalid for a
   * `Radio`.
   */
  defaultChecked: propTypes.bool,

  /**
   * Boolean if the `SelectionControl` should be displayed inline instead of a block.
   */
  inline: propTypes.bool,

  /**
   * The icon to use for a checked `checkbox` selection control.
   */
  checkedCheckboxIcon: propTypes.element,

  /**
   * The icon to use for an unchecked `checkbox` selection control.
   */
  uncheckedCheckboxIcon: propTypes.element,

  /**
   * The icon to use for a checked `radio` selection control.
   */
  checkedRadioIcon: propTypes.element,

  /**
   * The icon to use for an unchecked `radio` selection control.
   */
  uncheckedRadioIcon: propTypes.element,

  /**
   * An optional tooltip to render with the control. This is only used if you inject the
   * tooltip manually yourself.
   *
   * `const TooltippedSelectionControl = injectTooltip(SelectionControl);`
   */
  tooltip: propTypes.node,

  /**
   * Boolean if the ink should be disabled for radios or checkboxes.
   *
   * @see {@link Inks#inkDisabled}
   */
  inkDisabled: propTypes.bool,

  /**
   * An optional list of ink interactions that should be disabled.
   *
   * @see {@link Inks#disabledInteractions}
   */
  disabledInteractions: propTypes.arrayOf(propTypes.oneOf(['keyboard', 'touch', 'mouse'])),

  /**
   * An optional tab index to apply to the selection control.
   */
  tabIndex: propTypes.number,

  checkedIcon: preventDouble(deprecated(propTypes.node, 'Use the `checkedCheckboxIconChildren` and `checkedCheckboxIconClassName`  or the ' + '`checkedRadioIconChildren` and `checkedRadioIconClassName` props instead')),
  uncheckedIcon: preventDouble(deprecated(propTypes.node, 'Use the `uncheckedCheckboxIconChildren` and `uncheckedCheckboxIconClassName`  or the ' + '`uncheckedRadioIconChildren` and `uncheckedRadioIconClassName` props instead')),
  checkedCheckboxIconChildren: deprecated(propTypes.node, 'Use the `checkedCheckboxIcon` prop instead'),
  checkedCheckboxIconClassName: deprecated(propTypes.string, 'Use the `checkedCheckboxIcon` prop instead'),
  uncheckedCheckboxIconChildren: deprecated(propTypes.node, 'Use the `uncheckedCheckboxIcon` prop instead'),
  uncheckedCheckboxIconClassName: deprecated(propTypes.string, 'Use the `uncheckedCheckboxIcon` prop instead'),
  checkedRadioIconChildren: deprecated(propTypes.node, 'Use the `checkedRadioIcon` prop instead'),
  checkedRadioIconClassName: deprecated(propTypes.string, 'Use the `checkedRadioIcon` prop instead'),
  uncheckedRadioIconChildren: deprecated(propTypes.node, 'Use the `uncheckedRadioIcon` prop instead'),
  uncheckedRadioIconClassName: deprecated(propTypes.string, 'Use the `uncheckedRadioIcon` prop instead'),

  /* maybe removed once upgrade again? */
  __superSecreteProp: propTypes.bool
};
SelectionControl.defaultProps = {
  checkedCheckboxIcon: React.createElement(
    FontIcon,
    null,
    'check_box'
  ),
  uncheckedCheckboxIcon: React.createElement(
    FontIcon,
    null,
    'check_box_outline_blank'
  ),
  checkedRadioIcon: React.createElement(
    FontIcon,
    null,
    'radio_button_checked'
  ),
  uncheckedRadioIcon: React.createElement(
    FontIcon,
    null,
    'radio_button_unchecked'
  )
};

/**
 * Attempts fo find the base table component from an element in the table.
 * This will either be the wrapper for responsive data tables, or the table element.
 *
 * @param {Object} el - The element to traverse from
 * @param {Object} the table or null.
 */
function findTable(el) {
  var table = void 0;
  var node = el;
  while (node && node.parentNode) {
    if (node.classList) {
      if (node.classList.contains('md-data-table')) {
        table = node;
      } else if (node.classList.contains('md-data-table--responsive')) {
        return node;
      } else if (node.classList.contains('md-data-table__scroll-wrapper')) {
        // fixed-wrapper then responsive
        return node.parentNode.parentNode;
      } else if (table) {
        return table;
      }
    }

    node = node.parentNode;
  }

  return null;
}

var TableCheckbox = function (_Component) {
  inherits(TableCheckbox, _Component);

  function TableCheckbox() {
    var _ref;

    var _temp, _this, _ret;

    classCallCheck(this, TableCheckbox);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = possibleConstructorReturn(this, (_ref = TableCheckbox.__proto__ || Object.getPrototypeOf(TableCheckbox)).call.apply(_ref, [this].concat(args))), _this), _this._td = null, _this._header = false, _this._handleMount = function (td) {
      if (td) {
        var header = findTable(td).querySelector('thead');
        var index = td.parentNode.rowIndex - (header ? 1 : 0);

        if (td.parentNode.parentNode.tagName === 'TBODY') {
          _this.context.createCheckbox(index);
        }
        _this._td = td;
        _this._header = header;
      } else if (_this._td) {
        var _index = _this._td.parentNode.rowIndex;
        _this.context.removeCheckbox(_index - (_this._header ? 1 : 0));
        _this._td = null;
        _this._header = false;
      }
    }, _temp), possibleConstructorReturn(_this, _ret);
  }

  createClass(TableCheckbox, [{
    key: 'render',
    value: function render() {
      var _props = this.props,
          checked = _props.checked,
          index = _props.index,
          props = objectWithoutProperties(_props, ['checked', 'index']);
      var _context = this.context,
          checkedIcon = _context.checkedIcon,
          uncheckedIcon = _context.uncheckedIcon,
          indeterminateIcon = _context.indeterminateIcon,
          indeterminate = _context.indeterminate,
          header = _context.header,
          footer = _context.footer,
          rowId = _context.rowId,
          baseName = _context.baseName,
          checkboxHeaderLabel = _context.checkboxHeaderLabel,
          checkboxLabelTemplate = _context.checkboxLabelTemplate;


      var Cell = header ? 'th' : 'td';
      var label = void 0;
      if (header) {
        label = checkboxHeaderLabel;
      } else if (typeof checkboxLabelTemplate === 'function') {
        label = checkboxLabelTemplate(index);
      } else {
        label = checkboxLabelTemplate.replace(/{{row}}/g, index);
      }

      var content = React.createElement(SelectionControl, _extends({}, props, {
        id: rowId,
        name: baseName + '-checkbox',
        type: 'checkbox',
        checked: checked,
        checkedCheckboxIcon: checkedIcon,
        uncheckedCheckboxIcon: header && indeterminate ? indeterminateIcon : uncheckedIcon,
        'aria-label': label
      }));
      var fixedHeader = header && this.context.fixedHeader;
      var fixedFooter = footer && this.context.fixedFooter;

      if (fixedHeader) {
        content = React.createElement(
          'div',
          {
            className: classnames('md-table-column__fixed', {
              'md-table-column__fixed--header': fixedHeader,
              'md-table-column__fixed--footer': fixedFooter
            })
          },
          React.cloneElement(content, {
            className: classnames({
              'md-table-checkbox--header': header,
              'md-table-checkbox--footer': footer
            })
          })
        );
      }

      return React.createElement(
        Cell,
        {
          className: classnames('md-table-checkbox', {
            'md-table-column--fixed': fixedHeader
          }),
          scope: header ? 'col' : undefined,
          ref: this._handleMount
        },
        content
      );
    }
  }]);
  return TableCheckbox;
}(Component);

TableCheckbox.propTypes = {
  index: propTypes.number,
  checked: propTypes.bool
};
TableCheckbox.contextTypes = {
  rowId: propTypes.oneOfType([propTypes.number, propTypes.string]).isRequired,
  baseName: propTypes.string.isRequired,
  indeterminate: propTypes.bool,
  checkedIcon: propTypes.element,
  uncheckedIcon: propTypes.element,
  indeterminateIcon: propTypes.element,
  checkboxHeaderLabel: propTypes.string.isRequired,
  checkboxLabelTemplate: propTypes.oneOfType([propTypes.func, propTypes.string]).isRequired,
  createCheckbox: propTypes.func.isRequired,
  removeCheckbox: propTypes.func.isRequired,
  header: propTypes.bool,
  footer: propTypes.bool,
  fixedHeader: propTypes.bool.isRequired,
  fixedFooter: propTypes.bool.isRequired
};

/**
 * A component for displaying a row in a `DataTable`. This will
 * automatically add a `Checkbox` component to the row if it is not
 * a `plain` table.
 */

var TableRow = function (_Component) {
  inherits(TableRow, _Component);

  function TableRow(props, context) {
    classCallCheck(this, TableRow);

    var _this = possibleConstructorReturn(this, (TableRow.__proto__ || Object.getPrototypeOf(TableRow)).call(this, props, context));

    _this._handleMouseOver = function (e) {
      if (_this.props.onMouseOver) {
        _this.props.onMouseOver(e);
      }

      if (_this.context.header) {
        return;
      }

      var target = e.target;
      while (target && target.parentNode) {
        if (target.classList && _this._ignoreHoverState(target.classList)) {
          _this.setState({ hover: false });
          return;
        }

        target = target.parentNode;
      }

      _this.setState({ hover: true });
    };

    _this._handleMouseLeave = function (e) {
      if (_this.props.onMouseLeave) {
        _this.props.onMouseLeave(e);
      }

      if (_this.context.header) {
        return;
      }

      _this.setState({ hover: false });
    };

    _this._handleCheckboxClick = function (checked, e) {
      var rowIndex = _this._row.rowIndex;

      if (_this.props.onCheckboxClick) {
        _this.props.onCheckboxClick(rowIndex, checked, e);
      }

      _this.context.toggleSelectedRow(rowIndex, _this.context.header, e);
    };

    _this._setRow = function (row) {
      _this._row = row;
    };

    _this.state = { hover: false };
    return _this;
  }

  createClass(TableRow, [{
    key: 'getChildContext',
    value: function getChildContext() {
      var _context = this.context,
          baseId = _context.baseId,
          context = objectWithoutProperties(_context, ['baseId']);

      var id = baseId + '-' + (this._row ? this._row.rowIndex : null);
      return _extends({}, context, {
        rowId: context.header ? baseId + '-toggle-all' : id
      });
    }

    /**
     * Need to ignore adding the hover state if the mouse is over a menu/menu item
     * or the edit dialog is open.
     *
     * @param {Function} classList - the classList to use for checking cn
     * @return {Boolean} true if the hover state should be ignored for this classList
     */

  }, {
    key: '_ignoreHoverState',
    value: function _ignoreHoverState(classList) {
      return classList.contains('md-list--menu') || classList.contains('md-edit-dialog');
    }
  }, {
    key: 'render',
    value: function render() {
      var _this2 = this;

      var _props = this.props,
          className = _props.className,
          children = _props.children,
          selected = _props.selected,
          selectable = _props.selectable,
          onCheckboxClick = _props.onCheckboxClick,
          autoAdjust = _props.autoAdjust,
          props = objectWithoutProperties(_props, ['className', 'children', 'selected', 'selectable', 'onCheckboxClick', 'autoAdjust']);
      var hover = this.state.hover;


      var checkbox = void 0;
      if (typeof selectable !== 'undefined' ? selectable : !this.context.plain && this.context.selectableRows) {
        checkbox = React.createElement(TableCheckbox, {
          key: 'checkbox',
          checked: selected,
          onChange: this._handleCheckboxClick,
          index: this._row ? this._row.rowIndex : null
        });
      }

      var length = Children.count(children) - 1;
      var columns = Children.map(Children.toArray(children), function (col, i) {
        var adjusted = col.props.adjusted;
        if (typeof adjusted === 'undefined') {
          adjusted = i === length ? false : undefined;
        }

        return cloneElement(col, {
          cellIndex: i + (checkbox ? 1 : 0),
          header: getField(col.props, _this2.context, 'header'),
          adjusted: adjusted
        });
      });

      return React.createElement(
        'tr',
        _extends({}, props, {
          ref: this._setRow,
          className: classnames('md-table-row', className, {
            'md-table-row--hover': hover,
            'md-table-row--active': !this.context.header && selected
          }),
          onMouseOver: this._handleMouseOver,
          onMouseLeave: this._handleMouseLeave
        }),
        checkbox,
        columns
      );
    }
  }]);
  return TableRow;
}(Component);

TableRow.propTypes = {
  /**
   * An optional style to apply.
   */
  style: propTypes.object,

  /**
   * An optional className to apply to the row.
   */
  className: propTypes.string,

  /**
   * A single or list of `TableColumn` to display in the table.
   *
   * > The specs "require" at least 3 columns for a non-plain data table, but that isn't
   * strictly enforced here.
   */
  children: propTypes.oneOfType([propTypes.element, propTypes.arrayOf(propTypes.element)]).isRequired,

  /**
   * An optional onClick function to call when a row is clicked.
   */
  onClick: propTypes.func,

  /**
   * A function to call when the checkbox is clicked. This
   * function will will be called with `(rowIndex, checked, event)`.
   * The `TableBody` and `TableHeader` components will automatically
   * merge in a function to toggle the checkbox.
   */
  onCheckboxClick: propTypes.func,

  /**
   * An optional function to call onMouseOver.
   */
  onMouseOver: propTypes.func,

  /**
   * An optional function to call onMouseLeave.
   */
  onMouseLeave: propTypes.func,

  /**
   * Boolean if the row is currently selected. If this value will be
   * injected by the `TableHeader` or `TableBody` component.
   */
  selected: propTypes.bool,

  /**
   * Boolean if the current row is selectable. This value will take precedence over anything inherited
   * by the `DataTable`.
   */
  selectable: propTypes.bool,

  autoAdjust: deprecated(propTypes.bool, 'Manually specify `grow` on one of the columns instead')
};
TableRow.contextTypes = headerContextTypes;
TableRow.childContextTypes = rowContextTypes;

var CELL_SCOPE = {
  header: {
    scope: 'col'
  },
  noop: {}
};

/**
 * A column in a table. This is either the `th` or `td` component.
 */

var TableColumn = function (_PureComponent) {
  inherits(TableColumn, _PureComponent);

  function TableColumn() {
    classCallCheck(this, TableColumn);
    return possibleConstructorReturn(this, (TableColumn.__proto__ || Object.getPrototypeOf(TableColumn)).apply(this, arguments));
  }

  createClass(TableColumn, [{
    key: 'render',
    value: function render() {
      var _props = this.props,
          className = _props.className,
          fixedStyle = _props.fixedStyle,
          fixedClassName = _props.fixedClassName,
          numeric = _props.numeric,
          header = _props.header,
          children = _props.children,
          sorted = _props.sorted,
          sortIcon = _props.sortIcon,
          tooltip = _props.tooltip,
          selectColumnHeader = _props.selectColumnHeader,
          adjusted = _props.adjusted,
          grow = _props.grow,
          sortIconBefore = _props.sortIconBefore,
          propPlain = _props.plain,
          propScope = _props.scope,
          cellIndex = _props.cellIndex,
          sortIconChildren = _props.sortIconChildren,
          sortIconClassName = _props.sortIconClassName,
          props = objectWithoutProperties(_props, ['className', 'fixedStyle', 'fixedClassName', 'numeric', 'header', 'children', 'sorted', 'sortIcon', 'tooltip', 'selectColumnHeader', 'adjusted', 'grow', 'sortIconBefore', 'plain', 'scope', 'cellIndex', 'sortIconChildren', 'sortIconClassName']);


      var sortable = typeof sorted === 'boolean';
      var plain = getField(this.props, this.context, 'plain');
      var Component$$1 = header ? 'th' : 'td';
      var scope = getField(this.props, CELL_SCOPE[header ? 'header' : 'noop'], 'scope');

      var displayedChildren = children;
      var ariaSort = void 0;
      if (sortable) {
        ariaSort = sorted ? 'ascending' : 'descending';
        var icon = React.Children.only(getDeprecatedIcon(sortIconClassName, sortIconChildren, sortIcon));
        displayedChildren = React.createElement(
          IconSeparator,
          { label: children, iconBefore: sortIconBefore },
          React.cloneElement(icon, { className: getCollapserStyles({ flipped: !sorted }, icon.props.className) })
        );
      }

      var fixedHeader = header && this.context.fixedHeader;
      var fixedFooter = this.context.footer && this.context.fixedFooter;
      var fixed = fixedHeader || fixedFooter;
      var baseClassNames = themeColors({ text: !header, hint: header }, {
        'md-table-column--relative': tooltip,
        'md-table-column--select-field': selectColumnHeader
      });

      var mergedClassNames = classnames(defineProperty({
        'md-table-column--header': header,
        'md-table-column--data': !header && !plain,
        'md-table-column--plain': !header && plain,
        'md-table-column--adjusted': adjusted && !grow && !selectColumnHeader,
        'md-table-column--grow': grow,
        'md-table-column--sortable md-pointer--hover': sortable
      }, baseClassNames, !fixed), className);

      if (fixed) {
        displayedChildren = React.createElement(
          'div',
          {
            className: classnames('md-table-column__fixed', {
              'md-table-column__fixed--header': fixedHeader,
              'md-table-column__fixed--footer': fixedFooter
            })
          },
          React.createElement(
            'div',
            {
              style: fixedStyle,
              className: classnames(baseClassNames, mergedClassNames, 'md-table-column__fixed--flex', {
                'md-table-column__fixed--flex-right': numeric
              }, fixedClassName)
            },
            tooltip,
            displayedChildren
          )
        );
      }

      return React.createElement(
        Component$$1,
        _extends({
          'aria-sort': ariaSort
        }, props, {
          scope: scope,
          className: classnames('md-table-column', {
            'md-table-column--fixed': fixed,
            'md-text-left': !numeric && !fixed,
            'md-text-right': numeric && !fixed
          }, mergedClassNames)
        }),
        !fixedHeader && !fixedFooter && tooltip,
        displayedChildren
      );
    }
  }]);
  return TableColumn;
}(PureComponent);

TableColumn.propTypes = {
  /**
   * An optional style to apply.
   */
  style: propTypes.object,

  /**
   * The optional className for the table column
   */
  className: propTypes.string,

  /**
   * An optional style to apply to the surrounding div when the DataTable has been
   * set to include a fixed header or a fixed footer.
   */
  fixedStyle: propTypes.object,

  /**
   * An optional className to apply to the surrounding div when the DataTable has been
   * set to include a fixed header or a fixed footer.
   */
  fixedClassName: propTypes.string,

  /**
   * The children to display in the column.
   */
  children: propTypes.node,

  /**
   * Boolean if the column is currently sorted. If this prop is not `undefined`,
   * it will add the sort icon unto this column. You will also need to use the
   * `onClick` function to toggle the `sorted` prop as well as handling the sorting
   * of data.
   *
   * This value should really only be set in the `TableHeader` component.
   */
  sorted: propTypes.bool,

  /**
   * The icon to show when a column is sortable.
   */
  sortIcon: propTypes.element,

  /**
   * Boolean if the sortIcon should appear before the text in the column.
   */
  sortIconBefore: propTypes.bool,

  /**
   * A boolean if the column has numeric data. It will right-align the data.
   */
  numeric: propTypes.bool,

  /**
   * Boolean if the table column should gain the `.md-data-table--adjusted` class name. By default,
   * every column will gain this class name unless it is an `EditDialogColumn`, a `SelectFieldColumn`,
   * or the `grow` prop is enabled.
   */
  adjusted: propTypes.bool,

  /**
   * Boolean if the column should expand to fill any remaining width in the container. There should
   * really only be one column with the `grow` prop enabled. In addition, it should really only be
   * applied to one of the columns in the TableHeader.
   */
  grow: propTypes.bool,

  /**
   * Boolean if this column is the `th` for a column of `SelectFieldColumn`. This will apply
   * additional styling to the column to position with the select field.
   */
  selectColumnHeader: propTypes.bool,

  /**
   * Boolean if this is a `th` component. This value **should** be set
   * automatically for you if it is in the `TableHeader` component.
   */
  header: propTypes.bool.isRequired,

  /**
   * The optional tooltip to render on hover.
   */
  tooltipLabel: propTypes.node,

  /**
   * An optional delay to apply to the tooltip before it appears.
   */
  tooltipDelay: propTypes.number,

  /**
   * The position of the tooltip.
   */
  tooltipPosition: propTypes.oneOf(['top', 'right', 'bottom', 'left']),

  /**
   * The injected tooltip.
   * @access private
   */
  tooltip: propTypes.node,

  /**
   * Boolean if the `TableColumn` should gain the `plain` styles. This means that the text
   * in the column can wrap and there is no height limit enforced with some additional padding.
   */
  plain: propTypes.bool,

  /**
   * An optional scope to apply to the table column. If omitted, the scope will be set to
   * `'col'` if inside of the `TableHeader` component. This is really only needed for
   * header columns.
   */
  scope: propTypes.oneOf(['row', 'col']),

  /**
   * This is injected by the `TableRow` component to help with generating ids
   * @access private
   */
  cellIndex: propTypes.number,
  sortIconChildren: deprecated(propTypes.node, 'Use the `sortIcon` prop instead'),
  sortIconClassName: deprecated(propTypes.string, 'Use the `sortIcon` prop instead')
};
TableColumn.defaultProps = {
  header: false,
  adjusted: true,
  sortIcon: React.createElement(
    FontIcon,
    null,
    'arrow_upward'
  ),
  sortIconBefore: true
};
TableColumn.contextTypes = {
  plain: propTypes.bool,
  footer: propTypes.bool,
  fixedHeader: propTypes.bool,
  fixedFooter: propTypes.bool
};


var TableColumn$1 = injectTooltip(TableColumn);

var SelectFieldInput = function (_PureComponent) {
  inherits(SelectFieldInput, _PureComponent);

  function SelectFieldInput() {
    var _ref;

    var _temp, _this, _ret;

    classCallCheck(this, SelectFieldInput);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = possibleConstructorReturn(this, (_ref = SelectFieldInput.__proto__ || Object.getPrototypeOf(SelectFieldInput)).call.apply(_ref, [this].concat(args))), _this), _this.state = { transition: null }, _this._timeout = null, _this._transitionNewValue = function () {
      var _this$props = _this.props,
          transitionTime = _this$props.transitionTime,
          transitionName = _this$props.transitionName;

      if (_this._timeout) {
        clearTimeout(_this._timeout);
      }

      _this._timeout = setTimeout(function () {
        _this._timeout = setTimeout(function () {
          _this._timeout = null;
          _this.setState({ transition: null });
        }, transitionTime);

        _this.setState({ transition: _this.state.transition + ' ' + transitionName + '-enter-active' });
      }, TICK);

      _this.setState({ transition: transitionName + '-enter' });
    }, _temp), possibleConstructorReturn(_this, _ret);
  }

  createClass(SelectFieldInput, [{
    key: 'componentWillReceiveProps',
    value: function componentWillReceiveProps(nextProps) {
      if (this.props.value !== nextProps.value) {
        this._transitionNewValue();
      }
    }
  }, {
    key: 'componentWillUnmount',
    value: function componentWillUnmount() {
      if (this._timeout) {
        clearTimeout(this._timeout);
      }
    }
  }, {
    key: 'render',
    value: function render() {
      var _props = this.props,
          id = _props.id,
          className = _props.className,
          name = _props.name,
          value = _props.value,
          label = _props.label,
          placeholder = _props.placeholder,
          active = _props.active,
          activeLabel = _props.activeLabel,
          error = _props.error,
          disabled = _props.disabled,
          required = _props.required,
          toolbar = _props.toolbar,
          below = _props.below,
          lineDirection = _props.lineDirection,
          dropdownIcon = _props.dropdownIcon,
          iconChildren = _props.iconChildren,
          iconClassName = _props.iconClassName,
          transitionName = _props.transitionName,
          transitionTime = _props.transitionTime,
          props = objectWithoutProperties(_props, ['id', 'className', 'name', 'value', 'label', 'placeholder', 'active', 'activeLabel', 'error', 'disabled', 'required', 'toolbar', 'below', 'lineDirection', 'dropdownIcon', 'iconChildren', 'iconClassName', 'transitionName', 'transitionTime']);
      var transition = this.state.transition;


      var divider = void 0;
      if (!below && !toolbar) {
        divider = React.createElement(TextFieldDivider, {
          key: 'text-divider',
          active: active,
          error: error,
          lineDirection: lineDirection,
          className: 'md-divider--select-field'
        });
      }

      var visibleLabel = activeLabel;
      if (!activeLabel && activeLabel !== 0) {
        visibleLabel = (!label || active) && placeholder || '';
      }

      var labelActive = !!activeLabel || activeLabel === 0;

      var icon = dropdownIcon;
      if (iconClassName || iconChildren) {
        icon = React.createElement(
          FontIcon,
          { iconClassName: iconClassName },
          iconChildren
        );
      }
      icon = React.cloneElement(icon, { disabled: disabled });

      return React.createElement(
        AccessibleFakeInkedButton,
        _extends({}, props, {
          id: id + '-toggle',
          role: 'listbox',
          disabled: disabled,
          component: Paper,
          zDepth: below && active ? 1 : 0,
          inkDisabled: !below,
          className: classnames('md-select-field', themeColors({
            disabled: disabled,
            hint: !labelActive && placeholder,
            text: labelActive
          }), className)
        }),
        React.createElement(
          IconSeparator,
          {
            label: visibleLabel,
            labelClassName: transition,
            className: classnames('md-text-field', {
              'md-text-field--margin': !below && !label,
              'md-text-field--floating-margin': label,
              'md-text-field--toolbar': toolbar && !below,
              'md-select-field--text-field': !below,
              'md-select-field--btn': below
            })
          },
          icon
        ),
        divider,
        React.createElement('input', {
          key: 'value',
          type: 'hidden',
          id: id,
          name: name,
          value: value,
          required: required,
          disabled: disabled
        })
      );
    }
  }]);
  return SelectFieldInput;
}(PureComponent);

SelectFieldInput.propTypes = {
  id: propTypes.oneOfType([propTypes.number, propTypes.string]),
  style: propTypes.object,
  className: propTypes.string,
  name: propTypes.string,
  value: propTypes.oneOfType([propTypes.number, propTypes.string]).isRequired,
  disabled: propTypes.bool,
  required: propTypes.bool,
  label: propTypes.node,
  placeholder: propTypes.string,
  active: propTypes.bool,
  activeLabel: propTypes.node,
  below: propTypes.bool,
  error: propTypes.bool,
  toolbar: propTypes.bool,
  dropdownIcon: propTypes.element,
  iconClassName: propTypes.string,
  iconChildren: propTypes.node,
  transitionName: propTypes.string.isRequired,
  transitionTime: propTypes.number.isRequired,
  lineDirection: TextFieldDivider.propTypes.lineDirection
};
SelectFieldInput.defaultProps = {
  transitionName: 'md-drop',
  transitionTime: 300
};

var SelectFieldToggle = function (_PureComponent) {
  inherits(SelectFieldToggle, _PureComponent);

  function SelectFieldToggle() {
    classCallCheck(this, SelectFieldToggle);
    return possibleConstructorReturn(this, (SelectFieldToggle.__proto__ || Object.getPrototypeOf(SelectFieldToggle)).apply(this, arguments));
  }

  createClass(SelectFieldToggle, [{
    key: 'render',
    value: function render() {
      var _props = this.props,
          id = _props.id,
          style = _props.style,
          className = _props.className,
          inputStyle = _props.inputStyle,
          inputClassName = _props.inputClassName,
          required = _props.required,
          disabled = _props.disabled,
          active = _props.active,
          error = _props.error,
          errorText = _props.errorText,
          helpText = _props.helpText,
          helpOnFocus = _props.helpOnFocus,
          visible = _props.visible,
          activeLabel = _props.activeLabel,
          propLabel = _props.label,
          propPlaceholder = _props.placeholder,
          props = objectWithoutProperties(_props, ['id', 'style', 'className', 'inputStyle', 'inputClassName', 'required', 'disabled', 'active', 'error', 'errorText', 'helpText', 'helpOnFocus', 'visible', 'activeLabel', 'label', 'placeholder']);
      var _props2 = this.props,
          label = _props2.label,
          placeholder = _props2.placeholder;

      if (required) {
        if (label) {
          label = addSuffix(label, '*');
        }

        if (placeholder && !label) {
          placeholder = addSuffix(placeholder, '*');
        }
      }

      return React.createElement(
        'div',
        { style: style, className: classnames('md-select-field__toggle', className) },
        React.createElement(FloatingLabel, {
          label: label,
          htmlFor: id,
          active: active || visible,
          error: error,
          floating: isValued(activeLabel) || active || visible,
          disabled: disabled
        }),
        React.createElement(SelectFieldInput, _extends({}, props, {
          id: id,
          style: inputStyle,
          className: inputClassName,
          label: label,
          placeholder: placeholder,
          activeLabel: activeLabel,
          active: active,
          error: error,
          disabled: disabled
        })),
        React.createElement(TextFieldMessage, {
          active: active || visible,
          error: error,
          errorText: errorText,
          helpText: helpText,
          helpOnFocus: helpOnFocus,
          leftIcon: false,
          rightIcon: false
        })
      );
    }
  }]);
  return SelectFieldToggle;
}(PureComponent);

SelectFieldToggle.propTypes = {
  id: propTypes.oneOfType([propTypes.number, propTypes.string]),
  style: propTypes.object,
  className: propTypes.string,
  inputStyle: propTypes.object,
  inputClassName: propTypes.string,
  activeLabel: propTypes.node,
  value: propTypes.oneOfType([propTypes.number, propTypes.string]),
  required: propTypes.bool,
  disabled: propTypes.bool,
  label: propTypes.string,
  placeholder: propTypes.string,
  active: propTypes.bool,
  error: propTypes.bool,
  errorText: propTypes.node,
  helpText: propTypes.node,
  helpOnFocus: propTypes.bool,
  below: propTypes.bool,
  visible: propTypes.bool
};

var MOBILE_LIST_PADDING = 8;
var ARIA_ACTIVE = 'aria-activedescendant';

var SelectField = function (_PureComponent) {
  inherits(SelectField, _PureComponent);

  function SelectField(props) {
    classCallCheck(this, SelectField);

    var _this = possibleConstructorReturn(this, (SelectField.__proto__ || Object.getPrototypeOf(SelectField)).call(this, props));

    _initialiseProps$9.call(_this);

    _this.state = _extends({
      error: false,
      active: false
    }, _this._getActive(props, { value: props.defaultValue }), {
      listProps: defineProperty({
        role: 'listbox',
        ref: _this._scrollActiveIntoView
      }, ARIA_ACTIVE, null),
      match: null,
      lastSearch: null,
      value: props.defaultValue,
      visible: props.defaultVisible
    });

    _this._items = [];
    _this._activeItem = null;
    _this._deleteKeys = _this._getDeleteKeys(props);
    return _this;
  }

  createClass(SelectField, [{
    key: 'componentDidMount',
    value: function componentDidMount() {
      this._container = findDOMNode(this);
      this._field = this._container.querySelector('.md-select-field');
    }
  }, {
    key: 'componentWillReceiveProps',
    value: function componentWillReceiveProps(nextProps) {
      var _props = this.props,
          itemLabel = _props.itemLabel,
          itemValue = _props.itemValue,
          deleteKeys = _props.deleteKeys;

      if (deleteKeys !== nextProps.deleteKeys || itemLabel !== nextProps.itemLabel || itemValue !== nextProps.itemValue) {
        this._deleteKeys = this._getDeleteKeys(nextProps);
      }

      if (this.props.value !== nextProps.value || this.props.menuItems !== nextProps.menuItems) {
        this.setState(this._getActive(nextProps, this.state));
      }
    }

    /**
     * Gets the current value from the select field. This is used when you have an uncontrolled
     * text field and simply need the value from a ref callback.
     *
     * @return {String} the select field's value
     */

  }, {
    key: '_getItemPart',
    value: function _getItemPart(item, itemLabel, itemValue) {
      var preferLabel = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;

      var type = typeof item === 'undefined' ? 'undefined' : _typeof(item);
      if (type === 'number' || type === 'string') {
        return item;
      } else if (type === 'object') {
        var key1 = preferLabel ? itemLabel : itemValue;
        var key2 = preferLabel ? itemValue : itemLabel;
        return typeof item[key1] !== 'undefined' ? item[key1] : item[key2];
      }

      return '';
    }
  }, {
    key: '_getDeleteKeys',
    value: function _getDeleteKeys(_ref) {
      var itemLabel = _ref.itemLabel,
          itemValue = _ref.itemValue,
          itemProps = _ref.itemProps,
          deleteKeys = _ref.deleteKeys;

      var keys = [itemLabel, itemValue, itemProps];
      if (deleteKeys) {
        return keys.concat(Array.isArray(deleteKeys) ? deleteKeys : [deleteKeys]);
      }

      return keys;
    }
  }, {
    key: 'render',
    value: function render() {
      var _props2 = this.props,
          id = _props2.id,
          style = _props2.style,
          className = _props2.className,
          listStyle = _props2.listStyle,
          listClassName = _props2.listClassName,
          toggleStyle = _props2.toggleStyle,
          toggleClassName = _props2.toggleClassName,
          menuItems = _props2.menuItems,
          anchor = _props2.anchor,
          belowAnchor = _props2.belowAnchor,
          fixedTo = _props2.fixedTo,
          position = _props2.position,
          xThreshold = _props2.xThreshold,
          yThreshold = _props2.yThreshold,
          listZDepth = _props2.listZDepth,
          listInline = _props2.listInline,
          listHeightRestricted = _props2.listHeightRestricted,
          block = _props2.block,
          centered = _props2.centered,
          sameWidth = _props2.sameWidth,
          fullWidth = _props2.fullWidth,
          repositionOnScroll = _props2.repositionOnScroll,
          repositionOnResize = _props2.repositionOnResize,
          simplifiedMenu = _props2.simplifiedMenu,
          minLeft = _props2.minLeft,
          minRight = _props2.minRight,
          minBottom = _props2.minBottom,
          fillViewportWidth = _props2.fillViewportWidth,
          fillViewportHeight = _props2.fillViewportHeight,
          menuTransitionName = _props2.menuTransitionName,
          menuTransitionEnterTimeout = _props2.menuTransitionEnterTimeout,
          menuTransitionLeaveTimeout = _props2.menuTransitionLeaveTimeout,
          isOpen = _props2.isOpen,
          propError = _props2.error,
          propMenuId = _props2.menuId,
          propVisible = _props2.visible,
          itemLabel = _props2.itemLabel,
          itemValue = _props2.itemValue,
          itemProps = _props2.itemProps,
          getItemProps = _props2.getItemProps,
          defaultValue = _props2.defaultValue,
          defaultVisible = _props2.defaultVisible,
          onClick = _props2.onClick,
          onKeyDown = _props2.onKeyDown,
          onVisibilityChange = _props2.onVisibilityChange,
          deleteKeys = _props2.deleteKeys,
          stripActiveItem = _props2.stripActiveItem,
          keyboardMatchingTimeout = _props2.keyboardMatchingTimeout,
          defaultOpen = _props2.defaultOpen,
          initiallyOpen = _props2.initiallyOpen,
          onMenuToggle = _props2.onMenuToggle,
          stretchList = _props2.stretchList,
          menuStyle = _props2.menuStyle,
          menuClassName = _props2.menuClassName,
          floatingLabel = _props2.floatingLabel,
          noAutoAdjust = _props2.noAutoAdjust,
          adjustMinWidth = _props2.adjustMinWidth,
          props = objectWithoutProperties(_props2, ['id', 'style', 'className', 'listStyle', 'listClassName', 'toggleStyle', 'toggleClassName', 'menuItems', 'anchor', 'belowAnchor', 'fixedTo', 'position', 'xThreshold', 'yThreshold', 'listZDepth', 'listInline', 'listHeightRestricted', 'block', 'centered', 'sameWidth', 'fullWidth', 'repositionOnScroll', 'repositionOnResize', 'simplifiedMenu', 'minLeft', 'minRight', 'minBottom', 'fillViewportWidth', 'fillViewportHeight', 'menuTransitionName', 'menuTransitionEnterTimeout', 'menuTransitionLeaveTimeout', 'isOpen', 'error', 'menuId', 'visible', 'itemLabel', 'itemValue', 'itemProps', 'getItemProps', 'defaultValue', 'defaultVisible', 'onClick', 'onKeyDown', 'onVisibilityChange', 'deleteKeys', 'stripActiveItem', 'keyboardMatchingTimeout', 'defaultOpen', 'initiallyOpen', 'onMenuToggle', 'stretchList', 'menuStyle', 'menuClassName', 'floatingLabel', 'noAutoAdjust', 'adjustMinWidth']);
      var _props3 = this.props,
          menuId = _props3.menuId,
          listId = _props3.listId,
          error = _props3.error;

      error = error || this.state.error;
      if (!menuId) {
        menuId = id + '-menu';
      }

      if (!listId) {
        listId = menuId + '-options';
      }

      var _state = this.state,
          listProps = _state.listProps,
          active = _state.active,
          activeLabel = _state.activeLabel;

      var below = position === SelectField.Positions.BELOW;
      var visible = typeof isOpen !== 'undefined' ? isOpen : getField(this.props, this.state, 'visible');
      var value = getField(this.props, this.state, 'value');
      var useSameWidth = typeof sameWidth !== 'undefined' ? sameWidth : below;

      var toggle = React.createElement(SelectFieldToggle, _extends({}, props, {
        id: id,
        style: toggleStyle,
        className: toggleClassName,
        visible: visible,
        value: value,
        below: below,
        error: error,
        active: active,
        activeLabel: activeLabel,
        onClick: this._toggle,
        onFocus: this._handleFocus,
        onBlur: this._handleBlur
      }));

      return React.createElement(
        Menu,
        {
          id: menuId,
          listId: listId,
          style: style,
          className: classnames('md-menu--select-field', className),
          listProps: listProps,
          listStyle: listStyle,
          listClassName: listClassName,
          toggle: toggle,
          visible: visible,
          onClose: this._close,
          onKeyDown: this._handleKeyDown,
          onClick: this._handleClick,
          simplified: simplifiedMenu,
          anchor: anchor,
          belowAnchor: belowAnchor,
          fixedTo: fixedTo,
          position: position,
          xThreshold: xThreshold,
          yThreshold: yThreshold,
          listZDepth: listZDepth,
          listInline: listInline,
          listHeightRestricted: listHeightRestricted,
          sameWidth: useSameWidth,
          block: block,
          centered: centered,
          fullWidth: fullWidth,
          minLeft: minLeft,
          minRight: minRight,
          minBottom: minBottom,
          fillViewportWidth: fillViewportWidth,
          fillViewportHeight: fillViewportHeight,
          repositionOnScroll: repositionOnScroll,
          repositionOnResize: repositionOnResize,
          transitionName: menuTransitionName,
          transitionEnterTimeout: menuTransitionEnterTimeout,
          transitionLeaveTimeout: menuTransitionLeaveTimeout
        },
        menuItems.reduce(this._reduceItems, [])
      );
    }
  }, {
    key: 'value',
    get: function get$$1() {
      return getField(this.props, this.state, 'value');
    }
  }]);
  return SelectField;
}(PureComponent);

SelectField.HorizontalAnchors = Menu.HorizontalAnchors;
SelectField.VerticalAnchors = Menu.VerticalAnchors;
SelectField.Positions = Menu.Positions;
SelectField.propTypes = {
  /**
   * An id to give the select field. This is required for accessibility.
   */
  id: isRequiredForA11y(propTypes.oneOfType([propTypes.number, propTypes.string])),

  /**
   * An optional name to give to the select field.
   */
  name: propTypes.string,

  /**
   * An optional id to provide to the select field's menu. If this is omitted,
   * it will default to `${id}-menu`.
   */
  menuId: propTypes.oneOfType([propTypes.number, propTypes.string]),

  /**
   * An optional id to provide to the select field's list.
   *
   * @see {@link #menuId}
   * @see {@link Menus/Menu#menuId}
   */
  listId: propTypes.oneOfType([propTypes.number, propTypes.string]),

  /**
   * An optional style to apply to the select field's container (the menu).
   */
  style: propTypes.object,

  /**
   * An optional className to apply to the select field's container (the menu).
   */
  className: propTypes.string,

  /**
   * An optional style to apply to the menu's list.
   */
  listStyle: propTypes.object,

  /**
   * An optional className to apply to the menu's list.
   */
  listClassName: propTypes.string,

  /**
   * An optional style to apply to the select field's toggle.
   */
  toggleStyle: propTypes.object,

  /**
   * An optional className to apply to the select field's toggle.
   */
  toggleClassName: propTypes.string,

  /**
   * An optional style to apply to the `AccessibleFakeInkedButton` that is the trigger
   * for the select field.
   */
  inputStyle: propTypes.object,

  /**
   * An optional className to apply to the `AccessibleFakeInkedButton` that is the trigger
   * for the select field.
   */
  inputClassName: propTypes.string,

  /**
   * Boolean if the select field should be have the menu's list visible by default.
   */
  defaultVisible: propTypes.bool.isRequired,

  /**
   * Boolean if the select field should have the menu's list visible. This will make
   * the select field controlled and require the `onVisibilityChange` prop to be defined,
   */
  visible: controlled(propTypes.bool, 'onVisibilityChange', 'defaultVisible'),

  /**
   * An optional function to call when the select field's menu has it's visibility changed. The callback
   * will include the next visible state and the event that triggered it.
   */
  onVisibilityChange: propTypes.func,

  /**
   * A list of `number`, `string`, or `object` that should be used to create `ListItem`
   * in the menu's list. When it is an `object`, it will use the `itemLabel` prop as the
   * `primaryText` and use the value of `itemValue`.
   *
   * @see {@link #itemLabel}
   * @see {@link #itemValue}
   */
  menuItems: propTypes.arrayOf(propTypes.oneOfType([propTypes.number, propTypes.string, propTypes.object, propTypes.element])).isRequired,

  /**
   * The amount of time that a list of letters should be used when finding a menu item
   * while typing. Since a user can select items by typing multiple letters in a row,
   * this will be used as the timeout for clearing those letters.
   *
   * For example:
   * - User types `g`
   *
   * Full match is now `'g'`.
   *
   * - User delays 200ms and types `u`
   *
   * Full match is now `'gu'`
   *
   * - User delays 1000ms and types `a`.
   *
   * Full match is now `'a'`
   */
  keyboardMatchingTimeout: propTypes.number.isRequired,

  /**
   * The key to use for extracting a menu item's label if the menu item is an object.
   *
   * Example:
   *
   * ```js
   * const item = { something: 'My Label', somethingElse: 'value' };
   * const itemLabel = 'something';
   * const itemValue = 'somethingElse';
   * ```
   */
  itemLabel: propTypes.string.isRequired,

  /**
   * The key to use for extracting a menu item's value if the menu item is an object.
   *
   * Example:
   *
   * ```js
   * const item = { something: 'My Label', somethingElse: 'value' };
   * const itemLabel = 'something';
   * const itemValue = 'somethingElse';
   * ```
   */
  itemValue: propTypes.string.isRequired,

  /**
   * The key to use for extracting a menu item's function
   * to get additional `ListItem` props if the menu item is an object.
   *
   * Example:
   *
   * ```js
   * const item = { something: 'My Label', addProps: ({active}) => active ? {secondaryText: 'some text'} : null };
   * const itemLabel = 'something';
   * const itemProps = 'addProps';
   * ```
   *
   * @see {@link #getItemProps}
   */
  itemProps: propTypes.string.isRequired,

  /**
   * An optional function to get additional `ListItem` props if the menu item is an object.
   *
   * An object with the following fields will be passed into the function:
   * - `index` - item's index
   * - `active` - whether item is active
   * - `disabled` - whether item is disabled
   * - `itemValue` - item's value
   * - `value` - current list value
   * - `props` - default `ListItem` props
   * - `item` - source item's data
   * - `field` - reference to the component instance
   */
  getItemProps: propTypes.func,

  /**
   * The default value to use for the select field. If this is set, it should either match
   * one of the `number` or `string` in your `menuItems` list or be the empty string. If
   * the `menuItems` is a list of `object`, this value should match one of the menu item's
   * `itemValue` or be the empty string.
   *
   * ```js
   * const menuItems = [{ label: 'Something': value: 0 }, { label: 'Something else', value: 1 }];
   *
   * // both valid
   * defaultValue={0}
   * defaultValue=""
   * ```
   */
  defaultValue: propTypes.oneOfType([propTypes.number, propTypes.string]).isRequired,

  /**
   * The value to use for the select field. If this is defined, it becomes a controlled component
   * and requires the `onChange` prop to be defined. See the `defaultValue` for more behavior info.
   *
   * @see {@link #defaultValue}
   */
  value: controlled(propTypes.oneOfType([propTypes.number, propTypes.string]), 'onChange', 'defaultValue'),

  /**
   * An optional function to call when the select field's value has been changed either when the user
   * has click/touched/keyboard selected a value in the list, or the user has selected a value by typing
   * in the select field while the menu's list is closed.
   *
   * The callback will include the next text field value, the selected item's index, the event that
   * triggered the change, and the id, name, and value of the select field.
   *
   * ```js
   * onChange(value, index, event, { id, name, value });
   * ```
   */
  onChange: propTypes.func,

  /**
   * An optional label to use with the select field. This will be a floating label as seen on the text field.
   */
  label: propTypes.node,

  /**
   * An optional placeholder to use in the select field. This will only appear when no value has been selected.
   */
  placeholder: propTypes.string,

  /**
   * Boolean if the select field should be disabled.
   */
  disabled: propTypes.bool,

  /**
   * Boolean if the select field is required. This will update the label and placeholder to include a `*` suffix.
   */
  required: propTypes.bool,

  /**
   * Boolean if the select field is considered to be in an `error` state.
   *
   * @see {@link TextFields/TextField#error}
   */
  error: propTypes.bool,

  /**
   * An optional text to display when the text select field is in an error state.
   *
   * @see {@link TextFields/TextField#errorText}
   */
  errorText: propTypes.node,

  /**
   * An optional text to display below the select field to provide input help to the user.
   * This will only be displayed if the select field is not in an error state.
   *
   * @see {@link #helpOnFocus}
   * @see {@link TextFields/TextField#errorText}
   */
  helpText: propTypes.node,

  /**
   * Boolean if the `helpText` should only appear on focus.
   *
   * @see {@link #helpText}
   * @see {@link TextFields/TextField#helpOnFocus}
   */
  helpOnFocus: propTypes.bool,

  /**
   * An optional function to call when any element in the select field has been clicked.
   */
  onClick: propTypes.func,

  /**
   * An optional function to call when the `keydown` event has been triggered anywhere in the
   * select field.
   */
  onKeyDown: propTypes.func,

  /**
   * An optional function to call when the select field's toggle has gained focus.
   */
  onFocus: propTypes.func,

  /**
   * An optional function to call when the select field's toggle has been blurred. This
   * will be triggered if the user hits the up or down arrow keys to traverse the list
   * of items.
   */
  onBlur: propTypes.func,

  /**
   * The icon to use to display the dropdown arrow.
   */
  dropdownIcon: propTypes.element,

  /**
   * Boolean if the select field is in a toolbar. This should automatically be injected by the `Toolbar`
   * component if being used as a `titleMenu` or one of the `actions`.
   *
   * @see {@link Toolbars/Toolbar#titleMenu}
   * @see {@link Toolbars/Toolbar#actions}
   */
  toolbar: propTypes.bool,

  /**
   * Boolean if the currently active item should be removed from the list of available `menuItems`.
   * If this is `undefined`, it will strip out the active one only when the
   * `position === SelectField.Positions.BELOW`.
   */
  stripActiveItem: propTypes.bool,

  /**
   * The transition name to use when a new value has been selected. By default, it will have the
   * new item _drop_ into the select field's input location.
   */
  transitionName: propTypes.string.isRequired,

  /**
   * The transition time to use when a new value has been selected. If this value is `0`, there
   * will be no transition.
   */
  transitionTime: propTypes.number.isRequired,

  /**
   * This is how the menu's `List` gets anchored to the select field.
   *
   * @see {@link Helpers/Layover#anchor}
   */
  anchor: anchorShape,

  /**
   * This is the anchor to use when the `position` is set to `Autocomplete.Positions.BELOW`.
   *
   * @see {@link Helpers/Layover#belowAnchor}
   */
  belowAnchor: anchorShape,

  /**
   * This is the animation position for the list that appears.
   *
   * @see {@link Helpers/Layover#animationPosition}
   */
  position: positionShape,

  /**
   * This is how the menu's list will be "fixed" to the `toggle` component.
   *
   * @see {@link Helpers/Layover#fixedTo}
   */
  fixedTo: fixedToShape,

  /**
   * Boolean if the menu's list should appear horizontally instead of vertically.
   */
  listInline: propTypes.bool,

  /**
   * The list's z-depth for applying box shadow. This should be a number from 0 to 5.
   */
  listZDepth: propTypes.number,

  /**
   * Boolean if the list should have its height restricted to the `$md-menu-mobile-max-height`/
   * `$md-menu-desktop-max-height` values.
   *
   * @see [md-menu-mobile-max-height](/components/menus?tab=1#variable-md-menu-mobile-max-height)
   * @see [md-menu-desktop-max-height](/components/menus?tab=1#variable-md-menu-desktop-max-height)
   */
  listHeightRestricted: propTypes.bool,

  /**
   * @see {@link Helpers/Layover#xThreshold}
   */
  xThreshold: propTypes.number,

  /**
   * @see {@link Helpers/Layover#yThreshold}
   */
  yThreshold: propTypes.number,

  /**
   * @see {@link Helpers/Layover#closeOnOutsideClick}
   */
  closeOnOutsideClick: propTypes.bool,

  /**
   * An optional transition name to use for the list appearing/disappearing.
   *
   * @see {@link Menus/Menu#transitionName}
   */
  menuTransitionName: propTypes.string,

  /**
   * @see {@link Helpers/Layover#transitionEnterTimeout}
   */
  menuTransitionEnterTimeout: propTypes.number,

  /**
   * @see {@link Helpers/Layover#transitionLeaveTimeout}
   */
  menuTransitionLeaveTimeout: propTypes.number,

  /**
   * @see {@link Menus/Menu#block}
   */
  block: propTypes.bool,

  /**
   * @see {@link Menus/Menu#fullWidth}
   */
  fullWidth: propTypes.bool,

  /**
   * @see {@link Helpers/Layover#centered}
   */
  centered: Menu.propTypes.centered,

  /**
   * @see {@link Helpers/Layover#sameWidth}
   */
  sameWidth: Menu.propTypes.sameWidth,

  /**
   * Since the `menuItems` get mapped into `ListItem`, this prop is used to remove
   * any unnecessary props from the `ListItem` itself. This is where you
   * would remove parts of your object such as `description` or `__metadata__`.
   */
  deleteKeys: propTypes.oneOfType([propTypes.number, propTypes.string, propTypes.arrayOf(propTypes.oneOfType([propTypes.number, propTypes.string]))]),

  /**
   * Boolean if the menu should automatically try to reposition itself to stay within
   * the viewport when the `fixedTo` element scrolls.
   *
   * @see {@link Helpers/Layover#repositionOnScroll}
   */
  repositionOnScroll: propTypes.bool,

  /**
   * Boolean if the menu should automatically try to reposition itself to stay within
   * the viewport when the window resizes.
   *
   * @see {@link Helpers/Layover#repositionOnResize}
   */
  repositionOnResize: propTypes.bool,

  /**
   * Boolean if the menu logic should be simplified without any viewport logic and position
   * based on the relative position of the menu. This will most like require some additional
   * styles applied to the menu.
   *
   * @see {@link Helpers/Layover#simplified}
   */
  simplifiedMenu: propTypes.bool,

  /**
   * @see {@link Helpers/Layover#minLeft}
   */
  minLeft: Menu.propTypes.minLeft,

  /**
   * @see {@link Helpers/Layover#minRight}
   */
  minRight: Menu.propTypes.minLeft,

  /**
   * @see {@link Helpers/Layover#minBottom}
   */
  minBottom: Menu.propTypes.minBottom,

  /**
   * @see {@link Helpers/Layover#fillViewportWidth}
   */
  fillViewportWidth: propTypes.bool,

  /**
   * @see {@link Helpers/Layover#fillViewportHeight}
   */
  fillViewportHeight: propTypes.bool,

  /**
   * The direction that the underline should appear from.
   */
  lineDirection: propTypes.oneOf(['left', 'center', 'right']).isRequired,

  iconChildren: deprecated(propTypes.node, 'Use `dropdownIcon` instead'),
  iconClassName: deprecated(propTypes.string, 'Use `dropdownIcon` instead'),
  isOpen: deprecated(propTypes.bool, 'Use `visible` instead'),
  defaultOpen: deprecated(propTypes.bool, 'Use `defaultVisible` instead'),
  initiallyOpen: deprecated(propTypes.bool, 'Use `defaultVisible` instead'),
  onMenuToggle: deprecated(propTypes.func, 'Use `onVisibilityChange` instead'),
  stretchList: deprecated(propTypes.bool, 'No longer valid after the changes to the `Menu` component. Possibly use `sameWidth` instead'),
  menuStyle: deprecated(propTypes.object, 'Use `style` instead'),
  menuClassName: deprecated(propTypes.string, 'Use `className` instead'),
  floatingLabel: deprecated(propTypes.bool, 'A select field can only have floating labels now. Only provide the `label` prop'),
  noAutoAdjust: deprecated(propTypes.bool, 'No longer valid to use since select fields are no longer text fields'),
  adjustMinWidth: deprecated(propTypes.bool, 'No longer valid to use since select fields are no longer text fields')
};
SelectField.defaultProps = {
  anchor: {
    x: SelectField.HorizontalAnchors.INNER_LEFT,
    y: SelectField.VerticalAnchors.OVERLAP
  },
  fixedTo: Menu.defaultProps.fixedTo,
  position: SelectField.Positions.TOP_LEFT,
  itemLabel: 'label',
  itemValue: 'value',
  itemProps: 'getProps',
  dropdownIcon: React.createElement(
    FontIcon,
    null,
    'arrow_drop_down'
  ),
  lineDirection: 'left',
  menuItems: [],
  defaultValue: '',
  defaultVisible: false,
  keyboardMatchingTimeout: 1000,
  transitionName: 'md-drop',
  transitionTime: 300,
  repositionOnScroll: true,
  repositionOnResize: false
};

var _initialiseProps$9 = function _initialiseProps() {
  var _this2 = this;

  this._getActiveItemLabel = function (item, value, itemLabel, itemValue) {
    var v = _this2._getItemPart(item, itemLabel, itemValue);
    var label = _this2._getItemPart(item, itemLabel, itemValue, true);

    return v === value || v === parseInt(value, 10) ? label : '';
  };

  this._getActive = function (props, state) {
    var activeLabel = '';
    var activeIndex = -1;
    var value = getField(props, state, 'value');
    if (isValued(value)) {
      var menuItems = props.menuItems,
          itemLabel = props.itemLabel,
          itemValue = props.itemValue;


      menuItems.some(function (item, index) {
        activeLabel = _this2._getActiveItemLabel(item, value, itemLabel, itemValue);
        var found = isValued(activeLabel);
        if (found) {
          activeIndex = index;
        }

        return found;
      });
    }

    return { activeLabel: activeLabel, activeIndex: activeIndex };
  };

  this._attemptItemFocus = function (index) {
    if (index === -1) {
      return;
    }

    var item = _this2._items[index];
    if (item) {
      item.focus();
    }
  };

  this._setListItem = function (item) {
    if (!item) {
      return;
    }

    if (item.props.active) {
      _this2._activeItem = findDOMNode(item);
      item.focus();

      if (!_this2.state.listProps[ARIA_ACTIVE]) {
        _this2.setState({ listProps: _extends({}, _this2.state.listProps, defineProperty({}, ARIA_ACTIVE, _this2.props.id + '-options-active')) });
      }
    }

    _this2._items.push(item);
  };

  this._scrollActiveIntoView = function (listRef) {
    if (listRef === null) {
      _this2._items = [];
      return;
    } else if (!_this2._activeItem) {
      return;
    }

    var list = findDOMNode(listRef);
    var offsetTop = _this2._activeItem.offsetTop;

    list.scrollTop = offsetTop > MOBILE_LIST_PADDING ? offsetTop : 0;
  };

  this._toggle = function (e) {
    var _props4 = _this2.props,
        isOpen = _props4.isOpen,
        onVisibilityChange = _props4.onVisibilityChange,
        onMenuToggle = _props4.onMenuToggle;

    var visible = !(typeof isOpen !== 'undefined' ? isOpen : getField(_this2.props, _this2.state, 'visible'));
    if (onMenuToggle || onVisibilityChange) {
      (onMenuToggle || onVisibilityChange)(visible, e);
    }

    var state = void 0;
    if (typeof isOpen === 'undefined' && typeof _this2.props.visible === 'undefined') {
      state = { visible: visible };
    }

    if (state) {
      _this2.setState(state);
    }
  };

  this._close = function (e) {
    if (_this2.props.onVisibilityChange) {
      _this2.props.onVisibilityChange(false, e);
    }

    if (e.type === 'keydown' && _this2._field) {
      _this2._field.focus();
    }

    var state = void 0;
    if (_this2.props.required && !getField(_this2.props, _this2.state, 'value')) {
      state = { error: true };
    }

    if (typeof _this2.props.visible === 'undefined') {
      state = state || {};
      state.visible = false;
    }

    if (state) {
      _this2.setState(state);
    }
  };

  this._handleClick = function (e) {
    if (_this2.props.onClick) {
      _this2.props.onClick(e);
    }

    var isOpen = _this2.props.isOpen;

    var visible = typeof isOpen !== 'undefined' ? isOpen : getField(_this2.props, _this2.state, 'visible');
    if (visible && _this2._container) {
      var node = e.target;
      while (_this2._container.contains(node)) {
        if (node.dataset && typeof node.dataset.id !== 'undefined') {
          var _node$dataset = node.dataset,
              id = _node$dataset.id,
              value = _node$dataset.value;

          _this2._selectItem(parseInt(id, 10), value, e);
          return;
        }

        node = node.parentNode;
      }
    }
  };

  this._selectItem = function (dataIndex, dataValue, e) {
    var _props5 = _this2.props,
        required = _props5.required,
        menuItems = _props5.menuItems,
        itemLabel = _props5.itemLabel,
        itemValue = _props5.itemValue,
        onChange = _props5.onChange,
        id = _props5.id,
        name = _props5.name;

    var value = _this2._getItemPart(menuItems[dataIndex], itemLabel, itemValue);
    var prevValue = getField(_this2.props, _this2.state, 'value');
    if (prevValue !== value && onChange) {
      onChange(value, dataIndex, e, { id: id, name: name, value: value });
    }

    var state = _extends({}, _this2._getActive({ value: value, itemLabel: itemLabel, itemValue: itemValue, menuItems: menuItems }, {}), {
      error: !!required && !value && value !== 0
    });

    if (typeof _this2.props.value === 'undefined') {
      state.value = value;
    }

    _this2.setState(state);
  };

  this._handleFocus = function (e) {
    if (_this2.props.onFocus) {
      _this2.props.onFocus(e);
    }

    _this2.setState({ active: true });
  };

  this._handleBlur = function (e) {
    if (_this2.props.onBlur) {
      _this2.props.onBlur(e);
    }

    var error = _this2.state.error;
    var _props6 = _this2.props,
        isOpen = _props6.isOpen,
        required = _props6.required;

    var visible = typeof isOpen !== 'undefined' ? isOpen : getField(_this2.props, _this2.state, 'visible');
    var value = getField(_this2.props, _this2.state, 'value');

    if (required && !visible) {
      error = !value;
    }

    _this2.setState({ active: false, error: error });
  };

  this._handleKeyDown = function (e) {
    var _props7 = _this2.props,
        isOpen = _props7.isOpen,
        onKeyDown = _props7.onKeyDown;

    if (onKeyDown) {
      onKeyDown(e);
    }

    var key = e.which || e.keyCode;
    var up = key === UP;
    var down = key === DOWN;
    var visible = typeof isOpen !== 'undefined' ? isOpen : getField(_this2.props, _this2.state, 'visible');

    if (up || down) {
      e.preventDefault();

      if (!visible) {
        _this2._toggle(e);
        return;
      }

      _this2._advanceFocus(up);
    } else if (!visible && handleKeyboardAccessibility(e, _this2._toggle, true, true)) {
      return;
    } else if (visible && (key === ESC || key === TAB)) {
      if (_this2._field && key === ESC) {
        _this2._field.focus();
      }

      _this2._close(e);
      return;
    } else {
      _this2._selectItemByLetter(key, e);
    }
  };

  this._advanceFocus = function (decrement) {
    var _props8 = _this2.props,
        position = _props8.position,
        stripActiveItem = _props8.stripActiveItem;
    var activeIndex = _this2.state.activeIndex;


    var below = position === SelectField.Positions.BELOW;
    var value = getField(_this2.props, _this2.state, 'value');
    var valued = isValued(value);
    var itemStripped = (typeof stripActiveItem !== 'undefined' ? stripActiveItem : below) && valued;

    // If the select field is positioned below and there is no value, need to increment the last index
    // by one since this select field removes the active item. Need to account for that here when there
    // is no value.
    var lastIndex = _this2._items.length - (itemStripped ? 0 : 1);
    if (decrement && activeIndex <= 0 || !decrement && activeIndex >= lastIndex) {
      return;
    }

    var nextIndex = Math.max(-1, Math.min(lastIndex, activeIndex + (decrement ? -1 : 1)));
    if (nextIndex === activeIndex) {
      return;
    }

    _this2._attemptItemFocus(nextIndex - (itemStripped ? 1 : 0));
    _this2.setState({ activeIndex: nextIndex });
  };

  this._selectItemByLetter = function (key, e) {
    var charCode = String.fromCharCode(key);
    var isLetter = charCode && charCode.match(/[A-Za-z0-9-_ ]/);
    var isKeypad = isBetween(key, KEYPAD_ZERO, KEYPAD_NINE);
    if (!isBetween(key, ZERO, NINE) && !isKeypad && !isLetter) {
      return;
    }

    var letter = isLetter ? charCode : String(key - (isKeypad ? KEYPAD_ZERO : ZERO));

    if (_this2._matchingTimeout) {
      clearTimeout(_this2._matchingTimeout);
    }

    _this2._matchingTimeout = setTimeout(function () {
      _this2._matchingTimeout = null;

      _this2.setState({ match: null, lastSearch: null });
    }, _this2.props.keyboardMatchingTimeout);

    _this2._selectFirstMatch(letter, e);
  };

  this._selectFirstMatch = function (letter, e) {
    var _props9 = _this2.props,
        menuItems = _props9.menuItems,
        itemLabel = _props9.itemLabel,
        itemValue = _props9.itemValue,
        isOpen = _props9.isOpen,
        onChange = _props9.onChange,
        id = _props9.id,
        name = _props9.name;
    var lastSearch = _this2.state.lastSearch;

    var match = -1;
    var search = ('' + (lastSearch || '') + letter).toUpperCase();
    menuItems.some(function (item, index) {
      if (item && (typeof item === 'undefined' ? 'undefined' : _typeof(item)) === 'object' && item.disabled) {
        return false;
      }

      var label = String(_this2._getItemPart(item, itemLabel, itemValue, true));
      if (label && label.toUpperCase().replace(/\s/g, '').indexOf(search) === 0) {
        match = index;
      }

      return match > -1;
    });

    var state = {
      match: match,
      lastSearch: search
    };

    if (match !== -1) {
      var activeItem = menuItems[match];
      state.activeLabel = _this2._getItemPart(activeItem, itemLabel, itemValue, true);
      state.activeIndex = match;

      var visible = typeof isOpen !== 'undefined' ? isOpen : getField(_this2.props, _this2.state, 'visible');
      if (visible) {
        if (state.match !== _this2.state.match) {
          _this2._attemptItemFocus(state.activeIndex);
        }
      } else {
        var value = _this2._getItemPart(activeItem, itemLabel, itemValue);
        var prevValue = getField(_this2.props, _this2.state, 'value');

        if (value !== prevValue && onChange) {
          onChange(value, match, e, { id: id, name: name, value: value });
        }

        if (typeof _this2.props.value === 'undefined') {
          state.value = value;
        }
      }
    }

    _this2.setState(state);
  };

  this._reduceItems = function (items, item, i) {
    if (item === null) {
      return items;
    } else if (React.isValidElement(item)) {
      items.push(item);
      return items;
    }

    var _props10 = _this2.props,
        getItemProps = _props10.getItemProps,
        id = _props10.id,
        itemLabel = _props10.itemLabel,
        itemProps = _props10.itemProps,
        itemValue = _props10.itemValue,
        position = _props10.position,
        stripActiveItem = _props10.stripActiveItem;

    var below = position === SelectField.Positions.BELOW;
    var value = getField(_this2.props, _this2.state, 'value');

    var dataValue = _this2._getItemPart(item, itemLabel, itemValue);
    var primaryText = _this2._getItemPart(item, itemLabel, itemValue, true);

    var active = dataValue === value || dataValue === parseInt(value, 10);
    var stripped = (typeof stripActiveItem !== 'undefined' ? stripActiveItem : below) && active;
    if (!stripped) {
      var objectType = (typeof item === 'undefined' ? 'undefined' : _typeof(item)) === 'object';
      var props = objectType ? omit(item, _this2._deleteKeys) : {};
      var disabled = props.disabled || false;
      props.ref = disabled ? null : _this2._setListItem;
      props.id = active ? id + '-options-active' : null;
      props.active = active;
      props.tabIndex = -1;
      props.primaryText = primaryText;
      props.key = item.key || dataValue;
      props.role = 'option';
      props['data-id'] = disabled ? null : i;
      props['data-value'] = disabled ? null : dataValue;

      var getProps = objectType && item[itemProps] || getItemProps;
      if (typeof getProps === 'function') {
        Object.assign(props, getProps({
          index: i,
          active: active,
          disabled: disabled,
          itemValue: itemValue,
          value: value,
          props: props,
          item: item,
          field: _this2
        }));
      }

      items.push(React.createElement(ListItem, props));
    }

    return items;
  };
};

/**
 * This is just a simple <tfoot> component.
 */

var TableFooter = function (_PureComponent) {
  inherits(TableFooter, _PureComponent);

  function TableFooter() {
    classCallCheck(this, TableFooter);
    return possibleConstructorReturn(this, (TableFooter.__proto__ || Object.getPrototypeOf(TableFooter)).apply(this, arguments));
  }

  createClass(TableFooter, [{
    key: 'getChildContext',
    value: function getChildContext() {
      return { footer: true };
    }
  }, {
    key: 'render',
    value: function render() {
      var _props = this.props,
          className = _props.className,
          children = _props.children,
          props = objectWithoutProperties(_props, ['className', 'children']);


      return React.createElement(
        'tfoot',
        _extends({ className: classnames('md-table-footer', className) }, props),
        children
      );
    }
  }]);
  return TableFooter;
}(PureComponent);

TableFooter.propTypes = {
  /**
   * An optional style to apply.
   */
  style: propTypes.object,

  /**
   * An optional className to apply.
   */
  className: propTypes.string,

  /**
   * The children to display. This should really be one or a list of `TableRow`
   * components.
   */
  children: propTypes.node
};
TableFooter.childContextTypes = {
  footer: propTypes.bool
};

/**
 * The `TablePagination` component is used to generate the table footer that helps
 * pagination through a large dataset by limiting the number of rows per page.
 * The pagination will always be placed persistently at the bottom of the table
 * so that when a user scrolls to the right, they will always be able to use the
 * pagination.
 */

var TablePagination = function (_PureComponent) {
  inherits(TablePagination, _PureComponent);

  function TablePagination(props, context) {
    classCallCheck(this, TablePagination);

    var _this = possibleConstructorReturn(this, (TablePagination.__proto__ || Object.getPrototypeOf(TablePagination)).call(this, props, context));

    _initialiseProps$8.call(_this);

    var controlledPage = typeof props.page !== 'undefined';
    var controlledRowsPerPage = typeof props.rowsPerPage !== 'undefined';
    var rowsPerPage = controlledRowsPerPage ? props.rowsPerPage : props.defaultRowsPerPage;
    var page = controlledPage ? props.page : props.defaultPage;
    _this.state = {
      start: (page - 1) * rowsPerPage,
      controlsMarginLeft: 0
    };

    if (!controlledPage) {
      _this.state.page = page;
    }

    if (!controlledRowsPerPage) {
      _this.state.rowsPerPage = props.defaultRowsPerPage;
    }

    _this._table = null;
    _this._ticking = false;
    return _this;
  }

  createClass(TablePagination, [{
    key: 'componentWillReceiveProps',
    value: function componentWillReceiveProps(nextProps) {
      var _props = this.props,
          rowsPerPage = _props.rowsPerPage,
          page = _props.page;

      if (page !== nextProps.page || rowsPerPage !== nextProps.rowsPerPage) {
        var rpp = getField(nextProps, this.state, 'rowsPerPage');
        var p = getField(nextProps, this.state, 'page');

        this.setState({ start: (p - 1) * rpp });
      }
    }
  }, {
    key: 'render',
    value: function render() {
      var _state = this.state,
          controlsMarginLeft = _state.controlsMarginLeft,
          start = _state.start;
      var _props2 = this.props,
          className = _props2.className,
          selectFieldStyle = _props2.selectFieldStyle,
          selectFieldClassName = _props2.selectFieldClassName,
          selectFieldInputStyle = _props2.selectFieldInputStyle,
          selectFieldInputClassName = _props2.selectFieldInputClassName,
          rows = _props2.rows,
          rowsPerPageLabel = _props2.rowsPerPageLabel,
          rowsPerPageItems = _props2.rowsPerPageItems,
          incrementIcon = _props2.incrementIcon,
          decrementIcon = _props2.decrementIcon,
          simplifiedMenu = _props2.simplifiedMenu,
          incrementIconChildren = _props2.incrementIconChildren,
          incrementIconClassName = _props2.incrementIconClassName,
          decrementIconChildren = _props2.decrementIconChildren,
          decrementIconClassName = _props2.decrementIconClassName,
          propId = _props2.id,
          propIncrementId = _props2.incrementId,
          propDecrementId = _props2.decrementId,
          onPagination = _props2.onPagination,
          propRowsPerPage = _props2.rowsPerPage,
          propPage = _props2.page,
          defaultPage = _props2.defaultPage,
          defaultRowsPerPage = _props2.defaultRowsPerPage,
          props = objectWithoutProperties(_props2, ['className', 'selectFieldStyle', 'selectFieldClassName', 'selectFieldInputStyle', 'selectFieldInputClassName', 'rows', 'rowsPerPageLabel', 'rowsPerPageItems', 'incrementIcon', 'decrementIcon', 'simplifiedMenu', 'incrementIconChildren', 'incrementIconClassName', 'decrementIconChildren', 'decrementIconClassName', 'id', 'incrementId', 'decrementId', 'onPagination', 'rowsPerPage', 'page', 'defaultPage', 'defaultRowsPerPage']);
      var baseId = this.context.baseId;

      var rowsPerPage = getField(this.props, this.state, 'rowsPerPage');
      var _props3 = this.props,
          id = _props3.id,
          incrementId = _props3.incrementId,
          decrementId = _props3.decrementId;

      if (!id) {
        id = baseId + '-pagination';
      }

      if (!incrementId) {
        incrementId = id + '-increment-btn';
      }

      if (!decrementId) {
        decrementId = id + '-decrement-btn';
      }

      var pagination = start + 1 + '-' + Math.min(rows, start + rowsPerPage) + ' of ' + rows;
      return React.createElement(
        TableFooter,
        _extends({}, props, { className: classnames('md-table-footer--pagination', className) }),
        React.createElement(ResizeObserver$1, { watchWidth: true, component: 'tr', onResize: this._throttledPosition }),
        React.createElement(ResizeObserver$1, { watchWidth: true, component: 'tr', target: this._table, onResize: this._throttledPosition }),
        React.createElement(
          'tr',
          null,
          React.createElement(
            TableColumn$1,
            { colSpan: '100%' },
            React.createElement(
              'div',
              {
                ref: this._setControls,
                className: 'md-table-pagination md-table-pagination--controls md-text',
                style: { marginLeft: controlsMarginLeft }
              },
              React.createElement(
                'span',
                { className: 'md-table-pagination__label' },
                rowsPerPageLabel
              ),
              React.createElement(SelectField, {
                id: id,
                menuItems: rowsPerPageItems,
                position: SelectField.Positions.BELOW,
                style: selectFieldStyle,
                className: selectFieldClassName,
                inputStyle: selectFieldInputStyle,
                inputClassName: classnames('md-select-field--pagination', selectFieldInputClassName),
                value: rowsPerPage,
                onChange: this._setRowsPerPage,
                simplifiedMenu: simplifiedMenu
              }),
              React.createElement(
                'span',
                { className: 'md-table-pagination--label' },
                pagination
              ),
              React.createElement(Button$1, {
                id: decrementId,
                icon: true,
                onClick: this._decrement,
                disabled: start === 0,
                iconEl: getDeprecatedIcon(decrementIconClassName, decrementIconChildren, decrementIcon)
              }),
              React.createElement(Button$1, {
                id: incrementId,
                icon: true,
                onClick: this._increment,
                disabled: start + rowsPerPage >= rows,
                iconEl: getDeprecatedIcon(incrementIconClassName, incrementIconChildren, incrementIcon)
              })
            ),
            React.createElement('div', { className: 'md-table-pagination' })
          )
        )
      );
    }
  }]);
  return TablePagination;
}(PureComponent);

TablePagination.propTypes = {
  /**
   * An optional id to provide to the select field. If this is omitted, it will be
   * the `DataTable`'s `baseId` with '-pagination'.
   *
   * @see {@link DataTables/DataTable#baseId}
   */
  id: propTypes.oneOfType([propTypes.number, propTypes.string]),

  /**
   * An optional id to provide to the increment icon button. If this is omitted, it will be
   * the `id` with '-increment-btn'.
   *
   * @see {@link #id}
   */
  incrementId: propTypes.oneOfType([propTypes.number, propTypes.string]),

  /**
   * An optional id to provide to the decrement icon button. If this is omitted, it will be
   * the `id` with '-decrement-btn'.
   *
   * @see {@link #id}
   */
  decrementId: propTypes.oneOfType([propTypes.number, propTypes.string]),

  /**
   * An optional style to apply to the `tfoot` tag.
   */
  style: propTypes.object,

  /**
   * An optional className to apply to the `tfoot` tag.
   */
  className: propTypes.string,

  /**
   * An optional style to apply to the select field.
   *
   * @see {@link SelectFields/SelectField#style}
   */
  selectFieldStyle: propTypes.object,

  /**
   * An optional className to apply to the select field.
   *
   * @see {@link SelectFields/SelectField#className}
   */
  selectFieldClassName: propTypes.string,

  /**
   * An optional style to apply to the select field's input.
   *
   * @see {@link SelectFields/SelectField#inputStyle}
   */
  selectFieldInputStyle: propTypes.object,

  /**
   * An optional className to apply to the select field's input.
   *
   * @see {@link SelectFields/SelectField#inputClassName}
   */
  selectFieldInputClassName: propTypes.string,

  /**
   * Boolean if the select field should use the simplified menu logic.
   *
   * @see {@link Helpers/Layover#simplified}
   */
  simplifiedMenu: propTypes.bool,

  /**
   * A function to call when a user clicks the increment or decrement pagination
   * icon button. This function will be given the new start index and the number
   * or rows per page as well as the current page.
   *
   * ```js
   * onPagination(newStart, rowsPerPage, currentPage);
   * ```
   */
  onPagination: propTypes.func.isRequired,

  /**
   * The current value for the select field holding the number of rows per page.
   */
  rowsPerPage: propTypes.number,

  /**
   * The current page for the pagination. This will make the component controlled, so the only way to get pagination
   * is making sure you are updating this prop after the `onPagination` callback is called.
   *
   * Pages start from 1 instead of 0.
   */
  page: propTypes.number,

  /**
   * The default page to start from for the pagination. Pages start from 1 instead of 0.
   */
  defaultPage: propTypes.number.isRequired,

  /**
   * The default number of rows per page to display. This will be the value for the
   * `SelectField`.
   */
  defaultRowsPerPage: propTypes.number.isRequired,

  /**
   * The label to use for the rows per page `SelectField`.
   */
  rowsPerPageLabel: propTypes.node.isRequired,

  /**
   * A list of numbers for the amount of rows per page to display at a time.
   * This will be rendered into the `SelectField`.
   */
  rowsPerPageItems: propTypes.arrayOf(propTypes.number).isRequired,

  /**
   * The total number of rows that can be displayed. This is the unfiltered/non-subset
   * number of rows. This is used to help calculate the increment/decrement values to
   * display and determine if the user can increment/decrement again.
   */
  rows: propTypes.number.isRequired,

  /**
   * The icon to use for the increment icon button.
   */
  incrementIcon: propTypes.element,

  /**
   * The icon to use for the decrement icon button.
   */
  decrementIcon: propTypes.element,

  incrementIconChildren: deprecated(propTypes.node, 'Use the `incrementIcon` prop instead'),
  incrementIconClassName: deprecated(propTypes.string, 'Use the `incrementIcon` prop instead'),
  decrementIconChildren: deprecated(propTypes.node, 'Use the `decrementIcon` prop instead'),
  decrementIconClassName: deprecated(propTypes.string, 'Use the `decrementIcon` prop instead')
};
TablePagination.contextTypes = {
  baseId: propTypes.oneOfType([propTypes.number, propTypes.string]).isRequired,
  fixedFooter: propTypes.bool
};
TablePagination.defaultProps = {
  defaultPage: 1,
  defaultRowsPerPage: 10,
  rowsPerPageLabel: 'Rows per page:',
  rowsPerPageItems: [10, 20, 30, 40, 50, 100],
  incrementIcon: React.createElement(
    FontIcon,
    null,
    'keyboard_arrow_right'
  ),
  decrementIcon: React.createElement(
    FontIcon,
    null,
    'keyboard_arrow_left'
  ),
  simplifiedMenu: false
};

var _initialiseProps$8 = function _initialiseProps() {
  var _this2 = this;

  this._setControls = function (controls) {
    _this2._controls = controls;
    _this2._table = findTable(controls);

    if (_this2._table && _this2.context.fixedFooter) {
      _this2._table.addEventListener('scroll', _this2._throttledPosition);
    }
  };

  this._position = function () {
    if (_this2._table) {
      var fixedFooter = _this2.context.fixedFooter;
      var _table = _this2._table,
          offsetWidth = _table.offsetWidth,
          scrollLeft = _table.scrollLeft;


      var controlsMarginLeft = offsetWidth - _this2._controls.offsetWidth;
      if (fixedFooter) {
        controlsMarginLeft += scrollLeft;
      }

      _this2.setState({
        controlsMarginLeft: Math.max(24, controlsMarginLeft)
      });
    }
  };

  this._throttledPosition = function () {
    if (!_this2._ticking) {
      requestAnimationFrame(function () {
        _this2._ticking = false;
        _this2._position();
      });
    }

    _this2._ticking = true;
  };

  this._increment = function () {
    var _props4 = _this2.props,
        rows = _props4.rows,
        onPagination = _props4.onPagination;
    var start = _this2.state.start;

    var rowsPerPage = getField(_this2.props, _this2.state, 'rowsPerPage');
    var page = getField(_this2.props, _this2.state, 'page');

    // Only correct multiple of rows per page
    var max = rows - rows % rowsPerPage;

    var newStart = Math.min(start + rowsPerPage, max);
    var nextPage = page + 1;

    onPagination(newStart, rowsPerPage, nextPage);
    if (typeof _this2.props.page === 'undefined') {
      _this2.setState({ start: newStart, page: nextPage });
    }
  };

  this._decrement = function () {
    var start = _this2.state.start;

    var page = getField(_this2.props, _this2.state, 'page');
    var rowsPerPage = getField(_this2.props, _this2.state, 'rowsPerPage');
    var newStart = Math.max(0, start - rowsPerPage);
    var nextPage = page - 1;

    _this2.props.onPagination(newStart, rowsPerPage, nextPage);
    if (typeof _this2.props.page === 'undefined') {
      _this2.setState({ start: newStart, page: nextPage });
    }
  };

  this._setRowsPerPage = function (rowsPerPage) {
    var page = 1;
    var newStart = 0;
    _this2.props.onPagination(newStart, rowsPerPage, page);
    var nextState = void 0;
    if (typeof _this2.props.rowsPerPage === 'undefined') {
      nextState = { rowsPerPage: rowsPerPage };
    }

    if (typeof _this2.props.page === 'undefined') {
      nextState = nextState || {};
      nextState.start = newStart;
    }

    if (nextState) {
      _this2.setState(nextState);
    }
  };
};

/** @module utils/EventUtils/isValidFocusKeypress */
/**
 * Checks if a keydown or keyup event's key was the TAB key or any additional valid
 * keys that were passed in.
 *
 * @param {Object} event - The event to check.
 * @param {Array.<number>=} additionalKeys - An optional array of additional key codes
 *    that are considered valid for a focus event.
 */
function isValidFocusKeypress(event, additionalKeys) {
  var key = event.which || event.keyCode;
  return key === TAB || additionalKeys && additionalKeys.indexOf(key) !== -1;
}

var hrefables = ['a', 'area'].map(function (tag) {
  return tag + '[href],';
}).join('');
var disableables = ['button', 'input', 'textarea', 'select'].map(function (tag) {
  return tag + ':not([disabled]),';
}).join('');
var FOCUSABLE_QUERY = '' + hrefables + disableables + '*[tabIndex]';

/**
 * This component is used for keeping the focus within some container. When the container
 * is mounted and the `focusOnMount` prop is `true`, it will attempt to focus either:
 * - an element that matches `document.getElementById(this.props.initialFocus)`
 * - an element that matches `this._container.querySelector(this.props.initialFocus)`
 * - the first focusable element in it's children (if `this.props.initialFocus` is omitted)
 */

var FocusContainer = function (_PureComponent) {
  inherits(FocusContainer, _PureComponent);

  function FocusContainer() {
    var _ref;

    var _temp, _this, _ret;

    classCallCheck(this, FocusContainer);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = possibleConstructorReturn(this, (_ref = FocusContainer.__proto__ || Object.getPrototypeOf(FocusContainer)).call.apply(_ref, [this].concat(args))), _this), _this._enableFocusTrap = function () {
      window.addEventListener('keydown', _this._handleKeyDown, true);
    }, _this._disableFocusTrap = function () {
      window.removeEventListener('keydown', _this._handleKeyDown, true);
    }, _this._attemptInitialFocus = function () {
      if (!_this._container) {
        return;
      }

      var initialFocus = _this.props.initialFocus;


      var toFocus = initialFocus ? document.getElementById(initialFocus) || _this._container.querySelector(initialFocus) : _this._focusables[0];

      var debugError = void 0;
      if (!toFocus && initialFocus) {
        debugError = ' The `initialFocus` did not match a document\'s `id` or was an invalid ';
        debugError += '`querySelector` for the container. `initialFocus`: `' + initialFocus + '`. ';
        debugError += 'If this was supposed to be an `id`, make sure to prefix with the `#` symbol.';
      }

      if (process.env.NODE_ENV !== 'production' && !toFocus) {
        throw new Error('You specified that the `FocusContainer` should focus an element on mount, ' + 'but a focusable element was not found in the children. This could be because ' + 'the `initialFocus` prop is an invalid id or query selector, or the children ' + ('do not contain a valid focusable element.' + debugError));
      }

      if (toFocus) {
        toFocus.focus();
      }
    }, _this._containFocus = function (containerRef) {
      if (containerRef === null) {
        _this._container = null;
        _this._disableFocusTrap();
        return;
      }

      var _this$props = _this.props,
          focusOnMount = _this$props.focusOnMount,
          containFocus = _this$props.containFocus;

      _this._container = findDOMNode(containerRef);
      _this._focusables = Array.prototype.slice.call(_this._container.querySelectorAll(FOCUSABLE_QUERY)).filter(function (el) {
        return el.tabIndex !== -1;
      });

      if (focusOnMount) {
        _this._attemptInitialFocus();
      }

      if (containFocus) {
        _this._enableFocusTrap();
      }
    }, _this._handleKeyDown = function (e) {
      _this._shifted = e.shiftKey;
      if (!isValidFocusKeypress(e, _this.props.additionalFocusKeys)) {
        return;
      } else if (_this._focusables.length === 1) {
        e.preventDefault();
        return;
      }

      var target = e.target,
          shiftKey = e.shiftKey;

      var _this$_focusables = toArray(_this._focusables),
          first = _this$_focusables[0],
          focusables = _this$_focusables.slice(1);

      var last = focusables[focusables.length - 1];

      if (shiftKey && target === first) {
        e.preventDefault();
        last.focus();
      } else if (!shiftKey && target === last) {
        e.preventDefault();
        first.focus();
      }
    }, _temp), possibleConstructorReturn(_this, _ret);
  }

  createClass(FocusContainer, [{
    key: 'componentWillReceiveProps',
    value: function componentWillReceiveProps(nextProps) {
      if (this.props.containFocus === nextProps.containFocus) {
        return;
      }

      if (nextProps.containFocus) {
        this._enableFocusTrap();
        this._attemptInitialFocus();
      } else {
        this._disableFocusTrap();
      }
    }
  }, {
    key: 'componentDidUpdate',
    value: function componentDidUpdate() {
      if (this.props.containFocus && this._container) {
        this._focusables = Array.prototype.slice.call(this._container.querySelectorAll(FOCUSABLE_QUERY)).filter(function (el) {
          return el.tabIndex !== -1;
        });
      }
    }
  }, {
    key: 'componentWillUnmount',
    value: function componentWillUnmount() {
      if (this.props.containFocus) {
        this._disableFocusTrap();
      }
    }

    /**
     * Manages the event listeners to contain the focus within some container.  When the container
     * ref is not null, the container has mounted and then attempts to focus an element inside
     * if the `focusOnMount` prop is `true`.
     */

  }, {
    key: 'render',
    value: function render() {
      var _props = this.props,
          Component$$1 = _props.component,
          initialFocus = _props.initialFocus,
          focusOnMount = _props.focusOnMount,
          containFocus = _props.containFocus,
          additionalFocusKeys = _props.additionalFocusKeys,
          props = objectWithoutProperties(_props, ['component', 'initialFocus', 'focusOnMount', 'containFocus', 'additionalFocusKeys']);


      return React.createElement(Component$$1, _extends({}, props, { ref: this._containFocus }));
    }
  }]);
  return FocusContainer;
}(PureComponent);

FocusContainer.propTypes = {
  /**
   * The component to render as. This can be a React DOM element or
   * a react Component.
   */
  component: propTypes.oneOfType([propTypes.string, propTypes.func]).isRequired,

  /**
   * An optional style to apply.
   */
  style: propTypes.object,

  /**
   * An optional className to apply.
   */
  className: propTypes.string,

  /**
   * The children to display.
   */
  children: propTypes.node,

  /**
   * An optional id string or a query selector string to use for the initial focus.
   * This will only be triggered if the `focusOnMount` prop is `true`. If this is
   * omitted and the `focusOnMount` prop is `true`, the first focusable element in the
   * container will be focused.
   *
   * Examples:
   *
   * ```js
   * initialFocus="#someAmazingId"
   * // or
   * initialFocus=".md-btn,.md-list-tile"
   * ```
   */
  initialFocus: propTypes.string,

  /**
   * Boolean if an element in the container should be focused when mounted.
   */
  focusOnMount: propTypes.bool,

  /**
   * An optional list of additional key codes to use for focus events.
   */
  additionalFocusKeys: propTypes.arrayOf(propTypes.number),

  /**
   * Boolean if the focus container should start or stop containing the focus within the container.
   * This is useful for changing the focus requirements after mount.
   */
  containFocus: propTypes.bool
};
FocusContainer.defaultProps = {
  component: 'div',
  containFocus: true
};

var DialogTitle = function (_PureComponent) {
  inherits(DialogTitle, _PureComponent);

  function DialogTitle() {
    classCallCheck(this, DialogTitle);
    return possibleConstructorReturn(this, (DialogTitle.__proto__ || Object.getPrototypeOf(DialogTitle)).apply(this, arguments));
  }

  createClass(DialogTitle, [{
    key: 'render',
    value: function render() {
      var _props = this.props,
          children = _props.children,
          className = _props.className,
          props = objectWithoutProperties(_props, ['children', 'className']);


      if (!children) {
        return null;
      }

      return React.createElement(
        'h2',
        _extends({}, props, { className: classnames('md-title md-title--dialog', className) }),
        children
      );
    }
  }]);
  return DialogTitle;
}(PureComponent);

DialogTitle.propTypes = {
  id: propTypes.oneOfType([propTypes.number, propTypes.string]),
  className: propTypes.string,
  children: propTypes.node
};

var FOOTER_PADDING = 8;

var DialogFooter = function (_PureComponent) {
  inherits(DialogFooter, _PureComponent);

  function DialogFooter() {
    var _ref;

    var _temp, _this, _ret;

    classCallCheck(this, DialogFooter);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = possibleConstructorReturn(this, (_ref = DialogFooter.__proto__ || Object.getPrototypeOf(DialogFooter)).call.apply(_ref, [this].concat(args))), _this), _this.state = { stacked: false }, _this._setContainer = function (container) {
      if (container !== null) {
        _this._container = container;
        var maxWidth = (_this._container.offsetWidth - FOOTER_PADDING * 3) / 2;

        var stacked = false;
        Array.prototype.slice.call(_this._container.querySelectorAll('.md-btn')).some(function (_ref2) {
          var offsetWidth = _ref2.offsetWidth;

          stacked = offsetWidth > maxWidth;
          return stacked;
        });

        _this.setState({ stacked: stacked });
      }
    }, _this._generateActions = function () {
      var actions = _this.props.actions;

      if (!actions) {
        return null;
      } else if (Array.isArray(actions)) {
        return actions.map(_this._toElement);
      }

      return _this._toElement(actions);
    }, _temp), possibleConstructorReturn(_this, _ret);
  }

  createClass(DialogFooter, [{
    key: '_toElement',
    value: function _toElement(action, index) {
      if (isValidElement(action)) {
        var button = Children.only(action);

        return cloneElement(action, {
          key: button.key || index,
          className: classnames('md-btn--dialog', button.props.className)
        });
      }

      // Both label and children are valid for dialog actions
      var label = action.label,
          children = action.children,
          remaining = objectWithoutProperties(action, ['label', 'children']);

      return React.createElement(
        Button$1,
        _extends({
          key: index,
          flat: true
        }, remaining, {
          className: classnames('md-btn--dialog', action.className)
        }),
        label || children
      );
    }
  }, {
    key: 'render',
    value: function render() {
      var _props = this.props,
          actions = _props.actions,
          className = _props.className,
          children = _props.children,
          propStacked = _props.stacked,
          props = objectWithoutProperties(_props, ['actions', 'className', 'children', 'stacked']);


      if (!children && (!actions || Array.isArray(actions) && !actions.length)) {
        return null;
      }

      var stacked = this.props.stacked;

      var stackedDefined = typeof propStacked !== 'undefined';
      if (!stackedDefined) {
        stacked = this.state.stacked;
      }

      return React.createElement(
        'footer',
        _extends({}, props, {
          className: classnames('md-dialog-footer', {
            'md-dialog-footer--inline': !stacked,
            'md-dialog-footer--stacked': stacked
          }, className),
          ref: !stackedDefined ? this._setContainer : null
        }),
        this._generateActions(),
        children
      );
    }
  }]);
  return DialogFooter;
}(PureComponent);

DialogFooter.propTypes = {
  style: propTypes.object,
  className: propTypes.string,
  children: propTypes.node,
  actions: propTypes.oneOfType([propTypes.element, propTypes.object, propTypes.arrayOf(propTypes.oneOfType([propTypes.element, propTypes.object]))]),
  stacked: propTypes.bool
};

var DIFF_KEYS = ['style', 'height', 'width', 'contentStyle'];

/**
 * The `Dialog` is just a static component for creating dialogs. Dialogs
 * seemed like they could be used outside of the `DialogContainer` component,
 * so it was exposed as well. In *most* cases, you will still want to use
 * the `DialogContainer` component.
 */

var Dialog = function (_PureComponent) {
  inherits(Dialog, _PureComponent);

  function Dialog(props) {
    classCallCheck(this, Dialog);

    var _this = possibleConstructorReturn(this, (Dialog.__proto__ || Object.getPrototypeOf(Dialog)).call(this));

    _initialiseProps$11.call(_this);

    var height = props.height,
        width = props.width;

    var styles = props.style;
    if (height || width) {
      styles = styles || {};
      styles = _extends({ height: height, width: width }, styles);
    }

    _this.state = {
      styles: styles,
      contentStyles: props.contentStyle,
      contentPadded: false
    };
    return _this;
  }

  createClass(Dialog, [{
    key: 'getChildContext',
    value: function getChildContext() {
      return { renderNode: this._renderNode };
    }
  }, {
    key: 'componentWillMount',
    value: function componentWillMount() {
      var _props = this.props,
          pageX = _props.pageX,
          pageY = _props.pageY;

      if (!pageX || !pageY) {
        return;
      }

      this.setState({ styles: this._getStyles(this.props) });
    }
  }, {
    key: 'componentDidMount',
    value: function componentDidMount() {
      if (this.props.onOpen) {
        this.props.onOpen();
      }
    }
  }, {
    key: 'componentWillReceiveProps',
    value: function componentWillReceiveProps(nextProps) {
      var _this2 = this;

      if (DIFF_KEYS.some(function (key) {
        return nextProps[key] !== _this2.props[key];
      })) {
        this.setState({
          styles: this._getStyles(nextProps),
          contentStyles: _extends({}, this.state.contentStyles, nextProps.contentStyle)
        });
      }
    }
  }, {
    key: 'componentWillUnmount',
    value: function componentWillUnmount() {
      if (this.props.onLeave) {
        this.props.onLeave();
      }
    }
  }, {
    key: 'render',
    value: function render() {
      var _state = this.state,
          contentPadded = _state.contentPadded,
          styles = _state.styles,
          contentStyles = _state.contentStyles;
      var _props2 = this.props,
          id = _props2.id,
          className = _props2.className,
          titleStyle = _props2.titleStyle,
          titleClassName = _props2.titleClassName,
          footerStyle = _props2.footerStyle,
          footerClassName = _props2.footerClassName,
          contentClassName = _props2.contentClassName,
          title = _props2.title,
          Content = _props2.contentComponent,
          contentProps = _props2.contentProps,
          actions = _props2.actions,
          children = _props2.children,
          fullPage = _props2.fullPage,
          centered = _props2.centered,
          autopadContent = _props2.autopadContent,
          paddedContent = _props2.paddedContent,
          autosizeContent = _props2.autosizeContent,
          stackedActions = _props2.stackedActions,
          style = _props2.style,
          contentStyle = _props2.contentStyle,
          pageX = _props2.pageX,
          pageY = _props2.pageY,
          containerX = _props2.containerX,
          containerY = _props2.containerY,
          onOpen = _props2.onOpen,
          onLeave = _props2.onLeave,
          height = _props2.height,
          width = _props2.width,
          props = objectWithoutProperties(_props2, ['id', 'className', 'titleStyle', 'titleClassName', 'footerStyle', 'footerClassName', 'contentClassName', 'title', 'contentComponent', 'contentProps', 'actions', 'children', 'fullPage', 'centered', 'autopadContent', 'paddedContent', 'autosizeContent', 'stackedActions', 'style', 'contentStyle', 'pageX', 'pageY', 'containerX', 'containerY', 'onOpen', 'onLeave', 'height', 'width']);
      var labelledBy = this.props['aria-labelledby'];

      var titleId = id + '-title';
      if (!labelledBy && title) {
        labelledBy = titleId;
      }

      var padDefined = typeof paddedContent !== 'undefined';
      var dialogChildren = fullPage ? children : [React.createElement(
        DialogTitle,
        {
          key: 'title',
          id: titleId,
          style: titleStyle,
          className: titleClassName
        },
        title
      ), React.createElement(
        Content,
        _extends({
          ref: !padDefined && autopadContent ? this._setContent : null,
          key: 'content'
        }, contentProps, {
          style: contentStyles,
          className: classnames('md-dialog-content', {
            'md-dialog-content--padded': padDefined ? paddedContent : contentPadded
          }, contentClassName)
        }),
        autosizeContent ? React.createElement(ResizeObserver$1, { watchHeight: true, watchWidth: true, onResize: this._handleContentResize }) : null,
        children
      ), React.createElement(DialogFooter, {
        key: 'footer',
        style: footerStyle,
        className: footerClassName,
        actions: actions,
        stacked: stackedActions
      })];

      return React.createElement(
        Paper,
        _extends({}, props, {
          id: id,
          component: FocusContainer,
          ref: this._setRenderNode,
          style: styles,
          className: classnames('md-dialog', {
            'md-dialog--full-page': fullPage,
            'md-dialog--centered': centered
          }, className),
          role: 'dialog',
          'aria-labelledby': labelledBy
        }),
        dialogChildren
      );
    }
  }]);
  return Dialog;
}(PureComponent);

Dialog.propTypes = {
  /**
   * @see {@link Dialogs/DialogContainer#id}
   */
  id: isRequiredForA11y(propTypes.oneOfType([propTypes.number, propTypes.string])),

  /**
   * @see {@link Dialogs/DialogContainer#aria-describedby}
   */
  'aria-describedby': oneRequiredForA11y(propTypes.oneOfType([propTypes.number, propTypes.string]), 'title', 'aria-labelledby', 'aria-label'),

  /**
   * @see {@link Dialogs/DialogContainer#aria-labelledby}
   */
  'aria-labelledby': propTypes.oneOfType([propTypes.number, propTypes.string]),

  /**
   * @see {@link Dialogs/DialogContainer#aria-label}
   */
  'aria-label': propTypes.string,

  /**
   * An optional style to apply to the dialog.
   */
  style: propTypes.object,

  /**
   * An optional className to apply to the dialog.
   */
  className: propTypes.string,

  /**
   * An optional styke to apply to the title.
   */
  titleStyle: propTypes.object,

  /**
   * An optional className to apply to the title.
   */
  titleClassName: propTypes.string,

  /**
   * An optional style to apply to the footer. This is used when the `actions`
   * prop is defined.
   */
  footerStyle: propTypes.object,

  /**
   * An optional className to apply to the footer. This is used when the `actions`
   * prop is defined.
   */
  footerClassName: propTypes.string,

  /**
   * An optional style to apply to the dialog's content.
   */
  contentStyle: propTypes.object,

  /**
   * An optional className to apply to the dialog's content.
   */
  contentClassName: propTypes.string,

  /**
   * The component to render the content as. This is helpful if you would like to use
   * the CSSTransitionGroup. This really just saves a tiny bit of markup.
   *
   * ```js
   * <Dialog
   *   contentComponent={CSSTransitionGroup}
   *   contentProps={{
   *     transitionName: 'md-cross-fade',
   *     transitionLeave: false,
   *     transitionEnterTimeout: 150,
   *   }}
   * >
   *   {dynamicContent}
   * </Dialog>
   * ```
   */
  contentComponent: propTypes.oneOfType([propTypes.string, propTypes.func]).isRequired,

  /**
   * Any additional props to pass to the content component.
   */
  contentProps: propTypes.object,

  /**
   * An optional title to display in the dialog.
   */
  title: propTypes.node,

  /**
   * Any children to display in the content of the dialog.
   */
  children: propTypes.node,

  /**
   * A single action or a list of actions to display in the dialog. This can either be a list
   * of `FlatButton` props or `<Button flat {...props} />` elements.
   */
  actions: propTypes.oneOfType([propTypes.element, propTypes.object, propTypes.arrayOf(propTypes.oneOfType([propTypes.element, propTypes.object]))]),

  /**
   * @see {@link Helpers/FocusContainer#additionalFocusKeys}
   */
  additionalFocusKeys: FocusContainer.propTypes.additionalFocusKeys,

  /**
   * @see {@link Helpers/FocusContainer#initialFocus}
   */
  initialFocus: FocusContainer.propTypes.initialFocus,

  /**
   * @see {@link Helpers/FocusContainer#focusOnMount}
   */
  focusOnMount: FocusContainer.propTypes.focusOnMount,

  /**
   * @see {@link Helpers/FocusContainer#containFocus}
   */
  containFocus: FocusContainer.propTypes.containFocus,

  /**
   * An optional x coordinate on the page that caused a full page dialog
   * to be created. This is really just used for a `transformOrigin` style.
   */
  pageX: propTypes.number,

  /**
   * An optional y coordinate on the page that caused a full page dialog
   * to be created. This is really just used for a `transformOrigin` style.
   */
  pageY: propTypes.number,

  /**
   * An optional x scroll position of the container holding the dialog. This
   * is really just used for a `transformOrigin` style on full page dialogs.
   */
  containerX: propTypes.number,

  /**
   * An optional y scroll position of the container holding the dialog. This
   * is really just used for a `transformOrigin` style on full page dialogs.
   */
  containerY: propTypes.number,

  /**
   * Boolean if the dialog should be rendered as a full page dialog.
   */
  fullPage: propTypes.bool,

  /**
   * The zDepth to use for the dialog.
   */
  zDepth: propTypes.number.isRequired,

  /**
   * An optional function to call when the dialog has been opened. This is
   * really just used for the `DialogContainer`.
   */
  onOpen: propTypes.func,

  /**
   * An optional function to call when the dialog has been closed. This is
   * really just used for the `DialogContainer`.
   */
  onLeave: propTypes.func,

  /**
   * Boolean if the dialog should be centered in the page.
   */
  centered: propTypes.bool,

  /**
   * Boolean if the content should be padded. This will take precedence
   * over the `autopadContent` prop. So if this is defined, that value
   * will be used instead of any thing that was was calculated in this
   * component.
   *
   * @see {@link #autopadContent}
   */
  paddedContent: propTypes.bool,

  /**
   * Boolean if the dialog should automatically try to determine if the content
   * should be padded. It will be padded if the dialog does not contain a `List`.
   */
  autopadContent: propTypes.bool,

  /**
   * Boolean if the dialog content's size should automatically be resized to overflow
   * correctly when there is a lot of content. This will calculate and apply some `maxHeight`
   * to the `contentStyle`.
   */
  autosizeContent: propTypes.bool,

  /**
   * An optional height to apply to the dialog. This is used if it is easier to just apply height/width
   * with for specific dialogs instead of in CSS.
   *
   * **This prop should not be used if the `fullPage` prop is enabled.**
   *
   * @see {@link #fullPage}
   * @see {@link #width}
   */
  height: propTypes.oneOfType([propTypes.number, propTypes.string]),

  /**
   * An optional width to apply to the dialog. This is used if it is easier to just apply height/width
   * with for specific dialogs instead of in CSS.
   *
   * **This prop should not be used if the `fullPage` prop is enabled.**
   *
   * @see {@link #fullPage}
   * @see {@link #height}
   */
  width: propTypes.oneOfType([propTypes.number, propTypes.string]),

  /**
   * Boolean if the actions should be stacked on top of each other. If this value is `undefined`, it will
   * automatically attempt to guess if the items should be stacked.
   */
  stackedActions: propTypes.bool
};
Dialog.defaultProps = {
  autopadContent: true,
  autosizeContent: true,
  contentComponent: 'section',
  zDepth: 5
};
Dialog.childContextTypes = {
  renderNode: propTypes.object
};

var _initialiseProps$11 = function _initialiseProps() {
  var _this3 = this;

  this._getStyles = function () {
    var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : _this3.props,
        pageX = _ref.pageX,
        containerX = _ref.containerX,
        pageY = _ref.pageY,
        containerY = _ref.containerY,
        height = _ref.height,
        width = _ref.width,
        style = _ref.style;

    return _extends({
      height: typeof height !== 'undefined' ? height : null,
      width: typeof width !== 'undefined' ? width : null,
      transformOrigin: pageX || pageY ? pageX - containerX + 'px ' + (pageY - containerY) + 'px' : null
    }, style);
  };

  this._setRenderNode = function (dialog) {
    _this3._renderNode = findDOMNode(dialog);
  };

  this._setContent = function (content) {
    if (content !== null) {
      _this3._content = findDOMNode(content);
      var contentPadded = _this3._content.querySelectorAll('.md-list').length === 0;

      _this3.setState({ contentPadded: contentPadded });
    }
  };

  this._handleContentResize = function (_ref2) {
    var scrollHeight = _ref2.scrollHeight,
        content = _ref2.el;

    var maxHeight = content.style.maxHeight;
    var dialog = content.parentNode;
    content.style.maxHeight = 'none';
    var title = _this3.props.title ? dialog.querySelector('.md-title--dialog') : null;
    var footer = _this3.props.actions ? dialog.querySelector('.md-dialog-footer') : null;

    var totalHeight = dialog.offsetHeight - (title ? title.offsetHeight : 0) - (footer ? footer.offsetHeight : 0);
    content.style.maxHeight = maxHeight;
    var equalHeight = totalHeight === scrollHeight;
    if (equalHeight) {
      var currentHeight = _this3.state.contentStyles && _this3.state.contentStyles.maxHeight || null;
      if (currentHeight && currentHeight !== scrollHeight) {
        _this3.setState({ contentStyles: _this3.props.contentStyle });
      }
    } else {
      _this3.setState({ contentStyles: _extends({ maxHeight: totalHeight }, _this3.props.contentStyle) });
    }
  };
};

var EditDialog = function (_PureComponent) {
  inherits(EditDialog, _PureComponent);

  function EditDialog() {
    classCallCheck(this, EditDialog);
    return possibleConstructorReturn(this, (EditDialog.__proto__ || Object.getPrototypeOf(EditDialog)).apply(this, arguments));
  }

  createClass(EditDialog, [{
    key: 'render',
    value: function render() {
      var _props = this.props,
          id = _props.id,
          dialogStyle = _props.dialogStyle,
          dialogClassName = _props.dialogClassName,
          dialogContentStyle = _props.dialogContentStyle,
          dialogContentClassName = _props.dialogContentClassName,
          textFieldId = _props.textFieldId,
          visible = _props.visible,
          header = _props.header,
          onOpen = _props.onOpen,
          children = _props.children,
          label = _props.label,
          title = _props.title,
          large = _props.large,
          actions = _props.actions,
          placeholder = _props.placeholder,
          dialogZDepth = _props.dialogZDepth,
          props = objectWithoutProperties(_props, ['id', 'dialogStyle', 'dialogClassName', 'dialogContentStyle', 'dialogContentClassName', 'textFieldId', 'visible', 'header', 'onOpen', 'children', 'label', 'title', 'large', 'actions', 'placeholder', 'dialogZDepth']);


      var field = React.createElement(
        AccessibleFakeButton,
        {
          className: classnames('md-edit-dialog__label', {
            'md-edit-dialog__header': header
          }, themeColors({ hint: placeholder || header })),
          noFocusOutline: visible,
          onClick: onOpen,
          onFocus: onOpen
        },
        label
      );

      return React.createElement(
        Layover,
        _extends({}, props, {
          id: id + '-layover',
          toggle: field,
          visible: visible,
          block: true,
          belowAnchor: null
        }),
        React.createElement(
          Dialog,
          {
            id: id,
            'aria-labelledby': !large ? textFieldId : undefined,
            style: dialogStyle,
            className: classnames('md-edit-dialog', themeColors({ background: true, themeText: false }), dialogClassName),
            contentStyle: dialogContentStyle,
            contentClassName: classnames('md-edit-dialog__content', dialogContentClassName),
            title: large ? title : null,
            focusOnMount: true,
            containFocus: !!large,
            paddedContent: false,
            actions: large ? actions : null,
            zDepth: dialogZDepth
          },
          children
        )
      );
    }
  }]);
  return EditDialog;
}(PureComponent);

EditDialog.propTypes = {
  id: propTypes.oneOfType([propTypes.number, propTypes.string]),
  textFieldId: propTypes.oneOfType([propTypes.number, propTypes.string]),
  style: propTypes.object,
  className: propTypes.string,
  dialogStyle: propTypes.object,
  dialogClassName: propTypes.string,
  dialogContentStyle: propTypes.object,
  dialogContentClassName: propTypes.string,
  children: propTypes.node,
  onOpen: propTypes.func.isRequired,
  onClose: propTypes.func.isRequired,
  visible: propTypes.bool.isRequired,
  label: propTypes.oneOfType([propTypes.number, propTypes.string]).isRequired,
  placeholder: propTypes.bool,
  title: propTypes.node,
  large: propTypes.bool,
  actions: Dialog.propTypes.actions,
  dialogZDepth: propTypes.number,
  header: propTypes.bool
};

function findFixedTo(table) {
  if (table && table.firstChild.firstChild.classList.contains('md-data-table__scroll-wrapper')) {
    return {
      x: table,
      y: table.firstChild.firstChild
    };
  }

  return table;
}

/**
 * The `EditDialogColumn` is used when there should be used when a table column's value
 * can be changed. It can either be displayed as a dialog or inline.
 *
 * All props that are not documented but provided will be passed on to the `TextField`
 * component.
 */

var EditDialogColumn = function (_PureComponent) {
  inherits(EditDialogColumn, _PureComponent);

  function EditDialogColumn(props) {
    classCallCheck(this, EditDialogColumn);

    var _this = possibleConstructorReturn(this, (EditDialogColumn.__proto__ || Object.getPrototypeOf(EditDialogColumn)).call(this, props));

    _initialiseProps$10.call(_this);

    _this.state = {
      visible: props.defaultVisible,
      value: props.defaultValue,
      cancelValue: props.defaultValue,
      actions: _this._makeActions(props),
      cellIndex: undefined
    };
    return _this;
  }

  createClass(EditDialogColumn, [{
    key: 'componentDidMount',
    value: function componentDidMount() {
      this._column = findDOMNode(this);
      this._table = findTable(this._column);
      this._fixedTo = findFixedTo(this._table);

      // If a developer creates their own component to wrap the EditDialogColumn, the cellIndex prop
      // might not be defined if they don't pass ...props
      var cellIndex = this.props.cellIndex;

      if (!cellIndex && cellIndex !== 0) {
        var columns = [].slice.call(this._column.parentNode.querySelectorAll('th,td'));
        this.setState({ cellIndex: columns.indexOf(this._column) }); // eslint-disable-line react/no-did-mount-set-state
      }
    }
  }, {
    key: 'componentWillReceiveProps',
    value: function componentWillReceiveProps(nextProps) {
      var _props = this.props,
          okLabel = _props.okLabel,
          okPrimary = _props.okPrimary,
          okSecondary = _props.okSecondary,
          okProps = _props.okProps,
          cancelLabel = _props.cancelLabel,
          cancelPrimary = _props.cancelPrimary,
          cancelSecondary = _props.cancelSecondary,
          cancelProps = _props.cancelProps;


      if (okLabel !== nextProps.okLabel || okPrimary !== nextProps.okPrimary || okSecondary !== nextProps.okSecondary || cancelLabel !== nextProps.cancelLabel || cancelPrimary !== nextProps.cancelPrimary || cancelSecondary !== nextProps.cancelSecondary || okProps !== nextProps.okProps || cancelProps !== nextProps.cancelProps) {
        this.setState({ actions: this._makeActions(nextProps) });
      }
    }
  }, {
    key: 'render',
    value: function render() {
      var rowId = this.context.rowId;
      var _props2 = this.props,
          style = _props2.style,
          className = _props2.className,
          layoverStyle = _props2.layoverStyle,
          layoverClassName = _props2.layoverClassName,
          dialogStyle = _props2.dialogStyle,
          dialogClassName = _props2.dialogClassName,
          dialogContentStyle = _props2.dialogContentStyle,
          dialogContentClassName = _props2.dialogContentClassName,
          dialogZDepth = _props2.dialogZDepth,
          textFieldStyle = _props2.textFieldStyle,
          textFieldClassName = _props2.textFieldClassName,
          inputClassName = _props2.inputClassName,
          large = _props2.large,
          title = _props2.title,
          inline = _props2.inline,
          inlineIcon = _props2.inlineIcon,
          maxLength = _props2.maxLength,
          label = _props2.label,
          placeholder = _props2.placeholder,
          header = _props2.header,
          anchor = _props2.anchor,
          belowAnchor = _props2.belowAnchor,
          fixedTo = _props2.fixedTo,
          animationPosition = _props2.animationPosition,
          xThreshold = _props2.xThreshold,
          yThreshold = _props2.yThreshold,
          centered = _props2.centered,
          sameWidth = _props2.sameWidth,
          repositionOnScroll = _props2.repositionOnScroll,
          repositionOnResize = _props2.repositionOnResize,
          transitionName = _props2.transitionName,
          transitionEnterTimeout = _props2.transitionEnterTimeout,
          transitionLeaveTimeout = _props2.transitionLeaveTimeout,
          tooltipLabel = _props2.tooltipLabel,
          tooltipDelay = _props2.tooltipDelay,
          tooltipPosition = _props2.tooltipPosition,
          onClick = _props2.onClick,
          onMouseDown = _props2.onMouseDown,
          onMouseUp = _props2.onMouseUp,
          onTouchStart = _props2.onTouchStart,
          onTouchEnd = _props2.onTouchEnd,
          onMouseEnter = _props2.onMouseEnter,
          onMouseOver = _props2.onMouseOver,
          onMouseLeave = _props2.onMouseLeave,
          onTouchMove = _props2.onTouchMove,
          simplifiedDialog = _props2.simplifiedDialog,
          minLeft = _props2.minLeft,
          minRight = _props2.minRight,
          minBottom = _props2.minBottom,
          noIcon = _props2.noIcon,
          inlineIconChildren = _props2.inlineIconChildren,
          inlineIconClassName = _props2.inlineIconClassName,
          propId = _props2.id,
          propDialogId = _props2.dialogId,
          propCellIndex = _props2.cellIndex,
          onOkClick = _props2.onOkClick,
          okLabel = _props2.okLabel,
          okPrimary = _props2.okPrimary,
          okSecondary = _props2.okSecondary,
          okProps = _props2.okProps,
          onCancelClick = _props2.onCancelClick,
          cancelLabel = _props2.cancelLabel,
          cancelPrimary = _props2.cancelPrimary,
          cancelSecondary = _props2.cancelSecondary,
          cancelProps = _props2.cancelProps,
          okOnOutsideClick = _props2.okOnOutsideClick,
          defaultValue = _props2.defaultValue,
          adjusted = _props2.adjusted,
          scrollIntoView = _props2.scrollIntoView,
          scrollIntoViewPadding = _props2.scrollIntoViewPadding,
          defaultVisible = _props2.defaultVisible,
          visibleOnFocus = _props2.visibleOnFocus,
          scrollThreshold = _props2.scrollThreshold,
          enforceMinWidth = _props2.enforceMinWidth,
          transitionDuration = _props2.transitionDuration,
          props = objectWithoutProperties(_props2, ['style', 'className', 'layoverStyle', 'layoverClassName', 'dialogStyle', 'dialogClassName', 'dialogContentStyle', 'dialogContentClassName', 'dialogZDepth', 'textFieldStyle', 'textFieldClassName', 'inputClassName', 'large', 'title', 'inline', 'inlineIcon', 'maxLength', 'label', 'placeholder', 'header', 'anchor', 'belowAnchor', 'fixedTo', 'animationPosition', 'xThreshold', 'yThreshold', 'centered', 'sameWidth', 'repositionOnScroll', 'repositionOnResize', 'transitionName', 'transitionEnterTimeout', 'transitionLeaveTimeout', 'tooltipLabel', 'tooltipDelay', 'tooltipPosition', 'onClick', 'onMouseDown', 'onMouseUp', 'onTouchStart', 'onTouchEnd', 'onMouseEnter', 'onMouseOver', 'onMouseLeave', 'onTouchMove', 'simplifiedDialog', 'minLeft', 'minRight', 'minBottom', 'noIcon', 'inlineIconChildren', 'inlineIconClassName', 'id', 'dialogId', 'cellIndex', 'onOkClick', 'okLabel', 'okPrimary', 'okSecondary', 'okProps', 'onCancelClick', 'cancelLabel', 'cancelPrimary', 'cancelSecondary', 'cancelProps', 'okOnOutsideClick', 'defaultValue', 'adjusted', 'scrollIntoView', 'scrollIntoViewPadding', 'defaultVisible', 'visibleOnFocus', 'scrollThreshold', 'enforceMinWidth', 'transitionDuration']);
      var _state = this.state,
          visible = _state.visible,
          actions = _state.actions;

      var value = getField(this.props, this.state, 'value');
      var cellIndex = getField(this.props, this.state, 'cellIndex');

      var _props3 = this.props,
          id = _props3.id,
          dialogId = _props3.dialogId;

      if (!dialogId) {
        dialogId = (id || rowId + '-' + cellIndex) + '-edit-dialog';
      }

      if (!id) {
        id = dialogId + '-field';
      }

      var inlineEditIcon = void 0;
      if (inline && !noIcon) {
        var icon = getDeprecatedIcon(inlineIconClassName, inlineIconChildren, inlineIcon);
        if (icon) {
          inlineEditIcon = React.cloneElement(icon, { key: 'edit-icon' });
        }
      }

      var numeric = props.type === 'number';
      var field = React.createElement(TextField, _extends({}, props, {
        ref: this._setField,
        style: textFieldStyle,
        className: classnames({ 'md-edit-dialog__blocked-field': inline }, textFieldClassName),
        inputClassName: classnames({
          'md-edit-dialog__header': header && inline,
          'md-text-right': numeric
        }, themeColors({ hint: header && inline }), inputClassName),
        id: id,
        label: label,
        placeholder: placeholder,
        value: value,
        onFocus: this._handleFocus,
        onChange: this._handleChange,
        onKeyDown: this._handleKeyDown,
        block: inline,
        maxLength: visible ? maxLength : null,
        rightIcon: inlineEditIcon
      }));

      var children = void 0;
      if (inline) {
        children = field;
      } else {
        var dialogLabel = value || value === 0 ? value : placeholder || label;
        children = React.createElement(
          EditDialog,
          {
            style: layoverStyle,
            className: layoverClassName,
            dialogStyle: dialogStyle,
            dialogClassName: dialogClassName,
            dialogContentStyle: dialogContentStyle,
            dialogContentClassName: dialogContentClassName,
            id: dialogId,
            textFieldId: id,
            visible: visible,
            onOpen: this._handleOpen,
            onClose: this._handleClose,
            label: dialogLabel,
            actions: actions,
            large: large,
            title: title,
            header: header,
            placeholder: dialogLabel === placeholder || dialogLabel === label,
            simplified: simplifiedDialog,
            anchor: anchor,
            belowAnchor: belowAnchor,
            animationPosition: animationPosition,
            xThreshold: xThreshold,
            yThreshold: yThreshold,
            centered: centered,
            sameWidth: sameWidth,
            minLeft: minLeft,
            minRight: minRight,
            minBottom: minBottom,
            fixedTo: typeof fixedTo !== 'undefined' ? fixedTo : this._fixedTo,
            dialogZDepth: dialogZDepth,
            repositionOnScroll: repositionOnScroll,
            repositionOnResize: repositionOnResize,
            transitionName: transitionName,
            transitionEnterTimeout: transitionEnterTimeout,
            transitionLeaveTimeout: transitionLeaveTimeout
          },
          field
        );
      }

      return React.createElement(
        TableColumn$1,
        {
          style: style,
          numeric: numeric,
          className: classnames('md-edit-dialog-column', className),
          header: header,
          adjusted: false,
          tooltipLabel: tooltipLabel,
          tooltipDelay: tooltipDelay,
          tooltipPosition: tooltipPosition,
          onClick: onClick,
          onMouseDown: onMouseDown,
          onMouseUp: onMouseUp,
          onTouchStart: onTouchStart,
          onTouchMove: onTouchMove,
          onMouseEnter: onMouseEnter,
          onMouseOver: onMouseOver,
          onMouseLeave: onMouseLeave,
          onTouchEnd: onTouchEnd
        },
        children
      );
    }
  }]);
  return EditDialogColumn;
}(PureComponent);

EditDialogColumn.VerticalAnchors = Layover.VerticalAnchors;
EditDialogColumn.HorizontalAnchors = Layover.HorizontalAnchors;
EditDialogColumn.Positions = Layover.Positions;
EditDialogColumn.propTypes = {
  /**
   * An optional id to use for the text field in the column. If this is omitted,
   * the id will be `${dialogId}-field`.
   *
   * @see {@link #dialogId}
   */
  id: propTypes.oneOfType([propTypes.number, propTypes.string]),

  /**
   * An optional id to use for the dialog that appears in the column. If this is omitted,
   * the id will be `${rowId}-${cellIndex}-edit-dialog-field`.
   */
  dialogId: propTypes.oneOfType([propTypes.number, propTypes.string]),

  /**
   * The optional style to apply to the edit dialog's column.
   */
  style: propTypes.object,

  /**
   * The optional className to apply to the edit dialog's column.
   */
  className: propTypes.string,

  /**
   * An optional style to apply to the dialog's surrounding `Layover` component.
   */
  layoverStyle: propTypes.object,

  /**
   * An optional className to the dialog's surrounding `Layover` component.
   */
  layoverClassName: propTypes.string,

  /**
   * The optional style to apply to the edit dialog.
   */
  dialogStyle: propTypes.object,

  /**
   * The optional className to apply to the edit dialog.
   */
  dialogClassName: propTypes.string,

  /**
   * An optional style to apply to the dialog's content area. This is the area
   * that holds the text field.
   */
  dialogContentStyle: propTypes.object,

  /**
   * An optional class name to apply to the dialog's content area. This is the area
   * that holds the text field.
   */
  dialogContentClassName: propTypes.string,

  /**
   * The zDepth to apply to the dialog when not inline.
   *
   * @see {@link Papers/Paper#zDepth}
   */
  dialogZDepth: propTypes.number.isRequired,

  /**
   * An optional style to apply to the text field.
   */
  textFieldStyle: propTypes.object,

  /**
   * An optional class name to apply to the text field.
   */
  textFieldClassName: propTypes.string,

  /**
   * An optional style to apply to the text field's input.
   */
  inputStyle: propTypes.object,

  /**
   * An optional class name to apply to the text field's input.
   */
  inputClassName: propTypes.string,

  /**
   * Boolean if the edit dialog is currently disabled.
   */
  disabled: propTypes.bool,

  /**
   * Boolean if the text field should be editable inline instead of in a dialog.
   *
   * @see {@link #inlineIcon}
   */
  inline: propTypes.bool,

  /**
   * An optional icon to set for the inline edit dialog column. Setting this prop to null
   * will not render an icon.
   */
  inlineIcon: propTypes.element,

  /**
   * The default value to use for the text field.
   */
  defaultValue: propTypes.oneOfType([propTypes.number, propTypes.string]).isRequired,

  /**
   * A value to use for the edit dialog text field. This will make the component controlled
   * so you will need to provide an `onChange` function.
   */
  value: controlled(propTypes.oneOfType([propTypes.number, propTypes.string]), 'onChange', 'defaultValue'),

  /**
   * An optional function to call when the text field's value has changed. This is required
   * if the `value` prop has been defined.
   *
   * @see {@link TextFields/TextField#onChange}
   */
  onChange: propTypes.func,

  /**
   * An optional function to call when the text field gains focus.
   */
  onFocus: propTypes.func,

  /**
   * An optional function to call when the keydown event is triggered on the text field.
   */
  onKeyDown: propTypes.func,

  /**
   * An optional label for the text field. When displaying an `inline` edit dialog column,
   * the `placeholder` prop should be used instead. This is because the text field changes
   * to the `block` type when `inline`.
   *
   * @see {@link #inline}
   * @see {@link #placeholder}
   * @see {@link TextFields/TextField#block}
   */
  label: propTypes.node,

  /**
   * An optional placeholder for the text field.
   */
  placeholder: propTypes.string,

  /**
   * Boolean if the edit dialog should become a large dialog. When the dialog is large,
   * the `title` prop is required.
   *
   * A large dialog has a Title followed by the text field, and then a cancel and ok action
   * buttons below.
   */
  large: propTypes.bool,

  /**
   * The title to use for the large edit dialog. This prop is required if the `large` prop
   * is enabled.
   */
  title: propTypes.node,

  /**
   * An optional `maxLength` to apply to the text field.
   *
   * @see {@link TextFields/TextField#maxLength}
   */
  maxLength: propTypes.number,

  /**
   * An optional function to call when the "Ok" button has been clicked, the user presses enter
   * on * the text field or when the `okOnOutsideClick` prop has been enabled and the user clicks
   * somewhere on the page.
   *
   * The callback will include the current value and the click or keypress event.
   * ```js
   * onOkClick(value, event)
   * ```
   *
   * @see {@link #large}
   */
  onOkClick: propTypes.func,

  /**
   * The label to use for the "Ok" button in large dialogs.
   *
   * @see {@link #large}
   */
  okLabel: propTypes.node.isRequired,

  /**
   * Boolean if the "Ok" button in large dialogs should be styled with the primary color.
   * To get a `default` styled button, set both `okPrimary` and `okSecondary` (or omit `okSecondary`)
   * to `false`.
   *
   * @see {@link #large}
   * @see {@link #okSecondary}
   */
  okPrimary: propTypes.bool,

  /**
   * Boolean if the "Ok" button in large dialogs should be styled with the secondary color.
   *
   * @see {@link #large}
   * @see {@link #okPrimary}
   */
  okSecondary: propTypes.bool,

  /**
   * Any additional props to apply to the "Ok" button. This will override any of the other
   * button props.
   *
   * @see {@link #okLabel}
   * @see {@link #okPrimary}
   * @see {@link #okSecondary}
   */
  okProps: propTypes.object,

  /**
   * An optional function to call when the "Cancel" button has been clicked in large edit dialogs.
   * The callback will include the text field's value before any edits occurred and the click event.
   *
   * ```js
   * onCancelClick(previousValue, event)
   * ```
   *
   * @see {@link #large}
   */
  onCancelClick: propTypes.func,

  /**
   * The label to give to the "Cancel" button in large edit dialogs.
   *
   * @see {@link #large}
   */
  cancelLabel: propTypes.node.isRequired,

  /**
   * Boolean if the "Cancel" button in large dialogs should be styled with the primary color.
   * To get a `default` styled button, set both `cancelPrimary` and `cancelSecondary` (or
   * omit `cancelSecondary`) to `false`.
   *
   * @see {@link #large}
   * @see {@link #cancelSecondary}
   */
  cancelPrimary: propTypes.bool,

  /**
   * Boolean if the "Cancel" button in large dialogs should be styled with the secondary color.
   *
   * @see {@link #large}
   * @see {@link #cancelPrimary}
   */
  cancelSecondary: propTypes.bool,

  /**
   * Any additional props to apply to the "Cancel" button. This will override any of the other
   * button props.
   *
   * @see {@link #cancelLabel}
   * @see {@link #cancelPrimary}
   * @see {@link #cancelSecondary}
   */
  cancelProps: propTypes.object,

  /**
   * Boolean if the action for clicking somewhere on on the page while the dialog is open
   * saves the changes or cancels to the previous value before opening the dialog.
   *
   * @see {@link #onOkClick}
   * @see {@link #onCancelClick}
   */
  okOnOutsideClick: propTypes.bool,

  /**
   * An optional function to call when a user clicks out of the text field.
   */
  onOutsideClick: propTypes.func,

  /**
   * Boolean if the edit dialog should be closed if the user clicks somewhere else on the page
   * while the dialog is open.
   */
  closeOnOutsideClick: propTypes.bool,

  /**
   * Boolean if the Edit Dialog should be visible by default. This only applies when the `inline` prop
   * is not enabled.
   */
  defaultVisible: propTypes.bool,

  /**
   * Boolean if the edit dialog should automatically open when the text field is focused for non-inline
   * dialogs. This is enabled by default for backwards compatibility.
   */
  visibleOnFocus: propTypes.bool,

  /**
   * The type for the text field in the edit dialog.
   *
   * @see {@link TextFields/TextField#type}
   */
  type: propTypes.string,

  /**
   * This is how the dialog gets "anchored" to the table column.
   *
   * @see {@link Helpers/Layover#anchor}
   */
  anchor: anchorShape,

  /**
   * This is the anchor to use when the `position` is set to `Autocomplete.Positions.BELOW`.
   *
   * @see {@link Helpers/Layover#belowAnchor}
   */
  belowAnchor: anchorShape,

  /**
   * This is the animation position to use for the dialog.
   *
   * @see {@link Helpers/Layover#animationPosition}
   */
  animationPosition: positionShape,

  /**
   * This is how the dialog should be fixed within the table. When this is omitted, it will
   * automatically use the responsive table as the fixture so that the dialog will close/adjust itself
   * to the scrolling of the table.
   *
   * @see {@link Helpers/Layover#fixedTo}
   */
  fixedTo: fixedToShape,

  /**
   * @see {@link Helpers/Layover#xThreshold}
   */
  xThreshold: propTypes.number,

  /**
   * @see {@link Helpers/Layover#yThreshold}
   */
  yThreshold: propTypes.number,

  /**
   * @see {@link Helpers/Layover#centered}
   */
  centered: propTypes.bool,

  /**
   * @see {@link Helpers/Layover#sameWidth}
   */
  sameWidth: propTypes.bool,

  /**
   * @see {@link Helpers/Layover#transitionName}
   */
  transitionName: propTypes.string,

  /**
   * @see {@link Helpers/Layover#transitionEnterTimeout}
   */
  transitionEnterTimeout: propTypes.number,

  /**
   * @see {@link Helpers/Layover#transitionLeaveTimeout}
   */
  transitionLeaveTimeout: propTypes.number,

  /**
   * The optional tooltip to render on hover.
   */
  tooltipLabel: propTypes.node,

  /**
   * An optional delay to apply to the tooltip before it appears.
   */
  tooltipDelay: propTypes.number,

  /**
   * The position of the tooltip.
   */
  tooltipPosition: propTypes.oneOf(['top', 'right', 'bottom', 'left']),

  /**
   * Boolean if the menu should automatically try to reposition itself to stay within
   * the viewport when the `fixedTo` element scrolls.
   *
   * @see {@link Helpers/Layover#repositionOnScroll}
   */
  repositionOnScroll: propTypes.bool,

  /**
   * Boolean if the menu should automatically try to reposition itself to stay within
   * the viewport when the window resizes.
   *
   * @see {@link Helpers/Layover#repositionOnResize}
   */
  repositionOnResize: propTypes.bool,

  /**
   * Boolean if the dialog logic should be simplified without any viewport logic and position
   * based on the relative position of the menu. This will most like require some additional
   * styles applied to the dialog.
   *
   * @see {@link Helpers/Layover#simplified}
   */
  simplifiedDialog: propTypes.bool,

  /**
   * @see {@link Helpers/Layover#minLeft}
   */
  minLeft: Layover.propTypes.minLeft,

  /**
   * @see {@link Helpers/Layover#minRight}
   */
  minRight: Layover.propTypes.minLeft,

  /**
   * @see {@link Helpers/Layover#minBottom}
   */
  minBottom: Layover.propTypes.minBottom,

  /**
   * Boolean if the edit dialog should attempt to scroll into view if the full
   * dialog can not be displayed in the viewport when it was toggled open.
   *
   * @see {@link #scrollIntoViewPadding}
   */
  scrollIntoView: propTypes.bool,

  /**
   * The amount of padding that should be applied when the cell is scrolled into view.
   * This will be applied to the left of the cell.
   */
  scrollIntoViewPadding: propTypes.number,

  /**
   * An optional function to call when the `click` event is triggered in the column.
   */
  onClick: propTypes.func,

  /**
   * An optional function to call when the `mousedown` event is triggered in the column.
   */
  onMouseDown: propTypes.func,

  /**
   * An optional function to call when the `mouseup` event is triggered in the column.
   */
  onMouseUp: propTypes.func,

  /**
   * An optional function to call when the `touchstart` event is triggered in the column.
   */
  onTouchStart: propTypes.func,

  /**
   * An optional function to call when the `touchend` event is triggered in the column.
   */
  onTouchEnd: propTypes.func,

  /**
   * An optional function to call when the `mouseenter` event is triggered in the column.
   */
  onMouseEnter: propTypes.func,

  /**
   * An optional function to call when the `mouseover` event is triggered in the column.
   */
  onMouseOver: propTypes.func,

  /**
   * An optional function to call when the `mouseleave` event is triggered in the column.
   */
  onMouseLeave: propTypes.func,

  /**
   * An optional function to call when the `touchmove` event is triggered in the column.
   */
  onTouchMove: propTypes.func,

  /**
   * This is injected by the `TableRow` component.
   * @access private
   */
  header: propTypes.bool,

  /**
   * This is injected by the `TableRow` component and used to help generate the unique id for the text
   * field.
   *
   * @access private
   */
  cellIndex: propTypes.number,

  /**
   * @access private
   */
  adjusted: propTypes.bool,

  inlineIconChildren: deprecated(propTypes.node, 'Use the `inlineIcon` prop instead'),
  inlineIconClassName: deprecated(propTypes.string, 'Use the `inlineIcon` prop instead'),
  noIcon: deprecated(propTypes.bool, 'Set the `inlineIcon` prop to `null` instead'),
  enforceMinWidth: deprecated(propTypes.bool, 'The min width will always be enforced based on the `$md-edit-dialog-min-width` Sass variable'),
  scrollThreshold: deprecated(propTypes.number, 'Use `xThreshold` and `yThreshold` instead'),
  transitionDuration: deprecated(propTypes.number, 'use `transitionEnterTimeout` and `transitionLeaveTimeout` instead')
};
EditDialogColumn.defaultProps = {
  type: 'text',
  defaultValue: '',
  okOnOutsideClick: true,
  inlineIcon: React.createElement(
    FontIcon,
    null,
    'edit'
  ),
  okLabel: 'Save',
  okPrimary: true,
  cancelLabel: 'Cancel',
  cancelPrimary: true,
  animationPosition: EditDialogColumn.Positions.BELOW,
  dialogZDepth: 1,
  repositionOnScroll: true,
  repositionOnResize: false,
  scrollIntoView: true,
  scrollIntoViewPadding: 16,
  minLeft: 0,
  minRight: 0,
  minBottom: 0,
  visibleOnFocus: true,
  defaultVisible: false
};
EditDialogColumn.contextTypes = {
  rowId: propTypes.oneOfType([propTypes.number, propTypes.string])
};

var _initialiseProps$10 = function _initialiseProps() {
  var _this2 = this;

  this._setField = function (field) {
    _this2._field = field;
  };

  this._makeActions = function (props) {
    var okLabel = props.okLabel,
        okPrimary = props.okPrimary,
        okSecondary = props.okSecondary,
        okProps = props.okProps,
        cancelLabel = props.cancelLabel,
        cancelPrimary = props.cancelPrimary,
        cancelSecondary = props.cancelSecondary,
        cancelProps = props.cancelProps;


    return [_extends({
      key: 'cancel',
      children: cancelLabel,
      primary: cancelPrimary && !cancelSecondary,
      secondary: cancelSecondary
    }, cancelProps, {
      onClick: _this2._handleCancel
    }), _extends({
      key: 'ok',
      children: okLabel,
      primary: okPrimary && !okSecondary,
      secondary: okSecondary
    }, okProps, {
      onClick: _this2._handleOk
    })];
  };

  this._handleOpen = function (e) {
    if (_this2._skipNextOpen) {
      _this2._skipNextOpen = false;
    } else if (_this2.props.visibleOnFocus || !e || e.type !== 'focus') {
      var _props4 = _this2.props,
          scrollIntoView = _props4.scrollIntoView,
          scrollIntoViewPadding = _props4.scrollIntoViewPadding;

      if (scrollIntoView) {
        var vp = viewport(_this2._column);
        if (vp !== true && _this2._table && _this2._column && !_this2.props.inline) {
          _this2._table.scrollLeft = _this2._column.offsetLeft - scrollIntoViewPadding;
        }
      }

      _this2.setState({ visible: true, cancelValue: getField(_this2.props, _this2.state, 'value') });
    }
  };

  this._handleClose = function (e) {
    var _props5 = _this2.props,
        onOutsideClick = _props5.onOutsideClick,
        okOnOutsideClick = _props5.okOnOutsideClick;

    if (onOutsideClick) {
      onOutsideClick(e);
    }

    if (okOnOutsideClick) {
      _this2._handleOk(e);
    } else {
      _this2._handleCancel(e);
    }
  };

  this._handleChange = function (value, e) {
    if (_this2.props.onChange) {
      _this2.props.onChange(value, e);
    }

    if (typeof _this2.props.value === 'undefined') {
      _this2.setState({ value: value });
    }
  };

  this._handleFocus = function (e) {
    if (_this2.props.onFocus) {
      _this2.props.onFocus(e);
    }

    if (_this2.props.inline) {
      _this2.setState({ cancelValue: e.target.value });
    }
  };

  this._handleKeyDown = function (e) {
    var _props6 = _this2.props,
        onKeyDown = _props6.onKeyDown,
        okOnOutsideClick = _props6.okOnOutsideClick,
        large = _props6.large;

    if (onKeyDown) {
      onKeyDown(e);
    }

    var key = e.which || e.keyCode;
    if (key === ENTER) {
      _this2._handleOk(e);
    } else if (key === ESC) {
      _this2._handleCancel(e);
    } else if (key === TAB && !large) {
      // infinitely opens otherwise...
      _this2._skipNextOpen = e.shiftKey;

      if (okOnOutsideClick) {
        _this2._handleOk(e);
      } else {
        _this2._handleCancel(e);
      }
    }
  };

  this._handleOk = function (e) {
    if (_this2.props.onOkClick) {
      _this2.props.onOkClick(getField(_this2.props, _this2.state, 'value'), e);
    }

    _this2.setState({ visible: false });
  };

  this._handleCancel = function (e) {
    var value = _this2.state.cancelValue;
    if (_this2.props.onCancelClick) {
      _this2.props.onCancelClick(value, e);
    }

    var state = { visible: false };
    if (typeof _this2.props.value === 'undefined') {
      state.value = value;
    }

    _this2.setState(state);
  };
};

/**
 * This is a utility HOC to fix the components that use the `Menu` component behind the scenes. This will
 * correctly add the `id` and `fixedTo` props if they are omitted from the child component's props.
 *
 * If the id prop is omitted, it will default to the `${rowId}-${cellIndex}-${suffix}` and when the
 * `fixedTo` prop is omitted, it will automatically set it to the responsive table wrapper so that
 * it will stay in viewport as expected.
 *
 * This component also attempts to find the `cellIndex` prop if it is not correctly cloned into the
 * component.
 *
 * @param {function|Class} ComposedComponent - the component to compose with the tooltip functionality.
 * @param {String} suffix - the id suffix to apply.
 * @return {Class} the ComposedComponent with some fixes applied.
 */
function withTableFixes(ComposedComponent, suffix) {
  var _class, _temp2;

  return _temp2 = _class = function (_PureComponent) {
    inherits(TableFixesComponent, _PureComponent);

    function TableFixesComponent() {
      var _ref;

      var _temp, _this, _ret;

      classCallCheck(this, TableFixesComponent);

      for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      return _ret = (_temp = (_this = possibleConstructorReturn(this, (_ref = TableFixesComponent.__proto__ || Object.getPrototypeOf(TableFixesComponent)).call.apply(_ref, [this].concat(args))), _this), _this.state = { cellIndex: undefined }, _this._fixedTo = null, _temp), possibleConstructorReturn(_this, _ret);
    }

    createClass(TableFixesComponent, [{
      key: 'componentDidMount',
      value: function componentDidMount() {
        var _props = this.props,
            cellIndex = _props.cellIndex,
            fixedTo = _props.fixedTo,
            id = _props.id;

        var isIndexed = !!id || cellIndex === 0 || !!cellIndex;
        var isFixed = fixedTo === null || !!fixedTo;
        if (isIndexed && isFixed) {
          // all is good
          return;
        }

        var column = findDOMNode(this);
        var table = findTable(column);
        this._fixedTo = findFixedTo(table);

        // If a developer creates their own component to wrap the component that uses a menu, the cellIndex prop
        // might not be defined if they don't pass ...props
        if (!isIndexed) {
          var columns = [].slice.call(column.parentNode.querySelectorAll('th,td'));
          this.setState({ cellIndex: columns.indexOf(column) }); // eslint-disable-line react/no-did-mount-set-state
        } else if (this._fixedTo) {
          // need to apply the _fixedTo for the select field
          this.forceUpdate();
        }
      }
    }, {
      key: 'render',
      value: function render() {
        var rowId = this.context.rowId;
        var _props2 = this.props,
            propid = _props2.id,
            propFixedTo = _props2.fixedTo,
            propCellIndex = _props2.cellIndex,
            props = objectWithoutProperties(_props2, ['id', 'fixedTo', 'cellIndex']);
        var id = this.props.id;

        var fixedTo = this._fixedTo === null || propFixedTo ? propFixedTo : this._fixedTo;
        var cellIndex = getField(this.props, this.state, 'cellIndex');
        if (!id) {
          id = rowId + '-' + cellIndex + '-' + suffix;
        }

        return React.createElement(ComposedComponent, _extends({}, props, { id: id, fixedTo: fixedTo }));
      }
    }]);
    return TableFixesComponent;
  }(PureComponent), _class.Positions = ComposedComponent.Positions, _class.HorizontalAnchors = ComposedComponent.HorizontalAnchors, _class.VerticalAnchors = ComposedComponent.VerticalAnchors, _class.displayName = getDisplayName(ComposedComponent, 'TableFixes'), _class.propTypes = {
    id: propTypes.oneOfType([propTypes.number, propTypes.string]),
    cellIndex: propTypes.number,
    fixedTo: fixedToShape
  }, _class.contextTypes = {
    rowId: propTypes.oneOfType([propTypes.number, propTypes.string])
  }, _temp2;
}

/**
 * The `SelectFieldColumn` component is just a simple wrapper between a `SelectField` and
 * the `TableColumn` components.
 *
 * All props that are on the `SelectField` are also available here (except the naming of style or className).
 * See the [SelectField](/components/select-fields?tab=1#select-field-proptypes) for remaining prop descriptions.
 */

var SelectFieldColumn = function (_PureComponent) {
  inherits(SelectFieldColumn, _PureComponent);

  function SelectFieldColumn() {
    classCallCheck(this, SelectFieldColumn);
    return possibleConstructorReturn(this, (SelectFieldColumn.__proto__ || Object.getPrototypeOf(SelectFieldColumn)).apply(this, arguments));
  }

  createClass(SelectFieldColumn, [{
    key: 'render',
    value: function render() {
      var _props = this.props,
          style = _props.style,
          className = _props.className,
          menuStyle = _props.menuStyle,
          menuClassName = _props.menuClassName,
          header = _props.header,
          tooltipLabel = _props.tooltipLabel,
          tooltipDelay = _props.tooltipDelay,
          tooltipPosition = _props.tooltipPosition,
          adjusted = _props.adjusted,
          wrapperStyle = _props.wrapperStyle,
          wrapperClassName = _props.wrapperClassName,
          props = objectWithoutProperties(_props, ['style', 'className', 'menuStyle', 'menuClassName', 'header', 'tooltipLabel', 'tooltipDelay', 'tooltipPosition', 'adjusted', 'wrapperStyle', 'wrapperClassName']);


      return React.createElement(
        TableColumn$1,
        {
          header: header,
          style: style,
          className: classnames('md-select-field-column', className),
          adjusted: false,
          tooltipLabel: tooltipLabel,
          tooltipDelay: tooltipDelay,
          tooltipPosition: tooltipPosition
        },
        React.createElement(SelectField, _extends({}, props, { style: menuStyle, className: menuClassName }))
      );
    }
  }]);
  return SelectFieldColumn;
}(PureComponent);

SelectFieldColumn.VerticalAnchors = SelectField.VerticalAnchors;
SelectFieldColumn.HorizontalAnchors = SelectField.HorizontalAnchors;
SelectFieldColumn.Positions = SelectField.Positions;
SelectFieldColumn.propTypes = {
  /**
   * An optional id to use for the select field in the column. If this is omitted, it's value will be
   * `${rowId}-${cellIndex}-select-field`
   */
  id: propTypes.oneOfType([propTypes.number, propTypes.string]),

  /**
   * This is the optional style to apply to the `TableColumn`.
   */
  style: propTypes.object,

  /**
   * This is the optional className to apply to the `TableColumn`.
   */
  className: propTypes.string,

  /**
   * The is the optional style to apply to the select field's menu container.
   *
   * @see {@link SelectFields/SelectField#style}
   */
  menuStyle: propTypes.object,

  /**
   * The is the optional class name to apply to the select field's menu container.
   *
   * @see {@link SelectFields/SelectField#className}
   */
  menuClassName: propTypes.string,

  /**
   * This is how the select field should be fixed within the table. When this is omitted,
   * it will automatically use the responsive table as the fixture so that the select field
   * will close/adjust itself to the scrolling of the table.
   *
   * @see {@link Helpers/Layover#fixedTo}
   */
  fixedTo: fixedToShape,

  /**
   * Boolean if the select field should span the entire width of the column.
   */
  fullWidth: propTypes.bool,

  /**
   * The position for the select field.
   *
   * @see {@link SelectFields/SelectField#position}
   */
  position: positionShape,

  /**
   * This is injected by the `TableRow` component.
   * @access private
   */
  header: propTypes.bool,

  /**
   * @access private
   */
  adjusted: propTypes.bool,

  /**
   * The optional tooltip to render on hover.
   *
   * @see {@link DataTables/TableColumn#tooltipLabel}
   */
  tooltipLabel: propTypes.string,

  /**
   * An optional delay to apply to the tooltip before it appears.
   *
   * @see {@link DataTables/TableColumn#tooltipDelay}
   */
  tooltipDelay: propTypes.number,

  /**
   * The position of the tooltip.
   *
   * @see {@link DataTables/TableColumn#tooltipPosition}
   */
  tooltipPosition: propTypes.oneOf(['top', 'right', 'bottom', 'left']),

  /**
   * Boolean if the menu should automatically try to reposition itself to stay within
   * the viewport when the `fixedTo` element scrolls.
   *
   * @see {@link Helpers/Layover#repositionOnScroll}
   */
  repositionOnScroll: propTypes.bool,

  /**
   * Boolean if the menu should automatically try to reposition itself to stay within
   * the viewport when the window resizes.
   *
   * @see {@link Helpers/Layover#repositionOnResize}
   */
  repositionOnResize: propTypes.bool,

  /**
   * Boolean if the menu logic should be simplified without any viewport logic and position
   * based on the relative position of the menu. This will most like require some additional
   * styles applied to the menu.
   *
   * @see {@link Helpers/Layover#simplified}
   */
  simplifiedMenu: propTypes.bool,

  wrapperStyle: deprecated(propTypes.object, 'There is no longer a wrapper'),
  wrapperClassName: deprecated(propTypes.string, 'There is no longer a wrapper')
};
SelectFieldColumn.defaultProps = {
  position: SelectFieldColumn.Positions.BELOW,
  fullWidth: true,
  repositionOnScroll: true,
  repositionOnResize: false,
  simplifiedMenu: false
};


var SelectFieldColumn$1 = withTableFixes(SelectFieldColumn, 'select-field');

/** @module utils/mapToListParts */

/**
 * A utility function to convert any "item" into a valid React element that is used
 * within the `List` component.
 *
 * Use cases:
 * - is a valid React element -> item returned unmodified
 * - `number` or `string` -> `ListItem` with the item as the `primaryText`
 * - an `object` with a key `divider: true` -> a `Divider` component with the remaining
 *    keys applied as props.
 * - an `object` with a key `subheader: true` -> a `Subheader` component with the remianing
 *    keys applied as props. This one technically requires the `primaryText` key to be defined.
 * - an `object` -> all keys passed into the `ListItem` component.
 *
 * Examples:
 * ```js
 * mapToListParts('Hello') == <ListItem primaryText="Hello" />
 * mapToListParts(100)     == <ListItem primaryText={100} />
 * mapToListParts({ primaryText: 'Item' }) == <ListItem primaryText="Item" />
 * mapToListParts({ divider: true }) == <Divider />
 * mapToListParts({ subheader: true, primaryText: 'Subheader' }) == <Subheader primaryText="Subheader" />
 * ```
 *
 * @param {string|number|Object} item - the item to convert
 * @param {number|string=} index - the current index in the array (if used in an array)
 * @return {Object} a React element
 */
function mapToListParts(item, index) {
  if (typeof item === 'string' || typeof item === 'number') {
    return createElement(ListItem, { key: item, primaryText: item });
  } else if (isValidElement(item)) {
    return item;
  }

  var divider = item.divider,
      subheader = item.subheader,
      nestedItems = item.nestedItems,
      remainingProps = objectWithoutProperties(item, ['divider', 'subheader', 'nestedItems']);

  var component = void 0;
  if (divider) {
    component = Divider;
  } else if (subheader) {
    component = Subheader$1;
  } else {
    component = ListItem;
  }

  var props = _extends({}, remainingProps, { key: item.key || index });
  if (nestedItems) {
    props.nestedItems = nestedItems.map(mapToListParts);
  }

  return createElement(component, props);
}

/**
 * The `DropdownMenu` is just a simple wrapper to the `Menu` component. The main differences
 * is that the `toggle` component will now be the children and the list of items to display
 * will be the `menuItems` prop.
 *
 * The dropdown menu is mostly used to control the state of the menu and render a single element
 * as the toggle.
 */

var DropdownMenu = function (_PureComponent) {
  inherits(DropdownMenu, _PureComponent);

  function DropdownMenu(props) {
    classCallCheck(this, DropdownMenu);

    var _this = possibleConstructorReturn(this, (DropdownMenu.__proto__ || Object.getPrototypeOf(DropdownMenu)).call(this, props));

    _this._handleClick = function (e) {
      var _this$props = _this.props,
          onVisibilityChange = _this$props.onVisibilityChange,
          children = _this$props.children;

      var visible = !getField(_this.props, _this.state, 'visible');
      if (onVisibilityChange) {
        onVisibilityChange(visible, e);
      }

      var toggle = React.Children.only(children);
      if (toggle.props.onClick) {
        toggle.props.onClick(e);
      }

      if (typeof _this.props.visible === 'undefined') {
        _this.setState({ visible: visible });
      }
    };

    _this._handleClose = function (e) {
      var onVisibilityChange = _this.props.onVisibilityChange;

      var visible = false;
      if (onVisibilityChange) {
        onVisibilityChange(visible, e);
      }

      if (typeof _this.props.visible === 'undefined') {
        _this.setState({ visible: visible });
      }
    };

    _this.state = {};
    if (typeof props.visible === 'undefined') {
      _this.state.visible = props.defaultVisible;
    }
    return _this;
  }

  createClass(DropdownMenu, [{
    key: 'render',
    value: function render() {
      var _props = this.props,
          id = _props.id,
          listId = _props.listId,
          menuItems = _props.menuItems,
          propChildren = _props.children,
          simplifiedMenu = _props.simplifiedMenu,
          propVisible = _props.visible,
          onVisibilityChange = _props.onVisibilityChange,
          defaultVisible = _props.defaultVisible,
          props = objectWithoutProperties(_props, ['id', 'listId', 'menuItems', 'children', 'simplifiedMenu', 'visible', 'onVisibilityChange', 'defaultVisible']);


      var visible = getField(this.props, this.state, 'visible');

      var children = React.Children.only(propChildren);
      var toggle = React.cloneElement(children, {
        id: children.props.id || id + '-toggle',
        onClick: this._handleClick
      });

      var items = void 0;
      if (!Array.isArray(menuItems)) {
        items = mapToListParts(menuItems);
      } else {
        items = menuItems.map(mapToListParts);
      }

      return React.createElement(
        Menu,
        _extends({}, props, {
          simplified: simplifiedMenu,
          id: id,
          listId: listId,
          toggle: toggle,
          visible: visible,
          onClose: this._handleClose
        }),
        items
      );
    }
  }]);
  return DropdownMenu;
}(PureComponent);

DropdownMenu.Positions = Menu.Positions;
DropdownMenu.HorizontalAnchors = Menu.HorizontalAnchors;
DropdownMenu.VerticalAnchors = Menu.VerticalAnchors;
DropdownMenu.propTypes = {
  /**
   * An id to use for the menu. This is required for accessibility.
   *
   * @see {@link Menus/Menu#id}
   */
  id: propTypes.oneOfType([propTypes.number, propTypes.string]),

  /**
   * An optional id to provide to the menu's list.
   *
   * @see {@link Menus/Menu#listId}
   */
  listId: propTypes.oneOfType([propTypes.number, propTypes.string]),

  /**
   * An optional style to apply to the menu.
   */
  style: propTypes.object,

  /**
   * An optional className to apply to the menu.
   */
  className: propTypes.string,

  /**
   * An optional style to apply to the list.
   */
  listStyle: propTypes.object,

  /**
   * An optional class name to apply to the list.
   */
  listClassName: propTypes.string,

  /**
   * Any additional props to provide to the list.
   *
   * @see {@link Menus/Menu#listProps}
   */
  listProps: propTypes.object,

  /**
   * The z-depth to use for the list.
   *
   * @see {@link Menus/Menu/listZDepth}
   */
  listZDepth: propTypes.number,

  /**
   * Boolean if the list should be displayed inline.
   *
   * @see {@link Lists/List#inline}
   */
  listInline: propTypes.bool,

  /**
   * Boolean if the list's height should be restricted.
   *
   * @see {@link Menus/Menu#listHeightRestricted}
   */
  listHeightRestricted: propTypes.bool,

  /**
   * Boolean if the menu's list is currently visible. If this is defined, it will
   * require the `onVisibilityChange` function to be defined since it will become
   * a controlled component.
   */
  visible: controlled(propTypes.bool, 'onVisibilityChange', 'defaultVisible'),

  /**
   * Boolean if the menu's list should be visible by default.
   */
  defaultVisible: propTypes.bool.isRequired,

  /**
   * An optional function to call when the button is clicked.
   */
  onClick: propTypes.func,

  /**
   * An optional function to call when the visibility changes for the menu. The callback will
   * include the next visibility state and the event that triggered the change.
   *
   * ```js
   * onVisibilityChange(visible, event);
   * ```
   */
  onVisibilityChange: propTypes.func,

  /**
   * This is a 0 to many relationship of `ListItem` to display in the menu's `List`. If the type
   * of the item is a number or string, it will be passed to the `ListItem` as the `primaryText`.
   * If it is an object, it should be the shape of the `ListItem` props. If it is a node, it will
   * just be rendered in the `List`.
   *
   * @see {@link Lists/ListItem}
   * @see {@link Menus/Menu#children}
   */
  menuItems: propTypes.oneOfType([propTypes.number, propTypes.string, propTypes.object, propTypes.node, propTypes.arrayOf(propTypes.oneOfType([propTypes.string, propTypes.number, propTypes.object, propTypes.node]))]),

  /**
   * @see {@link Menus/Menu#toggle}
   */
  children: propTypes.element.isRequired,

  /**
   * The anchor position of the menu's list.
   *
   * @see {@link Helpers/Layover#anchor}
   */
  anchor: anchorShape,

  /**
   * This is the anchor to use when the `position` is set to `Autocomplete.Positions.BELOW`.
   *
   * @see {@link Helpers/Layover#belowAnchor}
   */
  belowAnchor: anchorShape,

  /**
   * This is how the menu's list is fixed to the toggle.
   *
   * @see {@link Menus/Menu#fixedTo}
   */
  fixedTo: fixedToShape,

  /**
   * This is the animation position for the menu's list.
   *
   * @see {@link Menus/Menu#position}
   */
  position: positionShape,

  /**
   * Boolean if the menu's list should gain the cascading styles.
   *
   * @see {@link Menus/Menu#cascading}
   */
  cascading: propTypes.bool,

  /**
   * The zDepth to use for the lists that appear in cascading menus.
   *
   * @see {@link Menus/Menu#cascadingZDepth}
   */
  cascadingZDepth: propTypes.number,

  /**
   * The anchor position for the cascading lists.
   *
   * @see {@link Menus/Menu#cascadingAnchor}
   */
  cascadingAnchor: anchorShape,

  /**
   * Boolean if the menu should display as a full width container. This will *not* update the button
   * to be full width as well.
   *
   * @see {@link Menus/Menu#fullWidth}
   */
  fullWidth: propTypes.bool,

  /**
   * Boolean if the menu's container should display as `block` instead of `inline-block`.
   *
   * @see {@link Menus/Menu#block}
   */
  block: propTypes.bool,

  /**
   * Boolean if the list should appear centered related to the button.
   *
   * @see {@link Menus/Menu#centered}
   */
  centered: propTypes.bool,

  /**
   * Boolean if the menu's list should be the same width as the button.
   *
   * @see {@link Menus/Menu#sameWidth}
   */
  sameWidth: propTypes.bool,

  /**
   * @see {@link Menus/Menu#xThreshold}
   */
  xThreshold: propTypes.number,

  /**
   * @see {@link Menus/Menu#yThreshold}
   */
  yThreshold: propTypes.number,

  /**
   * Boolean if the menu's list should be closed when an element outside of the menu has been clicked.
   *
   * @see {@link Menus/Menu#closeOnOutsideClick}
   */
  closeOnOutsideClick: propTypes.bool,

  /**
   * The transition name to use for the menu's list visibility changes.
   *
   * @see {@link Menus/Menu#transitionName}
   */
  transitionName: propTypes.string,

  /**
   * The transition name to use when the menu's list gains visibility.
   *
   * @see {@link Menus/Menu#transitionEnterTimeout}
   */
  transitionEnterTimeout: propTypes.number,

  /**
   * The transition timeout to use when the menu's list loses visibility.
   *
   * @see {@link Menus/Menu#transitionLeaveTimeout}
   */
  transitionLeaveTimeout: propTypes.number,

  /**
   * Boolean if the menu should automatically try to reposition itself to stay within
   * the viewport when the `fixedTo` element scrolls.
   *
   * @see {@link Helpers/Layover#repositionOnScroll}
   */
  repositionOnScroll: propTypes.bool,

  /**
   * Boolean if the menu should automatically try to reposition itself to stay within
   * the viewport when the window resizes.
   *
   * @see {@link Helpers/Layover#repositionOnResize}
   */
  repositionOnResize: propTypes.bool,

  /**
   * Boolean if the menu logic should be simplified without any viewport logic and position
   * based on the relative position of the menu. This will most like require some additional
   * styles applied to the menu.
   *
   * @see {@link Helpers/Layover#simplified}
   */
  simplifiedMenu: propTypes.bool,

  /**
   * @see {@link Helpers/Layover#minLeft}
   */
  minLeft: Menu.propTypes.minLeft,

  /**
   * @see {@link Helpers/Layover#minRight}
   */
  minRight: Menu.propTypes.minLeft,

  /**
   * @see {@link Helpers/Layover#minBottom}
   */
  minBottom: Menu.propTypes.minBottom,

  /**
   * @see {@link Helpers/Layover#fillViewportWidth}
   */
  fillViewportWidth: propTypes.bool,

  /**
   * @see {@link Helpers/Layover#fillViewportHeight}
   */
  fillViewportHeight: propTypes.bool
};
DropdownMenu.defaultProps = {
  defaultVisible: false,
  repositionOnScroll: true,
  repositionOnResize: false
};

/**
 * The `MenuButton` is a simple wrapper / combination of the `Button` and the `Menu`
 * components that can be uncontrolled.
 */

var MenuButton = function (_PureComponent) {
  inherits(MenuButton, _PureComponent);

  function MenuButton() {
    classCallCheck(this, MenuButton);
    return possibleConstructorReturn(this, (MenuButton.__proto__ || Object.getPrototypeOf(MenuButton)).apply(this, arguments));
  }

  createClass(MenuButton, [{
    key: 'render',
    value: function render() {
      var _props = this.props,
          id = _props.id,
          listId = _props.listId,
          buttonId = _props.buttonId,
          menuStyle = _props.menuStyle,
          menuClassName = _props.menuClassName,
          listStyle = _props.listStyle,
          listClassName = _props.listClassName,
          listProps = _props.listProps,
          listZDepth = _props.listZDepth,
          listInline = _props.listInline,
          listHeightRestricted = _props.listHeightRestricted,
          menuItems = _props.menuItems,
          buttonChildren = _props.buttonChildren,
          children = _props.children,
          anchor = _props.anchor,
          belowAnchor = _props.belowAnchor,
          fixedTo = _props.fixedTo,
          position = _props.position,
          cascading = _props.cascading,
          cascadingAnchor = _props.cascadingAnchor,
          cascadingZDepth = _props.cascadingZDepth,
          fullWidth = _props.fullWidth,
          block = _props.block,
          centered = _props.centered,
          sameWidth = _props.sameWidth,
          repositionOnScroll = _props.repositionOnScroll,
          repositionOnResize = _props.repositionOnResize,
          xThreshold = _props.xThreshold,
          yThreshold = _props.yThreshold,
          closeOnOutsideClick = _props.closeOnOutsideClick,
          transitionName = _props.transitionName,
          transitionEnterTimeout = _props.transitionEnterTimeout,
          transitionLeaveTimeout = _props.transitionLeaveTimeout,
          visible = _props.visible,
          defaultVisible = _props.defaultVisible,
          onVisibilityChange = _props.onVisibilityChange,
          simplifiedMenu = _props.simplifiedMenu,
          minLeft = _props.minLeft,
          minRight = _props.minRight,
          minBottom = _props.minBottom,
          fillViewportWidth = _props.fillViewportWidth,
          fillViewportHeight = _props.fillViewportHeight,
          onMenuClick = _props.onMenuClick,
          onMenuMouseDown = _props.onMenuMouseDown,
          onMenuMouseUp = _props.onMenuMouseUp,
          onMenuMouseEnter = _props.onMenuMouseEnter,
          onMenuMouseMove = _props.onMenuMouseMove,
          onMenuMouseLeave = _props.onMenuMouseLeave,
          onMenuTouchStart = _props.onMenuTouchStart,
          onMenuTouchMove = _props.onMenuTouchMove,
          onMenuTouchCancel = _props.onMenuTouchCancel,
          onMenuTouchEnd = _props.onMenuTouchEnd,
          onMenuFocus = _props.onMenuFocus,
          onMenuBlur = _props.onMenuBlur,
          onMenuKeyDown = _props.onMenuKeyDown,
          onMenuKeyUp = _props.onMenuKeyUp,
          isOpen = _props.isOpen,
          defaultOpen = _props.defaultOpen,
          onMenuToggle = _props.onMenuToggle,
          props = objectWithoutProperties(_props, ['id', 'listId', 'buttonId', 'menuStyle', 'menuClassName', 'listStyle', 'listClassName', 'listProps', 'listZDepth', 'listInline', 'listHeightRestricted', 'menuItems', 'buttonChildren', 'children', 'anchor', 'belowAnchor', 'fixedTo', 'position', 'cascading', 'cascadingAnchor', 'cascadingZDepth', 'fullWidth', 'block', 'centered', 'sameWidth', 'repositionOnScroll', 'repositionOnResize', 'xThreshold', 'yThreshold', 'closeOnOutsideClick', 'transitionName', 'transitionEnterTimeout', 'transitionLeaveTimeout', 'visible', 'defaultVisible', 'onVisibilityChange', 'simplifiedMenu', 'minLeft', 'minRight', 'minBottom', 'fillViewportWidth', 'fillViewportHeight', 'onMenuClick', 'onMenuMouseDown', 'onMenuMouseUp', 'onMenuMouseEnter', 'onMenuMouseMove', 'onMenuMouseLeave', 'onMenuTouchStart', 'onMenuTouchMove', 'onMenuTouchCancel', 'onMenuTouchEnd', 'onMenuFocus', 'onMenuBlur', 'onMenuKeyDown', 'onMenuKeyUp', 'isOpen', 'defaultOpen', 'onMenuToggle']);


      var items = children;
      var toggleChildren = buttonChildren;
      if (typeof menuItems !== 'undefined') {
        toggleChildren = children;
        items = menuItems;
      }

      return React.createElement(
        DropdownMenu,
        {
          id: id,
          listId: listId,
          style: menuStyle,
          className: menuClassName,
          listStyle: listStyle,
          listClassName: listClassName,
          listProps: listProps,
          listInline: listInline,
          listZDepth: listZDepth,
          listHeightRestricted: listHeightRestricted,
          visible: typeof isOpen !== 'undefined' ? isOpen : visible,
          defaultVisible: typeof defaultOpen !== 'undefined' ? defaultOpen : defaultVisible,
          menuItems: items,
          simplifiedMenu: simplifiedMenu,
          anchor: anchor,
          belowAnchor: belowAnchor,
          fixedTo: fixedTo,
          position: position,
          cascading: cascading,
          cascadingAnchor: cascadingAnchor,
          cascadingZDepth: cascadingZDepth,
          fullWidth: fullWidth,
          block: block,
          centered: centered,
          sameWidth: sameWidth,
          minLeft: minLeft,
          minRight: minRight,
          minBottom: minBottom,
          fillViewportWidth: fillViewportWidth,
          fillViewportHeight: fillViewportHeight,
          repositionOnScroll: repositionOnScroll,
          repositionOnResize: repositionOnResize,
          xThreshold: xThreshold,
          yThreshold: yThreshold,
          closeOnOutsideClick: closeOnOutsideClick,
          transitionName: transitionName,
          transitionEnterTimeout: transitionEnterTimeout,
          transitionLeaveTimeout: transitionLeaveTimeout,
          onVisibilityChange: onMenuToggle || onVisibilityChange,
          onClick: onMenuClick,
          onMouseDown: onMenuMouseDown,
          onMouseUp: onMenuMouseUp,
          onMouseEnter: onMenuMouseEnter,
          onMouseMove: onMenuMouseMove,
          onMouseLeave: onMenuMouseLeave,
          onTouchStart: onMenuTouchStart,
          onTouchMove: onMenuTouchMove,
          onTouchCancel: onMenuTouchCancel,
          onTouchEnd: onMenuTouchEnd,
          onFocus: onMenuFocus,
          onBlur: onMenuBlur,
          onKeyDown: onMenuKeyDown,
          onKeyUp: onMenuKeyUp
        },
        React.createElement(
          Button$1,
          _extends({}, props, { id: buttonId }),
          toggleChildren
        )
      );
    }
  }]);
  return MenuButton;
}(PureComponent);

MenuButton.Positions = DropdownMenu.Positions;
MenuButton.HorizontalAnchors = DropdownMenu.HorizontalAnchors;
MenuButton.VerticalAnchors = DropdownMenu.VerticalAnchors;
MenuButton.propTypes = {
  /**
   * An id to use for the menu button. This is required for accessibility.
   *
   * @see {@link Menus/Menu#id}
   */
  id: propTypes.oneOfType([propTypes.number, propTypes.string]),

  /**
   * An optional id to provide to the menu's list.
   *
   * @see {@link Menus/Menu#listId}
   */
  listId: propTypes.oneOfType([propTypes.number, propTypes.string]),

  /**
   * An optional id to provide to the button. If this is omitted, the button will automatically
   * gain an id of `${id}-toggle`.
   */
  buttonId: propTypes.oneOfType([propTypes.number, propTypes.string]),

  /**
   * An optional style to apply to the button.
   */
  style: propTypes.object,

  /**
   * An optional className to apply to the button.
   */
  className: propTypes.string,

  /**
   * An optional style to apply to the surrounding menu.
   */
  menuStyle: propTypes.object,

  /**
   * An optional className to apply to the surrounding menu.
   */
  menuClassName: propTypes.string,

  /**
   * An optional style to apply to the list.
   */
  listStyle: propTypes.object,

  /**
   * An optional class name to apply to the list.
   */
  listClassName: propTypes.string,

  /**
   * Any additional props to provide to the list.
   *
   * @see {@link Menus/Menu#listProps}
   */
  listProps: propTypes.object,

  /**
   * The z-depth to use for the list.
   *
   * @see {@link Menus/Menu/listZDepth}
   */
  listZDepth: propTypes.number,

  /**
   * Boolean if the list should be displayed inline.
   *
   * @see {@link Lists/List#inline}
   */
  listInline: propTypes.bool,

  /**
   * Boolean if the list's height should be restricted.
   *
   * @see {@link Menus/Menu#listHeightRestricted}
   */
  listHeightRestricted: propTypes.bool,

  /**
   * Boolean if the menu's list is currently visible. If this is defined, it will
   * require the `onVisibilityChange` function to be defined since it will become
   * a controlled component.
   */
  visible: controlled(propTypes.bool, 'onVisibilityChange', 'defaultVisible'),

  /**
   * Boolean if the menu's list should be visible by default.
   */
  defaultVisible: propTypes.bool.isRequired,

  /**
   * An optional function to call when the button is clicked.
   *
   * @see {@link #onMenuClick}
   */
  onClick: propTypes.func,

  /**
   * An optional function to call when the `mousedown` event is triggered by the button.
   *
   * @see {@link #onMenuMouseDown}
   */
  onMouseDown: propTypes.func,

  /**
   * An optional function to call when the `mouseup` event is triggered by the button.
   *
   * @see {@link #onMenuMouseUp}
   */
  onMouseUp: propTypes.func,

  /**
   * An optional function to call when the `mouseenter` event is triggered by the button.
   *
   * @see {@link #onMenuMouseEnter}
   */
  onMouseEnter: propTypes.func,

  /**
   * An optional function to call when the `mousemove` event is triggered by the button.
   *
   * @see {@link #onMenuMouseMove}
   */
  onMouseMove: propTypes.func,

  /**
   * An optional function to call when the `mouseleave` event is triggered by the button.
   *
   * @see {@link #onMenuMouseLeave}
   */
  onMouseLeave: propTypes.func,

  /**
   * An optional function to call when the `touchstart` event is triggered by the button.
   *
   * @see {@link #onMenuTouchStart}
   */
  onTouchStart: propTypes.func,

  /**
   * An optional function to call when the `touchmove` event is triggered by the button.
   *
   * @see {@link #onMenuTouchMove}
   */
  onTouchMove: propTypes.func,

  /**
   * An optional function to call when the `touchend` event is triggered by the button.
   *
   * @see {@link #onMenuTouchEnd}
   */
  onTouchEnd: propTypes.func,

  /**
   * An optional function to call when the `touchcancel` event is triggered by the button.
   *
   * @see {@link #onMenuTouchCancel}
   */
  onTouchCancel: propTypes.func,

  /**
   * An optional function to call when the `focus` event is triggered by the button.
   *
   * @see {@link #onMenuFocus}
   */
  onFocus: propTypes.func,

  /**
   * An optional function to call when the `blur` event is triggered by the button.
   *
   * @see {@link #onMenuBlur}
   */
  onBlur: propTypes.func,

  /**
   * An optional function to call when the `keydown` event is triggered by the button.
   *
   * @see {@link #onMenuKeyDown}
   */
  onKeyDown: propTypes.func,

  /**
   * An optional function to call when the `keyup` event is triggered by the button.
   *
   * @see {@link #onMenuKeyUp}
   */
  onKeyUp: propTypes.func,

  /**
   * An optional function to call when any element in the entire `MenuButton` is clicked. This can be triggered
   * by clicking the button or any list item that appears in the menu list.
   *
   * @see {@link #onClick}
   */
  onMenuClick: propTypes.func,

  /**
   * An optional function to call when any element in the `MenuButton` triggers the `mousedown` event.
   *
   * @see {@link #onMouseDown}
   */
  onMenuMouseDown: propTypes.func,

  /**
   * An optional function to call when any element in the `MenuButton` triggers the `mouseup` event.
   *
   * @see {@link #onMouseUp}
   */
  onMenuMouseUp: propTypes.func,

  /**
   * An optional function to call when any element in the `MenuButton` triggers the `mouseenter` event.
   *
   * @see {@link #onMouseEnter}
   */
  onMenuMouseEnter: propTypes.func,

  /**
   * An optional function to call when any element in the `MenuButton` triggers the `mousemove` event.
   *
   * @see {@link #onMouseMove}
   */
  onMenuMouseMove: propTypes.func,

  /**
   * An optional function to call when any element in the `MenuButton` triggers the `mouseleave` event.
   *
   * @see {@link #onMouseLeave}
   */
  onMenuMouseLeave: propTypes.func,

  /**
   * An optional function to call when any element in the `MenuButton` triggers the `touchstart` event.
   *
   * @see {@link @onTouchStart}
   */
  onMenuTouchStart: propTypes.func,

  /**
   * An optional function to call when any element in the `MenuButton` triggers the `touchmove` event.
   *
   * @see {@link @onTouchMove}
   */
  onMenuTouchMove: propTypes.func,

  /**
   * An optional function to call when any element in the `MenuButton` triggers the `touchend` event.
   *
   * @see {@link @onTouchEnd}
   */
  onMenuTouchEnd: propTypes.func,

  /**
   * An optional function to call when any element in the `MenuButton` triggers the `touchcancel` event.
   *
   * @see {@link @onTouchCancel}
   */
  onMenuTouchCancel: propTypes.func,

  /**
   * An optional function to call when any element in the `MenuButton` triggers the `focus` event.
   *
   * @see {@link #onFocus}
   */
  onMenuFocus: propTypes.func,

  /**
   * An optional function to call when any element in the `MenuButton` triggers the `blur` event.
   *
   * @see {@link #onBlur}
   */
  onMenuBlur: propTypes.func,

  /**
   * An optional function to call when any element in the `MenuButton` triggers the `keydown` event.
   *
   * @see {@link #onKeyDown}
   */
  onMenuKeyDown: propTypes.func,

  /**
   * An optional function to call when any element in the `MenuButton` triggers the `keyup` event.
   *
   * @see {@link #onKeyUp}
   */
  onMenuKeyUp: propTypes.func,

  /**
   * An optional function to call when the visibility changes for the menu. The callback will
   * include the next visibility state and the event that triggered the change.
   *
   * ```js
   * onVisibilityChange(visible, event);
   * ```
   */
  onVisibilityChange: propTypes.func,

  /**
   * This is a 0 to many relationship of `ListItem` to display in the menu's `List`. If the type
   * of the item is a number or string, it will be passed to the `ListItem` as the `primaryText`.
   * If it is an object, it should be the shape of the `ListItem` props. If it is a node, it will
   * just be rendered in the `List`.
   *
   * @see {@link Lists/ListItem}
   * @see {@link Menus/Menu#children}
   */
  menuItems: propTypes.oneOfType([propTypes.number, propTypes.string, propTypes.object, propTypes.node, propTypes.arrayOf(propTypes.oneOfType([propTypes.string, propTypes.number, propTypes.object, propTypes.node]))]),

  /**
   * This should be the children to use in the `Button` that gets created as the menu's toggle.
   *
   * @see {@link Buttons/Button}
   * @see {@link Menus/Menu#toggle}
   */
  children: propTypes.node,

  /**
   * The anchor position of the menu's list.
   *
   * @see {@link Helpers/Layover#anchor}
   */
  anchor: anchorShape,

  /**
   * This is the anchor to use when the `position` is set to `Autocomplete.Positions.BELOW`.
   *
   * @see {@link Helpers/Layover#belowAnchor}
   */
  belowAnchor: anchorShape,

  /**
   * This is how the menu's list is fixed to the toggle.
   *
   * @see {@link Menus/Menu#fixedTo}
   */
  fixedTo: fixedToShape,

  /**
   * This is the animation position for the menu's list.
   *
   * @see {@link Menus/Menu#position}
   */
  position: positionShape,

  /**
   * Boolean if the menu's list should gain the cascading styles.
   *
   * @see {@link Menus/Menu#cascading}
   */
  cascading: propTypes.bool,

  /**
   * The zDepth to use for the lists that appear in cascading menus.
   *
   * @see {@link Menus/Menu#cascadingZDepth}
   */
  cascadingZDepth: propTypes.number,

  /**
   * The anchor position for the cascading lists.
   *
   * @see {@link Menus/Menu#cascadingAnchor}
   */
  cascadingAnchor: anchorShape,

  /**
   * Boolean if the menu should display as a full width container. This will *not* update the button
   * to be full width as well.
   *
   * @see {@link Menus/Menu#fullWidth}
   */
  fullWidth: propTypes.bool,

  /**
   * Boolean if the menu's container should display as `block` instead of `inline-block`.
   *
   * @see {@link Menus/Menu#block}
   */
  block: propTypes.bool,

  /**
   * Boolean if the list should appear centered related to the button.
   *
   * @see {@link Menus/Menu#centered}
   */
  centered: propTypes.bool,

  /**
   * Boolean if the menu's list should be the same width as the button.
   *
   * @see {@link Menus/Menu#sameWidth}
   */
  sameWidth: propTypes.bool,

  /**
   * @see {@link Menus/Menu#xThreshold}
   */
  xThreshold: propTypes.number,

  /**
   * @see {@link Menus/Menu#yThreshold}
   */
  yThreshold: propTypes.number,

  /**
   * Boolean if the menu's list should be closed when an element outside of the menu has been clicked.
   *
   * @see {@link Menus/Menu#closeOnOutsideClick}
   */
  closeOnOutsideClick: propTypes.bool,

  /**
   * The transition name to use for the menu's list visibility changes.
   *
   * @see {@link Menus/Menu#transitionName}
   */
  transitionName: propTypes.string,

  /**
   * The transition name to use when the menu's list gains visibility.
   *
   * @see {@link Menus/Menu#transitionEnterTimeout}
   */
  transitionEnterTimeout: propTypes.number,

  /**
   * The transition timeout to use when the menu's list loses visibility.
   *
   * @see {@link Menus/Menu#transitionLeaveTimeout}
   */
  transitionLeaveTimeout: propTypes.number,

  /**
   * Boolean if the menu should automatically try to reposition itself to stay within
   * the viewport when the `fixedTo` element scrolls.
   *
   * @see {@link Helpers/Layover#repositionOnScroll}
   */
  repositionOnScroll: propTypes.bool,

  /**
   * Boolean if the menu should automatically try to reposition itself to stay within
   * the viewport when the window resizes.
   *
   * @see {@link Helpers/Layover#repositionOnResize}
   */
  repositionOnResize: propTypes.bool,

  /**
   * Boolean if the menu logic should be simplified without any viewport logic and position
   * based on the relative position of the menu. This will most like require some additional
   * styles applied to the menu.
   *
   * @see {@link Helpers/Layover#simplified}
   */
  simplifiedMenu: propTypes.bool,

  /**
   * @see {@link Helpers/Layover#minLeft}
   */
  minLeft: DropdownMenu.propTypes.minLeft,

  /**
   * @see {@link Helpers/Layover#minRight}
   */
  minRight: DropdownMenu.propTypes.minLeft,

  /**
   * @see {@link Helpers/Layover#minBottom}
   */
  minBottom: DropdownMenu.propTypes.minBottom,

  /**
   * @see {@link Helpers/Layover#fillViewportWidth}
   */
  fillViewportWidth: propTypes.bool,

  /**
   * @see {@link Helpers/Layover#fillViewportHeight}
   */
  fillViewportHeight: propTypes.bool,

  buttonChildren: deprecated(propTypes.node, 'To build a button, put any elements in the `children`. The `ListItem` have been moved to the `menuItems` prop'),
  onMenuToggle: deprecated(propTypes.bool, 'Use `onVisibilityChange` instead'),
  isOpen: deprecated(propTypes.bool, 'Use `visible` instead'),
  defaultOpen: deprecated(propTypes.bool, 'Use `defaultVisible` instead')
};
MenuButton.defaultProps = {
  defaultVisible: false,
  repositionOnScroll: true,
  repositionOnResize: false
};

var MenuButtonColumn = function (_PureComponent) {
  inherits(MenuButtonColumn, _PureComponent);

  function MenuButtonColumn() {
    classCallCheck(this, MenuButtonColumn);
    return possibleConstructorReturn(this, (MenuButtonColumn.__proto__ || Object.getPrototypeOf(MenuButtonColumn)).apply(this, arguments));
  }

  createClass(MenuButtonColumn, [{
    key: 'render',
    value: function render() {
      var _props = this.props,
          style = _props.style,
          className = _props.className,
          menuStyle = _props.menuStyle,
          menuClassName = _props.menuClassName,
          header = _props.header,
          adjusted = _props.adjusted,
          tooltipLabel = _props.tooltipLabel,
          tooltipDelay = _props.tooltipDelay,
          tooltipPosition = _props.tooltipPosition,
          props = objectWithoutProperties(_props, ['style', 'className', 'menuStyle', 'menuClassName', 'header', 'adjusted', 'tooltipLabel', 'tooltipDelay', 'tooltipPosition']);

      return React.createElement(
        TableColumn$1,
        {
          style: style,
          className: className,
          header: header,
          adjusted: adjusted,
          tooltipLabel: tooltipLabel,
          tooltipDelay: tooltipDelay,
          tooltipPosition: tooltipPosition
        },
        React.createElement(MenuButton, _extends({}, props, { style: menuStyle, className: menuClassName }))
      );
    }
  }]);
  return MenuButtonColumn;
}(PureComponent);

MenuButtonColumn.Positions = MenuButton.Positions;
MenuButtonColumn.HorizontalAnchors = MenuButton.HorizontalAnchors;
MenuButtonColumn.VerticalAnchors = MenuButton.VerticalAnchors;
MenuButtonColumn.propTypes = {
  /**
   * An optional id to use for the menu button in the column. If this is omitted, it's value will be
   * `${rowId}-${cellIndex}-menu-button`
   */
  id: propTypes.oneOfType([propTypes.number, propTypes.string]),

  /**
   * This is the optional style to apply to the `TableColumn`.
   */
  style: propTypes.object,

  /**
   * This is the optional className to apply to the `TableColumn`.
   */
  className: propTypes.string,

  /**
   * The is the optional style to apply to the menu button's menu container.
   *
   * @see {@link Menus/MenuButton#style}
   */
  menuStyle: propTypes.object,

  /**
   * The is the optional class name to apply to the menu button's menu container.
   *
   * @see {@link Menus/MenuButton#className}
   */
  menuClassName: propTypes.string,

  /**
   * This is how the select field should be fixed within the table. When this is omitted,
   * it will automatically use the responsive table as the fixture so that the select field
   * will close/adjust itself to the scrolling of the table.
   *
   * @see {@link Helpers/Layover#fixedTo}
   */
  fixedTo: fixedToShape,

  /**
   * The optional tooltip to render on hover.
   *
   * @see {@link DataTables/TableColumn#tooltipLabel}
   */
  tooltipLabel: propTypes.string,

  /**
   * An optional delay to apply to the tooltip before it appears.
   *
   * @see {@link DataTables/TableColumn#tooltipDelay}
   */
  tooltipDelay: propTypes.number,

  /**
   * The position of the tooltip.
   *
   * @see {@link DataTables/TableColumn#tooltipPosition}
   */
  tooltipPosition: propTypes.oneOf(['top', 'right', 'bottom', 'left']),

  /**
   * Boolean if the menu should automatically try to reposition itself to stay within
   * the viewport when the `fixedTo` element scrolls.
   *
   * @see {@link Helpers/Layover#repositionOnScroll}
   */
  repositionOnScroll: propTypes.bool,

  /**
   * Boolean if the menu should automatically try to reposition itself to stay within
   * the viewport when the window resizes.
   *
   * @see {@link Helpers/Layover#repositionOnResize}
   */
  repositionOnResize: propTypes.bool,

  /**
   * Boolean if the menu logic should be simplified without any viewport logic and position
   * based on the relative position of the menu. This will most like require some additional
   * styles applied to the menu.
   *
   * @see {@link Helpers/Layover#simplified}
   */
  simplifiedMenu: propTypes.bool,

  /**
   * This is injected by the `TableRow` component.
   * @access private
   */
  header: propTypes.bool,

  /**
   * @access private
   */
  adjusted: propTypes.bool
};
MenuButtonColumn.defaultProps = {
  simplifiedMenu: false
};


var MenuButtonColumn$1 = withTableFixes(MenuButtonColumn, 'menu-button');

var DropdownMenuColumn = function (_PureComponent) {
  inherits(DropdownMenuColumn, _PureComponent);

  function DropdownMenuColumn() {
    classCallCheck(this, DropdownMenuColumn);
    return possibleConstructorReturn(this, (DropdownMenuColumn.__proto__ || Object.getPrototypeOf(DropdownMenuColumn)).apply(this, arguments));
  }

  createClass(DropdownMenuColumn, [{
    key: 'render',
    value: function render() {
      var _props = this.props,
          style = _props.style,
          className = _props.className,
          menuStyle = _props.menuStyle,
          menuClassName = _props.menuClassName,
          header = _props.header,
          adjusted = _props.adjusted,
          tooltipLabel = _props.tooltipLabel,
          tooltipDelay = _props.tooltipDelay,
          tooltipPosition = _props.tooltipPosition,
          props = objectWithoutProperties(_props, ['style', 'className', 'menuStyle', 'menuClassName', 'header', 'adjusted', 'tooltipLabel', 'tooltipDelay', 'tooltipPosition']);

      return React.createElement(
        TableColumn$1,
        {
          style: style,
          className: className,
          header: header,
          adjusted: adjusted,
          tooltipLabel: tooltipLabel,
          tooltipDelay: tooltipDelay,
          tooltipPosition: tooltipPosition
        },
        React.createElement(DropdownMenu, _extends({}, props, { style: menuStyle, className: menuClassName }))
      );
    }
  }]);
  return DropdownMenuColumn;
}(PureComponent);

DropdownMenuColumn.Positions = DropdownMenu.Positions;
DropdownMenuColumn.HorizontalAnchors = DropdownMenu.HorizontalAnchors;
DropdownMenuColumn.VerticalAnchors = DropdownMenu.VerticalAnchors;
DropdownMenuColumn.propTypes = {
  /**
   * An optional id to use for the menu button in the column. If this is omitted, it's value will be
   * `${rowId}-${cellIndex}-menu-button`
   */
  id: propTypes.oneOfType([propTypes.number, propTypes.string]),

  /**
   * This is the optional style to apply to the `TableColumn`.
   */
  style: propTypes.object,

  /**
   * This is the optional className to apply to the `TableColumn`.
   */
  className: propTypes.string,

  /**
   * The is the optional style to apply to the menu button's menu container.
   *
   * @see {@link Menus/DropdownMenu#style}
   */
  menuStyle: propTypes.object,

  /**
   * The is the optional class name to apply to the menu button's menu container.
   *
   * @see {@link Menus/DropdownMenu#className}
   */
  menuClassName: propTypes.string,

  /**
   * This is how the select field should be fixed within the table. When this is omitted,
   * it will automatically use the responsive table as the fixture so that the select field
   * will close/adjust itself to the scrolling of the table.
   *
   * @see {@link Helpers/Layover#fixedTo}
   */
  fixedTo: fixedToShape,

  /**
   * The optional tooltip to render on hover.
   *
   * @see {@link DataTables/TableColumn#tooltipLabel}
   */
  tooltipLabel: propTypes.string,

  /**
   * An optional delay to apply to the tooltip before it appears.
   *
   * @see {@link DataTables/TableColumn#tooltipDelay}
   */
  tooltipDelay: propTypes.number,

  /**
   * The position of the tooltip.
   *
   * @see {@link DataTables/TableColumn#tooltipPosition}
   */
  tooltipPosition: propTypes.oneOf(['top', 'right', 'bottom', 'left']),

  /**
   * Boolean if the menu should automatically try to reposition itself to stay within
   * the viewport when the `fixedTo` element scrolls.
   *
   * @see {@link Helpers/Layover#repositionOnScroll}
   */
  repositionOnScroll: propTypes.bool,

  /**
   * Boolean if the menu should automatically try to reposition itself to stay within
   * the viewport when the window resizes.
   *
   * @see {@link Helpers/Layover#repositionOnResize}
   */
  repositionOnResize: propTypes.bool,

  /**
   * Boolean if the menu logic should be simplified without any viewport logic and position
   * based on the relative position of the menu. This will most like require some additional
   * styles applied to the menu.
   *
   * @see {@link Helpers/Layover#simplified}
   */
  simplifiedMenu: propTypes.bool,

  /**
   * This is injected by the `TableRow` component.
   * @access private
   */
  header: propTypes.bool,

  /**
   * @access private
   */
  adjusted: propTypes.bool
};
DropdownMenuColumn.defaultProps = {
  simplifiedMenu: false
};


var DropdownMenuColumn$1 = withTableFixes(DropdownMenuColumn, 'menu-button');

/** @module utils/PropTypes/oneRequired */

/**
 * A simple prop type validation that makes sure that at least this prop or one of the
 * other defined prop names are defined for a component.
 *
 * @param {function} validator - The PropType validator for the current prop.
 * @param {...String} otherPropNames - A single or list of prop names that could be defined
 * @return {Error} a prop type validation error or null.
 */
function oneRequired(validator) {
  for (var _len = arguments.length, otherPropNames = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
    otherPropNames[_key - 1] = arguments[_key];
  }

  return function validate(props, propName, componentName, location, propFullName) {
    var componentNameSafe = componentName || '<<anonymous>>';
    var propFullNameSafe = propFullName || propName;
    var allPropNames = [propFullNameSafe].concat(otherPropNames);

    for (var _len2 = arguments.length, args = Array(_len2 > 5 ? _len2 - 5 : 0), _key2 = 5; _key2 < _len2; _key2++) {
      args[_key2 - 5] = arguments[_key2];
    }

    var err = validator.apply(undefined, [props, propName, componentName, location, propFullName].concat(args));
    if (!err && !allPropNames.filter(function (pn) {
      return typeof props[pn] !== 'undefined';
    }).length) {
      err = new Error('One of the following props are required for the ' + componentNameSafe + ' component. ' + ('`' + allPropNames.join('`, `') + '`.'));
    }

    return err;
  };
}

/**
 * The `TableCardHeader` is used when contextual actions should appear when
 * a user selects a row.
 */

var TableCardHeader = function (_PureComponent) {
  inherits(TableCardHeader, _PureComponent);

  function TableCardHeader(props) {
    classCallCheck(this, TableCardHeader);

    var _this = possibleConstructorReturn(this, (TableCardHeader.__proto__ || Object.getPrototypeOf(TableCardHeader)).call(this, props));

    _this.state = { animating: false };
    return _this;
  }

  createClass(TableCardHeader, [{
    key: 'componentWillReceiveProps',
    value: function componentWillReceiveProps(nextProps) {
      var _this2 = this;

      var visible = this.props.visible;
      var nVisible = nextProps.visible,
          transitionEnterTimeout = nextProps.transitionEnterTimeout,
          transitionLeaveTimeout = nextProps.transitionLeaveTimeout;

      var timeout = !nVisible ? transitionLeaveTimeout : transitionEnterTimeout;
      if (visible !== nVisible) {
        if (this._timeout) {
          clearTimeout(this._timeout);
        }

        this._timeout = setTimeout(function () {
          _this2._timeout = setTimeout(function () {
            _this2._timeout = null;
            _this2.setState({ animating: false });
          }, timeout);
        }, TICK);

        if (!this.state.animating) {
          this.setState({ animating: true });
        }
      }
    }
  }, {
    key: '_cloneCellRight',
    value: function _cloneCellRight(noAdjust, children) {
      if (noAdjust || !children) {
        return children;
      }

      return Children.map(Children.toArray(children), function (child, i) {
        if (i === 0) {
          return cloneElement(child, { className: classnames('md-cell--right', child.props.className) });
        }

        return child;
      });
    }
  }, {
    key: '_cloneLeftChildren',
    value: function _cloneLeftChildren(noClone, children) {
      if (noClone || !children) {
        return children;
      }

      return Children.map(Children.toArray(children), function (child) {
        return cloneElement(child, {
          className: classnames('md-btn--dialog', child.props.className)
        });
      });
    }
  }, {
    key: 'render',
    value: function render() {
      var animating = this.state.animating;
      var _props = this.props,
          style = _props.style,
          className = _props.className,
          title = _props.title,
          titleId = _props.titleId,
          actions = _props.actions,
          contextualTitleId = _props.contextualTitleId,
          contextualChildren = _props.contextualChildren,
          noActionsAdjust = _props.noActionsAdjust,
          noChildrenAdjust = _props.noChildrenAdjust,
          noLeftChildrenClone = _props.noLeftChildrenClone,
          visible = _props.visible,
          propChildren = _props.children,
          propLeftChildren = _props.leftChildren,
          propContextualTitle = _props.contextualTitle,
          props = objectWithoutProperties(_props, ['style', 'className', 'title', 'titleId', 'actions', 'contextualTitleId', 'contextualChildren', 'noActionsAdjust', 'noChildrenAdjust', 'noLeftChildrenClone', 'visible', 'children', 'leftChildren', 'contextualTitle']);
      var _props2 = this.props,
          children = _props2.children,
          leftChildren = _props2.leftChildren,
          contextualTitle = _props2.contextualTitle;

      children = this._cloneCellRight(noChildrenAdjust, children);
      leftChildren = this._cloneLeftChildren(noLeftChildrenClone, leftChildren);

      if (title) {
        children = React.createElement(
          'div',
          { className: 'md-card-title', key: 'main-title' },
          React.createElement(CardTitleBlock, { id: titleId, title: title }),
          children
        );
      } else if (leftChildren) {
        leftChildren = Children.toArray(leftChildren);

        if (children) {
          children = leftChildren.concat(Children.toArray(children));
        } else {
          children = leftChildren;
        }
      }

      if (contextualTitle) {
        contextualTitle = React.createElement(
          'h2',
          {
            id: contextualTitleId,
            className: 'md-card-title--title md-card-title--title-contextual',
            tabIndex: contextualTitleId ? -1 : null
          },
          contextualTitle
        );
      }

      var contextualHeader = React.createElement(
        'div',
        { key: 'contextual-header', className: 'md-card-title md-card-title--contextual' },
        contextualTitle,
        contextualChildren,
        this._cloneCellRight(noActionsAdjust, actions)
      );

      var mergedStyles = style;
      if (animating) {
        mergedStyles = Object.assign({}, style, { overflow: 'hidden' });
      }

      return React.createElement(
        CSSTransitionGroup,
        _extends({}, props, {
          style: mergedStyles,
          className: classnames('md-table-card-header', {
            'md-table-card-header--no-title': !title
          }, className)
        }),
        children,
        visible ? contextualHeader : null
      );
    }
  }]);
  return TableCardHeader;
}(PureComponent);

TableCardHeader.propTypes = {
  /**
   * An optional style to apply.
   */
  style: propTypes.object,

  /**
   * An optional className to apply.
   */
  className: propTypes.string,

  /**
   * The component to render as.
   */
  component: propTypes.oneOfType([propTypes.func, propTypes.string]).isRequired,

  /**
   * The transition name to use when the contextual header appears.
   */
  transitionName: propTypes.string.isRequired,

  /**
   * The transition time to use when the contextual header appears.
   */
  transitionEnterTimeout: propTypes.number.isRequired,

  /**
   * The transition time to use when the contextual header disappears.
   */
  transitionLeaveTimeout: propTypes.number.isRequired,

  /**
   * An optional title to display. It is invalid to have both `title` and `leftChildren`
   * defined as only one will be used.
   */
  title: oneRequired(propTypes.node, 'leftChildren', 'children'),

  /**
   * An optional id to provide to the title.
   */
  titleId: propTypes.oneOfType([propTypes.number, propTypes.string]),

  /**
   * An optional title to display in the contextual header. This will get wrapped in an `h2`
   * tag and additional styles applied.
   */
  contextualTitle: propTypes.node,

  /**
   * An optional id to provide to the contextual title.
   */
  contextualTitleId: propTypes.oneOfType([propTypes.number, propTypes.string]),

  /**
   * Any additional children to display in the contextual header. This will be displayed after
   * the optional `contextualTile` and before the `actions`.
   */
  contextualChildren: propTypes.node,

  /**
   * An optional button or list of buttons to display instead of a title.
   */
  leftChildren: invalidIf(propTypes.oneOfType([propTypes.element, propTypes.arrayOf(propTypes.element)]), 'title'),

  /**
   * An additional children to display after the `title` or `leftChildren` prop.
   * This is _normally_ a list of icon button or menu button.
   */
  children: propTypes.oneOfType([propTypes.element, propTypes.arrayOf(propTypes.element)]),

  /**
   * An optional button/menu button or a list of button/menu button to display in the
   * contextual header once the user has selected a row or multiple rows.
   */
  actions: propTypes.oneOfType([propTypes.element, propTypes.arrayOf(propTypes.element)]),

  /**
   * Boolean if the `actions` prop should not have each element cloned with additional
   * class names.
   */
  noActionsAdjust: propTypes.bool,

  /**
   * Boolean if the `children` prop should not have each element cloned with additional
   * class names.
   */
  noChildrenAdjust: propTypes.bool,

  /**
   * Boolean if the `leftChildren` prop should not have each element cloned with additional
   * class names.
   */
  noLeftChildrenClone: propTypes.bool,

  /**
   * Boolean if the contextual header is currently visible.
   */
  visible: propTypes.bool.isRequired
};
TableCardHeader.defaultProps = {
  component: 'header',
  transitionName: 'md-drop-down',
  transitionEnterTimeout: 150,
  transitionLeaveTimeout: 150
};

/** @module utils/toggleScroll */
/**
 * A utility function for toggling the overflow visibility on an element. This will either target
 * the given `selector`, or the `body` tag to set a `className`.
 *
 * If the `visible` param is `undefined`, the className will be toggled.
 * If the `visible` param is `true`, the className will be added.
 * If the `visible` param is `false`, the className will be removed.
 *
 *
 * > This depends on the `classList` attribute on elements.
 *
 * @param {bool=} visible - An optional boolean to determine how the `className` will be applied.
 * @param {string|Object=} selector - An optional query selector string to use to select an element.
 * @param {string=} className - The className to apply. Defaults to 'md-overflow-hidden'
 */
function toggleScroll(scrollable, selector) {
  var className = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'md-no-scroll';

  var queryable = !selector || typeof selector === 'string';
  var el = void 0;
  if (queryable) {
    el = selector ? document.querySelector(selector) : document.querySelector('html');
  } else {
    el = selector;
  }

  if (!el) {
    return;
  }

  if (typeof scrollable === 'undefined') {
    scrollable = !el.classList.contains(className);
  }

  if (scrollable && !el.classList.contains(className)) {
    el.style.top = '-' + (queryable ? getPagePosition('y') : el.scrollTop) + 'px';
    el.classList.add(className);
  } else if (!scrollable && el.classList.contains(className)) {
    var scrollTop = Math.abs(parseInt(el.style.top, 10));
    el.classList.remove(className);
    el.style.top = null;

    if (!selector) {
      window.scrollTo(0, scrollTop);
    } else {
      el.scrollTop = scrollTop;
    }
  }
}

/**
 * The `DialogContainer` component is used for dynamically creating the `Dialog` with
 * transitions.
 */

var DialogContainer = function (_PureComponent) {
  inherits(DialogContainer, _PureComponent);

  function DialogContainer(props) {
    classCallCheck(this, DialogContainer);

    var _this = possibleConstructorReturn(this, (DialogContainer.__proto__ || Object.getPrototypeOf(DialogContainer)).call(this, props));

    _initialiseProps$12.call(_this);

    var visible = typeof props.isOpen !== 'undefined' ? props.isOpen : props.visible;
    var dialogVisible = visible && !props.defaultVisibleTransitionable;

    _this.state = {
      active: visible && !props.fullPage,
      portalVisible: visible,
      dialogVisible: dialogVisible
    };
    return _this;
  }
  /* eslint-disable max-len */


  createClass(DialogContainer, [{
    key: 'componentDidMount',
    value: function componentDidMount() {
      if (!this.props.isOpen && !this.props.visible) {
        return;
      }

      this._mountDialog(this.props);
    }
  }, {
    key: 'componentWillReceiveProps',
    value: function componentWillReceiveProps(nextProps) {
      var visible = typeof nextProps.isOpen !== 'undefined' ? nextProps.isOpen : nextProps.visible;
      if (this.props.isOpen === visible || this.props.visible === visible) {
        return;
      }

      var el = getField(this.props, this.context, 'renderNode') || window;
      var pageX = el.scrollX,
          pageY = el.scrollY;

      if (typeof el.scrollTop !== 'undefined' && typeof el.scrollLeft !== 'undefined') {
        pageX = el.scrollLeft;
        pageY = el.scrollTop;
      } else if (typeof el.scrollY !== 'undefined' && typeof el.scrollX !== 'undefined') {
        pageX = el.scrollX;
        pageY = el.scrollY;
      }

      this._pageX = pageX;
      this._pageY = pageY;

      if (this._inTimeout) {
        clearTimeout(this._inTimeout);
        this._inTimeout = null;
      }

      if (visible) {
        this._activeElement = document.activeElement;
        this._mountPortal(nextProps);
      } else {
        this.setState({ dialogVisible: false, active: false });
      }
    }
  }, {
    key: 'componentDidUpdate',
    value: function componentDidUpdate(prevProps) {
      var _props = this.props,
          visible = _props.visible,
          closeOnEsc = _props.closeOnEsc,
          modal = _props.modal;

      var escapable = !modal && closeOnEsc;
      var prevEscapable = !prevProps.modal && prevProps.closeOnEsc;

      // Only going to support visible here since it was not implemented before.
      if (visible === prevProps.visible && escapable === prevEscapable) {
        return;
      }

      var add = false;
      var remove = false;

      if (escapable !== prevEscapable) {
        add = visible && escapable;
        remove = !visible || prevEscapable && !escapable;
      } else if (escapable) {
        add = visible;
        remove = !visible;
      }

      if (add) {
        window.addEventListener('keydown', this._handleEscClose);
      } else if (remove) {
        window.removeEventListener('keydown', this._handleEscClose);
      }
    }
  }, {
    key: 'componentWillUnmount',
    value: function componentWillUnmount() {
      if (this.props.isOpen || this.props.visible) {
        toggleScroll(false);
      }

      if (this.props.visible && this.props.closeOnEsc && !this.props.modal) {
        window.removeEventListener('keydown', this._handleEscClose);
      }

      if (this._inTimeout) {
        clearTimeout(this._inTimeout);
      }
    }
  }, {
    key: 'render',
    value: function render() {
      var _state = this.state,
          active = _state.active,
          dialogVisible = _state.dialogVisible,
          portalVisible = _state.portalVisible;
      var _props2 = this.props,
          style = _props2.style,
          className = _props2.className,
          dialogStyle = _props2.dialogStyle,
          dialogClassName = _props2.dialogClassName,
          modal = _props2.modal,
          fullPage = _props2.fullPage,
          component = _props2.component,
          transitionEnterTimeout = _props2.transitionEnterTimeout,
          transitionLeaveTimeout = _props2.transitionLeaveTimeout,
          lastChild = _props2.lastChild,
          portal = _props2.portal,
          propVisible = _props2.visible,
          propRenderNode = _props2.renderNode,
          closeOnEsc = _props2.closeOnEsc,
          onShow = _props2.onShow,
          onHide = _props2.onHide,
          disableScrollLocking = _props2.disableScrollLocking,
          defaultVisibleTransitionable = _props2.defaultVisibleTransitionable,
          close = _props2.close,
          isOpen = _props2.isOpen,
          actionLeft = _props2.actionLeft,
          actionRight = _props2.actionRight,
          transitionName = _props2.transitionName,
          transitionEnter = _props2.transitionEnter,
          transitionLeave = _props2.transitionLeave,
          props = objectWithoutProperties(_props2, ['style', 'className', 'dialogStyle', 'dialogClassName', 'modal', 'fullPage', 'component', 'transitionEnterTimeout', 'transitionLeaveTimeout', 'lastChild', 'portal', 'visible', 'renderNode', 'closeOnEsc', 'onShow', 'onHide', 'disableScrollLocking', 'defaultVisibleTransitionable', 'close', 'isOpen', 'actionLeft', 'actionRight', 'transitionName', 'transitionEnter', 'transitionLeave']);


      var renderNode = getField(this.props, this.context, 'renderNode');
      var dialog = React.createElement(Dialog, _extends({
        key: 'dialog',
        style: dialogStyle,
        className: classnames('md-background--card', dialogClassName),
        ref: this._handleDialogMounting,
        centered: !fullPage,
        fullPage: fullPage
      }, props, {
        containerX: this._pageX,
        containerY: this._pageY,
        onLeave: this._unmountPortal
      }));

      var container = React.createElement(
        CSSTransitionGroup,
        {
          component: component,
          ref: this._setContainer,
          style: style,
          className: classnames('md-dialog-container', {
            'md-overlay': !fullPage,
            'md-overlay--active': !fullPage && active && propVisible,
            'md-pointer--hover': !fullPage && !modal && propVisible
          }, className),
          transitionName: 'md-dialog--' + (fullPage ? 'full-page' : 'centered'),
          transitionEnterTimeout: transitionEnterTimeout,
          transitionLeaveTimeout: transitionLeaveTimeout,
          tabIndex: -1,
          onClick: this._handleClick
        },
        dialogVisible ? dialog : null
      );

      if (!portal) {
        return portalVisible ? container : null;
      }

      return React.createElement(
        Portal,
        { visible: portalVisible, renderNode: renderNode, lastChild: lastChild },
        container
      );
    }
  }]);
  return DialogContainer;
}(PureComponent);

DialogContainer.propTypes = {
  /**
   * An id to use for the `Dialog` once it has been opened. This is used for the
   * [dialog role](https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/ARIA_Techniques/Using_the_dialog_role).
   * This is used to generate an `id` for the `title` prop when it has been defined.
   */
  id: isRequiredForA11y(propTypes.oneOfType([propTypes.number, propTypes.string])),
  /* eslint-enable max-len */

  /**
   * An optional accessibility prop to use when the `Dialog` is opened. This should be an id
   * pointing to some text that describes the content of the dialog. For accessibility
   * reasons, one of the following props must be defined:
   * - `title`
   * - `aria-describedby`
   * - `aria-labelledby`
   * - `aria-label`
   *
   * An example usage:
   *
   * ```js
   * <Dialog id="accessible-example" visible aria-describedby="accessible-content">
   *   <p id="accessible-content">This is some content that describes the dialog.</p>
   * </Dialog>
   * ```
   */
  'aria-describedby': oneRequiredForA11y(propTypes.oneOfType([propTypes.number, propTypes.string]), 'title', 'aria-labelledby', 'aria-label'),

  /**
   * An optional accessibility prop to use when the `title` prop is not given. This should be
   * an id pointing to a `h` tag that labels the dialog.
   *
   * An example usage:
   *
   * ```js
   * <Dialog visible id="accessible-example" aria-labelledby="accessible-dialog-label">
   *   <h2 id="accessible-dialog-label">Some Accessible Dialog</h2>
   * </Dialog>
   * ```
   */
  'aria-labelledby': propTypes.oneOfType([propTypes.number, propTypes.string]),

  /**
   * An optional accessibility prop to use when the `title` and `aria-labelledby` props are
   * not defined. This should be a string that describes what is in the `Dialog`.
   *
   * An example usage:
   *
   * ```js
   * <Dialog visible id="accessible-example" aria-label="Some Accessible Dialog">
   *   <p>Lorem Ipsum</p>
   * </Dialog>
   * ```
   */
  'aria-label': propTypes.string,

  /**
   * An optional style to apply to the dialog's container.
   */
  style: propTypes.object,

  /**
   * An optional className to apply to the dialog's container.
   */
  className: propTypes.string,

  /**
   * An optional style to apply to the dialog itself when the `visible` prop is `true`.
   */
  dialogStyle: propTypes.object,

  /**
   * An optional className to apply to the dialog itself when the `visible` prop is `true`.
   */
  dialogClassName: propTypes.string,

  /**
   * An optional styke to apply to the title.
   */
  titleStyle: propTypes.object,

  /**
   * An optional className to apply to the title.
   */
  titleClassName: propTypes.string,

  /**
   * An optional style to apply to the footer. This is used when the `actions`
   * prop is defined.
   */
  footerStyle: propTypes.object,

  /**
   * An optional className to apply to the footer. This is used when the `actions`
   * prop is defined.
   */
  footerClassName: propTypes.string,

  /**
   * An optional style to apply to the dialog's content.
   */
  contentStyle: propTypes.object,

  /**
   * An optional className to apply to the dialog's content.
   */
  contentClassName: propTypes.string,

  /**
   * The component to render the dialog's container in.
   */
  component: propTypes.oneOfType([propTypes.func, propTypes.string]).isRequired,

  /**
   * The component to render the dialog's content in.
   */
  contentComponent: propTypes.oneOfType([propTypes.func, propTypes.string]).isRequired,

  /**
   * The content to display in the dialog once open.
   */
  children: propTypes.node,

  /**
   * A single action or a list of actions to display in the dialog. This can either be a list
   * of `FlatButton` props or `<Button flat {...props} />` elements.
   */
  actions: propTypes.oneOfType([propTypes.element, propTypes.object, propTypes.arrayOf(propTypes.oneOfType([propTypes.element, propTypes.object]))]),

  /**
   * Boolean if the `Dialog` is current visible.
   */
  visible: propTypes.bool.isRequired,

  /**
   * An optional function to call when the `visible` prop is changed from `false` to `true`.
   */
  onShow: propTypes.func,

  /**
   * A function to call that will close the dialog. This is required when the `modal` and `fullPage`
   * props are not `true`.
   */
  onHide: function onHide(props, propName) {
    for (var _len = arguments.length, args = Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
      args[_key - 2] = arguments[_key];
    }

    var validator = propTypes.func;
    if (!props.modal && !props.fullPage) {
      validator = validator.isRequired;
    }

    return validator.apply(undefined, [props, propName].concat(args));
  },

  /**
   * Boolean if the dialog should behave like a modal. This means that the dialog can only
   * be closed by clicking on an action instead of also clicking on the overlay.
   */
  modal: propTypes.bool,

  /**
   * Boolean if the dialog should be displayed as a full page dialog.
   */
  fullPage: function fullPage(props, propName, componentName) {
    for (var _len2 = arguments.length, args = Array(_len2 > 3 ? _len2 - 3 : 0), _key2 = 3; _key2 < _len2; _key2++) {
      args[_key2 - 3] = arguments[_key2];
    }

    var componentNameSafe = componentName || '<<anonymous>>';
    var err = propTypes.bool.apply(propTypes, [props, propName, componentName].concat(args));

    if (!err && props[propName] && typeof props.title !== 'undefined') {
      err = new Error('You provided a `title` ' + location + ' to the `' + componentNameSafe + '` when `fullPage` ' + 'has been set to true. A title for a full page dialog should be rendered as a child instead.');
    }

    return err;
  },

  /**
   * An optional pageX location to use when rendering a full page dialog. This is used to set the location
   * the dialog should appear from.
   */
  pageX: propTypes.number,

  /**
   * An optional pageY location to use when rendering a full page dialog. This is used to set the location
   * the dialog should appear from.
   */
  pageY: propTypes.number,

  /**
   * @see {@link Helpers/FocusContainer#additionalFocusKeys}
   */
  additionalFocusKeys: Dialog.propTypes.additionalFocusKeys,

  /**
   * @see {@link Helpers/FocusContainer#initialFocus}
   */
  initialFocus: Dialog.propTypes.initialFocus,

  /**
   * @see {@link Helpers/FocusContainer#focusOnMount}
   */
  focusOnMount: Dialog.propTypes.focusOnMount,

  /**
   * @see {@link Helpers/FocusContainer#containFocus}
   */
  containFocus: Dialog.propTypes.containFocus,

  /**
   * The transition enter timeout for the dialog.
   */
  transitionEnterTimeout: propTypes.number.isRequired,

  /**
   * The transition leave timeout for the dialog.
   */
  transitionLeaveTimeout: propTypes.number.isRequired,

  /**
   * Boolean if the dialog should be closable by pressing the escape key.
   * This will always be considered `false` of the `modal` props is `true`.
   */
  closeOnEsc: propTypes.bool,

  /**
   * Boolean if the Portal's functionality of rendering in a separate react tree should be applied
   * to the dialog.
   *
   * @see {@link Helpers/Portal}
   */
  portal: propTypes.bool,

  /**
   * Since the `Dialog` uses the `Portal` component, you can pass an optional HTML Node to render
   * the dialog in instead of the `document.body`.
   */
  renderNode: propTypes.object,

  /**
   * Boolean if the dialog should be rendered as the last child in the `renderNode` or `body` instead
   * of as the first.
   */
  lastChild: propTypes.bool,

  /**
   * An optional title for the dialog.
   */
  title: propTypes.node,

  /**
   * Boolean if the dialog should animate into view if it is constructed with `visible` enabled.
   *
   * This basically means that if the `Dialog` has `visible` enabled on initial page load, does it animate?
   * In some cases, it can also mean if the `Dialog` is added to the render tree with `visible` enabled,
   * does it animate?
   */
  defaultVisibleTransitionable: propTypes.bool,

  /**
   * Boolean if the Dialog should no longer try to prevent the parent container from scrolling while visible.
   * In most cases, this will attempt to prevent the main window scrolling. If this dialog is nested in another
   * dialog, it will attempt to prevent the parent dialog from scrolling.
   */
  disableScrollLocking: propTypes.bool,

  /**
   * Boolean if the dialog should automatically try to determine if the content
   * should be padded. It will be padded if the dialog does not contain a `List`.
   */
  autopadContent: propTypes.bool,

  /**
   * Boolean if the dialog content's size should automatically be resized to overflow
   * correctly when there is a lot of content. This will calculate and apply some `maxHeight`
   * to the `contentStyle`.
   */
  autosizeContent: propTypes.bool,

  /**
   * An optional height to apply to the dialog. This is used if it is easier to just apply height/width
   * with for specific dialogs instead of in CSS.
   *
   * **This prop should not be used if the `fullPage` prop is enabled.**
   *
   * @see {@link #fullPage}
   * @see {@link #width}
   */
  height: propTypes.oneOfType([propTypes.number, propTypes.string]),

  /**
   * An optional width to apply to the dialog. This is used if it is easier to just apply height/width
   * with for specific dialogs instead of in CSS.
   *
   * **This prop should not be used if the `fullPage` prop is enabled.**
   *
   * @see {@link #fullPage}
   * @see {@link #height}
   */
  width: propTypes.oneOfType([propTypes.number, propTypes.string]),

  /**
   * Boolean if the actions should be stacked on top of each other. If this value is `undefined`, it will
   * automatically attempt to guess if the items should be stacked.
   */
  stackedActions: propTypes.bool,

  isOpen: deprecated(propTypes.bool, 'Use `visible` instead'),
  transitionName: deprecated(propTypes.string, 'The transition name will be managed by the component'),
  transitionEnter: deprecated(propTypes.bool, 'The transition will always be enforced'),
  transitionLeave: deprecated(propTypes.bool, 'The transition will always be enforced'),
  actionLeft: deprecated(propTypes.node, 'Use the `fullPage` prop instead'),
  actionRight: deprecated(propTypes.node, 'Use the `fullPage` prop instead'),
  close: deprecated(propTypes.func, 'Use `onHide` instead')
};
DialogContainer.defaultProps = {
  autopadContent: true,
  autosizeContent: true,
  component: 'span',
  closeOnEsc: true,
  contentComponent: 'section',
  focusOnMount: true,
  transitionEnterTimeout: 300,
  transitionLeaveTimeout: 300,
  defaultVisibleTransitionable: false
};
DialogContainer.contextTypes = {
  renderNode: propTypes.object
};

var _initialiseProps$12 = function _initialiseProps() {
  var _this2 = this;

  this._setContainer = function (container) {
    if (container !== null) {
      _this2._container = findDOMNode(container);
    }
  };

  this._handleEscClose = function (e) {
    if ((e.which || e.keyCode) === ESC) {
      (_this2.props.onHide || _this2.props.close)(e);
    }
  };

  this._mountPortal = function (props) {
    _this2._mountDialog(props);
    _this2.setState({ portalVisible: true });
  };

  this._mountDialog = function (props) {
    var fullPage = props.fullPage,
        onShow = props.onShow;

    _this2._inTimeout = setTimeout(function () {
      _this2._inTimeout = fullPage ? null : setTimeout(function () {
        _this2._inTimeout = null;
        _this2.setState({ active: true });
      }, TICK);
      _this2.setState({ dialogVisible: true }, onShow);
    }, TICK);
  };

  this._unmountPortal = function () {
    _this2.setState({ portalVisible: false });
  };

  this._handleClick = function (e) {
    var visible = typeof _this2.props.isOpen !== 'undefined' ? _this2.props.isOpen : _this2.props.visible;
    if (_this2.props.modal || !visible || e.target !== _this2._container) {
      return;
    }

    (_this2.props.onHide || _this2.props.close)(e);
  };

  this._handleDialogMounting = function (dialog) {
    var disableScrollLocking = _this2.props.disableScrollLocking;

    if (dialog === null) {
      if (_this2._activeElement) {
        _this2._activeElement.focus();
      }

      if (!disableScrollLocking) {
        toggleScroll(false, _this2.scrollEl);
      }

      _this2._activeElement = null;
    } else {
      var container = document.getElementById(_this2.props.id);
      if (!container || disableScrollLocking) {
        return;
      }

      var el = getField(_this2.props, _this2.context, 'renderNode');
      var node = container.parentNode;
      while (node && node.classList && !el) {
        if (node.classList.contains('md-dialog')) {
          el = node;
        }

        node = node.parentNode;
      }

      _this2.scrollEl = el;
      toggleScroll(true, el);
    }
  };
};

var MOBILE_MIN_WIDTH = 320;
var TABLET_MIN_WIDTH = 768;
var DESKTOP_MIN_WIDTH = 1025;

var Overlay = function (_PureComponent) {
  inherits(Overlay, _PureComponent);

  function Overlay() {
    classCallCheck(this, Overlay);
    return possibleConstructorReturn(this, (Overlay.__proto__ || Object.getPrototypeOf(Overlay)).apply(this, arguments));
  }

  createClass(Overlay, [{
    key: 'getChildContext',
    value: function getChildContext() {
      // Always want the overlay to render in a separate subtree until 1.1.0
      return { isInPortal: false };
    }
  }, {
    key: 'render',
    value: function render() {
      var _props = this.props,
          active = _props.active,
          visible = _props.visible,
          renderNode = _props.renderNode,
          onClick = _props.onClick,
          style = _props.style,
          className = _props.className;

      return React.createElement(
        Portal,
        { visible: visible, renderNode: renderNode },
        React.createElement('div', {
          style: style,
          className: classnames('md-overlay md-overlay--drawer md-pointer--hover', {
            'md-overlay--active': active
          }, className),
          onClick: onClick
        })
      );
    }
  }]);
  return Overlay;
}(PureComponent);

Overlay.propTypes = {
  style: propTypes.object,
  className: propTypes.string,
  active: propTypes.bool,
  visible: propTypes.bool.isRequired,
  renderNode: propTypes.object,
  onClick: propTypes.func
};
Overlay.childContextTypes = {
  isInPortal: propTypes.bool
};

/** @module Drawers/DrawerTypes */

/**
 * An enum for all the different type of drawers.
 *
 * @readonly
 * @enum {string}
 */
var DrawerTypes = {
  // Permanent drawers
  /**
   * This is the default drawer type. It will always be on the screen and takes
   * up the entire height. This is very helpful for main navigation on desktops
   * when you do not need an expandable workspace.
   */
  FULL_HEIGHT: 'full-height',

  /**
   * This drawer type will always be on the screen, but it will appear under the
   * main toolbar.
   */
  CLIPPED: 'clipped',

  /**
   * This drawer type will always be on the screen, but it will appear under the
   * main toolbar and have a transparent background. This is useful if you want
   * a persistent drawer on desktop screens, but do not want the main focus to be
   * the drawer.
   */
  FLOATING: 'floating',

  // Persistent drawers
  /**
   * A persistent drawer changes between being hidden and being fixed on the page like
   * a permanent drawer. When it is visible, it will take up the same amount of room
   * as a permanent drawer, and will not go away until closed.
   *
   * This drawer type is helpful when you need to have a dynamic workspace size.
   */
  PERSISTENT: 'persistent',

  /**
   * This is a modification of the persistent drawer. It will behave as the persistent drawer
   * but it will always have a "mini" drawer visible. This is helpful when you want to have
   * a dynamic workspace size and keep certain actions available at all times.
   */
  PERSISTENT_MINI: 'persistent-mini',

  // Temporary
  /**
   * A temporary drawer will not be visible by default. When it is visible, it will overlay
   * the page to get the main focus on the drawer. When the user touches the overlay or
   * one of the navigation items, the drawer will be closed. The overlay can be disabled on
   * desktop and tablets.
   */
  TEMPORARY: 'temporary',

  /**
   * This is a modification of the temporary drawer. It will behave like a temporary drawer,
   * but it will always have a "mini" drawer visible. Just like the `PERSISTENT_MINI` drawer
   * type, this is useful when certain actions should be available at all times but additional
   * actions are available when the drawer is visible.
   */
  TEMPORARY_MINI: 'temporary-mini'
};

var FULL_HEIGHT = DrawerTypes.FULL_HEIGHT;
var CLIPPED = DrawerTypes.CLIPPED;
var FLOATING = DrawerTypes.FLOATING;
var PERSISTENT = DrawerTypes.PERSISTENT;
var PERSISTENT_MINI = DrawerTypes.PERSISTENT_MINI;
var TEMPORARY = DrawerTypes.TEMPORARY;
var TEMPORARY_MINI = DrawerTypes.TEMPORARY_MINI;


function isTemporary(type) {
  return [TEMPORARY, TEMPORARY_MINI].indexOf(type) !== -1;
}

function isPersistent(type) {
  return [PERSISTENT, PERSISTENT_MINI].indexOf(type) !== -1;
}

function isPermanent(type) {
  return [FULL_HEIGHT, CLIPPED, FLOATING].indexOf(type) !== -1;
}

function isMini(type) {
  return [PERSISTENT_MINI, TEMPORARY_MINI].indexOf(type) !== -1;
}

var oneOfDrawerTypes = propTypes.oneOf([DrawerTypes.FULL_HEIGHT, DrawerTypes.CLIPPED, DrawerTypes.FLOATING, DrawerTypes.PERSISTENT, DrawerTypes.PERSISTENT_MINI, DrawerTypes.TEMPORARY, DrawerTypes.TEMPORARY_MINI]);

/**
 * The `Drawer` component is used for having a sliding panel of content or navigation
 * that appears from the side of a screen.
 *
 * If the `Drawer` uses any of the `_MINI` drawer types, you will need to also create another
 * `Drawer` that is not `_MINI`. Transitioning the `width` on mobile devices is very sluggish,
 * and it isn't much more work to create another drawer.
 */

var Drawer = function (_PureComponent) {
  inherits(Drawer, _PureComponent);
  createClass(Drawer, null, [{
    key: 'getCurrentMedia',


    /**
     * Determines the current media and returns an object containing matches for `mobile`, `tablet`, `desktop`,
     * and the current drawer type. This expects a `props` object of the drawer.
     *
     * If this is used server side, it will default to only matching mobile.
     *
     * @param {Object=} props - The current drawer's prop shape to extract the mobile, tablet,
     *    and desktop type/min widths. This defaults to the drawer's default props.
     * @return {Object} an object containing the media matches and the current type to use for the drawer.
     */
    value: function getCurrentMedia() {
      var props = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : Drawer.defaultProps;
      var mobileMinWidth = props.mobileMinWidth,
          tabletMinWidth = props.tabletMinWidth,
          desktopMinWidth = props.desktopMinWidth,
          mobileType = props.mobileType,
          tabletType = props.tabletType,
          desktopType = props.desktopType,
          constantType = props.constantType;

      if (typeof window === 'undefined') {
        var _type = constantType && props.type ? props.type : mobileType;
        return { mobile: true, tablet: false, desktop: false, type: _type };
      }

      var mobile = Drawer.matchesMedia(mobileMinWidth, tabletMinWidth - 1);
      var tablet = Drawer.matchesMedia(tabletMinWidth, desktopMinWidth);
      var desktop = Drawer.matchesMedia(desktopMinWidth);

      var type = void 0;
      if (constantType && props.type && isTemporary(props.type)) {
        type = props.type;
      } else if (desktop) {
        type = desktopType;
      } else if (tablet) {
        type = tabletType;
      } else {
        type = mobileType;
      }

      return { type: type, mobile: mobile, tablet: tablet, desktop: desktop };
    }

    /**
     * Simply does a `window.matchMedia(query)` where the query gets defined as a min width
     * and optional max width.
     *
     * @param {number} min - The min width for the media query.
     * @param {number=} max - An optional max width to include for the media query.
     * @return {boolean} true if the media matches.
     */

  }, {
    key: 'matchesMedia',
    value: function matchesMedia(min, max) {
      var media = 'screen and (min-width: ' + min + 'px)';
      if (max) {
        media += ' and (max-width: ' + max + 'px)';
      }

      return window.matchMedia(media).matches;
    }
  }]);

  function Drawer(props) {
    classCallCheck(this, Drawer);

    var _this = possibleConstructorReturn(this, (Drawer.__proto__ || Object.getPrototypeOf(Drawer)).call(this, props));

    _initialiseProps$13.call(_this);

    var defaultVisible = props.defaultVisible,
        defaultMedia = props.defaultMedia,
        overlay = props.overlay;


    _this.state = {
      mobile: defaultMedia === 'mobile',
      tablet: defaultMedia === 'tablet',
      desktop: defaultMedia === 'desktop',
      animating: false,
      overlayActive: false,
      drawerActive: false
    };

    if (typeof props.type === 'undefined') {
      _this.state.type = props[defaultMedia + 'Type'];
    }

    var type = getField(props, _this.state, 'type');
    _this._initialFix = true;

    if (typeof props.visible === 'undefined') {
      var _visible = isPermanent(type) || isMini(type);
      if (!_visible && typeof defaultVisible !== 'undefined') {
        _visible = defaultVisible;
      }

      _this.state.visible = _visible;
    }

    var visible = getField(props, _this.state, 'visible');

    _this.state.overlayActive = (typeof overlay !== 'undefined' ? overlay : isTemporary(type) && !_this.state.desktop) && visible;
    _this.state.drawerActive = visible;
    return _this;
  }

  createClass(Drawer, [{
    key: 'componentWillMount',
    value: function componentWillMount() {
      if (typeof window !== 'undefined') {
        this._updateType(this.props);
      }
    }
  }, {
    key: 'componentDidMount',
    value: function componentDidMount() {
      if (!isMini(getField(this.props, this.state, 'type'))) {
        window.addEventListener('resize', this._updateMedia);
      }
    }
  }, {
    key: 'componentWillReceiveProps',
    value: function componentWillReceiveProps(nextProps) {
      var _props = this.props,
          mobileMinWidth = _props.mobileMinWidth,
          mobileType = _props.mobileType,
          tabletMinWidth = _props.tabletMinWidth,
          tabletType = _props.tabletType,
          desktopMinWidth = _props.desktopMinWidth,
          desktopType = _props.desktopType;


      if (nextProps.mobileMinWidth !== mobileMinWidth || nextProps.mobileType !== mobileType || nextProps.tabletMinWidth !== tabletMinWidth || nextProps.tabletType !== tabletType || nextProps.desktopMinWidth !== desktopMinWidth || nextProps.desktopType !== desktopType) {
        this._updateType(nextProps);
      }

      var visible = nextProps.visible,
          transitionDuration = nextProps.transitionDuration,
          overlay = nextProps.overlay;

      if (this.props.visible === nextProps.visible) {
        return;
      }

      var type = getField(nextProps, this.state, 'type');
      this._animate(visible, type, transitionDuration, overlay, this.state.desktop);
    }
  }, {
    key: 'componentWillUnmount',
    value: function componentWillUnmount() {
      if (this._timeout) {
        clearTimeout(this._timeout);
      }

      if (this._closeTimeout) {
        clearTimeout(this._closeTimeout);
      }

      window.removeEventListener('resize', this._updateMedia);
    }
  }, {
    key: 'render',
    value: function render() {
      var _cn;

      var _state = this.state,
          overlayActive = _state.overlayActive,
          drawerActive = _state.drawerActive,
          animating = _state.animating;
      var _props2 = this.props,
          id = _props2.id,
          style = _props2.style,
          className = _props2.className,
          navStyle = _props2.navStyle,
          navClassName = _props2.navClassName,
          component = _props2.component,
          navItems = _props2.navItems,
          header = _props2.header,
          children = _props2.children,
          inline = _props2.inline,
          position = _props2.position,
          overlay = _props2.overlay,
          clickableDesktopOverlay = _props2.clickableDesktopOverlay,
          lastChild = _props2.lastChild,
          portal = _props2.portal,
          overlayStyle = _props2.overlayStyle,
          overlayClassName = _props2.overlayClassName,
          propType = _props2.type,
          propVisible = _props2.visible,
          propRenderNode = _props2.renderNode,
          propNavItemsId = _props2.navItemsId,
          propZDepth = _props2.zDepth,
          constantType = _props2.constantType,
          defaultVisible = _props2.defaultVisible,
          defaultMedia = _props2.defaultMedia,
          mobileType = _props2.mobileType,
          mobileMinWidth = _props2.mobileMinWidth,
          tabletType = _props2.tabletType,
          tabletMinWidth = _props2.tabletMinWidth,
          desktopType = _props2.desktopType,
          desktopMinWidth = _props2.desktopMinWidth,
          transitionDuration = _props2.transitionDuration,
          onMediaTypeChange = _props2.onMediaTypeChange,
          onVisibilityChange = _props2.onVisibilityChange,
          autoclose = _props2.autoclose,
          autocloseAfterInk = _props2.autocloseAfterInk,
          onVisibilityToggle = _props2.onVisibilityToggle,
          closeOnNavItemClick = _props2.closeOnNavItemClick,
          props = objectWithoutProperties(_props2, ['id', 'style', 'className', 'navStyle', 'navClassName', 'component', 'navItems', 'header', 'children', 'inline', 'position', 'overlay', 'clickableDesktopOverlay', 'lastChild', 'portal', 'overlayStyle', 'overlayClassName', 'type', 'visible', 'renderNode', 'navItemsId', 'zDepth', 'constantType', 'defaultVisible', 'defaultMedia', 'mobileType', 'mobileMinWidth', 'tabletType', 'tabletMinWidth', 'desktopType', 'desktopMinWidth', 'transitionDuration', 'onMediaTypeChange', 'onVisibilityChange', 'autoclose', 'autocloseAfterInk', 'onVisibilityToggle', 'closeOnNavItemClick']);
      var _props3 = this.props,
          navItemsId = _props3.navItemsId,
          zDepth = _props3.zDepth;

      if (!navItemsId && id) {
        navItemsId = id + '-nav-items';
      }

      var desktop = this.state.desktop;

      var renderNode = getField(this.props, this.context, 'renderNode');
      var type = getField(this.props, this.state, 'type');
      var visible = getField(this.props, this.state, 'visible');
      var mini = isMini(type);
      var temporary = isTemporary(type);
      var floating = DrawerTypes.FLOATING === type;
      var permanent = isPermanent(type);

      var Component$$1 = void 0;
      if (component) {
        Component$$1 = component;
      } else if (navItems) {
        Component$$1 = 'nav';
      } else {
        Component$$1 = 'aside';
      }

      var navigation = void 0;
      if (navItems) {
        navigation = React.createElement(
          List,
          {
            ref: this._setNavigation,
            key: 'navigation',
            id: navItemsId,
            style: navStyle,
            className: classnames('md-list--drawer', {
              'md-toolbar-relative': mini && !visible,
              'md-background': floating
            }, navClassName),
            onClick: this._handleNavClick
          },
          navItems.map(mapToListParts)
        );
      }

      if (typeof zDepth === 'undefined') {
        zDepth = 1;
        if (floating || inline) {
          zDepth = 0;
        } else if (!mini && temporary) {
          zDepth = 5;
        }
      }

      var overlayVisible = overlay;
      if (typeof overlayVisible !== 'boolean') {
        overlayVisible = temporary && !mini && (!desktop || clickableDesktopOverlay) && (animating || visible);
      }

      var drawer = React.createElement(
        Paper,
        _extends({}, props, {
          id: id,
          key: 'drawer',
          component: Component$$1,
          zDepth: zDepth,
          raiseOnHover: false,
          style: style,
          className: classnames('md-drawer', (_cn = {}, defineProperty(_cn, 'md-drawer--' + position, !inline), defineProperty(_cn, 'md-drawer--fixed', !inline), defineProperty(_cn, 'md-drawer--inline', inline), defineProperty(_cn, 'md-drawer--active', mini || drawerActive), defineProperty(_cn, 'md-drawer--mini', mini), defineProperty(_cn, 'md-transition--deceleration', !mini && !permanent && visible), defineProperty(_cn, 'md-transition--acceleration', !mini && !permanent && !visible), defineProperty(_cn, 'md-background', inline || floating), defineProperty(_cn, 'md-background--card', !floating && !inline), _cn), className)
        }),
        header,
        navigation,
        children,
        React.createElement(Overlay, {
          style: overlayStyle,
          className: overlayClassName,
          active: overlayActive,
          onClick: this._closeDrawer,
          visible: overlayVisible,
          renderNode: renderNode
        })
      );

      if (inline || permanent) {
        return drawer;
      } else if (!portal) {
        return mini || animating || visible ? drawer : null;
      }

      return React.createElement(
        Portal,
        { visible: animating || visible, renderNode: renderNode, lastChild: lastChild },
        drawer
      );
    }
  }]);
  return Drawer;
}(PureComponent);

Drawer.DrawerTypes = DrawerTypes;
Drawer.propTypes = {
  /**
   * An optional id to provide to the drawer. This is generally a good idea to provide if
   * there are any `navItems` defined.
   *
   * @see {@link #navItemsId}
   */
  id: propTypes.oneOfType([propTypes.number, propTypes.string]),

  /**
   * An optional id to provide to the navItems list. If this is omitted and the `id` prop is
   * defined, it will be defaulted to `${id}-nav-items`.
   */
  navItemsId: propTypes.oneOfType([propTypes.number, propTypes.string]),

  /**
   * An optional style to apply.
   */
  style: propTypes.object,

  /**
   * An optional className to apply.
   */
  className: propTypes.string,

  /**
   * An optional style to apply to the `List` surrounding the `navItems`.
   */
  navStyle: propTypes.object,

  /**
   * An optional className to apply to the `List` surrounding the `navItems`.
   */
  navClassName: propTypes.string,

  /**
   * An optional style to apply to the overlay.
   */
  overlayStyle: propTypes.object,

  /**
   * An optional className to apply to the overlay.
   */
  overlayClassName: propTypes.string,

  /**
   * An optional component to render the drawer in. When this prop is undefined, the drawer
   * will be rendered as a `nav` if the `navItems` prop is defined, otherwise an `aside`.
   */
  component: propTypes.oneOfType([propTypes.func, propTypes.element]),

  /**
   * An optional list of navigation items to display in the drawer. This list can either contain
   * a valid child component for a `List` or an object used to create a `Divider`, `Subheader`,
   * or `ListItem`.
   *
   * - To create a divider in the list, set a `divider` key to `true`. Any other keys will be
   * passed to the `Divider` component.
   * - To create a subheader in the list, set the `subheader` key to `true`. Any other keys will
   * be passed to the `Subheader` component.
   * - To create a list item, just create an object with any normal `ListItem` props.
   */
  navItems: propTypes.arrayOf(propTypes.oneOfType([propTypes.element, propTypes.shape({
    divider: propTypes.bool,
    subheader: propTypes.bool,
    primaryText: propTypes.node
  })])),

  /**
   * Boolean if a temporary drawer should close when a nav item is clicked.
   */
  autoclose: propTypes.bool,

  /**
   * An optional header to display. This _should_ normally be a toolbar.
   */
  header: propTypes.node,

  /**
   * Any additional children to display after the `header` and `navItems`.
   */
  children: propTypes.node,

  /**
   * The drawer type to use when the current device matches the mobile
   * media query.
   */
  mobileType: propTypes.oneOf([Drawer.DrawerTypes.TEMPORARY, Drawer.DrawerTypes.TEMPORARY_MINI]).isRequired,

  /**
   * The min-width to use for the mobile media query.
   */
  mobileMinWidth: propTypes.number.isRequired,

  /**
   * The drawer type to use when the current device matches the tablet
   * media query.
   */
  tabletType: oneOfDrawerTypes.isRequired,

  /**
   * The min-width to use for the tablet media query.
   */
  tabletMinWidth: propTypes.number.isRequired,

  /**
   * The drawer type to use when the current device matches the desktop media
   * query.
   */
  desktopType: oneOfDrawerTypes.isRequired,

  /**
   * The min-width for a desktop screen.
   */
  desktopMinWidth: propTypes.number.isRequired,

  /**
   * An optional type to enforce across all media sizes. Since `mobile` devices are
   * included, you are required to manually specify when the `type` should be `temporary`.
   *
   * When the `type` is not one of the `temporary` types, the `onMediaTypeChange` prop
   * must be provided.
   */
  type: function type(props, propName, component) {
    for (var _len = arguments.length, others = Array(_len > 3 ? _len - 3 : 0), _key = 3; _key < _len; _key++) {
      others[_key - 3] = arguments[_key];
    }

    var type = props[propName];
    if (isTemporary(type)) {
      return oneOfDrawerTypes.apply(undefined, [props, propName, component].concat(others));
    }

    var err = oneOfDrawerTypes.apply(undefined, [props, propName, component].concat(others));
    if (!err && typeof type !== 'undefined' && !isMini(type) && typeof props.onMediaTypeChange === 'undefined') {
      err = new Error('You provided a `' + propName + '` prop to the ' + component + ' without the `onMediaTypeChange` ' + ('handler. The `onMediaTypeChange` prop must be specified when the `' + propName + '` is not ') + 'one of the `temporary` types.');
    }

    return err;
  },

  /**
   * An optional function to call when the drawer's type changes when the screen resizes.
   * The callback will include the new `type` that should be used for the screen size,
   * and an object containing the media matches for `mobile`, `tablet`, and `desktop`.
   *
   * ```js
   * this.props.onMediaTypeChange(Drawer.DrawerTypes.TEMPORARY, {
   *   mobile: true,
   *   tablet: false,
   *   desktop: false,
   * });
   * ```
   */
  onMediaTypeChange: propTypes.func,

  /**
   * The default drawer type to display on initial render. The drawer will automatically
   * adjust itself to the correct media once it has mounted. This prop is really only useful
   * for server side rendering.
   */
  defaultMedia: propTypes.oneOf(['mobile', 'tablet', 'desktop']).isRequired,

  /**
   * Boolean if there should be a visible overlay when the drawer is visible. The default behavior
   * is to only include a visible overlay when the `type` is `TEMPORARY` or `TEMPORARY_MINI` and
   * the device is not a desktop.
   *
   * Definining this variable as `true` or `false` will override any default behavior. This means that
   * if this is enabled for a full-height drawer, an overlay will still be created.
   */
  overlay: propTypes.bool,

  /**
   * Boolean if the Portal's functionality of rendering in a separate react tree should be applied
   * to the drawer. The overlay that appears for temporary type drawers will still appear in the
   * separate subtree.
   *
   * @see {@link Helpers/Portal}
   */
  portal: propTypes.bool,

  /**
   * An optional DOM Node to render the drawer into. The default is to render as
   * the first child in the `body`.
   *
   * > This prop will not be used when the drawer is of the permanent type or `inline` is specified
   * since the `Portal` component will not be used.
   */
  renderNode: propTypes.object,

  /**
   * Boolean if the drawer should be rendered as the last child instead of the first child
   * in the `renderNode` or `body`.
   *
   * > This prop will not be used when the drawer is of the permanent type or `inline` is specified
   * since the `Portal` component will not be used.
   */
  lastChild: propTypes.bool,

  /**
   * Boolean if the drawer is visible by default. If this is omitted, the drawer will be visible
   * if the current drawer type is NOT `Drawer.DrawerTypes.TEMPORARY` or `Drawer.DrawerTypes.TEMPORARY_MINI`.
   *
   * This basically means that if you are using the default configuration, a mobile device's drawer
   * will be hidden while tablets and desktops will be visible.
   */
  defaultVisible: propTypes.bool,

  /**
   * Boolean if the drawer is visible. This will force the component to define the `onVisibilityChange`
   * prop as well as manually updating the drawer's visibility.
   */
  visible: controlled(propTypes.bool, 'onVisibilityChange', 'defaultVisible'),

  /**
   * An optional function to call when the visibility of the drawer is changed. The function will
   * be called with the new visibility state.
   *
   * ```js
   * onVisibilityChange(!currentlyVisible);
   * ```
   */
  onVisibilityChange: propTypes.func,

  /**
   * The drawer's position on the page when it is not `inline`. When the drawer's position is `left`,
   * the width will be `calc(100vw - 56px)` on mobile devices and `$md-drawer-desktop-width` on desktops.
   *
   * When the position is `right`, the width will be `100vw` for mobile devices and scaling to the drawer's
   * children width on desktops.
   */
  position: propTypes.oneOf(['left', 'right']).isRequired,

  /**
   * Boolean if the drawer should be displayed inline instead of fixed to the page. When this prop
   * is enabled, the `position` prop will not be used.
   */
  inline: propTypes.bool,

  /**
   * The `$md-drawer-transition-time` value from sass.
   */
  transitionDuration: propTypes.number.isRequired,

  /**
   * Boolean if the temporary drawer's overlay should be created on desktop screens. This is really used so that
   * the drawer will close when a user clicks anywhere on the page except in the drawer.
   */
  clickableDesktopOverlay: propTypes.bool,

  /**
   * Boolean if the `autoclose` feature should wait for the ink transition to finish before automatically
   * closing the drawer. This will add a `300ms` delay. If this is `false`, there will only be a `17ms` delay.
   *
   * > The delay is required so that any event listeners will still be correctly invoked when an item is clicked.
   */
  autocloseAfterInk: propTypes.bool,

  /**
   * Boolean if the `type` prop should be constant across all media sizes. This is only valid if the `type` is
   * one of the temporary types.
   *
   * This will basically mean that when attempting to do a media adjustment, it will use the `type` prop instead of
   * `mobileType`, `tabletType`, and `desktopType` to determine the next drawer type.
   */
  constantType: propTypes.bool.isRequired,

  /**
   * An optional zDepth to apply to the drawer. If this is omitted, the value will be set as follows:
   * - floating || inline = 1
   * - temporary = 5
   * - all others = 1
   *
   * @see {@link Papers/Paper#zDepth}
   */
  zDepth: propTypes.number,

  closeOnNavItemClick: deprecated(propTypes.bool, 'Use `autoclose` instead'),
  onVisibilityToggle: deprecated(propTypes.func, 'Use `onVisibilityChange` instead')
};
Drawer.defaultProps = {
  defaultMedia: 'mobile',
  mobileType: Drawer.DrawerTypes.TEMPORARY,
  mobileMinWidth: MOBILE_MIN_WIDTH,
  tabletType: Drawer.DrawerTypes.PERSISTENT,
  tabletMinWidth: TABLET_MIN_WIDTH,
  desktopType: Drawer.DrawerTypes.FULL_HEIGHT,
  desktopMinWidth: DESKTOP_MIN_WIDTH,
  position: 'left',
  transitionDuration: 300,
  autoclose: true,
  clickableDesktopOverlay: true,
  constantType: true
};
Drawer.contextTypes = {
  renderNode: propTypes.object
};

var _initialiseProps$13 = function _initialiseProps() {
  var _this2 = this;

  this._updateType = function (props) {
    var onMediaTypeChange = props.onMediaTypeChange,
        overlay = props.overlay,
        transitionDuration = props.transitionDuration;


    var onVisibilityChange = props.onVisibilityToggle || props.onVisibilityChange;

    var state = Drawer.getCurrentMedia(props);
    var diffType = getField(props, _this2.state, 'type') !== state.type;
    var diffMedia = state.mobile !== _this2.state.mobile || state.tablet !== _this2.state.tablet || state.desktop !== _this2.state.desktop;

    if (onMediaTypeChange && (diffType || diffMedia)) {
      onMediaTypeChange(state.type, { mobile: state.mobile, tablet: state.tablet, desktop: state.desktop });
    }

    if (diffType) {
      var visible = isPermanent(state.type);
      if (_this2._initialFix) {
        if (props.defaultVisible) {
          visible = props.defaultVisible;
        } else if (props.visible) {
          visible = props.visible;
        }
      }

      var prevVisible = getField(props, _this2.state, 'visible');
      if (onVisibilityChange && visible !== prevVisible) {
        onVisibilityChange(visible);
      }

      if (typeof props.visible === 'undefined') {
        state.visible = visible;
        _this2._animate(visible, state.type, transitionDuration, overlay, state.desktop);
      }
    } else if (_this2._initialFix && diffMedia) {
      state.overlayActive = (typeof overlay !== 'undefined' ? overlay : isTemporary(state.type) && !state.desktop) && getField(props, _this2.state, 'visible');
    }

    if (typeof props.type !== 'undefined') {
      var _state2 = state,
          type = _state2.type,
          realState = objectWithoutProperties(_state2, ['type']); // eslint-disable-line no-unused-vars

      state = realState;
    }

    _this2._initialFix = false;
    _this2.setState(state);
  };

  this._updateMedia = function () {
    _this2._updateType(_this2.props);
  };

  this._animate = function (visible, type, timeout, overlay, desktop) {
    if (_this2._timeout) {
      clearTimeout(_this2._timeout);
    }

    if (visible) {
      _this2._timeout = setTimeout(function () {
        _this2._timeout = null;

        _this2.setState({
          overlayActive: overlay || isTemporary(type) && !desktop,
          drawerActive: true,
          animating: true
        });
      }, TICK);
    } else {
      _this2._timeout = setTimeout(function () {
        _this2._timeout = null;

        _this2.setState({ animating: false });
      }, timeout);
      _this2.setState({ animating: true, overlayActive: false, drawerActive: false });
    }
  };

  this._setNavigation = function (navigation) {
    _this2._navigation = findDOMNode(navigation);
  };

  this._handleNavClick = function (e) {
    var _props4 = _this2.props,
        closeOnNavItemClick = _props4.closeOnNavItemClick,
        autoclose = _props4.autoclose,
        autocloseAfterInk = _props4.autocloseAfterInk;

    var enabled = typeof closeOnNavItemClick !== 'undefined' ? closeOnNavItemClick : autoclose;
    if (!enabled || !isTemporary(getField(_this2.props, _this2.state, 'type'))) {
      return;
    }

    var target = e.target;

    while (target && _this2._navigation.contains(target)) {
      if (target.classList.contains('md-list-tile')) {
        // Clicked a nav item that has a nested list
        if (target.getAttribute('aria-expanded') !== null) {
          return;
        }

        _this2._closeTimeout = setTimeout(function () {
          _this2._closeTimeout = null;

          _this2._closeDrawer(e);
        }, autocloseAfterInk ? 300 : TICK);
        return;
      }

      target = target.parentNode;
    }
  };

  this._closeDrawer = function () {
    var _props5 = _this2.props,
        onVisibilityChange = _props5.onVisibilityChange,
        onVisibilityToggle = _props5.onVisibilityToggle,
        transitionDuration = _props5.transitionDuration,
        overlay = _props5.overlay;

    var callback = onVisibilityToggle || onVisibilityChange;
    if (callback) {
      callback(false);
    }

    if (typeof _this2.props.visible === 'undefined') {
      _this2.setState({ visible: false });
      _this2._animate(false, getField(_this2.props, _this2.state, 'type'), transitionDuration, overlay, _this2.state.desktop);
    }
  };
};

/**
 * The `PanelContent` component is for displaying the expanded content
 * for an `ExpansionPanel`. It will display any children in a `md-panel-content`
 * container followed by a `Divider` and the `PanelControls` .
 */

var PanelContent = function (_PureComponent) {
  inherits(PanelContent, _PureComponent);

  function PanelContent() {
    classCallCheck(this, PanelContent);
    return possibleConstructorReturn(this, (PanelContent.__proto__ || Object.getPrototypeOf(PanelContent)).apply(this, arguments));
  }

  createClass(PanelContent, [{
    key: 'render',
    value: function render() {
      var _props = this.props,
          style = _props.style,
          footerStyle = _props.footerStyle,
          footerClassName = _props.footerClassName,
          contentStyle = _props.contentStyle,
          className = _props.className,
          children = _props.children,
          onSave = _props.onSave,
          onCancel = _props.onCancel,
          saveProps = _props.saveProps,
          saveType = _props.saveType,
          saveLabel = _props.saveLabel,
          savePrimary = _props.savePrimary,
          saveSecondary = _props.saveSecondary,
          cancelProps = _props.cancelProps,
          cancelType = _props.cancelType,
          cancelLabel = _props.cancelLabel,
          cancelPrimary = _props.cancelPrimary,
          cancelSecondary = _props.cancelSecondary,
          footer = _props.footer,
          footerChildren = _props.footerChildren;


      var actions = [_extends({
        type: cancelType,
        label: cancelLabel,
        primary: cancelPrimary,
        secondary: cancelSecondary
      }, cancelProps, {
        onClick: onCancel
      }), _extends({
        type: saveType,
        label: saveLabel,
        primary: savePrimary,
        secondary: saveSecondary
      }, saveProps, {
        onClick: onSave
      })];

      var actionFooter = null;
      if (typeof footer === 'undefined') {
        actionFooter = React.createElement(
          DialogFooter,
          {
            actions: actions,
            style: footerStyle,
            className: classnames('md-divider-border md-divider-border--top', footerClassName)
          },
          footerChildren
        );
      } else if (footer !== null) {
        actionFooter = footer;
      }

      return React.createElement(
        'div',
        { style: style },
        React.createElement(
          'div',
          { className: classnames('md-panel-content', className), style: contentStyle },
          children
        ),
        actionFooter
      );
    }
  }]);
  return PanelContent;
}(PureComponent);

PanelContent.propTypes = {
  style: propTypes.object,
  className: propTypes.string,
  footerStyle: propTypes.object,
  footerClassName: propTypes.string,
  contentStyle: propTypes.object,
  children: propTypes.node,
  onSave: propTypes.func.isRequired,
  onCancel: propTypes.func.isRequired,
  saveProps: propTypes.object,
  saveType: propTypes.string,
  saveLabel: propTypes.node.isRequired,
  savePrimary: propTypes.bool,
  saveSecondary: propTypes.bool,
  cancelProps: propTypes.object,
  cancelType: propTypes.string,
  cancelLabel: propTypes.node.isRequired,
  cancelPrimary: propTypes.bool,
  cancelSecondary: propTypes.bool,
  footer: propTypes.node,
  footerChildren: propTypes.node
};

var LABEL_FONT_SIZE = 15;
var LINE_HEIGHT = 1.42857;
var SINGLE_LINE_HEIGHT = LABEL_FONT_SIZE * LINE_HEIGHT;

/**
 * The `ExpansionPanel` component needs to be used with the `ExpansionList`
 * component. The only reason is that the `ExpansionPanel` should really
 * be rendered as a table, but it was a bit hard to have a single component
 * dynamically rendering another row when expanded. It couldn't be in the
 * same row since the expanded content might not have the same columns.
 */

var ExpansionPanel = function (_PureComponent) {
  inherits(ExpansionPanel, _PureComponent);

  function ExpansionPanel(props, context) {
    classCallCheck(this, ExpansionPanel);

    var _this = possibleConstructorReturn(this, (ExpansionPanel.__proto__ || Object.getPrototypeOf(ExpansionPanel)).call(this, props, context));

    _this._determineIfTwoLine = function () {
      var twoLine = false;
      Array.prototype.slice.call(findDOMNode(_this).querySelectorAll('.md-panel-column')).some(function (el) {
        return twoLine = el.offsetHeight > SINGLE_LINE_HEIGHT;
      });

      _this.setState({ twoLine: twoLine });
    };

    _this._handleClick = function () {
      var expanded = !_this._isExpanded(_this.props, _this.state);
      if (_this.props.onExpandToggle) {
        _this.props.onExpandToggle(expanded);
      }

      if (typeof _this.props.expanded === 'undefined') {
        _this.setState({ expanded: expanded });
      }
    };

    _this._handleSave = function (e) {
      var _this$props = _this.props,
          onSave = _this$props.onSave,
          onExpandToggle = _this$props.onExpandToggle,
          closeOnSave = _this$props.closeOnSave;

      if (onSave) {
        onSave(e);
      }

      if (closeOnSave) {
        if (onExpandToggle) {
          onExpandToggle(false);
        }

        if (typeof _this.props.expanded === 'undefined') {
          _this.setState({ expanded: false });
        }
      }
    };

    _this._handleCancel = function (e) {
      var _this$props2 = _this.props,
          onCancel = _this$props2.onCancel,
          onExpandToggle = _this$props2.onExpandToggle,
          closeOnCancel = _this$props2.closeOnCancel;

      if (onCancel) {
        onCancel(e);
      }

      if (closeOnCancel) {
        if (onExpandToggle) {
          onExpandToggle(false);
        }

        if (typeof _this.props.expanded === 'undefined') {
          _this.setState({ expanded: false });
        }
      }
    };

    _this.state = {
      received: false,
      twoLine: false
    };

    if (typeof props.expanded === 'undefined') {
      _this.state.expanded = props.defaultExpanded;
    }
    return _this;
  }

  createClass(ExpansionPanel, [{
    key: 'componentDidMount',
    value: function componentDidMount() {
      this._determineIfTwoLine();
    }
  }, {
    key: 'componentWillReceiveProps',
    value: function componentWillReceiveProps(nextProps) {
      if (process.env.NODE_ENV === 'development' && !this.state.received) {
        if (nextProps.columnWidths.length === 0) {
          // Hopefully a nice warning about fixing the missing props injected from ExpansionList
          /* eslint-disable no-console */
          console.error('The `ExpansionPanel` component expects the `columnWidths` prop to be injected from the ' + '`ExpansionList` component. It could be missing because:' + '\n - you have a wrapper component with extra functionality' + '\n - the `ExpansionPanel` is not a direct child of the `ExpansionList` component' + '\n\nYou can fix this by making sure to pass `this.props.focused` and `this.props.columnWidths` ' + 'within your wrapper component and making the `ExpansionPanel` a direct child of `ExpansionList`.');
        }

        this.setState({ received: true });
      }
    }
  }, {
    key: 'componentDidUpdate',
    value: function componentDidUpdate(prevProps) {
      if (this.props.label === prevProps.label && this.props.secondaryLabel === prevProps.secondaryLabel) {
        return;
      }

      this._determineIfTwoLine();
    }
  }, {
    key: '_isExpanded',
    value: function _isExpanded(props, state) {
      return typeof props.expanded === 'undefined' ? state.expanded : props.expanded;
    }
  }, {
    key: 'render',
    value: function render() {
      var _props = this.props,
          className = _props.className,
          label = _props.label,
          secondaryLabel = _props.secondaryLabel,
          expandedSecondaryLabel = _props.expandedSecondaryLabel,
          children = _props.children,
          focused = _props.focused,
          columnWidths = _props.columnWidths,
          saveType = _props.saveType,
          saveLabel = _props.saveLabel,
          savePrimary = _props.savePrimary,
          saveSecondary = _props.saveSecondary,
          saveProps = _props.saveProps,
          cancelType = _props.cancelType,
          cancelLabel = _props.cancelLabel,
          cancelPrimary = _props.cancelPrimary,
          cancelSecondary = _props.cancelSecondary,
          cancelProps = _props.cancelProps,
          headerStyle = _props.headerStyle,
          headerClassName = _props.headerClassName,
          contentStyle = _props.contentStyle,
          contentClassName = _props.contentClassName,
          tabIndex = _props.tabIndex,
          overflown = _props.overflown,
          footer = _props.footer,
          footerChildren = _props.footerChildren,
          footerStyle = _props.footerStyle,
          footerClassName = _props.footerClassName,
          expandIconChildren = _props.expandIconChildren,
          expandIconClassName = _props.expandIconClassName,
          propAnimateContent = _props.animateContent,
          propExpanded = _props.expanded,
          propExpanderIcon = _props.expanderIcon,
          defaultExpanded = _props.defaultExpanded,
          closeOnSave = _props.closeOnSave,
          closeOnCancel = _props.closeOnCancel,
          onSave = _props.onSave,
          onCancel = _props.onCancel,
          onExpandToggle = _props.onExpandToggle,
          props = objectWithoutProperties(_props, ['className', 'label', 'secondaryLabel', 'expandedSecondaryLabel', 'children', 'focused', 'columnWidths', 'saveType', 'saveLabel', 'savePrimary', 'saveSecondary', 'saveProps', 'cancelType', 'cancelLabel', 'cancelPrimary', 'cancelSecondary', 'cancelProps', 'headerStyle', 'headerClassName', 'contentStyle', 'contentClassName', 'tabIndex', 'overflown', 'footer', 'footerChildren', 'footerStyle', 'footerClassName', 'expandIconChildren', 'expandIconClassName', 'animateContent', 'expanded', 'expanderIcon', 'defaultExpanded', 'closeOnSave', 'closeOnCancel', 'onSave', 'onCancel', 'onExpandToggle']);
      var twoLine = this.state.twoLine;

      var expanded = this._isExpanded(this.props, this.state);
      var animateContent = getField(this.props, this.context, 'animateContent');

      var columns = Children.map(expanded && expandedSecondaryLabel || secondaryLabel, function (panelLabel, i) {
        return React.createElement(
          'div',
          {
            style: defineProperty({}, '' + (overflown ? 'width' : 'minWidth'), columnWidths[i + 1]),
            className: classnames('md-panel-column', {
              'md-panel-column--overflown': overflown
            }, themeColors({ text: true }))
          },
          panelLabel
        );
      });

      if (!Array.isArray(columns)) {
        columns = [columns];
      }

      columns.unshift(React.createElement(
        'div',
        {
          key: 'main-label',
          style: { minWidth: columnWidths[0] },
          className: classnames('md-panel-column', themeColors({ text: true }))
        },
        label
      ));

      var expanderIcon = getDeprecatedIcon(expandIconClassName, expandIconChildren, this.props.expanderIcon);
      expanderIcon = React.Children.only(expanderIcon);
      expanderIcon = React.cloneElement(expanderIcon, {
        className: getCollapserStyles({
          flipped: expanded
        }, 'md-expansion-panel__collapser md-cell--right', expanderIcon.props.className)
      });

      return React.createElement(
        Paper,
        _extends({}, props, {
          className: classnames('md-expansion-panel', {
            'md-expansion-panel--expanded': expanded
          }, className),
          'aria-expanded': expanded
        }),
        React.createElement(
          AccessibleFakeButton,
          {
            onClick: this._handleClick,
            style: headerStyle,
            className: classnames('md-panel-header', {
              'md-panel-header--expanded': expanded || twoLine,
              'md-panel-header--focused': focused
            }, headerClassName),
            tabIndex: tabIndex
          },
          columns,
          expanderIcon
        ),
        React.createElement(
          Collapse,
          { collapsed: !expanded, animate: animateContent },
          React.createElement(
            PanelContent,
            {
              style: contentStyle,
              className: contentClassName,
              footerStyle: footerStyle,
              footerClassName: footerClassName,
              onSave: this._handleSave,
              onCancel: this._handleCancel,
              saveType: saveType,
              saveLabel: saveLabel,
              savePrimary: savePrimary,
              saveSecondary: saveSecondary,
              saveProps: saveProps,
              cancelType: cancelType,
              cancelLabel: cancelLabel,
              cancelPrimary: cancelPrimary,
              cancelSecondary: cancelSecondary,
              cancelProps: cancelProps,
              footer: footer,
              footerChildren: footerChildren
            },
            children
          )
        )
      );
    }
  }]);
  return ExpansionPanel;
}(PureComponent);

ExpansionPanel.propTypes = {
  /**
   * An optional style to apply to the panel.
   */
  style: propTypes.object,

  /**
   * An optional className to apply to the panel.
   */
  className: propTypes.string,

  /**
   * An options style to apply to the panel's header content. This is the
   * section that toggles the children to be visible and label columns.
   */
  headerStyle: propTypes.object,

  /**
   * An optional className to apply to the panel's header content. This is the
   * section that toggles the children to be visible and label columns.
   */
  headerClassName: propTypes.string,

  /**
   * An optional style to apply to the element surrounding the children when expanded.
   */
  contentStyle: propTypes.object,

  /**
   * An optional className to apply to the element surrounding the children when expanded.
   */
  contentClassName: propTypes.string,

  /**
   * An optional style to apply to the footer when the `footer` prop is `undefined`.
   *
   * @see {@link #footer}
   */
  footerStyle: propTypes.object,

  /**
   * An optional className to apply to the footer when the `footer` prop is `undefined`.
   *
   * @see {@link #footer}
   */
  footerClassName: propTypes.string,

  /**
   * The main label to display in the unexpanded panel.
   */
  label: propTypes.node.isRequired,

  /**
   * Any additional columns to display after the main label. If this is a `list`
   * instead of a singular item, they will each be formatted as a column.
   */
  secondaryLabel: propTypes.node,

  /**
   * Any additional columns to display after the main label when the panel is
   * expanded. If this is omitted, the default `secondaryLabel` will be displayed
   * instead.
   */
  expandedSecondaryLabel: propTypes.node,

  /**
   * The component to render the panel as.
   */
  component: propTypes.oneOfType([propTypes.string, propTypes.func]).isRequired,

  /**
   * The content to display once the panel is toggled open.
   */
  children: propTypes.node,

  /**
   * A boolean if the panel is currently expanded. This will force the component
   * to be controlled and require's the `onExpandToggle` function to be defined.
   */
  expanded: controlled(propTypes.bool, 'onExpandToggle', 'defaultExpanded'),

  /**
   * Boolean if an uncontrolled panel should be expanded by default.
   */
  defaultExpanded: propTypes.bool.isRequired,

  /**
   * The icon to display for expanding the expansion panel.
   */
  expanderIcon: propTypes.element,

  /**
   * Boolean if the `ExpansionPanel` is currently tab focused. This is injected
   * and managed by the `ExpansionList` component. Do not set yourself.
   */
  focused: propTypes.bool.isRequired,

  /**
   * A list of min-widths to apply to each column in the panel header. This is injected
   * and managed by the `ExpansionList` component. Do not set yourself.
   */
  columnWidths: propTypes.arrayOf(propTypes.number).isRequired,

  /**
   * Boolean if the panel has too much content so that it overflowns. This is injected
   * and managed by the `ExpansionList` component. Do not set yourself.
   *
   * When this is active, it will truncate all columns except for the main label and the
   * toggle icon.
   */
  overflown: propTypes.bool,

  /**
   * A function to call when the expansion panel's expanded state is toggled.
   * The callback for this function will include the new expanded state.
   *
   * `onExpandToggle(expanded)`
   */
  onExpandToggle: propTypes.func,

  /**
   * An optional function to call when the Save button is clicked on the expanded panel.
   */
  onSave: propTypes.func,

  /**
   * An optional function to call when the Cancel button is clicked on the expanded panel.
   */
  onCancel: propTypes.func,

  /**
   * Boolean if the panel should close when the Save button is clicked.
   */
  closeOnSave: propTypes.bool,

  /**
   * Boolean if the panel should close when the Cancel button is clicked.
   */
  closeOnCancel: propTypes.bool,

  /**
   * An optional button type to apply to the Save button. This will get
   * passed to the `FlatButton`.
   */
  saveType: propTypes.oneOf(['button', 'submit', 'reset']),

  /**
   * The label for the Save button.
   */
  saveLabel: propTypes.node.isRequired,

  /**
   * Boolean if the Save button should be styled with the primary color.
   */
  savePrimary: propTypes.bool,

  /**
   * Boolean if the Save button should be styled with the secondary color,
   */
  saveSecondary: propTypes.bool,

  /**
   * Any additional props to provide/override for the save button in the
   * footer of the panel.
   */
  saveProps: propTypes.object,

  /**
   * An optional button type to apply to the Cancel button. This will get
   * passed to the `FlatButton`.
   */
  cancelType: propTypes.oneOf(['button', 'submit', 'reset']),

  /**
   * The label for the Cancel button.
   */
  cancelLabel: propTypes.node.isRequired,

  /**
   * Boolean if the Cancel button should be styled with the primary color,
   */
  cancelPrimary: propTypes.bool,

  /**
   * Boolean if the Cancel button should be styled with the secondary color,
   */
  cancelSecondary: propTypes.bool,

  /**
   * Any additional props to provide/override for the cancel button in the
   * footer of the panel.
   */
  cancelProps: propTypes.object,

  /**
   * The tab index for the panel's header. This allows keyboard navigation.
   */
  tabIndex: propTypes.number.isRequired,

  /**
   * Boolean if the panel's content should animate when the content's visibility changes. This
   * can also be toggled from the `ExpansionList` component if all `ExpansionPanel` in the list
   * should not animate. This only affects the height transition.
   *
   * > The default value is really `true` since it gets passed down to the `Collapse` component.
   */
  animateContent: propTypes.bool,

  /**
   * This prop controls the footer for the expansion panel. If this prop is `undefined`, it will
   * go with the default behavior of generating the save and cancel buttons with the save and cancel
   * props.
   *
   * If this value is `null`, there will be no footer created.
   *
   * Finally, if this prop is defined as any renderable item, it will be displayed in place of the
   * footer.
   *
   * @see {@link #footerChildren}
   */
  footer: propTypes.node,

  /**
   * Any additional children that should be displayed in the footer of the panel. These children
   * will be placed after the action buttons.
   */
  footerChildren: propTypes.node,
  expandIconChildren: deprecated(propTypes.node, 'Use the `expanderIcon` instead'),
  expandIconClassName: deprecated(propTypes.string, 'Use the `expanderIcon` instead')
};
ExpansionPanel.defaultProps = {
  defaultExpanded: false,
  expanderIcon: React.createElement(
    FontIcon,
    null,
    'keyboard_arrow_down'
  ),
  component: 'li',
  saveLabel: 'Save',
  cancelLabel: 'Cancel',
  savePrimary: true,
  tabIndex: 0,
  closeOnSave: true,
  closeOnCancel: true,
  focused: false,
  columnWidths: []
};
ExpansionPanel.contextTypes = {
  animateContent: propTypes.bool
};

/**
 * The `ExpansionList` component is a wrapper for the `ExpansionPanel` that helps
 * determine which `ExpansionPanel` currently has tab focus and adjusts the column
 * sizes in the header of the `ExpansionPanel`.
 *
 * The `ExpansionList` and `ExpansionPanel` components should have probably been
 * implemented as a `table` instead of a `ul || ol` since it is more column based,
 * but it would complicate the API to have dynamic row generation for the expanded
 * panels. The expanded panels _might_ not follow the same column widths as their labels
 * so a singular row with a div for expanded content might not work correctly.
 */

var ExpansionList = function (_PureComponent) {
  inherits(ExpansionList, _PureComponent);

  function ExpansionList() {
    var _ref;

    var _temp, _this, _ret;

    classCallCheck(this, ExpansionList);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = possibleConstructorReturn(this, (_ref = ExpansionList.__proto__ || Object.getPrototypeOf(ExpansionList)).call.apply(_ref, [this].concat(args))), _this), _this.state = { columnWidths: [], focusedIndex: -1, overflown: false }, _this._setContainer = function (container) {
      if (container !== null) {
        _this._container = findDOMNode(container);
        window.addEventListener('keyup', _this._determineTabFocus);

        _this._width = _this._container.offsetWidth;
        _this._calcColumnWidths();
      }
    }, _this._determineTabFocus = function (e) {
      if ((e.which || e.keyCode) === TAB) {
        var panels = Array.prototype.slice.call(findDOMNode(_this).querySelectorAll('.md-panel-header'));
        _this.setState({ focusedIndex: panels.indexOf(e.target) });
      }
    }, _this._removeFocus = function () {
      _this.setState({ focusedIndex: -1 });
    }, _this._isOverflown = function (widths) {
      if (!_this._container) {
        return false;
      }

      var panel = _this._container.querySelector('.md-panel-header');
      if (!panel) {
        return false;
      }

      var collapser = _this._container.querySelector('.md-expansion-panel__collapser');
      var collapserWidth = collapser ? collapser.offsetWidth : 0;
      var styles = window.getComputedStyle(panel);
      var maxWidth = panel.offsetWidth - parseFloat(styles.paddingLeft) - parseFloat(styles.paddingRight) - collapserWidth;

      var totalWidth = widths.reduce(function (total, w) {
        return total + w;
      }, 0);
      return totalWidth > maxWidth;
    }, _this._getColumnWidths = function () {
      if (!_this._container) {
        return _this.state.columnWidths;
      }

      return [].slice.call(_this._container.querySelectorAll('.md-panel-header')).reduce(function (maxes, row) {
        var columns = row.querySelectorAll('.md-panel-column');
        for (var i = 0; i < columns.length; i++) {
          var col = columns[i];
          // Need to reset the widths if it has already been calculated to get a more accurate measurement.
          var _col$style = col.style,
              width = _col$style.width,
              minWidth = _col$style.minWidth;

          col.style.width = 'auto';
          col.style.minWidth = 'auto';

          // Only need to include the offsetWidth of the column because the child will really
          // determine the width of the column. Since it has already been defined at this point,
          // no additional work needs to be done.
          maxes[i] = Math.max(col.offsetWidth, maxes[i] || 0);
          col.style.width = width;
          col.style.minWidth = minWidth;
        }

        return maxes;
      }, [0]);
    }, _this._calcColumnWidths = function () {
      var columnWidths = _this.state.columnWidths;

      var nextWidths = _this._getColumnWidths();
      var overflown = _this._isOverflown(nextWidths);
      if (_this.state.overflown !== overflown || columnWidths.length !== nextWidths.length || nextWidths.some(function (w, i) {
        return w !== columnWidths[i];
      })) {
        _this.setState({ columnWidths: nextWidths, overflown: overflown });
      }
    }, _this._handleResize = function (_ref2) {
      var width = _ref2.width;
      var recalculateThreshold = _this.props.recalculateThreshold;

      if (_this._width !== width && Math.abs(width - _this._width) >= recalculateThreshold) {
        _this._width = width;
        _this._calcColumnWidths();
      }
    }, _temp), possibleConstructorReturn(_this, _ret);
  }

  createClass(ExpansionList, [{
    key: 'getChildContext',
    value: function getChildContext() {
      var animateContent = this.props.animateContent;

      return { animateContent: animateContent };
    }
  }, {
    key: 'componentWillReceiveProps',
    value: function componentWillReceiveProps(nextProps) {
      if (this.props.children !== nextProps.children) {
        this._calcColumnWidths();
      }
    }
  }, {
    key: 'componentDidUpdate',
    value: function componentDidUpdate(prevProps, prevState) {
      var focusedIndex = this.state.focusedIndex;

      if (prevState.focusedIndex === focusedIndex || prevState.focusedIndex > -1 && focusedIndex > -1) {
        return;
      }

      handleWindowClickListeners(this._removeFocus, this.state.focusedIndex !== -1);
    }
  }, {
    key: 'componentWillUnmount',
    value: function componentWillUnmount() {
      if (this.state.focusedIndex === -1) {
        handleWindowClickListeners(this._removeFocus, false);
      }

      window.removeEventListener('keyup', this._determineTabFocus);
    }

    /**
     * Since this should really be rendered as a table, need to calculate the max width for each _column_
     * on the panel's header and apply that as a min width for the other panels.
     */

  }, {
    key: 'render',
    value: function render() {
      var _state = this.state,
          columnWidths = _state.columnWidths,
          focusedIndex = _state.focusedIndex,
          overflown = _state.overflown;
      var _props = this.props,
          children = _props.children,
          className = _props.className,
          Component$$1 = _props.component,
          animateContent = _props.animateContent,
          recalculateThreshold = _props.recalculateThreshold,
          props = objectWithoutProperties(_props, ['children', 'className', 'component', 'animateContent', 'recalculateThreshold']);


      var panels = Children.map(children, function (child, i) {
        return cloneElement(child, {
          key: child.key || i,
          overflown: overflown,
          columnWidths: columnWidths,
          focused: focusedIndex === i
        });
      });
      return React.createElement(
        Component$$1,
        _extends({}, props, {
          ref: this._setContainer,
          className: classnames('md-expansion-panel-list', className)
        }),
        React.createElement(ResizeObserver$1, { watchWidth: true, onResize: this._handleResize }),
        panels
      );
    }
  }]);
  return ExpansionList;
}(PureComponent);

ExpansionList.propTypes = {
  /**
   * An optional style object to apply to the list.
   */
  style: propTypes.object,

  /**
   * An optional className to apply to the list.
   */
  className: propTypes.string,

  /**
   * The children should be a list or singular `ExpansionPanel` component
   * to render with some additional props injected.
   */
  children: propTypes.node,

  /**
   * The component to render the list as.
   */
  component: propTypes.oneOfType([propTypes.string, propTypes.func]).isRequired,

  /**
   * Boolean if all the expansion panels in the list should animate when their content's visibility
   * changes. This is just a quicker way to disable all animations instead of having to toggle it off
   * on each panel.
   *
   * > The default value is really `true` since it gets passed down to the `Collapse` component.
   */
  animateContent: propTypes.bool,

  /**
   * The threshold that should be used for when the list should recalculate the positioning of all
   * the columns. This will only compare the difference between updates.
   * So if the size changes from 80 -> 120 -> 160 -> 140. It will only update on the third resize (160)
   */
  recalculateThreshold: propTypes.number.isRequired
};
ExpansionList.defaultProps = {
  component: 'ul',
  recalculateThreshold: 80
};
ExpansionList.childContextTypes = {
  animateContent: propTypes.bool
};

/**
 * The `FileInput` component is used as simple styling for the `<input type="file" />`.
 * It will style the input as a raised button by default.
 */

var FileInput = function (_PureComponent) {
  inherits(FileInput, _PureComponent);

  function FileInput() {
    var _ref;

    var _temp, _this, _ret;

    classCallCheck(this, FileInput);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = possibleConstructorReturn(this, (_ref = FileInput.__proto__ || Object.getPrototypeOf(FileInput)).call.apply(_ref, [this].concat(args))), _this), _this.state = { hover: false, pressed: false }, _this._handleChange = function (e) {
      var _this$props = _this.props,
          multiple = _this$props.multiple,
          onChange = _this$props.onChange;
      var files = e.target.files;

      if (onChange) {
        if (!multiple) {
          onChange(files[0] || null, e);
        } else {
          onChange(Array.prototype.slice.call(files), e);
        }
      }
    }, _this._blur = function () {
      if (_this.props.disabled) {
        return;
      }

      if (_this._timeout) {
        _this._attemptedBlur = true;
      } else {
        _this.setState({ pressed: false });
      }
    }, _this._handleMouseUp = function (e) {
      if (_this.props.onMouseUp) {
        _this.props.onMouseUp(e);
      }

      _this._blur();
    }, _this._handleMouseDown = function (e) {
      if (_this.props.onMouseDown) {
        _this.props.onMouseDown(e);
      }

      if (!_this.props.disabled) {
        _this.setState({ pressed: true });
      }
    }, _this._handleTouchStart = function (e) {
      if (_this.props.onTouchStart) {
        _this.props.onTouchStart(e);
      }

      if (!_this.props.disabled) {
        _this.setState({ pressed: true });
      }
    }, _this._handleTouchEnd = function (e) {
      if (_this.props.onTouchEnd) {
        _this.props.onTouchEnd(e);
      }

      _this._blur();
      captureNextEvent('mouseover');
    }, _this._handleKeyUp = function (e) {
      if (_this.props.onKeyUp) {
        _this.props.onKeyUp(e);
      }

      if ((e.which || e.keyCode) === TAB) {
        window.addEventListener('click', _this._blur);
        _this.setState({ pressed: true });
      }
    }, _this._handleKeyDown = function (e) {
      if (_this.props.onKeyDown) {
        _this.props.onKeyDown(e);
      }

      var key = e.which || e.keyCode;

      if (key === TAB) {
        window.removeEventListener('click', _this._blur);
        _this.setState({ pressed: false });
      } else if (key === SPACE || key === ENTER) {
        e.preventDefault();
        e.target.click();
      }
    }, _this._handleMouseOver = function (e) {
      if (_this.props.onMouseOver) {
        _this.props.onMouseOver(e);
      }

      if (!_this.props.disabled) {
        _this.setState({ hover: true });
      }
    }, _this._handleMouseLeave = function (e) {
      if (_this.props.onMouseLeave) {
        _this.props.onMouseLeave(e);
      }

      if (!_this.props.disabled) {
        _this.setState({ hover: false });
      }
    }, _temp), possibleConstructorReturn(_this, _ret);
  }

  createClass(FileInput, [{
    key: 'componentWillReceiveProps',
    value: function componentWillReceiveProps(nextProps) {
      if (this.props.disabled && !nextProps.disabled && this.state.hover) {
        this.setState({ hover: false });
      }
    }
  }, {
    key: 'componentWillUpdate',
    value: function componentWillUpdate(nextProps, nextState) {
      var _this2 = this;

      // I honestly don't remember why this was implemented, but it was copied from the Button
      // component
      if (!this.state.pressed && nextState.pressed) {
        this._timeout = setTimeout(function () {
          _this2._timeout = null;
          if (_this2._attemptedBlur) {
            _this2._attemptedBlur = false;

            _this2.setState({ pressed: false });
          }
        }, 450);
      }
    }
  }, {
    key: 'componentWillUnmount',
    value: function componentWillUnmount() {
      if (this._timeout) {
        clearTimeout(this._timeout);
      }

      window.removeEventListener('click', this._blur);
    }
  }, {
    key: 'render',
    value: function render() {
      var _state = this.state,
          hover = _state.hover,
          pressed = _state.pressed;
      var _props = this.props,
          style = _props.style,
          className = _props.className,
          labelStyle = _props.labelStyle,
          labelClassName = _props.labelClassName,
          label = _props.label,
          primary = _props.primary,
          secondary = _props.secondary,
          flat = _props.flat,
          id = _props.id,
          name = _props.name,
          iconBefore = _props.iconBefore,
          disabled = _props.disabled,
          accept = _props.accept,
          multiple = _props.multiple,
          swapTheming = _props.swapTheming,
          allowDuplicates = _props.allowDuplicates,
          iconChildren = _props.iconChildren,
          iconClassName = _props.iconClassName,
          propIcon = _props.icon,
          onChange = _props.onChange,
          onKeyUp = _props.onKeyUp,
          onKeyDown = _props.onKeyDown,
          onMouseUp = _props.onMouseUp,
          onMouseDown = _props.onMouseDown,
          onMouseOver = _props.onMouseOver,
          onMouseLeave = _props.onMouseLeave,
          onTouchStart = _props.onTouchStart,
          onTouchEnd = _props.onTouchEnd,
          propValue = _props.value,
          props = objectWithoutProperties(_props, ['style', 'className', 'labelStyle', 'labelClassName', 'label', 'primary', 'secondary', 'flat', 'id', 'name', 'iconBefore', 'disabled', 'accept', 'multiple', 'swapTheming', 'allowDuplicates', 'iconChildren', 'iconClassName', 'icon', 'onChange', 'onKeyUp', 'onKeyDown', 'onMouseUp', 'onMouseDown', 'onMouseOver', 'onMouseLeave', 'onTouchStart', 'onTouchEnd', 'value']);
      var icon = this.props.icon;

      if (iconClassName || iconChildren) {
        icon = React.createElement(
          FontIcon,
          { iconClassName: iconClassName },
          iconChildren
        );
      }

      var labelChildren = label;
      if (icon) {
        icon = React.cloneElement(icon, { inherit: true });
        labelChildren = React.createElement(
          IconSeparator,
          { label: label, iconBefore: iconBefore },
          icon
        );
      }

      var value = void 0;
      if (allowDuplicates) {
        value = '';
      }

      return React.createElement(
        'div',
        _extends({}, props, {
          style: style,
          className: classnames('md-inline-block md-file-input-container', className)
        }),
        React.createElement(
          AccessibleFakeInkedButton,
          {
            component: 'label',
            htmlFor: id,
            disabled: disabled,
            onTouchStart: this._handleTouchStart,
            onTouchEnd: this._handleTouchEnd,
            onMouseDown: this._handleMouseDown,
            onMouseUp: this._handleMouseUp,
            onKeyDown: this._handleKeyDown,
            onKeyUp: this._handleKeyUp,
            onMouseOver: this._handleMouseOver,
            onMouseLeave: this._handleMouseLeave,
            style: labelStyle,
            className: getBtnStyles({
              flat: flat,
              raised: !flat,
              disabled: disabled,
              primary: primary,
              secondary: secondary,
              hover: hover,
              swapTheming: swapTheming,
              pressed: pressed
            }, labelClassName)
          },
          labelChildren
        ),
        React.createElement('input', {
          id: id,
          name: name,
          accept: accept,
          type: 'file',
          multiple: multiple,
          disabled: disabled,
          'aria-hidden': 'true',
          className: 'md-file-input',
          onChange: this._handleChange,
          value: value,
          tabIndex: -1
        })
      );
    }
  }]);
  return FileInput;
}(PureComponent);

FileInput.propTypes = {
  /**
   * The id for the text field. This is required for a11y and to get the `input type="file"` to
   * open.
   */
  id: isRequiredForA11y(propTypes.oneOfType([propTypes.string, propTypes.number])),

  /**
   * An optional name to provide to the input.
   */
  name: propTypes.string,

  /**
   * An optional style to apply.
   */
  style: propTypes.object,

  /**
   * An optional className to apply.
   */
  className: propTypes.string,

  /**
   * An optional style to apply to the label.
   */
  labelStyle: propTypes.object,

  /**
   * An optional className to apply to the label.
   */
  labelClassName: propTypes.string,

  /**
   * Boolean if the `FileInput` should be styled with the primary color.
   */
  primary: propTypes.bool,

  /**
   * Boolean if the `FileInput` should be styled with the secondary color.
   */
  secondary: propTypes.bool,

  /**
   * Boolean if the `FileInput` should be styled as a flat button instead of a
   * raised button.
   */
  flat: propTypes.bool,

  /**
   * Boolean if the theming should be swapped from text to background or vice-versa.
   *
   * @see {@link Buttons/Button#swapTheming}
   */
  swapTheming: propTypes.bool,

  /**
   * This should be a comma separated list of Media Types that the `FileInput` can
   * accept. If this prop is left blank, any file will be accepted.
   *
   * The values can either be:
   * - A file extension
   * - audio/*
   * - video/*
   * - image/*
   * - any valid [IANA Media Type](http://www.iana.org/assignments/media-types/media-types.xhtml)
   *
   * > NOTE: IE does not enforce this.
   */
  accept: propTypes.string,

  /**
   * Boolean if the same file is allowed to be uploaded multiple times. This will basically make the
   * `value` of the file input always blank.
   */
  allowDuplicates: propTypes.bool,

  /**
   * Boolean if multiple files will be accepted.
   */
  multiple: propTypes.bool,

  /**
   * A label to display on the `FileInput`. This will be used with the `AccessibleFakeInkedButton` component to
   * create a `<label>` for the `<input type="file">`.
   */
  label: propTypes.node,

  /**
   * Boolean if the icons should appear before the label.
   */
  iconBefore: propTypes.bool,

  /**
   * An optional icon to display with the file download. This can be a `FontIcon` or an `SVGIcon`.
   */
  icon: propTypes.element,

  /**
   * A function to call when the value of the input changes. This will
   * be triggered when the user selects a new file or cancels the new file selection.
   *
   * This function will be given the new [FileList](https://developer.mozilla.org/en-US/docs/Web/API/FileList)
   * as an array and the change event. If this is not a multiple file input, only the
   * newly selected File will be given instead of a list of one file. Since this is an
   * `input` tag, the user will not be able to select the same file multiple times unless
   * you manually clear the input's value.
   *
   * > NOTE: If the user hits cancel, null will be given for a single file input.
   *
   * ```js
   * onChange(files, e);
   * ```
   */
  onChange: propTypes.func,

  /**
   * Boolean if the `FileInput` is currently disabled.
   */
  disabled: propTypes.bool,

  /**
   * An optional function to call when they keyup event is triggered on the file input's label.
   */
  onKeyUp: propTypes.func,

  /**
   * An optional function to call when they keydown event is triggered on the file input's label.
   */
  onKeyDown: propTypes.func,

  /**
   * An optional function to call when they mouseup event is triggered on the file input's label.
   */
  onMouseUp: propTypes.func,

  /**
   * An optional function to call when they mousedown event is triggered on the file input's label.
   */
  onMouseDown: propTypes.func,

  /**
   * An optional function to call when they mouseover event is triggered on the file input's label.
   */
  onMouseOver: propTypes.func,

  /**
   * An optional function to call when they mouseleave event is triggered on the file input's label.
   */
  onMouseLeave: propTypes.func,

  /**
   * An optional function to call when they touchend event is triggered on the file input's label.
   */
  onTouchEnd: propTypes.func,

  /**
   * An optional function to call when they touchstart event is triggered on the file input's label.
   */
  onTouchStart: propTypes.func,

  iconChildren: deprecated(propTypes.node, 'Use `icon` instead'),
  iconClassName: deprecated(propTypes.string, 'Use `icon` instead'),
  value: deprecated(propTypes.string, 'There should\'t be a reason to set the value manually. Check out {@link #allowDuplicates} instead')
};
FileInput.defaultProps = {
  label: 'Select a file',
  icon: React.createElement(
    FontIcon,
    null,
    'file_upload'
  ),
  allowDuplicates: false
};

/**
 * The `FileUpload` component is used to upload files locally This is a wrapper of the `FileInput` component
 * with some additional functionality so any props that are undocumented on `FileUpload` but are present
 * on `FileInput` are correctly provided. If you want to upload files to a server, use
 * [FormData](https://developer.mozilla.org/en-US/docs/Web/API/FormData)
 * by attaching the `File`.
 *
 * Quick example:
 *
 * ```js
 * function upload(file) {
 *   fetch('/api/images', {
 *     method: 'POST',
 *     body: new FormData().append('file', file),
 *   });
 * }
 * ```
 *
 * An upload can be aborted by calling the `abort(file || fileName)` function. If
 * the file or fileName are omitted, it will *attempt* to abort the current
 * file that is uploading. Unreliable for multi-select.
 *
 * ```js
 * <FileUpload ref="upload" />
 * <Button raised onClick={() => this.refs.upload.abort()} label="Abort! Abort!" />
 * ```
 */

var FileUpload = function (_PureComponent) {
  inherits(FileUpload, _PureComponent);

  function FileUpload() {
    var _ref;

    var _temp, _this, _ret;

    classCallCheck(this, FileUpload);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = possibleConstructorReturn(this, (_ref = FileUpload.__proto__ || Object.getPrototypeOf(FileUpload)).call.apply(_ref, [this].concat(args))), _this), _this.state = {}, _this.abort = function (file) {
      var fileName = file;
      if (!file) {
        // Attempt to remove first file added...
        fileName = Object.keys(_this.state)[0];
      } else if (typeof file.name === 'string') {
        fileName = file.name;
      }

      var reader = _this.state[fileName];
      if (reader) {
        reader.abort();
        findDOMNode(_this).querySelector('.md-file-input').value = '';

        _this.setState(omit(_this.state, [fileName]));
      }
    }, _this._uploadFile = function (file) {
      var _this$props = _this.props,
          onAbort = _this$props.onAbort,
          onError = _this$props.onError,
          onLoad = _this$props.onLoad,
          onLoadStart = _this$props.onLoadStart,
          onLoadEnd = _this$props.onLoadEnd,
          onProgress = _this$props.onProgress,
          readAs = _this$props.readAs;
      var name = file.name,
          type = file.type;


      var fr = new FileReader();
      if (onError) {
        fr.onerror = function (e) {
          onError(file, e.target.error, e);
        };
      }

      if (onAbort) {
        fr.onabort = function (e) {
          onAbort(file, e);
        };
      }

      if (onLoadStart) {
        fr.onloadstart = function (e) {
          onLoadStart(file, e);
        };
      }

      if (onLoadEnd) {
        fr.onloadend = function (e) {
          onLoadEnd(file, e);
        };
      }

      fr.onload = function (e) {
        if (onLoad) {
          onLoad(file, e.target.result, e);
        }

        _this.setState(omit(_this.state, [name]));
      };

      if (onProgress) {
        fr.onprogress = function (e) {
          if (e.lengthComputable) {
            onProgress(file, e.loaded / e.total * 100, e);
          }
        };
      }

      if (readAs) {
        if (typeof readAs === 'function') {
          readAs(type, file, fr);
        } else {
          fr['readAs' + readAs](file);
        }
      } else if (type.match(/image|video|audio|application\/pdf/) || name.match(/\.mkv$/)) {
        fr.readAsDataURL(file);
      } else if (type.match(/application\/json/)) {
        fr.readAsText(file);
      } else if (type.match(/application|model|multipart/) || name.match(/(w|e)ar$/)) {
        fr.readAsArrayBuffer(file);
      } else {
        fr.readAsText(file);
      }

      return fr;
    }, _this._handleUpload = function (fileList, e) {
      if (_this.props.onChange) {
        _this.props.onChange(fileList, e);
      }

      if (!fileList) {
        return;
      }
      var _this$props2 = _this.props,
          maxSize = _this$props2.maxSize,
          onSizeError = _this$props2.onSizeError;

      var files = Array.isArray(fileList) ? fileList : [fileList];

      var errorFiles = [];
      if (maxSize) {
        errorFiles = files.filter(function (file) {
          return file.size > maxSize;
        });
        files = files.filter(function (file) {
          return file.size <= maxSize;
        });
      }

      if (errorFiles.length) {
        onSizeError(errorFiles);
      }

      if (!files.length) {
        return;
      }

      var nextState = {};
      files.forEach(function (file) {
        var fileReader = _this._uploadFile(file);
        nextState[file.name] = fileReader;
      });

      _this.setState(nextState);
    }, _temp), possibleConstructorReturn(_this, _ret);
  }

  /**
   * Attempts to abort the upload of a file. This function takes an optional `file` or `fileName`
   * as it's parameter. If the parameter is omitted, it attempts to abort the first file that was
   * added. If the `onAbort` function was given, it will be called as well.
   *
   * @param {Object|string} file - The file or the file name to use to find the
   *     correct `FileReader`.
   */


  createClass(FileUpload, [{
    key: 'render',
    value: function render() {
      var _props = this.props,
          maxSize = _props.maxSize,
          readAs = _props.readAs,
          onLoad = _props.onLoad,
          onLoadStart = _props.onLoadStart,
          onLoadEnd = _props.onLoadEnd,
          onProgress = _props.onProgress,
          onAbort = _props.onAbort,
          onError = _props.onError,
          onSizeError = _props.onSizeError,
          props = objectWithoutProperties(_props, ['maxSize', 'readAs', 'onLoad', 'onLoadStart', 'onLoadEnd', 'onProgress', 'onAbort', 'onError', 'onSizeError']);


      return React.createElement(FileInput, _extends({}, props, { onChange: this._handleUpload }));
    }
  }]);
  return FileUpload;
}(PureComponent);

FileUpload.propTypes = {
  /**
   * An optional style to apply.
   */
  style: propTypes.object,

  /**
   * An optional className to apply.
   */
  className: propTypes.string,

  /**
   * An optional style to apply to the label.
   */
  labelStyle: propTypes.object,

  /**
   * An optional className to apply to the label.
   */
  labelClassName: propTypes.string,

  /**
   * Boolean if the `FileInput` should be styled with the primary color.
   */
  primary: propTypes.bool,

  /**
   * Boolean if the `FileInput` should be styled with the secondary color.
   */
  secondary: propTypes.bool,

  /**
   * Boolean if the `FileInput` should be styled as a flat button instead of a
   * raised button.
   */
  flat: propTypes.bool,

  /**
   * This should be a comma separated list of Media Types that the `FileInput` can
   * accept. If this prop is left blank, any file will be accepted.
   *
   * The values can either be:
   * - A file extension
   * - audio/*
   * - video/*
   * - image/*
   * - any valid [IANA Media Type](http://www.iana.org/assignments/media-types/media-types.xhtml)
   */
  accept: propTypes.string,

  /**
   * Boolean if multiple files will be accepted.
   */
  multiple: propTypes.bool,

  /**
   * A label to display on the `FileInput`.
   */
  label: propTypes.node,

  /**
   * The icon children to use for the upload icon.
   */
  iconChildren: propTypes.node,

  /**
   * The icon className to use for the upload icon.
   */
  iconClassName: propTypes.string,

  /**
   * An optional max size for the file. If the file is greater than
   * this limit, the file will not be uploaded.
   */
  maxSize: propTypes.number,

  /**
   * A required function to call when the `maxSize` prop is set. It will
   * be given a list of files that were too big.
   */
  onSizeError: function onSizeError(props, propName, component) {
    for (var _len2 = arguments.length, others = Array(_len2 > 3 ? _len2 - 3 : 0), _key2 = 3; _key2 < _len2; _key2++) {
      others[_key2 - 3] = arguments[_key2];
    }

    if (typeof props.maxSize === 'number') {
      var _PropTypes$func;

      return (_PropTypes$func = propTypes.func).isRequired.apply(_PropTypes$func, [props, propName, component].concat(others));
    }

    return null;
  },

  /**
   * You can force the `FileReader` to read the file as a specific type
   * if you do not trust the *amazing* regex I have for choosing the correct
   * one.
   *
   * ```js
   * if(type.match(/image|video|audio/)) {
   *   fr.readAsDataURL(file);
   * } else if(type.match(/application|model|multipart/)) {
   *   fr.readAsArrayBuffer(file);
   * } else {
   *   fr.readAsText(file);
   * }
   * ```
   *
   * > `.yml` and `.js` both are considered `application`, so it definitely fails there.
   *
   * If this prop is a function, you will be given the file's type, the file object, and
   * the file reader. You will then need to call `fileReader.readAsYOUR_CORRECT_TYPE(file)`.
   */
  readAs: propTypes.oneOfType([propTypes.oneOf(['DataURL', 'ArrayBuffer', 'Text']), propTypes.func]),

  /**
   * An optional function to call when the `FileUpload` aborts. The current
   * file and the abort event are given. This might not be the most useful
   * function to use since you will need to manually call abort yourself anyways.
   */
  onAbort: propTypes.func,

  /**
   * An optional function to call when the `FileUpload` errors. The current
   * file, the error, and the error event are given.
   *
   * ```js
   * onError(file, event.target.error, event);
   * ```
   */
  onError: propTypes.func,

  /**
   * An optional function to call when the `FileUpload` loads. The current
   * file, the load result, and the load event are given.
   *
   * ```js
   * onLoad(file, event.target.result, event);
   * ```
   *
   * The load result will either be:
   * - a data URL
   * - a plain text string
   * - an array buffer
   *
   * depending on what type the file is.
   */
  onLoad: propTypes.func,

  /**
   * An optional function to call when the `FileUpload` starts loading. The current
   * file and the load start event are given.
   */
  onLoadStart: propTypes.func,

  /**
   * An optional function to call when the `FileUpload` finishes loading. The
   * current file and the load end event are given.
   */
  onLoadEnd: propTypes.func,

  /**
   * An optional function to call when the `FileUpload` progress. The current
   * file, upload progress, and the progress event are given. The progress
   * will be a number between 0 and 100 that has not been rounded.
   *
   * ```js
   * onProgress(file, progress, event);
   * ```
   */
  onProgress: propTypes.func,

  /**
   * Boolean if the same file is allowed to be uploaded multiple times. This will basically make the
   * `value` of the file input always blank.
   */
  allowDuplicates: propTypes.bool,

  /**
   * An optional function to call when a file selects or unselects a file.
   * This will be called before any local uploading occurs.
   *
   * ```js
   * onChange(file(s) || null, event);
   * ```
   */
  onChange: propTypes.func,
  value: deprecated(propTypes.string, 'There should\'t be a reason to set the value manually. Check out {@link #allowDuplicates} instead')
};

/** @module utils/bem */
/**
 * A utility function to apply BEM class names to an element.
 *
 * ### Examples:
 * ```js
 * bem('class') === 'class'
 * bem('block', 'element') === 'block__element'
 * bem('block', 'element', 'sub-element') === 'block__element__sub-element'
 * bem('block', { 'mod-1': true, 'mod-2': false }) === 'block block--mod-1'
 * bem('block', 'element', { 'mod-1': false, 'mod-2': true }) === 'block__element block__element--mod-2'
 * bem('block', 'element', {
 *   'mod-1': false,
 *   'mod-2': true,
 * }, 'other', 'class-names') === 'block__element block__element--mod-2 other class-names'
 * ```
 *
 * @param {...String} blocks - 1 to many blocks to use. These names will be joined
 *    with underscores.
 * @param {Object=} modifiers - Any conditional modifiers to apply to the blocks. Each
 *    key in this object will be applied as a `--suffix` to the blocks ONLY when
 *    their value is true-ish.
 * @param {...String} others - Any additional class names to apply.
 * @return {String} the bem-formatted className string.
 */
function bem() {
  var base = [];
  var modifiers = null;
  var remaining = -1;

  for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
    args[_key] = arguments[_key];
  }

  args.some(function (arg, i) {
    if (arg) {
      var type = typeof arg === 'undefined' ? 'undefined' : _typeof(arg);
      if (type === 'number' || type === 'string') {
        base.push(arg);
      } else if (type === 'object') {
        modifiers = arg;
        remaining = i + 1;
      }
    }
    return modifiers;
  });

  var element = base.join('__');
  if (modifiers) {
    modifiers = Object.keys(modifiers).reduce(function (obj, key) {
      obj[element + '--' + key] = modifiers[key];
      return obj;
    }, {});
  }
  var classes = remaining > -1 ? args.slice(remaining) : null;
  return classnames(element, modifiers, classes).trim();
}

var DIFF_KEYS$1 = ['className', 'stacked', 'container', 'noSpacing', 'gutter', 'spacing'];

var Grid = function (_PureComponent) {
  inherits(Grid, _PureComponent);
  createClass(Grid, null, [{
    key: 'getClassName',


    /**
     * A utility function to get the grid's className based on the Grid's props. This is
     * used behind the scenes to merge and create the className for the grid.
     *
     * ### Example:
     * ```js
     * <div className={Grid.getClassName()}>A base grid</div>
     * <div className={Grid.getClassName({ stacked: true })}>A stacked Grid</div>
     * ```
     *
     * @param {Object=} props - This should be an object of the `Grid`'s props. It
     *    will extract the needed keys and generate the className.
     * @return {String} the full className to use for the grid
     */
    value: function getClassName() {
      var _bem;

      var props = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var className = props.className,
          stacked = props.stacked,
          noSpacing = props.noSpacing,
          gutter = props.gutter,
          spacing = props.spacing,
          container = props.container;

      return bem('md-grid', (_bem = {
        'stacked': stacked,
        'no-spacing': noSpacing
      }, defineProperty(_bem, gutter + '-' + spacing, isValued(gutter) && isValued(spacing)), defineProperty(_bem, container, container), _bem), className);
    }
  }]);

  function Grid(props) {
    classCallCheck(this, Grid);

    var _this = possibleConstructorReturn(this, (Grid.__proto__ || Object.getPrototypeOf(Grid)).call(this));

    _this.state = { className: Grid.getClassName(props) };
    return _this;
  }

  createClass(Grid, [{
    key: 'componentWillMount',
    value: function componentWillMount() {
      this.setState({ className: Grid.getClassName(this.props) });
    }
  }, {
    key: 'componentWillReceiveProps',
    value: function componentWillReceiveProps(nextProps) {
      var _this2 = this;

      if (DIFF_KEYS$1.some(function (key) {
        return _this2.props[key] !== nextProps[key];
      })) {
        this.setState({ className: Grid.getClassName(nextProps) });
      }
    }
  }, {
    key: 'render',
    value: function render() {
      var className = this.state.className;
      var _props = this.props,
          style = _props.style,
          Component$$1 = _props.component,
          children = _props.children,
          propClassName = _props.className,
          container = _props.container,
          stacked = _props.stacked,
          noSpacing = _props.noSpacing,
          gutter = _props.gutter,
          spacing = _props.spacing,
          props = objectWithoutProperties(_props, ['style', 'component', 'children', 'className', 'container', 'stacked', 'noSpacing', 'gutter', 'spacing']);


      if (typeof children === 'function') {
        return children({ style: style, className: className });
      }

      return React.createElement(
        Component$$1,
        _extends({}, props, { style: style, className: className }),
        children
      );
    }
  }]);
  return Grid;
}(PureComponent);

Grid.propTypes = {
  /**
   * An optional style to apply to the Grid component. This will only be applied
   * if the `children` prop is not a callback function.
   *
   * @see {@link #children}
   */
  style: propTypes.object,

  /**
   * An optional className to apply to the Grid component. This will only be applied
   * if the `children` prop is not a callback function.
   *
   * @see {@link #children}
   */
  className: propTypes.string,

  /**
   * The component to render the Grid as. This should probably not be used as much
   * as the `children` callback function.
   */
  component: propTypes.oneOfType([propTypes.string, propTypes.func]),

  /**
   * The children can either be renderable React elements or a callback function
   * that accepts the style and className props to apply so that the styles can
   * be manually added to whichever component.
   */
  children: propTypes.oneOfType([propTypes.func, propTypes.node]),

  /**
   * An optional container name to apply to the Grid. This should be the same name as provided
   * to the [react-md-make-grid-container](/components/grids?tab=2#mixin-react-md-make-grid-container) mixin.
   */
  container: propTypes.string,

  /**
   * Boolean if the grid should be placed vertically instead of horizontally.
   */
  stacked: propTypes.bool,

  /**
   * Boolean if all the gutters and spacing should be removed from the grid.
   */
  noSpacing: propTypes.bool,

  /**
   * When the [react-md-make-custom-grid](/components/grids?tab=2#mixin-react-md-make-custom-grid) mixin
   * is used, you can use the `gutter` and `spacing` props on the `Grid` to apply the correct className
   */
  gutter: propTypes.number,

  /**
   * When the [react-md-make-custom-grid](/components/grids?tab=2#mixin-react-md-make-custom-grid) mixin
   * is used, you can use the `gutter` and `spacing` props on the `Grid` to apply the correct className
   */
  spacing: propTypes.number
};
Grid.defaultProps = {
  component: 'div',
  stacked: false,
  noSpacing: false
};

var DIFF_KEYS$2 = ['className', 'align', 'position', 'size', 'offset', 'order', 'phoneSize', 'phoneOrder', 'phoneOffset', 'phoneHidden', 'tabletSize', 'tabletOrder', 'tabletOffset', 'tabletHidden', 'desktopSize', 'desktopOrder', 'desktopOffset', 'desktopHidden'];

var Cell = function (_PureComponent) {
  inherits(Cell, _PureComponent);
  createClass(Cell, null, [{
    key: 'getClassName',


    /**
     * A utility function to get the cell's className based on the Cell's props. This is
     * used behind the scenes to merge and create the className for the cell.
     *
     * ### Example:
     * ```js
     * <div className={Cell.getClassName()}>A simple cell</div>
     * <div className={Cell.getClassName({ size: 1 })}>A cell with size 1</div>
     * ```
     *
     * @param {Object=} props - This should be an object of the `Cell`'s props. It
     *    will extract the needed keys and generate the className.
     * @return {String} the full className to use for the cell
     */
    value: function getClassName() {
      var _bem;

      var props = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var className = props.className,
          align = props.align,
          position = props.position,
          size = props.size,
          order = props.order,
          offset = props.offset,
          phoneSize = props.phoneSize,
          phoneOrder = props.phoneOrder,
          phoneOffset = props.phoneOffset,
          phoneHidden = props.phoneHidden,
          tabletSize = props.tabletSize,
          tabletOrder = props.tabletOrder,
          tabletOffset = props.tabletOffset,
          tabletHidden = props.tabletHidden,
          desktopSize = props.desktopSize,
          desktopOrder = props.desktopOrder,
          desktopOffset = props.desktopOffset,
          desktopHidden = props.desktopHidden;


      return bem('md-cell', (_bem = {}, defineProperty(_bem, align, align), defineProperty(_bem, position, position), defineProperty(_bem, size, size), defineProperty(_bem, 'order-' + order, order), defineProperty(_bem, offset + '-offset', offset), defineProperty(_bem, phoneSize + '-phone', phoneSize), defineProperty(_bem, 'order-' + phoneOrder + '-phone', phoneOrder), defineProperty(_bem, phoneOffset + '-phone-offset', phoneOffset), defineProperty(_bem, 'phone-hidden', phoneHidden), defineProperty(_bem, tabletSize + '-tablet', tabletSize), defineProperty(_bem, 'order-' + tabletOrder + '-tablet', tabletOrder), defineProperty(_bem, tabletOffset + '-tablet-offset', tabletOffset), defineProperty(_bem, 'tablet-hidden', tabletHidden), defineProperty(_bem, desktopSize + '-desktop', desktopSize), defineProperty(_bem, 'order-' + desktopOrder + '-desktop', desktopOrder), defineProperty(_bem, desktopOffset + '-desktop-offset', desktopOffset), defineProperty(_bem, 'desktop-hidden', desktopHidden), _bem), className);
    }
  }]);

  function Cell(props) {
    classCallCheck(this, Cell);

    var _this = possibleConstructorReturn(this, (Cell.__proto__ || Object.getPrototypeOf(Cell)).call(this));

    _this.state = { className: Cell.getClassName(props) };
    return _this;
  }

  createClass(Cell, [{
    key: 'componentWillMount',
    value: function componentWillMount() {
      this.setState({ className: Cell.getClassName(this.props) });
    }
  }, {
    key: 'componentWillReceiveProps',
    value: function componentWillReceiveProps(nextProps) {
      var _this2 = this;

      if (DIFF_KEYS$2.some(function (key) {
        return _this2.props[key] !== nextProps[key];
      })) {
        this.setState({ className: Cell.getClassName(nextProps) });
      }
    }
  }, {
    key: 'render',
    value: function render() {
      var className = this.state.className;
      var _props = this.props,
          style = _props.style,
          Component$$1 = _props.component,
          children = _props.children,
          propClassName = _props.className,
          align = _props.align,
          position = _props.position,
          size = _props.size,
          offset = _props.offset,
          order = _props.order,
          phoneSize = _props.phoneSize,
          phoneOrder = _props.phoneOrder,
          phoneOffset = _props.phoneOffset,
          phoneHidden = _props.phoneHidden,
          tabletSize = _props.tabletSize,
          tabletOrder = _props.tabletOrder,
          tabletOffset = _props.tabletOffset,
          tabletHidden = _props.tabletHidden,
          desktopSize = _props.desktopSize,
          desktopOrder = _props.desktopOrder,
          desktopOffset = _props.desktopOffset,
          desktopHidden = _props.desktopHidden,
          props = objectWithoutProperties(_props, ['style', 'component', 'children', 'className', 'align', 'position', 'size', 'offset', 'order', 'phoneSize', 'phoneOrder', 'phoneOffset', 'phoneHidden', 'tabletSize', 'tabletOrder', 'tabletOffset', 'tabletHidden', 'desktopSize', 'desktopOrder', 'desktopOffset', 'desktopHidden']);


      if (typeof children === 'function') {
        return children({ style: style, className: className });
      }

      return React.createElement(
        Component$$1,
        _extends({}, props, { style: style, className: className }),
        children
      );
    }
  }]);
  return Cell;
}(PureComponent);

Cell.propTypes = {
  /**
   * An optional style to apply to the Cell component. This will only be applied
   * if the `children` prop is not a callback function.
   *
   * @see {@link #children}
   */
  style: propTypes.object,

  /**
   * An optional className to apply to the Cell component. This will only be applied
   * if the `children` prop is not a callback function.
   *
   * @see {@link #children}
   */
  className: propTypes.string,

  /**
   * The component to render the Cell as. This should probably not be used as much
   * as the `children` callback function.
   */
  component: propTypes.oneOfType([propTypes.string, propTypes.func]),

  /**
   * The children can either be renderable React elements or a callback function
   * that accepts the style and className props to apply so that the styles can
   * be manually added to whichever component.
   */
  children: propTypes.oneOfType([propTypes.func, propTypes.node]),

  /**
   * An optional cell alignment to apply. When the `Grid` is not `stacked`,
   * this will apply to vertical alignment within each "row" of the grid.
   *
   * Alignments:
   * - `top` - This will align to the top of the row
   * - `middle` - This will align to the middle of the row
   * - `bottom` - This will align to the bottom of the row
   * - `stretch` - This will make the cell stretch to fill all the available space
   *   in the row.
   *
   * @see {@link #position}
   */
  align: propTypes.oneOf(['top', 'middle', 'bottom', 'stretch']),

  /**
   * An optional cell position to apply. When the `Grid` is not `stacked`,
   * this will apply to horizontal alignment within each "row" of the grid.
   *
   * Positions:
   * - `center` - This will align the cell to be within the center of the row. This really
   *    just applies `margin-left: auto; margin-right: auto`.
   * - `right` - This will align the cell to the end of the row. This really just applies `margin-left: auto`.
   *
   * @see {@link #align}
   */
  position: propTypes.oneOf(['center', 'right']),

  /**
   * An optional size to apply to the cell. This sizing will be applied across all media sizes.
   * If the size is greater than the number of columns allowed for the media size, it will just
   * span the entire width.
   */
  size: propTypes.number,

  /**
   * An optional order to apply to the cell. This order will be applied across all media sizes.
   */
  order: propTypes.number,

  /**
   * An optional offset to apply to the cell. This will add spacing to the left of the cell.
   */
  offset: propTypes.number,

  /**
   * An optional size to apply to the cell only on phones.
   */
  phoneSize: propTypes.number,

  /**
   * An optional order to apply to the cell only on phones.
   */
  phoneOrder: propTypes.number,

  /**
   * An optional offset to apply to the cell only on phones.
   */
  phoneOffset: propTypes.number,

  /**
   * Boolean if the cell should be hidden on phones only.
   */
  phoneHidden: propTypes.bool,

  /**
   * An optional size to apply to the cell only on tablets.
   */
  tabletSize: propTypes.number,

  /**
   * An optional order to apply to the cell only on tablets.
   */
  tabletOrder: propTypes.number,

  /**
   * An optional offset to apply to the cell only on tablets.
   */
  tabletOffset: propTypes.number,

  /**
   * Boolean if the cell should be hidden on tablets only.
   */
  tabletHidden: propTypes.bool,

  /**
   * An optional size to apply to the cell only on desktops.
   */
  desktopSize: propTypes.number,

  /**
   * An optional order to apply to the cell only on desktops.
   */
  desktopOrder: propTypes.number,

  /**
   * An optional offset to apply to the cell only on desktops.
   */
  desktopOffset: propTypes.number,

  /**
   * Boolean if the cell should be hidden on desktops only.
   */
  desktopHidden: propTypes.bool
};
Cell.defaultProps = {
  component: 'div',
  phoneHidden: false,
  tabletHidden: false,
  desktopHidden: false
};

var DIFF_KEYS$3 = ['className', 'cellClassName', 'stacked', 'container', 'noSpacing', 'gutter', 'spacing', 'align', 'position', 'size', 'offset', 'order', 'phoneSize', 'phoneOrder', 'phoneOffset', 'phoneHidden', 'tabletSize', 'tabletOrder', 'tabletOffset', 'tabletHidden', 'desktopSize', 'desktopOrder', 'desktopOffset', 'desktopHidden'];

var GridList = function (_PureComponent) {
  inherits(GridList, _PureComponent);
  createClass(GridList, null, [{
    key: 'getClassNames',


    /**
     * A utility function to get the grid's className based on the `Grid`'s and `Cell`'s
     * props. This is * used behind the scenes to merge and create the className for the grid.
     *
     * ### Example:
     * ```js
     * const { className, cellClassName } = GridList.getClassNames();
     * const { className, cellClassName } = GridList.getClassNames({ size: 1, container: 'custom' });
     * ```
     *
     * @param {Object=} props - This should be an object of the `Grid`'s props. It
     *    will extract the needed keys and generate the classNames.
     * @return {Object} an object containing the `className` and `cellClassName` attributes.
     */
    value: function getClassNames() {
      var props = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var className = props.className,
          cellClassName = props.cellClassName,
          remaining = objectWithoutProperties(props, ['className', 'cellClassName']);

      return {
        className: Grid.getClassName(_extends({ className: className }, remaining)),
        cellClassName: Cell.getClassName(_extends({ className: cellClassName }, remaining))
      };
    }
  }]);

  function GridList(props) {
    classCallCheck(this, GridList);

    var _this = possibleConstructorReturn(this, (GridList.__proto__ || Object.getPrototypeOf(GridList)).call(this));

    _this.state = GridList.getClassNames(props);
    return _this;
  }

  createClass(GridList, [{
    key: 'componentWillMount',
    value: function componentWillMount() {
      this.setState(GridList.getClassNames(this.props));
    }
  }, {
    key: 'componentWillReceiveProps',
    value: function componentWillReceiveProps(nextProps) {
      var _this2 = this;

      if (DIFF_KEYS$3.some(function (key) {
        return _this2.props[key] !== nextProps[key];
      })) {
        this.setState(GridList.getClassNames(nextProps));
      }
    }
  }, {
    key: 'render',
    value: function render() {
      var _state = this.state,
          className = _state.className,
          cellClassName = _state.cellClassName;
      var _props = this.props,
          style = _props.style,
          cellStyle = _props.cellStyle,
          Component$$1 = _props.component,
          children = _props.children,
          propClassName = _props.className,
          propCellClassName = _props.cellClassName,
          container = _props.container,
          noSpacing = _props.noSpacing,
          stacked = _props.stacked,
          gutter = _props.gutter,
          spacing = _props.spacing,
          align = _props.align,
          position = _props.position,
          size = _props.size,
          offset = _props.offset,
          order = _props.order,
          phoneSize = _props.phoneSize,
          phoneOrder = _props.phoneOrder,
          phoneOffset = _props.phoneOffset,
          phoneHidden = _props.phoneHidden,
          tabletSize = _props.tabletSize,
          tabletOrder = _props.tabletOrder,
          tabletOffset = _props.tabletOffset,
          tabletHidden = _props.tabletHidden,
          desktopSize = _props.desktopSize,
          desktopOrder = _props.desktopOrder,
          desktopOffset = _props.desktopOffset,
          desktopHidden = _props.desktopHidden,
          props = objectWithoutProperties(_props, ['style', 'cellStyle', 'component', 'children', 'className', 'cellClassName', 'container', 'noSpacing', 'stacked', 'gutter', 'spacing', 'align', 'position', 'size', 'offset', 'order', 'phoneSize', 'phoneOrder', 'phoneOffset', 'phoneHidden', 'tabletSize', 'tabletOrder', 'tabletOffset', 'tabletHidden', 'desktopSize', 'desktopOrder', 'desktopOffset', 'desktopHidden']);


      if (typeof children === 'function') {
        return children({ style: style, className: className, cellStyle: cellStyle, cellClassName: cellClassName });
      }

      return React.createElement(
        Component$$1,
        _extends({}, props, { style: style, className: className }),
        React.Children.map(children, function (child) {
          if (!child) {
            return child;
          }

          var childStyle = child.props.style;
          if (cellStyle) {
            childStyle = childStyle ? _extends({}, cellStyle, childStyle) : cellStyle;
          }

          return React.cloneElement(child, {
            style: childStyle,
            className: classnames(child.props.className, cellClassName)
          });
        })
      );
    }
  }]);
  return GridList;
}(PureComponent);

GridList.propTypes = {
  /**
   * An optional style to apply to the Grid component. This will only be applied
   * if the `children` prop is not a callback function.
   *
   * @see {@link #children}
   */
  style: propTypes.object,

  /**
   * An optional className to apply to the Grid component. This will only be applied
   * if the `children` prop is not a callback function.
   *
   * @see {@link #children}
   */
  className: propTypes.string,

  /**
   * An optional style to apply to each child. This will only be applied
   * if the `children` prop is not a callback function.
   *
   * @see {@link #children}
   */
  cellStyle: propTypes.object,

  /**
   * An optional className to apply to each child. This will only be applied
   * if the `children` prop is not a callback function.
   *
   * @see {@link #children}
   */
  cellClassName: propTypes.string,

  /**
   * The component to render the Cell as. This should probably not be used as much
   * as the `children` callback function.
   */
  component: propTypes.oneOfType([propTypes.string, propTypes.func]),

  /**
   * The children can either be renderable React elements or a callback function
   * that accepts the style and className props to apply so that the styles can
   * be manually added to whichever component.
   */
  children: propTypes.oneOfType([propTypes.func, propTypes.node]),

  /**
   * An optional container name to apply to the Grid. This should be the same name as provided
   * to the [react-md-make-grid-container](/components/grids?tab=2#mixin-react-md-make-grid-container) mixin.
   */
  container: propTypes.string,

  /**
   * Boolean if the grid should be placed vertically instead of horizontally.
   */
  stacked: propTypes.bool,

  /**
   * Boolean if all the gutters and spacing should be removed from the grid.
   */
  noSpacing: propTypes.bool,

  /**
   * When the [react-md-make-custom-grid](/components/grids?tab=2#mixin-react-md-make-custom-grid) mixin
   * is used, you can use the `gutter` and `spacing` props on the `Grid` to apply the correct className
   */
  gutter: propTypes.number,

  /**
   * When the [react-md-make-custom-grid](/components/grids?tab=2#mixin-react-md-make-custom-grid) mixin
   * is used, you can use the `gutter` and `spacing` props on the `Grid` to apply the correct className
   */
  spacing: propTypes.number,

  /**
   * An optional cell alignment to apply. When the `Grid` is not `stacked`,
   * this will apply to vertical alignment within each "row" of the grid.
   *
   * Alignments:
   * - `top` - This will align to the top of the row
   * - `middle` - This will align to the middle of the row
   * - `bottom` - This will align to the bottom of the row
   * - `stretch` - This will make the cell stretch to fill all the available space
   *   in the row.
   *
   * @see {@link #position}
   */
  align: propTypes.oneOf(['top', 'middle', 'bottom', 'stretch']),

  /**
   * An optional cell position to apply. When the `Grid` is not `stacked`,
   * this will apply to horizontal alignment within each "row" of the grid.
   *
   * Positions:
   * - `center` - This will align the cell to be within the center of the row. This really
   *    just applies `margin-left: auto; margin-right: auto`.
   * - `right` - This will align the cell to the end of the row. This really just applies `margin-left: auto`.
   *
   * @see {@link #align}
   */
  position: propTypes.oneOf(['center', 'right']),

  /**
   * An optional size to apply to the cell. This sizing will be applied across all media sizes.
   * If the size is greater than the number of columns allowed for the media size, it will just
   * span the entire width.
   */
  size: propTypes.number,

  /**
   * An optional order to apply to the cell. This order will be applied across all media sizes.
   */
  order: propTypes.number,

  /**
   * An optional offset to apply to the cell. This will add spacing to the left of the cell.
   */
  offset: propTypes.number,

  /**
   * An optional size to apply to the cell only on phones.
   */
  phoneSize: propTypes.number,

  /**
   * An optional order to apply to the cell only on phones.
   */
  phoneOrder: propTypes.number,

  /**
   * An optional offset to apply to the cell only on phones.
   */
  phoneOffset: propTypes.number,

  /**
   * Boolean if the cell should be hidden on phones only.
   */
  phoneHidden: propTypes.bool,

  /**
   * An optional size to apply to the cell only on tablets.
   */
  tabletSize: propTypes.number,

  /**
   * An optional order to apply to the cell only on tablets.
   */
  tabletOrder: propTypes.number,

  /**
   * An optional offset to apply to the cell only on tablets.
   */
  tabletOffset: propTypes.number,

  /**
   * Boolean if the cell should be hidden on tablets only.
   */
  tabletHidden: propTypes.bool,

  /**
   * An optional size to apply to the cell only on desktops.
   */
  desktopSize: propTypes.number,

  /**
   * An optional order to apply to the cell only on desktops.
   */
  desktopOrder: propTypes.number,

  /**
   * An optional offset to apply to the cell only on desktops.
   */
  desktopOffset: propTypes.number,

  /**
   * Boolean if the cell should be hidden on desktops only.
   */
  desktopHidden: propTypes.bool
};
GridList.defaultProps = {
  component: 'div',
  stacked: false,
  noSpacing: false,
  phoneHidden: false,
  tabletHidden: false,
  desktopHidden: false
};

var ListItemControl = function (_PureComponent) {
  inherits(ListItemControl, _PureComponent);

  function ListItemControl() {
    classCallCheck(this, ListItemControl);
    return possibleConstructorReturn(this, (ListItemControl.__proto__ || Object.getPrototypeOf(ListItemControl)).apply(this, arguments));
  }

  createClass(ListItemControl, [{
    key: 'render',
    value: function render() {
      var _props = this.props,
          className = _props.className,
          tileStyle = _props.tileStyle,
          tileClassName = _props.tileClassName,
          primaryAction = _props.primaryAction,
          secondaryAction = _props.secondaryAction,
          primaryText = _props.primaryText,
          secondaryText = _props.secondaryText,
          threeLines = _props.threeLines,
          leftIcon = _props.leftIcon,
          leftAvatar = _props.leftAvatar,
          rightIcon = _props.rightIcon,
          rightAvatar = _props.rightAvatar,
          props = objectWithoutProperties(_props, ['className', 'tileStyle', 'tileClassName', 'primaryAction', 'secondaryAction', 'primaryText', 'secondaryText', 'threeLines', 'leftIcon', 'leftAvatar', 'rightIcon', 'rightAvatar']);


      var control = Children.only(primaryAction || secondaryAction);
      var text = React.createElement(ListItemText, {
        key: 'text',
        primaryText: control.props.label || primaryText,
        secondaryText: secondaryText,
        className: classnames({
          'md-tile-content--left-icon': leftIcon,
          'md-tile-content--left-avatar': leftAvatar,
          'md-tile-content--left-button': primaryAction,
          'md-tile-content--right-padding': primaryAction
        })
      });
      control = cloneElement(control, {
        className: classnames('md-list-control', {
          'md-list-control--right': secondaryAction
        }, control.props.className),
        label: text
      });

      var leftNode = React.createElement(TileAddon, {
        key: 'left-addon',
        icon: leftIcon,
        avatar: leftAvatar
      });

      var rightNode = React.createElement(TileAddon, {
        key: 'right-addon',
        icon: rightIcon,
        avatar: rightAvatar
      });

      var icond = !!leftIcon || !!rightIcon;
      var avatard = !!leftAvatar || !!rightAvatar;

      return React.createElement(
        'li',
        _extends({}, props, { className: classnames('md-list-item', className) }),
        React.createElement(
          'div',
          {
            style: tileStyle,
            className: classnames('md-list-tile', {
              'md-list-tile--icon': !secondaryText && icond && !avatard,
              'md-list-tile--avatar': !secondaryText && avatard,
              'md-list-tile--two-lines': secondaryText && !threeLines,
              'md-list-tile--three-lines': secondaryText && threeLines,
              'md-list-tile--control-left': primaryAction,
              'md-list-tile--control-right': secondaryAction
            }, themeColors({ text: true }), tileClassName)
          },
          leftNode,
          control,
          rightNode
        )
      );
    }
  }]);
  return ListItemControl;
}(PureComponent);

ListItemControl.propTypes = {
  /**
   * An optional style to apply to the `.md-list-item`.
   */
  style: propTypes.object,

  /**
   * An optional className to apply to the `.md-list-item`.
   */
  className: propTypes.string,

  /**
   * An optional style to apply to the `.md-list-tile`.
   */
  tileStyle: propTypes.object,

  /**
   * An optional className to apply to the `.md-list-tile`.
   */
  tileClassName: propTypes.string,

  /**
   * The primary text to display in the `ListItemControl`. The `primaryAction` or
   * `secondaryAction` will end up getting the `label` prop injected into it with
   * a combination of the `primaryText` and `secondaryText`. If the `primaryAction`
   * or `secondaryAction` already have a label prop, the `label` prop will be used
   * as the `primaryText`.
   */
  primaryText: propTypes.node,

  /**
   * An optional secondary text that can be displayed in the label of the `primaryAction`
   * or `secondaryAction`.
   */
  secondaryText: propTypes.node,

  /**
   * Boolean if the primary and secondary text will span three lines.
   */
  threeLines: propTypes.bool,

  /**
   * The primary action of the `ListItemControl`. This _should_ normally
   * be a type of `SelectionControl`
   */
  primaryAction: propTypes.element,

  /**
   * The secondary action of the `ListItemControl`. This _should_ normally
   * be a type of `SelectionControl`. If it is a selection control,
   * make sure to add the `labelBefore` prop to get correct positioning.
   */
  secondaryAction: propTypes.element,

  /**
   * An optional `FontIcon` to display to the left of the action.
   */
  leftIcon: propTypes.node,

  /**
   * An optional `Avatar` to display to the left of the action.
   */
  leftAvatar: propTypes.node,

  /**
   * An optional `FontIcon` to display to the right of the action.
   */
  rightIcon: propTypes.node,

  /**
   * An optional `FontIcon` to display to the right of the action.
   */
  rightAvatar: propTypes.node,

  /**
   * Defines the number of items in the list. This is only required when all items in the
   * list are not present in the DOM.
   *
   * @see https://www.w3.org/TR/wai-aria/states_and_properties#aria-setsize
   */
  'aria-setsize': propTypes.number,

  /**
   * Defines the items position in the list. This is only required when all items in the list
   * are not present in the DOM. The custom validation just requires this prop if the `aria-setsize`
   * prop is defined as a helpful reminder.
   *
   * @see https://www.w3.org/TR/wai-aria/states_and_properties#aria-posinset
   */
  'aria-posinset': function ariaPosinset(props, propName) {
    for (var _len = arguments.length, args = Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
      args[_key - 2] = arguments[_key];
    }

    var validator = propTypes.number;
    if (typeof props['aria-setsize'] !== 'undefined') {
      validator = validator.isRequired;
    }

    return validator.apply(undefined, [props, propName].concat(args));
  }
};

function validateAspectRatio(props, propName, component) {
  var _PropTypes$string;

  var value = props[propName];

  for (var _len = arguments.length, args = Array(_len > 3 ? _len - 3 : 0), _key = 3; _key < _len; _key++) {
    args[_key - 3] = arguments[_key];
  }

  var err = (_PropTypes$string = propTypes.string).isRequired.apply(_PropTypes$string, [props, propName, component].concat(args));
  if (!err && value.split('-').length !== 2) {
    err = new Error('Your provided an `' + propName + '` prop to the ' + component + ' that is not a valid ' + ('aspect ratio `' + value + '`. This should be in the form of \'{width}-{height}\'.'));
  }

  return err;
}

/**
 * The `Media` component is used to display images, iframes, ...media. Who'da thunk?
 */

var Media = function (_PureComponent) {
  inherits(Media, _PureComponent);

  function Media() {
    classCallCheck(this, Media);
    return possibleConstructorReturn(this, (Media.__proto__ || Object.getPrototypeOf(Media)).apply(this, arguments));
  }

  createClass(Media, [{
    key: 'render',
    value: function render() {
      var _props = this.props,
          Component$$1 = _props.component,
          className = _props.className,
          children = _props.children,
          forceAspect = _props.forceAspect,
          aspectRatio = _props.aspectRatio,
          expandable = _props.expandable,
          props = objectWithoutProperties(_props, ['component', 'className', 'children', 'forceAspect', 'aspectRatio', 'expandable']);


      return React.createElement(
        Component$$1,
        _extends({}, props, {
          className: classnames('md-media', defineProperty({}, 'md-media--' + aspectRatio, forceAspect), className)
        }),
        children
      );
    }
  }]);
  return Media;
}(PureComponent);

Media.propTypes = {
  /**
   * An optional className to apply to the card media component.
   */
  className: propTypes.string,

  /**
   * Any media to display.
   */
  children: propTypes.node,

  /**
   * Boolean if the aspect ratio should be forced.
   */
  forceAspect: propTypes.bool,

  /**
   * The aspect ratio to use.
   */
  aspectRatio: validateAspectRatio,

  /**
   * Boolean if this component should be expandable when there is a `CardExpander`
   * above it in the `Card`.
   */
  expandable: propTypes.bool,

  /**
   * The component to render the card media as.
   */
  component: propTypes.oneOfType([propTypes.func, propTypes.string]).isRequired
};
Media.defaultProps = {
  forceAspect: true,
  aspectRatio: '16-9',
  component: 'section'
};

/**
 * The `MediaOverlay` component is just a very simple wrapper that adds the
 * `.md-media-overlay` class name to a div. The overlay will be positioned
 * at the bottom of the `Media` by default.
 */

var MediaOverlay = function (_PureComponent) {
  inherits(MediaOverlay, _PureComponent);

  function MediaOverlay() {
    classCallCheck(this, MediaOverlay);
    return possibleConstructorReturn(this, (MediaOverlay.__proto__ || Object.getPrototypeOf(MediaOverlay)).apply(this, arguments));
  }

  createClass(MediaOverlay, [{
    key: 'render',
    value: function render() {
      var _props = this.props,
          className = _props.className,
          Component$$1 = _props.component,
          props = objectWithoutProperties(_props, ['className', 'component']);

      return React.createElement(Component$$1, _extends({ className: classnames('md-media-overlay', className) }, props));
    }
  }]);
  return MediaOverlay;
}(PureComponent);

MediaOverlay.propTypes = {
  /**
   * An optional style to apply to the overlay.
   */
  style: propTypes.object,

  /**
   * An optional className to apply to the overlay.
   */
  className: propTypes.string,

  /**
   * Any children to display in the overlay. This is _normally_ a `CardTitle` component
   * or some buttons.
   */
  children: propTypes.node,

  /**
   * The component to be rendered as.
   */
  component: propTypes.oneOfType([propTypes.func, propTypes.string]).isRequired
};
MediaOverlay.defaultProps = {
  component: 'div'
};

var ToolbarTitle = function (_PureComponent) {
  inherits(ToolbarTitle, _PureComponent);

  function ToolbarTitle() {
    classCallCheck(this, ToolbarTitle);
    return possibleConstructorReturn(this, (ToolbarTitle.__proto__ || Object.getPrototypeOf(ToolbarTitle)).apply(this, arguments));
  }

  createClass(ToolbarTitle, [{
    key: 'render',
    value: function render() {
      var _props = this.props,
          title = _props.title,
          className = _props.className,
          prominent = _props.prominent,
          offset = _props.offset,
          props = objectWithoutProperties(_props, ['title', 'className', 'prominent', 'offset']);

      if (!title) {
        return null;
      }

      var fullClassName = classnames('md-title md-title--toolbar', {
        'md-title--toolbar-prominent': prominent,
        'md-title--toolbar-offset': offset
      }, className);

      if (isValidElement(title)) {
        var titleEl = Children.only(title);
        return cloneElement(title, _extends({}, props, {
          id: titleEl.props.id || props.id,
          className: classnames(fullClassName, titleEl.props.className)
        }));
      }

      return React.createElement(
        'h2',
        _extends({}, props, {
          className: fullClassName
        }),
        title
      );
    }
  }]);
  return ToolbarTitle;
}(PureComponent);

ToolbarTitle.propTypes = {
  className: propTypes.string,
  prominent: propTypes.bool,
  offset: propTypes.bool,
  title: propTypes.node
};

var Toolbar = function (_PureComponent) {
  inherits(Toolbar, _PureComponent);

  function Toolbar() {
    classCallCheck(this, Toolbar);
    return possibleConstructorReturn(this, (Toolbar.__proto__ || Object.getPrototypeOf(Toolbar)).apply(this, arguments));
  }

  createClass(Toolbar, [{
    key: 'render',
    value: function render() {
      var _props = this.props,
          style = _props.style,
          className = _props.className,
          component = _props.component,
          titleStyle = _props.titleStyle,
          titleClassName = _props.titleClassName,
          prominentTitle = _props.prominentTitle,
          themed = _props.themed,
          singleColor = _props.singleColor,
          actions = _props.actions,
          fixed = _props.fixed,
          children = _props.children,
          inset = _props.inset,
          titleId = _props.titleId,
          propNav = _props.nav,
          propTitle = _props.title,
          propTitleMenu = _props.titleMenu,
          propZDepth = _props.zDepth,
          propColored = _props.colored,
          propProminent = _props.prominent,
          containerStyle = _props.containerStyle,
          containerClassName = _props.containerClassName,
          actionLeft = _props.actionLeft,
          actionsRight = _props.actionsRight,
          primary = _props.primary,
          secondary = _props.secondary,
          props = objectWithoutProperties(_props, ['style', 'className', 'component', 'titleStyle', 'titleClassName', 'prominentTitle', 'themed', 'singleColor', 'actions', 'fixed', 'children', 'inset', 'titleId', 'nav', 'title', 'titleMenu', 'zDepth', 'colored', 'prominent', 'containerStyle', 'containerClassName', 'actionLeft', 'actionsRight', 'primary', 'secondary']);
      var _props2 = this.props,
          colored = _props2.colored,
          title = _props2.title,
          titleMenu = _props2.titleMenu,
          nav = _props2.nav,
          prominent = _props2.prominent,
          zDepth = _props2.zDepth;


      colored = colored || primary || secondary;
      prominent = prominent || prominentTitle;

      title = React.createElement(ToolbarTitle, {
        key: 'title',
        style: titleStyle,
        className: titleClassName,
        prominent: prominentTitle,
        offset: prominentTitle,
        id: typeof titleId === 'undefined' && props.id ? props.id + '-title' : titleId,
        title: title
      });

      if (nav || actionLeft) {
        var navEl = Children.only(nav || actionLeft);
        nav = cloneElement(nav, {
          className: classnames('md-btn--toolbar md-toolbar--action-left', navEl.props.className)
        });
      }

      var rightActions = void 0;
      if (actions || actionsRight) {
        rightActions = Children.map(Children.toArray(actions || actionsRight), function (action) {
          return cloneElement(action, {
            className: classnames('md-btn--toolbar', action.props.className)
          });
        });

        rightActions = React.createElement(
          'div',
          { key: 'actions', className: 'md-cell--right md-toolbar--action-right' },
          rightActions
        );
      }

      if (titleMenu) {
        titleMenu = Children.only(titleMenu);
        titleMenu = cloneElement(titleMenu, {
          className: classnames('md-title md-title--toolbar md-select-field--toolbar', {
            'md-title--toolbar-offset': prominentTitle,
            'md-title--toolbar-prominent': prominentTitle
          }, titleMenu.props.className),
          position: titleMenu.props.position || 'tl',
          toolbar: true
        });
      }

      if (typeof zDepth !== 'number') {
        zDepth = fixed ? 2 : 0;
      }

      return React.createElement(
        Paper,
        _extends({}, props, {
          component: component,
          zDepth: zDepth,
          style: style,
          className: classnames('md-toolbar', {
            'md-background--primary': colored,
            'md-toolbar--themed': themed,
            'md-toolbar--text-white': singleColor && colored,
            'md-toolbar--prominent': prominent,
            'md-toolbar--fixed': fixed,
            'md-toolbar--inset': inset
          }, className)
        }),
        nav,
        title,
        titleMenu,
        children,
        rightActions
      );
    }
  }]);
  return Toolbar;
}(PureComponent);

Toolbar.propTypes = {
  /**
   * An optional id to provide to the toolbar. If this is specified and the `titleId` is not, the title
   * will gain an id of `${id}-title`. This will not be applied to the `titleMenu`.
   *
   * @see {@link #titleId}
   */
  id: propTypes.oneOfType([propTypes.number, propTypes.string]),

  /**
   * An optional style to apply to the toolbar.
   */
  style: propTypes.object,

  /**
   * An optional className to apply to the toolbar,
   */
  className: propTypes.string,

  /*
   * An optional style to apply to the `h2` surrounding the `title` prop.
   */
  titleStyle: propTypes.object,

  /*
   * An optional className to apply to the `h2` surrounding the `title` prop.
   */
  titleClassName: propTypes.string,

  /**
   * Boolean if the toolbar should more prominent. This will double the height of the toolbar.
   */
  prominent: propTypes.bool,

  /**
   * Boolean if the toolbar's title should be more prominent. This will move the title to the
   * second line of the toolbar. This only works when the `prominent` prop is true as well.
   */
  prominentTitle: propTypes.bool,

  /**
   * The current title of the page to show in the toolbar. It is invalid to specify both a
   * `title` and a `titleMenu`. Only one should be given.
   */
  title: invalidIf(propTypes.node, 'titleMenu'),

  /**
   * An optional id to give the main title in the toolbar. This will not be applied to the
   * `titleMenu`.
   */
  titleId: propTypes.oneOfType([propTypes.number, propTypes.string]),

  /**
   * An optional title menu to display instead of the title. This should be a `SelectField` component.
   * It is cloned with some additional props, so if the `SelectField` is separated into a separate
   * component, the following props must be passed to get the correct styling: `className`, `block`,
   * `paddedBlock`, `position`.
   */
  titleMenu: propTypes.element,

  /**
   * This prop is used for rendering an optional navigation button to the left of the `title`
   * or the `titleMenu` component. This needs to be an icon `Button` because some additional props
   * are cloned into it.
   */
  nav: propTypes.element,

  /**
   * Any additional actions to display to the right of the title. This should be a list or a single
   * `Button` to display. The buttons get cloned with an additional className for toolbar styling.
   */
  actions: propTypes.oneOfType([propTypes.element, propTypes.arrayOf(propTypes.element)]),

  /**
   * Any children to display in the toolbar. This will be displayed between the optional title and
   * actions.
   */
  children: propTypes.node,

  /**
   * Boolean if the toolbar should be fixed to the top of the page. This will add some additional box shadow.
   */
  fixed: propTypes.bool,

  /**
   * Boolean if the nav, actions, and title should share the same color. For a `colored` or dark `themed`
   * toolbar, they will all be colored white. For a transparent or light `themed` toolbar, the colors will
   * be the `rgba(0, 0, 0, .87)`. Setting this to false will only style the title to the specific color
   * stated above.
   */
  singleColor: propTypes.bool,

  /**
   * Boolean if the toolbar should be colored based off the current theme. This will either style the background
   * to be fairly white, or fairly black. You can not specify both `themed` and `colored`.
   */
  themed: propTypes.bool,

  /**
   * Boolean if the toolbar should be colored with the `$md-primary-color`.
   */
  colored: invalidIf(propTypes.bool, 'themed'),

  /**
   * The component to render the toolbar as.
   */
  component: propTypes.oneOfType([propTypes.func, propTypes.string]).isRequired,

  /**
   * Boolean if the toolbar is inset in the page. This will just add some margin around
   * it.
   */
  inset: propTypes.bool,

  /**
   * An optional zDepth to enforce for the toolbar. This should be a number between 0 and 5.
   * If this is omitted, the toolbar will gain a zDepth of 2 when `fixed`.
   */
  zDepth: between(propTypes.number, 0, 5),
  containerStyle: deprecated(propTypes.object, 'The `container` no longer exists in the `Toolbar`. Use the `style` prop instead'),
  containerClassName: deprecated(propTypes.string, 'The `container` no longer exists in the `Toolbar`. Use the `className` prop instead'),
  primary: deprecated(propTypes.bool, 'Use the `colored` prop instead'),
  secondary: deprecated(propTypes.bool, 'Toolbars can no longer be themed to the secondary color. Use the `colored` prop instead'),
  actionLeft: deprecated(propTypes.element, 'Use the `nav` prop instead'),
  actionsRight: deprecated(propTypes.node, 'Use the `menu` prop and/or the `actions` prop instead')
};
Toolbar.defaultProps = {
  singleColor: true,
  component: 'header'
};

/**
 * This is an accessibility only component that should be used in the `NavigationDrawer`
 * component. It allows keyboard users to quickly jump to the main content.
 *
 * This component relies on the `contextTypes` of the `NavigationDrawer` to work. If this is going
 * to be used outside of that component, you will need to specify an `id` and `label` contextType
 * to pass to this component.
 */

var JumpToContentLink = function (_PureComponent) {
  inherits(JumpToContentLink, _PureComponent);

  function JumpToContentLink() {
    var _ref;

    var _temp, _this, _ret;

    classCallCheck(this, JumpToContentLink);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = possibleConstructorReturn(this, (_ref = JumpToContentLink.__proto__ || Object.getPrototypeOf(JumpToContentLink)).call.apply(_ref, [this].concat(args))), _this), _this._handleClick = function (e) {
      if (_this.props.onClick) {
        _this.props.onClick(e);
      }

      document.getElementById(_this.context.id).focus();
    }, _temp), possibleConstructorReturn(_this, _ret);
  }

  createClass(JumpToContentLink, [{
    key: 'render',
    value: function render() {
      var _props = this.props,
          className = _props.className,
          props = objectWithoutProperties(_props, ['className']);
      var _context = this.context,
          id = _context.id,
          label = _context.label;

      return React.createElement(
        'a',
        _extends({}, props, {
          id: 'jump-to-' + id,
          href: '#' + id,
          onClick: this._handleClick,
          className: classnames('md-content-jump', className)
        }),
        label
      );
    }
  }]);
  return JumpToContentLink;
}(PureComponent);

JumpToContentLink.propTypes = {
  /**
   * An optional className to apply.
   */
  className: propTypes.string,

  /**
   * An optional function to call when the linked is clicked.
   */
  onClick: propTypes.func
};
JumpToContentLink.contextTypes = {
  id: propTypes.oneOfType([propTypes.number, propTypes.string]).isRequired,
  label: propTypes.node.isRequired
};

/**
 * A button used to close the persistent navigation drawer. The button will
 * be generated based on the `NavigationDrawer`'s `contextTypes`.
 *
 * This component is really only used if you are using a `persistent` drawer and you
 * manually created the `drawerHeader` for the `NavigationDrawer`.
 */

var CloseButton = function (_PureComponent) {
  inherits(CloseButton, _PureComponent);

  function CloseButton() {
    var _ref;

    var _temp, _this, _ret;

    classCallCheck(this, CloseButton);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = possibleConstructorReturn(this, (_ref = CloseButton.__proto__ || Object.getPrototypeOf(CloseButton)).call.apply(_ref, [this].concat(args))), _this), _this._handleClick = function (e) {
      if (_this.props.onClick) {
        _this.props.onClick(e);
      }

      if (_this.context.onCloseClick) {
        _this.context.onCloseClick(e);
      }
    }, _temp), possibleConstructorReturn(_this, _ret);
  }

  createClass(CloseButton, [{
    key: 'render',
    value: function render() {
      var closeIcon = this.context.closeIcon;


      return React.createElement(Button$1, _extends({}, this.props, {
        icon: true,
        key: 'close',
        onClick: this._handleClick,
        iconEl: closeIcon
      }));
    }
  }]);
  return CloseButton;
}(PureComponent);

CloseButton.propTypes = {
  /**
   * An optional className to apply.
   */
  className: propTypes.string,

  /**
   * An optional additional function to call when the `click` event is triggered.
   */
  onClick: propTypes.func
};
CloseButton.contextTypes = {
  closeIcon: propTypes.element,
  onCloseClick: propTypes.func
};

var MiniListItem = function (_PureComponent) {
  inherits(MiniListItem, _PureComponent);

  function MiniListItem() {
    var _ref;

    var _temp, _this, _ret;

    classCallCheck(this, MiniListItem);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = possibleConstructorReturn(this, (_ref = MiniListItem.__proto__ || Object.getPrototypeOf(MiniListItem)).call.apply(_ref, [this].concat(args))), _this), _this.state = { active: false }, _this._handleMouseOver = function (e) {
      if (_this.props.onMouseOver) {
        _this.props.onMouseOver(e);
      }

      if (!_this.props.disabled) {
        _this.setState({ active: true });
      }
    }, _this._handleMouseLeave = function (e) {
      if (_this.props.onMouseLeave) {
        _this.props.onMouseLeave(e);
      }

      if (!_this.props.disabled) {
        _this.setState({ active: false });
      }
    }, _this._handleTouchStart = function (e) {
      if (_this.props.onTouchStart) {
        _this.props.onTouchStart(e);
      }

      _this._touched = true;

      _this.setState({ active: true, touchedAt: Date.now() });
    }, _this._handleTouchEnd = function (e) {
      if (_this.props.onTouchEnd) {
        _this.props.onTouchEnd(e);
      }

      var time = Date.now() - _this.state.touchedAt;
      _this._touchTimeout = setTimeout(function () {
        _this._touchTimeout = null;

        _this.setState({ active: false });
      }, time > 450 ? 0 : 450 - time);
    }, _temp), possibleConstructorReturn(_this, _ret);
  }

  createClass(MiniListItem, [{
    key: 'componentWillUnmount',
    value: function componentWillUnmount() {
      if (this._touchTimeout) {
        clearTimeout(this._touchTimeout);
      }
    }
  }, {
    key: 'render',
    value: function render() {
      var _props = this.props,
          style = _props.style,
          className = _props.className,
          tileStyle = _props.tileStyle,
          tileClassName = _props.tileClassName,
          leftIcon = _props.leftIcon,
          leftAvatar = _props.leftAvatar,
          active = _props.active,
          activeClassName = _props.activeClassName,
          ItemComponent = _props.itemComponent,
          primaryText = _props.primaryText,
          secondaryText = _props.secondaryText,
          rightIcon = _props.rightIcon,
          rightAvatar = _props.rightAvatar,
          threeLines = _props.threeLines,
          children = _props.children,
          defaultOpen = _props.defaultOpen,
          isOpen = _props.isOpen,
          inset = _props.inset,
          nestedItems = _props.nestedItems,
          animateNestedItems = _props.animateNestedItems,
          expanderIcon = _props.expanderIcon,
          expanderIconChildren = _props.expanderIconChildren,
          expanderIconClassName = _props.expanderIconClassName,
          props = objectWithoutProperties(_props, ['style', 'className', 'tileStyle', 'tileClassName', 'leftIcon', 'leftAvatar', 'active', 'activeClassName', 'itemComponent', 'primaryText', 'secondaryText', 'rightIcon', 'rightAvatar', 'threeLines', 'children', 'defaultOpen', 'isOpen', 'inset', 'nestedItems', 'animateNestedItems', 'expanderIcon', 'expanderIconChildren', 'expanderIconClassName']);


      return React.createElement(
        ItemComponent,
        { style: style, className: className },
        React.createElement(
          AccessibleFakeInkedButton,
          _extends({}, props, {
            style: tileStyle,
            className: classnames('md-list-tile md-list-tile--icon md-list-tile--mini', {
              'md-list-tile--active': this.state.active && !this._touched
            }, tileClassName),
            onMouseOver: this._handleMouseOver,
            onMouseLeave: this._handleMouseLeave,
            onTouchStart: this._handleTouchStart,
            onTouchEnd: this._handleTouchEnd
          }),
          React.createElement(TileAddon, {
            active: active,
            activeClassName: activeClassName,
            icon: leftIcon,
            avatar: leftAvatar
          })
        )
      );
    }
  }]);
  return MiniListItem;
}(PureComponent);

MiniListItem.propTypes = {
  style: propTypes.object,
  className: propTypes.string,
  tileStyle: propTypes.object,
  tileClassName: propTypes.string,
  component: propTypes.oneOfType([propTypes.func, propTypes.string]),
  active: propTypes.bool,
  activeClassName: propTypes.string,
  leftIcon: propTypes.node,
  leftAvatar: propTypes.node,
  disabled: propTypes.bool,
  onTouchStart: propTypes.func,
  onTouchEnd: propTypes.func,
  onMouseOver: propTypes.func,
  onMouseLeave: propTypes.func,
  defaultOpen: propTypes.bool,
  itemComponent: propTypes.oneOfType([propTypes.string, propTypes.func]).isRequired
};
MiniListItem.defaultProps = {
  activeClassName: 'md-text--theme-primary',
  component: 'div',
  itemComponent: 'li'
};

var DrawerTypes$2 = Drawer.DrawerTypes;

function getNonMiniType(type) {
  var pMini = DrawerTypes$2.PERSISTENT_MINI,
      tMini = DrawerTypes$2.TEMPORARY_MINI;

  if ([pMini, tMini].indexOf(type) === -1) {
    return type;
  }

  return pMini === type ? DrawerTypes$2.PERSISTENT : DrawerTypes$2.TEMPORARY;
}

function toMiniListItem(item, index) {
  if (isValidElement(item)) {
    return item;
  }

  var divider = item.divider,
      subheader = item.subheader,
      key = item.key,
      itemProps = objectWithoutProperties(item, ['divider', 'subheader', 'key']);

  if (divider || subheader) {
    return null;
  }

  return React.createElement(MiniListItem, _extends({ key: key || index }, itemProps));
}

/**
 * The `NavigationDrawer` is used when you want a full layout configuration. It is a combination
 * of the `Toolbar` component and the `Drawer` component. Any props that are not specifically
 * listed below will be provided to t