'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _keyCodes = require('../constants/keyCodes');

var _themeColors = require('../utils/themeColors');

var _themeColors2 = _interopRequireDefault(_themeColors);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var CLOCK_PADDING = 4;

/**
 * The `ClockTime` component is used for positioning hours or minutes
 * in a clock. The time will be positioned based on it's given index
 * and the radius of the clock.
 */

var ClockTime = function (_PureComponent) {
  _inherits(ClockTime, _PureComponent);

  function ClockTime(props) {
    _classCallCheck(this, ClockTime);

    var _this = _possibleConstructorReturn(this, (ClockTime.__proto__ || Object.getPrototypeOf(ClockTime)).call(this, props));

    _this._handleKeyUp = function (e) {
      if ((e.which || e.keyCode) === _keyCodes.TAB) {
        _this.props.onKeyboardFocus(_this.props.time);
      }
    };

    _this._setTime = function (time) {
      _this._time = time;
      if (time !== null) {
        _this._setPosition(_this.props, time);

        if (_this.props.active) {
          time.focus();
        }
      }
    };

    _this._setPosition = function (_ref, time) {
      var radius = _ref.radius,
          index = _ref.index;

      // 36 is default size for the time
      var size = (time.offsetWidth || 36) / 2;
      var timeRadians = Math.PI / 2 - index * (Math.PI / 6);
      var innerCircle = index > 12;

      var outerRadius = radius - size;
      var innerRadius = outerRadius - CLOCK_PADDING - (innerCircle ? size * 2 : 0);

      _this.setState({
        style: {
          top: outerRadius - innerRadius * Math.sin(timeRadians),
          left: outerRadius + innerRadius * Math.cos(timeRadians)
        }
      });
    };

    _this.state = {
      // default size in scss
      size: 18
    };
    return _this;
  }

  _createClass(ClockTime, [{
    key: 'componentWillReceiveProps',
    value: function componentWillReceiveProps(nextProps) {
      if (this.props.radius !== nextProps.radius || this.props.index !== nextProps.index) {
        this._setPosition(nextProps, this._time);
      }
    }
  }, {
    key: 'render',
    value: function render() {
      var _props = this.props,
          time = _props.time,
          active = _props.active;

      return _react2.default.createElement(
        'div',
        {
          ref: this._setTime,
          tabIndex: 0,
          className: (0, _classnames2.default)('md-clock-time md-text-no-select md-pointer--none', {
            'md-picker-text--active': active
          }, (0, _themeColors2.default)({ text: !active })),
          style: this.state.style,
          onKeyUp: this._handleKeyUp
        },
        _react2.default.createElement(
          'span',
          { className: 'md-clock-time-value' },
          time
        )
      );
    }
  }]);

  return ClockTime;
}(_react.PureComponent);

ClockTime.propTypes = {
  /**
   * The index of the current time to be displayed. This
   * should be a number between 1 and 24.
   */
  index: _propTypes2.default.number.isRequired,

  /**
   * The time number to display.
   */
  time: _propTypes2.default.number.isRequired,

  /**
   * Boolean if this time is currently selected.
   */
  active: _propTypes2.default.bool.isRequired,

  /**
   * The radius of the clock.
   */
  radius: _propTypes2.default.number.isRequired,

  onKeyboardFocus: _propTypes2.default.func.isRequired
};
exports.default = ClockTime;
//# sourceMappingURL=ClockTime.js.map