'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _keyCodes = require('../constants/keyCodes');

var _themeColors = require('../utils/themeColors');

var _themeColors2 = _interopRequireDefault(_themeColors);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var PasswordButton = function (_PureComponent) {
  _inherits(PasswordButton, _PureComponent);

  function PasswordButton() {
    var _ref;

    var _temp, _this, _ret;

    _classCallCheck(this, PasswordButton);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = PasswordButton.__proto__ || Object.getPrototypeOf(PasswordButton)).call.apply(_ref, [this].concat(args))), _this), _this.state = { keyboardFocus: false }, _this._handleOutsideClick = function (e) {
      if (_this._button && !_this._button.contains(e.target)) {
        window.removeEventListener('click', _this._handleOutsideClick);
        _this.setState({ keyboardFocus: false });
      }
    }, _this._handleBlur = function () {
      if (_this.state.keyboardFocus) {
        _this.setState({ keyboardFocus: false });
      }
    }, _this._handleKeyUp = function (e) {
      var key = e.which || e.keyCode;
      if (key === _keyCodes.TAB) {
        _this.setState({ keyboardFocus: true });
      }
    }, _temp), _possibleConstructorReturn(_this, _ret);
  }

  _createClass(PasswordButton, [{
    key: 'render',
    value: function render() {
      var keyboardFocus = this.state.keyboardFocus;

      var _props = this.props,
          active = _props.active,
          passwordVisible = _props.passwordVisible,
          block = _props.block,
          floating = _props.floating,
          icon = _props.icon,
          props = _objectWithoutProperties(_props, ['active', 'passwordVisible', 'block', 'floating', 'icon']);

      return _react2.default.createElement(
        'button',
        _extends({}, props, {
          onBlur: this._handleBlur,
          onKeyUp: this._handleKeyUp,
          type: 'button',
          className: (0, _classnames2.default)('md-text-field-inline-indicator md-password-btn md-pointer--hover', {
            'md-password-btn--focus': keyboardFocus,
            'md-password-btn--invisible': active && !passwordVisible,
            'md-text-field-inline-indicator--floating': floating,
            'md-text-field-inline-indicator--block': block
          }, (0, _themeColors2.default)({ disabled: !active, hint: active }))
        }),
        icon
      );
    }
  }]);

  return PasswordButton;
}(_react.PureComponent);

PasswordButton.propTypes = {
  active: _propTypes2.default.bool,
  passwordVisible: _propTypes2.default.bool,
  icon: _propTypes2.default.element,
  block: _propTypes2.default.bool,
  floating: _propTypes2.default.bool
};
exports.default = PasswordButton;
//# sourceMappingURL=PasswordButton.js.map