'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = getCollapserStyles;

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/**
 * A simple utility function to get the dynamic collapser styles.
 */
function getCollapserStyles(_ref) {
  var _ref2;

  var flipped = _ref.flipped,
      suffix = _ref.suffix,
      suffixFlipped = _ref.suffixFlipped;

  for (var _len = arguments.length, classNames = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
    classNames[_key - 1] = arguments[_key];
  }

  return _classnames2.default.apply(undefined, ['md-collapser', (_ref2 = {
    'md-collapser--flipped': flipped && (!suffixFlipped || !suffix)
  }, _defineProperty(_ref2, 'md-collapser--' + suffix, suffix), _defineProperty(_ref2, 'md-collapser--' + suffix + '-flipped', suffix && flipped && suffixFlipped), _ref2)].concat(classNames));
}
//# sourceMappingURL=getCollapserStyles.js.map