'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _glamor = require('glamor');

var _ProgressBar = require('./ProgressBar');

var _ProgressBar2 = _interopRequireDefault(_ProgressBar);

var _constant = require('./constant');

var _defaultStyle = require('./defaultStyle');

var _defaultStyle2 = _interopRequireDefault(_defaultStyle);

var _propValidator = require('./util/propValidator');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var styles = {
  container: function container(type, rtl) {
    var _extends2;

    return (0, _glamor.css)(_extends({
      position: 'relative',
      minHeight: '64px',
      boxSizing: 'border-box',
      marginBottom: '1rem',
      padding: '8px',
      borderRadius: '1px',
      boxShadow: '0 1px 10px 0 rgba(0, 0, 0, .1), 0 2px 15px 0 rgba(0, 0, 0, .05)',
      display: 'flex',
      justifyContent: 'space-between',
      maxHeight: '800px',
      overflow: 'hidden',
      fontFamily: _defaultStyle2.default.fontFamily,
      cursor: 'pointer',
      background: _defaultStyle2.default['color' + type.charAt(0).toUpperCase() + type.slice(1)]
    }, type === 'default' ? { color: '#aaa' } : {}, (_extends2 = {}, _defineProperty(_extends2, '@media ' + _defaultStyle2.default.mobile, {
      marginBottom: 0
    }), _defineProperty(_extends2, 'direction', rtl ? 'rtl' : 'ltr'), _extends2)));
  },
  body: (0, _glamor.css)({
    margin: 'auto 0',
    flex: 1
  })
};

var Toast = function (_Component) {
  _inherits(Toast, _Component);

  function Toast() {
    var _ref;

    var _temp, _this, _ret;

    _classCallCheck(this, Toast);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = Toast.__proto__ || Object.getPrototypeOf(Toast)).call.apply(_ref, [this].concat(args))), _this), _this.state = {
      isRunning: true
    }, _this.pauseToast = function () {
      _this.setState({ isRunning: false });
    }, _this.playToast = function () {
      _this.setState({ isRunning: true });
    }, _temp), _possibleConstructorReturn(_this, _ret);
  }

  _createClass(Toast, [{
    key: 'componentDidMount',
    value: function componentDidMount() {
      this.props.onOpen !== null && this.props.onOpen(this.getChildrenProps());
    }
  }, {
    key: 'componentWillReceiveProps',
    value: function componentWillReceiveProps(nextProps) {
      if (this.props.isDocumentHidden !== nextProps.isDocumentHidden) {
        this.setState({
          isRunning: !nextProps.isDocumentHidden
        });
      }
    }
  }, {
    key: 'componentWillUnmount',
    value: function componentWillUnmount() {
      this.props.onClose !== null && this.props.onClose(this.getChildrenProps());
    }
  }, {
    key: 'getChildrenProps',
    value: function getChildrenProps() {
      return this.props.children.props;
    }
  }, {
    key: 'getToastProps',
    value: function getToastProps() {
      var toastProps = {};

      if (this.props.autoClose !== false && this.props.pauseOnHover === true) {
        toastProps.onMouseEnter = this.pauseToast;
        toastProps.onMouseLeave = this.playToast;
      }
      typeof this.props.className === 'string' && (toastProps.className = this.props.className);
      this.props.closeOnClick && (toastProps.onClick = this.props.closeToast);

      return toastProps;
    }
  }, {
    key: 'render',
    value: function render() {
      var _props = this.props,
          closeButton = _props.closeButton,
          children = _props.children,
          autoClose = _props.autoClose,
          type = _props.type,
          hideProgressBar = _props.hideProgressBar,
          closeToast = _props.closeToast,
          Transition = _props.transition,
          position = _props.position,
          onExited = _props.onExited,
          className = _props.className,
          bodyClassName = _props.bodyClassName,
          progressClassName = _props.progressClassName,
          updateId = _props.updateId,
          role = _props.role,
          rtl = _props.rtl;


      return _react2.default.createElement(
        Transition,
        {
          'in': this.props.in,
          appear: true,
          unmountOnExit: true,
          onExited: onExited,
          position: position
        },
        _react2.default.createElement(
          'div',
          _extends({}, (0, _glamor.css)(styles.container(type, rtl), typeof className !== 'string' && className), this.getToastProps()),
          _react2.default.createElement(
            'div',
            _extends({}, this.props.in && { role: role }, (0, _glamor.css)(styles.body, typeof bodyClassName !== 'string' && bodyClassName), typeof bodyClassName === 'string' && {
              className: bodyClassName
            }),
            children
          ),
          closeButton !== false && closeButton,
          autoClose !== false && _react2.default.createElement(_ProgressBar2.default, {
            key: 'pb-' + updateId,
            rtl: rtl,
            delay: autoClose,
            isRunning: this.state.isRunning,
            closeToast: closeToast,
            hide: hideProgressBar,
            type: type,
            className: progressClassName
          })
        )
      );
    }
  }]);

  return Toast;
}(_react.Component);

Toast.propTypes = {
  closeButton: _propValidator.falseOrElement.isRequired,
  autoClose: _propValidator.falseOrDelay.isRequired,
  children: _propTypes2.default.node.isRequired,
  closeToast: _propTypes2.default.func.isRequired,
  position: _propTypes2.default.oneOf((0, _propValidator.objectValues)(_constant.POSITION)).isRequired,
  pauseOnHover: _propTypes2.default.bool.isRequired,
  closeOnClick: _propTypes2.default.bool.isRequired,
  transition: _propTypes2.default.func.isRequired,
  isDocumentHidden: _propTypes2.default.bool.isRequired,
  rtl: _propTypes2.default.bool.isRequired,
  in: _propTypes2.default.bool,
  onExited: _propTypes2.default.func,
  hideProgressBar: _propTypes2.default.bool,
  onOpen: _propTypes2.default.func,
  onClose: _propTypes2.default.func,
  type: _propTypes2.default.oneOf((0, _propValidator.objectValues)(_constant.TYPE)),
  className: _propTypes2.default.oneOfType([_propTypes2.default.string, _propTypes2.default.object]),
  bodyClassName: _propTypes2.default.oneOfType([_propTypes2.default.string, _propTypes2.default.object]),
  progressClassName: _propTypes2.default.oneOfType([_propTypes2.default.string, _propTypes2.default.object]),
  updateId: _propTypes2.default.number,
  ariaLabel: _propTypes2.default.string
};
Toast.defaultProps = {
  type: _constant.TYPE.DEFAULT,
  in: true,
  hideProgressBar: false,
  onOpen: null,
  onClose: null,
  className: null,
  bodyClassName: null,
  progressClassName: null,
  updateId: null,
  role: 'alert'
};
exports.default = Toast;