<%--

    The Kuali Financial System, a comprehensive financial management system for higher education.

    Copyright 2005-2018 Kuali, Inc.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

--%>
<%@ include file="/jsp/sys/kfsTldHeader.jsp" %>
<%@ attribute name="assetPaymentDetail" type="java.util.List" required="true"
              description="In process asset payments list" %>
<%@ attribute name="assetPaymentAssetDetail" type="java.util.List" required="true"
              description="List of asset in payment document" %>
<%@ attribute name="assetPaymentDistribution" type="java.util.Map" required="true"
              description="Map of asset payment distributions key by AssetPayment and AssetDetail" %>
<%@ attribute name="defaultTabHide" type="java.lang.Boolean" required="false"
              description="Show tab contents indicator" %>
<%@ attribute name="assetPaymentInProcessPayments" type="java.util.List" required="true"
              description="List of in process payments" %>

<c:set var="readOnly" value="${!KualiForm.documentActions[Constants.KUALI_ACTION_CAN_EDIT]}" />

<c:if test="${ (fn:length(assetPaymentDetail) > 0) && (fn:length(assetPaymentAssetDetail) > 0) }">
    <c:set var="assetPaymentAttributes" value="${DataDictionary.AssetPayment.attributes}"/>
    <c:set var="assetPaymentDetailAttributes" value="${DataDictionary.AssetPaymentDetail.attributes}"/>
    <c:set var="assetAttributes" value="${DataDictionary.Asset.attributes}"/>
    <c:set var="dateFormatPattern" value="MM/dd/yyyy"/>

    <kul:tab tabTitle="In Process Payments by Asset" defaultOpen="${!defaultTabHide}" useCurrentTabIndexAsKey="false">
        <div class="tab-container" align="center">
            <table width="100%" cellpadding="0" cellspacing="0" class="datatable">
                <tr>
                    <th class="grid" align="center"><kul:htmlAttributeLabel noColon="true"
                                                                            attributeEntry="${assetAttributes.capitalAssetNumber}"
                                                                            readOnly="true"/></th>
                    <th class="grid" align="center"><kul:htmlAttributeLabel noColon="true"
                                                                            attributeEntry="${assetPaymentDetailAttributes.chartOfAccountsCode}"
                                                                            readOnly="true"/></th>
                    <th class="grid" align="center"><kul:htmlAttributeLabel noColon="true"
                                                                            attributeEntry="${assetPaymentDetailAttributes.accountNumber}"
                                                                            readOnly="true"/></th>
                    <th class="grid" align="center"><kul:htmlAttributeLabel noColon="true"
                                                                            attributeEntry="${assetPaymentDetailAttributes.subAccountNumber}"
                                                                            readOnly="true"/></th>
                    <th class="grid" align="center"><kul:htmlAttributeLabel noColon="true"
                                                                            attributeEntry="${assetPaymentDetailAttributes.financialObjectCode}"
                                                                            readOnly="true"/></th>
                    <th class="grid" align="center"><kul:htmlAttributeLabel noColon="true"
                                                                            attributeEntry="${assetPaymentDetailAttributes.financialSubObjectCode}"
                                                                            readOnly="true"/></th>
                    <th class="grid" align="center"><kul:htmlAttributeLabel noColon="true"
                                                                            attributeEntry="${assetPaymentDetailAttributes.projectCode}"
                                                                            readOnly="true"/></th>
                    <th class="grid" align="center"><kul:htmlAttributeLabel noColon="true"
                                                                            attributeEntry="${assetPaymentDetailAttributes.expenditureFinancialDocumentPostedDate}"
                                                                            readOnly="true"/></th>
                    <th class="grid" align="center"><kul:htmlAttributeLabel noColon="true"
                                                                            attributeEntry="${assetPaymentDetailAttributes.postingYear}"
                                                                            readOnly="true"/></th>
                    <th class="grid" align="center"><kul:htmlAttributeLabel noColon="true"
                                                                            attributeEntry="${assetPaymentDetailAttributes.postingPeriodCode}"
                                                                            readOnly="true"/></th>
                    <th class="grid" align="center"><kul:htmlAttributeLabel noColon="true"
                                                                            attributeEntry="${assetPaymentDetailAttributes.amount}"
                                                                            readOnly="true"/></th>
                </tr>

                <c:set var="pos" value="${-1}"/>
                <%-- These loops exist in AssetPaymentDocumentPreRules as part of a question page. If this is changed,
                     review that code. --%>
                <c:forEach var="assetDetail" items="${assetPaymentAssetDetail}">
                    <c:set var="pos" value="${pos + 1}"/>
                    <c:set var="line" value="${-1}"/>
                    <c:forEach var="payment" items="${assetPaymentDetail}">
                        <c:if test="${not empty assetPaymentDistribution[payment.assetPaymentDetailKey][assetDetail]}">
                            <c:set var="line" value="${line + 1}"/>
                            <c:set var="object" value="document.sourceAccountingLine[${line}]"/>
                            <c:set var="allocatedAmount" value="${assetPaymentDistribution[payment.assetPaymentDetailKey][assetDetail]}"/>
                            <fmt:formatNumber var="formattedAllocatedAmount"
                                              value="${assetPaymentDistribution[payment.assetPaymentDetailKey][assetDetail]}"
                                              maxFractionDigits="2" minFractionDigits="2" type="number"/>
                            <tr>
                                <td class="grid">
                                    <kul:htmlControlAttribute
                                            property="document.assetPaymentAssetDetail[${pos}].capitalAssetNumber"
                                            attributeEntry="${assetAttributes.capitalAssetNumber}" readOnly="true"
                                            readOnlyBody="true">
                                        <kul:inquiry boClassName="org.kuali.kfs.module.cam.businessobject.Asset"
                                                     keyValues="capitalAssetNumber=${KualiForm.document.assetPaymentAssetDetail[pos].capitalAssetNumber}&versionNumber=${KualiForm.document.assetPaymentAssetDetail[pos].asset.versionNumber}"
                                                     render="true">
                                            <html:hidden write="true"
                                                         property="document.assetPaymentAssetDetail[${pos}].capitalAssetNumber"/>
                                        </kul:inquiry>&nbsp;
                                    </kul:htmlControlAttribute>
                                </td>

                                <td class="grid"><kul:htmlControlAttribute property="${object}.chartOfAccountsCode"
                                                                           attributeEntry="${assetPaymentDetailAttributes.chartOfAccountsCode}"
                                                                           readOnly="true"/></td>
                                <td class="grid">
                                    <kul:htmlControlAttribute property="${object}.accountNumber"
                                                              attributeEntry="${assetPaymentDetailAttributes.accountNumber}"
                                                              readOnly="true" readOnlyBody="true">
                                        <kul:inquiry boClassName="org.kuali.kfs.coa.businessobject.Account"
                                                     keyValues="chartOfAccountsCode=${KualiForm.document.sourceAccountingLines[line].chartOfAccountsCode}&amp;accountNumber=${KualiForm.document.sourceAccountingLines[line].accountNumber}"
                                                     render="true">
                                            <html:hidden write="true" property="${object}.accountNumber"/>
                                        </kul:inquiry>&nbsp;
                                    </kul:htmlControlAttribute>
                                </td>
                                <td class="grid"><c:out value="${payment.subAccountNumber}"/>&nbsp;</td>
                                <td class="grid"><c:out value="${payment.financialObjectCode}"/>&nbsp;</td>
                                <td class="grid"><c:out value="${payment.financialSubObjectCode}"/>&nbsp;</td>
                                <td class="grid"><c:out value="${payment.projectCode}"/>&nbsp;</td>
                                <td class="grid"><fmt:formatDate
                                        value="${payment.expenditureFinancialDocumentPostedDate}"
                                        pattern="${dateFormatPattern}"/></td>
                                <td class="grid"><c:out value="${payment.postingYear}"/></td>
                                <td class="grid"><c:out value="${payment.postingPeriodCode}"/></td>
                                <td class="grid">
                                    <div align="right">${formattedAllocatedAmount}</div>
                                </td>
                            </tr>
                            <tr>
                                <td class="grid" colspan="11">
                                    <kul:errors keyMatch="inProcessPaymentErrorSection.${assetDetail.capitalAssetNumber}.${payment.sequenceNumber}" displayInDiv="true"/>
                                </td>
                            </tr>
                            <tr>
                                <td class="grid"/>
                                <td class="grid" colspan="11">
                                    <c:choose>
                                        <c:when test="${readOnly}">
                                            Asset Payment Lines
                                        </c:when>
                                        <c:otherwise>
                                            Look Up/Add Multiple Asset Payment Lines
                                            <kul:multipleValueLookup boClassName="org.kuali.kfs.module.cam.businessobject.AssetPayment" lookedUpCollectionName="assetPaymentInProcessPayments.${assetDetail.capitalAssetNumber}.${payment.sequenceNumber}"
                                                                     lookupParameters="document.assetPaymentAssetDetail[${pos}].capitalAssetNumber:capitalAssetNumber,document.sourceAccountingLines[${line}].chartOfAccountsCode:account.chartOfAccountsCode,document.sourceAccountingLines[${line}].accountNumber:accountNumber,document.sourceAccountingLines[${line}].financialObjectCode:financialObjectCode,'N':transferPaymentCode"
                                                                     autoSearch="yes"/>
                                        </c:otherwise>
                                    </c:choose>
                                </td>
                            </tr>
                            <c:set var="totalSelectedPaymentAmount" value="${0.00}"/>
                            <c:forEach var="assetPaymentInProcessPayment" items="${assetPaymentInProcessPayments}">
                                <c:if test="${assetPaymentInProcessPayment.capitalAssetNumber == assetDetail.capitalAssetNumber && assetPaymentInProcessPayment.sequenceNumber == payment.sequenceNumber}">
                                    <tr>
                                        <td class="grid" colspan="5"/>
                                        <td class="grid" colspan="2">
                                            <kul:htmlAttributeLabel attributeEntry="${assetPaymentAttributes.paymentSequenceNumber}" readOnly="true" />${assetPaymentInProcessPayment.selectedPaymentSequenceNumber}
                                        </td>
                                        <td class="grid">
                                            <fmt:formatDate value="${assetPaymentInProcessPayment.assetPayment.financialDocumentPostingDate}" pattern="${dateFormatPattern}"/>
                                        </td>
                                        <td class="grid" colspan="2"/>
                                        <td class="grid">
                                            <c:set var="totalSelectedPaymentAmount" value="${totalSelectedPaymentAmount + assetPaymentInProcessPayment.assetPayment.accountChargeAmount}" />
                                            <fmt:formatNumber var="formattedAccountChargeAmount"
                                                              value="${assetPaymentInProcessPayment.assetPayment.accountChargeAmount}"
                                                              maxFractionDigits="2" minFractionDigits="2" type="number"/>
                                            <div align="right">${formattedAccountChargeAmount}</div>
                                        </td>
                                    </tr>
                                </c:if>
                            </c:forEach>
                            <tr>
                                <td class="grid" colspan="5"/>
                                <td class="grid" colspan="2">Total Amount </td>
                                <td class="grid" colspan="5">
                                    <fmt:formatNumber var="formattedTotalSelectedPaymentAmount"
                                                      value="${totalSelectedPaymentAmount}"
                                                      maxFractionDigits="2" minFractionDigits="2" type="number"/>
                                    <div align="right">${formattedTotalSelectedPaymentAmount}</div>
                                </td>
                            </tr>
                        </c:if>
                    </c:forEach>
                </c:forEach>
            </table>
        </div>
    </kul:tab>
</c:if>
