/**
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2018 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.web;

import com.google.gson.Gson;
import org.kuali.kfs.krad.util.ObjectUtils;

import javax.servlet.jsp.PageContext;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.Map;

public class JavascriptUtils {
    private static final String WEBPACK_MANIFEST_FILE = "build/webpack.manifest.json";
    private static Map<String, String> manifestMapping;

    public static Map<String, String> getManifestMapping(String manifestPath) throws FileNotFoundException {
        if (ObjectUtils.isNull(manifestMapping)) {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(manifestPath));
            Gson gson = new Gson();
            manifestMapping = gson.fromJson(bufferedReader, Map.class);
        }
        return manifestMapping;
    }
    
    public static String getManifestResource(PageContext pageContext, String bundleName) throws FileNotFoundException {
        String manifestPath = pageContext.getServletContext().getRealPath("/") + WEBPACK_MANIFEST_FILE;
        String hashedBundleName = getManifestMapping(manifestPath).get(bundleName);
        return pageContext.getServletContext().getContextPath() + "/build/" + hashedBundleName;
    }
}
