/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.web;

import javax.servlet.ServletContext;
import javax.servlet.jsp.PageContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.web.JavascriptUtils;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class JavascriptUtilsTest {
    @Mock
    private PageContext pageContextMock;
    @Mock
    private ServletContext servletContextMock;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.pageContextMock.getServletContext()).thenReturn((Object)this.servletContextMock);
        String testManifestPath = this.getClass().getClassLoader().getResource("org.kuali.kfs.web/").getPath();
        Mockito.when((Object)this.servletContextMock.getRealPath(Mockito.anyString())).thenReturn((Object)testManifestPath);
        Mockito.when((Object)this.servletContextMock.getContextPath()).thenReturn((Object)"");
    }

    @Test
    public void validBundle() throws Exception {
        Assert.assertEquals((Object)"/build/test.12345.bundle.js", (Object)JavascriptUtils.getManifestResource((PageContext)this.pageContextMock, (String)"test.js"));
    }

    @Test
    public void invalidBundle() throws Exception {
        Assert.assertEquals((Object)"/build/null", (Object)JavascriptUtils.getManifestResource((PageContext)this.pageContextMock, (String)"invalid.js"));
    }
}

