/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2020 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.rice.kew.service.impl;

import org.apache.commons.lang3.StringUtils;
import org.kuali.rice.kim.api.KimConstants;
import org.kuali.rice.kim.api.permission.Permission;
import org.kuali.kfs.kns.kim.permission.PermissionTypeServiceBase;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * Gives people with a Backdoor Restriction permission the ability to backdoor as anyone
 *
 * @author IU Kuali Rice Team (rice.collab@kuali.org)
 */

public class BackdoorRestrictionPermissionTypeServiceImpl extends PermissionTypeServiceBase {
    @Override
    protected List<Permission> performPermissionMatches(Map<String, String> requestedDetails,
            List<Permission> permissionsList) {
        // pull all the potential app codes from the permission list
        Set<String> permissionAppCodes = new HashSet<String>(permissionsList.size());
        for (Permission permission : permissionsList) {
            String appCode = permission.getAttributes().get(KimConstants.AttributeConstants.APP_CODE);
            if (StringUtils.isNotBlank(appCode)) {
                permissionAppCodes.add(appCode);
            }
        }
        String requestedAppCode = requestedDetails.get(KimConstants.AttributeConstants.APP_CODE);
        // re-loop over the permissions and build a new list of the ones which have the
        // matching app codes in their details
        List<Permission> matchingPermissions = new ArrayList<Permission>();
        for (Permission permission : permissionsList) {
            String currentAppCode = permission.getAttributes().get(KimConstants.AttributeConstants.APP_CODE);
            if (StringUtils.isNotEmpty(requestedAppCode) && requestedAppCode.equals(currentAppCode)) {
                matchingPermissions.add(permission);
            }
        }

        return matchingPermissions;
    }
}

