/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.web.filter;

import java.io.IOException;
import java.util.Locale;
import java.util.Optional;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.kns.bo.AuthenticationValidationResponse;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.krad.exception.AuthenticationException;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.KRADUtils;
import org.kuali.kfs.krad.web.filter.LoginFilterBase;
import org.kuali.kfs.sys.businessobject.JwtData;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.CoreApiKeyAuthenticationService;
import org.kuali.kfs.sys.service.JwtService;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.kim.api.identity.AuthenticationService;

public class ResourceLoginFilter
extends LoginFilterBase {
    private static final Logger LOG = LogManager.getLogger(ResourceLoginFilter.class);
    public static final String UNAUTHORIZED_JSON = "[ \"Unauthorized\" ]";
    public static final String FORBIDDEN_JSON = "[ \"Forbidden\" ]";

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.doFilter((HttpServletRequest)request, (HttpServletResponse)response, chain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        LOG.debug("doFilter() started");
        try {
            Optional user = this.getPrincipalNameFromRequest(request);
            if (!user.isPresent()) {
                this.sendError(response);
                this.removeFromMDC();
                return;
            }
            if (this.isInactive((String)user.get())) {
                this.sendForbidden(response);
                this.removeFromMDC();
                return;
            }
            this.setUserSession(request, (String)user.get());
            this.establishUserSession(request, response);
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (IllegalArgumentException | AuthenticationException e) {
            LOG.error("doFilter() AuthenticationException", e);
            this.sendError(response);
        }
        finally {
            this.removeFromMDC();
        }
    }

    protected boolean isInactive(String principalName) {
        AuthenticationValidationResponse validationResponse = this.getCfAuthenticationService().validatePrincipalName(principalName);
        return validationResponse == AuthenticationValidationResponse.INVALID_PRINCIPAL_CANNOT_LOGIN;
    }

    protected void establishUserSession(HttpServletRequest request, HttpServletResponse response) {
        UserSession userSession = KRADUtils.getUserSessionFromRequest((HttpServletRequest)request);
        if (userSession != null) {
            GlobalVariables.setUserSession((UserSession)userSession);
        }
        this.establishSessionCookie(request, response);
        this.establishBackdoorUser(request);
        this.addToMDC(request);
    }

    private Optional<String> getPrincipalNameFromRequest(HttpServletRequest request) {
        Optional<String> user = Optional.empty();
        String authorizationHeader = request.getHeader("Authorization");
        if (StringUtils.isNotBlank((CharSequence)authorizationHeader)) {
            user = this.getPrincipalNameFromHeader(authorizationHeader);
        } else if (this.isUserSessionEstablished(request)) {
            UserSession userSession = KRADUtils.getUserSessionFromRequest((HttpServletRequest)request);
            user = Optional.of(userSession.getPrincipalName());
        }
        return user;
    }

    private Optional<String> getPrincipalNameFromHeader(String authorizationHeader) {
        if (authorizationHeader == null) {
            return Optional.empty();
        }
        Optional oKey = this.getApiKey(authorizationHeader);
        if (oKey.isPresent()) {
            if (this.getCoreApiKeyAuthenticationService().useCore()) {
                return this.getCoreApiKeyAuthenticationService().getPrincipalIdFromApiKey((String)oKey.get());
            }
            try {
                JwtData data = this.getJwtService().decodeJwt((String)oKey.get());
                return Optional.of(data.getPrincipalName());
            }
            catch (RuntimeException e) {
                LOG.debug("getPrincipalNameFromHeader() invalid financials token", (Throwable)e);
            }
        }
        return Optional.empty();
    }

    private void sendError(HttpServletResponse response) throws IOException {
        response.setStatus(401);
        response.getWriter().println(UNAUTHORIZED_JSON);
    }

    private void sendForbidden(HttpServletResponse response) throws IOException {
        response.setStatus(403);
        response.getWriter().println(FORBIDDEN_JSON);
    }

    protected void setUserSession(HttpServletRequest request, String principalName) {
        UserSession userSession = KRADUtils.getUserSessionFromRequest((HttpServletRequest)request);
        if (userSession == null || userSession.getActualPerson() == null || !StringUtils.equals((CharSequence)userSession.getActualPerson().getPrincipalName(), (CharSequence)principalName)) {
            UserSession newUserSession = new UserSession(principalName);
            request.getSession().setAttribute("cf.UserSession", (Object)newUserSession);
        }
    }

    private Optional<String> getApiKey(String authorizationHeader) {
        if (!authorizationHeader.toLowerCase(Locale.US).startsWith("bearer")) {
            LOG.error("getApiKey() authorization header missing Bearer prefix");
            return Optional.empty();
        }
        String[] split = authorizationHeader.split("\\s+");
        if (split.length != 2) {
            LOG.error("doFilter() authorization header should be two parts");
            return Optional.empty();
        }
        return Optional.of(split[1]);
    }

    protected CoreApiKeyAuthenticationService getCoreApiKeyAuthenticationService() {
        return (CoreApiKeyAuthenticationService)SpringContext.getBean(CoreApiKeyAuthenticationService.class);
    }

    protected JwtService getJwtService() {
        return (JwtService)SpringContext.getBean(JwtService.class);
    }

    protected AuthenticationService getAuthenticationService() {
        return (AuthenticationService)GlobalResourceLoader.getResourceLoader().getService(new QName("kimAuthenticationService"));
    }
}

