<%--

    The Kuali Financial System, a comprehensive financial management system for higher education.

    Copyright 2005-2020 Kuali, Inc.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

--%>
<style type="text/css">
  select.fixed-size-200-select {
    width:200px;
   }
</style>

<%@ include file="/kr/WEB-INF/jsp/tldHeader.jsp"%>
<c:set var="docAddressAttributes" value="${DataDictionary.PersonDocumentAddress.attributes}" />

<c:set var="canModify" scope="request" value="${!KualiForm.document.privacy.suppressAddress || KualiForm.canOverrideEntityPrivacyPreferences}" />
<c:set var="maskData" value="${KualiForm.document.privacy.suppressAddress && !KualiForm.canOverrideEntityPrivacyPreferences}" />

<kul:subtab lookedUpCollectionName="address" width="${tableWidth}" subTabTitle="Addresses" noShowHideButton="true">      
    <table class="standard side-margins">
        <tr>
            <th><div align="left">&nbsp;</div></th>
            <kim:cell inquiry="${inquiry}" isLabel="true" textAlign="left" attributeEntry="${docAddressAttributes.addressTypeCode}" noColon="true" />
            <kim:cell inquiry="${inquiry}" isLabel="true" textAlign="left" attributeEntry="${docAddressAttributes.line1}" noColon="true" />
            <kim:cell inquiry="${inquiry}" isLabel="true" textAlign="left" attributeEntry="${docAddressAttributes.line2}" noColon="true" />
            <kim:cell inquiry="${inquiry}" isLabel="true" textAlign="left" attributeEntry="${docAddressAttributes.line3}" noColon="true" />
            <kim:cell inquiry="${inquiry}" isLabel="true" textAlign="left" attributeEntry="${docAddressAttributes.city}" noColon="true" />
            <kim:cell inquiry="${inquiry}" isLabel="true" textAlign="left" attributeEntry="${docAddressAttributes.stateProvinceCode}" noColon="true" />
            <kim:cell inquiry="${inquiry}" isLabel="true" textAlign="left" attributeEntry="${docAddressAttributes.postalCode}" noColon="true" />
            <kim:cell inquiry="${inquiry}" isLabel="true" textAlign="left" attributeEntry="${docAddressAttributes.countryCode}" noColon="true" />
            <kim:cell inquiry="${inquiry}" isLabel="true" textAlign="left" attributeEntry="${docAddressAttributes.dflt}" noColon="true" />
            <kim:cell inquiry="${inquiry}" isLabel="true" textAlign="left" attributeEntry="${docAddressAttributes.active}" noColon="true" />
            <c:if test="${not inquiry and canModify}">  
                <kul:htmlAttributeHeaderCell literalLabel="Actions" scope="col"/>
            </c:if>
        </tr>
        <c:if test="${not inquiry and not readOnlyEntity and canModify}">
             <tr>
                <th class="infoline">
                    <c:out value="Add:" />
                </th>
                <td>
                    <div align="left">
                        <kul:htmlControlAttribute property="newAddress.addressTypeCode" attributeEntry="${docAddressAttributes.addressTypeCode}" readOnly="${readOnlyEntity}" />
                    </div>
                </td>
                <td>
                    <div align="left">
                        <kul:htmlControlAttribute property="newAddress.line1" attributeEntry="${docAddressAttributes.line1}" readOnly="${readOnlyEntity}" />
                    </div>
                </td>
                <td>
                    <div align="left">
                      <kul:htmlControlAttribute property="newAddress.line2" attributeEntry="${docAddressAttributes.line2}" readOnly="${readOnlyEntity}" />
                    </div>
                </td>
                <td>
                    <div align="left"><kul:htmlControlAttribute property="newAddress.line3" attributeEntry="${docAddressAttributes.line3}" readOnly="${readOnlyEntity}" />
                </div>
                </td>
                <td>
                    <div align="left"><kul:htmlControlAttribute property="newAddress.city" attributeEntry="${docAddressAttributes.city}" readOnly="${readOnlyEntity}" />
                    </div>
                </td>
                <td>
                    <div align="left"><kul:htmlControlAttribute property="newAddress.stateProvinceCode" attributeEntry="${docAddressAttributes.stateProvinceCode}" styleClass="fixed-size-200-select" readOnly="${readOnlyEntity}" />
                    </div>
                </td>
                <td>
                    <div align="left"><kul:htmlControlAttribute property="newAddress.postalCode" attributeEntry="${docAddressAttributes.postalCode}" readOnly="${readOnlyEntity}" />
                    </div>
                </td>
                <td>
                    <div align="left"><kul:htmlControlAttribute property="newAddress.countryCode" attributeEntry="${docAddressAttributes.countryCode}" styleClass="fixed-size-200-select" readOnly="${readOnlyEntity}" />
                    </div>
                </td>
                <td>
                    <div align="left"><kul:htmlControlAttribute property="newAddress.dflt" attributeEntry="${docAddressAttributes.dflt}" readOnly="${readOnlyEntity}" />
                    </div>
                </td>
                <td>
                    <div align="left"><kul:htmlControlAttribute property="newAddress.active" attributeEntry="${docAddressAttributes.active}" readOnly="${readOnlyEntity}" />
                    </div>
                </td>
                <td>
                    <div align="left">
                        <html:submit property="methodToCall.addAddress.anchor${tabKey}"
                        value="Add" styleClass="btn btn-green"/>
                    </div>
                </td>
            </tr>
        </c:if>
        <c:forEach var="address" items="${KualiForm.document.addrs}" varStatus="status">
            <c:if test="${!(inquiry and readOnlyEntity and kfunc:isHiddenKimObjectType(address.addressType.code, 'kim.hide.PersonDocumentAddress.type'))}">
              <tr>
                <th class="infoline">
                    <c:out value="${status.index+1}" />
                </th>
                <kim:cell inquiry="${inquiry}" valign="middle" cellClass="infoline" textAlign="left" property="document.addrs[${status.index}].addressTypeCode" attributeEntry="${docAddressAttributes.addressTypeCode}" readOnlyAlternateDisplay="${fn:escapeXml(address.addressType.name)}" readOnly="${readOnlyEntity or !canModify}" />
                <kim:cell inquiry="${inquiry}" valign="middle" cellClass="infoline" textAlign="left" property="document.addrs[${status.index}].line1" attributeEntry="${docAddressAttributes.line1}" readOnly="${readOnlyEntity or !canModify}" displayMask="${maskData}" displayMaskValue="Xxxxxxx" />
                <kim:cell inquiry="${inquiry}" valign="middle" cellClass="infoline" textAlign="left" property="document.addrs[${status.index}].line2" attributeEntry="${docAddressAttributes.line2}" readOnly="${readOnlyEntity or !canModify}" displayMask="${maskData}" displayMaskValue="Xxxxxxx" />
                <kim:cell inquiry="${inquiry}" valign="middle" cellClass="infoline" textAlign="left" property="document.addrs[${status.index}].line3" attributeEntry="${docAddressAttributes.line3}" readOnly="${readOnlyEntity or !canModify}" displayMask="${maskData}" displayMaskValue="Xxxxxxx" />
                <kim:cell inquiry="${inquiry}" valign="middle" cellClass="infoline" textAlign="left" property="document.addrs[${status.index}].city" attributeEntry="${docAddressAttributes.city}" readOnly="${readOnlyEntity or !canModify}" displayMask="${maskData}" displayMaskValue="Xxxxxxx" />
                <kim:cell inquiry="${inquiry}" valign="middle" cellClass="infoline" textAlign="left" property="document.addrs[${status.index}].stateProvinceCode" attributeEntry="${docAddressAttributes.stateProvinceCode}" styleClass="fixed-size-200-select" readOnly="${readOnlyEntity or !canModify}" displayMask="${maskData}" displayMaskValue="XX" />
                <kim:cell inquiry="${inquiry}" valign="middle" cellClass="infoline" textAlign="left" property="document.addrs[${status.index}].postalCode" attributeEntry="${docAddressAttributes.postalCode}" readOnly="${readOnlyEntity or !canModify}" displayMask="${maskData}" displayMaskValue="XXXXX" />
                <kim:cell inquiry="${inquiry}" valign="middle" cellClass="infoline" textAlign="left" property="document.addrs[${status.index}].countryCode" attributeEntry="${docAddressAttributes.countryCode}" styleClass="fixed-size-200-select" readOnly="${readOnlyEntity or !canModify}" displayMask="${maskData}" displayMaskValue="XX" />
                <kim:cell inquiry="${inquiry}" valign="middle" cellClass="infoline" textAlign="left" property="document.addrs[${status.index}].dflt" attributeEntry="${docAddressAttributes.dflt}" readOnly="${readOnlyEntity or !canModify}" />
                <kim:cell inquiry="${inquiry}" valign="middle" cellClass="infoline" textAlign="left" property="document.addrs[${status.index}].active" attributeEntry="${docAddressAttributes.active}" readOnly="${readOnlyEntity or !canModify}" />

                <c:if test="${not inquiry and canModify}">
                    <td>
                        <div align="left">&nbsp;
                             <c:choose>
                               <c:when test="${address.edit or readOnlyEntity}">
                                   <button class="btn btn-red" disabled>Delete</button>
                               </c:when>
                               <c:otherwise>
                                  <html:submit property='methodToCall.deleteAddress.line${status.index}.anchor${currentTabIndex}'
                                        value="Delete" styleClass='btn btn-red'/>
                               </c:otherwise>
                             </c:choose>
                        </div>
                    </td>
                </c:if>
              </tr>
            </c:if>
        </c:forEach>

    </table>
</kul:subtab>
