/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2021 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.rice.kew.service.impl;

import org.apache.commons.lang3.StringUtils;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.kfs.kim.api.KimConstants;
import org.kuali.rice.kim.api.permission.Permission;
import org.kuali.kfs.kim.framework.permission.PermissionTypeService;
import org.kuali.kfs.kim.impl.permission.PermissionBo;
import org.kuali.kfs.krad.kim.DocumentTypePermissionTypeServiceImpl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * This is a description of what this class does - jonathan don't forget to fill
 * this in.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */
public class AdhocReviewPermissionTypeServiceImpl extends DocumentTypePermissionTypeServiceImpl implements PermissionTypeService {

    @Override
    protected List<String> getRequiredAttributes() {
        final List<String> attrs = new ArrayList<String>(super.getRequiredAttributes());
        attrs.add(KimConstants.AttributeConstants.ACTION_REQUEST_CD);
        return Collections.unmodifiableList(attrs);
    }

    @Override
    public List<Permission> performPermissionMatches(
            Map<String, String> requestedDetails,
            List<Permission> permissionsList) {

        if (permissionsList == null) {
            throw new RiceIllegalArgumentException("permissionsList was null or blank");
        }

        if (requestedDetails == null) {
            throw new RiceIllegalArgumentException("requestedDetails was null");
        }

        List<Permission> matchingPermissions = new ArrayList<Permission>();
        // loop over the permissions, checking the non-document-related ones
        for (Permission kpi : permissionsList) {
            PermissionBo bo = PermissionBo.from(kpi);
            if (!bo.getDetails().containsKey(KimConstants.AttributeConstants.ACTION_REQUEST_CD)
                    || StringUtils.equals(bo.getDetails().get(KimConstants.AttributeConstants.ACTION_REQUEST_CD),
                    requestedDetails.get(KimConstants.AttributeConstants.ACTION_REQUEST_CD))) {
                matchingPermissions.add(kpi);
            }
        }
        // now, filter the list to just those for the current document
        matchingPermissions = super.performPermissionMatches(requestedDetails, matchingPermissions);
        return matchingPermissions;
    }
}
