/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2021 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.web;

import com.fasterxml.jackson.databind.json.JsonMapper;
import org.kuali.kfs.krad.util.ObjectUtils;

import javax.servlet.jsp.PageContext;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public final class JavascriptUtils {

    private static final JsonMapper MAPPER = new JsonMapper();
    private static final String WEBPACK_MANIFEST_FILE = "build/webpack.manifest.json";

    private static Map<String, String> manifestMapping;

    /**
     * Private Constructor since this is a util class that should never be instantiated.
     */
    private JavascriptUtils() {
    }

    // TODO: Can this be made non-public?
    public static Map<String, String> getManifestMapping(String manifestPath) throws IOException {
        if (ObjectUtils.isNull(manifestMapping)) {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(manifestPath, StandardCharsets.UTF_8));
            manifestMapping = MAPPER.readValue(bufferedReader, Map.class);
        }
        return manifestMapping;
    }

    public static String getManifestResource(PageContext pageContext, String bundleName) throws IOException {
        String manifestPath = pageContext.getServletContext().getRealPath("/") + WEBPACK_MANIFEST_FILE;
        String hashedBundleName = getManifestMapping(manifestPath).get(bundleName);
        return pageContext.getServletContext().getContextPath() + "/build/" + hashedBundleName;
    }
}
