<%--

    The Kuali Financial System, a comprehensive financial management system for higher education.

    Copyright 2005-2021 Kuali, Inc.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

--%>
<%@ include file="/jsp/sys/kfsTldHeader.jsp" %>

<c:set var="methodCall" value="${MessageQueueForm.messageQueueFromDatabase.methodCall}" />

<style type="text/css">
	table.standard tr td {
        padding: 8px;
	}
	#lookup table.standard th {
		text-align: left;
        padding: 8px;
	}
</style>
<kul:page
	showDocumentInfo="false"
	docTitle="Message View"
	headerTitle="Message"
	transactionalDocument="false"
	htmlFormAction="MessageQueue"
>
    <div>
		<jsp:include page="../Messages.jsp" flush="true" />
	</div>

	<div id="view_div" class="main-panel search-results" style="padding-left: 5%;">
		<div id="lookup">
			<table class="standard side-margins" style="width: 800px;">
				<tr>
					<th colspan="2"><h2>Message</h2></th>
				</tr>
				<tr class="even">
					<td>Message Queue Id:</td>
					<td><c:out value="${MessageQueueForm.messageQueueFromForm.routeQueueId}" /></td>
				</tr>
				<tr class="odd">
					<td>Status:</td>
					<td><c:out value="${MessageQueueForm.messageQueueFromForm.queueStatus}" /></td>
				</tr>
				<tr class="even">
					<td>Date:</td>
					<td><fmt:formatDate value="${MessageQueueForm.messageQueueFromForm.queueDate}" pattern="${KFSConstants.DEFAULT_DATE_FORMAT_PATTERN}" /></td>
				</tr>
				<tr class="odd">
					<td>Expiration Date:</td>
					<td><fmt:formatDate value="${MessageQueueForm.messageQueueFromForm.expirationDate}" pattern="${KFSConstants.DEFAULT_DATE_FORMAT_PATTERN}" /></td>
				</tr>
				<tr class="even">
					<td>Priority:</td>
					<td><c:out value="${MessageQueueForm.messageQueueFromForm.queuePriority}" /></td>
				</tr>
				<tr class="odd">
					<td>Retry Count:</td>
					<td><c:out value="${MessageQueueForm.messageQueueFromForm.retryCount}" /></td>
				</tr>
				<tr class="even">
					<td>IP Number:</td>
					<td><c:out value="${MessageQueueForm.messageQueueFromForm.ipNumber}" /></td>
				</tr>
				<tr class="odd">
					<td>Service Name:</td>
					<td><c:out value="${MessageQueueForm.messageQueueFromForm.serviceName}" /></td>
				</tr>
				<tr class="even">
					<td>Method Name:</td>
					<td><c:out value="${MessageQueueForm.messageQueueFromForm.methodName}" /></td>
				</tr>
				<tr class="odd">
					<td>App Specific Value 1:</td>
					<td><c:out value="${MessageQueueForm.messageQueueFromForm.value1}" /></td>
				</tr>
				<tr class="even">
					<td>App Specific Value 2:</td>
					<td><c:out value="${MessageQueueForm.messageQueueFromForm.value2}" /></td>
				</tr>

				<tr>
					<th colspan="2" style="padding-top: 24px;"><h2>Payload</h2></th>
				</tr>

				<tr class="odd">
					<td>Payload Class:</td>
					<td><c:out value="${methodCall['class']}" /></td>
				</tr>
				<tr class="even">
					<td>Method Name</td>
					<td><c:out value="${methodCall.methodName}" /></td>
				</tr>
				<tr class="odd">
					<td>Arguments:</td>
					<c:choose>
						<c:when test="${(empty methodCall.arguments) || (empty methodCall.paramTypes)}">
							<td>No Arguments</td>
						</c:when>
						<c:otherwise>
							<td>
								<c:forEach items="methodCall.arguments" var="serviceInterface" varStatus="x">
									[<c:out value="${methodCall.paramTypes[x.index].name}" />] <c:out value="${methodCall.arguments[x.index]}" />&nbsp;<br />
								</c:forEach>
							</td>
						</c:otherwise>
					</c:choose>
				</tr>
			</table>
		</div>
	</div>
</kul:page>
