<%--

    The Kuali Financial System, a comprehensive financial management system for higher education.

    Copyright 2005-2021 Kuali, Inc.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

--%>
<%@ include file="/jsp/sys/kfsTldHeader.jsp"%>

<%@ attribute name="afflnIdx" required="true" description="In the array of affiliations on the IdentityManagementPersonDocument, the index of the affiliation to display employee information records for." %>
<c:set var="docEmploymentInfoAttributes" value="${DataDictionary.PersonDocumentEmploymentInfo.attributes}" />

<kul:subtab lookedUpCollectionName="empInfo" width="${tableWidth}" subTabTitle="Employment Information">      
	<table class="standard side-margins">
       	<tr>
            <th width="5%" rowspan="20" style="border-style:none">&nbsp;</th>
       		<th><div align="left">&nbsp</div></th>
       		<kim:cell inquiry="${inquiry}" isLabel="true" attributeEntry="${docEmploymentInfoAttributes.employeeId}" noColon="true" />
       		<kim:cell inquiry="${inquiry}" isLabel="true" attributeEntry="${docEmploymentInfoAttributes.primary}" noColon="true" />
       		<kim:cell inquiry="${inquiry}" isLabel="true" attributeEntry="${docEmploymentInfoAttributes.employmentStatusCode}" noColon="true" />
       		<kim:cell inquiry="${inquiry}" isLabel="true" attributeEntry="${docEmploymentInfoAttributes.employmentTypeCode}" noColon="true" />
       		<kim:cell inquiry="${inquiry}" isLabel="true" attributeEntry="${docEmploymentInfoAttributes.baseSalaryAmount}" noColon="true" />
       		<kim:cell inquiry="${inquiry}" isLabel="true" attributeEntry="${docEmploymentInfoAttributes.primaryDepartmentCode}" noColon="true" />
	        <c:if test="${not inquiry}">	
	              	<kul:htmlAttributeHeaderCell literalLabel="Actions" scope="col"/>
	        </c:if>
        </tr>     
      	<c:if test="${not inquiry and not readOnlyEntity}">	          	
             <tr>
				<th class="infoline">Add:</th>
				
				<kim:cell inquiry="${inquiry}" valign="middle" cellClass="infoline" textAlign="center" property="document.affiliations[${afflnIdx}].newEmpInfo.employeeId" attributeEntry="${docEmploymentInfoAttributes.employeeId}" readOnly="${readOnlyEntity}" />
				<kim:cell inquiry="${inquiry}" valign="middle" cellClass="infoline" textAlign="center" property="document.affiliations[${afflnIdx}].newEmpInfo.primary" attributeEntry="${docEmploymentInfoAttributes.primary}" readOnly="${readOnlyEntity}" /> 
                <kim:cell inquiry="${inquiry}" valign="middle" cellClass="infoline" textAlign="center" property="document.affiliations[${afflnIdx}].newEmpInfo.employmentStatusCode" attributeEntry="${docEmploymentInfoAttributes.employmentStatusCode}" readOnly="${readOnlyEntity}" />
                <kim:cell inquiry="${inquiry}" valign="middle" cellClass="infoline" textAlign="center" property="document.affiliations[${afflnIdx}].newEmpInfo.employmentTypeCode" attributeEntry="${docEmploymentInfoAttributes.employmentTypeCode}" readOnly="${readOnlyEntity}" />
                <kim:cell inquiry="${inquiry}" valign="middle" cellClass="infoline" textAlign="center" property="document.affiliations[${afflnIdx}].newEmpInfo.baseSalaryAmount" attributeEntry="${docEmploymentInfoAttributes.baseSalaryAmount}" readOnly="${readOnlyEntity}" />
                <kim:cell inquiry="${inquiry}" valign="middle" cellClass="infoline" textAlign="center" property="document.affiliations[${afflnIdx}].newEmpInfo.primaryDepartmentCode" attributeEntry="${docEmploymentInfoAttributes.primaryDepartmentCode}" readOnly="${readOnlyEntity}" />              
                <td class="infoline">
					<div align="center">
						<html:submit property="methodToCall.addEmpInfo.line${afflnIdx}.anchor${tabKey}"
						value="Add" styleClass="btn btn-green"/>
					</div>
                </td>
       		</tr>         
  		</c:if>          
    	<c:forEach var="empInfo" items="${KualiForm.document.affiliations[afflnIdx].empInfos}" varStatus="status">
	       	<tr>
                <th><div align="left">&nbsp</div></th>
                <kim:cell inquiry="${inquiry}" valign="middle" cellClass="infoline" textAlign="center" property="document.affiliations[${afflnIdx}].empInfos[${status.index}].employeeId"  attributeEntry="${docEmploymentInfoAttributes.employeeId}" readOnly="${readOnlyEntity}" />
                <kim:cell inquiry="${inquiry}" valign="middle" cellClass="infoline" textAlign="center" property="document.affiliations[${afflnIdx}].empInfos[${status.index}].primary" attributeEntry="${docEmploymentInfoAttributes.primary}" readOnly="${readOnlyEntity}" />
                <kim:cell inquiry="${inquiry}" valign="middle" cellClass="infoline" textAlign="center" property="document.affiliations[${afflnIdx}].empInfos[${status.index}].employmentStatusCode" attributeEntry="${docEmploymentInfoAttributes.employmentStatusCode}"  readOnlyAlternateDisplay="${fn:escapeXml(empInfo.employmentStatus.name)}" readOnly="${readOnlyEntity}" />
                <kim:cell inquiry="${inquiry}" valign="middle" cellClass="infoline" textAlign="center" property="document.affiliations[${afflnIdx}].empInfos[${status.index}].employmentTypeCode" attributeEntry="${docEmploymentInfoAttributes.employmentTypeCode}" readOnlyAlternateDisplay="${fn:escapeXml(empInfo.employmentType.name)}" readOnly="${readOnlyEntity}" />
                <kim:cell inquiry="${inquiry}" valign="middle" cellClass="infoline" textAlign="center" property="document.affiliations[${afflnIdx}].empInfos[${status.index}].baseSalaryAmount" attributeEntry="${docEmploymentInfoAttributes.baseSalaryAmount}" readOnly="${readOnlyEntity}" />
                <kim:cell inquiry="${inquiry}" valign="middle" cellClass="infoline" textAlign="center" property="document.affiliations[${afflnIdx}].empInfos[${status.index}].primaryDepartmentCode" attributeEntry="${docEmploymentInfoAttributes.primaryDepartmentCode}" readOnly="${readOnlyEntity}" />
                <c:if test="${not inquiry}">
                    <td>
                        <div align=center>&nbsp;
                             <c:choose>
                                <c:when test="${empInfo.edit  or readOnlyEntity}">
                                  <button class="btn btn-red" disabled>Delete</button>
                                </c:when>
                                <c:otherwise>
                                  <html:submit property='methodToCall.deleteEmpInfo.line${afflnIdx}:${status.index}.anchor${currentTabIndex}'
                                        value="Delete" styleClass='btn btn-red'/>
                                </c:otherwise>
                             </c:choose>
                        </div>
                    </td>
                </c:if>
            </tr>
        </c:forEach>
		<tr>
            <td colspan=10 style="padding:0px; border-style:none; height:22px; background-color:#F6F6F6">&nbsp;</td>
        </tr>            
	</table>
</kul:subtab>
