<%--

    The Kuali Financial System, a comprehensive financial management system for higher education.

    Copyright 2005-2021 Kuali, Inc.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

--%>
<%@ include file="/jsp/sys/kfsTldHeader.jsp"%>

<%@ attribute name="awardAccountAttributes" required="true" type="java.util.Map" description="The DataDictionary entry containing attributes for this row's AwardAccount fields."%>
<%@ attribute name="propertyName" required="true" description="The DataDictionary entry containing attributes for this row's fields."%>
<%@ attribute name="highlight" required="false" description="Boolean to determine if the row should have be highlighted" %>

<c:choose>
    <c:when test="${highlight}">
        <tr class="highlight">
    </c:when>
    <c:otherwise>
        <tr>
    </c:otherwise>
</c:choose>
	<td><kul:htmlControlAttribute attributeEntry="${awardAccountAttributes.proposalNumber}" property="${propertyName}.proposalNumber" readOnly="true" /></td>
	<td><kul:htmlControlAttribute attributeEntry="${awardAccountAttributes.chartOfAccountsCode}" property="${propertyName}.chartOfAccountsCode" readOnly="true" /></td>
	<td><kul:htmlControlAttribute attributeEntry="${awardAccountAttributes.accountNumber}" property="${propertyName}.accountNumber" readOnly="true" /></td>
	<td><kul:htmlControlAttribute attributeEntry="${awardAccountAttributes.awardBeginningDate}" property="${propertyName}.awardBeginningDate" readOnly="true" /></td>
	<td><kul:htmlControlAttribute attributeEntry="${awardAccountAttributes.awardEndingDate}" property="${propertyName}.awardEndingDate" readOnly="true" /></td>
	<td><kul:htmlControlAttribute attributeEntry="${awardAccountAttributes.billingFrequencyCode}" property="${propertyName}.billingFrequencyCode" readOnly="true" /></td>
	<td><kul:htmlControlAttribute attributeEntry="${awardAccountAttributes.instrumentTypeDescription}" property="${propertyName}.instrumentTypeDescription" readOnly="true" /></td>
	<td><kul:htmlControlAttribute attributeEntry="${awardAccountAttributes.invoicingOptionDescription}" property="${propertyName}.invoicingOptionDescription" readOnly="true" /></td>
	<td><kul:htmlControlAttribute attributeEntry="${awardAccountAttributes.awardTotalAmount}" property="${propertyName}.awardTotalAmount" readOnly="true" /></td>
</tr>
