<%--

    The Kuali Financial System, a comprehensive financial management system for higher education.

    Copyright 2005-2021 Kuali, Inc.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

--%>
<%@ include file="/jsp/sys/kfsTldHeader.jsp"%>
<%@ attribute name="defaultTabHide" type="java.lang.Boolean" required="false" description="Show tab contents indicator" %>
<c:set var="equipAttributes" value="${DataDictionary.EquipmentLoanOrReturnDocument.attributes}"/>
<c:set var="readOnly" value="${!KualiForm.documentActions[KRADConstants.KUALI_ACTION_CAN_EDIT]}"/>

<kul:tab tabTitle="Borrower's Address" defaultOpen="true" tabErrorKey="document.borrowerA*,document.borrowerC*,document.borrowerZ*,document.borrowerP*,document.borrowerS*">
    <div class="tab-container" align="center">
        <table class="standard side-margins">
            <tr>
                <td class="tab-subhead" width="50%" colspan="2"><h3>Borrower</h3></td>
                <td class="tab-subhead" width="50%" colspan="2"><h3>Stored at</h3></td>
            </tr>
            <tr>
                <th class="grid right" width="25%"><kul:htmlAttributeLabel attributeEntry="${equipAttributes.borrowerAddress}"/></th>
                <td class="grid" width="25%"><kul:htmlControlAttribute property="document.borrowerAddress" attributeEntry="${equipAttributes.borrowerAddress}" readOnly="${readOnly}"/></td>
                <th class="grid right" width="25%"><kul:htmlAttributeLabel attributeEntry="${equipAttributes.borrowerStorageAddress}" readOnly="true"/></th>
                <td class="grid" width="25%"><kul:htmlControlAttribute property="document.borrowerStorageAddress" attributeEntry="${equipAttributes.borrowerStorageAddress}" readOnly="${readOnly}"/></td>
            </tr>
            <tr>
                <th class="grid right" width="25%"><kul:htmlAttributeLabel attributeEntry="${equipAttributes.borrowerCityName}"/></th>
                <td class="grid" width="25%"><kul:htmlControlAttribute property="document.borrowerCityName" attributeEntry="${equipAttributes.borrowerCityName}" readOnly="${readOnly}"/></td>
                <th class="grid right" width="25%"><kul:htmlAttributeLabel attributeEntry="${equipAttributes.borrowerStorageCityName}" readOnly="true"/></th>
                <td class="grid" width="25%"><kul:htmlControlAttribute property="document.borrowerStorageCityName" attributeEntry="${equipAttributes.borrowerStorageCityName}" readOnly="${readOnly}"/></td>
            </tr>
            <tr>
                <th class="grid right" width="25%"><kul:htmlAttributeLabel attributeEntry="${equipAttributes.borrowerStateCode}"/></th>
                <td class="grid" width="25%"><kul:htmlControlAttribute property="document.borrowerStateCode" attributeEntry="${equipAttributes.borrowerStateCode}" readOnly="${readOnly}"/>
                    <c:if test="${not readOnly}">
                        &nbsp;
                        <kul:lookup boClassName="org.kuali.kfs.sys.businessobject.State"
                                    fieldConversions="code:document.borrowerStateCode"
                                    lookupParameters="document.borrowerCountryCode:countryCode,document.borrowerStateCode:code"/>
                    </c:if>
                </td>
                <th class="grid right" width="25%"><kul:htmlAttributeLabel attributeEntry="${equipAttributes.borrowerStorageStateCode}" readOnly="true"/></th>
                <td class="grid" width="25%"><kul:htmlControlAttribute property="document.borrowerStorageStateCode" attributeEntry="${equipAttributes.borrowerStorageStateCode}" readOnly="${readOnly}"/>
                    <c:if test="${not readOnly}">
                        &nbsp;
                        <kul:lookup boClassName="org.kuali.kfs.sys.businessobject.State"
                                    fieldConversions="code:document.borrowerStorageStateCode"
                                    lookupParameters="document.borrowerStorageCountryCode:countryCode,document.borrowerStorageStateCode:code"/>
                    </c:if>
                </td>
            </tr>
            <tr>
                <th class="grid right" width="25%"><kul:htmlAttributeLabel attributeEntry="${equipAttributes.borrowerZipCode}"/></th>
                <td class="grid" width="25%"><kul:htmlControlAttribute property="document.borrowerZipCode" attributeEntry="${equipAttributes.borrowerZipCode}" readOnly="${readOnly}"/>
                    <c:if test="${not readOnly}">
                        &nbsp;
                        <kul:lookup boClassName="org.kuali.kfs.sys.businessobject.PostalCode"
                                    fieldConversions="code:document.borrowerZipCode"
                                    lookupParameters="document.borrowerCountryCode:countryCode,document.borrowerZipCode:code,document.borrowerStateCode:stateCode"/>
                    </c:if>
                </td>
                <th class="grid right" width="25%"><kul:htmlAttributeLabel attributeEntry="${equipAttributes.borrowerStorageZipCode}" readOnly="true"/></th>
                <td class="grid" width="25%"><kul:htmlControlAttribute property="document.borrowerStorageZipCode" attributeEntry="${equipAttributes.borrowerStorageZipCode}" readOnly="${readOnly}"/>
                    <c:if test="${not readOnly}">
                        &nbsp;
                        <kul:lookup boClassName="org.kuali.kfs.sys.businessobject.PostalCode"
                                    fieldConversions="code:document.borrowerStorageZipCode"
                                    lookupParameters="document.borrowerStorageCountryCode:countryCode,document.borrowerStorageZipCode:code,document.borrowerStorageStateCode:stateCode"/>
                    </c:if>
                </td>
            </tr>
            <tr>
                <th class="grid right" width="25%"><kul:htmlAttributeLabel attributeEntry="${equipAttributes.borrowerCountryCode}"/></th>
                <td class="grid" width="25%"><kul:htmlControlAttribute property="document.borrowerCountryCode" attributeEntry="${equipAttributes.borrowerCountryCode}" readOnly="${readOnly}"/>
                </td>
                <th class="grid right" width="25%"><kul:htmlAttributeLabel attributeEntry="${equipAttributes.borrowerStorageCountryCode}" readOnly="true"/></th>
                <td class="grid" width="25%"><kul:htmlControlAttribute property="document.borrowerStorageCountryCode" attributeEntry="${equipAttributes.borrowerStorageCountryCode}" readOnly="${readOnly}"/>
                </td>
            </tr>
            <tr>
                <th class="grid right" width="25%"><kul:htmlAttributeLabel attributeEntry="${equipAttributes.borrowerPhoneNumber}" readOnly="true"/></th>
                <td class="grid" width="25%"><kul:htmlControlAttribute property="document.borrowerPhoneNumber" attributeEntry="${equipAttributes.borrowerPhoneNumber}" readOnly="${readOnly}"/></td>
                <th class="grid right" width="25%"><kul:htmlAttributeLabel attributeEntry="${equipAttributes.borrowerStoragePhoneNumber}" readOnly="true"/></th>
                <td class="grid" width="25%"><kul:htmlControlAttribute property="document.borrowerStoragePhoneNumber" attributeEntry="${equipAttributes.borrowerStoragePhoneNumber}" readOnly="${readOnly}"/></td>
            </tr>
        </table>
    </div>
</kul:tab>
