<%--

    The Kuali Financial System, a comprehensive financial management system for higher education.

    Copyright 2005-2021 Kuali, Inc.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

--%>
<%@ include file="/jsp/sys/kfsTldHeader.jsp"%>

<script language="JavaScript" src="scripts/kew/documentoperation-common.js"></script>

<kul:tab tabTitle="Branch States" defaultOpen="true">
<div class="tab-container">
  <table class="standard side-margins">
      <c:set var="branchStateIndex" value="0"/>
      <c:choose>
      <c:when test="${empty DocumentOperationForm.branches}">
      <tr><td class="datacell" colspan="2" align="center" height="15">None</td></tr>
      </c:when>
      <c:otherwise>
      <html-el:hidden property="branchStatesDelete" value=""/>
        <logic-el:iterate id="branch" name="DocumentOperationForm" property="branches" indexId="ctr">
          <tr>
            <td width="33%" class="headercell3-b-l" align="right"><b> Branch ID: </b><c:out value="${branch.branchId}" /> </td>
            <td width="66%" class="headercell3-b-l">
              <html-el:radio property="branchOp[${ctr}].value" value="update"/>Update &nbsp;&nbsp;
                <html-el:radio property="branchOp[${ctr}].value" value="noop"/>No Operation&nbsp;&nbsp;
                  <html-el:hidden property="branchOp[${ctr}].index" />
            </td>
          </tr>
          <tr>
            <td width="33%" align="right" class="thnormal">Branch Name:</td>
            <td width="66%" class="datacell"><html-el:text property="branche[${ctr}].name"/></td>
          </tr>
          <c:choose>
          <c:when test="${empty branch.branchState}">
          <tr>
            <td width="33%" align="right" class="thnormal">Branch States:</td>
            <td width="66%" class="datacell">None</td>
          </tr>
          </c:when>
          <c:otherwise>
          <logic-el:iterate id="branchState" name="DocumentOperationForm" property="branche[${ctr}].branchState" indexId="ctr1">
            <tr>
              <c:set var="branchStateIndex" value="${branchStateIndex + 1}"/>
              <td width="33%" align="right" class="thnormal">Branch State ID: <c:out value="${branchState.branchStateId}"/></td>
              <td width="66%" class="datacell">
                Key: &nbsp;&nbsp;&nbsp;&nbsp;<html-el:text property="branche[${ctr}].docBranchState[${ctr1}].key"/>&nbsp;&nbsp;&nbsp;&nbsp; <html-el:button property="branchStateDeleteOp[${branchStateIndex}].value" value="delete ${branchState.branchStateId}" onclick="changeBranchValue(this,${ctr},${ctr1})"/><br>
                    Value: &nbsp;&nbsp;<html-el:text property="branche[${ctr}].docBranchState[${ctr1}].value"/><br>
              </td>
            </tr>
          </logic-el:iterate>
          </c:otherwise>
          </c:choose>
        </logic-el:iterate>
        </c:otherwise>
        </c:choose>
    </table>
  </div>
</kul:tab>
