<%--

    The Kuali Financial System, a comprehensive financial management system for higher education.

    Copyright 2005-2021 Kuali, Inc.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

--%>
<%@ include file="/jsp/sys/kfsTldHeader.jsp"%>

<c:set var="docPrivacyAttributes" value="${DataDictionary.PersonDocumentPrivacy.attributes}" />

<c:set var="canModifyPrivacyPreferences" scope="request" value="${KualiForm.canOverrideEntityPrivacyPreferences && !readOnly}" />

<kul:tab tabTitle="Privacy Preferences" defaultOpen="false" tabErrorKey="document.privacy*">
	<div class="tab-container" align="center">
		<table class="standard side-margins">
	 		<tr>
	 		    <kim:cell cellWidth="30%" inquiry="${inquiry}" isLabel="true" textAlign="right" attributeEntry="${docPrivacyAttributes.suppressName}" /> 
		 		<kim:cell inquiry="${inquiry}" cellWidth="20%" textAlign="center" property="document.privacy.suppressName" attributeEntry="${docPrivacyAttributes.suppressName}" readOnly="${!canModifyPrivacyPreferences}" />
  				<kim:cell cellWidth="30%" inquiry="${inquiry}" isLabel="true" textAlign="right" attributeEntry="${docPrivacyAttributes.suppressAddress}" /> 
		 		<kim:cell inquiry="${inquiry}" cellWidth="20%" textAlign="center" property="document.privacy.suppressAddress" attributeEntry="${docPrivacyAttributes.suppressAddress}" readOnly="${!canModifyPrivacyPreferences}" />
	 		</tr>
	 		<tr>
	 		    <kim:cell cellWidth="30%" inquiry="${inquiry}" isLabel="true" textAlign="right" attributeEntry="${docPrivacyAttributes.suppressPersonal}" />
		 		<kim:cell inquiry="${inquiry}" cellWidth="20%" textAlign="center" property="document.privacy.suppressPersonal" attributeEntry="${docPrivacyAttributes.suppressPersonal}" readOnly="${!canModifyPrivacyPreferences}" />
  				<kim:cell cellWidth="30%" inquiry="${inquiry}" isLabel="true" textAlign="right" attributeEntry="${docPrivacyAttributes.suppressEmail}" />
		 		<kim:cell inquiry="${inquiry}" cellWidth="20%" textAlign="center" property="document.privacy.suppressEmail" attributeEntry="${docPrivacyAttributes.suppressEmail}" readOnly="${!canModifyPrivacyPreferences}" />
	 		</tr>
	 		<tr>
  				<kim:cell cellWidth="30%" inquiry="${inquiry}" isLabel="true" textAlign="right" attributeEntry="${docPrivacyAttributes.suppressPhone}" />
		 		<kim:cell inquiry="${inquiry}" cellWidth="20%" textAlign="center" property="document.privacy.suppressPhone" attributeEntry="${docPrivacyAttributes.suppressPhone}" readOnly="${!canModifyPrivacyPreferences}" />
		 		<th></th>
		 		<td></td>
	 		</tr>
		</table> 		
	</div>
</kul:tab>
