<%--

    The Kuali Financial System, a comprehensive financial management system for higher education.

    Copyright 2005-2021 Kuali, Inc.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

--%>
<%@ include file="/jsp/sys/kfsTldHeader.jsp"%>

<c:set var="docNameAttributes" value="${DataDictionary.PersonDocumentName.attributes}" />

<c:set var="canModify" scope="request" value="${!KualiForm.document.privacy.suppressName || KualiForm.canOverrideEntityPrivacyPreferences}" />
<c:set var="maskData" value="${KualiForm.document.privacy.suppressName && !KualiForm.canOverrideEntityPrivacyPreferences}" />

<kul:subtab lookedUpCollectionName="name" width="${tableWidth}" subTabTitle="Names" noShowHideButton="true">      
    <table class="standard side-margins">
        <tr>
            <th>&nbsp;</th>
            <kim:cell inquiry="${inquiry}" isLabel="true" textAlign="left" attributeEntry="${docNameAttributes.nameCode}" noColon="true" />
            <kim:cell inquiry="${inquiry}" isLabel="true" textAlign="left" attributeEntry="${docNameAttributes.namePrefix}" noColon="true" />
            <kim:cell inquiry="${inquiry}" isLabel="true" textAlign="left" attributeEntry="${docNameAttributes.firstName}" noColon="true" />
            <kim:cell inquiry="${inquiry}" isLabel="true" textAlign="left" attributeEntry="${docNameAttributes.middleName}" noColon="true" />
            <kim:cell inquiry="${inquiry}" isLabel="true" textAlign="left" attributeEntry="${docNameAttributes.lastName}" noColon="true" />
            <kim:cell inquiry="${inquiry}" isLabel="true" textAlign="left" attributeEntry="${docNameAttributes.nameSuffix}" noColon="true" />
            <kim:cell inquiry="${inquiry}" isLabel="true" textAlign="left" attributeEntry="${docNameAttributes.dflt}" noColon="true" />
            <kim:cell inquiry="${inquiry}" isLabel="true" textAlign="left" attributeEntry="${docNameAttributes.active}" noColon="true" />
          
            <c:if test="${not inquiry and canModify}">    
                <kul:htmlAttributeHeaderCell literalLabel="Actions" scope="col"/>
            </c:if>
        </tr>     
        <c:if test="${not inquiry and not readOnlyEntity and canModify}">              
            <tr>
                <th class="infoline">
                    <c:out value="Add:" />
                </th>
                <td align="left" valign="middle" class="infoline">
                    <div align="left">
                        <kul:htmlControlAttribute property="newName.nameCode" attributeEntry="${docNameAttributes.nameCode}" readOnly="${readOnlyEntity}" />
                    </div>
                </td>
                <td class="infoline">
                    <div align="left">
                        <kul:htmlControlAttribute property="newName.namePrefix" attributeEntry="${docNameAttributes.namePrefix}" readOnly="${readOnlyEntity}" />
                    </div>
                </td>
                <td class="infoline">   
                    <div align="left">
                      <kul:htmlControlAttribute property="newName.firstName" attributeEntry="${docNameAttributes.firstName}" readOnly="${readOnlyEntity}" />
                    </div>
                </td>
              <td class="infoline">
                <div align="left">
                  <kul:htmlControlAttribute property="newName.middleName" attributeEntry="${docNameAttributes.middleName}" readOnly="${readOnlyEntity}" />
                </div>
              </td>
              <td align="left" valign="middle" class="infoline">
                    <div align="left"><kul:htmlControlAttribute property="newName.lastName" attributeEntry="${docNameAttributes.lastName}" readOnly="${readOnlyEntity}" />
                    </div>
                </td>
                <td align="left" valign="middle" class="infoline">
                    <div align="left"><kul:htmlControlAttribute property="newName.nameSuffix" attributeEntry="${docNameAttributes.nameSuffix}" readOnly="${readOnlyEntity}" />
                    </div>
                </td>
                <td align="left" valign="middle" class="infoline">
                    <div align="left"><kul:htmlControlAttribute property="newName.dflt" attributeEntry="${docNameAttributes.dflt}" readOnly="${readOnlyEntity}" />
                    </div>
                </td>
                <td align="left" valign="middle" class="infoline">
                    <div align="left"><kul:htmlControlAttribute property="newName.active" attributeEntry="${docNameAttributes.active}" readOnly="${readOnlyEntity}" />
                    </div>
                </td>                               
                <td class="infoline">
                    <div align=left>
                        <html:submit property="methodToCall.addName.anchor${tabKey}"
                        value="Add" styleClass="btn btn-green"/>
                    </div>
                </td>
            </tr>         
        </c:if>      
        <c:forEach var="name" items="${KualiForm.document.names}" varStatus="status"> 
            <c:if test="${!(inquiry and readOnlyEntity and kfunc:isHiddenKimObjectType(name.entityNameType.code, 'kim.hide.PersonDocumentName.type'))}">
              <tr>
                <th class="infoline">
                    <c:out value="${status.index+1}" />
                </th>
                <kim:cell inquiry="${inquiry}" valign="middle" cellClass="infoline" textAlign="left" property="document.names[${status.index}].nameCode"  attributeEntry="${docNameAttributes.nameCode}"  readOnlyAlternateDisplay="${fn:escapeXml(name.entityNameType.name)}" readOnly="${readOnlyEntity or !canModify}" />
				<kim:cell inquiry="${inquiry}" valign="middle" cellClass="infoline" textAlign="left" property="document.names[${status.index}].namePrefix" attributeEntry="${docNameAttributes.namePrefix}" readOnly="${readOnlyEntity or !canModify}"  displayMask="${maskData}" displayMaskValue="Xxxxxxx" />
				<kim:cell inquiry="${inquiry}" valign="middle" cellClass="infoline" textAlign="left" property="document.names[${status.index}].firstName" attributeEntry="${docNameAttributes.firstName}" readOnly="${readOnlyEntity or !canModify}"  displayMask="${maskData}" displayMaskValue="Xxxxxxx" />
                <kim:cell inquiry="${inquiry}" valign="middle" cellClass="infoline" textAlign="left" property="document.names[${status.index}].middleName" attributeEntry="${docNameAttributes.middleName}" readOnly="${readOnlyEntity or !canModify}"  displayMask="${maskData}" displayMaskValue="Xxxxxxx" />
                <kim:cell inquiry="${inquiry}" valign="middle" cellClass="infoline" textAlign="left" property="document.names[${status.index}].lastName" attributeEntry="${docNameAttributes.lastName}" readOnly="${readOnlyEntity or !canModify}" displayMask="${maskData}" displayMaskValue="Xxxxxxx" />
				<kim:cell inquiry="${inquiry}" valign="middle" cellClass="infoline" textAlign="left" property="document.names[${status.index}].nameSuffix" attributeEntry="${docNameAttributes.nameSuffix}" readOnly="${readOnlyEntity or !canModify}"  displayMask="${maskData}" displayMaskValue="Xxxxxxx" />
				<kim:cell inquiry="${inquiry}" valign="middle" cellClass="infoline" textAlign="left" property="document.names[${status.index}].dflt" attributeEntry="${docNameAttributes.dflt}" readOnly="${readOnlyEntity or !canModify}" />
				<kim:cell inquiry="${inquiry}" valign="middle" cellClass="infoline" textAlign="left" property="document.names[${status.index}].active" attributeEntry="${docNameAttributes.active}" readOnly="${readOnlyEntity or !canModify}" />
                <c:if test="${not inquiry and canModify}">                        
                    <td>
                        <div align="left">&nbsp;
                         <c:choose>
                           <c:when test="${name.edit or readOnlyEntity}">
                               <button class="btn btn-red" disabled>Delete</button>
                           </c:when>
                           <c:otherwise>
                              <html:submit property='methodToCall.deleteName.line${status.index}.anchor${currentTabIndex}'
                                    value="Delete" styleClass='btn btn-red'/>
                           </c:otherwise>
                         </c:choose>  
                        </div>
                    </td>
                </c:if>    
              </tr>
            </c:if>  
        </c:forEach> 
    </table>
</kul:subtab>
