<%--

    The Kuali Financial System, a comprehensive financial management system for higher education.

    Copyright 2005-2021 Kuali, Inc.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

--%>
<%@ include file="/jsp/sys/kfsTldHeader.jsp"%>

<c:set var="awardAccountAttributes" value="${DataDictionary.ContractsGrantsInvoiceLookupResultAward.attributes}"/>

<div class="tab-container" align="center">
	<h3>Awards to be Invoiced</h3>
	<table width="100%" border="0" cellpadding="0" cellspacing="0" class="datatable standard">
		<thead>
			<tr class="header">
				<kul:htmlAttributeHeaderCell attributeEntry="${awardAccountAttributes.proposalNumber}" useShortLabel="false" hideRequiredAsterisk="true" />
				<kul:htmlAttributeHeaderCell attributeEntry="${awardAccountAttributes.chartOfAccountsCode}" useShortLabel="false" hideRequiredAsterisk="true" />
				<kul:htmlAttributeHeaderCell attributeEntry="${awardAccountAttributes.accountNumber}" useShortLabel="false" hideRequiredAsterisk="true" />
				<kul:htmlAttributeHeaderCell attributeEntry="${awardAccountAttributes.awardBeginningDate}" useShortLabel="false" hideRequiredAsterisk="true" />
				<kul:htmlAttributeHeaderCell attributeEntry="${awardAccountAttributes.awardEndingDate}" useShortLabel="false" hideRequiredAsterisk="true" />
				<kul:htmlAttributeHeaderCell attributeEntry="${awardAccountAttributes.billingFrequencyCode}" useShortLabel="false" hideRequiredAsterisk="true" />
				<kul:htmlAttributeHeaderCell attributeEntry="${awardAccountAttributes.instrumentTypeDescription}" useShortLabel="false" hideRequiredAsterisk="true" />
				<kul:htmlAttributeHeaderCell attributeEntry="${awardAccountAttributes.invoicingOptionDescription}" useShortLabel="false" hideRequiredAsterisk="true" />
				<kul:htmlAttributeHeaderCell attributeEntry="${awardAccountAttributes.awardTotalAmount}" useShortLabel="false" hideRequiredAsterisk="true" />
			</tr>
		</thead>
		<logic:iterate id="awards" name="KualiForm" property="${requestScope.propertyName}.lookupResultAwards" indexId="ctr">
            <c:set var="highlight" value="${ctr % 2 == 0}"/>
			<ar:contractsGrantsInvoiceSummarySubResult highlight="${highlight}" awardAccountAttributes="${awardAccountAttributes}" propertyName="${requestScope.propertyName}.lookupResultAwards[${ctr}]" />
		</logic:iterate>
	</table>
</div>
