<%--

    The Kuali Financial System, a comprehensive financial management system for higher education.

    Copyright 2005-2022 Kuali, Inc.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

--%>
<%@ include file="/jsp/sys/kfsTldHeader.jsp"%>
<%@ tag body-content="empty" %>
<%@ attribute name="delegationMemberIdx" required="true" description="The index of the delegation member information on the IdentityManagementPersonDocument to display qualifiers for." %>

<c:set var="delegationMember" value="${KualiForm.document.delegationMembers[delegationMemberIdx]}"/>
<c:set var="delegationMemberAttributes" value="${DataDictionary.RoleDocumentDelegationMember.attributes}" />
<c:set var="roleDocumentDelegationMemberQualifier" value="${DataDictionary.RoleDocumentDelegationMemberQualifier.attributes}" />

<kul:subtab lookedUpCollectionName="delegationMemberQualifier" width="${tableWidth}" subTabTitle="Delegation Member Qualifier" useCurrentTabIndexAsKey="true">      
    <table class="standard side-margins">
        <tr>
        	<th width="5%" rowspan="20" style="border-style:none">&nbsp;</th>
			<th>&nbsp;</th> 
		    <c:choose>
	            <c:when test="${!empty delegationMember.attributesHelper.definitions and fn:length(delegationMember.attributesHelper.definitions) > 0}" >
					<c:forEach var="attrDefn" items="${delegationMember.attributesHelper.definitions}" varStatus="status1">
						<c:set var="attr" value="${attrDefn.attributeField}" />
						<c:set var="fieldName" value="${attr.name}" />
						<c:set var="attrEntry" value="${delegationMember.attributesHelper.attributeEntry[fieldName]}" />
	         		    <kul:htmlAttributeHeaderCell attributeEntry="${attrEntry}" useShortLabel="false" />
					</c:forEach>	
 		        </c:when>
		     </c:choose>
      		</tr>         
        <tr>
         		<th>&nbsp;</th> 
		    <c:choose>
	            <c:when test="${!empty delegationMember.attributesHelper.definitions and fn:length(delegationMember.attributesHelper.definitions) > 0}" >
					<c:forEach var="attrDefn" items="${delegationMember.attributesHelper.definitions}" varStatus="status1">
						<c:set var="attr" value="${attrDefn.attributeField}" />
						<c:set var="fieldName" value="${attr.name}" />
						<c:set var="attrEntry" value="${delegationMember.attributesHelper.attributeEntry[fieldName]}" />
				       	<td align="left" valign="middle">
				       		<div align="center"> 
				      		   	<kul:htmlControlAttribute property="document.delegationMembers[${delegationMemberIdx}].qualifiers[${status1.index}].attrVal"  attributeEntry="${attrEntry}" readOnly="${readOnly}" />

								<c:if test="${attrDefinition.quickFinder != null}" >
									<c:if test="${!empty attrDefinition.quickFinder.dataObjectClass and not readOnly}">
    					       		    <kim:attributeLookup
												attributeDefinitions="${delegationMember.attributesHelper.definitions}"
												pathPrefix="document.delegationMembers[${delegationMemberIdx}]"
												attr="${attrDefinition.quickFinder}" />
		                          	</c:if>
                            	</c:if>
				  			</div>
						</td>
					</c:forEach>	
 		        </c:when>
		     </c:choose>
      	</tr>
    </table>
</kul:subtab>
