<%--

    The Kuali Financial System, a comprehensive financial management system for higher education.

    Copyright 2005-2022 Kuali, Inc.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

--%>
<%@ include file="/jsp/sys/kfsTldHeader.jsp"%>

<%@ attribute name="customerAttributes" required="true"
	type="java.util.Map"
	description="The DataDictionary entry containing attributes for this row's fields."%>
<%@ attribute name="customerInvoiceDetailAttributes" required="true"
	type="java.util.Map"
	description="The DataDictionary entry containing attributes for this row's fields."%>
<%@ attribute name="invoiceAttributes" required="true"
	type="java.util.Map"
	description="The DataDictionary entry containing attributes for this row's fields."%>
<%@ attribute name="readOnly" required="true"
	description="If document is in read only mode"%>

<c:set var="arDocHeaderAttributes" value="${DataDictionary.AccountsReceivableDocumentHeader.attributes}" />

<kul:tab tabTitle="Apply to Invoice Detail" defaultOpen="true"
	tabErrorKey="${KFSConstants.PaymentApplicationTabErrorCodes.APPLY_TO_INVOICE_DETAIL_TAB}">
	<div class="tab-container" align="center">
        <table class="standard side-margins">
			<tr>
				<th class="right">Customer</th>
				<td>
					<c:if test="${readOnly eq true && not empty KualiForm.selectedCustomerNumber}">
						<kul:inquiry
							boClassName="org.kuali.kfs.module.ar.businessobject.Customer"
							keyValues="customerNumber=${KualiForm.selectedCustomerNumber}"
							render="true">
							<kul:htmlControlAttribute readOnly="${readOnly}"
								attributeEntry="${customerAttributes.customerNumber}"
								property="selectedCustomerNumber" />
						</kul:inquiry>
					</c:if>
					<c:if test="${readOnly ne true}">
						<kul:htmlControlAttribute
							readOnly="${readOnly}"
							attributeEntry="${customerAttributes.customerNumber}"
							property="selectedCustomerNumber" />
						<kul:lookup
							boClassName="org.kuali.kfs.module.ar.businessobject.Customer"
							fieldConversions="customerNumber:selectedCustomerNumber" />
					</c:if>
				</td>
			</tr>
			<tr>
				<th width='50%' class="right">Invoice</th>
				<td>
					<kul:checkErrors keyMatch="${KFSConstants.PaymentApplicationTabErrorCodes.APPLY_TO_INVOICE_DETAIL_TAB}"/>
					<c:choose>
						<c:when test="${empty KualiForm.enteredInvoiceDocumentNumber || hasErrors }">
								<kul:htmlControlAttribute
								readOnly="${readOnly}"
								attributeEntry="${invoiceAttributes.organizationInvoiceNumber}"
								property="enteredInvoiceDocumentNumber" />
						</c:when>
						<c:otherwise>
							<a href="${ConfigProperties.application.url}/DocHandler.do?docId=${KualiForm.enteredInvoiceDocumentNumber}&command=displayDocSearchView" target="blank">
								<kul:htmlControlAttribute
									readOnly="true"
									attributeEntry="${invoiceAttributes.organizationInvoiceNumber}"
									property="enteredInvoiceDocumentNumber" />
							</a>
						</c:otherwise>
					</c:choose>
				</td>
			</tr>
			<c:if test="${readOnly ne true}">
				<tr>
					<td colspan='2' class="center">
						<html:submit
								property="methodToCall.loadInvoices"
								alt="Load Invoices"
								title="Load Invoices"
								styleClass="btn btn-default"
								value="Load"/>
					</td>
				</tr>
			</c:if>
		</table>
		<c:choose>
			<c:when test="${empty KualiForm.selectedCustomerNumber}">
			</c:when>
			<c:otherwise>
				<table class="standard">
					<tr id='beta_zeta'>
						<td>
							<table class="standard">
								<tr>
									<td colspan='2' class='tab-subhead'>
										<label for="selectedInvoiceDocumentNumber">Invoices</label>
										<c:if test="${readOnly ne true}">
											<html:select property="selectedInvoiceDocumentNumber">
												<c:forEach items="${KualiForm.invoiceApplications}" var="invoiceApplication">
													<html:option value="${invoiceApplication.documentNumber}">
														<c:out value="${invoiceApplication.documentNumber}" />
													</html:option>
												</c:forEach>
											</html:select>
											<c:if test="${!empty invoiceApplications}">
												<logic:iterate id="invoiceApplication" name="KualiForm"
													property="invoiceApplications" indexId="ctr">
												</logic:iterate>
											</c:if>
											<html:submit
													property="methodToCall.goToInvoice"
													alt="Go To Invoice"
													title="Go To Invoice"
													styleClass="btn btn-default"
													value="Load"/>
										</c:if>
									</td>
								</tr>
								<tr>
									<th colspan='2' class='tab-subhead'>
										<h3>
										<c:out value="Invoice " />
										<a href="${ConfigProperties.application.url}/DocHandler.do?docId=${KualiForm.selectedInvoiceDocumentNumber}&command=displayDocSearchView" target="blank">
											<kul:htmlControlAttribute
												attributeEntry="${invoiceAttributes.organizationInvoiceNumber}"
												property="selectedInvoiceDocumentNumber" readOnly="true" />
										</a>
										&nbsp;
										<c:if test="${!empty KualiForm.previousInvoiceDocumentNumber}">
											<html:submit
													property="methodToCall.goToPreviousInvoice"
													alt="Go To Previous Invoice"
													title="Go To Previous Invoice"
													styleClass="btn btn-default small"
													value="prev"/>
										</c:if>
										<c:if
											test="${!empty KualiForm.previousInvoiceDocumentNumber && !empty KualiForm.nextInvoiceDocumentNumber}">|</c:if>
										<c:if test="${!empty KualiForm.nextInvoiceDocumentNumber}">
											<html:submit
													property="methodToCall.goToNextInvoice"
													alt="Go To Next Invoice"
													title="Go To Next Invoice"
													styleClass="btn btn-default small"
													value="next"/>
										</c:if>
										</h3>
									</th>
								</tr>
								<tr>
									<td colspan='2'>
										<div align="center">
										<table cellpadding='0' cellspacing='0' class='datatable' style="width: 80%">
											<tr>
												<kul:htmlAttributeHeaderCell
													labelFor="selectedInvoiceDocumentNumber"
													literalLabel="Invoice Number/Billing Date"
													addClass="left" />
												<kul:htmlAttributeHeaderCell
													labelFor="selectedInvoiceApplication.accountsReceivableDocumentHeader.customer.customerName"
													literalLabel="Invoice Header/Customer Name"
													addClass="left" />
												<kul:htmlAttributeHeaderCell
													labelFor="selectedInvoiceBalance"
													literalLabel="Open Amount/Total"
													addClass="right" />
												<kul:htmlAttributeHeaderCell
													labelFor="amountAppliedDirectlyToInvoice"
													literalLabel="Amount Applied to Invoice"
													addClass="right" />
											</tr>
											<tr>
												<td>
												<c:choose>
												<c:when test="${KualiForm.enteredInvoiceDocumentNumber}">
													<a href="${ConfigProperties.application.url}/DocHandler.do?docId=${KualiForm.enteredInvoiceDocumentNumber}&command=displayDocSearchView" target="blank">
														<kul:htmlControlAttribute
															attributeEntry="${invoiceAttributes.organizationInvoiceNumber}"
															property="selectedInvoiceDocumentNumber" readOnly="true" />
													</a>
												</c:when>
												<c:otherwise>
													<a href="${ConfigProperties.application.url}/DocHandler.do?docId=${KualiForm.selectedInvoiceDocumentNumber}&command=displayDocSearchView" target="blank">
														<kul:htmlControlAttribute
															attributeEntry="${invoiceAttributes.organizationInvoiceNumber}"
															property="selectedInvoiceDocumentNumber" readOnly="true" />
													</a>
												</c:otherwise>
												</c:choose>
												</td>
												<td>
													<c:out value="${KualiForm.selectedInvoiceApplication.invoice.invoiceHeaderText}" />
													&nbsp;
												</td>
												<td style="text-align: right;">
													<kul:htmlControlAttribute
														attributeEntry="${invoiceAttributes.openAmount}"
														property="selectedInvoiceBalance" readOnly="true" />
												</td>
												<td rowspan='2' style='vertical-align: top; text-align: right;'>
													<kul:htmlControlAttribute
														attributeEntry="${invoiceAttributes.openAmount}"
														property="amountAppliedDirectlyToInvoice" readOnly="true" />
												</td>
											</tr>
											<tr>
												<td>
													<c:out value="${KualiForm.selectedInvoiceApplication.invoice.billingDate}"/>
												</td>
												<td>
													<c:out value="${KualiForm.selectedInvoiceApplication.invoice.accountsReceivableDocumentHeader.customer.customerName}" />
												</td>
												<td style="text-align: right;">
													<kul:htmlControlAttribute
														attributeEntry="${invoiceAttributes.sourceTotal}"
														property="selectedInvoiceTotalAmount" readOnly="true" />
												</td>
											</tr>
										</table>
										</div>
									</td>
								</tr>
								<tr>
									<td colspan='2'>
										<table clas="standard acct-lines">
											<tbody>
												<tr>
													<td colspan='4' class='tab-subhead'>
														<h3>Invoice Detail</h3>
													</td>
												</tr>
												<tr>
													<td colspan='4'>
														<table width='100%' cellpadding='0' cellspacing='0'
															   class='datatable' id="selectedCustomerInvoiceDetails">
															<tr>
																<th>
																	&nbsp;
																</th>
																<th class="center">
																	Chart
																</th>
																<th class="center">
																	Account
																</th>
																<th class="center">
																	Item Desc
																</th>
																<th class="center">
																	Item Total Amount
																</th>
																<th class="center">
																	Item Open Amount
																</th>
																<th class="center">
																	Apply Amount
																</th>
																<c:if test="${readOnly ne true}">
																	<th class="center">
																		Apply Full Amount
																	</th>
																</c:if>
															</tr>
															<c:if test="${!empty KualiForm.selectedInvoiceDetailApplications}">
																<logic:iterate id="invoiceDetailApplication" name="KualiForm"
																			   property="selectedInvoiceDetailApplications" indexId="ctr">
																	<tr>
																		<td>
																			<kul:htmlControlAttribute
																					attributeEntry="${customerInvoiceDetailAttributes.sequenceNumber}"
																					property="selectedInvoiceDetailApplications[${ctr}].sequenceNumber"
																					readOnly="true" />
																		</td>
																		<td>
																			<kul:htmlControlAttribute
																					attributeEntry="${customerInvoiceDetailAttributes.chartOfAccountsCode}"
																					property="selectedInvoiceDetailApplications[${ctr}].chartOfAccountsCode"
																					readOnly="true" />
																		</td>
																		<td>
																			<kul:htmlControlAttribute
																					attributeEntry="${customerInvoiceDetailAttributes.accountNumber}"
																					property="selectedInvoiceDetailApplications[${ctr}].accountNumber"
																					readOnly="true" />
																		</td>
																		<td>
																			<kul:htmlControlAttribute
																					attributeEntry="${customerInvoiceDetailAttributes.invoiceItemDescription}"
																					property="selectedInvoiceDetailApplications[${ctr}].invoiceItemDescription"
																					readOnly="true" />
																		</td>
																		<td style="text-align: right;">
																			<kul:htmlControlAttribute
																					attributeEntry="${customerInvoiceDetailAttributes.amount}"
																					property="selectedInvoiceDetailApplications[${ctr}].amount"
																					readOnly="true" />
																		</td>
																		<td style="text-align: right;">
																			<kul:htmlControlAttribute
																					attributeEntry="${customerInvoiceDetailAttributes.amountOpen}"
																					property="selectedInvoiceDetailApplications[${ctr}].amountOpen"
																					readOnly="true" />
																		</td>
																		<td style="text-align: right;">
																			<kul:htmlControlAttribute
																					readOnly="${readOnly}"
																					styleClass="amount"
																					disabled="${invoiceDetailApplication.fullApply || invoiceDetailApplication.invoiceQuickApplied}"
																					attributeEntry="${customerInvoiceDetailAttributes.amountApplied}"
																					property="selectedInvoiceDetailApplications[${ctr}].amountApplied" />
																		</td>
																		<c:if test="${readOnly ne true}">
																			<td>
																				<center>
																					<kul:htmlControlAttribute
																							readOnly="${readOnly}"
																							disabled="${invoiceDetailApplication.invoiceQuickApplied}"
																							attributeEntry="${customerInvoiceDetailAttributes.taxableIndicator}"
																							property="selectedInvoiceDetailApplications[${ctr}].fullApply" />
																				</center>
																			</td>
																		</c:if>
																	</tr>
																</logic:iterate>
															</c:if>
														</table>
													</td>
												</tr>
												<c:if test="${readOnly ne true}">
													<tr>
														<td style='text-align: right;' colspan='4'>
															<html:submit
																	property="methodToCall.applyAllAmounts"
																	alt="Apply"
																	title="Apply"
																	styleClass="btn btn-default"
																	value="Apply"/>
														</td>
													</tr>
												</c:if>
											</tbody>
										</table>
									</td>
								</tr>
							</table>
						</td>
					</tr>

				</table>
			</c:otherwise>
		</c:choose>
	</div>
</kul:tab>
