<%--

    The Kuali Financial System, a comprehensive financial management system for higher education.

    Copyright 2005-2022 Kuali, Inc.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

--%>
<%@ include file="/jsp/sys/kfsTldHeader.jsp"%>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Stuck Documents Autofix Report</title>
    <style type="text/css">
        td, th
        {
            padding:0 15px 0 15px;
        }
    </style>
</head>
<body>
<h1>Stuck Documents Autofix Report</h1>
<form action="StuckDocuments.do" method="POST">
    <select name="statusFilter" onchange="this.form.submit()">
        <c:forEach var="status" items="${KualiForm.statuses}">
            <option value="${status.value}" ${status.selected ? 'selected="selected"' : ''}>${status.value}</option>
        </c:forEach>
    </select>
    <input type="hidden" name="methodToCall" value="autofixReport"/>
    <br><br>
    <table>
        <thead>
            <tr>
                <th>Document ID</th>
                <th>Document Type</th>
                <th>Start Date</th>
                <th>End Date</th>
                <th>Status</th>
                <th>Autofix Attempts</th>
            </tr>
        </thead>
        <tbody>
        <c:forEach var="incidentHistory" items="${history}">
            <tr>
                <td><c:out value="${incidentHistory.documentId}"/></td>
                <td><c:out value="${incidentHistory.documentTypeLabel}"/></td>
                <td><c:out value="${incidentHistory.startDate}"/></td>
                <td><c:out value="${incidentHistory.endDate}"/></td>
                <td><c:out value="${incidentHistory.status}"/></td>
                <td><c:out value="${incidentHistory.fixAttempts}"/></td>
            </tr>
        </c:forEach>
        </tbody>
    </table>
    <kul:csrf/>
</form>
</body>
</html>
