<%--

    The Kuali Financial System, a comprehensive financial management system for higher education.

    Copyright 2005-2022 Kuali, Inc.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

--%>
<%@ include file="/jsp/sys/kfsTldHeader.jsp"%>

<kul:tab tabTitle="Action Requests" defaultOpen="true">
  <div class="tab-container">
    <table class="standard side-margins">
      <c:choose>
      <c:when test="${empty DocumentOperationForm.actionRequests}">
      <tr><td class="datacell" colspan="2" align="center" height="15">None</td></tr>
      </c:when>
      <c:otherwise>
      <logic-el:iterate id="actionRequest" name="DocumentOperationForm" property="actionRequests" indexId="ctr">
        <html-el:hidden property="actionRequests[${ctr}].actionRequestId" />
          <html-el:hidden property="actionRequests[${ctr}].versionNumber" />
            <tr>
              <td width="33%" class="headercell3-b-l" align="right"><b> Action Request ID: </b><c:out value="${actionRequest.actionRequestId}" /> </td>
              <td width="66%" class="headercell3-b-l">
                <html-el:radio property="actionRequestOp[${ctr}].value" value="update" />Update &nbsp;&nbsp;<html-el:radio property="actionRequestOp[${ctr}].value" value="delete"/>Delete&nbsp;&nbsp;<html-el:radio property="actionRequestOp[${ctr}].value" value="noop"/>No Operation&nbsp;&nbsp;
                      <html-el:hidden property="actionRequestOp[${ctr}].index" />
              </td>
            </tr>
            <tr>
              <td width="33%" align="right" class="thnormal">* Document Version:</td>
              <td width="66%" class="datacell"><html-el:text property="actionRequests[${ctr}].docVersion" /></td>
            </tr>
            <tr>
              <td width="33%" align="right" class="thnormal">* Document ID:</td>
              <td width="66%" class="datacell"><html-el:text property="actionRequests[${ctr}].documentId" /></td>
            </tr>
            <tr>
              <td width="33%" align="right" class="thnormal">* Route Node Instance ID:</td>
              <td width="66%" class="datacell">
                <c:choose>
                <c:when test="${actionRequest.nodeInstance==null}">
                None
                </c:when>
                <c:otherwise>
                <html-el:text property="actionRequests[${ctr}].nodeInstance.routeNodeInstanceId" />
                </c:otherwise>
                </c:choose>
              </td>
            </tr>
            <tr>
              <td width="33%" align="right" class="thnormal">* Action Requested:</td>
              <td width="66%" class="datacell">
                <html-el:select property="actionRequests[${ctr}].actionRequested" value="${actionRequest.actionRequested}">
                  <c:set var="actionRequestCds" value="${DocumentOperationForm.actionRequestCds}"/>
                  <html-el:options collection="actionRequestCds" property="key" labelProperty="value"/>
                  </html-el:select>
              </td>
            </tr>
            <tr>
              <td width="33%" align="right" class="thnormal">* Create Date: </td>
              <td width="66%" class="datacell">
                  <html-el:text property="actionRequests[${ctr}].createDateString" styleId="actionRequestCreateDate${ctr}" />
                  <img
                    src="${ConfigProperties.externalizable.images.url}cal.png"
                    id="actionRequestCreateDate${ctr}_trigger"
                    style="width: 24px;"
                    align="absmiddle"
                    alt="Create Date Select"
                  />
                  <script type="text/javascript">
                    (function () {
                      Calendar.setup({
                        inputField     :    "actionRequestCreateDate${ctr}",     // id of the input field
                        ifFormat       :    "%m/%d/%Y",     // format of the input field (even if hidden, this format will be honored)
                        button         :    "actionRequestCreateDate${ctr}_trigger", // the button or image that triggers this
                        daFormat       :    "%A, %B %d, %Y",// format of the displayed date
                        singleClick    :    true,
                        timeFormat     :    "12",
                        step           :    1
                      })
                    })()
                  </script>
              </td>
            </tr>
            <tr>
              <td width="33%" align="right" class="thnormal">* Status:</td>
              <td width="66%" class="datacell">
                <html-el:select property="actionRequests[${ctr}].status" value="${actionRequest.status}">
                  <c:set var="actionRequestStatuses" value="${DocumentOperationForm.actionRequestStatuses}"/>
                  <html-el:options collection="actionRequestStatuses" property="key" labelProperty="value"/>
                  </html-el:select>
              </td>
            </tr>
            <tr>
              <td width="33%" align="right" class="thnormal">* Priority:</td>
              <td width="66%" class="datacell"><html-el:text property="actionRequests[${ctr}].priority" /></td>
            </tr>
            <tr>
              <td width="33%" align="right" class="thnormal">* Route Level:</td>
              <td width="66%" class="datacell"><html-el:text property="actionRequests[${ctr}].routeLevel" /></td>
            </tr>
            <tr>
              <td width="33%" align="right" class="thnormal">* Responsibility ID:</td>
              <td width="66%" class="datacell"><html-el:text property="actionRequests[${ctr}].responsibilityId" /></td>
            </tr>
            <tr>
              <td width="33%" align="right" class="thnormal">Responsibility Description: </td>
              <td width="66%" class="datacell"><html-el:text property="actionRequests[${ctr}].responsibilityDesc" /></td>
            </tr>
            <tr>
              <td width="33%" align="right" class="thnormal">Action Request Parent ID:</td>
              <td width="66%" class="datacell"><html-el:text property="actionRequests[${ctr}].parentActionRequestId" /></td>
            </tr>
            <tr>
              <td width="33%" align="right" class="thnormal">Recipient Type:</td>
              <td width="66%" class="datacell">
                <html-el:select property="actionRequests[${ctr}].recipientTypeCd" value="${actionRequest.recipientTypeCd}">
                  <c:set var="actionRequestRecipientTypes" value="${DocumentOperationForm.actionRequestRecipientTypes}"/>
                  <html-el:options collection="actionRequestRecipientTypes" property="key" labelProperty="value"/>
                  </html-el:select>
                  <%-- <html-el:text property="actionRequests[${ctr}].recipientTypeCd" />--%>
              </td>
            </tr>
            <tr>
              <td width="33%" align="right" class="thnormal">Person ID:</td>
              <td width="66%" class="datacell"><html-el:text property="actionRequests[${ctr}].principalId" />
                  <kul:lookup boClassName="org.kuali.kfs.kim.impl.identity.PersonImpl" fieldConversions="principalId:actionRequests[${ctr}].principalId"
                                                                                       lookupParameters="actionRequests[${ctr}].principalId:principalId"/>
              </td>
            </tr>
            <tr>
              <td width="33%" align="right" class="thnormal">Workgroup ID:</td>
              <td width="66%" class="datacell"><html-el:text property="actionRequests[${ctr}].groupId" />
                  <kul:lookup boClassName="org.kuali.kfs.kim.impl.group.Group" fieldConversions="id:actionRequests[${ctr}].groupId" lookupParameters="actionRequests[${ctr}].groupId:id"/>
              </td>
            </tr>
            <tr>
              <td width="33%" align="right" class="thnormal">Role Name:</td>
              <td width="66%" class="datacell"><html-el:text property="actionRequests[${ctr}].roleName"/>
                  <kul:lookup boClassName="org.kuali.kfs.kim.impl.role.Role" fieldConversions="name:actionRequests[${ctr}].roleName" lookupParameters="actionRequests[${ctr}].roleName:name" />
              </td>
            </tr>
            <tr>
              <td width="33%" align="right" class="thnormal">Qualified Role Name:</td>
              <td width="66%" class="datacell"><html-el:text property="actionRequests[${ctr}].qualifiedRoleName" /></td>
            </tr>
            <tr>
              <td width="33%" align="right" class="thnormal">Qualified Role Label:</td>
              <td width="66%" class="datacell"><html-el:text property="actionRequests[${ctr}].qualifiedRoleNameLabel" /></td>
            </tr>
            <tr>
              <td width="33%" align="right" class="thnormal">Action Taken ID:</td>
              <td width="66%" class="datacell"><html-el:text property="actionRequests[${ctr}].actionTakenId" /></td>
            </tr>
            <tr>
              <td width="33%" align="right" class="thnormal">Force Action: </td>
              <td width="66%" class="datacell"><html-el:text property="actionRequests[${ctr}].forceAction" /></td>
            </tr>
            <tr>
              <td width="33%" align="right" class="thnormal">Approve Policy: </td>
              <td width="66%" class="datacell"><html-el:text property="actionRequests[${ctr}].approvePolicy" /></td>
            </tr>
            <tr>
              <td width="33%" align="right" class="thnormal">Delegation Type: </td>
              <td width="66%" class="datacell"><html-el:text property="actionRequests[${ctr}].delegationTypeCode" /></td>
            </tr>
            <tr>
              <td width="33%" align="right" class="thnormal">Current Indicator: </td>
              <td width="66%" class="datacell"><html-el:text property="actionRequests[${ctr}].currentIndicator" /></td>
            </tr>
            <tr>
              <td width="33%" align="right" class="thnormal">Annotation: </td>
              <td width="66%" class="datacell"><html-el:textarea cols="55" rows="5" property="actionRequests[${ctr}].annotation" /></td>
            </tr>
      </logic-el:iterate>
      </c:otherwise>
      </c:choose>
    </table>
  </div>
</kul:tab>
