<%--

    The Kuali Financial System, a comprehensive financial management system for higher education.

    Copyright 2005-2022 Kuali, Inc.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

--%>
<%@ include file="/jsp/sys/kfsTldHeader.jsp"%>

<kul:tab tabTitle="Document Header" defaultOpen="true">
<html-el:hidden property="routeHeader.documentId" />
<html-el:hidden property="routeHeader.versionNumber" />
<html-el:hidden property="lookupableImplServiceName" />
<div class="tab-container">
  <table class="standard side-margins">
	 	  <tr>
		    <td width="33%" class="headercell3-b-l" align="right">
          <b> Document ID: </b>
          <c:out value="${DocumentOperationForm.routeHeader.documentId}" />
        </td>
		    <td width="66%" class="headercell3-b-l"><html-el:radio property="routeHeaderOp" value="update"/>Update &nbsp;&nbsp;<html-el:radio property="routeHeaderOp" value="noop"/>No Operation&nbsp;&nbsp;</td>
		  </tr>
		  <tr>
	  	    <td width="33%" align="right" class="thnormal">* Document Version:</td>
	  	    <td width="66%" class="datacell"><html-el:text property="routeHeader.docVersion"/></td>
	  	  </tr>
		  <tr>
	  	    <td width="33%" align="right" class="thnormal">* Initiator ID:</td>
	  	    <td width="66%" class="datacell"><html-el:text property="routeHeader.initiatorWorkflowId"/>
	  	      <kul:lookup boClassName="org.kuali.kfs.kim.impl.identity.PersonImpl" fieldConversions="principalId:routeHeader.initiatorWorkflowId" lookupParameters="routeHeader.initiatorWorkflowId:principalId" />
	  	      <%-- document.forms[0].elements['lookupableImplServiceName'].value = 'UserLookupableImplService';"/> --%>
	  	    </td>
	  	  </tr>
	  	  <tr>
	  	    <td width="33%" align="right" class="thnormal">* Initial Route Node Instances:</td>
	  	    <td width="66%" class="datacell">
	  	      	<html-el:text property="initialNodeInstances"/>
	  	    </td>
	  	  </tr>
		  <tr>
	  	    <td width="33%" align="right" class="thnormal">* Route Status:</td>
	  	    <td width="66%" class="datacell">
  	    	  <html-el:select property="routeHeader.docRouteStatus" value="${DocumentOperationForm.routeHeader.docRouteStatus}">
              <c:set var="docStatuses" value="${DocumentOperationForm.docStatuses}"/>
              <html-el:options collection="docStatuses" property="key" labelProperty="value"/>
            </html-el:select>
	  	    </td>
	  	  </tr>
	  	 <tr>
	  	    <td width="33%" align="right" class="thnormal">* Route Level:</td>
	  	    <td width="66%" class="datacell"><html-el:text property="routeHeader.docRouteLevel"/></td>
	  	  </tr>
	  	  <tr>
	  	    <td width="33%" align="right" class="thnormal">* Create Date:</td>
	  	    <td width="66%" class="datacell">
            <html-el:text property="createDate" styleId="createDate"/>&nbsp;
            <img src="${ConfigProperties.externalizable.images.url}cal.png" width="24" id="createDate_trigger" style="cursor: pointer;" alt="Created Date selector" title="Date selector" />
	  	    </td>
	  	  </tr>
	  	  <tr>
	  	    <td width="33%" align="right" class="thnormal">* Modification Date:</td>
	  	    <td width="66%" class="datacell">
	  	    	<html-el:text property="dateModified" styleId="dateModified"/>&nbsp;
	  	    	<img src="${ConfigProperties.externalizable.images.url}cal.png" id="dateModified_trigger" width="24" align="absmiddle" alt="Modified Date selector">
	  	    </td>
	  	  </tr>
	  	  <tr>
	  	    <td width="33%" align="right" class="thnormal">Approved Date:</td>
	  	 	<td width="66%" class="datacell">
	  	    	<html-el:text property="approvedDate" styleId="approvedDate"/>&nbsp;
	  	    	<img src="${ConfigProperties.externalizable.images.url}cal.png" id="approvedDate_trigger" width="24" align="absmiddle" alt="Approved Date selector">
	  	    </td>
	  	  </tr>
	  	  <tr>
	  	    <td width="33%" align="right" class="thnormal">Finalized Date:</td>
	  	    <td width="66%" class="datacell">
	  	    	<html-el:text property="finalizedDate" styleId="finalizedDate"/>&nbsp;
	  	    	<img src="${ConfigProperties.externalizable.images.url}cal.png" id="finalizedDate_trigger" width="24" align="absmiddle" alt="Finalized Date selector">
	  	    </td>
	  	  </tr>
	  	  <tr>
	  	    <td width="33%" align="right" class="thnormal">Route Status Modification Date:</td>
	  	    <td width="66%" class="datacell">
	  	    	<html-el:text property="routeStatusDate" styleId="routeStatusDate"/>&nbsp;
	  	    	<img src="${ConfigProperties.externalizable.images.url}cal.png" id="routeStatusDate_trigger" width="24" align="absmiddle" alt="Route Status Date selector">
	  	    </td>
	  	  </tr>
	  	  <tr>
	  	    <td width="33%" align="right" class="thnormal">Doc Type ID:</td>
	  	    <td width="66%" class="datacell"><html-el:text property="routeHeader.documentTypeId" />
	  	    	<kul:lookup boClassName="org.kuali.kfs.kew.doctype.bo.DocumentType" fieldConversions="documentTypeId:routeHeader.documentTypeId" lookupParameters="routeHeader.documentTypeId:documentTypeId" />
	  	    </td>
		  </tr>
	  	  <tr>
	  	    <td width="33%" align="right" class="thnormal">Doc Title:</td>
	  	    <td width="66%" class="datacell"><html-el:text property="routeHeader.docTitle"/></td>
	  	  </tr>
	  	  <tr>
	  	    <td width="33%" align="right" class="thnormal">Application Doc ID:</td>
	  	    <td width="66%" class="datacell"><html-el:text property="routeHeader.appDocId"/></td>
	  	  </tr>
        <!-- KULRICE-12353:  Added ability to change application document status from document operation screen -->
        <tr>
          <td width="33%" align="right" class="thnormal">Application Doc Status:</td>
          <td width="66%" class="datacell"><html-el:text property="routeHeader.appDocStatus"/></td>
        </tr>
        <tr>
	  	    <td width="33%" align="right" class="thnormal">Doc Content:</td>
	  	    <td width="66%" class="datacell"><html-el:textarea cols="55" rows="5" property="routeHeader.docContent"/></td>
	  	  </tr>
	  </table>
  </div>
</kul:tab>


<script type="text/javascript">
  (function () {
        /* Wires up calendar for all calendars on this page, see button for button it's associated with */
    Calendar.setup({
      inputField     :    "createDate",     // id of the input field
      ifFormat       :    "%I:%M %p %m/%d/%Y",     // format of the input field (even if hidden, this format will be honored)
      button         :    "createDate_trigger", // the button or image that triggers this
      showsTime      :    true,            // will display a time selector
      daFormat       :    "%A, %B %d, %Y",// format of the displayed date
      singleClick    :    true,
      timeFormat     :    "12",
      step           :    1
    });

    Calendar.setup({
      inputField     :    "dateModified",     // id of the input field
      ifFormat       :    "%I:%M %p %m/%d/%Y ",     // format of the input field (even if hidden, this format will be honored)
      button         :    "dateModified_trigger", // the button or image that triggers this
      showsTime      :    true,            // will display a time selector
      daFormat       :    "%A, %B %d, %Y",// format of the displayed date
      singleClick    :    true,
      timeFormat     :    "12",
      step           :    1
    });

    Calendar.setup({
      inputField     :    "approvedDate",     // id of the input field
      ifFormat       :    "%I:%M %p %m/%d/%Y ",     // format of the input field (even if hidden, this format will be honored)
      button         :    "approvedDate_trigger", // the button or image that triggers this
      showsTime      :    true,            // will display a time selector
      daFormat       :    "%A, %B %d, %Y",// format of the displayed date
      singleClick    :    true,
      timeFormat     :    "12",
      step           :    1
    });


    Calendar.setup({
      inputField     :    "finalizedDate",     // id of the input field
      ifFormat       :    "%I:%M %p %m/%d/%Y ",     // format of the input field (even if hidden, this format will be honored)
      button         :    "finalizedDate_trigger", // the button or image that triggers this
      showsTime      :    true,            // will display a time selector
      daFormat       :    "%A, %B %d, %Y",// format of the displayed date
      singleClick    :    true,
      timeFormat     :    "12",
      step           :    1
    });

    Calendar.setup({
      inputField     :    "routeStatusDate",     // id of the input field
      ifFormat       :    "%I:%M %p %m/%d/%Y ",     // format of the input field (even if hidden, this format will be honored)
      button         :    "routeStatusDate_trigger", // the button or image that triggers this
      showsTime      :    true,            // will display a time selector
      daFormat       :    "%A, %B %d, %Y",// format of the displayed date
      singleClick    :    true,
      timeFormat     :    "12",
      step           :    1
    });
  })()
</script>
