/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.web.filter;

import java.io.PrintWriter;
import java.util.Optional;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.kim.api.identity.AuthenticationService;
import org.kuali.kfs.kns.bo.AuthenticationValidationResponse;
import org.kuali.kfs.kns.service.CfAuthenticationService;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.sys.businessobject.JwtData;
import org.kuali.kfs.sys.service.CoreApiKeyAuthenticationService;
import org.kuali.kfs.sys.service.JwtService;
import org.kuali.kfs.sys.util.BearerTokenContext;
import org.kuali.kfs.web.filter.ResourceLoginFilter;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
@Execution(value=ExecutionMode.SAME_THREAD)
class ResourceLoginFilterTest {
    private ResourceLoginFilter cut;
    @Mock
    private HttpServletRequest requestMock;
    @Mock
    private HttpServletResponse responseMock;
    @Mock
    private HttpSession sessionMock;
    @Mock
    private PrintWriter writerMock;
    @Mock
    private FilterChain filterChainMock;
    @Mock
    private AuthenticationService authSvcMock;
    @Mock
    private CfAuthenticationService cfAuthSvcMock;
    @Mock
    private CoreApiKeyAuthenticationService coreApiKeyAuthSvcMock;
    @Mock
    private JwtService jwtSvcMock;
    @Mock
    private UserSession userSessionMock;
    private boolean userSessionEstablished;

    ResourceLoginFilterTest() {
    }

    @BeforeEach
    void setUp() {
        this.cut = new ResourceLoginFilter(){

            protected JwtService getJwtService() {
                return ResourceLoginFilterTest.this.jwtSvcMock;
            }

            protected CoreApiKeyAuthenticationService getCoreApiKeyAuthenticationService() {
                return ResourceLoginFilterTest.this.coreApiKeyAuthSvcMock;
            }

            protected boolean isUserSessionEstablished(HttpServletRequest request) {
                return ResourceLoginFilterTest.this.userSessionEstablished;
            }

            protected void establishUserSession(HttpServletRequest request, HttpServletResponse response) {
            }

            protected void setUserSession(HttpServletRequest request, String principalName) {
            }

            protected AuthenticationService getAuthenticationService() {
                return ResourceLoginFilterTest.this.authSvcMock;
            }

            protected CfAuthenticationService getCfAuthenticationService() {
                return ResourceLoginFilterTest.this.cfAuthSvcMock;
            }
        };
        this.userSessionEstablished = false;
    }

    @AfterEach
    void tearDown() {
        BearerTokenContext.clear();
    }

    @Test
    void notInSession() throws Exception {
        this.userSessionEstablished = false;
        Mockito.when((Object)this.requestMock.getHeader("Authorization")).thenReturn(null);
        this.responseMock.setStatus(401);
        Mockito.when((Object)this.responseMock.getWriter()).thenReturn((Object)this.writerMock);
        this.writerMock.println("[ \"Unauthorized\" ]");
        Mockito.when((Object)this.sessionMock.getAttribute("userSession")).thenReturn((Object)this.userSessionMock);
        Mockito.when((Object)this.requestMock.getSession()).thenReturn((Object)this.sessionMock);
        this.cut.doFilter((ServletRequest)this.requestMock, (ServletResponse)this.responseMock, this.filterChainMock);
        ((HttpServletRequest)Mockito.verify((Object)this.requestMock)).getHeader(ArgumentMatchers.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.requestMock});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.coreApiKeyAuthSvcMock});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.jwtSvcMock});
        Assertions.assertNull((Object)BearerTokenContext.getBearerToken());
    }

    @Test
    void notInSessionOrRequest() throws Exception {
        this.userSessionEstablished = false;
        Mockito.when((Object)this.requestMock.getHeader("Authorization")).thenReturn(null);
        this.responseMock.setStatus(401);
        Mockito.when((Object)this.responseMock.getWriter()).thenReturn((Object)this.writerMock);
        this.writerMock.println("[ \"Unauthorized\" ]");
        Mockito.when((Object)this.sessionMock.getAttribute("userSession")).thenReturn((Object)this.userSessionMock);
        Mockito.when((Object)this.requestMock.getSession()).thenReturn((Object)this.sessionMock);
        this.cut.doFilter((ServletRequest)this.requestMock, (ServletResponse)this.responseMock, this.filterChainMock);
        ((HttpServletRequest)Mockito.verify((Object)this.requestMock)).getHeader(ArgumentMatchers.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.requestMock});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.coreApiKeyAuthSvcMock});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.jwtSvcMock});
        Assertions.assertNull((Object)BearerTokenContext.getBearerToken());
    }

    @Test
    void inSession() throws Exception {
        this.userSessionEstablished = true;
        Mockito.when((Object)this.userSessionMock.getPrincipalName()).thenReturn((Object)"SomeUser");
        Mockito.when((Object)this.sessionMock.getAttribute("userSession")).thenReturn((Object)this.userSessionMock);
        Mockito.when((Object)this.requestMock.getHeader("Authorization")).thenReturn(null);
        Mockito.when((Object)this.requestMock.getSession()).thenReturn((Object)this.sessionMock);
        this.filterChainMock.doFilter((ServletRequest)this.requestMock, (ServletResponse)this.responseMock);
        Mockito.when((Object)this.cfAuthSvcMock.validatePrincipalName(ArgumentMatchers.anyString())).thenReturn((Object)AuthenticationValidationResponse.VALID_AUTHENTICATION);
        this.cut.doFilter((ServletRequest)this.requestMock, (ServletResponse)this.responseMock, this.filterChainMock);
        ((HttpServletRequest)Mockito.verify((Object)this.requestMock, (VerificationMode)Mockito.times((int)2))).getHeader(ArgumentMatchers.anyString());
        ((FilterChain)Mockito.verify((Object)this.filterChainMock, (VerificationMode)Mockito.times((int)2))).doFilter((ServletRequest)this.requestMock, (ServletResponse)this.responseMock);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.filterChainMock});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.jwtSvcMock});
        Assertions.assertNull((Object)BearerTokenContext.getBearerToken());
    }

    @Test
    void inSessionEmptyHeader() throws Exception {
        this.userSessionEstablished = true;
        Mockito.when((Object)this.userSessionMock.getPrincipalName()).thenReturn((Object)"SomeUser");
        Mockito.when((Object)this.sessionMock.getAttribute("userSession")).thenReturn((Object)this.userSessionMock);
        Mockito.when((Object)this.requestMock.getHeader("Authorization")).thenReturn((Object)"");
        Mockito.when((Object)this.requestMock.getSession()).thenReturn((Object)this.sessionMock);
        this.responseMock.setStatus(401);
        this.writerMock.println("[ \"Unauthorized\" ]");
        this.filterChainMock.doFilter((ServletRequest)this.requestMock, (ServletResponse)this.responseMock);
        Mockito.when((Object)this.cfAuthSvcMock.validatePrincipalName(ArgumentMatchers.anyString())).thenReturn((Object)AuthenticationValidationResponse.VALID_AUTHENTICATION);
        this.cut.doFilter((ServletRequest)this.requestMock, (ServletResponse)this.responseMock, this.filterChainMock);
        ((HttpServletRequest)Mockito.verify((Object)this.requestMock, (VerificationMode)Mockito.times((int)2))).getHeader(ArgumentMatchers.anyString());
        ((FilterChain)Mockito.verify((Object)this.filterChainMock, (VerificationMode)Mockito.times((int)2))).doFilter((ServletRequest)this.requestMock, (ServletResponse)this.responseMock);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.filterChainMock});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.jwtSvcMock});
        Assertions.assertNull((Object)BearerTokenContext.getBearerToken());
    }

    @Test
    void blankAuthHeader() throws Exception {
        Mockito.when((Object)this.requestMock.getHeader("Authorization")).thenReturn((Object)"");
        this.responseMock.setStatus(401);
        Mockito.when((Object)this.responseMock.getWriter()).thenReturn((Object)this.writerMock);
        this.writerMock.println("[ \"Unauthorized\" ]");
        Mockito.when((Object)this.sessionMock.getAttribute("userSession")).thenReturn((Object)this.userSessionMock);
        Mockito.when((Object)this.requestMock.getSession()).thenReturn((Object)this.sessionMock);
        this.cut.doFilter((ServletRequest)this.requestMock, (ServletResponse)this.responseMock, this.filterChainMock);
        ((HttpServletRequest)Mockito.verify((Object)this.requestMock)).getHeader(ArgumentMatchers.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.requestMock});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.coreApiKeyAuthSvcMock});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.filterChainMock});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.jwtSvcMock});
        Assertions.assertNull((Object)BearerTokenContext.getBearerToken());
    }

    @Test
    void noBearerHeader() throws Exception {
        Mockito.when((Object)this.requestMock.getHeader("Authorization")).thenReturn((Object)"XXX");
        this.responseMock.setStatus(401);
        Mockito.when((Object)this.responseMock.getWriter()).thenReturn((Object)this.writerMock);
        this.writerMock.println("[ \"Unauthorized\" ]");
        Mockito.when((Object)this.sessionMock.getAttribute("userSession")).thenReturn((Object)this.userSessionMock);
        Mockito.when((Object)this.requestMock.getSession()).thenReturn((Object)this.sessionMock);
        this.cut.doFilter((ServletRequest)this.requestMock, (ServletResponse)this.responseMock, this.filterChainMock);
        ((HttpServletRequest)Mockito.verify((Object)this.requestMock)).getHeader(ArgumentMatchers.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.requestMock});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.coreApiKeyAuthSvcMock});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.filterChainMock});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.jwtSvcMock});
        Assertions.assertNull((Object)BearerTokenContext.getBearerToken());
    }

    @Test
    void onlyBearerHeader() throws Exception {
        Mockito.when((Object)this.requestMock.getHeader("Authorization")).thenReturn((Object)"Bearer");
        this.responseMock.setStatus(401);
        Mockito.when((Object)this.responseMock.getWriter()).thenReturn((Object)this.writerMock);
        this.writerMock.println("[ \"Unauthorized\" ]");
        Mockito.when((Object)this.sessionMock.getAttribute("userSession")).thenReturn((Object)this.userSessionMock);
        Mockito.when((Object)this.requestMock.getSession()).thenReturn((Object)this.sessionMock);
        this.cut.doFilter((ServletRequest)this.requestMock, (ServletResponse)this.responseMock, this.filterChainMock);
        ((HttpServletRequest)Mockito.verify((Object)this.requestMock)).getHeader(ArgumentMatchers.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.requestMock});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.coreApiKeyAuthSvcMock});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.filterChainMock});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.jwtSvcMock});
        Assertions.assertNull((Object)BearerTokenContext.getBearerToken());
    }

    @Test
    void blankKeyHeader() throws Exception {
        Mockito.when((Object)this.requestMock.getHeader("Authorization")).thenReturn((Object)"Bearer ");
        this.responseMock.setStatus(401);
        Mockito.when((Object)this.responseMock.getWriter()).thenReturn((Object)this.writerMock);
        this.writerMock.println("[ \"Unauthorized\" ]");
        Mockito.when((Object)this.sessionMock.getAttribute("userSession")).thenReturn((Object)this.userSessionMock);
        Mockito.when((Object)this.requestMock.getSession()).thenReturn((Object)this.sessionMock);
        this.cut.doFilter((ServletRequest)this.requestMock, (ServletResponse)this.responseMock, this.filterChainMock);
        ((HttpServletRequest)Mockito.verify((Object)this.requestMock)).getHeader(ArgumentMatchers.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.requestMock});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.coreApiKeyAuthSvcMock});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.filterChainMock});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.jwtSvcMock});
        Assertions.assertNull((Object)BearerTokenContext.getBearerToken());
    }

    @Test
    void nonCoreBadHeader() throws Exception {
        Mockito.when((Object)this.requestMock.getHeader("Authorization")).thenReturn((Object)"Bearer BAD");
        Mockito.when((Object)this.sessionMock.getAttribute("userSession")).thenReturn((Object)this.userSessionMock);
        Mockito.when((Object)this.requestMock.getSession()).thenReturn((Object)this.sessionMock);
        Mockito.when((Object)this.coreApiKeyAuthSvcMock.useCore()).thenReturn((Object)false);
        Mockito.when((Object)this.jwtSvcMock.decodeJwt("BAD")).thenThrow(new Throwable[]{new RuntimeException("Error")});
        this.responseMock.setStatus(401);
        Mockito.when((Object)this.responseMock.getWriter()).thenReturn((Object)this.writerMock);
        this.writerMock.println("[ \"Unauthorized\" ]");
        this.cut.doFilter((ServletRequest)this.requestMock, (ServletResponse)this.responseMock, this.filterChainMock);
        ((HttpServletRequest)Mockito.verify((Object)this.requestMock)).getHeader(ArgumentMatchers.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.requestMock});
        ((CoreApiKeyAuthenticationService)Mockito.verify((Object)this.coreApiKeyAuthSvcMock)).useCore();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.coreApiKeyAuthSvcMock});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.filterChainMock});
        ((JwtService)Mockito.verify((Object)this.jwtSvcMock)).decodeJwt(ArgumentMatchers.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.jwtSvcMock});
        Assertions.assertNull((Object)BearerTokenContext.getBearerToken());
    }

    @Test
    void nonCoreGoodHeader() throws Exception {
        Mockito.when((Object)this.requestMock.getHeader("Authorization")).thenReturn((Object)"Bearer GOOD");
        Mockito.when((Object)this.sessionMock.getAttribute("userSession")).thenReturn((Object)this.userSessionMock);
        Mockito.when((Object)this.requestMock.getSession()).thenReturn((Object)this.sessionMock);
        Mockito.when((Object)this.coreApiKeyAuthSvcMock.useCore()).thenReturn((Object)false);
        JwtData data = new JwtData("user", 1000);
        Mockito.when((Object)this.jwtSvcMock.decodeJwt("GOOD")).thenReturn((Object)data);
        this.filterChainMock.doFilter((ServletRequest)this.requestMock, (ServletResponse)this.responseMock);
        Mockito.when((Object)this.cfAuthSvcMock.validatePrincipalName(ArgumentMatchers.anyString())).thenReturn((Object)AuthenticationValidationResponse.VALID_AUTHENTICATION);
        this.cut.doFilter((ServletRequest)this.requestMock, (ServletResponse)this.responseMock, this.filterChainMock);
        ((HttpServletRequest)Mockito.verify((Object)this.requestMock, (VerificationMode)Mockito.times((int)2))).getHeader(ArgumentMatchers.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.requestMock});
        ((CoreApiKeyAuthenticationService)Mockito.verify((Object)this.coreApiKeyAuthSvcMock)).useCore();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.coreApiKeyAuthSvcMock});
        ((JwtService)Mockito.verify((Object)this.jwtSvcMock)).decodeJwt(ArgumentMatchers.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.jwtSvcMock});
        ((FilterChain)Mockito.verify((Object)this.filterChainMock, (VerificationMode)Mockito.times((int)2))).doFilter((ServletRequest)this.requestMock, (ServletResponse)this.responseMock);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.filterChainMock});
        Assertions.assertEquals((Object)"GOOD", (Object)BearerTokenContext.getBearerToken());
    }

    @Test
    void coreBadHeader() throws Exception {
        Mockito.when((Object)this.requestMock.getHeader("Authorization")).thenReturn((Object)"Bearer BAD");
        Mockito.when((Object)this.sessionMock.getAttribute("userSession")).thenReturn((Object)this.userSessionMock);
        Mockito.when((Object)this.requestMock.getSession()).thenReturn((Object)this.sessionMock);
        Mockito.when((Object)this.coreApiKeyAuthSvcMock.useCore()).thenReturn((Object)true);
        Mockito.when((Object)this.coreApiKeyAuthSvcMock.getPrincipalIdFromApiKey("BAD", this.userSessionMock)).thenReturn(Optional.empty());
        this.responseMock.setStatus(401);
        Mockito.when((Object)this.responseMock.getWriter()).thenReturn((Object)this.writerMock);
        this.writerMock.println("[ \"Unauthorized\" ]");
        this.cut.doFilter((ServletRequest)this.requestMock, (ServletResponse)this.responseMock, this.filterChainMock);
        ((HttpServletRequest)Mockito.verify((Object)this.requestMock)).getHeader(ArgumentMatchers.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.requestMock});
        ((CoreApiKeyAuthenticationService)Mockito.verify((Object)this.coreApiKeyAuthSvcMock)).useCore();
        ((CoreApiKeyAuthenticationService)Mockito.verify((Object)this.coreApiKeyAuthSvcMock)).getPrincipalIdFromApiKey(ArgumentMatchers.anyString(), (UserSession)ArgumentMatchers.eq((Object)this.userSessionMock));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.coreApiKeyAuthSvcMock});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.filterChainMock});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.jwtSvcMock});
        Assertions.assertNull((Object)BearerTokenContext.getBearerToken());
    }

    @Test
    void coreGoodHeader() throws Exception {
        Mockito.when((Object)this.requestMock.getHeader("Authorization")).thenReturn((Object)"Bearer GOOD");
        Mockito.when((Object)this.sessionMock.getAttribute("userSession")).thenReturn((Object)this.userSessionMock);
        Mockito.when((Object)this.requestMock.getSession()).thenReturn((Object)this.sessionMock);
        Mockito.when((Object)this.coreApiKeyAuthSvcMock.useCore()).thenReturn((Object)true);
        Mockito.when((Object)this.coreApiKeyAuthSvcMock.getPrincipalIdFromApiKey("GOOD", this.userSessionMock)).thenReturn(Optional.of("user"));
        this.filterChainMock.doFilter((ServletRequest)this.requestMock, (ServletResponse)this.responseMock);
        Mockito.when((Object)this.cfAuthSvcMock.validatePrincipalName(ArgumentMatchers.anyString())).thenReturn((Object)AuthenticationValidationResponse.VALID_AUTHENTICATION);
        this.cut.doFilter((ServletRequest)this.requestMock, (ServletResponse)this.responseMock, this.filterChainMock);
        ((HttpServletRequest)Mockito.verify((Object)this.requestMock, (VerificationMode)Mockito.times((int)2))).getHeader(ArgumentMatchers.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.requestMock});
        ((CoreApiKeyAuthenticationService)Mockito.verify((Object)this.coreApiKeyAuthSvcMock)).useCore();
        ((CoreApiKeyAuthenticationService)Mockito.verify((Object)this.coreApiKeyAuthSvcMock)).getPrincipalIdFromApiKey(ArgumentMatchers.anyString(), (UserSession)ArgumentMatchers.eq((Object)this.userSessionMock));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.coreApiKeyAuthSvcMock});
        ((FilterChain)Mockito.verify((Object)this.filterChainMock, (VerificationMode)Mockito.times((int)2))).doFilter((ServletRequest)this.requestMock, (ServletResponse)this.responseMock);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.filterChainMock});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.jwtSvcMock});
        Assertions.assertEquals((Object)"GOOD", (Object)BearerTokenContext.getBearerToken());
    }

    @Test
    void coreGoodHeaderInactiveUser() throws Exception {
        Mockito.when((Object)this.requestMock.getHeader("Authorization")).thenReturn((Object)"Bearer GOOD");
        Mockito.when((Object)this.coreApiKeyAuthSvcMock.useCore()).thenReturn((Object)true);
        Mockito.when((Object)this.sessionMock.getAttribute("userSession")).thenReturn((Object)this.userSessionMock);
        Mockito.when((Object)this.requestMock.getSession()).thenReturn((Object)this.sessionMock);
        Mockito.when((Object)this.coreApiKeyAuthSvcMock.getPrincipalIdFromApiKey("GOOD", this.userSessionMock)).thenReturn(Optional.of("user"));
        Mockito.when((Object)this.cfAuthSvcMock.validatePrincipalName(ArgumentMatchers.anyString())).thenReturn((Object)AuthenticationValidationResponse.INVALID_PRINCIPAL_CANNOT_LOGIN);
        this.expectForbiddenResponse();
        this.cut.doFilter((ServletRequest)this.requestMock, (ServletResponse)this.responseMock, this.filterChainMock);
        ((HttpServletRequest)Mockito.verify((Object)this.requestMock)).getHeader(ArgumentMatchers.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.requestMock});
        ((CoreApiKeyAuthenticationService)Mockito.verify((Object)this.coreApiKeyAuthSvcMock)).useCore();
        ((CoreApiKeyAuthenticationService)Mockito.verify((Object)this.coreApiKeyAuthSvcMock)).getPrincipalIdFromApiKey(ArgumentMatchers.anyString(), (UserSession)ArgumentMatchers.eq((Object)this.userSessionMock));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.coreApiKeyAuthSvcMock});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.filterChainMock});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.jwtSvcMock});
        Assertions.assertNull((Object)BearerTokenContext.getBearerToken());
    }

    private void expectForbiddenResponse() throws Exception {
        this.responseMock.setStatus(403);
        Mockito.when((Object)this.responseMock.getWriter()).thenReturn((Object)this.writerMock);
        this.writerMock.println("[ \"Forbidden\" ]");
    }
}

