/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.web.filter;

import java.io.PrintWriter;
import java.util.Optional;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.kns.bo.AuthenticationValidationResponse;
import org.kuali.kfs.kns.service.CfAuthenticationService;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.sys.businessobject.JwtData;
import org.kuali.kfs.sys.service.CoreApiKeyAuthenticationService;
import org.kuali.kfs.sys.service.JwtService;
import org.kuali.kfs.sys.util.BearerTokenContext;
import org.kuali.kfs.web.filter.ResourceLoginFilter;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
@Execution(value=ExecutionMode.SAME_THREAD)
class ResourceLoginFilterTest {
    private ResourceLoginFilter cut;
    @Mock
    private CfAuthenticationService cfAuthSvcMock;
    @Mock
    private CoreApiKeyAuthenticationService coreApiKeyAuthSvcMock;
    @Mock
    private JwtService jwtSvcMock;
    private boolean userSessionEstablished;

    ResourceLoginFilterTest() {
    }

    @BeforeEach
    void setUp() {
        this.cut = new ResourceLoginFilter(){

            protected JwtService getJwtService() {
                return ResourceLoginFilterTest.this.jwtSvcMock;
            }

            protected CoreApiKeyAuthenticationService getCoreApiKeyAuthenticationService() {
                return ResourceLoginFilterTest.this.coreApiKeyAuthSvcMock;
            }

            protected boolean isUserSessionEstablished(HttpServletRequest request) {
                return ResourceLoginFilterTest.this.userSessionEstablished;
            }

            protected void establishUserSession(HttpServletRequest request, HttpServletResponse response) {
            }

            protected void setUserSession(HttpServletRequest request, String principalName) {
            }

            protected CfAuthenticationService getCfAuthenticationService() {
                return ResourceLoginFilterTest.this.cfAuthSvcMock;
            }
        };
        this.userSessionEstablished = false;
    }

    @AfterEach
    void tearDown() {
        BearerTokenContext.clear();
    }

    @Test
    void pathDoesNotRequireAuthentication(@Mock HttpServletRequest requestMock, @Mock HttpServletResponse responseMock, @Mock FilterChain filterChainMock) throws Exception {
        this.userSessionEstablished = false;
        Mockito.when((Object)requestMock.getPathInfo()).thenReturn((Object)"/health/check");
        this.cut.doFilter((ServletRequest)requestMock, (ServletResponse)responseMock, filterChainMock);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{requestMock});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{responseMock});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.cfAuthSvcMock});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.coreApiKeyAuthSvcMock});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.jwtSvcMock});
        Assertions.assertNull((Object)BearerTokenContext.getBearerToken());
    }

    @Test
    void notInSession(@Mock HttpServletRequest requestMock, @Mock HttpSession sessionMock, @Mock UserSession userSessionMock, @Mock HttpServletResponse responseMock, @Mock PrintWriter writerMock, @Mock FilterChain filterChainMock) throws Exception {
        this.userSessionEstablished = false;
        Mockito.when((Object)requestMock.getPathInfo()).thenReturn((Object)"/foo");
        Mockito.when((Object)requestMock.getHeader("Authorization")).thenReturn(null);
        responseMock.setStatus(401);
        Mockito.when((Object)responseMock.getWriter()).thenReturn((Object)writerMock);
        writerMock.println("[ \"Unauthorized\" ]");
        Mockito.when((Object)sessionMock.getAttribute("userSession")).thenReturn((Object)userSessionMock);
        Mockito.when((Object)requestMock.getSession()).thenReturn((Object)sessionMock);
        this.cut.doFilter((ServletRequest)requestMock, (ServletResponse)responseMock, filterChainMock);
        ((HttpServletRequest)Mockito.verify((Object)requestMock)).getHeader(ArgumentMatchers.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{requestMock});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.coreApiKeyAuthSvcMock});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.jwtSvcMock});
        Assertions.assertNull((Object)BearerTokenContext.getBearerToken());
    }

    @Test
    void notInSessionOrRequest(@Mock HttpServletRequest requestMock, @Mock HttpSession sessionMock, @Mock UserSession userSessionMock, @Mock HttpServletResponse responseMock, @Mock PrintWriter writerMock, @Mock FilterChain filterChainMock) throws Exception {
        this.userSessionEstablished = false;
        Mockito.when((Object)requestMock.getPathInfo()).thenReturn((Object)"/foo");
        Mockito.when((Object)requestMock.getHeader("Authorization")).thenReturn(null);
        responseMock.setStatus(401);
        Mockito.when((Object)responseMock.getWriter()).thenReturn((Object)writerMock);
        writerMock.println("[ \"Unauthorized\" ]");
        Mockito.when((Object)sessionMock.getAttribute("userSession")).thenReturn((Object)userSessionMock);
        Mockito.when((Object)requestMock.getSession()).thenReturn((Object)sessionMock);
        this.cut.doFilter((ServletRequest)requestMock, (ServletResponse)responseMock, filterChainMock);
        ((HttpServletRequest)Mockito.verify((Object)requestMock)).getHeader(ArgumentMatchers.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{requestMock});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.coreApiKeyAuthSvcMock});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.jwtSvcMock});
        Assertions.assertNull((Object)BearerTokenContext.getBearerToken());
    }

    @Test
    void inSession(@Mock HttpServletRequest requestMock, @Mock HttpSession sessionMock, @Mock UserSession userSessionMock, @Mock HttpServletResponse responseMock, @Mock FilterChain filterChainMock) throws Exception {
        this.userSessionEstablished = true;
        Mockito.when((Object)requestMock.getPathInfo()).thenReturn((Object)"/foo");
        Mockito.when((Object)userSessionMock.getPrincipalName()).thenReturn((Object)"SomeUser");
        Mockito.when((Object)sessionMock.getAttribute("userSession")).thenReturn((Object)userSessionMock);
        Mockito.when((Object)requestMock.getHeader("Authorization")).thenReturn(null);
        Mockito.when((Object)requestMock.getSession()).thenReturn((Object)sessionMock);
        filterChainMock.doFilter((ServletRequest)requestMock, (ServletResponse)responseMock);
        Mockito.when((Object)this.cfAuthSvcMock.validatePrincipalName(ArgumentMatchers.anyString())).thenReturn((Object)AuthenticationValidationResponse.VALID_AUTHENTICATION);
        this.cut.doFilter((ServletRequest)requestMock, (ServletResponse)responseMock, filterChainMock);
        ((HttpServletRequest)Mockito.verify((Object)requestMock, (VerificationMode)Mockito.times((int)2))).getHeader(ArgumentMatchers.anyString());
        ((FilterChain)Mockito.verify((Object)filterChainMock, (VerificationMode)Mockito.times((int)2))).doFilter((ServletRequest)requestMock, (ServletResponse)responseMock);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{filterChainMock});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.jwtSvcMock});
        Assertions.assertNull((Object)BearerTokenContext.getBearerToken());
    }

    @Test
    void inSessionEmptyHeader(@Mock HttpServletRequest requestMock, @Mock HttpSession sessionMock, @Mock UserSession userSessionMock, @Mock HttpServletResponse responseMock, @Mock PrintWriter writerMock, @Mock FilterChain filterChainMock) throws Exception {
        this.userSessionEstablished = true;
        Mockito.when((Object)requestMock.getPathInfo()).thenReturn((Object)"/foo");
        Mockito.when((Object)userSessionMock.getPrincipalName()).thenReturn((Object)"SomeUser");
        Mockito.when((Object)sessionMock.getAttribute("userSession")).thenReturn((Object)userSessionMock);
        Mockito.when((Object)requestMock.getHeader("Authorization")).thenReturn((Object)"");
        Mockito.when((Object)requestMock.getSession()).thenReturn((Object)sessionMock);
        responseMock.setStatus(401);
        writerMock.println("[ \"Unauthorized\" ]");
        filterChainMock.doFilter((ServletRequest)requestMock, (ServletResponse)responseMock);
        Mockito.when((Object)this.cfAuthSvcMock.validatePrincipalName(ArgumentMatchers.anyString())).thenReturn((Object)AuthenticationValidationResponse.VALID_AUTHENTICATION);
        this.cut.doFilter((ServletRequest)requestMock, (ServletResponse)responseMock, filterChainMock);
        ((HttpServletRequest)Mockito.verify((Object)requestMock, (VerificationMode)Mockito.times((int)2))).getHeader(ArgumentMatchers.anyString());
        ((FilterChain)Mockito.verify((Object)filterChainMock, (VerificationMode)Mockito.times((int)2))).doFilter((ServletRequest)requestMock, (ServletResponse)responseMock);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{filterChainMock});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.jwtSvcMock});
        Assertions.assertNull((Object)BearerTokenContext.getBearerToken());
    }

    @Test
    void blankAuthHeader(@Mock HttpServletRequest requestMock, @Mock HttpSession sessionMock, @Mock UserSession userSessionMock, @Mock HttpServletResponse responseMock, @Mock PrintWriter writerMock, @Mock FilterChain filterChainMock) throws Exception {
        Mockito.when((Object)requestMock.getPathInfo()).thenReturn((Object)"/foo");
        Mockito.when((Object)requestMock.getHeader("Authorization")).thenReturn((Object)"");
        responseMock.setStatus(401);
        Mockito.when((Object)responseMock.getWriter()).thenReturn((Object)writerMock);
        writerMock.println("[ \"Unauthorized\" ]");
        Mockito.when((Object)sessionMock.getAttribute("userSession")).thenReturn((Object)userSessionMock);
        Mockito.when((Object)requestMock.getSession()).thenReturn((Object)sessionMock);
        this.cut.doFilter((ServletRequest)requestMock, (ServletResponse)responseMock, filterChainMock);
        ((HttpServletRequest)Mockito.verify((Object)requestMock)).getHeader(ArgumentMatchers.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{requestMock});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.coreApiKeyAuthSvcMock});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{filterChainMock});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.jwtSvcMock});
        Assertions.assertNull((Object)BearerTokenContext.getBearerToken());
    }

    @Test
    void noBearerHeader(@Mock HttpServletRequest requestMock, @Mock HttpSession sessionMock, @Mock UserSession userSessionMock, @Mock HttpServletResponse responseMock, @Mock PrintWriter writerMock, @Mock FilterChain filterChainMock) throws Exception {
        Mockito.when((Object)requestMock.getPathInfo()).thenReturn((Object)"/foo");
        Mockito.when((Object)requestMock.getHeader("Authorization")).thenReturn((Object)"XXX");
        responseMock.setStatus(401);
        Mockito.when((Object)responseMock.getWriter()).thenReturn((Object)writerMock);
        writerMock.println("[ \"Unauthorized\" ]");
        Mockito.when((Object)sessionMock.getAttribute("userSession")).thenReturn((Object)userSessionMock);
        Mockito.when((Object)requestMock.getSession()).thenReturn((Object)sessionMock);
        this.cut.doFilter((ServletRequest)requestMock, (ServletResponse)responseMock, filterChainMock);
        ((HttpServletRequest)Mockito.verify((Object)requestMock)).getHeader(ArgumentMatchers.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{requestMock});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.coreApiKeyAuthSvcMock});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{filterChainMock});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.jwtSvcMock});
        Assertions.assertNull((Object)BearerTokenContext.getBearerToken());
    }

    @Test
    void onlyBearerHeader(@Mock HttpServletRequest requestMock, @Mock HttpSession sessionMock, @Mock UserSession userSessionMock, @Mock HttpServletResponse responseMock, @Mock PrintWriter writerMock, @Mock FilterChain filterChainMock) throws Exception {
        Mockito.when((Object)requestMock.getPathInfo()).thenReturn((Object)"/foo");
        Mockito.when((Object)requestMock.getHeader("Authorization")).thenReturn((Object)"Bearer");
        responseMock.setStatus(401);
        Mockito.when((Object)responseMock.getWriter()).thenReturn((Object)writerMock);
        writerMock.println("[ \"Unauthorized\" ]");
        Mockito.when((Object)sessionMock.getAttribute("userSession")).thenReturn((Object)userSessionMock);
        Mockito.when((Object)requestMock.getSession()).thenReturn((Object)sessionMock);
        this.cut.doFilter((ServletRequest)requestMock, (ServletResponse)responseMock, filterChainMock);
        ((HttpServletRequest)Mockito.verify((Object)requestMock)).getHeader(ArgumentMatchers.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{requestMock});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.coreApiKeyAuthSvcMock});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{filterChainMock});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.jwtSvcMock});
        Assertions.assertNull((Object)BearerTokenContext.getBearerToken());
    }

    @Test
    void blankKeyHeader(@Mock HttpServletRequest requestMock, @Mock HttpSession sessionMock, @Mock UserSession userSessionMock, @Mock HttpServletResponse responseMock, @Mock PrintWriter writerMock, @Mock FilterChain filterChainMock) throws Exception {
        Mockito.when((Object)requestMock.getPathInfo()).thenReturn((Object)"/foo");
        Mockito.when((Object)requestMock.getHeader("Authorization")).thenReturn((Object)"Bearer ");
        responseMock.setStatus(401);
        Mockito.when((Object)responseMock.getWriter()).thenReturn((Object)writerMock);
        writerMock.println("[ \"Unauthorized\" ]");
        Mockito.when((Object)sessionMock.getAttribute("userSession")).thenReturn((Object)userSessionMock);
        Mockito.when((Object)requestMock.getSession()).thenReturn((Object)sessionMock);
        this.cut.doFilter((ServletRequest)requestMock, (ServletResponse)responseMock, filterChainMock);
        ((HttpServletRequest)Mockito.verify((Object)requestMock)).getHeader(ArgumentMatchers.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{requestMock});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.coreApiKeyAuthSvcMock});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{filterChainMock});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.jwtSvcMock});
        Assertions.assertNull((Object)BearerTokenContext.getBearerToken());
    }

    @Test
    void nonCoreBadHeader(@Mock HttpServletRequest requestMock, @Mock HttpSession sessionMock, @Mock UserSession userSessionMock, @Mock HttpServletResponse responseMock, @Mock PrintWriter writerMock, @Mock FilterChain filterChainMock) throws Exception {
        Mockito.when((Object)requestMock.getPathInfo()).thenReturn((Object)"/foo");
        Mockito.when((Object)requestMock.getHeader("Authorization")).thenReturn((Object)"Bearer BAD");
        Mockito.when((Object)sessionMock.getAttribute("userSession")).thenReturn((Object)userSessionMock);
        Mockito.when((Object)requestMock.getSession()).thenReturn((Object)sessionMock);
        Mockito.when((Object)this.coreApiKeyAuthSvcMock.useCore()).thenReturn((Object)false);
        Mockito.when((Object)this.jwtSvcMock.decodeJwt("BAD")).thenThrow(new Throwable[]{new RuntimeException("Error")});
        responseMock.setStatus(401);
        Mockito.when((Object)responseMock.getWriter()).thenReturn((Object)writerMock);
        writerMock.println("[ \"Unauthorized\" ]");
        this.cut.doFilter((ServletRequest)requestMock, (ServletResponse)responseMock, filterChainMock);
        ((HttpServletRequest)Mockito.verify((Object)requestMock)).getHeader(ArgumentMatchers.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{requestMock});
        ((CoreApiKeyAuthenticationService)Mockito.verify((Object)this.coreApiKeyAuthSvcMock)).useCore();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.coreApiKeyAuthSvcMock});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{filterChainMock});
        ((JwtService)Mockito.verify((Object)this.jwtSvcMock)).decodeJwt(ArgumentMatchers.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.jwtSvcMock});
        Assertions.assertNull((Object)BearerTokenContext.getBearerToken());
    }

    @Test
    void nonCoreGoodHeader(@Mock HttpServletRequest requestMock, @Mock HttpSession sessionMock, @Mock UserSession userSessionMock, @Mock HttpServletResponse responseMock, @Mock FilterChain filterChainMock) throws Exception {
        Mockito.when((Object)requestMock.getPathInfo()).thenReturn((Object)"/foo");
        Mockito.when((Object)requestMock.getHeader("Authorization")).thenReturn((Object)"Bearer GOOD");
        Mockito.when((Object)sessionMock.getAttribute("userSession")).thenReturn((Object)userSessionMock);
        Mockito.when((Object)requestMock.getSession()).thenReturn((Object)sessionMock);
        Mockito.when((Object)this.coreApiKeyAuthSvcMock.useCore()).thenReturn((Object)false);
        JwtData data = new JwtData();
        data.setPrincipalName("user");
        Mockito.when((Object)this.jwtSvcMock.decodeJwt("GOOD")).thenReturn((Object)data);
        filterChainMock.doFilter((ServletRequest)requestMock, (ServletResponse)responseMock);
        Mockito.when((Object)this.cfAuthSvcMock.validatePrincipalName(ArgumentMatchers.anyString())).thenReturn((Object)AuthenticationValidationResponse.VALID_AUTHENTICATION);
        this.cut.doFilter((ServletRequest)requestMock, (ServletResponse)responseMock, filterChainMock);
        ((HttpServletRequest)Mockito.verify((Object)requestMock, (VerificationMode)Mockito.times((int)2))).getHeader(ArgumentMatchers.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{requestMock});
        ((CoreApiKeyAuthenticationService)Mockito.verify((Object)this.coreApiKeyAuthSvcMock)).useCore();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.coreApiKeyAuthSvcMock});
        ((JwtService)Mockito.verify((Object)this.jwtSvcMock)).decodeJwt(ArgumentMatchers.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.jwtSvcMock});
        ((FilterChain)Mockito.verify((Object)filterChainMock, (VerificationMode)Mockito.times((int)2))).doFilter((ServletRequest)requestMock, (ServletResponse)responseMock);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{filterChainMock});
        Assertions.assertEquals((Object)"GOOD", (Object)BearerTokenContext.getBearerToken());
    }

    @Test
    void coreBadHeader(@Mock HttpServletRequest requestMock, @Mock HttpSession sessionMock, @Mock UserSession userSessionMock, @Mock HttpServletResponse responseMock, @Mock PrintWriter writerMock, @Mock FilterChain filterChainMock) throws Exception {
        Mockito.when((Object)requestMock.getPathInfo()).thenReturn((Object)"/foo");
        Mockito.when((Object)requestMock.getHeader("Authorization")).thenReturn((Object)"Bearer BAD");
        Mockito.when((Object)sessionMock.getAttribute("userSession")).thenReturn((Object)userSessionMock);
        Mockito.when((Object)requestMock.getSession()).thenReturn((Object)sessionMock);
        Mockito.when((Object)this.coreApiKeyAuthSvcMock.useCore()).thenReturn((Object)true);
        Mockito.when((Object)this.coreApiKeyAuthSvcMock.getPrincipalIdFromApiKey("BAD", userSessionMock)).thenReturn(Optional.empty());
        responseMock.setStatus(401);
        Mockito.when((Object)responseMock.getWriter()).thenReturn((Object)writerMock);
        writerMock.println("[ \"Unauthorized\" ]");
        this.cut.doFilter((ServletRequest)requestMock, (ServletResponse)responseMock, filterChainMock);
        ((HttpServletRequest)Mockito.verify((Object)requestMock)).getHeader(ArgumentMatchers.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{requestMock});
        ((CoreApiKeyAuthenticationService)Mockito.verify((Object)this.coreApiKeyAuthSvcMock)).useCore();
        ((CoreApiKeyAuthenticationService)Mockito.verify((Object)this.coreApiKeyAuthSvcMock)).getPrincipalIdFromApiKey(ArgumentMatchers.anyString(), (UserSession)ArgumentMatchers.eq((Object)userSessionMock));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.coreApiKeyAuthSvcMock});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{filterChainMock});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.jwtSvcMock});
        Assertions.assertNull((Object)BearerTokenContext.getBearerToken());
    }

    @Test
    void coreGoodHeader(@Mock HttpServletRequest requestMock, @Mock HttpSession sessionMock, @Mock UserSession userSessionMock, @Mock HttpServletResponse responseMock, @Mock FilterChain filterChainMock) throws Exception {
        Mockito.when((Object)requestMock.getPathInfo()).thenReturn((Object)"/foo");
        Mockito.when((Object)requestMock.getHeader("Authorization")).thenReturn((Object)"Bearer GOOD");
        Mockito.when((Object)sessionMock.getAttribute("userSession")).thenReturn((Object)userSessionMock);
        Mockito.when((Object)requestMock.getSession()).thenReturn((Object)sessionMock);
        Mockito.when((Object)this.coreApiKeyAuthSvcMock.useCore()).thenReturn((Object)true);
        Mockito.when((Object)this.coreApiKeyAuthSvcMock.getPrincipalIdFromApiKey("GOOD", userSessionMock)).thenReturn(Optional.of("user"));
        filterChainMock.doFilter((ServletRequest)requestMock, (ServletResponse)responseMock);
        Mockito.when((Object)this.cfAuthSvcMock.validatePrincipalName(ArgumentMatchers.anyString())).thenReturn((Object)AuthenticationValidationResponse.VALID_AUTHENTICATION);
        this.cut.doFilter((ServletRequest)requestMock, (ServletResponse)responseMock, filterChainMock);
        ((HttpServletRequest)Mockito.verify((Object)requestMock, (VerificationMode)Mockito.times((int)2))).getHeader(ArgumentMatchers.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{requestMock});
        ((CoreApiKeyAuthenticationService)Mockito.verify((Object)this.coreApiKeyAuthSvcMock)).useCore();
        ((CoreApiKeyAuthenticationService)Mockito.verify((Object)this.coreApiKeyAuthSvcMock)).getPrincipalIdFromApiKey(ArgumentMatchers.anyString(), (UserSession)ArgumentMatchers.eq((Object)userSessionMock));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.coreApiKeyAuthSvcMock});
        ((FilterChain)Mockito.verify((Object)filterChainMock, (VerificationMode)Mockito.times((int)2))).doFilter((ServletRequest)requestMock, (ServletResponse)responseMock);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{filterChainMock});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.jwtSvcMock});
        Assertions.assertEquals((Object)"GOOD", (Object)BearerTokenContext.getBearerToken());
    }

    @Test
    void coreGoodHeaderInactiveUser(@Mock HttpServletRequest requestMock, @Mock HttpSession sessionMock, @Mock UserSession userSessionMock, @Mock HttpServletResponse responseMock, @Mock PrintWriter writerMock, @Mock FilterChain filterChainMock) throws Exception {
        Mockito.when((Object)requestMock.getPathInfo()).thenReturn((Object)"/foo");
        Mockito.when((Object)requestMock.getHeader("Authorization")).thenReturn((Object)"Bearer GOOD");
        Mockito.when((Object)this.coreApiKeyAuthSvcMock.useCore()).thenReturn((Object)true);
        Mockito.when((Object)sessionMock.getAttribute("userSession")).thenReturn((Object)userSessionMock);
        Mockito.when((Object)requestMock.getSession()).thenReturn((Object)sessionMock);
        Mockito.when((Object)this.coreApiKeyAuthSvcMock.getPrincipalIdFromApiKey("GOOD", userSessionMock)).thenReturn(Optional.of("user"));
        Mockito.when((Object)this.cfAuthSvcMock.validatePrincipalName(ArgumentMatchers.anyString())).thenReturn((Object)AuthenticationValidationResponse.INVALID_PRINCIPAL_CANNOT_LOGIN);
        ResourceLoginFilterTest.expectForbiddenResponse(responseMock, writerMock);
        this.cut.doFilter((ServletRequest)requestMock, (ServletResponse)responseMock, filterChainMock);
        ((HttpServletRequest)Mockito.verify((Object)requestMock)).getHeader(ArgumentMatchers.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{requestMock});
        ((CoreApiKeyAuthenticationService)Mockito.verify((Object)this.coreApiKeyAuthSvcMock)).useCore();
        ((CoreApiKeyAuthenticationService)Mockito.verify((Object)this.coreApiKeyAuthSvcMock)).getPrincipalIdFromApiKey(ArgumentMatchers.anyString(), (UserSession)ArgumentMatchers.eq((Object)userSessionMock));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.coreApiKeyAuthSvcMock});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{filterChainMock});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.jwtSvcMock});
        Assertions.assertNull((Object)BearerTokenContext.getBearerToken());
    }

    private static void expectForbiddenResponse(HttpServletResponse responseMock, PrintWriter writerMock) throws Exception {
        responseMock.setStatus(403);
        Mockito.when((Object)responseMock.getWriter()).thenReturn((Object)writerMock);
        writerMock.println("[ \"Forbidden\" ]");
    }
}

