<%--

    The Kuali Financial System, a comprehensive financial management system for higher education.

    Copyright 2005-2023 Kuali, Inc.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

--%>
<%@ include file="/jsp/sys/kfsTldHeader.jsp"%>

<c:set var="groupAttributes" value="${DataDictionary.Group.attributes}" />
<c:set var="groupTypeAttributes" value="${DataDictionary.KimType.attributes}" />

<kul:tab tabTitle="Overview" defaultOpen="true" tabErrorKey="document.group*,document.active">
<div class="tab-container" align="center">
	<table cellpadding="0" cellspacing="0" summary="" class="datatable standard old-new">
	 	<tr>
			<th class="grid right"><kul:htmlAttributeLabel attributeEntry="${groupAttributes.id}"  /></th>
	 		<td class="grid"><kul:htmlControlAttribute property="document.groupId" attributeEntry="${groupAttributes.id}" readOnly="true" /></td>
    		<th class="grid right"><kul:htmlAttributeLabel attributeEntry="${groupTypeAttributes.name}"  /></th>
	 		<td class="grid">
	 		    <kul:htmlControlAttribute property="document.groupTypeName" attributeEntry="${groupTypeAttributes.name}" readOnly="true" />
				<c:if test="${!readOnly}">
	            	<c:set var="bo" value="${KualiForm.kimTypeClass}"/>
	               	<kul:lookup boClassName="${bo}"
	               	   fieldConversions=""  />
	           	</c:if>
	 		</td>
	 		<html:hidden property="document.groupTypeId" />
	 	</tr>
	 	<tr>
    		<th class="grid right"><kul:htmlAttributeLabel attributeEntry="${groupAttributes.namespaceCode}"  /></th>
	 		<td class="grid">
	 		    <kul:htmlControlAttribute property="document.groupNamespace" attributeEntry="${groupAttributes.namespaceCode}" readOnly="${(readOnly || editingDocument)}" onchange="namespaceChanged( this.form );" />
	 		    <c:if test="${!readOnly && !editingDocument}">
	 		        <noscript>
	 		            <html:image tabindex="32768" property="methodToCall.changeNamespace" src="${ConfigProperties.externalizable.images.url}tinybutton-refresh.gif" styleClass="tinybutton" title="Click to refresh the page after changing the namespace." alt="Click to refresh the page after changing the namespace." />
	 		        </noscript>
	 		    </c:if>
	 		</td>
    		<th class="grid right"><kul:htmlAttributeLabel attributeEntry="${groupAttributes.name}"  /></th>
	 		<td class="grid"><kul:htmlControlAttribute property="document.groupName" attributeEntry="${groupAttributes.name}" readOnly="${(readOnly || editingDocument)}" /></td>
	 	</tr>
	 	<tr>
			<th class="grid right"><kul:htmlAttributeLabel attributeEntry="${groupAttributes.active}"  /></th>
	 		<td class="grid"><kul:htmlControlAttribute property="document.active" attributeEntry="${groupAttributes.active}" readOnly="${readOnly}" /></td>

			<th class="grid right"><kul:htmlAttributeLabel attributeEntry="${groupAttributes.description}"  /></th>
		    <td class="grid"><kul:htmlControlAttribute property="document.groupDescription" attributeEntry="${groupAttributes.description}" readOnly="${readOnly}" /></td>
	 	</tr>
	</table>
</div>
</kul:tab>
