<%--

    The Kuali Financial System, a comprehensive financial management system for higher education.

    Copyright 2005-2023 Kuali, Inc.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

--%>
<%@ include file="/jsp/sys/kfsTldHeader.jsp"%>

<%@ attribute name="readOnly" required="true"
    description="If document is in read only mode"%>

<c:set var="ContractsGrantsCollectionActivityAttributes"
    value="${DataDictionary.ContractsGrantsCollectionActivityDocument.attributes}"/>

<kul:tab tabTitle="Award Information" defaultOpen="true" tabErrorKey="document.proposalNumber">
    <div class="tab-container" align="center">
        <table width="100%" cellpadding="0" cellspacing="0" class="datatable">
            <tr>
                <kul:htmlAttributeHeaderCell
                        width="50%"
                        attributeEntry="${ContractsGrantsCollectionActivityAttributes.proposalNumber}"
                        useShortLabel="false"
                        horizontal="true"
                        addClass="right"/>
                <td>
                    <a
                            href="${ConfigProperties.application.url}/inquiry.do?methodToCall=start&businessObjectClassName=org.kuali.kfs.module.cg.businessobject.Award&mode=modal&proposalNumber=${KualiForm.document.proposalNumber}" data-remodal-target="modal">
                    <kul:htmlControlAttribute readOnly="true"
                        attributeEntry="${ContractsGrantsCollectionActivityAttributes.proposalNumber}"
                        property="document.proposalNumber" forceRequired="true" />
                    </a>
                    <c:if test="${not readOnly}">
                        <kul:lookup
                            boClassName="org.kuali.kfs.module.cg.businessobject.Award"
                            fieldConversions="proposalNumber:document.proposalNumber" />
                    </c:if>
                </td>
            </tr>

            <tr>
                <kul:htmlAttributeHeaderCell
                        attributeEntry="${ContractsGrantsCollectionActivityAttributes.agencyNumber}"
                        useShortLabel="false"
                        horizontal="true"
                        addClass="right"/>
                <td>
                    <div id="document.agencyNumber.div">
                        <a
                                href="${ConfigProperties.application.url}/inquiry.do?methodToCall=start&businessObjectClassName=org.kuali.kfs.module.cg.businessobject.Agency&mode=modal&agencyNumber=${KualiForm.document.agencyNumber}" data-remodal-target="modal">
                        <kul:htmlControlAttribute readOnly="true"
                            attributeEntry="${ContractsGrantsCollectionActivityAttributes.agencyNumber}"
                            property="document.agencyNumber" />
                        </a>
                    </div>
                </td>
            </tr>
            <tr>
                <kul:htmlAttributeHeaderCell
                        attributeEntry="${ContractsGrantsCollectionActivityAttributes.agencyName}"
                        useShortLabel="false"
                        horizontal="true"
                        addClass="right"/>
                <td>
                    <div id="document.agencyName.div">
                        <kul:htmlControlAttribute readOnly="true"
                            attributeEntry="${ContractsGrantsCollectionActivityAttributes.agencyName}"
                            property="document.agencyName" />
                    </div>
                </td>
            </tr>

            <tr>
                <kul:htmlAttributeHeaderCell
                        attributeEntry="${ContractsGrantsCollectionActivityAttributes.customerNumber}"
                        useShortLabel="false"
                        horizontal="true"
                        addClass="right"/>
                <td>
                    <div id="document.customerNumber.div">
                        <a href="${ConfigProperties.application.url}/inquiry.do?methodToCall=start&businessObjectClassName=org.kuali.kfs.module.ar.businessobject.Customer&mode=modal&customerNumber=${KualiForm.document.customerNumber}" data-remodal-target="modal">
                        <kul:htmlControlAttribute readOnly="true"
                            attributeEntry="${ContractsGrantsCollectionActivityAttributes.customerNumber}"
                            property="document.customerNumber" />
                        </a>
                    </div>
                </td>
            </tr>

            <tr>
                <kul:htmlAttributeHeaderCell
                        attributeEntry="${ContractsGrantsCollectionActivityAttributes.customerName}"
                        useShortLabel="false"
                        horizontal="true"
                        addClass="right"/>
                <td>
                    <div id="document.customerName.div">
                        <kul:htmlControlAttribute readOnly="true"
                            attributeEntry="${ContractsGrantsCollectionActivityAttributes.customerName}"
                            property="document.customerName" />
                    </div>
                </td>
            </tr>
        </table>
    </div>
</kul:tab>
