<%--

    The Kuali Financial System, a comprehensive financial management system for higher education.

    Copyright 2005-2023 Kuali, Inc.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

--%>
<%@ include file="/jsp/sys/kfsTldHeader.jsp"%>

<kul:tab tabTitle="Action Items" defaultOpen="true">
<div class="tab-container">
  <table class="standard side-margins">
      <c:choose>
      <c:when test="${empty DocumentOperationForm.actionItems}">
      <tr><td class="datacell" colspan="2" align="center" height="15">None</td></tr>
      </c:when>
      <c:otherwise>
      <logic-el:iterate id="actionItem" name="DocumentOperationForm" property="actionItems" indexId="ctr">
        <html-el:hidden property="actionItems[${ctr}].id" />
          <tr>
            <td width="33%" class="headercell3-b-l" align="right"><b> Action Item ID: </b><c:out value="${actionItem.id}" /> </td>
            <td width="66%" class="headercell3-b-l">
              <html-el:radio property="actionItemOp[${ctr}].value" value="update"/>Update &nbsp;&nbsp;<html-el:radio property="actionItemOp[${ctr}].value" value="delete"/>Delete&nbsp;&nbsp;<html-el:radio property="actionItemOp[${ctr}].value" value="noop"/>No Operation&nbsp;&nbsp;
                    <html-el:hidden property="actionItemOp[${ctr}].index" />
            </td>
          </tr>
          <tr>
            <td width="33%" align="right" class="thnormal">* Document ID:</td>
            <td width="66%" class="datacell"><html-el:text property="actionItems[${ctr}].documentId" /></td>
          </tr>
          <tr>
            <td width="33%" align="right" class="thnormal">* Doc Type Name:</td>
            <td width="66%" class="datacell"><html-el:text property="actionItems[${ctr}].docName" />
                <kul:lookup boClassName="org.kuali.kfs.kew.doctype.bo.DocumentType" fieldConversions="name:actionItems[${ctr}].docName" lookupParameters="actionItems[${ctr}].docName:name" />
            </td>
          </tr>
          <tr>
            <td width="33%" align="right" class="thnormal">* Doc Type Label:</td>
            <td width="66%" class="datacell"><html-el:text property="actionItems[${ctr}].docLabel" /></td>
          </tr>
          <tr>
            <td width="33%" align="right" class="thnormal">* Doc Handler URL:</td>
            <td width="66%" class="datacell"><html-el:text property="actionItems[${ctr}].docHandlerURL" /></td>
          </tr>
          <tr>
            <td width="33%" align="right" class="thnormal">* Date Assigned:</td>
            <td width="66%" class="datacell">
              <html-el:text property="actionItems[${ctr}].dateAssignedStringValue" styleId="actionsItems${ctr}" />
              <img
                src="${ConfigProperties.externalizable.images.url}cal.png"
                id="actionsItems${ctr}_trigger"
                style="width: 24px;"
                align="absmiddle"
                alt="Action Items Date"
              >
              <script type="text/javascript">
                // This is located here because we're inside of the iterate loop and need the counter var
                (function () {
                  Calendar.setup({
                    inputField     :    "actionsItems${ctr}",     // id of the input field
                    ifFormat       :    "%m/%d/%Y",     // format of the input field (even if hidden, this format will be honored)
                    button         :    "actionsItems${ctr}_trigger", // the button or image that triggers this
                    daFormat       :    "%A, %B %d, %Y",// format of the displayed date
                    singleClick    :    true,
                    timeFormat     :    "12",
                    step           :    1
                  })
                })()
              </script>
            </td>
          </tr>
          <tr>
            <td width="33%" align="right" class="thnormal">* Action Request ID:</td>
            <td width="66%" class="datacell"><html-el:text property="actionItems[${ctr}].actionRequestId" /></td>
          </tr>
          <tr>
            <td width="33%" align="right" class="thnormal">* Action Requested:</td>
            <td width="66%" class="datacell"><%-- <html-el:text property="actionItems[${ctr}].actionRequestCd" />--%>
                <html-el:select property="actionItems[${ctr}].actionRequestCd" value="${actionItem.actionRequestCd}">
                  <c:set var="actionRequestCds" value="${DocumentOperationForm.actionRequestCds}"/>
                  <html-el:options collection="actionRequestCds" property="key" labelProperty="value"/>
                  </html-el:select>
            </td>
          </tr>
          <tr>
            <td width="33%" align="right" class="thnormal">* Responsibility ID:</td>
            <td width="66%" class="datacell"><html-el:text property="actionItems[${ctr}].responsibilityId" /></td>
          </tr>
          <tr>
            <td width="33%" align="right" class="thnormal">* Person ID:</td>
            <td width="66%" class="datacell"><html-el:text property="actionItems[${ctr}].principalId" />
                <kul:lookup boClassName="org.kuali.kfs.kim.impl.identity.Person" fieldConversions="principalId:actionItems[${ctr}].principalId" lookupParameters="actionItems[${ctr}].principalId:principalId" />
            </td>
          </tr>
          <tr>
            <td width="33%" align="right" class="thnormal">Workgroup ID:</td>
            <td width="66%" class="datacell"><html-el:text property="actionItems[${ctr}].groupId" />
                <kul:lookup boClassName="org.kuali.kfs.kim.impl.group.Group" fieldConversions="id:actionItems[${ctr}].groupId" lookupParameters="actionItems[${ctr}].groupId:id" />
            </td>
          </tr>
          <tr>
            <td width="33%" align="right" class="thnormal">Role Name:</td>
            <td width="66%" class="datacell"><html-el:text property="actionItems[${ctr}].roleName" />
                <kul:lookup boClassName="org.kuali.kfs.kim.impl.role.Role" fieldConversions="name:actionItems[${ctr}].roleName" lookupParameters="actionItems[${ctr}].roleName:name" />
            </td>
          </tr>
          <tr>
            <td width="33%" align="right" class="thnormal">Delegator Person ID: </td>
            <td width="66%" class="datacell"><html-el:text property="actionItems[${ctr}].delegatorPrincipalId" />
                <kul:lookup boClassName="org.kuali.kfs.kim.impl.identity.Person" fieldConversions="principalId:actionItems[${ctr}].delegatorPrincipalId" lookupParameters="actionItems[${ctr}].delegatorPrincipalId:principalId" />
            </td>
          </tr>
          <tr>
            <td width="33%" align="right" class="thnormal">Delegator Workgroup ID:</td>
            <td width="66%" class="datacell"><html-el:text property="actionItems[${ctr}].delegatorGroupId" />
                <kul:lookup boClassName="org.kuali.kfs.kim.impl.group.Group" fieldConversions="id:actionItems[${ctr}].delegatorGroupId" lookupParameters="actionItems[${ctr}].delegatorGroupId:id" />
            </td>
          </tr>
          <tr>
            <td width="33%" align="right" class="thnormal">Document Title:</td>
            <td width="66%" class="datacell"><html-el:text property="actionItems[${ctr}].docTitle" /></td>
          </tr>
      </logic-el:iterate>
      </c:otherwise>
      </c:choose>
    </table>
  </div>
</kul:tab>
