<%--

    The Kuali Financial System, a comprehensive financial management system for higher education.

    Copyright 2005-2024 Kuali, Inc.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

--%>
<%@ include file="/jsp/sys/kfsTldHeader.jsp"%>

<c:set var="personAttributes" value="${DataDictionary.Person.attributes}" />

<kul:subtab width="${tableWidth}" subTabTitle="Employment Information">
	<table class="standard side-margins">
       	<tr>
            <th width="5%" rowspan="20" style="border-style:none">&nbsp;</th>
       		<th><div align="left">&nbsp</div></th>
       		<kim:cell isLabel="true" attributeEntry="${personAttributes.employeeId}" noColon="true" />
       		<kim:cell isLabel="true" attributeEntry="${personAttributes.employeeStatusCode}" noColon="true" />
       		<kim:cell isLabel="true" attributeEntry="${personAttributes.employeeTypeCode}" noColon="true" />
       		<kim:cell isLabel="true" attributeEntry="${personAttributes.baseSalaryAmount}" noColon="true" />
       		<kim:cell isLabel="true" attributeEntry="${personAttributes.primaryDepartmentCode}" noColon="true" />
        </tr>
        <tr>
            <th><div align="left">&nbsp</div></th>
            <kim:cell valign="middle" cellClass="infoline" textAlign="center" property="document.employeeId"  attributeEntry="${personAttributes.employeeId}" readOnly="${readOnlyEntity}" />
            <kim:cell valign="middle" cellClass="infoline" textAlign="center" property="document.employeeStatusCode" attributeEntry="${personAttributes.employeeStatusCode}" readOnly="${readOnlyEntity}" />
            <kim:cell valign="middle" cellClass="infoline" textAlign="center" property="document.employeeTypeCode" attributeEntry="${personAttributes.employeeTypeCode}" readOnly="${readOnlyEntity}" />
            <kim:cell valign="middle" cellClass="infoline" textAlign="center" property="document.baseSalaryAmount" attributeEntry="${personAttributes.baseSalaryAmount}" readOnly="${readOnlyEntity}" />
            <kim:cell valign="middle" cellClass="infoline" textAlign="center" property="document.primaryDepartmentCode" attributeEntry="${personAttributes.primaryDepartmentCode}" readOnly="${readOnlyEntity}" />
        </tr>
		<tr>
            <td colspan=10 style="padding:0px; border-style:none; height:22px; background-color:#F6F6F6">&nbsp;</td>
        </tr>
	</table>
</kul:subtab>
