<%--

    The Kuali Financial System, a comprehensive financial management system for higher education.

    Copyright 2005-2024 Kuali, Inc.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

--%>
<%@ taglib uri="http://struts.apache.org/tags-bean-el" prefix="bean-el"%>
<%@ taglib uri="http://www.kuali.org/struts.apache.org/tags-html-el" prefix="html-el"%>
<%@ taglib uri="http://struts.apache.org/tags-logic-el" prefix="logic-el"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@ taglib uri="http://displaytag.sf.net" prefix="display"%>
<html-el:html>
    <head>
        <title>Configuration Viewer</title>
        <style type="text/css">
            .highlightrow {

            }

            tr.highlightrow:hover,tr.over td {
                background-color: #66FFFF;
            }
        </style>
        <style>
            .headercell1
            {
                background-color: #CCCCCC;
                border-top: 1px solid #666666;
                border-right: 1px solid #666666;
                border-bottom: 1px solid #666666;
                border-left: 1px solid #666666;
                padding: 2px;
            }
            .bord-r-t
            {
                border-top-width: 1px;
                border-top-style: solid;
                border-top-color: #999999;
                border-right-style: solid;
                border-right-color: #999999;
                border-right-width: 1px;
                border-bottom-color: #999999;
                border-left-color: #999999;
            }
            .datacell
            {
                padding: 1px 4px;
                border-bottom-width: 1px;
                border-bottom-style: solid;
                border-bottom-color: #999999;
                border-left-width: 1px;
                border-left-style: solid;
                border-left-color: #999999;
                border-top-color: #999999;
                border-right-color: #999999;
            }
            th
            {
                border-bottom-width: 1px;
                border-bottom-style: solid;
                border-bottom-color: #999999;
                border-left-width: 1px;
                border-left-style: solid;
                border-left-color: #999999;
                background-color: #CCCCCC;
                text-decoration: none;
                text-align: left;
                padding: 3px;
            }
            th.sorted {
                background-color: #ADADAD;
            }
        </style>
    </head>




    <body>
    <table width="100%" border=0 cellpadding=0 cellspacing=0
           class="headercell1">
        <tr>
            <td width="15%"></td>
            <td width="85%"><a href="ConfigViewer.do?methodToCall=refresh">Refresh Page</a></td>
            <td>&nbsp;&nbsp;</td>
        </tr>
    </table>

    <br />
    <br />

    <table width="100%" border=0 cellspacing=0 cellpadding=0>
        <tr>
            <td width="20" height="20">&nbsp;</td>
            <td>
                <b>Configured Properties:</b> <%-- Table layout of the search results --%>
                <display:table excludedParams="*" class="bord-r-t"
                               style="width:100%" cellspacing="0" cellpadding="0"
                               name="${ConfigViewerForm.properties}" id="result"
                               requestURI="ConfigViewer.do?methodToCall=start" defaultsort="1"
                               defaultorder="ascending">
                    <display:setProperty name="paging.banner.placement" value="both" />
                    <display:setProperty name="paging.banner.all_items_found" value="" />
                    <display:setProperty name="export.banner" value="" />
                    <display:setProperty name="basic.msg.empty_list">No Configuration Found</display:setProperty>
                    <display:column class="datacell" sortable="true"
                                    title="<div>Config Key</div>">
                        <c:out value="${result.key}" />&nbsp;
                    </display:column>
                    <display:column class="datacell" sortable="true"
                                    title="<div>Config Value</div>">
                        <c:out value="${result.value}" />&nbsp;
                    </display:column>
                </display:table>
            </td>
            <td width="20" height="20">&nbsp;</td>
        </tr>
    </table>

    </body>
</html-el:html>
