<%--

    The Kuali Financial System, a comprehensive financial management system for higher education.

    Copyright 2005-2024 Kuali, Inc.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

--%>
<%@ include file="/jsp/sys/kfsTldHeader.jsp"%>

<c:set var="roleMemberAttributes" value="${DataDictionary.KimDocumentRoleMember.attributes}" />
<c:set var="delegationMemberAttributes" value="${DataDictionary.RoleDocumentDelegationMember.attributes}" />
<c:set var="roleDocumentDelegationMemberQualifier" value="${DataDictionary.RoleDocumentDelegationMemberQualifier.attributes}" />
<c:set var="kimAttributes" value="${DataDictionary.KimAttributeImpl.attributes}" />

<%--<c:if test="${KualiForm.anchor ne '' && KualiForm.anchor ne 'topOfForm'}">
	<script type="text/javascript">
		jumpToAnchorName('<c:out value="${KualiForm.anchor}"/>');
	</script>
</c:if>	--%>
<c:if test="${!(empty KualiForm.document.delegationMembers) || canModifyAssignees}">
<kul:tab tabTitle="Delegations" defaultOpen="true" tabErrorKey="document.delegationMember*,delegationMember.*">
	<div class="tab-container" align="center">    
    <table class="standard side-margins">
        	<tr>
        		<th>&nbsp;</th> 
        		<th><div align="left"><kul:htmlAttributeLabel attributeEntry="${delegationMemberAttributes.roleMemberId}" noColon="true" /></div></th>
        		<th><div align="left"><kul:htmlAttributeLabel attributeEntry="${delegationMemberAttributes.memberTypeCode}" noColon="true" /></div></th>
        		<th><div align="left"><kul:htmlAttributeLabel attributeEntry="${delegationMemberAttributes.memberId}" noColon="true" /></div></th>
        		<th><div align="left"><kul:htmlAttributeLabel attributeEntry="${delegationMemberAttributes.memberNamespaceCode}" noColon="true" /></div></th>
        		<th><div align="left"><kul:htmlAttributeLabel attributeEntry="${delegationMemberAttributes.memberName}" noColon="true" /></div></th>
        		<th><div align="left"><kul:htmlAttributeLabel attributeEntry="${delegationMemberAttributes.activeFromDate}" noColon="true" /></div></th>
        		<th><div align="celeftnter"><kul:htmlAttributeLabel attributeEntry="${delegationMemberAttributes.activeToDate}" noColon="true" /></div></th>
				<c:forEach var="attrDefn" items="${KualiForm.document.kimType.attributeDefinitions}" varStatus="status">
        			<c:set var="fieldName" value="${attrDefn.kimAttribute.attributeName}" />
        			<c:set var="attrEntry" value="${KualiForm.document.attributeEntry[fieldName]}" />
         		    <kul:htmlAttributeHeaderCell attributeEntry="${attrEntry}" useShortLabel="false" />
		        </c:forEach>
        		<th><div align="left"><kul:htmlAttributeLabel attributeEntry="${delegationMemberAttributes.delegationTypeCode}" noColon="true" /></div></th>
				<c:if test="${!readOnlyAssignees}">	
            		<kul:htmlAttributeHeaderCell literalLabel="Actions" scope="col"/>
				</c:if>	
        	</tr>     
          <c:if test="${!readOnlyAssignees}">	
             <tr>
				<th class="infoline">
					<c:out value="Add:" />
				</th>
                <td class="infoline">   
                <div align="left">
					<!-- Combo of role members -->
					<c:if test="${KualiForm.delegationMemberRoleMemberId ne ''}" >
						<c:set var="jumpToRoleMemberAnchorName"
							   value="methodToCall.jumpToRoleMember.dmrmi${KualiForm.delegationMemberRoleMemberId}" />
			  	   		${kfunc:registerEditableProperty(KualiForm, jumpToRoleMemberAnchorName)}
						<input type="submit" tabindex="${tabindex}" name="${jumpToRoleMemberAnchorName}"
							   value="${KualiForm.delegationMember.roleMemberNamespaceCode}&nbsp;${KualiForm.delegationMember.roleMemberName}"/>
					</c:if>
	               	<kul:lookup boClassName="org.kuali.kfs.kim.bo.ui.KimDocumentRoleMember"
								fieldConversions="roleMemberId:delegationMemberRoleMemberId" anchor="${tabKey}" />
				</div>
				</td>
                <td align="left" valign="middle" class="infoline">
                <div align="left">
                	<kul:htmlControlAttribute property="delegationMember.memberTypeCode" 
                	attributeEntry="${delegationMemberAttributes.memberTypeCode}" 
                	onchange="changeDelegationMemberTypeCode(this.form)" disabled="${!canModifyAssignees}" />
					<NOSCRIPT>
                        <input type="image" tabindex="32768" name="methodToCall.changeDelegationMemberTypeCode" src="${ConfigProperties.externalizable.images.url}tinybutton-refresh.gif" class="tinybutton" title="Click to refresh the page after changing the member type." alt="Click to refresh the page after changing the member type." />
					</NOSCRIPT>
	            </div>
            	<c:set var="bo" value="${KualiForm.delegationMemberBusinessObjectName}"/>
            	<c:set var="fc" value="${KualiForm.delegationMemberFieldConversions}"/>
				</td>
                <td class="infoline">   
                <div align="left">
					<kul:htmlControlAttribute property="delegationMember.memberId" attributeEntry="${delegationMemberAttributes.memberId}" readOnly="${!canModifyAssignees}" />
					<c:if test="${!readOnlyAssignees}" >
		               	<kul:lookup boClassName="${bo}" fieldConversions="${fc}" anchor="${tabKey}" />
		            </c:if>
				</div>
				</td>
				<td class="infoline">   
                <div align="left">
                    <c:if test='${KualiForm.delegationMember.memberTypeCode == "R" || KualiForm.delegationMember.memberTypeCode == "P"}'>
                      <kul:htmlControlAttribute property="delegationMember.memberNamespaceCode" attributeEntry="${delegationMemberAttributes.memberNamespaceCode}" readOnly="true" />
                    </c:if>
                    <c:if test='${KualiForm.delegationMember.memberTypeCode == "G"}'>
                      <kul:htmlControlAttribute property="delegationMember.memberNamespaceCode" attributeEntry="${delegationMemberAttributes.memberNamespaceCode}" readOnly="${!canModifyAssignees}" />
                    </c:if>
					
				</div>
				</td>
				<td class="infoline">   
                <div align="left">
                    <c:if test='${KualiForm.delegationMember.memberTypeCode == "G" || KualiForm.delegationMember.memberTypeCode == "P"}'>
					  <kul:htmlControlAttribute property="delegationMember.memberName" attributeEntry="${delegationMemberAttributes.memberName}" readOnly="${!canModifyAssignees}" />
					  <c:if test="${!readOnlyAssignees}" >
		               	<kul:lookup boClassName="${bo}" fieldConversions="${fc}" anchor="${tabKey}" />
		              </c:if>
		            </c:if>
		            <c:if test='${KualiForm.delegationMember.memberTypeCode == "R"}'>
		              <kul:htmlControlAttribute property="delegationMember.memberName" attributeEntry="${delegationMemberAttributes.memberName}" readOnly="true" />	
		            </c:if>
				</div>
				</td>
                <td align="left" valign="middle" class="infoline">
                <div align="left">
                	<kul:htmlControlAttribute property="delegationMember.activeFromDate" attributeEntry="${delegationMemberAttributes.activeFromDate}" datePicker="true" readOnly="${!canModifyAssignees}" />
                </div>
                </td>
                <td align="left" valign="middle" class="infoline">
                <div align="left">
                	<kul:htmlControlAttribute property="delegationMember.activeToDate" attributeEntry="${delegationMemberAttributes.activeToDate}" datePicker="true" readOnly="${!canModifyAssignees}" />
                </div>
                </td>
				<c:forEach var="qualifier" items="${KualiForm.document.kimType.attributeDefinitions}" varStatus="statusQualifier">
					<c:set var="fieldName" value="${qualifier.kimAttribute.attributeName}" />
        			<c:set var="attrEntry" value="${KualiForm.document.attributeEntry[fieldName]}" />
        			<c:set var="attrDefinition" value="${KualiForm.document.definitionsKeyedByAttributeName[fieldName]}"/>
		            <td align="left" valign="middle">
		               	<div align="left"> <kul:htmlControlAttribute property="delegationMember.qualifier(${qualifier.kimAttribute.id}).attrVal"  attributeEntry="${attrEntry}" readOnly="${!canModifyAssignees}" />

							<c:if test="${attrDefinition.quickFinder != null}" >
								<c:if test="${!empty attrDefinition.quickFinder.dataObjectClass and not canModifyAssignees}">
									<kim:attributeLookup attributeDefinitions="${KualiForm.document.definitions}"
														 pathPrefix="delegationMember"
														 attr="${attrDefinition.quickFinder}" />
								</c:if>
							</c:if>
						</div>
					</td>
		        </c:forEach>
                <td align="left" valign="middle" class="infoline">
	                <div align="left">
	                	<kul:htmlControlAttribute property="delegationMember.delegationTypeCode" 
	                	attributeEntry="${delegationMemberAttributes.delegationTypeCode}" disabled="${!canModifyAssignees}" />
		            </div>
				</td>
                <td class="infoline">
					<div align=left>
						<c:choose>
				        <c:when test="${!readOnlyAssignees}">
							<html:submit property="methodToCall.addDelegationMember.anchor${tabKey}"
								   styleClass="btn btn-green" value="Add"/>
						</c:when>
						<c:otherwise>
							<html:submit property="methodToCall.addDelegationMember.anchor${tabKey}"
								   styleClass="btn btn-green" value="Add" disabled="true"/>
						</c:otherwise>
						</c:choose>
					</div>
                </td>
    	   </tr>         
		</c:if>

      	<c:forEach var="member" items="${KualiForm.document.delegationMembers}" varStatus="statusMember">
            <tr>
				<th class="infoline" valign="top">
					<c:out value="${statusMember.index+1}" />
				</th>
	            <td align="left" valign="middle">
	               	<div align="left">
						<c:out value="${member.roleMemberNamespaceCode} ${member.roleMemberName}" />
			  	</div>
				</td>
	            <td align="left" valign="middle">
	               	<div align="left"> <kul:htmlControlAttribute property="document.delegationMembers[${statusMember.index}].memberTypeCode"  attributeEntry="${delegationMemberAttributes.memberTypeCode}" readOnly="true" />
					</div>
				</td>
	            <td align="left" valign="middle">
	               	<div align="left"> <kul:htmlControlAttribute property="document.delegationMembers[${statusMember.index}].memberId"  attributeEntry="${delegationMemberAttributes.memberId}" readOnly="true" />
					</div>
				</td>
	            <td align="left" valign="middle">
	               	<div align="left"> <kul:htmlControlAttribute property="document.delegationMembers[${statusMember.index}].memberNamespaceCode"  attributeEntry="${delegationMemberAttributes.memberNamespaceCode}" readOnly="true" />
					</div>
				</td>
	            <td align="left" valign="middle">
	               	<div align="left"> <kul:htmlControlAttribute property="document.delegationMembers[${statusMember.index}].memberName"  attributeEntry="${delegationMemberAttributes.memberName}" readOnly="true" />
					</div>
				</td>
	            <td align="left" valign="middle">
	               	<div align="left"> <kul:htmlControlAttribute property="document.delegationMembers[${statusMember.index}].activeFromDate"  attributeEntry="${delegationMemberAttributes.activeFromDate}" readOnly="${!canModifyAssignees}" datePicker="true" />
					</div>
				</td>
	            <td align="left" valign="middle">
	               	<div align="left"> <kul:htmlControlAttribute property="document.delegationMembers[${statusMember.index}].activeToDate"  attributeEntry="${delegationMemberAttributes.activeToDate}" readOnly="${!canModifyAssignees}"  datePicker="true" />
					</div>
				</td>
				<c:set var="numberOfColumns" value="${KualiForm.member.numberOfQualifiers+6}"/>
				<c:forEach var="qualifier" items="${KualiForm.document.kimType.attributeDefinitions}" varStatus="statusQualifier">
					<c:set var="fieldName" value="${qualifier.kimAttribute.attributeName}" />
        			<c:set var="attrEntry" value="${KualiForm.document.attributeEntry[fieldName]}" />
        			<c:set var="attrDefinition" value="${KualiForm.document.definitionsKeyedByAttributeName[fieldName]}"/>
        			<c:set var="attrReadOnly" value="${!canModifyAssignees}"/>
		            <td align="left" valign="middle">
		               	<div align="left">
		                    <kul:htmlControlAttribute property="document.delegationMembers[${statusMember.index}].qualifier(${qualifier.kimAttribute.id}).attrVal"  attributeEntry="${attrEntry}" readOnly="${attrReadOnly}"  />
							<c:if test="${attrDefinition.quickFinder != null}" >
								<c:if test="${!empty attrDefinition.quickFinder.dataObjectClass and not readOnlyAssignees}">
									<kim:attributeLookup attributeDefinitions="${KualiForm.document.definitions}"
														 pathPrefix="document.delegationMembers[${statusMember.index}]"
														 attr="${attrDefinition.quickFinder}" />
								</c:if>
							</c:if>
						</div>
					</td>
		        </c:forEach>
	            <td align="left" valign="middle">
	               	<div align="left"> <kul:htmlControlAttribute property="document.delegationMembers[${statusMember.index}].delegationTypeCode"  attributeEntry="${delegationMemberAttributes.delegationTypeCode}" readOnly="${!canModifyAssignees}" />
					</div>
				</td>
			<c:if test="${!readOnlyAssignees}">	
				<td>
					<div align="left">&nbsp;
						<c:choose>
							<c:when test="${member.edit or readOnlyAssignees}">
								<button class='btn btn-red' disabled>Delete</button>
							</c:when>
							<c:when test="${empty member.delegationMemberId}">
								<html:submit property='methodToCall.deleteDelegationMember.line${statusMember.index}.anchor${currentTabIndex}'
											 styleClass='btn btn-red' value="Delete"/>
							</c:when>
	        	       		<c:otherwise>
	        	        		<html:submit property='methodToCall.deleteDelegationMember.line${statusMember.index}.anchor${currentTabIndex}'
								value="Inactivate" styleClass='btn btn-default'/>
		        	       	</c:otherwise>
	        	     	</c:choose>  
					</div>
				</td>
			</c:if>    
			</tr>
		</c:forEach>        
	</table>
	</div>
</kul:tab>
</c:if>
