/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.web.filter;

import java.io.PrintWriter;
import java.util.Optional;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.sys.businessobject.JwtData;
import org.kuali.kfs.sys.service.CoreApiKeyAuthenticationService;
import org.kuali.kfs.sys.service.JwtService;
import org.kuali.kfs.web.filter.ResourceLoginFilter;
import org.kuali.rice.kim.api.identity.AuthenticationService;

public class ResourceLoginFilterTest {
    private ResourceLoginFilter filter;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private HttpSession session;
    private PrintWriter writer;
    private FilterChain filterChain;
    private AuthenticationService authenticationService;
    private CoreApiKeyAuthenticationService coreApiKeyAuthenticationService;
    private JwtService jwtService;
    private boolean userSessionEstablished;

    @Before
    public void setUp() throws Exception {
        this.filter = new ResourceLoginFilter(){

            protected JwtService getJwtService() {
                return ResourceLoginFilterTest.this.jwtService;
            }

            protected CoreApiKeyAuthenticationService getCoreApiKeyAuthenticationService() {
                return ResourceLoginFilterTest.this.coreApiKeyAuthenticationService;
            }

            protected boolean isUserSessionEstablished(HttpServletRequest request) {
                return ResourceLoginFilterTest.this.userSessionEstablished;
            }

            protected void establishUserSession(HttpServletRequest request, HttpServletResponse response) {
            }

            protected void setUserSession(HttpServletRequest request, String principalName) {
            }

            protected AuthenticationService getAuthenticationService() {
                return ResourceLoginFilterTest.this.authenticationService;
            }
        };
        this.userSessionEstablished = false;
        this.request = (HttpServletRequest)EasyMock.createMock(HttpServletRequest.class);
        this.response = (HttpServletResponse)EasyMock.createMock(HttpServletResponse.class);
        this.writer = (PrintWriter)EasyMock.createMock(PrintWriter.class);
        this.session = (HttpSession)EasyMock.createMock(HttpSession.class);
        this.filterChain = (FilterChain)EasyMock.createMock(FilterChain.class);
        this.authenticationService = (AuthenticationService)EasyMock.createMock(AuthenticationService.class);
        this.coreApiKeyAuthenticationService = (CoreApiKeyAuthenticationService)EasyMock.createMock(CoreApiKeyAuthenticationService.class);
        this.jwtService = (JwtService)EasyMock.createMock(JwtService.class);
    }

    @Test
    public void testNotInSession() throws Exception {
        this.userSessionEstablished = false;
        EasyMock.expect((Object)this.request.getHeader("Authorization")).andReturn(null);
        EasyMock.expect((Object)this.authenticationService.getPrincipalName(this.request)).andReturn((Object)"username");
        this.filterChain.doFilter((ServletRequest)this.request, (ServletResponse)this.response);
        this.replayAll();
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.filterChain);
    }

    @Test
    public void testNotInSessionOrRequest() throws Exception {
        this.userSessionEstablished = false;
        EasyMock.expect((Object)this.request.getHeader("Authorization")).andReturn(null);
        EasyMock.expect((Object)this.authenticationService.getPrincipalName(this.request)).andReturn(null);
        this.expectErrorResponse();
        this.replayAll();
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.filterChain);
    }

    @Test
    public void testInSession() throws Exception {
        this.userSessionEstablished = true;
        EasyMock.expect((Object)this.request.getHeader("Authorization")).andReturn(null);
        this.filterChain.doFilter((ServletRequest)this.request, (ServletResponse)this.response);
        this.replayAll();
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.filterChain);
    }

    @Test
    public void testBlankAuthHeader() throws Exception {
        EasyMock.expect((Object)this.request.getHeader("Authorization")).andReturn((Object)"");
        this.expectErrorResponse();
        this.replayAll();
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.filterChain);
    }

    @Test
    public void testNoBearerHeader() throws Exception {
        EasyMock.expect((Object)this.request.getHeader("Authorization")).andReturn((Object)"XXX");
        this.expectErrorResponse();
        this.replayAll();
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.filterChain);
    }

    @Test
    public void testOnlyBearerHeader() throws Exception {
        EasyMock.expect((Object)this.request.getHeader("Authorization")).andReturn((Object)"Bearer");
        this.expectErrorResponse();
        this.replayAll();
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.filterChain);
    }

    @Test
    public void testBlankKeyHeader() throws Exception {
        EasyMock.expect((Object)this.request.getHeader("Authorization")).andReturn((Object)"Bearer ");
        this.expectErrorResponse();
        this.replayAll();
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.filterChain);
    }

    @Test
    public void testNonCoreBadHeader() throws Exception {
        EasyMock.expect((Object)this.request.getHeader("Authorization")).andReturn((Object)"Bearer BAD");
        EasyMock.expect((Object)this.coreApiKeyAuthenticationService.useCore()).andReturn((Object)false);
        EasyMock.expect((Object)this.jwtService.decodeJwt("BAD")).andThrow((Throwable)new RuntimeException("Error"));
        this.expectErrorResponse();
        this.replayAll();
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.filterChain);
    }

    @Test
    public void testNonCoreGoodHeader() throws Exception {
        EasyMock.expect((Object)this.request.getHeader("Authorization")).andReturn((Object)"Bearer GOOD");
        EasyMock.expect((Object)this.coreApiKeyAuthenticationService.useCore()).andReturn((Object)false);
        JwtData data = new JwtData("user", 1000);
        EasyMock.expect((Object)this.jwtService.decodeJwt("GOOD")).andReturn((Object)data);
        EasyMock.expect((Object)this.request.getSession()).andReturn((Object)this.session);
        this.filterChain.doFilter((ServletRequest)this.request, (ServletResponse)this.response);
        this.replayAll();
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.filterChain);
    }

    @Test
    public void testCoreBadHeader() throws Exception {
        EasyMock.expect((Object)this.request.getHeader("Authorization")).andReturn((Object)"Bearer BAD");
        EasyMock.expect((Object)this.coreApiKeyAuthenticationService.useCore()).andReturn((Object)true);
        EasyMock.expect((Object)this.coreApiKeyAuthenticationService.getPrincipalIdFromApiKey("BAD")).andReturn(Optional.empty());
        this.expectErrorResponse();
        this.replayAll();
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.filterChain);
    }

    @Test
    public void testCoreGoodHeader() throws Exception {
        EasyMock.expect((Object)this.request.getHeader("Authorization")).andReturn((Object)"Bearer GOOD");
        EasyMock.expect((Object)this.coreApiKeyAuthenticationService.useCore()).andReturn((Object)true);
        EasyMock.expect((Object)this.coreApiKeyAuthenticationService.getPrincipalIdFromApiKey("GOOD")).andReturn(Optional.of("user"));
        EasyMock.expect((Object)this.request.getSession()).andReturn((Object)this.session);
        this.filterChain.doFilter((ServletRequest)this.request, (ServletResponse)this.response);
        this.replayAll();
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.filterChain);
    }

    private void replayAll() {
        EasyMock.replay((Object[])new Object[]{this.request});
        EasyMock.replay((Object[])new Object[]{this.response});
        EasyMock.replay((Object[])new Object[]{this.writer});
        EasyMock.replay((Object[])new Object[]{this.session});
        EasyMock.replay((Object[])new Object[]{this.filterChain});
        EasyMock.replay((Object[])new Object[]{this.authenticationService});
        EasyMock.replay((Object[])new Object[]{this.jwtService});
        EasyMock.replay((Object[])new Object[]{this.coreApiKeyAuthenticationService});
    }

    private void expectErrorResponse() throws Exception {
        this.response.setStatus(401);
        EasyMock.expect((Object)this.response.getWriter()).andReturn((Object)this.writer);
        this.writer.println("[ \"Unauthorized\" ]");
    }
}

