<%--

    The Kuali Financial System, a comprehensive financial management system for higher education.

    Copyright 2005-2024 Kuali, Inc.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

--%>
<%@ include file="/jsp/sys/kfsTldHeader.jsp"%>
<%@ tag body-content="empty" %>
<%@ attribute name="roleIdx" required="true"
              description="In the list of roles a Person is a member of in the IdentityManagementPersonDocument, the index of the role to display qualifiers for." %>
<%@ attribute name="role" required="true" type="org.kuali.kfs.kim.bo.ui.PersonDocumentRole"
              description="Information about the displayed/maintained Person's relationship to the role displayed by this tag." %>
<c:set var="docRolePrncplAttributes" value="${DataDictionary.KimDocumentRoleMember.attributes}"/>
<c:set var="docRoleRspActionAttributes" value="${DataDictionary.KimDocumentRoleResponsibilityAction.attributes}"/>

<kul:subtab lookedUpCollectionName="roleQualifier" width="${tableWidth}" subTabTitle="Role Qualifier"
            useCurrentTabIndexAsKey="true">
  <table class="standard side-margins">
    <tr>
      <th width="5%" rowspan="20" style="border-style:none">&nbsp;</th>
      <th>&nbsp;</th>
      <c:forEach var="attrDefn" items="${role.definitions}" varStatus="status">
        <c:set var="attr" value="${attrDefn.attributeField}"/>
        <%-- AttrDefn: ${attr}<br /> --%>
        <c:set var="fieldName" value="${attr.name}"/>
        <c:set var="attrEntry" value="${role.attributeEntry[fieldName]}"/>
        <kul:htmlAttributeHeaderCell attributeEntry="${attrEntry}" useShortLabel="false"/>
      </c:forEach>
      <kim:cell isLabel="true" textAlign="center"
                attributeEntry="${docRolePrncplAttributes.activeFromDate}" noColon="true"/>
      <kim:cell isLabel="true" textAlign="center"
                attributeEntry="${docRolePrncplAttributes.activeToDate}" noColon="true"/>
      <kul:htmlAttributeHeaderCell literalLabel="Actions"/>
    </tr>
    <c:if test="${not readOnlyRole}">
      <tr>
        <th class="infoline">
          <c:out value="Add:"/>
        </th>
        <c:forEach var="attrDefn" items="${role.definitions}" varStatus="status1">
          <c:set var="attr" value="${attrDefn.attributeField}"/>
          <c:set var="fieldName" value="${attr.name}"/>
          <c:set var="attrEntry" value="${role.attributeEntry[fieldName]}"/>
          <c:set var="attrDefinition" value="${role.definitionsKeyedByAttributeName[fieldName]}"/>
          <td align="left" valign="middle">
            <div align="center">
              <kul:htmlControlAttribute
                      property="document.roles[${roleIdx}].newRolePrncpl.qualifiers[${status1.index}].attrVal"
                      attributeEntry="${attrEntry}" readOnly="${readOnlyRole}"/>
            </div>
              <%--
               Field: ${fieldName}<br />
               Attribute Definition: ${attr}<br />
               --%>
          </td>
        </c:forEach>
        <td>
          <div align="center">
            <kul:htmlControlAttribute property="document.roles[${roleIdx}].newRolePrncpl.activeFromDate"
                                      attributeEntry="${docRolePrncplAttributes.activeFromDate}" datePicker="true"
                                      readOnly="${readOnlyRole}"/>
          </div>
        </td>
        <td>
          <div align="center">
            <kul:htmlControlAttribute property="document.roles[${roleIdx}].newRolePrncpl.activeToDate"
                                      attributeEntry="${docRolePrncplAttributes.activeToDate}" datePicker="true"
                                      readOnly="${readOnlyRole}"/>
          </div>
        </td>
        <td class="infoline">
          <div align=center>
            <html:submit property="methodToCall.addRoleQualifier.line${roleIdx}.anchor${tabKey}"
                        value="Add" styleClass="btn btn-green"/>
          </div>
        </td>
      </tr>
    </c:if>
    <!-- use definitions map -->
    <c:if test="${fn:length(role.rolePrncpls) > 0}">
      <c:forEach var="rolePrncpl" items="${role.rolePrncpls}" varStatus="status1">
        <c:if test="${fn:length(rolePrncpl.qualifiers) > 0}">
          <tr>
              <%-- TODO : rowspan=2 if there is responsibilityaction only --%>
            <c:set var="rows" value="1"/>
            <c:if test="${fn:length(rolePrncpl.roleRspActions) > 0}">
              <c:set var="rows" value="2"/>

            </c:if>
            <th rowspan="${rows}" class="infoline">
              <c:out value="${status1.index+1}"/>
            </th>
            <c:forEach var="attrDefn" items="${role.definitions}" varStatus="status">
              <c:forEach var="qualifier" items="${rolePrncpl.qualifiers}" varStatus="status2">
                <c:if test="${attrDefn.attributeField.name == qualifier.kimAttribute.attributeName}">
                  <c:set var="attr" value="${attrDefn.attributeField}"/>
                  <c:set var="fieldName" value="${attr.name}"/>
                  <c:set var="attrEntry" value="${role.attributeEntry[fieldName]}"/>
                  <c:set var="attrDefinition" value="${role.definitionsKeyedByAttributeName[fieldName]}"/>
                  <c:set var="attrReadOnly" value="${readOnlyRole}"/>
                  <td align="left" valign="middle">
                    <div align="center">
                      <kul:htmlControlAttribute
                              property="document.roles[${roleIdx}].rolePrncpls[${status1.index}].qualifiers[${status.index}].attrVal"
                              attributeEntry="${attrEntry}" readOnly="true"/>


                    </div>
                  </td>
                </c:if>
              </c:forEach>
            </c:forEach>
            <kim:cell textAlign="center"
                      property="document.roles[${roleIdx}].rolePrncpls[${status1.index}].activeFromDate"
                      attributeEntry="${docRolePrncplAttributes.activeFromDate}" datePicker="true"
                      readOnly="${readOnlyRole}"/>
            <kim:cell textAlign="center"
                      property="document.roles[${roleIdx}].rolePrncpls[${status1.index}].activeToDate"
                      attributeEntry="${docRolePrncplAttributes.activeToDate}" datePicker="true"
                      readOnly="${readOnlyRole}"/>

            <td class="infoline">
              <div align=center>
                <c:if test="${!readOnlyRole}">
                    <c:choose>
                        <c:when test="${rolePrncpl.active}">
                            <c:set var="toggleLabel" value="Inactivate"/>
                        </c:when>
                        <c:otherwise>
                            <c:set var="toggleLabel" value="Activate"/>
                        </c:otherwise>
                    </c:choose>
                    <html:submit
                            property='methodToCall.toggleRoleQualifierActive.line${roleIdx}:${status1.index}.anchor${currentTabIndex}'
                            value="${toggleLabel}" styleClass='btn bth-green'/>
                </c:if>
              </div>
            </td>
          </tr>
          <c:if test="${fn:length(rolePrncpl.roleRspActions) > 0}">
            <tr>
              <td colspan="12" style="padding:0px;">
                <kim:roleResponsibilityAction roleIdx="${roleIdx}" mbrIdx="${status1.index}"/>
              </td>
            </tr>
          </c:if>
        </c:if>
      </c:forEach>
      <tr>
        <!-- need to decide colspan -->
        <td colspan="15" style="padding:0px; border-style:none; height:22px; background-color:#F6F6F6">&nbsp;</td>
      </tr>
    </c:if>
  </table>
</kul:subtab>
