<%--

    The Kuali Financial System, a comprehensive financial management system for higher education.

    Copyright 2005-2024 Kuali, Inc.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

--%>
<%@ include file="/jsp/sys/kfsTldHeader.jsp"%>

<kul:tab tabTitle="Actions Taken" defaultOpen="true">
<div class="tab-container">
  <table class="standard side-margins">
      <c:choose>
        <c:when test="${empty DocumentOperationForm.actionsTaken}">
          <tr><td class="datacell" colspan="2" align="center" height="15">None</td></tr>
        </c:when>
      <c:otherwise>
      <logic-el:iterate id="actionTaken" name="DocumentOperationForm" property="actionsTaken" indexId="ctr">
        <html-el:hidden property="actionsTaken[${ctr}].actionTakenId" />
        <html-el:hidden property="actionsTaken[${ctr}].versionNumber" />
            <tr>
              <td width="33%" class="headercell3-b-l" align="right"><b> Action Taken ID: </b><c:out value="${actionTaken.actionTakenId}" /> </td>
              <td width="66%" class="headercell3-b-l">
                <html-el:radio property="actionTakenOp[${ctr}].value" value="update"/>Update &nbsp;&nbsp;<html-el:radio property="actionTakenOp[${ctr}].value" value="delete"/>Delete&nbsp;&nbsp;<html-el:radio property="actionTakenOp[${ctr}].value" value="noop"/>No Operation&nbsp;&nbsp;
                      <html-el:hidden property="actionTakenOp[${ctr}].index" />
              </td>
            </tr>
            <tr>
              <td width="33%" align="right" class="thnormal">* Document ID:</td>
              <td width="66%" class="datacell"><html-el:text property="actionsTaken[${ctr}].documentId" /></td>
            </tr>
            <tr>
              <td width="33%" align="right" class="thnormal">* Document Version:</td>
              <td width="66%" class="datacell"><html-el:text property="actionsTaken[${ctr}].docVersion" /></td>
            </tr>
            <tr>
              <td width="33%" align="right" class="thnormal">* Action Taken:</td>
              <td width="66%" class="datacell">
                <html-el:select property="actionsTaken[${ctr}].actionTaken" value="${actionTaken.actionTaken}">
                  <c:set var="actionTakenCds" value="${DocumentOperationForm.actionTakenCds}"/>
                  <html-el:options collection="actionTakenCds" property="key" labelProperty="value"/>
                  </html-el:select>
                  <%-- <html-el:text property="actionsTaken[${ctr}].actionTaken" />--%>
              </td>
            </tr>
            <tr>
              <td width="33%" align="right" class="thnormal">* Action Date:</td>
              <td width="66%" class="datacell">
                  <html-el:text property="actionsTaken[${ctr}].actionDateString" styleId="actionsTaken${ctr}" />
                  <img
                    src="${ConfigProperties.externalizable.images.url}cal.png"
                    id="actionsTaken${ctr}_trigger"
                    style="width: 24px;"
                    align="absmiddle"
                    alt="Actions Taken Date"
                  >
                  <script type="text/javascript">
                    // This is located here because we're inside of the iterate loop and need the counter var
                    (function () {
                      Calendar.setup({
                        inputField     :    "actionsTaken${ctr}",     // id of the input field
                        ifFormat       :    "%m/%d/%Y",     // format of the input field (even if hidden, this format will be honored)
                        button         :    "actionsTaken${ctr}_trigger", // the button or image that triggers this
                        daFormat       :    "%A, %B %d, %Y",// format of the displayed date
                        singleClick    :    true,
                        timeFormat     :    "12",
                        step           :    1
                      })
                    })()
                  </script>
              </td>
            </tr>
            <tr>
              <td width="33%" align="right" class="thnormal">* Action Taken Person ID:</td>
              <td width="66%" class="datacell"><html-el:text property="actionsTaken[${ctr}].principalId" />
                  <kul:lookup boClassName="org.kuali.kfs.kim.impl.identity.Person" fieldConversions="principalId:actionsTaken[${ctr}].principalId" lookupParameters="actionsTaken[${ctr}].principalId:principalId" />
              </td>
            </tr>
            <tr>
              <td width="33%" align="right" class="thnormal">Delegator Person ID:</td>
              <td width="66%" class="datacell"><html-el:text property="actionsTaken[${ctr}].delegatorPrincipalId" />
                  <kul:lookup boClassName="org.kuali.kfs.kim.impl.identity.Person" fieldConversions="principalId:actionsTaken[${ctr}].delegatorPrincipalId" lookupParameters="actionsTaken[${ctr}].delegatorPrincipalId:principalId" />
              </td>
            </tr>
            <tr>
              <td width="33%" align="right" class="thnormal">Delegator Workgroup ID:</td>
              <td width="66%" class="datacell"><html-el:text property="actionsTaken[${ctr}].delegatorGroupId" />
                  <kul:lookup boClassName="org.kuali.kfs.kim.impl.group.Group" fieldConversions="id:actionsTaken[${ctr}].delegatorGroupId" lookupParameters="actionsTaken[${ctr}].delegatorGroupId:id" />
              </td>
            </tr>
            <tr>
              <td width="33%" align="right" class="thnormal">Current Indicator:</td>
              <td width="66%" class="datacell"><html-el:text property="actionsTaken[${ctr}].currentIndicator" /></td>
            </tr>
            <tr>
              <td width="33%" align="right" class="thnormal">Annotation:</td>
              <td width="66%" class="datacell"><html-el:textarea cols="55" rows="5" property="actionsTaken[${ctr}].annotation" /></td>
            </tr>
      </logic-el:iterate>
      </c:otherwise>
      </c:choose>
    </table>
  </div>
</kul:tab>
