<%--

    The Kuali Financial System, a comprehensive financial management system for higher education.

    Copyright 2005-2022 Kuali, Inc.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

--%>
<style type="text/css">
  select.fixed-size-200-select {
    width:200px;
   }
</style>

<%@ include file="/jsp/sys/kfsTldHeader.jsp"%>
<c:set var="personAttributes" value="${DataDictionary.Person.attributes}" />

<kul:subtab width="${tableWidth}" subTabTitle="Address" noShowHideButton="true">
    <table class="standard side-margins">
        <tr>
            <kim:cell isLabel="true" textAlign="left" attributeEntry="${personAttributes.addressTypeCode}" noColon="true" />
            <kim:cell isLabel="true" textAlign="left" attributeEntry="${personAttributes.addressLine1}" noColon="true" />
            <kim:cell isLabel="true" textAlign="left" attributeEntry="${personAttributes.addressLine2}" noColon="true" />
            <kim:cell isLabel="true" textAlign="left" attributeEntry="${personAttributes.addressLine3}" noColon="true" />
            <kim:cell isLabel="true" textAlign="left" attributeEntry="${personAttributes.addressCity}" noColon="true" />
            <kim:cell isLabel="true" textAlign="left" attributeEntry="${personAttributes.addressStateProvinceCode}" noColon="true" />
            <kim:cell isLabel="true" textAlign="left" attributeEntry="${personAttributes.addressPostalCode}" noColon="true" />
            <kim:cell isLabel="true" textAlign="left" attributeEntry="${personAttributes.addressCountryCode}" noColon="true" />
        </tr>
        <tr>
            <kim:cell valign="middle" cellClass="infoline" textAlign="left" property="document.addressTypeCode" attributeEntry="${personAttributes.addressTypeCode}" readOnly="${readOnlyEntity}" />
            <kim:cell valign="middle" cellClass="infoline" textAlign="left" property="document.addressLine1" attributeEntry="${personAttributes.addressLine1}" readOnly="${readOnlyEntity}" />
            <kim:cell valign="middle" cellClass="infoline" textAlign="left" property="document.addressLine2" attributeEntry="${personAttributes.addressLine2}" readOnly="${readOnlyEntity}" />
            <kim:cell valign="middle" cellClass="infoline" textAlign="left" property="document.addressLine3" attributeEntry="${personAttributes.addressLine3}" readOnly="${readOnlyEntity}" />
            <kim:cell valign="middle" cellClass="infoline" textAlign="left" property="document.addressCity" attributeEntry="${personAttributes.addressCity}" readOnly="${readOnlyEntity}" />
            <kim:cell valign="middle" cellClass="infoline" textAlign="left" property="document.addressStateProvinceCode" attributeEntry="${personAttributes.addressStateProvinceCode}" styleClass="fixed-size-200-select" readOnly="${readOnlyEntity}" />
            <kim:cell valign="middle" cellClass="infoline" textAlign="left" property="document.addressPostalCode" attributeEntry="${personAttributes.addressPostalCode}" readOnly="${readOnlyEntity}" />
            <kim:cell valign="middle" cellClass="infoline" textAlign="left" property="document.addressCountryCode" attributeEntry="${personAttributes.addressCountryCode}" styleClass="fixed-size-200-select" readOnly="${readOnlyEntity}" />
        </tr>
    </table>
</kul:subtab>
