<%--

    The Kuali Financial System, a comprehensive financial management system for higher education.

    Copyright 2005-2022 Kuali, Inc.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

--%>
<%@ include file="/jsp/sys/kfsTldHeader.jsp"%>
<%@ attribute name="actionRequest"
              required="true"
              type="org.kuali.kfs.kew.actionrequest.ActionRequest"
%>
<%@ attribute name="headerClass"
              required="true"
              type="java.lang.String"
%>
<c:set var="maxRoleChildrenToDisplay" value="5" />
<td align="left" class="<c:out value="${headerClass}"/>" nowrap="nowrap">
    <c:choose>
        <c:when test="${actionRequest.userRequest}">
            <kul:inquiry boClassName="org.kuali.kfs.kim.impl.identity.Person"
                         keyValues="principalId=${actionRequest.principalId}" render="true">
                <c:out value="${actionRequest.displayName}" />
            </kul:inquiry>
            &nbsp;
            <c:choose>
              <c:when test="${actionRequest.delegationType == KewApiConstants.DELEGATION_SECONDARY}">
                <bean-el:message key="routeLog.ActionRequests.actionRequest.label.secondaryDelegate"/>
              </c:when>
              <c:when test="${actionRequest.delegationType == KewApiConstants.DELEGATION_PRIMARY}">
                <bean-el:message key="routeLog.ActionRequests.actionRequest.label.primaryDelegate"/>
              </c:when>
            </c:choose>
            <kul:actionRequestImpersonationLink actionRequest="${actionRequest}" />
        </c:when>
        <c:when test="${actionRequest.groupRequest}">
            <kul:inquiry boClassName="org.kuali.kfs.kim.impl.group.Group"
                         keyValues="id=${actionRequest.groupId}"
                         render="true">
                <c:out value="${actionRequest.groupName}" />
            </kul:inquiry>
            <c:choose>
              <c:when test="${actionRequest.delegationType == KewApiConstants.DELEGATION_SECONDARY}">
                <bean-el:message key="routeLog.ActionRequests.actionRequest.label.secondaryDelegate"/>
              </c:when>
              <c:when test="${actionRequest.delegationType == KewApiConstants.DELEGATION_PRIMARY}">
                <bean-el:message key="routeLog.ActionRequests.actionRequest.label.primaryDelegate"/>
              </c:when>
            </c:choose>
        </c:when>
        <c:otherwise>
         <c:choose>
          <c:when test="${fn:length(actionRequest.childrenRequests) <= maxRoleChildrenToDisplay}">
           <c:forEach var="roleRequest" items="${actionRequest.childrenRequests}" varStatus="arStatus">
               <c:choose>
                  <c:when test="${roleRequest.primaryDelegator}">
                      <c:forEach var="primDelegateRequest"
                                 items="${roleRequest.primaryDelegateRequests}"
                                 varStatus="pDelegateArStatus">
                          <c:set var="primDelegateDisplayName" value="${primDelegateRequest.displayName}"/>
                          <c:if test="${primDelegateRequest.userRequest}">
                              <kul:inquiry boClassName="org.kuali.kfs.kim.impl.identity.Person"
                                  keyValues="principalId=${primDelegateRequest.principalId}"
                                  render="true">
                                  <c:out value="${primDelegateDisplayName}" />
                              </kul:inquiry>
                           </c:if>
                          <c:if test="${primDelegateRequest.groupRequest}">
                              <kul:inquiry boClassName="org.kuali.kfs.kim.impl.group.Group"
                                           keyValues="id=${primDelegateRequest.groupId}"
                                           render="true">
                                  <c:out value="${primDelegateRequest.groupName}" />
                              </kul:inquiry>
                          </c:if>
                          &nbsp;
                         <bean-el:message key="routeLog.ActionRequests.actionRequest.label.primaryDelegate"/>
                          <c:if test="${!empty primDelegateRequest.qualifiedRoleNameLabel}">
                            &nbsp;(<c:out value="${primDelegateRequest.qualifiedRoleNameLabel}" />)
                          </c:if>
                          <c:if test="${primDelegateRequest.userRequest}">
                              <kul:actionRequestImpersonationLink actionRequest="${primDelegateRequest}" />
                           </c:if>
                          <c:if test="${!pDelegateArStatus.last}">
                              <br />
                          </c:if>
                      </c:forEach>
                   </c:when>
                   <c:when test="${roleRequest.groupRequest}">
                      <kul:inquiry boClassName="org.kuali.kfs.kim.impl.group.Group"
                                   keyValues="id=${roleRequest.groupId}"
                                   render="true">
                          <c:out value="${roleRequest.groupName}" />
                      </kul:inquiry>
                      &nbsp;
                        <c:choose>
                          <c:when test="${roleRequest.delegationType == KewApiConstants.DELEGATION_SECONDARY}">
                            <bean-el:message key="routeLog.ActionRequests.actionRequest.label.secondaryDelegate"/>
                          </c:when>
                          <c:when test="${roleRequest.delegationType == KewApiConstants.DELEGATION_PRIMARY}">
                            <bean-el:message key="routeLog.ActionRequests.actionRequest.label.primaryDelegate"/>
                          </c:when>
                        </c:choose>
                       <c:if test="${!empty actionRequest.qualifiedRoleNameLabel}">
                           &nbsp;(<c:out value="${actionRequest.qualifiedRoleNameLabel}" />)
                       </c:if>
                       <c:if test="${!arStatus.last}"><br /></c:if>
                   </c:when>
                   <c:otherwise>
                        <kul:inquiry boClassName="org.kuali.kfs.kim.impl.identity.Person"
                                     keyValues="principalId=${roleRequest.principalId}"
                                     render="true">
                            <c:out value="${roleRequest.displayName}" />
                        </kul:inquiry>
                        &nbsp;
                        <c:choose>
                          <c:when test="${roleRequest.delegationType == KewApiConstants.DELEGATION_SECONDARY}">
                            <bean-el:message key="routeLog.ActionRequests.actionRequest.label.secondaryDelegate"/>
                          </c:when>
                          <c:when test="${roleRequest.delegationType == KewApiConstants.DELEGATION_PRIMARY}">
                            <bean-el:message key="routeLog.ActionRequests.actionRequest.label.primaryDelegate"/>
                          </c:when>
                        </c:choose>
                        <c:if test="${!empty actionRequest.qualifiedRoleNameLabel}">
                        &nbsp;(<c:out value="${actionRequest.qualifiedRoleNameLabel}" />)
                        </c:if>
                        <kul:actionRequestImpersonationLink actionRequest="${roleRequest}" />
                        <c:if test="${!arStatus.last}"><br></c:if>
                 </c:otherwise>
               </c:choose>
           </c:forEach>
          </c:when>
          <c:otherwise>
            (Multiple - expand to see details)
          </c:otherwise>
         </c:choose>
        </c:otherwise>
    </c:choose>
</td>
